/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.graph.GraphManager;
import org.apache.cayenne.reflect.ClassDescriptor;

public class ShallowMergeOperation {
    private final ObjectContext context;

    public ShallowMergeOperation(ObjectContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Persistent> T merge(T peerInParentContext) {
        GraphManager graphManager;
        if (peerInParentContext == null) {
            throw new IllegalArgumentException("Null peerInParentContext");
        }
        int peerState = peerInParentContext.getPersistenceState();
        ObjectId id = peerInParentContext.getObjectId();
        ClassDescriptor descriptor = this.context.getEntityResolver().getClassDescriptor(id.getEntityName());
        GraphManager graphManager2 = graphManager = this.context.getGraphManager();
        synchronized (graphManager2) {
            Persistent object = (Persistent)graphManager.getNode(id);
            if (object == null) {
                object = (Persistent)descriptor.createObject();
                object.setObjectContext(this.context);
                object.setObjectId(id);
                if (peerState == 5) {
                    object.setPersistenceState(5);
                } else {
                    object.setPersistenceState(3);
                }
                graphManager.registerNode(id, object);
            }
            if (peerState != 5 && object.getPersistenceState() != 4 && object.getPersistenceState() != 6) {
                descriptor.shallowMerge(peerInParentContext, object);
                if (object.getPersistenceState() == 5) {
                    object.setPersistenceState(3);
                }
            }
            return (T)object;
        }
    }
}

