/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools;

import java.io.File;
import java.net.MalformedURLException;
import org.apache.cayenne.configuration.DataMapLoader;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.resource.URLResource;

class CayenneGeneratorMapLoaderAction {
    private File mainDataMapFile;
    private File[] additionalDataMapFiles;
    private DataMap mainDataMap;
    private transient Injector injector;

    CayenneGeneratorMapLoaderAction(Injector injector) {
        this.injector = injector;
    }

    DataMap getMainDataMap() throws MalformedURLException {
        if (this.mainDataMap == null) {
            DataMapLoader loader = this.createLoader();
            DataMap mainDataMap = this.loadDataMap(loader, this.mainDataMapFile);
            if (this.additionalDataMapFiles != null) {
                EntityResolver entityResolver = new EntityResolver();
                entityResolver.addDataMap(mainDataMap);
                mainDataMap.setNamespace(entityResolver);
                for (File additionalDataMapFile : this.additionalDataMapFiles) {
                    DataMap dataMap = this.loadDataMap(loader, additionalDataMapFile);
                    entityResolver.addDataMap(dataMap);
                    dataMap.setNamespace(entityResolver);
                }
            }
            this.mainDataMap = mainDataMap;
        }
        return this.mainDataMap;
    }

    DataMapLoader createLoader() {
        return this.injector.getInstance(DataMapLoader.class);
    }

    protected DataMap loadDataMap(DataMapLoader mapLoader, File dataMapFile) throws MalformedURLException {
        return mapLoader.load(new URLResource(dataMapFile.toURI().toURL()));
    }

    void setMainDataMapFile(File mainDataMapFile) {
        this.mainDataMapFile = mainDataMapFile;
    }

    void setAdditionalDataMapFiles(File[] additionalDataMapFiles) {
        this.additionalDataMapFiles = additionalDataMapFiles;
    }
}

