/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.modeler.util.Comparators;
import org.apache.cayenne.modeler.util.EntityTreeFilter;

public class EntityTreeModel
implements TreeModel {
    protected Entity root;
    protected Map<Object, ConfigurationNode[]> sortedChildren;
    protected EntityTreeFilter filter;

    public EntityTreeModel(Entity root) {
        this.root = root;
        this.sortedChildren = new HashMap<Object, ConfigurationNode[]>();
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getChild(Object node, int index) {
        return this.sortedChildren(node)[index];
    }

    @Override
    public int getChildCount(Object node) {
        return node instanceof Attribute ? 0 : this.sortedChildren(node).length;
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    @Override
    public void valueForPathChanged(TreePath arg0, Object arg1) {
    }

    @Override
    public int getIndexOfChild(Object node, Object child) {
        if (node instanceof Attribute) {
            return -1;
        }
        return Arrays.binarySearch(this.sortedChildren(node), (ConfigurationNode)child, Comparators.getNamedObjectComparator());
    }

    @Override
    public void addTreeModelListener(TreeModelListener listener) {
    }

    @Override
    public void removeTreeModelListener(TreeModelListener listener) {
    }

    private ConfigurationNode[] sortedChildren(Object node) {
        Entity entity = this.entityForNonLeafNode(node);
        if (entity == null) {
            return new ConfigurationNode[0];
        }
        ConfigurationNode[] sortedForNode = this.sortedChildren.get(node);
        if (sortedForNode == null) {
            Collection<? extends Attribute> attributes = entity.getAttributes();
            Collection<? extends Relationship> relationships = entity.getRelationships();
            ArrayList<ConfigurationNode> nodes = new ArrayList<ConfigurationNode>();
            for (Attribute attribute : attributes) {
                if (this.filter != null && !this.filter.attributeMatch(node, attribute)) continue;
                nodes.add((ConfigurationNode)((Object)attribute));
            }
            for (Relationship relationship : relationships) {
                if (this.filter != null && !this.filter.relationshipMatch(node, relationship)) continue;
                nodes.add((ConfigurationNode)((Object)relationship));
            }
            sortedForNode = nodes.toArray(new ConfigurationNode[0]);
            Arrays.sort(sortedForNode, Comparators.getEntityChildrenComparator());
            this.sortedChildren.put(node, sortedForNode);
        }
        return sortedForNode;
    }

    public void invalidate() {
        this.sortedChildren.clear();
    }

    public void invalidateChildren(Entity entity) {
        this.sortedChildren.remove(entity);
        for (Relationship relationship : entity.getRelationships()) {
            this.sortedChildren.remove(relationship);
        }
    }

    private Entity entityForNonLeafNode(Object node) {
        if (node instanceof Entity) {
            return (Entity)node;
        }
        if (node instanceof Relationship) {
            return ((Relationship)node).getTargetEntity();
        }
        String className = node != null ? node.getClass().getName() : "null";
        throw new IllegalArgumentException("Unexpected non-leaf node: " + className);
    }

    public void setFilter(EntityTreeFilter filter) {
        this.filter = filter;
    }

    public EntityTreeFilter getFilter() {
        return this.filter;
    }
}

