/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.undo.CayenneTableModelUndoableEdit;
import org.apache.cayenne.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CayenneTableModel<T>
extends AbstractTableModel {
    protected ProjectController mediator;
    protected Object eventSource;
    protected List<T> objectList;
    private static Logger logObj = LoggerFactory.getLogger(CayenneTableModel.class);

    public CayenneTableModel(ProjectController mediator, Object eventSource, List<T> objectList) {
        this.eventSource = eventSource;
        this.mediator = mediator;
        this.objectList = objectList;
    }

    @Override
    public void setValueAt(Object newVal, int row, int col) {
        try {
            Object oldValue = this.getValueAt(row, col);
            if (!Util.nullSafeEquals(newVal, oldValue)) {
                this.setUpdatedValueAt(newVal, row, col);
                this.mediator.getApplication().getUndoManager().addEdit(new CayenneTableModelUndoableEdit(this, oldValue, newVal, row, col));
            }
        }
        catch (IllegalArgumentException e) {
            logObj.error("Error setting table model value", e);
            JOptionPane.showMessageDialog(Application.getFrame(), e.getMessage(), "Invalid value", 0);
        }
    }

    public abstract void setUpdatedValueAt(Object var1, int var2, int var3);

    public abstract Class<?> getElementsClass();

    @Override
    public int getRowCount() {
        return this.objectList.size();
    }

    public Object getEventSource() {
        return this.eventSource;
    }

    public ProjectController getMediator() {
        return this.mediator;
    }

    public List<T> getObjectList() {
        return this.objectList;
    }

    public void addRow(T row) {
        this.objectList.add(row);
        this.fireTableDataChanged();
    }

    public void removeRow(T row) {
        this.objectList.remove(row);
        this.fireTableDataChanged();
    }

    public int moveRowUp(T row) {
        int len = this.objectList.size();
        if (len < 2) {
            return -1;
        }
        int ind = this.objectList.indexOf(row);
        if (ind <= 0) {
            return -1;
        }
        int neighborIndex = ind - 1;
        this.swapRows(ind, neighborIndex);
        return neighborIndex;
    }

    public int moveRowDown(T row) {
        int len = this.objectList.size();
        if (len < 2) {
            return -1;
        }
        int ind = this.objectList.indexOf(row);
        if (ind < 0 || ind + 1 >= len) {
            return -1;
        }
        int neighborIndex = ind + 1;
        this.swapRows(ind, neighborIndex);
        return neighborIndex;
    }

    protected void swapRows(int i, int j) {
        Collections.swap(this.objectList, i, j);
        this.fireTableDataChanged();
    }

    public void resetModel() {
    }

    public boolean isValid() {
        return true;
    }

    public abstract void sortByColumn(int var1, boolean var2);

    public abstract boolean isColumnSortable(int var1);

    public void sortByElementProperty(String string, boolean isAscent) {
        Collections.sort(this.objectList, new PropertyComparator(string, this.getElementsClass()));
        if (!isAscent) {
            Collections.reverse(this.objectList);
        }
    }

    protected class PropertyComparator<C>
    implements Comparator<C> {
        Method getter;

        PropertyComparator(String propertyName, Class beanClass) {
            try {
                this.getter = this.findGetter(beanClass, propertyName);
            }
            catch (IntrospectionException e) {
                throw new CayenneRuntimeException("Introspection error", (Throwable)e, new Object[0]);
            }
        }

        Method findGetter(Class beanClass, String propertyName) throws IntrospectionException {
            PropertyDescriptor[] descriptors;
            BeanInfo info = Introspector.getBeanInfo(beanClass);
            for (PropertyDescriptor descriptor : descriptors = info.getPropertyDescriptors()) {
                if (!propertyName.equals(descriptor.getName())) continue;
                return descriptor.getReadMethod();
            }
            throw new IntrospectionException("No getter found for " + propertyName);
        }

        @Override
        public int compare(C o1, C o2) {
            if (o1 == null && o2 == null || o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            try {
                Comparable p1 = (Comparable)this.getter.invoke(o1, new Object[0]);
                Comparable p2 = (Comparable)this.getter.invoke(o2, new Object[0]);
                return p1 == null ? -1 : (p2 == null ? 1 : p1.compareTo(p2));
            }
            catch (Exception ex) {
                throw new CayenneRuntimeException("Error reading property.", (Throwable)ex, new Object[0]);
            }
        }
    }
}

