/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import java.util.Collection;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.event.DataNodeEvent;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.undo.CayenneUndoableEdit;

public class LinkDataMapsUndoableEdit
extends CayenneUndoableEdit {
    DataNodeDescriptor dataNodeDescriptor;
    Collection<String> linkedDataMaps;
    ProjectController mediator;

    @Override
    public String getPresentationName() {
        return "Link unlinked DataMaps";
    }

    public LinkDataMapsUndoableEdit(DataNodeDescriptor dataNodeDescriptor, Collection<String> linkedDataMaps, ProjectController mediator) {
        this.dataNodeDescriptor = dataNodeDescriptor;
        this.linkedDataMaps = linkedDataMaps;
        this.mediator = mediator;
    }

    @Override
    public void redo() throws CannotRedoException {
        for (DataMap dataMap : ((DataChannelDescriptor)this.mediator.getProject().getRootNode()).getDataMaps()) {
            if (this.linkedDataMaps.contains(dataMap.getName())) continue;
            this.dataNodeDescriptor.getDataMapNames().add(dataMap.getName());
            this.mediator.fireDataNodeEvent(new DataNodeEvent((Object)this, this.dataNodeDescriptor));
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        this.dataNodeDescriptor.getDataMapNames().retainAll(this.linkedDataMaps);
        this.mediator.fireDataNodeEvent(new DataNodeEvent((Object)this, this.dataNodeDescriptor));
    }
}

