/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.dbimport.tree;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JTree;
import org.apache.cayenne.dbsync.reverse.dbimport.Catalog;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.FilterContainer;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.PatternParam;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.dbsync.reverse.dbimport.Schema;
import org.apache.cayenne.dbsync.reverse.dbimport.SchemaContainer;
import org.apache.cayenne.modeler.dialog.db.load.DbImportTreeNode;
import org.apache.cayenne.modeler.editor.dbimport.DbImportTree;
import org.apache.cayenne.modeler.editor.dbimport.DbImportTreeCellRenderer;
import org.apache.cayenne.modeler.editor.dbimport.tree.CatalogNode;
import org.apache.cayenne.modeler.editor.dbimport.tree.CatalogProcedureNode;
import org.apache.cayenne.modeler.editor.dbimport.tree.CatalogTableNode;
import org.apache.cayenne.modeler.editor.dbimport.tree.ColumnNode;
import org.apache.cayenne.modeler.editor.dbimport.tree.Node;
import org.apache.cayenne.modeler.editor.dbimport.tree.ObjectType;
import org.apache.cayenne.modeler.editor.dbimport.tree.SchemaNode;
import org.apache.cayenne.modeler.editor.dbimport.tree.SchemaProcedureNode;
import org.apache.cayenne.modeler.editor.dbimport.tree.SchemaTableNode;
import org.apache.cayenne.modeler.editor.dbimport.tree.Status;
import org.apache.cayenne.modeler.editor.dbimport.tree.TableNode;

public class ColorTreeRenderer
extends DbImportTreeCellRenderer {
    private DbImportTree reverseEngineeringTree;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        if (this.node.isLabel() || this.selected) {
            this.setForeground(Color.BLACK);
            return this;
        }
        Node<?> logicalTreeNode = this.getLogicalTreeNode();
        if (logicalTreeNode == null) {
            return this;
        }
        Status status = logicalTreeNode.getStatus(this.reverseEngineeringTree.getReverseEngineering());
        ReverseEngineering mask = this.getMask();
        if (mask != null) {
            status = logicalTreeNode.getStatus(mask);
        }
        this.setForeground(status.getColor());
        return this;
    }

    private ReverseEngineering merge(ReverseEngineering config, Object object) {
        if (this.mergeAsFilterContainer(config, object)) {
            return config;
        }
        if (this.mergeAsSchemaContainer(config, object)) {
            return config;
        }
        if (object instanceof Catalog) {
            config.addCatalog((Catalog)object);
        }
        return config;
    }

    private Object merge(Catalog catalog, Object object) {
        if (this.mergeAsFilterContainer(catalog, object)) {
            return catalog;
        }
        this.mergeAsSchemaContainer(catalog, object);
        return catalog;
    }

    private Object merge(Schema schema, Object object) {
        this.mergeAsFilterContainer(schema, object);
        return schema;
    }

    private boolean mergeAsSchemaContainer(SchemaContainer container, Object object) {
        if (object instanceof Schema) {
            container.addSchema((Schema)object);
            return true;
        }
        return false;
    }

    private boolean mergeAsFilterContainer(FilterContainer container, Object object) {
        if (object instanceof IncludeTable) {
            container.addIncludeTable((IncludeTable)object);
            container.addIncludeProcedure(new IncludeProcedure("tmp include to disable include all behaviour"));
            return true;
        }
        if (object instanceof ExcludeTable) {
            container.addExcludeTable((ExcludeTable)object);
            container.addIncludeProcedure(new IncludeProcedure("tmp include to disable include all behaviour"));
            container.addIncludeTable(new IncludeTable("tmp include to disable include all behaviour"));
            return true;
        }
        if (object instanceof IncludeProcedure) {
            container.addIncludeProcedure((IncludeProcedure)object);
            return true;
        }
        if (object instanceof ExcludeProcedure) {
            container.addExcludeProcedure((ExcludeProcedure)object);
            container.addIncludeProcedure(new IncludeProcedure("tmp include to disable include all behaviour"));
            return true;
        }
        if (object instanceof IncludeColumn) {
            container.addIncludeColumn((IncludeColumn)object);
            return true;
        }
        if (object instanceof ExcludeColumn) {
            container.addExcludeColumn((ExcludeColumn)object);
            return true;
        }
        return false;
    }

    private IncludeTable merge(IncludeTable includeTable, Object object) {
        if (object instanceof IncludeColumn) {
            includeTable.addIncludeColumn((IncludeColumn)object);
        } else if (object instanceof ExcludeColumn) {
            includeTable.addExcludeColumn((ExcludeColumn)object);
            includeTable.addIncludeColumn(new IncludeColumn("tmp include to disable include all behaviour"));
        }
        return includeTable;
    }

    private Object addToMask(Object object, DbImportTreeNode node) {
        if (object == null) {
            return node.getUserObject();
        }
        String rule = this.getObjectValue(node.getUserObject());
        if (node.isCatalog()) {
            return this.merge(new Catalog(rule), object);
        }
        if (node.isSchema()) {
            return this.merge(new Schema(rule), object);
        }
        if (node.isIncludeTable()) {
            return this.merge(new IncludeTable(rule), object);
        }
        if (node.isExcludeTable()) {
            return new ExcludeTable(rule);
        }
        if (node.isIncludeColumn()) {
            return new IncludeColumn(rule);
        }
        if (node.isExcludeColumn()) {
            return new ExcludeColumn(rule);
        }
        if (node.isIncludeProcedure()) {
            return new IncludeProcedure(rule);
        }
        if (node.isExcludeProcedure()) {
            return new ExcludeProcedure(rule);
        }
        return object;
    }

    private ReverseEngineering getMask() {
        DbImportTreeNode selectedNode = this.reverseEngineeringTree.getSelectedNode();
        if (selectedNode == null) {
            return null;
        }
        if (selectedNode.isReverseEngineering()) {
            return this.reverseEngineeringTree.getReverseEngineering();
        }
        ReverseEngineering config = new ReverseEngineering();
        Object configNode = null;
        while (!selectedNode.isReverseEngineering()) {
            configNode = this.addToMask(configNode, selectedNode);
            selectedNode = selectedNode.getParent();
        }
        return this.merge(config, configNode);
    }

    private Node<?> getLogicalTreeNode() {
        ArrayList<Object> path = new ArrayList<Object>();
        for (DbImportTreeNode parent = this.node; parent != null; parent = parent.getParent()) {
            path.add(parent.getUserObject());
        }
        Collections.reverse(path);
        Node<?> logicalParent = null;
        for (Object e : path) {
            logicalParent = this.toLogicalNode(this.getObjectType(e), this.getObjectValue(e), logicalParent);
        }
        return logicalParent;
    }

    private Node<?> toLogicalNode(ObjectType type, String value, Node<?> logicalParent) {
        switch (type) {
            case CATALOG: {
                return new CatalogNode(value);
            }
            case SCHEMA: {
                return new SchemaNode(value, (CatalogNode)logicalParent);
            }
            case TABLE: {
                if (logicalParent instanceof CatalogNode) {
                    return new CatalogTableNode(value, (CatalogNode)logicalParent);
                }
                return new SchemaTableNode(value, (SchemaNode)logicalParent);
            }
            case COLUMN: {
                return new ColumnNode(value, (TableNode)logicalParent);
            }
            case PROCEDURE: {
                if (logicalParent instanceof CatalogNode) {
                    return new CatalogProcedureNode(value, (CatalogNode)logicalParent);
                }
                return new SchemaProcedureNode(value, (SchemaNode)logicalParent);
            }
        }
        return null;
    }

    private ObjectType getObjectType(Object object) {
        if (object instanceof Catalog) {
            return ObjectType.CATALOG;
        }
        if (object instanceof Schema) {
            return ObjectType.SCHEMA;
        }
        if (object instanceof IncludeTable || object instanceof ExcludeTable) {
            return ObjectType.TABLE;
        }
        if (object instanceof IncludeColumn || object instanceof ExcludeColumn) {
            return ObjectType.COLUMN;
        }
        if (object instanceof IncludeProcedure || object instanceof ExcludeProcedure) {
            return ObjectType.PROCEDURE;
        }
        return ObjectType.UNKNOWN;
    }

    private String getObjectValue(Object object) {
        if (object instanceof FilterContainer) {
            return ((FilterContainer)object).getName();
        }
        if (object instanceof PatternParam) {
            return ((PatternParam)object).getPattern();
        }
        return "";
    }

    public void setReverseEngineeringTree(DbImportTree reverseEngineeringTree) {
        this.reverseEngineeringTree = reverseEngineeringTree;
    }
}

