/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.db.gen;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.apache.cayenne.swing.components.TopBorder;

public class DBGeneratorOptionsView
extends JDialog {
    protected JTextArea sql;
    protected JButton generateButton = new JButton("Generate");
    protected JButton cancelButton;
    protected JButton saveSqlButton;
    protected JCheckBox dropTables;
    protected JCheckBox createTables;
    protected JCheckBox createFK;
    protected JCheckBox createPK;
    protected JCheckBox dropPK;
    protected Component tables;
    protected JTabbedPane tabs;
    protected JComboBox<String> adapters;

    public DBGeneratorOptionsView(Component tables) {
        this.getRootPane().setDefaultButton(this.generateButton);
        this.cancelButton = new JButton("Cancel");
        this.saveSqlButton = new JButton("Save SQL");
        this.dropTables = new JCheckBox("Drop Tables");
        this.createTables = new JCheckBox("Create Tables");
        this.createFK = new JCheckBox("Create FK Support");
        this.createPK = new JCheckBox("Create Primary Key Support");
        this.dropPK = new JCheckBox("Drop Primary Key Support");
        this.tables = tables;
        this.tabs = new JTabbedPane(1);
        this.adapters = new JComboBox();
        this.adapters.setEditable(true);
        this.sql = new JTextArea();
        this.sql.setEditable(false);
        this.sql.setLineWrap(true);
        this.sql.setWrapStyleWord(true);
        JPanel optionsPane = new JPanel(new GridLayout(3, 2));
        optionsPane.add(this.dropTables);
        optionsPane.add(this.createTables);
        optionsPane.add(new JLabel());
        optionsPane.add(this.createFK);
        optionsPane.add(this.dropPK);
        optionsPane.add(this.createPK);
        JPanel sqlTextPanel = new JPanel(new BorderLayout());
        sqlTextPanel.add((Component)new JScrollPane(this.sql, 20, 30), "Center");
        JPanel adapterPanel = new JPanel(new BorderLayout());
        adapterPanel.add(this.adapters);
        CellConstraints cc = new CellConstraints();
        PanelBuilder builder = new PanelBuilder(new FormLayout("fill:min(50dlu;pref):grow", "p, 3dlu, p, 9dlu, p, 3dlu, p, 3dlu, p, 3dlu, fill:40dlu:grow"));
        builder.addSeparator("Options", cc.xywh(1, 1, 1, 1));
        builder.add((Component)optionsPane, cc.xy(1, 3, "left,fill"));
        builder.addSeparator("Adapter", cc.xywh(1, 5, 1, 1));
        builder.add((Component)adapterPanel, cc.xy(1, 7));
        builder.addSeparator("Generated SQL", cc.xywh(1, 9, 1, 1));
        builder.add((Component)sqlTextPanel, cc.xy(1, 11));
        builder.setBorder(BorderFactory.createCompoundBorder(UIManager.getBorder("ToolBar.border"), Borders.DIALOG_BORDER));
        this.tabs.addTab("SQL Options", builder.getPanel());
        this.tabs.addTab("Tables", new JScrollPane(tables, 20, 30));
        this.tabs.setPreferredSize(new Dimension(450, 500));
        this.tabs.setFocusable(false);
        JPanel buttons = new JPanel(new FlowLayout(2));
        buttons.add(this.saveSqlButton);
        buttons.add(Box.createHorizontalStrut(20));
        buttons.add(this.cancelButton);
        buttons.add(this.generateButton);
        buttons.setBorder(TopBorder.create());
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.tabs, "Center");
        contentPane.add((Component)buttons, "South");
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public JTabbedPane getTabs() {
        return this.tabs;
    }

    public JCheckBox getCreateFK() {
        return this.createFK;
    }

    public JCheckBox getCreatePK() {
        return this.createPK;
    }

    public JCheckBox getCreateTables() {
        return this.createTables;
    }

    public JCheckBox getDropPK() {
        return this.dropPK;
    }

    public JCheckBox getDropTables() {
        return this.dropTables;
    }

    public JButton getGenerateButton() {
        return this.generateButton;
    }

    public JButton getSaveSqlButton() {
        return this.saveSqlButton;
    }

    public JTextArea getSql() {
        return this.sql;
    }

    public JComboBox<String> getAdapters() {
        return this.adapters;
    }
}

