/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.swing.components.textpane;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import org.apache.cayenne.modeler.Main;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.swing.components.textpane.EditorKit;
import org.apache.cayenne.swing.components.textpane.LineNumberedBorder;
import org.apache.cayenne.swing.components.textpane.UnderlineHighlighterForText;
import org.apache.cayenne.swing.components.textpane.syntax.SQLSyntaxConstants;
import org.apache.cayenne.swing.components.textpane.syntax.SyntaxConstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCayenneTextPane
extends JPanel {
    protected Highlighter.HighlightPainter painter;
    private JTextPaneScrollable pane;
    private JScrollPane scrollPane;
    private boolean imageError;
    private String tooltipTextError;
    private int startYPositionToolTip;
    private int endYPositionToolTip;
    private static Logger logObj = LoggerFactory.getLogger(Main.class);

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public String getTooltipTextError() {
        return this.tooltipTextError;
    }

    public void setTooltipTextError(String tooltipTextError) {
        this.tooltipTextError = tooltipTextError;
    }

    public void setText(String text) {
        this.pane.setText(text);
    }

    public String getText() {
        return this.pane.getText();
    }

    public JTextComponent getPane() {
        return this.pane;
    }

    public int getStartPositionInDocument() {
        return this.pane.viewToModel(this.scrollPane.getViewport().getViewPosition());
    }

    public int getEndPositionInDocument() {
        return this.pane.viewToModel(new Point(this.scrollPane.getViewport().getViewPosition().x + this.pane.getWidth(), this.scrollPane.getViewport().getViewPosition().y + this.pane.getHeight()));
    }

    public void repaintPane() {
        this.pane.repaint();
    }

    public int getLineNumber(int pos) {
        int y = 0;
        try {
            Rectangle caretCoords = this.pane.modelToView(pos);
            y = (int)caretCoords.getY();
        }
        catch (BadLocationException ex) {
            logObj.warn("Error: ", ex);
        }
        int lineHeight = this.pane.getFontMetrics(this.pane.getFont()).getHeight();
        int posLine = y / lineHeight + 1;
        return posLine;
    }

    public int getPosition(int line, int posInLine) throws BadLocationException {
        int position = -1;
        int numrows = 1;
        char[] chararr = this.pane.getText().toCharArray();
        for (int i = 0; i < chararr.length; ++i) {
            if (chararr[i] != '\n' || ++numrows != line) continue;
            position = i;
            break;
        }
        return position + posInLine;
    }

    public JCayenneTextPane(SyntaxConstant syntaxConstant) {
        Dimension dimension = new Dimension(15, 15);
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        this.setMinimumSize(dimension);
        this.setBorder(null);
        this.pane = new JTextPaneScrollable(new EditorKit(syntaxConstant)){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                JCayenneTextPane.this.repaint();
            }
        };
        this.pane.setFont(SQLSyntaxConstants.DEFAULT_FONT);
        this.pane.setBorder(new LineNumberedBorder(this));
        this.scrollPane = new JScrollPane(this.pane);
        this.scrollPane.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.painter = new UnderlineHighlighterForText.UnderlineHighlightPainter(Color.red);
        this.pane.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent evt) {
                try {
                    String text = JCayenneTextPane.this.pane.getText(evt.getOffset(), 1);
                    if (text.equals("/") || text.equals("*")) {
                        JCayenneTextPane.this.removeHighlightText();
                        JCayenneTextPane.this.pane.repaint();
                    } else if (text.equals(" ") || text.equals("\t") || text.equals("\n")) {
                        JCayenneTextPane.this.pane.repaint();
                    }
                }
                catch (Exception e) {
                    logObj.warn("Error: ", e);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent evt) {
            }

            @Override
            public void changedUpdate(DocumentEvent evt) {
            }
        });
    }

    public void setHighlightText(int lastIndex, int endIndex) throws BadLocationException {
        Highlighter highlighter = this.pane.getHighlighter();
        this.removeHighlightText(highlighter);
        highlighter.addHighlight(lastIndex, endIndex, this.painter);
    }

    public void setHighlightText(int line, int lastIndex, int size, String message) {
        Highlighter highlighter = this.pane.getHighlighter();
        this.removeHighlightText(highlighter);
        if (this.getText().length() > 0) {
            try {
                int position = this.getPosition(line, lastIndex);
                int positionEnd = position + size;
                highlighter.addHighlight(position, positionEnd, this.painter);
                this.setToolTipPosition(line, message);
                this.repaintPane();
            }
            catch (BadLocationException e) {
                logObj.warn("Error: ", e);
            }
        } else {
            this.setToolTipPosition(0, "");
        }
    }

    public void removeHighlightText(Highlighter highlighter) {
        Highlighter.Highlight[] highlights;
        for (Highlighter.Highlight h : highlights = highlighter.getHighlights()) {
            if (!(h.getPainter() instanceof UnderlineHighlighterForText.UnderlineHighlightPainter)) continue;
            highlighter.removeHighlight(h);
        }
    }

    public void setToolTipPosition(int line, String string) {
        if (line != 0) {
            int start;
            int height = this.pane.getFontMetrics(this.pane.getFont()).getHeight();
            this.endYPositionToolTip = start = (line - 1) * height;
            this.startYPositionToolTip = start + height;
            this.setTooltipTextError(string);
            this.imageError = !"".equals(string);
            this.setToolTipText("");
        } else {
            this.endYPositionToolTip = -1;
            this.startYPositionToolTip = -1;
            this.setTooltipTextError("");
            this.setToolTipText("");
            this.imageError = false;
        }
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        if (e.getPoint().y > this.endYPositionToolTip && e.getPoint().y < this.startYPositionToolTip && this.imageError) {
            this.setCursor(Cursor.getPredefinedCursor(12));
            String htmlText = this.getTooltipTextError().replaceAll("\n", "<br>&nbsp;").replaceAll("\t", "&nbsp;").replaceAll("\r", "<br>&nbsp;");
            return "<HTML><body bgcolor='#FFEBCD' text='black'>" + htmlText + "</body>";
        }
        this.setCursor(Cursor.getDefaultCursor());
        return null;
    }

    public void removeHighlightText() {
        this.imageError = false;
        Highlighter highlighter = this.pane.getHighlighter();
        this.removeHighlightText(highlighter);
    }

    public int getCaretPosition() {
        return this.pane.getCaretPosition();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        int start = this.getStartPositionInDocument();
        int end2 = this.getEndPositionInDocument();
        Document doc = this.pane.getDocument();
        int startline = doc.getDefaultRootElement().getElementIndex(start) + 1;
        int endline = doc.getDefaultRootElement().getElementIndex(end2) + 1;
        int fontHeight = g.getFontMetrics(this.pane.getFont()).getHeight();
        int fontDesc = g.getFontMetrics(this.pane.getFont()).getDescent();
        int starting_y = -1;
        try {
            starting_y = this.pane.modelToView(start) == null ? -1 : this.pane.modelToView((int)start).y - this.scrollPane.getViewport().getViewPosition().y + fontHeight - fontDesc;
        }
        catch (Exception e1) {
            logObj.warn("Error: ", e1);
        }
        int y = starting_y;
        for (int line = startline; line <= endline; ++line) {
            Color color = g.getColor();
            if (line - 1 == doc.getDefaultRootElement().getElementIndex(this.pane.getCaretPosition())) {
                g.setColor(new Color(224, 224, 255));
                g.fillRect(0, y - fontHeight + 3, 30, fontHeight + 1);
            }
            if (this.imageError) {
                Image img = ModelerUtil.buildIcon("icon-error.png").getImage();
                g.drawImage(img, 0, this.endYPositionToolTip, this);
            }
            g.setColor(color);
            y += fontHeight;
        }
    }

    public Document getDocument() {
        return this.pane.getDocument();
    }

    class JTextPaneScrollable
    extends JTextPane {
        JTextPaneScrollable(EditorKit editorKit) {
            this.setEditorKitForContentType(editorKit.getContentType(), editorKit);
            this.setContentType(editorKit.getContentType());
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            JViewport port;
            return this.getParent() instanceof JViewport && (port = (JViewport)this.getParent()).getWidth() > this.getUI().getPreferredSize((JComponent)this).width;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
        }
    }
}

