/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.dbentity;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.map.event.DbAttributeListener;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.ActionManager;
import org.apache.cayenne.modeler.action.CopyAttributeRelationshipAction;
import org.apache.cayenne.modeler.action.CutAttributeRelationshipAction;
import org.apache.cayenne.modeler.action.PasteAction;
import org.apache.cayenne.modeler.action.RemoveAttributeRelationshipAction;
import org.apache.cayenne.modeler.editor.dbentity.DbAttributeTableModel;
import org.apache.cayenne.modeler.editor.dbentity.DbEntityAttributeRelationshipTab;
import org.apache.cayenne.modeler.event.DbEntityDisplayListener;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.event.TablePopupHandler;
import org.apache.cayenne.modeler.pref.TableColumnPreferences;
import org.apache.cayenne.modeler.util.BoardTableCellRenderer;
import org.apache.cayenne.modeler.util.CayenneTable;
import org.apache.cayenne.modeler.util.PanelFactory;
import org.apache.cayenne.modeler.util.UIUtil;
import org.apache.cayenne.modeler.util.combo.AutoCompletion;

public class DbEntityAttributePanel
extends JPanel
implements DbEntityDisplayListener,
DbAttributeListener {
    protected ProjectController mediator;
    protected CayenneTable table;
    private TableColumnPreferences tablePreferences;
    private DbEntityAttributeRelationshipTab parentPanel;

    public DbEntityAttributePanel(ProjectController mediator, DbEntityAttributeRelationshipTab parentPanel) {
        this.mediator = mediator;
        this.parentPanel = parentPanel;
        this.initView();
        this.initController();
    }

    private void initView() {
        this.setLayout(new BorderLayout());
        ActionManager actionManager = Application.getInstance().getActionManager();
        this.table = new CayenneTable();
        this.tablePreferences = new TableColumnPreferences(DbAttributeTableModel.class, "attributeTable");
        this.table.setDefaultRenderer(String.class, new BoardTableCellRenderer());
        JPopupMenu popup = new JPopupMenu();
        popup.add(actionManager.getAction(RemoveAttributeRelationshipAction.class).buildMenu());
        popup.addSeparator();
        popup.add(actionManager.getAction(CutAttributeRelationshipAction.class).buildMenu());
        popup.add(actionManager.getAction(CopyAttributeRelationshipAction.class).buildMenu());
        popup.add(actionManager.getAction(PasteAction.class).buildMenu());
        TablePopupHandler.install(this.table, popup);
        this.add((Component)PanelFactory.createTablePanel(this.table, null), "Center");
    }

    private void initController() {
        this.mediator.addDbEntityDisplayListener(this);
        this.mediator.addDbAttributeListener(this);
        this.table.getSelectionModel().addListSelectionListener(new DbAttributeListSelectionListener());
        this.mediator.getApplication().getActionManager().setupCutCopyPaste(this.table, CutAttributeRelationshipAction.class, CopyAttributeRelationshipAction.class);
    }

    public void selectAttributes(DbAttribute[] attrs) {
        DbAttributeTableModel model = (DbAttributeTableModel)this.table.getModel();
        List listAttrs = model.getObjectList();
        int[] newSel = new int[attrs.length];
        this.parentPanel.updateActions(attrs);
        for (int i = 0; i < attrs.length; ++i) {
            newSel[i] = listAttrs.indexOf(attrs[i]);
        }
        this.table.select(newSel);
    }

    @Override
    public void dbAttributeChanged(AttributeEvent e) {
        this.table.select(e.getAttribute());
    }

    @Override
    public void dbAttributeAdded(AttributeEvent e) {
        this.rebuildTable((DbEntity)e.getEntity());
        this.table.select(e.getAttribute());
    }

    @Override
    public void dbAttributeRemoved(AttributeEvent e) {
        DbAttributeTableModel model = (DbAttributeTableModel)this.table.getModel();
        int ind = model.getObjectList().indexOf(e.getAttribute());
        model.removeRow(e.getAttribute());
        this.table.select(ind);
    }

    @Override
    public void currentDbEntityChanged(EntityDisplayEvent e) {
        DbEntity entity = (DbEntity)e.getEntity();
        if (entity != null && e.isEntityChanged()) {
            this.rebuildTable(entity);
        }
        if (e.isUnselectAttributes()) {
            this.table.clearSelection();
        }
    }

    protected void rebuildTable(DbEntity ent) {
        if (this.table.getEditingRow() != -1 && this.table.getEditingColumn() != -1) {
            TableCellEditor cellEditor = this.table.getCellEditor(this.table.getEditingRow(), this.table.getEditingColumn());
            cellEditor.stopCellEditing();
        }
        DbAttributeTableModel model = new DbAttributeTableModel(ent, this.mediator, this);
        this.table.setModel(model);
        this.table.setRowHeight(25);
        this.table.setRowMargin(3);
        TableColumn col = this.table.getColumnModel().getColumn(model.typeColumnInd());
        String[] types = TypesMapping.getDatabaseTypes();
        JComboBox<String> comboBox = Application.getWidgetFactory().createComboBox(types, true);
        comboBox.removeItem("NULL");
        AutoCompletion.enable(comboBox);
        col.setCellEditor(Application.getWidgetFactory().createCellEditor(comboBox));
        this.tablePreferences.bind(this.table, null, null, null, model.nameColumnInd(), true);
    }

    private class DbAttributeListSelectionListener
    implements ListSelectionListener {
        private DbAttributeListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            Object[] attrs = new DbAttribute[]{};
            if (!e.getValueIsAdjusting() && !((ListSelectionModel)e.getSource()).isSelectionEmpty()) {
                ((DbEntityAttributePanel)DbEntityAttributePanel.this).parentPanel.getRelationshipPanel().table.getSelectionModel().clearSelection();
                if (((DbEntityAttributePanel)DbEntityAttributePanel.this).parentPanel.getRelationshipPanel().table.getCellEditor() != null) {
                    ((DbEntityAttributePanel)DbEntityAttributePanel.this).parentPanel.getRelationshipPanel().table.getCellEditor().stopCellEditing();
                }
                Application.getInstance().getActionManager().getAction(RemoveAttributeRelationshipAction.class).setCurrentSelectedPanel(DbEntityAttributePanel.this.parentPanel.getAttributePanel());
                Application.getInstance().getActionManager().getAction(CutAttributeRelationshipAction.class).setCurrentSelectedPanel(DbEntityAttributePanel.this.parentPanel.getAttributePanel());
                Application.getInstance().getActionManager().getAction(CopyAttributeRelationshipAction.class).setCurrentSelectedPanel(DbEntityAttributePanel.this.parentPanel.getAttributePanel());
                DbEntityAttributePanel.this.parentPanel.getResolve().setEnabled(false);
                if (DbEntityAttributePanel.this.table.getSelectedRow() >= 0) {
                    DbAttributeTableModel model = (DbAttributeTableModel)DbEntityAttributePanel.this.table.getModel();
                    int[] sel = DbEntityAttributePanel.this.table.getSelectedRows();
                    attrs = new DbAttribute[sel.length];
                    for (int i = 0; i < sel.length; ++i) {
                        attrs[i] = model.getAttribute(sel[i]);
                    }
                    if (sel.length == 1) {
                        UIUtil.scrollToSelectedRow(DbEntityAttributePanel.this.table);
                    }
                }
            }
            DbEntityAttributePanel.this.mediator.setCurrentDbAttributes((DbAttribute[])attrs);
            DbEntityAttributePanel.this.parentPanel.updateActions(attrs);
        }
    }
}

