/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.event.ProcedureEvent;
import org.apache.cayenne.configuration.event.ProcedureParameterEvent;
import org.apache.cayenne.configuration.event.ProcedureParameterListener;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.ActionManager;
import org.apache.cayenne.modeler.action.CopyProcedureParameterAction;
import org.apache.cayenne.modeler.action.CreateProcedureParameterAction;
import org.apache.cayenne.modeler.action.CutProcedureParameterAction;
import org.apache.cayenne.modeler.action.PasteAction;
import org.apache.cayenne.modeler.action.RemoveProcedureParameterAction;
import org.apache.cayenne.modeler.editor.ExistingSelectionProcessor;
import org.apache.cayenne.modeler.editor.ProcedureParameterTableModel;
import org.apache.cayenne.modeler.event.ProcedureDisplayEvent;
import org.apache.cayenne.modeler.event.ProcedureDisplayListener;
import org.apache.cayenne.modeler.event.ProcedureParameterDisplayEvent;
import org.apache.cayenne.modeler.event.TablePopupHandler;
import org.apache.cayenne.modeler.pref.TableColumnPreferences;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.modeler.util.CayenneCellEditor;
import org.apache.cayenne.modeler.util.CayenneTable;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.modeler.util.PanelFactory;
import org.apache.cayenne.modeler.util.UIUtil;
import org.apache.cayenne.modeler.util.combo.AutoCompletion;
import org.apache.cayenne.swing.components.image.FilteredIconFactory;

public class ProcedureParameterTab
extends JPanel
implements ProcedureParameterListener,
ProcedureDisplayListener,
ExistingSelectionProcessor,
ActionListener {
    protected ProjectController eventController;
    protected CayenneTable table;
    protected TableColumnPreferences tablePreferences;
    protected JButton removeParameterButton;
    protected JButton moveUp;
    protected JButton moveDown;
    protected JMenuItem removeParameterMenu;
    protected JMenuItem moveUpMenu;
    protected JMenuItem moveDownMenu;

    public ProcedureParameterTab(ProjectController eventController) {
        this.eventController = eventController;
        this.init();
        eventController.addProcedureDisplayListener(this);
        eventController.addProcedureParameterListener(this);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ProcedureParameterTab.this.processExistingSelection(e);
            }
        });
        this.moveDown.addActionListener(this);
        this.moveUp.addActionListener(this);
        this.moveDownMenu.addActionListener(this);
        this.moveUpMenu.addActionListener(this);
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        ActionManager actionManager = Application.getInstance().getActionManager();
        toolBar.add(actionManager.getAction(CreateProcedureParameterAction.class).buildButton(1));
        this.removeParameterButton = actionManager.getAction(RemoveProcedureParameterAction.class).buildButton(3);
        toolBar.add(this.removeParameterButton);
        toolBar.addSeparator();
        ImageIcon up = ModelerUtil.buildIcon("icon-up.png");
        ImageIcon down = ModelerUtil.buildIcon("icon-down.png");
        this.moveUp = new CayenneAction.CayenneToolbarButton(null, 1);
        this.moveUp.setIcon(up);
        this.moveUp.setDisabledIcon(FilteredIconFactory.createDisabledIcon(up));
        this.moveUp.setToolTipText("Move Parameter Up");
        toolBar.add(this.moveUp);
        this.moveDown = new CayenneAction.CayenneToolbarButton(null, 3);
        this.moveDown.setIcon(down);
        this.moveDown.setDisabledIcon(FilteredIconFactory.createDisabledIcon(down));
        this.moveDown.setToolTipText("Move Parameter Down");
        toolBar.add(this.moveDown);
        toolBar.addSeparator();
        toolBar.add(actionManager.getAction(CutProcedureParameterAction.class).buildButton(1));
        toolBar.add(actionManager.getAction(CopyProcedureParameterAction.class).buildButton(2));
        toolBar.add(actionManager.getAction(PasteAction.class).buildButton(3));
        this.add((Component)toolBar, "North");
        this.table = new CayenneTable();
        this.tablePreferences = new TableColumnPreferences(this.getClass(), "procedure/parameterTable");
        JPopupMenu popup = new JPopupMenu();
        this.removeParameterMenu = actionManager.getAction(RemoveProcedureParameterAction.class).buildMenu();
        popup.add(this.removeParameterMenu);
        popup.addSeparator();
        this.moveUpMenu = new JMenuItem("Move Parameter Up", up);
        this.moveDownMenu = new JMenuItem("Move Parameter Down", down);
        popup.add(this.moveUpMenu);
        popup.add(this.moveDownMenu);
        popup.addSeparator();
        popup.add(actionManager.getAction(CutProcedureParameterAction.class).buildMenu());
        popup.add(actionManager.getAction(CopyProcedureParameterAction.class).buildMenu());
        popup.add(actionManager.getAction(PasteAction.class).buildMenu());
        TablePopupHandler.install(this.table, popup);
        this.add((Component)PanelFactory.createTablePanel(this.table, null), "Center");
        actionManager.setupCutCopyPaste(this.table, CutProcedureParameterAction.class, CopyProcedureParameterAction.class);
    }

    @Override
    public void processExistingSelection(EventObject e) {
        if (e instanceof ChangeEvent) {
            this.table.clearSelection();
        }
        ProcedureParameter[] parameters = new ProcedureParameter[]{};
        boolean enableUp = false;
        boolean enableDown = false;
        boolean enableRemoveButton = false;
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow >= 0) {
            enableRemoveButton = true;
            ProcedureParameterTableModel model = (ProcedureParameterTableModel)this.table.getModel();
            int[] sel = this.table.getSelectedRows();
            parameters = new ProcedureParameter[sel.length];
            for (int i = 0; i < sel.length; ++i) {
                parameters[i] = model.getParameter(sel[i]);
            }
            if (sel.length == 1) {
                UIUtil.scrollToSelectedRow(this.table);
                int rowCount = this.table.getRowCount();
                if (rowCount > 1) {
                    if (selectedRow > 0) {
                        enableUp = true;
                    }
                    if (selectedRow < rowCount - 1) {
                        enableDown = true;
                    }
                }
            }
        }
        this.removeParameterButton.setEnabled(enableRemoveButton);
        this.moveUp.setEnabled(enableUp);
        this.moveDown.setEnabled(enableDown);
        this.syncButtons();
        ProcedureParameterDisplayEvent ppde = new ProcedureParameterDisplayEvent((Object)this, parameters, this.eventController.getCurrentProcedure(), this.eventController.getCurrentDataMap(), (DataChannelDescriptor)this.eventController.getProject().getRootNode());
        this.eventController.fireProcedureParameterDisplayEvent(ppde);
    }

    @Override
    public void currentProcedureChanged(ProcedureDisplayEvent e) {
        Procedure procedure = e.getProcedure();
        if (procedure != null && e.isProcedureChanged()) {
            this.rebuildTable(procedure);
        }
    }

    public void selectParameters(ProcedureParameter[] parameters) {
        ModelerUtil.updateActions(parameters.length, RemoveProcedureParameterAction.class, CutProcedureParameterAction.class, CopyProcedureParameterAction.class);
        ProcedureParameterTableModel model = (ProcedureParameterTableModel)this.table.getModel();
        List listAttrs = model.getObjectList();
        int[] newSel = new int[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            newSel[i] = listAttrs.indexOf(parameters[i]);
        }
        this.table.select(newSel);
    }

    protected void rebuildTable(Procedure procedure) {
        ProcedureParameterTableModel model = new ProcedureParameterTableModel(procedure, this.eventController, this);
        this.table.setModel(model);
        this.table.setRowHeight(25);
        this.table.setRowMargin(3);
        TableColumn numberColumn = this.table.getColumnModel().getColumn(0);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(0);
        numberColumn.setCellRenderer(renderer);
        TableColumn typesColumn = this.table.getColumnModel().getColumn(3);
        JComboBox<String> typesEditor = Application.getWidgetFactory().createComboBox(TypesMapping.getDatabaseTypes(), true);
        AutoCompletion.enable(typesEditor);
        typesColumn.setCellEditor(Application.getWidgetFactory().createCellEditor(typesEditor));
        TableColumn directionColumn = this.table.getColumnModel().getColumn(2);
        JComboBox<String> directionEditor = Application.getWidgetFactory().createComboBox(ProcedureParameterTableModel.PARAMETER_DIRECTION_NAMES, false);
        directionEditor.setEditable(false);
        directionColumn.setCellEditor(new CayenneCellEditor((JComboBox)directionEditor));
        this.moveUp.setEnabled(false);
        this.moveDown.setEnabled(false);
        this.tablePreferences.bind(this.table, null, null, null);
    }

    @Override
    public void procedureParameterAdded(ProcedureParameterEvent e) {
        this.rebuildTable(e.getParameter().getProcedure());
        this.table.select(e.getParameter());
    }

    @Override
    public void procedureParameterChanged(ProcedureParameterEvent e) {
        this.table.select(e.getParameter());
    }

    @Override
    public void procedureParameterRemoved(ProcedureParameterEvent e) {
        ProcedureParameterTableModel model = (ProcedureParameterTableModel)this.table.getModel();
        int ind = model.getObjectList().indexOf(e.getParameter());
        model.removeRow(e.getParameter());
        this.table.select(ind);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ProcedureParameterTableModel model = (ProcedureParameterTableModel)this.table.getModel();
        ProcedureParameter parameter = model.getParameter(this.table.getSelectedRow());
        int index = -1;
        if (e.getSource() == this.moveUp || e.getSource() == this.moveUpMenu) {
            index = model.moveRowUp(parameter);
        } else if (e.getSource() == this.moveDown || e.getSource() == this.moveDownMenu) {
            index = model.moveRowDown(parameter);
        }
        if (index >= 0) {
            this.table.select(index);
            parameter.getProcedure().setCallParameters(model.getObjectList());
            this.eventController.fireProcedureEvent(new ProcedureEvent((Object)this, parameter.getProcedure(), 1));
        }
    }

    private void syncButtons() {
        this.removeParameterMenu.setEnabled(this.removeParameterButton.isEnabled());
        this.moveUpMenu.setEnabled(this.moveUp.isEnabled());
        this.moveDownMenu.setEnabled(this.moveDown.isEnabled());
    }
}

