/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.codegen;

import java.awt.Component;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.gen.ClassGenerationAction;
import org.apache.cayenne.modeler.dialog.codegen.ClientModeController;
import org.apache.cayenne.modeler.dialog.codegen.CodeGeneratorControllerBase;
import org.apache.cayenne.modeler.dialog.codegen.CustomModeController;
import org.apache.cayenne.modeler.dialog.codegen.GeneratorController;
import org.apache.cayenne.modeler.dialog.codegen.GeneratorTabPanel;
import org.apache.cayenne.modeler.dialog.codegen.StandardModeController;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.pref.CayenneProjectPreferences;
import org.apache.cayenne.pref.PreferenceDetail;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.util.Util;

public class GeneratorTabController
extends CayenneController {
    private static final String STANDARD_OBJECTS_MODE = "Standard Persistent Objects";
    private static final String CLIENT_OBJECTS_MODE = "Client Persistent Objects";
    private static final String ADVANCED_MODE = "Advanced";
    public static final String GENERATOR_PROPERTY = "generator";
    private static final String[] GENERATION_MODES = new String[]{"Standard Persistent Objects", "Client Persistent Objects", "Advanced"};
    protected GeneratorTabPanel view;
    protected Map controllers = new HashMap(5);
    protected PreferenceDetail preferences;

    public GeneratorTabController(CodeGeneratorControllerBase parent) {
        super(parent);
        this.controllers.put(STANDARD_OBJECTS_MODE, new StandardModeController(parent));
        this.controllers.put(CLIENT_OBJECTS_MODE, new ClientModeController(parent));
        this.controllers.put(ADVANCED_MODE, new CustomModeController(parent));
        Component[] modePanels = new Component[GENERATION_MODES.length];
        for (int i = 0; i < GENERATION_MODES.length; ++i) {
            modePanels[i] = ((GeneratorController)this.controllers.get(GENERATION_MODES[i])).getView();
        }
        this.view = new GeneratorTabPanel(GENERATION_MODES, modePanels);
        this.initBindings();
    }

    @Override
    public Component getView() {
        return this.view;
    }

    protected CodeGeneratorControllerBase getParentController() {
        return (CodeGeneratorControllerBase)this.getParent();
    }

    protected void initBindings() {
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        builder.bindToAction(this.view.getGenerationMode(), "updateModeAction()");
        CayenneProjectPreferences cayPrPref = this.application.getCayenneProjectPreferences();
        this.preferences = (PreferenceDetail)cayPrPref.getProjectDetailObject(PreferenceDetail.class, this.getViewPreferences().node("controller"));
        if (Util.isEmptyString(this.preferences.getProperty("mode"))) {
            this.preferences.setProperty("mode", STANDARD_OBJECTS_MODE);
        }
        builder.bindToComboSelection(this.view.getGenerationMode(), "preferences.property['mode']").updateView();
        this.updateModeAction();
    }

    public PreferenceDetail getPreferences() {
        return this.preferences;
    }

    public void updateModeAction() {
        this.firePropertyChange(GENERATOR_PROPERTY, null, this.getGeneratorController());
    }

    public GeneratorController getGeneratorController() {
        Object name = this.view.getGenerationMode().getSelectedItem();
        return (GeneratorController)this.controllers.get(name);
    }

    public Collection<ClassGenerationAction> getGenerator() {
        GeneratorController modeController = this.getGeneratorController();
        return modeController != null ? modeController.createGenerator() : null;
    }
}

