/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.filechooser.FileFilter;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.CayenneModelerFrame;
import org.apache.cayenne.modeler.ModelerPreferences;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.ExitAction;
import org.apache.cayenne.modeler.action.OpenProjectAction;
import org.apache.cayenne.modeler.dialog.validator.ValidatorDialog;
import org.apache.cayenne.modeler.editor.EditorView;
import org.apache.cayenne.modeler.init.platform.PlatformInitializer;
import org.apache.cayenne.modeler.pref.ComponentGeometry;
import org.apache.cayenne.modeler.pref.FSPath;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.modeler.util.FileFilters;
import org.apache.cayenne.modeler.util.state.ProjectStateUtil;
import org.apache.cayenne.project.Project;
import org.apache.cayenne.project.validation.ProjectValidator;
import org.apache.cayenne.validation.ValidationFailure;
import org.apache.cayenne.validation.ValidationResult;

public class CayenneModelerController
extends CayenneController {
    private static final ProjectStateUtil PROJECT_STATE_UTIL = new ProjectStateUtil();
    private ProjectController projectController;
    protected CayenneModelerFrame frame;
    private EditorView editorView;

    public CayenneModelerController() {
    }

    public CayenneModelerController(Application application) {
        super(application);
        this.frame = new CayenneModelerFrame(application.getActionManager());
        application.getInjector().getInstance(PlatformInitializer.class).setupMenus(this.frame);
        this.projectController = new ProjectController(this);
    }

    @Override
    public Component getView() {
        return this.frame;
    }

    public ProjectController getProjectController() {
        return this.projectController;
    }

    public FSPath getLastEOModelDirectory() {
        FSPath path = (FSPath)this.application.getCayenneProjectPreferences().getProjectDetailObject(FSPath.class, this.getViewPreferences().node("lastEOMDir"));
        if (path.getPath() == null) {
            path.setPath(this.getLastDirectory().getPath());
        }
        return path;
    }

    protected void initBindings() {
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PROJECT_STATE_UTIL.saveLastState(CayenneModelerController.this.projectController);
                CayenneModelerController.this.getApplication().getActionManager().getAction(ExitAction.class).exit();
            }
        });
        if (System.getProperty("os.name").startsWith("Mac OS")) {
            Runnable runner = new Runnable(){

                @Override
                public void run() {
                    PROJECT_STATE_UTIL.saveLastState(CayenneModelerController.this.projectController);
                }
            };
            Runtime.getRuntime().addShutdownHook(new Thread(runner, "Window Prefs Hook"));
        }
        new DropTarget(this.frame, new DropTargetAdapter(){

            @Override
            public void drop(DropTargetDropEvent dtde) {
                dtde.acceptDrop(dtde.getDropAction());
                Transferable transferable = dtde.getTransferable();
                dtde.dropComplete(CayenneModelerController.this.processDropAction(transferable));
            }
        });
        ComponentGeometry geometry = new ComponentGeometry(this.frame.getClass(), null);
        geometry.bind(this.frame, 1200, 720, 0);
    }

    private boolean processDropAction(Transferable transferable) {
        FileFilter filter;
        File transferFile;
        List fileList;
        try {
            fileList = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
        }
        catch (Exception e) {
            return false;
        }
        if (fileList != null && (transferFile = (File)fileList.get(0)).isFile() && (filter = FileFilters.getApplicationFilter()).accept(transferFile)) {
            ActionEvent e = new ActionEvent(transferFile, 1001, "OpenProject");
            Application.getInstance().getActionManager().getAction(OpenProjectAction.class).actionPerformed(e);
            return true;
        }
        return false;
    }

    public void startupAction() {
        this.initBindings();
        this.frame.setVisible(true);
    }

    public void projectModifiedAction() {
        String title = this.projectController.getProject().getConfigurationResource() == null ? "[New Project]" : this.projectController.getProject().getConfigurationResource().getURL().getPath();
        this.frame.setTitle("* - " + title);
    }

    public void projectSavedAction() {
        this.projectController.setDirty(false);
        this.projectController.updateProjectControllerPreferences();
        this.updateStatus("Project saved...");
        this.frame.setTitle(this.projectController.getProject().getConfigurationResource().getURL().getPath());
    }

    public void projectClosedAction() {
        PROJECT_STATE_UTIL.saveLastState(this.projectController);
        this.frame.setView(null);
        this.frame.repaint();
        this.frame.setTitle("");
        this.projectController.setProject(null);
        this.projectController.reset();
        this.application.getActionManager().projectClosed();
        this.updateStatus("Project Closed...");
    }

    public void projectOpenedAction(Project project) {
        this.projectController.setProject(project);
        this.editorView = new EditorView(this.projectController);
        this.frame.setView(this.editorView);
        this.projectController.projectOpened();
        this.application.getActionManager().projectOpened();
        if (project.getConfigurationResource() == null) {
            this.updateStatus("New project created...");
            this.frame.setTitle("[New Project]");
        } else {
            this.updateStatus("Project opened...");
            this.frame.setTitle(project.getConfigurationResource().getURL().getPath());
        }
        if (project.getConfigurationResource() != null) {
            this.getLastDirectory().setDirectory(new File(project.getConfigurationResource().getURL().getPath()));
            this.frame.fireRecentFileListChanged();
        }
        PROJECT_STATE_UTIL.fireLastState(this.projectController);
        ArrayList<ValidationFailure> allFailures = new ArrayList<ValidationFailure>();
        Collection<ValidationFailure> loadFailures = project.getConfigurationTree().getLoadFailures();
        if (!loadFailures.isEmpty()) {
            project.setModified(true);
            this.projectController.setDirty(true);
            allFailures.addAll(loadFailures);
        }
        ProjectValidator projectValidator = this.getApplication().getInjector().getInstance(ProjectValidator.class);
        ValidationResult validationResult = projectValidator.validate(project.getRootNode());
        allFailures.addAll(validationResult.getFailures());
        if (!allFailures.isEmpty()) {
            ValidatorDialog.showDialog(this.frame, validationResult.getFailures());
        }
    }

    public EditorView getEditorView() {
        return this.editorView;
    }

    public void addToLastProjListAction(File file) {
        Preferences prefLastProjFiles = ModelerPreferences.getLastProjFilesPref();
        List<File> arr = ModelerPreferences.getLastProjFiles();
        if (arr.contains(file)) {
            arr.remove(file);
        }
        arr.add(0, file);
        while (arr.size() > 12) {
            arr.remove(arr.size() - 1);
        }
        try {
            prefLastProjFiles.clear();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        int size = arr.size();
        for (int i = 0; i < size; ++i) {
            prefLastProjFiles.put(String.valueOf(i), arr.get(i).getAbsolutePath());
        }
    }

    public void updateStatus(String message) {
        this.frame.getStatus().setText(message);
        if (message != null && message.trim().length() > 0) {
            ExpireThread cleanup = new ExpireThread(message, 6);
            cleanup.start();
        }
    }

    public void changePathInLastProjListAction(File oldFile, File newFile) {
        Preferences frefLastProjFiles = ModelerPreferences.getLastProjFilesPref();
        List<File> arr = ModelerPreferences.getLastProjFiles();
        arr.remove(oldFile);
        arr.remove(newFile);
        arr.add(0, newFile);
        while (arr.size() > 12) {
            arr.remove(arr.size() - 1);
        }
        try {
            frefLastProjFiles.clear();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        int size = arr.size();
        for (int i = 0; i < size; ++i) {
            frefLastProjFiles.put(String.valueOf(i), arr.get(i).getAbsolutePath());
        }
        this.getLastDirectory().setDirectory(newFile);
        this.frame.fireRecentFileListChanged();
    }

    class ExpireThread
    extends Thread {
        int seconds;
        protected String message;

        ExpireThread(String message, int seconds) {
            this.seconds = seconds;
            this.message = message;
        }

        @Override
        public void run() {
            try {
                ExpireThread.sleep(this.seconds * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.message.equals(CayenneModelerController.this.frame.getStatus().getText())) {
                CayenneModelerController.this.updateStatus(null);
            }
        }
    }
}

