/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.gen;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.gen.Artifact;
import org.apache.cayenne.gen.ArtifactGenerationMode;
import org.apache.cayenne.gen.ArtifactsGenerationMode;
import org.apache.cayenne.gen.ClassGeneratorResourceLoader;
import org.apache.cayenne.gen.DataMapArtifact;
import org.apache.cayenne.gen.EmbeddableArtifact;
import org.apache.cayenne.gen.EntityArtifact;
import org.apache.cayenne.gen.ImportUtils;
import org.apache.cayenne.gen.StringUtils;
import org.apache.cayenne.gen.TemplateType;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.log.NullLogChute;
import org.slf4j.Logger;

public class ClassGenerationAction {
    static final String TEMPLATES_DIR_NAME = "templates/v1_2/";
    public static final String SINGLE_CLASS_TEMPLATE = "templates/v1_2/singleclass.vm";
    public static final String SUBCLASS_TEMPLATE = "templates/v1_2/subclass.vm";
    public static final String SUPERCLASS_TEMPLATE = "templates/v1_2/superclass.vm";
    public static final String EMBEDDABLE_SINGLE_CLASS_TEMPLATE = "templates/v1_2/embeddable-singleclass.vm";
    public static final String EMBEDDABLE_SUBCLASS_TEMPLATE = "templates/v1_2/embeddable-subclass.vm";
    public static final String EMBEDDABLE_SUPERCLASS_TEMPLATE = "templates/v1_2/embeddable-superclass.vm";
    public static final String DATAMAP_SINGLE_CLASS_TEMPLATE = "templates/v1_2/datamap-singleclass.vm";
    public static final String DATAMAP_SUBCLASS_TEMPLATE = "templates/v1_2/datamap-subclass.vm";
    public static final String DATAMAP_SUPERCLASS_TEMPLATE = "templates/v1_2/datamap-superclass.vm";
    public static final String SUPERCLASS_PREFIX = "_";
    private static final String WILDCARD = "*";
    protected Collection<Artifact> artifacts;
    protected String superPkg;
    protected DataMap dataMap;
    protected ArtifactsGenerationMode artifactsGenerationMode;
    protected boolean makePairs = true;
    protected Logger logger;
    protected File destDir;
    protected boolean overwrite;
    protected boolean usePkgPath = true;
    protected String template;
    protected String superTemplate;
    protected String embeddableTemplate;
    protected String embeddableSuperTemplate;
    protected String queryTemplate;
    protected String querySuperTemplate;
    protected long timestamp = System.currentTimeMillis();
    protected String outputPattern = "*.java";
    protected String encoding;
    protected boolean createPropertyNames;
    protected VelocityContext context = new VelocityContext();
    protected Map<String, Template> templateCache = new HashMap<String, Template>(5);

    public ClassGenerationAction() {
        this.artifacts = new ArrayList<Artifact>();
    }

    protected String defaultTemplateName(TemplateType type) {
        switch (type) {
            case ENTITY_SINGLE_CLASS: {
                return SINGLE_CLASS_TEMPLATE;
            }
            case ENTITY_SUBCLASS: {
                return SUBCLASS_TEMPLATE;
            }
            case ENTITY_SUPERCLASS: {
                return SUPERCLASS_TEMPLATE;
            }
            case EMBEDDABLE_SUBCLASS: {
                return EMBEDDABLE_SUBCLASS_TEMPLATE;
            }
            case EMBEDDABLE_SUPERCLASS: {
                return EMBEDDABLE_SUPERCLASS_TEMPLATE;
            }
            case EMBEDDABLE_SINGLE_CLASS: {
                return EMBEDDABLE_SINGLE_CLASS_TEMPLATE;
            }
            case DATAMAP_SINGLE_CLASS: {
                return DATAMAP_SINGLE_CLASS_TEMPLATE;
            }
            case DATAMAP_SUPERCLASS: {
                return DATAMAP_SUPERCLASS_TEMPLATE;
            }
            case DATAMAP_SUBCLASS: {
                return DATAMAP_SUBCLASS_TEMPLATE;
            }
        }
        throw new IllegalArgumentException("Invalid template type: " + (Object)((Object)type));
    }

    protected String customTemplateName(TemplateType type) {
        switch (type) {
            case ENTITY_SINGLE_CLASS: {
                return this.template;
            }
            case ENTITY_SUBCLASS: {
                return this.template;
            }
            case ENTITY_SUPERCLASS: {
                return this.superTemplate;
            }
            case EMBEDDABLE_SINGLE_CLASS: {
                return this.embeddableTemplate;
            }
            case EMBEDDABLE_SUBCLASS: {
                return this.embeddableTemplate;
            }
            case EMBEDDABLE_SUPERCLASS: {
                return this.embeddableSuperTemplate;
            }
            case DATAMAP_SINGLE_CLASS: {
                return this.queryTemplate;
            }
            case DATAMAP_SUPERCLASS: {
                return this.querySuperTemplate;
            }
            case DATAMAP_SUBCLASS: {
                return this.queryTemplate;
            }
        }
        throw new IllegalArgumentException("Invalid template type: " + (Object)((Object)type));
    }

    protected String getSuperclassPrefix() {
        return SUPERCLASS_PREFIX;
    }

    protected void resetContextForArtifact(Artifact artifact) {
        StringUtils stringUtils = StringUtils.getInstance();
        String qualifiedClassName = artifact.getQualifiedClassName();
        String packageName = stringUtils.stripClass(qualifiedClassName);
        String className = stringUtils.stripPackageName(qualifiedClassName);
        String qualifiedBaseClassName = artifact.getQualifiedBaseClassName();
        String basePackageName = stringUtils.stripClass(qualifiedBaseClassName);
        String baseClassName = stringUtils.stripPackageName(qualifiedBaseClassName);
        String superClassName = this.getSuperclassPrefix() + stringUtils.stripPackageName(qualifiedClassName);
        String superPackageName = this.superPkg;
        if (superPackageName == null) {
            superPackageName = packageName + ".auto";
        }
        this.context.put("baseClassName", baseClassName);
        this.context.put("basePackageName", basePackageName);
        this.context.put("subClassName", className);
        this.context.put("subPackageName", packageName);
        this.context.put("superClassName", superClassName);
        this.context.put("superPackageName", superPackageName);
        this.context.put("object", artifact.getObject());
        this.context.put("stringUtils", stringUtils);
        this.context.put("createPropertyNames", this.createPropertyNames);
    }

    protected void resetContextForArtifactTemplate(Artifact artifact, TemplateType templateType) {
        this.context.put("importUtils", new ImportUtils());
        artifact.postInitContext(this.context);
    }

    public void execute() throws Exception {
        this.validateAttributes();
        try {
            for (Artifact artifact : this.artifacts) {
                this.execute(artifact);
            }
        }
        finally {
            this.templateCache.clear();
        }
    }

    protected void execute(Artifact artifact) throws Exception {
        TemplateType[] templateTypes;
        this.resetContextForArtifact(artifact);
        ArtifactGenerationMode artifactMode = this.makePairs ? ArtifactGenerationMode.GENERATION_GAP : ArtifactGenerationMode.SINGLE_CLASS;
        for (TemplateType type : templateTypes = artifact.getTemplateTypes(artifactMode)) {
            try (Writer out = this.openWriter(type);){
                if (out == null) continue;
                this.resetContextForArtifactTemplate(artifact, type);
                this.getTemplate(type).merge(this.context, out);
            }
        }
    }

    protected Template getTemplate(TemplateType type) throws Exception {
        Template template;
        String templateName = this.customTemplateName(type);
        if (templateName == null) {
            templateName = this.defaultTemplateName(type);
        }
        if ((template = this.templateCache.get(templateName)) == null) {
            Properties props = new Properties();
            props.put("runtime.log.logsystem.class", NullLogChute.class.getName());
            props.put("resource.loader", "cayenne");
            props.put("cayenne.resource.loader.class", ClassGeneratorResourceLoader.class.getName());
            props.put("cayenne.resource.loader.cache", "false");
            VelocityEngine velocityEngine = new VelocityEngine();
            velocityEngine.init(props);
            template = velocityEngine.getTemplate(templateName);
            this.templateCache.put(templateName, template);
        }
        return template;
    }

    protected void validateAttributes() {
        if (this.destDir == null) {
            throw new CayenneRuntimeException("'destDir' attribute is missing.", new Object[0]);
        }
        if (!this.destDir.isDirectory()) {
            throw new CayenneRuntimeException("'destDir' is not a directory.", new Object[0]);
        }
        if (!this.destDir.canWrite()) {
            throw new CayenneRuntimeException("Do not have write permissions for %s", this.destDir);
        }
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void setOverwrite(boolean overwrite2) {
        this.overwrite = overwrite2;
    }

    public void setMakePairs(boolean makePairs) {
        this.makePairs = makePairs;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setSuperTemplate(String superTemplate) {
        this.superTemplate = superTemplate;
    }

    public void setQueryTemplate(String queryTemplate) {
        this.queryTemplate = queryTemplate;
    }

    public void setQuerySuperTemplate(String querySuperTemplate) {
        this.querySuperTemplate = querySuperTemplate;
    }

    public void setUsePkgPath(boolean usePkgPath) {
        this.usePkgPath = usePkgPath;
    }

    public void setOutputPattern(String outputPattern) {
        this.outputPattern = outputPattern;
    }

    public void setCreatePropertyNames(boolean createPropertyNames) {
        this.createPropertyNames = createPropertyNames;
    }

    protected Writer openWriter(TemplateType templateType) throws Exception {
        File outFile;
        File file = outFile = templateType.isSuperclass() ? this.fileForSuperclass() : this.fileForClass();
        if (outFile == null) {
            return null;
        }
        if (this.logger != null) {
            String label = templateType.isSuperclass() ? "superclass" : "class";
            this.logger.info("Generating " + label + " file: " + outFile.getCanonicalPath());
        }
        FileOutputStream out = new FileOutputStream(outFile);
        return this.encoding != null ? new OutputStreamWriter((OutputStream)out, this.encoding) : new OutputStreamWriter(out);
    }

    protected File fileForSuperclass() throws Exception {
        String packageName = (String)this.context.get("superPackageName");
        String className = (String)this.context.get("superClassName");
        String filename = StringUtils.getInstance().replaceWildcardInStringWithString(WILDCARD, this.outputPattern, className);
        File dest = new File(this.mkpath(this.destDir, packageName), filename);
        if (dest.exists() && !this.isOld(dest)) {
            if (this.superTemplate == null) {
                return null;
            }
            File superTemplateFile = new File(this.superTemplate);
            if (superTemplateFile.lastModified() < dest.lastModified()) {
                return null;
            }
        }
        return dest;
    }

    protected File fileForClass() throws Exception {
        String packageName = (String)this.context.get("subPackageName");
        String className = (String)this.context.get("subClassName");
        String filename = StringUtils.getInstance().replaceWildcardInStringWithString(WILDCARD, this.outputPattern, className);
        File dest = new File(this.mkpath(this.destDir, packageName), filename);
        if (dest.exists()) {
            if (this.makePairs) {
                return null;
            }
            if (!this.overwrite) {
                return null;
            }
            if (!this.isOld(dest)) {
                if (this.template == null) {
                    return null;
                }
                File templateFile = new File(this.template);
                if (templateFile.lastModified() < dest.lastModified()) {
                    return null;
                }
            }
        }
        return dest;
    }

    protected boolean isOld(File file) {
        return file.lastModified() <= this.timestamp;
    }

    protected File mkpath(File dest, String pkgName) throws Exception {
        if (!this.usePkgPath || pkgName == null) {
            return dest;
        }
        String path = pkgName.replace('.', File.separatorChar);
        File fullPath = new File(dest, path);
        if (!fullPath.isDirectory() && !fullPath.mkdirs()) {
            throw new Exception("Error making path: " + fullPath);
        }
        return fullPath;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setSuperPkg(String superPkg) {
        this.superPkg = superPkg;
    }

    public void setDataMap(DataMap dataMap) {
        this.dataMap = dataMap;
    }

    public void addEntities(Collection<ObjEntity> entities) throws CayenneException {
        if ((this.artifactsGenerationMode == ArtifactsGenerationMode.ENTITY || this.artifactsGenerationMode == ArtifactsGenerationMode.ALL) && entities != null) {
            for (ObjEntity entity : entities) {
                this.artifacts.add(new EntityArtifact(entity));
            }
        }
    }

    public void addEmbeddables(Collection<Embeddable> embeddables) {
        if ((this.artifactsGenerationMode == ArtifactsGenerationMode.ENTITY || this.artifactsGenerationMode == ArtifactsGenerationMode.ALL) && embeddables != null) {
            for (Embeddable embeddable : embeddables) {
                this.artifacts.add(new EmbeddableArtifact(embeddable));
            }
        }
    }

    public void addQueries(Collection<QueryDescriptor> queries) {
        if ((this.artifactsGenerationMode == ArtifactsGenerationMode.DATAMAP || this.artifactsGenerationMode == ArtifactsGenerationMode.ALL) && queries != null) {
            this.artifacts.add(new DataMapArtifact(this.dataMap, queries));
        }
    }

    public void setContext(VelocityContext context) {
        this.context = context;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setEmbeddableTemplate(String embeddableTemplate) {
        this.embeddableTemplate = embeddableTemplate;
    }

    public void setEmbeddableSuperTemplate(String embeddableSuperTemplate) {
        this.embeddableSuperTemplate = embeddableSuperTemplate;
    }

    public void setArtifactsGenerationMode(String mode) {
        this.artifactsGenerationMode = ArtifactsGenerationMode.ENTITY.getLabel().equalsIgnoreCase(mode) ? ArtifactsGenerationMode.ENTITY : (ArtifactsGenerationMode.DATAMAP.getLabel().equalsIgnoreCase(mode) ? ArtifactsGenerationMode.DATAMAP : ArtifactsGenerationMode.ALL);
    }
}

