/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.Fault;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.ObjectStore;
import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.graph.NodeDiff;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;
import org.apache.cayenne.util.Util;

class ObjectDiff
extends NodeDiff {
    private final String entityName;
    private transient ClassDescriptor classDescriptor;
    private Collection<NodeDiff> otherDiffs;
    private Map<String, Object> snapshot;
    private Map<String, Object> arcSnapshot;
    private Map<String, Object> currentArcSnapshot;
    private Map<ArcOperation, ArcOperation> flatIds;
    private Map<ArcOperation, ArcOperation> phantomFks;
    private Persistent object;

    ObjectDiff(final Persistent object) {
        super(object.getObjectId());
        this.object = object;
        EntityResolver entityResolver = object.getObjectContext().getEntityResolver();
        this.entityName = object.getObjectId().getEntityName();
        this.classDescriptor = entityResolver.getClassDescriptor(this.entityName);
        int state = object.getPersistenceState();
        if (state == 3 || state == 6 || state == 4) {
            final ObjEntity entity = entityResolver.getObjEntity(this.entityName);
            boolean lock = entity.getLockType() == 1;
            this.snapshot = new HashMap<String, Object>();
            this.arcSnapshot = new HashMap<String, Object>();
            this.classDescriptor.visitProperties(new PropertyVisitor(){

                @Override
                public boolean visitAttribute(AttributeProperty property) {
                    ObjectDiff.this.snapshot.put(property.getName(), property.readProperty(object));
                    return true;
                }

                @Override
                public boolean visitToMany(ToManyProperty property) {
                    return true;
                }

                @Override
                public boolean visitToOne(ToOneProperty property) {
                    Object target;
                    boolean isUsedForLocking = entity.getRelationship(property.getName()).isUsedForLocking();
                    Object object2 = target = isUsedForLocking ? property.readProperty(object) : property.readPropertyDirectly(object);
                    if (target instanceof Persistent) {
                        target = ((Persistent)target).getObjectId();
                    }
                    ObjectDiff.this.arcSnapshot.put(property.getName(), target);
                    return true;
                }
            });
        }
    }

    Object getObject() {
        return this.object;
    }

    ClassDescriptor getClassDescriptor() {
        if (this.classDescriptor == null) {
            EntityResolver entityResolver = this.object.getObjectContext().getEntityResolver();
            this.classDescriptor = entityResolver.getClassDescriptor(this.entityName);
        }
        return this.classDescriptor;
    }

    Object getSnapshotValue(String propertyName) {
        return this.snapshot != null ? this.snapshot.get(propertyName) : null;
    }

    ObjectId getArcSnapshotValue(String propertyName) {
        Object value;
        Object object = value = this.arcSnapshot != null ? this.arcSnapshot.get(propertyName) : null;
        if (value instanceof Fault) {
            Persistent target = (Persistent)((Fault)value).resolveFault(this.object, propertyName);
            value = target != null ? target.getObjectId() : null;
            this.arcSnapshot.put(propertyName, value);
        }
        return (ObjectId)value;
    }

    boolean containsArcSnapshot(String propertyName) {
        return this.arcSnapshot != null ? this.arcSnapshot.containsKey(propertyName) : false;
    }

    void appendDiffs(Collection<NodeDiff> collection) {
        if (this.otherDiffs != null) {
            collection.addAll(this.otherDiffs);
        }
        collection.add(new NodeDiff(this.nodeId, this.diffId){

            @Override
            public void apply(GraphChangeHandler tracker) {
                ObjectDiff.this.applySimplePropertyChanges(tracker);
            }

            @Override
            public void undo(GraphChangeHandler tracker) {
                throw new UnsupportedOperationException();
            }
        });
    }

    void addDiff(NodeDiff diff, ObjectStore parent) {
        boolean addDiff = true;
        if (diff instanceof ArcOperation) {
            ArcOperation arcDiff = (ArcOperation)diff;
            Object targetId = arcDiff.getTargetNodeId();
            String arcId = arcDiff.getArcId().toString();
            ArcProperty property = (ArcProperty)this.getClassDescriptor().getProperty(arcId);
            if (property == null && arcId.startsWith("db:")) {
                this.addPhantomFkDiff(arcDiff);
                addDiff = false;
            } else if (property instanceof ToManyProperty) {
                ObjRelationship relationship = property.getRelationship();
                if (relationship.isFlattened()) {
                    ArcOperation oldOp;
                    if (this.flatIds == null) {
                        this.flatIds = new HashMap<ArcOperation, ArcOperation>();
                    }
                    if ((oldOp = this.flatIds.put(arcDiff, arcDiff)) != null && oldOp.isDelete() != arcDiff.isDelete()) {
                        addDiff = false;
                        this.flatIds.remove(arcDiff);
                        if (this.otherDiffs != null) {
                            this.otherDiffs.remove(oldOp);
                        }
                    }
                } else if (property.getComplimentaryReverseArc() == null) {
                    String arc = "db:" + property.getComplimentaryReverseDbRelationshipPath();
                    ArcOperation complimentartyOp = new ArcOperation(targetId, arcDiff.getNodeId(), arc, arcDiff.isDelete());
                    parent.registerDiff(targetId, complimentartyOp);
                }
            } else if (property instanceof ToOneProperty) {
                if (this.currentArcSnapshot == null) {
                    this.currentArcSnapshot = new HashMap<String, Object>();
                }
                this.currentArcSnapshot.put(arcId, targetId);
            } else {
                String message = property == null ? "No property for arcId " + arcId : "Unrecognized property for arcId " + arcId + ": " + property;
                throw new CayenneRuntimeException(message, new Object[0]);
            }
        }
        if (addDiff) {
            if (this.otherDiffs == null) {
                this.otherDiffs = new ArrayList<NodeDiff>(3);
            }
            this.otherDiffs.add(diff);
        }
    }

    private void addPhantomFkDiff(ArcOperation arcDiff) {
        ArcOperation oldOp;
        String arcId = arcDiff.getArcId().toString();
        DbEntity dbEntity = this.classDescriptor.getEntity().getDbEntity();
        DbRelationship dbRelationship = dbEntity.getRelationship(arcId.substring("db:".length()));
        if (dbRelationship.isToMany()) {
            return;
        }
        if (this.currentArcSnapshot == null) {
            this.currentArcSnapshot = new HashMap<String, Object>();
        }
        this.currentArcSnapshot.put(arcId, arcDiff.getTargetNodeId());
        if (this.phantomFks == null) {
            this.phantomFks = new HashMap<ArcOperation, ArcOperation>();
        }
        if ((oldOp = this.phantomFks.put(arcDiff, arcDiff)) != null && oldOp.isDelete() != arcDiff.isDelete()) {
            this.phantomFks.remove(arcDiff);
            if (this.otherDiffs != null) {
                this.otherDiffs.remove(oldOp);
            }
        }
    }

    @Override
    public boolean isNoop() {
        if (this.snapshot == null) {
            return false;
        }
        if (this.flatIds != null && !this.flatIds.isEmpty()) {
            return false;
        }
        if (this.phantomFks != null && !this.phantomFks.isEmpty()) {
            return false;
        }
        int state = this.object.getPersistenceState();
        if (state == 2 || state == 6) {
            return false;
        }
        final boolean[] modFound = new boolean[1];
        this.getClassDescriptor().visitProperties(new PropertyVisitor(){

            @Override
            public boolean visitAttribute(AttributeProperty property) {
                Object newValue;
                Object oldValue = ObjectDiff.this.snapshot.get(property.getName());
                if (!Util.nullSafeEquals(oldValue, newValue = property.readProperty(ObjectDiff.this.object))) {
                    modFound[0] = true;
                }
                return !modFound[0];
            }

            @Override
            public boolean visitToMany(ToManyProperty property) {
                return true;
            }

            @Override
            public boolean visitToOne(ToOneProperty property) {
                if (ObjectDiff.this.arcSnapshot == null) {
                    return true;
                }
                Object newValue = property.readPropertyDirectly(ObjectDiff.this.object);
                if (newValue instanceof Fault) {
                    return true;
                }
                Object oldValue = ObjectDiff.this.arcSnapshot.get(property.getName());
                if (!Util.nullSafeEquals(oldValue, newValue != null ? ((Persistent)newValue).getObjectId() : null)) {
                    modFound[0] = true;
                }
                return !modFound[0];
            }
        });
        return !modFound[0];
    }

    @Override
    public void undo(GraphChangeHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void apply(GraphChangeHandler handler) {
        if (this.otherDiffs != null) {
            for (GraphDiff graphDiff : this.otherDiffs) {
                graphDiff.apply(handler);
            }
        }
        if (this.phantomFks != null) {
            for (GraphDiff graphDiff : this.phantomFks.keySet()) {
                graphDiff.apply(handler);
            }
        }
        this.applySimplePropertyChanges(handler);
    }

    private void applySimplePropertyChanges(final GraphChangeHandler handler) {
        this.getClassDescriptor().visitProperties(new PropertyVisitor(){

            @Override
            public boolean visitAttribute(AttributeProperty property) {
                Object newValue = property.readProperty(ObjectDiff.this.object);
                if (ObjectDiff.this.snapshot == null) {
                    if (newValue != null) {
                        handler.nodePropertyChanged(ObjectDiff.this.nodeId, property.getName(), null, newValue);
                    }
                } else {
                    Object oldValue = ObjectDiff.this.snapshot.get(property.getName());
                    if (!Util.nullSafeEquals(oldValue, newValue)) {
                        handler.nodePropertyChanged(ObjectDiff.this.nodeId, property.getName(), oldValue, newValue);
                    }
                }
                return true;
            }

            @Override
            public boolean visitToMany(ToManyProperty property) {
                return true;
            }

            @Override
            public boolean visitToOne(ToOneProperty property) {
                return true;
            }
        });
    }

    void updateArcSnapshot(String propertyName, Persistent object) {
        if (this.arcSnapshot == null) {
            this.arcSnapshot = new HashMap<String, Object>();
        }
        this.arcSnapshot.put(propertyName, object != null ? object.getObjectId() : null);
    }

    static final class ArcOperation
    extends NodeDiff {
        private Object targetNodeId;
        private Object arcId;
        private boolean delete;

        public ArcOperation(Object nodeId, Object targetNodeId, Object arcId, boolean delete2) {
            super(nodeId);
            this.targetNodeId = targetNodeId;
            this.arcId = arcId;
            this.delete = delete2;
        }

        boolean isDelete() {
            return this.delete;
        }

        public int hashCode() {
            return this.arcId.hashCode() + this.targetNodeId.hashCode() + 5;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof ArcOperation)) {
                return false;
            }
            ArcOperation other = (ArcOperation)object;
            return this.arcId.equals(other.arcId) && Util.nullSafeEquals(this.targetNodeId, other.targetNodeId);
        }

        @Override
        public void apply(GraphChangeHandler tracker) {
            if (this.delete) {
                tracker.arcDeleted(this.nodeId, this.targetNodeId, this.arcId);
            } else {
                tracker.arcCreated(this.nodeId, this.targetNodeId, this.arcId);
            }
        }

        @Override
        public void undo(GraphChangeHandler tracker) {
            throw new UnsupportedOperationException();
        }

        public Object getArcId() {
            return this.arcId;
        }

        public Object getTargetNodeId() {
            return this.targetNodeId;
        }
    }
}

