/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataRowStore;
import org.apache.cayenne.access.DataRowStoreFactory;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.di.DIRuntimeException;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.event.EventBridge;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.event.NoopEventBridgeProvider;

public class DefaultDataRowStoreFactory
implements DataRowStoreFactory {
    Provider<EventBridge> eventBridgeProvider;
    EventManager eventManager;
    RuntimeProperties properties;
    boolean isNoopEventBridge;

    public DefaultDataRowStoreFactory(@Inject Provider<EventBridge> eventBridgeProvider, @Inject EventManager eventManager, @Inject RuntimeProperties properties) {
        this.eventBridgeProvider = eventBridgeProvider;
        this.eventManager = eventManager;
        this.properties = properties;
        this.isNoopEventBridge = eventBridgeProvider instanceof NoopEventBridgeProvider;
    }

    @Override
    public DataRowStore createDataRowStore(String name) throws DIRuntimeException {
        DataRowStore store = new DataRowStore(name, this.properties, this.eventManager);
        this.setUpEventBridge(store);
        return store;
    }

    private void setUpEventBridge(DataRowStore store) {
        if (this.isNoopEventBridge) {
            return;
        }
        try {
            store.setEventBridge(this.eventBridgeProvider.get());
            store.startListeners();
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Error initializing DataRowStore.", (Throwable)ex, new Object[0]);
        }
    }
}

