/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.gen;

import java.util.Collection;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.gen.ArtifactsGenerationMode;
import org.apache.cayenne.gen.ClassGenerationAction;
import org.apache.cayenne.gen.ClientDataMapArtifact;
import org.apache.cayenne.gen.ClientEntityArtifact;
import org.apache.cayenne.gen.TemplateType;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.QueryDescriptor;

public class ClientClassGenerationAction
extends ClassGenerationAction {
    public static final String SUBCLASS_TEMPLATE = "templates/v1_2/client-subclass.vm";
    public static final String SUPERCLASS_TEMPLATE = "templates/v1_2/client-superclass.vm";
    public static final String SINGLE_CLASS_TEMPLATE = "templates/v1_2/client-singleclass.vm";
    public static final String DMAP_SUBCLASS_TEMPLATE = "templates/v1_2/client-datamap-subclass.vm";
    public static final String DMAP_SUPERCLASS_TEMPLATE = "templates/v1_2/client-datamap-superclass.vm";
    public static final String DMAP_SINGLE_CLASS_TEMPLATE = "templates/v1_2/client-datamap-singleclass.vm";
    public static final String CLIENT_SUPERCLASS_PREFIX = "_Client";

    @Override
    protected String defaultTemplateName(TemplateType type) {
        switch (type) {
            case ENTITY_SUBCLASS: {
                return SUBCLASS_TEMPLATE;
            }
            case ENTITY_SUPERCLASS: {
                return SUPERCLASS_TEMPLATE;
            }
            case ENTITY_SINGLE_CLASS: {
                return SINGLE_CLASS_TEMPLATE;
            }
            case EMBEDDABLE_SUBCLASS: {
                return "templates/v1_2/embeddable-subclass.vm";
            }
            case EMBEDDABLE_SUPERCLASS: {
                return "templates/v1_2/embeddable-superclass.vm";
            }
            case EMBEDDABLE_SINGLE_CLASS: {
                return "templates/v1_2/embeddable-singleclass.vm";
            }
            case DATAMAP_SUPERCLASS: {
                return DMAP_SUPERCLASS_TEMPLATE;
            }
            case DATAMAP_SUBCLASS: {
                return DMAP_SUBCLASS_TEMPLATE;
            }
            case DATAMAP_SINGLE_CLASS: {
                return DMAP_SINGLE_CLASS_TEMPLATE;
            }
        }
        throw new IllegalArgumentException("Unsupported template type: " + (Object)((Object)type));
    }

    @Override
    public void addEntities(Collection<ObjEntity> entities) throws CayenneException {
        if (!this.dataMap.isClientSupported()) {
            throw new CayenneException("Can't create client classes. Check client supported option on DataMap configuration.", new Object[0]);
        }
        if (entities != null) {
            for (ObjEntity entity : entities) {
                if (entity.isServerOnly()) continue;
                this.artifacts.add(new ClientEntityArtifact(entity));
            }
        }
    }

    @Override
    public void addQueries(Collection<QueryDescriptor> queries) {
        if ((this.artifactsGenerationMode == ArtifactsGenerationMode.DATAMAP || this.artifactsGenerationMode == ArtifactsGenerationMode.ALL) && queries != null) {
            this.artifacts.add(new ClientDataMapArtifact(this.dataMap, queries));
        }
    }
}

