/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.reader;

import java.sql.ResultSet;
import java.util.Map;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.access.jdbc.reader.RowReader;
import org.apache.cayenne.access.jdbc.reader.RowReaderFactory;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.crypto.map.ColumnMapper;
import org.apache.cayenne.crypto.transformer.MapTransformer;
import org.apache.cayenne.crypto.transformer.TransformerFactory;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.query.QueryMetadata;

public class CryptoRowReaderFactoryDecorator
implements RowReaderFactory {
    private RowReaderFactory delegate;
    private TransformerFactory transformerFactory;
    private ColumnMapper columnMapper;

    public CryptoRowReaderFactoryDecorator(@Inject RowReaderFactory delegate, @Inject TransformerFactory transformerFactory, @Inject ColumnMapper columnMapper) {
        this.delegate = delegate;
        this.transformerFactory = transformerFactory;
        this.columnMapper = columnMapper;
    }

    public RowReader<?> rowReader(final RowDescriptor descriptor, QueryMetadata queryMetadata, DbAdapter adapter, Map<ObjAttribute, ColumnDescriptor> attributeOverrides) {
        final RowReader delegateReader = this.delegate.rowReader(this.encryptedRowDescriptor(descriptor, adapter.getExtendedTypes()), queryMetadata, adapter, attributeOverrides);
        return new RowReader<Object>(){
            private boolean decryptorCompiled;
            private MapTransformer decryptor;

            private void ensureDecryptorCompiled(Object row) {
                if (!this.decryptorCompiled) {
                    this.decryptor = CryptoRowReaderFactoryDecorator.this.transformerFactory.decryptor(descriptor.getColumns(), row);
                    this.decryptorCompiled = true;
                }
            }

            public Object readRow(ResultSet resultSet) {
                Object row = delegateReader.readRow(resultSet);
                this.ensureDecryptorCompiled(row);
                if (this.decryptor != null) {
                    Map map = (Map)row;
                    this.decryptor.transform(map);
                }
                return row;
            }
        };
    }

    protected RowDescriptor encryptedRowDescriptor(RowDescriptor descriptor, ExtendedTypeMap typeMap) {
        ColumnDescriptor[] originalColumns = descriptor.getColumns();
        int len = originalColumns.length;
        ExtendedType[] originalConverters = descriptor.getConverters();
        ExtendedType[] encryptedConverters = new ExtendedType[len];
        for (int i = 0; i < len; ++i) {
            DbAttribute attribute = originalColumns[i].getAttribute();
            ExtendedType t = originalConverters[i];
            if (attribute != null && this.columnMapper.isEncrypted(attribute)) {
                if (TypesMapping.isBinary((int)attribute.getType())) {
                    t = typeMap.getRegisteredType(byte[].class);
                } else if (TypesMapping.isCharacter((int)attribute.getType())) {
                    t = typeMap.getRegisteredType(String.class);
                }
            }
            encryptedConverters[i] = t;
        }
        return new RowDescriptor(originalColumns, encryptedConverters);
    }
}

