/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import java.util.Collection;
import javax.sql.DataSource;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.configuration.CayenneRuntime;
import org.apache.cayenne.configuration.server.ServerModule;
import org.apache.cayenne.di.Module;

public class ServerRuntime
extends CayenneRuntime {
    private static Module mainModule(String ... configurationLocations) {
        return new ServerModule(configurationLocations);
    }

    public ServerRuntime(String configurationLocation, Module ... extraModules) {
        super(ServerRuntime.mergeModules(ServerRuntime.mainModule(configurationLocation), extraModules));
    }

    public ServerRuntime(String[] configurationLocations, Module ... extraModules) {
        super(ServerRuntime.mergeModules(ServerRuntime.mainModule(configurationLocations), extraModules));
    }

    public DataDomain getDataDomain() {
        return this.injector.getInstance(DataDomain.class);
    }

    public DataSource getDataSource(String dataNodeName) {
        DataDomain domain = this.getDataDomain();
        if (dataNodeName != null) {
            DataNode node = domain.getDataNode(dataNodeName);
            if (node == null) {
                throw new IllegalArgumentException("Unknown DataNode name: " + dataNodeName);
            }
            return node.getDataSource();
        }
        Collection nodes = domain.getDataNodes();
        if (nodes.size() != 1) {
            throw new IllegalArgumentException("If DataNode name is not specified, DataDomain must have exactly 1 DataNode. Actual node count: " + nodes.size());
        }
        return ((DataNode)nodes.iterator().next()).getDataSource();
    }
}

