/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.pref;

import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.cayenne.pref.CayennePreference;
import org.apache.cayenne.pref.PreferenceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RenamedPreferences
extends CayennePreference {
    private static List<Preferences> newNode;
    private static List<Preferences> oldNode;

    public RenamedPreferences(Preferences pref) {
        this.setCurrentPreference(pref);
    }

    public void copyPreferences(String newName) {
        this.setCurrentPreference(RenamedPreferences.copyPreferences(newName, this.getCurrentPreference()));
    }

    public static Preferences copyPreferences(String newName, Preferences oldPref) {
        Preferences parent = oldPref.parent();
        Preferences newPref = parent.node(newName);
        return RenamedPreferences.copyPreferences(newPref, oldPref, true);
    }

    private static ArrayList<Preferences> childrenCopy(Preferences pref, String oldPath, String newPath) {
        try {
            String[] children = pref.childrenNames();
            ArrayList<Preferences> prefChild = new ArrayList<Preferences>();
            for (int j = 0; j < children.length; ++j) {
                String child = children[j];
                Preferences childNode = pref.node(child);
                if (RenamedPreferences.equalsPath(oldNode, childNode)) continue;
                String path = childNode.absolutePath().replace(oldPath, newPath);
                String[] names = childNode.keys();
                Preferences newPref = Preferences.userRoot().node(path);
                for (int i = 0; i < names.length; ++i) {
                    newPref.put(names[i], childNode.get(names[i], ""));
                }
                prefChild.add(newPref);
            }
            return prefChild;
        }
        catch (BackingStoreException backingStoreException) {
            return null;
        }
    }

    public static void removeOldPreferences() {
        if (oldNode != null) {
            for (Preferences pref : oldNode) {
                try {
                    pref.removeNode();
                }
                catch (BackingStoreException e) {
                }
                catch (IllegalStateException illegalStateException) {}
            }
            RenamedPreferences.clearPreferences();
        }
    }

    public static void removeNewPreferences() {
        if (newNode != null) {
            for (Preferences pref : newNode) {
                try {
                    pref.removeNode();
                }
                catch (BackingStoreException e) {
                }
                catch (IllegalStateException illegalStateException) {}
            }
            RenamedPreferences.clearPreferences();
        }
    }

    public static void clearPreferences() {
        oldNode.clear();
        newNode.clear();
    }

    public static Preferences copyPreferences(Preferences newPref, Preferences oldPref, boolean addToPreferenceList) {
        try {
            String[] names = oldPref.keys();
            for (int i = 0; i < names.length; ++i) {
                newPref.put(names[i], oldPref.get(names[i], ""));
            }
            String oldPath = oldPref.absolutePath();
            String newPath = newPref.absolutePath();
            ArrayList<Preferences> childrenOldPref = RenamedPreferences.childrenCopy(oldPref, oldPath, newPath);
            while (childrenOldPref.size() > 0) {
                ArrayList<Preferences> childrenPrefTemp = new ArrayList<Preferences>();
                for (Preferences child : childrenOldPref) {
                    ArrayList<Preferences> childArray = RenamedPreferences.childrenCopy(child, oldPath, newPath);
                    childrenPrefTemp.addAll(childArray);
                }
                childrenOldPref.clear();
                childrenOldPref.addAll(childrenPrefTemp);
            }
            if (newNode == null) {
                newNode = new ArrayList<Preferences>();
            }
            if (oldNode == null) {
                oldNode = new ArrayList<Preferences>();
            }
            if (addToPreferenceList) {
                if (!RenamedPreferences.equalsPath(newNode, newPref)) {
                    newNode.add(newPref);
                }
                if (!RenamedPreferences.equalsPath(oldNode, oldPref)) {
                    oldNode.add(oldPref);
                }
            }
            return newPref;
        }
        catch (BackingStoreException e) {
            throw new PreferenceException("Error remane preferences");
        }
    }

    private static boolean equalsPath(List<Preferences> listPref, Preferences pref) {
        if (listPref != null) {
            for (Preferences next : listPref) {
                String path;
                String pathInList = next.absolutePath();
                if (!pathInList.equals(path = pref.absolutePath())) continue;
                return true;
            }
        }
        return false;
    }
}

