/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.objentity;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreePath;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.modeler.util.MultiColumnBrowser;

public class ObjRelationshipPathBrowser
extends MultiColumnBrowser {
    protected MouseListener panelOpener;
    protected ListSelectionListener panelRemover;

    public ObjRelationshipPathBrowser() {
        this(3);
    }

    public ObjRelationshipPathBrowser(int minColumns) {
        super(minColumns);
    }

    protected void installColumn(MultiColumnBrowser.BrowserPanel panel) {
        if (this.panelOpener == null) {
            this.panelOpener = new PanelOpener();
        }
        if (this.panelRemover == null) {
            this.panelRemover = new PanelRemover();
        }
        panel.addMouseListener(this.panelOpener);
        panel.addListSelectionListener(this.panelRemover);
        panel.setCellRenderer(this.renderer);
    }

    protected void selectRow(Object row, int index, TreePath path) {
        if (index > 0 && ((MultiColumnBrowser.BrowserPanel)this.columns.get(index - 1)).getSelectedValue() != row) {
            ((MultiColumnBrowser.BrowserPanel)this.columns.get(index - 1)).setSelectedValue(row, true);
        }
        if (index != path.getPathCount() - 1) {
            this.updateFromModel(row, index - 1);
        }
    }

    protected void uninstallColumn(MultiColumnBrowser.BrowserPanel panel) {
        panel.removeMouseListener(this.panelOpener);
        panel.removeListSelectionListener(this.panelRemover);
    }

    protected class PanelRemover
    implements ListSelectionListener {
        protected PanelRemover() {
        }

        public void valueChanged(ListSelectionEvent e) {
            MultiColumnBrowser.BrowserPanel panel;
            Object selectedNode;
            if (!e.getValueIsAdjusting() && (selectedNode = (panel = (MultiColumnBrowser.BrowserPanel)e.getSource()).getSelectedValue()) != null) {
                ObjRelationshipPathBrowser.this.updateFromModel(selectedNode, ObjRelationshipPathBrowser.this.columns.indexOf(panel), false);
            }
        }
    }

    protected class PanelOpener
    extends MouseAdapter {
        protected PanelOpener() {
        }

        public void mouseReleased(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                this.process(e);
            }
        }

        private void process(MouseEvent e) {
            MultiColumnBrowser.BrowserPanel panel = (MultiColumnBrowser.BrowserPanel)e.getSource();
            Object selectedNode = panel.getSelectedValue();
            if (selectedNode != null && selectedNode instanceof DbRelationship) {
                ObjRelationshipPathBrowser.this.updateFromModel(selectedNode, ObjRelationshipPathBrowser.this.columns.indexOf(panel));
            }
        }
    }
}

