/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.modeler.ClassLoadingService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileClassLoadingService
implements ClassLoadingService {
    private FileClassLoader classLoader;
    protected List<File> pathFiles = new ArrayList<File>(15);

    @Override
    public synchronized <T> Class<T> loadClass(Class<T> interfaceType, String className) throws ClassNotFoundException {
        return this.nonNullClassLoader().loadClass(className);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.nonNullClassLoader();
    }

    public synchronized List<File> getPathFiles() {
        return Collections.unmodifiableList(this.pathFiles);
    }

    public synchronized void setPathFiles(Collection<File> files) {
        this.pathFiles.clear();
        this.classLoader = null;
        for (File file : files) {
            this.addFile(file);
        }
    }

    private void addFile(File file) {
        if (this.pathFiles.contains(file = file.getAbsoluteFile())) {
            return;
        }
        if (this.classLoader != null) {
            try {
                this.classLoader.addURL(file.toURI().toURL());
            }
            catch (MalformedURLException ex) {
                return;
            }
        }
        this.pathFiles.add(file);
    }

    private synchronized FileClassLoader nonNullClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = new FileClassLoader(this.getClass().getClassLoader(), this.pathFiles);
        }
        return this.classLoader;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FileClassLoader
    extends URLClassLoader {
        FileClassLoader(ClassLoader parent) {
            super(new URL[0], parent);
        }

        FileClassLoader(ClassLoader parent, List<File> files) {
            this(parent);
            for (File file : files) {
                try {
                    this.addURL(file.toURI().toURL());
                }
                catch (MalformedURLException ex) {}
            }
        }

        @Override
        public void addURL(URL url) {
            super.addURL(url);
        }
    }
}

