/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.access.DbLoaderDelegate;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.DbRelationshipDetected;
import org.apache.cayenne.map.DetectedDbEntity;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.map.naming.BasicNamingStrategy;
import org.apache.cayenne.map.naming.ExportedKey;
import org.apache.cayenne.map.naming.NamingStrategy;
import org.apache.cayenne.util.EntityMergeSupport;
import org.apache.cayenne.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbLoader {
    private static Log logObj = LogFactory.getLog(DbLoader.class);
    private static final Collection<String> EXCLUDED_PROCEDURES = Arrays.asList("auto_pk_for_table", "auto_pk_for_table;1");
    public static final String WILDCARD = "%";
    private List<DbEntity> dbEntityList = new ArrayList<DbEntity>();
    private Set<DbEntity> skippedEntities = new HashSet<DbEntity>();
    protected Connection connection;
    protected DbAdapter adapter;
    protected DatabaseMetaData metaData;
    protected DbLoaderDelegate delegate;
    protected String genericClassName;
    protected boolean creatingMeaningfulPK;
    protected NamingStrategy namingStrategy;

    private static String uniqueRelName(Entity entity, String preferredName) {
        int currentSuffix = 1;
        String relName = preferredName;
        while (entity.getRelationship(relName) != null || entity.getAttribute(relName) != null) {
            relName = preferredName + currentSuffix;
            ++currentSuffix;
        }
        return relName;
    }

    public DbLoader(Connection connection, DbAdapter adapter, DbLoaderDelegate delegate) {
        this(connection, adapter, delegate, new BasicNamingStrategy());
    }

    public DbLoader(Connection connection, DbAdapter adapter, DbLoaderDelegate delegate, NamingStrategy strategy) {
        this.adapter = adapter;
        this.connection = connection;
        this.delegate = delegate;
        this.setNamingStrategy(strategy);
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (null == this.metaData) {
            this.metaData = this.connection.getMetaData();
        }
        return this.metaData;
    }

    public void setCreatingMeaningfulPK(boolean check) {
        this.creatingMeaningfulPK = check;
    }

    public boolean isCreatingMeaningfulPK() {
        return this.creatingMeaningfulPK;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getGenericClassName() {
        return this.genericClassName;
    }

    public void setGenericClassName(String genericClassName) {
        this.genericClassName = genericClassName;
    }

    public DbAdapter getAdapter() {
        return this.adapter;
    }

    public boolean includeTableName(String tableName) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCatalogs() throws SQLException {
        ArrayList<String> catalogs = new ArrayList<String>();
        ResultSet rs = this.getMetaData().getCatalogs();
        try {
            while (rs.next()) {
                String catalog_name = rs.getString(1);
                catalogs.add(catalog_name);
            }
        }
        finally {
            rs.close();
        }
        return catalogs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSchemas() throws SQLException {
        ArrayList<String> schemas = new ArrayList<String>();
        ResultSet rs = this.getMetaData().getSchemas();
        try {
            while (rs.next()) {
                String schema_name = rs.getString(1);
                schemas.add(schema_name);
            }
        }
        finally {
            rs.close();
        }
        return schemas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTableTypes() throws SQLException {
        ArrayList<String> types = new ArrayList<String>();
        ResultSet rs = this.getMetaData().getTableTypes();
        try {
            while (rs.next()) {
                types.add(rs.getString("TABLE_TYPE").trim());
            }
        }
        finally {
            rs.close();
        }
        return types;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DbEntity> getTables(String catalogPattern, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        ArrayList<DbEntity> tables = new ArrayList<DbEntity>();
        if (logObj.isDebugEnabled()) {
            logObj.debug("Read tables: catalog=" + catalogPattern + ", schema=" + schemaPattern + ", tableNames=" + tableNamePattern);
            if (types != null && types.length > 0) {
                for (String type : types) {
                    logObj.debug("Read tables: table type=" + type);
                }
            }
        }
        ResultSet rs = this.getMetaData().getTables(catalogPattern, schemaPattern, tableNamePattern, types);
        try {
            while (rs.next()) {
                String catalog = rs.getString("TABLE_CAT");
                String schema = rs.getString("TABLE_SCHEM");
                String name = rs.getString("TABLE_NAME");
                if (name == null || name.startsWith("BIN$") || !this.includeTableName(name)) continue;
                DetectedDbEntity table = new DetectedDbEntity(name);
                table.setCatalog(catalog);
                table.setSchema(schema);
                tables.add(table);
            }
        }
        finally {
            rs.close();
        }
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadDbEntities(DataMap map, List<? extends DbEntity> tables) throws SQLException {
        ResultSet rs;
        this.dbEntityList = new ArrayList<DbEntity>();
        for (DbEntity dbEntity : tables) {
            block21: {
                DbEntity oldEnt = map.getDbEntity(dbEntity.getName());
                if (oldEnt != null) {
                    if (this.delegate == null) break;
                    try {
                        if (this.delegate.overwriteDbEntity(oldEnt)) {
                            logObj.debug("Overwrite: " + oldEnt.getName());
                            map.removeDbEntity(oldEnt.getName(), true);
                            this.delegate.dbEntityRemoved(oldEnt);
                            break block21;
                        }
                        logObj.debug("Keep old: " + oldEnt.getName());
                        this.skippedEntities.add(oldEnt);
                        continue;
                    }
                    catch (CayenneException ex) {
                        logObj.debug("Load canceled.");
                        return false;
                    }
                }
            }
            rs = this.getMetaData().getColumns(dbEntity.getCatalog(), dbEntity.getSchema(), dbEntity.getName(), WILDCARD);
            try {
                while (rs.next()) {
                    String tableName = rs.getString("TABLE_NAME");
                    if (!dbEntity.getName().equals(tableName)) {
                        logObj.info("Incorrectly returned columns for '" + tableName + ", skipping.");
                        continue;
                    }
                    String columnName = rs.getString("COLUMN_NAME");
                    boolean allowNulls = rs.getBoolean("NULLABLE");
                    int columnType = rs.getInt("DATA_TYPE");
                    int columnSize = rs.getInt("COLUMN_SIZE");
                    String typeName = rs.getString("TYPE_NAME");
                    int decimalDigits = -1;
                    if (TypesMapping.isDecimal(columnType)) {
                        decimalDigits = rs.getInt("DECIMAL_DIGITS");
                        if (rs.wasNull()) {
                            decimalDigits = -1;
                        }
                    }
                    DbAttribute attr = this.adapter.buildAttribute(columnName, typeName, columnType, columnSize, decimalDigits, allowNulls);
                    attr.setEntity(dbEntity);
                    dbEntity.addAttribute(attr);
                }
            }
            finally {
                rs.close();
            }
            map.addDbEntity(dbEntity);
            if (this.delegate != null) {
                this.delegate.dbEntityAdded(dbEntity);
            }
            if (map.getDbEntity(dbEntity.getName()) != dbEntity) continue;
            this.dbEntityList.add(dbEntity);
        }
        for (DbEntity dbEntity : map.getDbEntities()) {
            if (!tables.contains(dbEntity)) continue;
            String tableName = dbEntity.getName();
            rs = this.metaData.getPrimaryKeys(null, dbEntity.getSchema(), tableName);
            try {
                while (rs.next()) {
                    String pkName;
                    String columnName = rs.getString(4);
                    DbAttribute attribute = (DbAttribute)dbEntity.getAttribute(columnName);
                    if (attribute != null) {
                        attribute.setPrimaryKey(true);
                    } else {
                        logObj.warn("Can't locate attribute for primary key: " + columnName);
                    }
                    if ((pkName = rs.getString(6)) == null || !(dbEntity instanceof DetectedDbEntity)) continue;
                    ((DetectedDbEntity)dbEntity).setPrimaryKeyName(pkName);
                }
            }
            finally {
                rs.close();
            }
        }
        for (DbEntity dbEntity : this.skippedEntities) {
            this.loadDbRelationships(dbEntity, map);
        }
        return true;
    }

    public void loadObjEntities(DataMap map) {
        Iterator<DbEntity> dbEntities = this.dbEntityList.iterator();
        if (!dbEntities.hasNext()) {
            return;
        }
        ArrayList<ObjEntity> loadedEntities = new ArrayList<ObjEntity>(this.dbEntityList.size());
        String packageName = map.getDefaultPackage();
        if (Util.isEmptyString(packageName)) {
            packageName = "";
        } else if (!packageName.endsWith(".")) {
            packageName = packageName + ".";
        }
        while (dbEntities.hasNext()) {
            String objEntityName;
            DbEntity dbEntity = dbEntities.next();
            Collection<ObjEntity> existing = map.getMappedEntities(dbEntity);
            if (existing.size() > 0) {
                loadedEntities.addAll(existing);
                continue;
            }
            String baseName = objEntityName = this.namingStrategy.createObjEntityName(dbEntity);
            for (int i = 1; i < 1000 && map.getObjEntity(objEntityName) != null; ++i) {
                objEntityName = baseName + i;
            }
            ObjEntity objEntity = new ObjEntity(objEntityName);
            objEntity.setDbEntity(dbEntity);
            objEntity.setClassName(this.getGenericClassName() != null ? this.getGenericClassName() : packageName + objEntity.getName());
            map.addObjEntity(objEntity);
            loadedEntities.add(objEntity);
            if (this.delegate == null) continue;
            this.delegate.objEntityAdded(objEntity);
        }
        new EntityMergeSupport(map, this.namingStrategy, !this.creatingMeaningfulPK).synchronizeWithDbEntities(loadedEntities);
    }

    public void loadDbRelationships(DataMap map) throws SQLException {
        for (DbEntity pkEntity : this.dbEntityList) {
            this.loadDbRelationships(pkEntity, map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDbRelationships(DbEntity pkEntity, DataMap map) throws SQLException {
        DatabaseMetaData md = this.getMetaData();
        String pkEntName = pkEntity.getName();
        ResultSet rs = null;
        try {
            rs = md.getExportedKeys(pkEntity.getCatalog(), pkEntity.getSchema(), pkEntity.getName());
        }
        catch (SQLException cay182Ex) {
            logObj.info("Error getting relationships for '" + pkEntName + "', ignoring.");
            return;
        }
        try {
            if (!rs.next()) {
                return;
            }
            DbRelationship forwardRelationship = null;
            DbRelationship reverseRelationship = null;
            DbEntity fkEntity = null;
            ExportedKey key = null;
            do {
                String fkName;
                key = ExportedKey.extractData(rs);
                short keySeq = rs.getShort("KEY_SEQ");
                if (keySeq == 1) {
                    if (forwardRelationship != null) {
                        this.postprocessMasterDbRelationship(forwardRelationship, key);
                        forwardRelationship = null;
                    }
                    String fkEntityName = key.getFKTableName();
                    fkName = key.getFKName();
                    if (!this.includeTableName(fkEntityName)) continue;
                    fkEntity = map.getDbEntity(fkEntityName);
                    if (fkEntity == null) {
                        logObj.info("FK warning: no entity found for name '" + fkEntityName + "'");
                    } else {
                        if (this.skippedEntities.contains(pkEntity) && this.skippedEntities.contains(fkEntity)) continue;
                        String forwardPreferredName = this.namingStrategy.createDbRelationshipName(key, true);
                        forwardRelationship = new DbRelationship(DbLoader.uniqueRelName(pkEntity, forwardPreferredName));
                        forwardRelationship.setSourceEntity(pkEntity);
                        forwardRelationship.setTargetEntity(fkEntity);
                        pkEntity.addRelationship(forwardRelationship);
                        String reversePreferredName = this.namingStrategy.createDbRelationshipName(key, false);
                        reverseRelationship = new DbRelationshipDetected(DbLoader.uniqueRelName(fkEntity, reversePreferredName));
                        ((DbRelationshipDetected)reverseRelationship).setFkName(fkName);
                        reverseRelationship.setToMany(false);
                        reverseRelationship.setSourceEntity(fkEntity);
                        reverseRelationship.setTargetEntity(pkEntity);
                        fkEntity.addRelationship(reverseRelationship);
                    }
                }
                if (fkEntity == null) continue;
                String pkName = key.getPKColumnName();
                fkName = key.getFKColumnName();
                DbAttribute pkAtt = (DbAttribute)pkEntity.getAttribute(pkName);
                if (pkAtt == null) {
                    logObj.info("no attribute for declared primary key: " + pkName);
                    continue;
                }
                DbAttribute fkAtt = (DbAttribute)fkEntity.getAttribute(fkName);
                if (fkAtt == null) {
                    logObj.info("no attribute for declared foreign key: " + fkName);
                    continue;
                }
                if (forwardRelationship != null) {
                    forwardRelationship.addJoin(new DbJoin(forwardRelationship, pkName, fkName));
                }
                if (reverseRelationship == null) continue;
                reverseRelationship.addJoin(new DbJoin(reverseRelationship, fkName, pkName));
            } while (rs.next());
            if (forwardRelationship != null) {
                this.postprocessMasterDbRelationship(forwardRelationship, key);
                forwardRelationship = null;
            }
        }
        finally {
            rs.close();
        }
    }

    protected void postprocessMasterDbRelationship(DbRelationship relationship, ExportedKey key) {
        boolean toPK = true;
        List<DbJoin> joins = relationship.getJoins();
        for (DbJoin join : joins) {
            if (join.getTarget().isPrimaryKey()) continue;
            toPK = false;
            break;
        }
        boolean toDependentPK = false;
        boolean toMany = true;
        if (toPK) {
            toDependentPK = true;
            if (((DbEntity)relationship.getTargetEntity()).getPrimaryKeys().size() == joins.size()) {
                toMany = false;
            }
        }
        if (!toMany) {
            Entity source = relationship.getSourceEntity();
            source.removeRelationship(relationship.getName());
            relationship.setName(DbLoader.uniqueRelName(source, this.namingStrategy.createDbRelationshipName(key, false)));
            source.addRelationship(relationship);
        }
        relationship.setToDependentPK(toDependentPK);
        relationship.setToMany(toMany);
    }

    private String[] getDefaultTableTypes() {
        String viewType = this.adapter.tableTypeForView();
        String tableType = this.adapter.tableTypeForTable();
        ArrayList<String> list = new ArrayList<String>();
        if (viewType != null) {
            list.add(viewType);
        }
        if (tableType != null) {
            list.add(tableType);
        }
        String[] types = new String[list.size()];
        list.toArray(types);
        return types;
    }

    public DataMap loadDataMapFromDB(String schemaName, String tablePattern, DataMap dataMap) throws SQLException {
        String[] types = this.getDefaultTableTypes();
        if (types.length == 0) {
            throw new SQLException("No supported table types found.");
        }
        return this.loadDataMapFromDB(schemaName, tablePattern, types, dataMap);
    }

    public DataMap loadDataMapFromDB(String schemaName, String tablePattern, String[] tableTypes, DataMap dataMap) throws SQLException {
        if (tablePattern == null) {
            tablePattern = WILDCARD;
        }
        if (!this.loadDbEntities(dataMap, this.getTables(null, schemaName, tablePattern, tableTypes))) {
            return dataMap;
        }
        this.loadDbRelationships(dataMap);
        this.loadObjEntities(dataMap);
        return dataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProceduresFromDB(String schemaPattern, String namePattern, DataMap dataMap) throws SQLException {
        HashMap<String, Procedure> procedures = null;
        ResultSet rs = this.getMetaData().getProcedures(null, schemaPattern, namePattern);
        try {
            while (rs.next()) {
                String name = rs.getString("PROCEDURE_NAME");
                if (EXCLUDED_PROCEDURES.contains(name)) {
                    logObj.info("skipping Cayenne PK procedure: " + name);
                    continue;
                }
                String catalog = rs.getString("PROCEDURE_CAT");
                String schema = rs.getString("PROCEDURE_SCHEM");
                short type = rs.getShort("PROCEDURE_TYPE");
                Procedure procedure = new Procedure(name);
                procedure.setCatalog(catalog);
                procedure.setSchema(schema);
                switch (type) {
                    case 0: 
                    case 1: {
                        procedure.setReturningValue(false);
                        break;
                    }
                    case 2: {
                        procedure.setReturningValue(true);
                    }
                }
                if (procedures == null) {
                    procedures = new HashMap<String, Procedure>();
                }
                procedures.put(procedure.getFullyQualifiedName(), procedure);
            }
        }
        finally {
            rs.close();
        }
        if (procedures == null) {
            return;
        }
        ResultSet columnsRS = this.getMetaData().getProcedureColumns(null, schemaPattern, namePattern, null);
        try {
            while (columnsRS.next()) {
                Procedure procedure;
                String key;
                String schema = columnsRS.getString("PROCEDURE_SCHEM");
                String name = columnsRS.getString("PROCEDURE_NAME");
                if (EXCLUDED_PROCEDURES.contains(name)) continue;
                String columnName = columnsRS.getString("COLUMN_NAME");
                short type = columnsRS.getShort("COLUMN_TYPE");
                String string = key = schema != null ? schema + '.' + name : name;
                if (type == 3) {
                    logObj.debug("skipping ResultSet column: " + key + "." + columnName);
                }
                if ((procedure = (Procedure)procedures.get(key)) == null) {
                    logObj.info("invalid procedure column, no procedure found: " + key + "." + columnName);
                    continue;
                }
                ProcedureParameter column = new ProcedureParameter(columnName);
                if (columnName == null) {
                    if (type == 5) {
                        logObj.debug("null column name, assuming result column: " + key);
                        column.setName("_return_value");
                    } else {
                        logObj.info("invalid null column name, skipping column : " + key);
                        continue;
                    }
                }
                int columnType = columnsRS.getInt("DATA_TYPE");
                int columnSize = columnsRS.getInt("LENGTH");
                int decimalDigits = -1;
                if (TypesMapping.isDecimal(columnType)) {
                    decimalDigits = columnsRS.getShort("SCALE");
                    if (columnsRS.wasNull()) {
                        decimalDigits = -1;
                    }
                }
                switch (type) {
                    case 1: {
                        column.setDirection(1);
                        break;
                    }
                    case 2: {
                        column.setDirection(3);
                        break;
                    }
                    case 4: {
                        column.setDirection(2);
                        break;
                    }
                    case 5: {
                        procedure.setReturningValue(true);
                    }
                }
                column.setMaxLength(columnSize);
                column.setPrecision(decimalDigits);
                column.setProcedure(procedure);
                column.setType(columnType);
                procedure.addCallParameter(column);
            }
        }
        finally {
            columnsRS.close();
        }
        for (Procedure procedure : procedures.values()) {
            dataMap.addProcedure(procedure);
        }
    }

    public void setNamingStrategy(NamingStrategy strategy) {
        if (strategy == null) {
            throw new NullPointerException("Null strategy not allowed");
        }
        this.namingStrategy = strategy;
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }
}

