/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.lifecycle.cache;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.DataChannelFilter;
import org.apache.cayenne.DataChannelFilterChain;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.annotation.PrePersist;
import org.apache.cayenne.annotation.PreRemove;
import org.apache.cayenne.annotation.PreUpdate;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.lifecycle.cache.CacheGroups;
import org.apache.cayenne.query.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheInvalidationFilter
implements DataChannelFilter {
    private final ThreadLocal<Set<String>> groups = new ThreadLocal();

    public void init(DataChannel channel) {
    }

    public QueryResponse onQuery(ObjectContext originatingContext, Query query, DataChannelFilterChain filterChain) {
        return filterChain.onQuery(originatingContext, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType, DataChannelFilterChain filterChain) {
        try {
            GraphDiff result = filterChain.onSync(originatingContext, changes, syncType);
            Collection groupSet = this.groups.get();
            if (groupSet != null && !groupSet.isEmpty()) {
                QueryCache cache = ((DataContext)originatingContext).getQueryCache();
                for (String group : groupSet) {
                    cache.removeGroup(group);
                }
            }
            GraphDiff graphDiff = result;
            return graphDiff;
        }
        finally {
            this.groups.set(null);
        }
    }

    @PrePersist(entityAnnotations={CacheGroups.class})
    @PreRemove(entityAnnotations={CacheGroups.class})
    @PreUpdate(entityAnnotations={CacheGroups.class})
    protected void preCommit(Object object) {
        Set<String> groupSet = this.groups.get();
        if (groupSet == null) {
            groupSet = new HashSet<String>();
            this.groups.set(groupSet);
        }
        this.addCacheGroups(groupSet, object);
    }

    protected void addCacheGroups(Set<String> groupSet, Object object) {
        CacheGroups a = object.getClass().getAnnotation(CacheGroups.class);
        for (String group : a.value()) {
            groupSet.add(group);
        }
    }
}

