/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package demoapp.web.replay;

import jakarta.inject.Named;

import org.springframework.context.annotation.Profile;

import org.apache.causeway.applib.annotation.Action;
import org.apache.causeway.applib.annotation.ActionLayout;
import org.apache.causeway.applib.annotation.DomainService;
import org.apache.causeway.applib.annotation.PriorityPrecedence;
import org.apache.causeway.applib.annotation.SemanticsOf;
import org.apache.causeway.extensions.commandreplay.secondary.spi.ReplayCommandExecutionController;

@Named("demo.web.DemoReplayController")
<<<<<<< HEAD
@DomainService(
        nature = NatureOfService.VIEW
)
@jakarta.annotation.Priority(PriorityPrecedence.EARLY)
=======
@DomainService
@jakarta.annotation.Priority(PriorityPrecedence.EARLY)
>>>>>>> refs/remotes/origin/master
@Profile("commandreplay-secondary")
public class DemoReplayController implements ReplayCommandExecutionController {

    private State state = State.PAUSED;

    @Override
    public State getState() {
        return state;
    }

    @Action(semantics = SemanticsOf.IDEMPOTENT)
    @ActionLayout(cssClassFa = "fa-play")
    public void resumeReplay() {
        state = State.RUNNING;
    }
    public boolean hideResumeReplay() { return state == State.RUNNING; }


    @Action(semantics = SemanticsOf.IDEMPOTENT)
    @ActionLayout(cssClassFa = "fa-pause")
    public void pauseReplay() {
        state = State.PAUSED;
    }
    public boolean hidePauseReplay() { return state == State.PAUSED; }

}
