/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.causeway.tooling.projectmodel;

import java.util.Comparator;

import lombok.Builder;
import lombok.Data;

@Data @Builder
public class Dependency implements Comparable<Dependency> {

    public static enum Location {
        LOCAL,
        EXTERNAL;

        public boolean isLocal()    { return this == LOCAL; }
        public boolean isExternal() { return this == EXTERNAL; }
    }

    private final ArtifactCoordinates artifactCoordinates;
    private Location location;

    /**
     * as generated by {@link ArtifactShortNameFactory}
     */
    private final String shortName;


    // -- COMPARATOR

    private final static Comparator<Dependency> comparator = Comparator
            .comparing(Dependency::getArtifactCoordinates);


    @Override
    public int compareTo(Dependency o) {
        return comparator.compare(this, o);
    }


}
