# Changelog

## [Unreleased](https://github.com/apache/camel-k-runtime/tree/HEAD)

[Full Changelog](https://github.com/apache/camel-k-runtime/compare/camel-k-runtime-project-2.16.0...HEAD)

**Closed issues:**

- Make camel-quarkus-3 branch buildable [\#1073](https://github.com/apache/camel-k-runtime/issues/1073)

## [camel-k-runtime-project-2.16.0](https://github.com/apache/camel-k-runtime/tree/camel-k-runtime-project-2.16.0) (2023-07-04)

[Full Changelog](https://github.com/apache/camel-k-runtime/compare/camel-k-runtime-project-1.17.1...camel-k-runtime-project-2.16.0)

**Closed issues:**

- Provide a script to support release process [\#1056](https://github.com/apache/camel-k-runtime/issues/1056)

## [camel-k-runtime-project-1.17.1](https://github.com/apache/camel-k-runtime/tree/camel-k-runtime-project-1.17.1) (2023-05-29)

[Full Changelog](https://github.com/apache/camel-k-runtime/compare/camel-k-runtime-project-1.17.0...camel-k-runtime-project-1.17.1)

**Closed issues:**

- Include miscellaneous components in Camel catalog [\#1029](https://github.com/apache/camel-k-runtime/issues/1029)
- Release 1.17.0 [\#951](https://github.com/apache/camel-k-runtime/issues/951)

## [camel-k-runtime-project-1.17.0](https://github.com/apache/camel-k-runtime/tree/camel-k-runtime-project-1.17.0) (2023-02-20)

[Full Changelog](https://github.com/apache/camel-k-runtime/compare/camel-k-runtime-project-1.16.0...camel-k-runtime-project-1.17.0)

**Closed issues:**

- Update DSLs metadata [\#953](https://github.com/apache/camel-k-runtime/issues/953)
- Upgrade for Camel 3.20.1 [\#950](https://github.com/apache/camel-k-runtime/issues/950)
- Release 1.16.0 [\#925](https://github.com/apache/camel-k-runtime/issues/925)

**Merged pull requests:**

- build\(deps\): bump maven-enforcer-plugin from 3.1.0 to 3.2.1 [\#969](https://github.com/apache/camel-k-runtime/pull/969) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump jackson-version from 2.14.1 to 2.14.2 [\#968](https://github.com/apache/camel-k-runtime/pull/968) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump http-cache-semantics from 4.1.0 to 4.1.1 in /docs [\#966](https://github.com/apache/camel-k-runtime/pull/966) ([dependabot[bot]](https://github.com/apps/dependabot))
- Move jolokia exclusions from generate-catalog maven plugin to the camel-k-runtime-bom/pom.xml [\#965](https://github.com/apache/camel-k-runtime/pull/965) ([claudio4j](https://github.com/claudio4j))
- build\(deps\): bump versions-maven-plugin from 2.12.0 to 2.14.2 [\#963](https://github.com/apache/camel-k-runtime/pull/963) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump maven-plugin-plugin from 3.6.4 to 3.7.1 [\#962](https://github.com/apache/camel-k-runtime/pull/962) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump maven-surefire-plugin from 3.0.0-M7 to 3.0.0-M8 [\#961](https://github.com/apache/camel-k-runtime/pull/961) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump maven-failsafe-plugin from 3.0.0-M7 to 3.0.0-M8 [\#960](https://github.com/apache/camel-k-runtime/pull/960) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump jolokia-jvm from 1.7.1 to 1.7.2 [\#959](https://github.com/apache/camel-k-runtime/pull/959) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump groovy-version from 3.0.13 to 3.0.14 [\#958](https://github.com/apache/camel-k-runtime/pull/958) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump value from 2.9.2 to 2.9.3 [\#957](https://github.com/apache/camel-k-runtime/pull/957) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump maven-checkstyle-plugin from 3.2.0 to 3.2.1 [\#956](https://github.com/apache/camel-k-runtime/pull/956) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump maven-pmd-plugin from 3.19.0 to 3.20.0 [\#955](https://github.com/apache/camel-k-runtime/pull/955) ([dependabot[bot]](https://github.com/apps/dependabot))
- Ref \#953: Update DSLs metadata [\#954](https://github.com/apache/camel-k-runtime/pull/954) ([essobedo](https://github.com/essobedo))
- Prepare release 1.17.0 [\#952](https://github.com/apache/camel-k-runtime/pull/952) ([oscerd](https://github.com/oscerd))
- build\(deps\): bump assertj-core from 3.23.1 to 3.24.2 [\#949](https://github.com/apache/camel-k-runtime/pull/949) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump maven-dependency-plugin from 3.3.0 to 3.5.0 [\#948](https://github.com/apache/camel-k-runtime/pull/948) ([dependabot[bot]](https://github.com/apps/dependabot))
- feat\(catalog\) : Add telemetry capability [\#945](https://github.com/apache/camel-k-runtime/pull/945) ([gansheer](https://github.com/gansheer))
- feat\(catalog\): publish Mandrel image info [\#943](https://github.com/apache/camel-k-runtime/pull/943) ([squakez](https://github.com/squakez))
- build\(deps\): bump apache from 27 to 29 [\#942](https://github.com/apache/camel-k-runtime/pull/942) ([dependabot[bot]](https://github.com/apps/dependabot))
- feat\(deps\): split quarkus-camel-bom [\#937](https://github.com/apache/camel-k-runtime/pull/937) ([squakez](https://github.com/squakez))
- Remove duplicate maven-assembly-plugin-version property from pom.xml [\#936](https://github.com/apache/camel-k-runtime/pull/936) ([claudio4j](https://github.com/claudio4j))
- build\(deps\): bump decode-uri-component from 0.2.0 to 0.2.2 in /docs [\#934](https://github.com/apache/camel-k-runtime/pull/934) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump jackson-version from 2.13.4 to 2.14.1 [\#932](https://github.com/apache/camel-k-runtime/pull/932) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump gmavenplus-plugin from 1.13.1 to 2.1.0 [\#912](https://github.com/apache/camel-k-runtime/pull/912) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump asm from 9.3 to 9.4 [\#899](https://github.com/apache/camel-k-runtime/pull/899) ([dependabot[bot]](https://github.com/apps/dependabot))

## [camel-k-runtime-project-1.16.0](https://github.com/apache/camel-k-runtime/tree/camel-k-runtime-project-1.16.0) (2022-11-28)

[Full Changelog](https://github.com/apache/camel-k-runtime/compare/camel-k-runtime-project-1.15.2...camel-k-runtime-project-1.16.0)

**Closed issues:**

- Release 1.15.2 [\#920](https://github.com/apache/camel-k-runtime/issues/920)

**Merged pull requests:**

- Set knative as a know http endpoint [\#933](https://github.com/apache/camel-k-runtime/pull/933) ([claudio4j](https://github.com/claudio4j))
- fix\(ci\): keep version artifact only [\#928](https://github.com/apache/camel-k-runtime/pull/928) ([squakez](https://github.com/squakez))
- Prepare release 1.16.0 [\#927](https://github.com/apache/camel-k-runtime/pull/927) ([oscerd](https://github.com/oscerd))
- Align to deps coming from next release 1.15.2 even on main [\#922](https://github.com/apache/camel-k-runtime/pull/922) ([oscerd](https://github.com/oscerd))
- fix\(deps\): brought back inheritance to camel deps [\#919](https://github.com/apache/camel-k-runtime/pull/919) ([squakez](https://github.com/squakez))
- chore: dependency cleaning [\#916](https://github.com/apache/camel-k-runtime/pull/916) ([squakez](https://github.com/squakez))
- fix\(ci\): publish distro within the rest of modules [\#915](https://github.com/apache/camel-k-runtime/pull/915) ([squakez](https://github.com/squakez))
- fix\(ci\): using a profile for distribution artifact [\#914](https://github.com/apache/camel-k-runtime/pull/914) ([squakez](https://github.com/squakez))
- fix\(ci\): proper directory [\#913](https://github.com/apache/camel-k-runtime/pull/913) ([squakez](https://github.com/squakez))
- feat\(ci\): publish snapshot on release branches [\#911](https://github.com/apache/camel-k-runtime/pull/911) ([squakez](https://github.com/squakez))
- chore: bump to 1.16.0 [\#909](https://github.com/apache/camel-k-runtime/pull/909) ([squakez](https://github.com/squakez))
- Revert logback uprgade to 1.2.11 [\#903](https://github.com/apache/camel-k-runtime/pull/903) ([claudio4j](https://github.com/claudio4j))
- Set jolokia dependency in camel-k-runtime-bom to avoid declaring the dependency in camel-k [\#901](https://github.com/apache/camel-k-runtime/pull/901) ([claudio4j](https://github.com/claudio4j))

## [camel-k-runtime-project-1.15.2](https://github.com/apache/camel-k-runtime/tree/camel-k-runtime-project-1.15.2) (2022-11-09)

[Full Changelog](https://github.com/apache/camel-k-runtime/compare/camel-k-runtime-project-1.15.1...camel-k-runtime-project-1.15.2)

**Closed issues:**

- Error publishing last snapshot [\#918](https://github.com/apache/camel-k-runtime/issues/918)
- Release 1.15.1 [\#907](https://github.com/apache/camel-k-runtime/issues/907)

## [camel-k-runtime-project-1.15.1](https://github.com/apache/camel-k-runtime/tree/camel-k-runtime-project-1.15.1) (2022-10-18)

[Full Changelog](https://github.com/apache/camel-k-runtime/compare/camel-k-runtime-project-1.15.0...camel-k-runtime-project-1.15.1)

## [camel-k-runtime-project-1.15.0](https://github.com/apache/camel-k-runtime/tree/camel-k-runtime-project-1.15.0) (2022-09-29)

[Full Changelog](https://github.com/apache/camel-k-runtime/compare/camel-k-runtime-project-1.14.0...camel-k-runtime-project-1.15.0)

**Merged pull requests:**

- Point to Quarkus Platform 2.13.0.Final [\#897](https://github.com/apache/camel-k-runtime/pull/897) ([oscerd](https://github.com/oscerd))
- build\(deps\): bump maven-common-artifact-filters from 3.3.1 to 3.3.2 [\#896](https://github.com/apache/camel-k-runtime/pull/896) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump maven-jar-plugin from 3.2.2 to 3.3.0 [\#895](https://github.com/apache/camel-k-runtime/pull/895) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump value from 2.9.1 to 2.9.2 [\#894](https://github.com/apache/camel-k-runtime/pull/894) ([dependabot[bot]](https://github.com/apps/dependabot))
- Prepare for 1.15.0 [\#893](https://github.com/apache/camel-k-runtime/pull/893) ([oscerd](https://github.com/oscerd))
- build\(deps\): bump logback-version from 1.2.11 to 1.4.1 [\#892](https://github.com/apache/camel-k-runtime/pull/892) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump versions-maven-plugin from 2.11.0 to 2.12.0 [\#891](https://github.com/apache/camel-k-runtime/pull/891) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump groovy-version from 3.0.12 to 3.0.13 [\#890](https://github.com/apache/camel-k-runtime/pull/890) ([dependabot[bot]](https://github.com/apps/dependabot))
- Upgrade to Camel Quarkus 2.13.0 [\#889](https://github.com/apache/camel-k-runtime/pull/889) ([oscerd](https://github.com/oscerd))
- chore\(ci\): extend check on release branches [\#887](https://github.com/apache/camel-k-runtime/pull/887) ([squakez](https://github.com/squakez))
- build\(deps\): bump maven-pmd-plugin from 3.18.0 to 3.19.0 [\#885](https://github.com/apache/camel-k-runtime/pull/885) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump jackson-version from 2.13.3 to 2.13.4 [\#884](https://github.com/apache/camel-k-runtime/pull/884) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump logback-version from 1.2.11 to 1.4.0 [\#879](https://github.com/apache/camel-k-runtime/pull/879) ([dependabot[bot]](https://github.com/apps/dependabot))

## [camel-k-runtime-project-1.14.0](https://github.com/apache/camel-k-runtime/tree/camel-k-runtime-project-1.14.0) (2022-08-30)

[Full Changelog](https://github.com/apache/camel-k-runtime/compare/camel-k-runtime-project-1.13.0...camel-k-runtime-project-1.14.0)

**Closed issues:**

- Bump to Camel Quarkus 2.11.0 and Camel 3.18.0 [\#852](https://github.com/apache/camel-k-runtime/issues/852)
- Improve error message during ErrorHander building validation [\#820](https://github.com/apache/camel-k-runtime/issues/820)
- Align Camel K Runtime BOM with camel version [\#813](https://github.com/apache/camel-k-runtime/issues/813)

**Merged pull requests:**

- Doc: Remove unsupported "Extending DSL" section [\#881](https://github.com/apache/camel-k-runtime/pull/881) ([claudio4j](https://github.com/claudio4j))
- fix\(core\): Error handler regression [\#880](https://github.com/apache/camel-k-runtime/pull/880) ([squakez](https://github.com/squakez))
- fix: issue inherited by Quarkus platform [\#878](https://github.com/apache/camel-k-runtime/pull/878) ([squakez](https://github.com/squakez))
- bump maven-pmd-plugin 3.18.0 and cleanup camel-k-maven-plugin deps [\#876](https://github.com/apache/camel-k-runtime/pull/876) ([lburgazzoli](https://github.com/lburgazzoli))
- Move to 2.11.3.Final for Quarkus and restart release process [\#875](https://github.com/apache/camel-k-runtime/pull/875) ([oscerd](https://github.com/oscerd))
- build\(deps\): bump quarkus-platform-version from 2.11.2.Final to 2.11.3.Final [\#874](https://github.com/apache/camel-k-runtime/pull/874) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump maven-checkstyle-plugin from 3.1.2 to 3.2.0 [\#873](https://github.com/apache/camel-k-runtime/pull/873) ([dependabot[bot]](https://github.com/apps/dependabot))
- fix: set quarkus core version to 2.11.2.Final [\#871](https://github.com/apache/camel-k-runtime/pull/871) ([squakez](https://github.com/squakez))
- Fixed an invalid resume api dependency reference in the bom [\#870](https://github.com/apache/camel-k-runtime/pull/870) ([orpiske](https://github.com/orpiske))
- build\(deps\): bump value from 2.9.0 to 2.9.1 [\#869](https://github.com/apache/camel-k-runtime/pull/869) ([dependabot[bot]](https://github.com/apps/dependabot))
- Cleanup [\#867](https://github.com/apache/camel-k-runtime/pull/867) ([lburgazzoli](https://github.com/lburgazzoli))
- feat: replace custom kubernetes properties function with those provided by camel-kubernetes [\#865](https://github.com/apache/camel-k-runtime/pull/865) ([lburgazzoli](https://github.com/lburgazzoli))
- build\(deps\): bump maven-javadoc-plugin from 3.4.0 to 3.4.1 [\#864](https://github.com/apache/camel-k-runtime/pull/864) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump quarkus-platform-version from 2.11.1.Final to 2.11.2.Final [\#863](https://github.com/apache/camel-k-runtime/pull/863) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump maven-site-plugin from 3.12.0 to 3.12.1 [\#862](https://github.com/apache/camel-k-runtime/pull/862) ([dependabot[bot]](https://github.com/apps/dependabot))
- \(chores\) ci: update checkout actions to v3 [\#861](https://github.com/apache/camel-k-runtime/pull/861) ([orpiske](https://github.com/orpiske))
- \(chores\) ci: add dependency review check for PRs [\#860](https://github.com/apache/camel-k-runtime/pull/860) ([orpiske](https://github.com/orpiske))
- Update to use the bom for Quarkus 2.11.0 [\#859](https://github.com/apache/camel-k-runtime/pull/859) ([orpiske](https://github.com/orpiske))
- Add preliminary support for the Resume API for Camel K [\#858](https://github.com/apache/camel-k-runtime/pull/858) ([orpiske](https://github.com/orpiske))
- Align Camel 3.18 dependencies [\#857](https://github.com/apache/camel-k-runtime/pull/857) ([orpiske](https://github.com/orpiske))
- Upgrade to Camel Quarkus 2.11.0.Final, Camel 3.18.0 and Quarkus Platform 2.11.1.Final [\#856](https://github.com/apache/camel-k-runtime/pull/856) ([oscerd](https://github.com/oscerd))
- build\(deps\): bump maven-assembly-plugin from 3.4.1 to 3.4.2 [\#855](https://github.com/apache/camel-k-runtime/pull/855) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump groovy-version from 3.0.11 to 3.0.12 [\#854](https://github.com/apache/camel-k-runtime/pull/854) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump maven-resources-plugin from 3.2.0 to 3.3.0 [\#853](https://github.com/apache/camel-k-runtime/pull/853) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore: fix 404 [\#851](https://github.com/apache/camel-k-runtime/pull/851) ([squakez](https://github.com/squakez))
- build\(deps\): bump maven-common-artifact-filters from 3.3.0 to 3.3.1 [\#850](https://github.com/apache/camel-k-runtime/pull/850) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump maven-remote-resources-plugin from 1.7.0 to 3.0.0 [\#849](https://github.com/apache/camel-k-runtime/pull/849) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump maven-deploy-plugin from 3.0.0-M2 to 3.0.0 [\#848](https://github.com/apache/camel-k-runtime/pull/848) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore: bom cleaning [\#847](https://github.com/apache/camel-k-runtime/pull/847) ([squakez](https://github.com/squakez))
- build\(deps\): bump exec-maven-plugin from 3.0.0 to 3.1.0 [\#846](https://github.com/apache/camel-k-runtime/pull/846) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump apache from 26 to 27 [\#845](https://github.com/apache/camel-k-runtime/pull/845) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump maven-assembly-plugin from 3.3.0 to 3.4.1 [\#844](https://github.com/apache/camel-k-runtime/pull/844) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump jandex-maven-plugin from 1.2.2 to 1.2.3 [\#842](https://github.com/apache/camel-k-runtime/pull/842) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump jandex from 2.4.2.Final to 2.4.3.Final [\#841](https://github.com/apache/camel-k-runtime/pull/841) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): Bump dependency versions [\#840](https://github.com/apache/camel-k-runtime/pull/840) ([christophd](https://github.com/christophd))
- build\(deps\): bump maven-common-artifact-filters from 3.2.0 to 3.3.0 [\#834](https://github.com/apache/camel-k-runtime/pull/834) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add new module for structural Maven logging [\#833](https://github.com/apache/camel-k-runtime/pull/833) ([christophd](https://github.com/christophd))
- build\(deps\): bump maven-enforcer-plugin from 3.0.0 to 3.1.0 [\#832](https://github.com/apache/camel-k-runtime/pull/832) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump maven-failsafe-plugin from 3.0.0-M6 to 3.0.0-M7 [\#831](https://github.com/apache/camel-k-runtime/pull/831) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump maven-surefire-plugin from 3.0.0-M6 to 3.0.0-M7 [\#830](https://github.com/apache/camel-k-runtime/pull/830) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump maven-pmd-plugin from 3.16.0 to 3.17.0 [\#829](https://github.com/apache/camel-k-runtime/pull/829) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump groovy-version from 3.0.10 to 3.0.11 [\#828](https://github.com/apache/camel-k-runtime/pull/828) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): Camel Quarkus dependency management [\#827](https://github.com/apache/camel-k-runtime/pull/827) ([squakez](https://github.com/squakez))
- chore\(deps\): move Quarkus native image into a property [\#826](https://github.com/apache/camel-k-runtime/pull/826) ([squakez](https://github.com/squakez))
- feat\(deps\): script to bump dependencies [\#825](https://github.com/apache/camel-k-runtime/pull/825) ([squakez](https://github.com/squakez))
- build\(deps\): bump versions-maven-plugin from 2.10.0 to 2.11.0 [\#824](https://github.com/apache/camel-k-runtime/pull/824) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(dependencies\): 1.14.0 new release cycle [\#823](https://github.com/apache/camel-k-runtime/pull/823) ([squakez](https://github.com/squakez))
- Improve error message during ErrorHander building validation [\#822](https://github.com/apache/camel-k-runtime/pull/822) ([lburgazzoli](https://github.com/lburgazzoli))
- build\(deps\): bump maven-failsafe-plugin from 3.0.0-M5 to 3.0.0-M6 [\#821](https://github.com/apache/camel-k-runtime/pull/821) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump maven-clean-plugin from 3.1.0 to 3.2.0 [\#817](https://github.com/apache/camel-k-runtime/pull/817) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump maven-site-plugin from 3.11.0 to 3.12.0 [\#816](https://github.com/apache/camel-k-runtime/pull/816) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump maven-javadoc-plugin from 3.3.2 to 3.4.0 [\#815](https://github.com/apache/camel-k-runtime/pull/815) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump asm from 9.2 to 9.3 [\#814](https://github.com/apache/camel-k-runtime/pull/814) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump simple-get from 3.1.0 to 3.1.1 in /docs [\#810](https://github.com/apache/camel-k-runtime/pull/810) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump lodash from 4.17.15 to 4.17.21 in /docs [\#809](https://github.com/apache/camel-k-runtime/pull/809) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump handlebars from 4.7.6 to 4.7.7 in /docs [\#808](https://github.com/apache/camel-k-runtime/pull/808) ([dependabot[bot]](https://github.com/apps/dependabot))

## [camel-k-runtime-project-1.13.0](https://github.com/apache/camel-k-runtime/tree/camel-k-runtime-project-1.13.0) (2022-04-19)

[Full Changelog](https://github.com/apache/camel-k-runtime/compare/camel-k-runtime-project-1.12.0...camel-k-runtime-project-1.13.0)

**Closed issues:**

- Release 1.13.0: Update to use Camel 3.16.0 [\#805](https://github.com/apache/camel-k-runtime/issues/805)
- Prepare for release 1.13.0 [\#793](https://github.com/apache/camel-k-runtime/issues/793)
- Move dsl-jsh to core project [\#767](https://github.com/apache/camel-k-runtime/issues/767)
- Move components to Camel [\#752](https://github.com/apache/camel-k-runtime/issues/752)
- HTTP error \(can't write to /deployments/file-uploads\) when not setting content-type [\#634](https://github.com/apache/camel-k-runtime/issues/634)
- Rest options such as cors still don't work [\#416](https://github.com/apache/camel-k-runtime/issues/416)

**Merged pull requests:**

- build\(deps\): bump apache from 25 to 26 [\#812](https://github.com/apache/camel-k-runtime/pull/812) ([dependabot[bot]](https://github.com/apps/dependabot))
- Remove staging repositories for Camel Quarkus 2.8.0 [\#811](https://github.com/apache/camel-k-runtime/pull/811) ([oscerd](https://github.com/oscerd))
- build\(deps\): bump maven-surefire-plugin from 3.0.0-M5 to 3.0.0-M6 [\#807](https://github.com/apache/camel-k-runtime/pull/807) ([dependabot[bot]](https://github.com/apps/dependabot))
- Fix 805 [\#806](https://github.com/apache/camel-k-runtime/pull/806) ([oscerd](https://github.com/oscerd))
- build\(deps\): bump maven-compiler-plugin from 3.10.0 to 3.10.1 [\#804](https://github.com/apache/camel-k-runtime/pull/804) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump apache from 24 to 25 [\#803](https://github.com/apache/camel-k-runtime/pull/803) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump maven-site-plugin from 3.10.0 to 3.11.0 [\#802](https://github.com/apache/camel-k-runtime/pull/802) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump spock-core from 2.0-groovy-3.0 to 2.1-groovy-3.0 [\#801](https://github.com/apache/camel-k-runtime/pull/801) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump versions-maven-plugin from 2.9.0 to 2.10.0 [\#800](https://github.com/apache/camel-k-runtime/pull/800) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump maven-plugin-annotations from 3.6.2 to 3.6.4 [\#799](https://github.com/apache/camel-k-runtime/pull/799) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump groovy-version from 3.0.9 to 3.0.10 [\#798](https://github.com/apache/camel-k-runtime/pull/798) ([dependabot[bot]](https://github.com/apps/dependabot))
- Removed staging repositories for Camel-quarkus 2.8.0-M1 [\#797](https://github.com/apache/camel-k-runtime/pull/797) ([oscerd](https://github.com/oscerd))
- Move dsl-jsh to core project - Removed the jsh module from camel-k-ru… [\#796](https://github.com/apache/camel-k-runtime/pull/796) ([oscerd](https://github.com/oscerd))
- Build 3.15.0 [\#795](https://github.com/apache/camel-k-runtime/pull/795) ([oscerd](https://github.com/oscerd))
- Next is 1.13.0 [\#794](https://github.com/apache/camel-k-runtime/pull/794) ([oscerd](https://github.com/oscerd))
- chore: use isEmpty\(\) instead of size\(\) == 0 [\#792](https://github.com/apache/camel-k-runtime/pull/792) ([lburgazzoli](https://github.com/lburgazzoli))
- build\(deps\): bump maven-pmd-plugin from 3.15.0 to 3.16.0 [\#791](https://github.com/apache/camel-k-runtime/pull/791) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump maven-javadoc-plugin from 3.3.1 to 3.3.2 [\#790](https://github.com/apache/camel-k-runtime/pull/790) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump maven-compiler-plugin from 3.9.0 to 3.10.0 [\#789](https://github.com/apache/camel-k-runtime/pull/789) ([dependabot[bot]](https://github.com/apps/dependabot))

## [camel-k-runtime-project-1.12.0](https://github.com/apache/camel-k-runtime/tree/camel-k-runtime-project-1.12.0) (2022-02-08)

[Full Changelog](https://github.com/apache/camel-k-runtime/compare/camel-k-runtime-project-1.11.0...camel-k-runtime-project-1.12.0)

**Closed issues:**

- Remove camel-k-kamelet-reify [\#766](https://github.com/apache/camel-k-runtime/issues/766)

**Merged pull requests:**

- Camel-dependencies should point to 3.14.1 [\#788](https://github.com/apache/camel-k-runtime/pull/788) ([oscerd](https://github.com/oscerd))
- build\(deps\): bump versions-maven-plugin from 2.8.1 to 2.9.0 [\#787](https://github.com/apache/camel-k-runtime/pull/787) ([dependabot[bot]](https://github.com/apps/dependabot))
- deps: update camel-quarkus to v2.7.0 [\#786](https://github.com/apache/camel-k-runtime/pull/786) ([lburgazzoli](https://github.com/lburgazzoli))
- build\(deps\): bump build-helper-maven-plugin from 3.2.0 to 3.3.0 [\#785](https://github.com/apache/camel-k-runtime/pull/785) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): remove kamelet-reify [\#784](https://github.com/apache/camel-k-runtime/pull/784) ([squakez](https://github.com/squakez))
- build\(deps\): bump maven-plugin-plugin from 3.6.2 to 3.6.4 [\#783](https://github.com/apache/camel-k-runtime/pull/783) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump value from 2.8.9-ea-1 to 2.9.0 [\#781](https://github.com/apache/camel-k-runtime/pull/781) ([dependabot[bot]](https://github.com/apps/dependabot))
- chore\(deps\): let transitive maven-core dependency [\#778](https://github.com/apache/camel-k-runtime/pull/778) ([squakez](https://github.com/squakez))
- build\(deps\): bump maven-deploy-plugin from 3.0.0-M1 to 3.0.0-M2 [\#777](https://github.com/apache/camel-k-runtime/pull/777) ([dependabot[bot]](https://github.com/apps/dependabot))

## [camel-k-runtime-project-1.11.0](https://github.com/apache/camel-k-runtime/tree/camel-k-runtime-project-1.11.0) (2022-01-18)

[Full Changelog](https://github.com/apache/camel-k-runtime/compare/camel-k-runtime-project-1.10.0...camel-k-runtime-project-1.11.0)

**Closed issues:**

- Cannot use event broker other than default [\#764](https://github.com/apache/camel-k-runtime/issues/764)
- Set YamlDeserializationMode.FLOW on camel-context [\#707](https://github.com/apache/camel-k-runtime/issues/707)
- Add more examples with different components [\#617](https://github.com/apache/camel-k-runtime/issues/617)
- Add README to examples [\#616](https://github.com/apache/camel-k-runtime/issues/616)

**Merged pull requests:**

- build\(deps\): bump maven-compiler-plugin from 3.8.1 to 3.9.0 [\#780](https://github.com/apache/camel-k-runtime/pull/780) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump maven-jar-plugin from 3.2.0 to 3.2.2 [\#779](https://github.com/apache/camel-k-runtime/pull/779) ([dependabot[bot]](https://github.com/apps/dependabot))
- camel-website-701 RI update attribute name \(main\) [\#774](https://github.com/apache/camel-k-runtime/pull/774) ([djencks](https://github.com/djencks))
- build\(deps\): bump jandex from 2.4.1.Final to 2.4.2.Final [\#773](https://github.com/apache/camel-k-runtime/pull/773) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump jandex-maven-plugin from 1.2.1 to 1.2.2 [\#772](https://github.com/apache/camel-k-runtime/pull/772) ([dependabot[bot]](https://github.com/apps/dependabot))
- Point to the latest tag in scm pom section [\#771](https://github.com/apache/camel-k-runtime/pull/771) ([oscerd](https://github.com/oscerd))
- build\(deps\): bump maven-site-plugin from 3.9.1 to 3.10.0 [\#769](https://github.com/apache/camel-k-runtime/pull/769) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump maven-plugin-annotations from 3.6.1 to 3.6.2 [\#768](https://github.com/apache/camel-k-runtime/pull/768) ([dependabot[bot]](https://github.com/apps/dependabot))
- fix\(knative\): use object name when events endpoints [\#765](https://github.com/apache/camel-k-runtime/pull/765) ([squakez](https://github.com/squakez))
- build\(deps\): bump gmavenplus-plugin from 1.13.0 to 1.13.1 [\#763](https://github.com/apache/camel-k-runtime/pull/763) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump maven-plugin-plugin from 3.6.1 to 3.6.2 [\#762](https://github.com/apache/camel-k-runtime/pull/762) ([dependabot[bot]](https://github.com/apps/dependabot))
- deps: upgrade camel-quarkus to v2.6.0 [\#761](https://github.com/apache/camel-k-runtime/pull/761) ([lburgazzoli](https://github.com/lburgazzoli))
- deps: remove log4j as it is not needed [\#757](https://github.com/apache/camel-k-runtime/pull/757) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: remove staging maven repo [\#756](https://github.com/apache/camel-k-runtime/pull/756) ([lburgazzoli](https://github.com/lburgazzoli))
- cq 2.5.0 [\#755](https://github.com/apache/camel-k-runtime/pull/755) ([lburgazzoli](https://github.com/lburgazzoli))
- Remove duplicated option from doc table knative.apiVersion [\#753](https://github.com/apache/camel-k-runtime/pull/753) ([apupier](https://github.com/apupier))

## [camel-k-runtime-project-1.10.0](https://github.com/apache/camel-k-runtime/tree/camel-k-runtime-project-1.10.0) (2021-11-09)

[Full Changelog](https://github.com/apache/camel-k-runtime/compare/camel-k-runtime-project-1.9.1...camel-k-runtime-project-1.10.0)

**Merged pull requests:**

- chore\(deps\): remove useless test dependency [\#751](https://github.com/apache/camel-k-runtime/pull/751) ([squakez](https://github.com/squakez))
- remove undertow [\#750](https://github.com/apache/camel-k-runtime/pull/750) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(deps\): move quarkus-logging-json dependency to pom [\#749](https://github.com/apache/camel-k-runtime/pull/749) ([squakez](https://github.com/squakez))
- camel-k-runtime main latest to next [\#747](https://github.com/apache/camel-k-runtime/pull/747) ([djencks](https://github.com/djencks))
- camel quarkus 2.4.0 [\#746](https://github.com/apache/camel-k-runtime/pull/746) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix camel-dependencies parent version [\#744](https://github.com/apache/camel-k-runtime/pull/744) ([jamesnetherton](https://github.com/jamesnetherton))
- deps: update to camel-quarkus 2.3.0 [\#743](https://github.com/apache/camel-k-runtime/pull/743) ([lburgazzoli](https://github.com/lburgazzoli))
- fix\(catalog\): add jolokia-jvm with exclusions to camel-catalog [\#742](https://github.com/apache/camel-k-runtime/pull/742) ([tadayosi](https://github.com/tadayosi))
- fix: use the quarkus catalog instead of the vanilla one [\#741](https://github.com/apache/camel-k-runtime/pull/741) ([lburgazzoli](https://github.com/lburgazzoli))
- build\(deps\): bump maven-javadoc-plugin from 3.3.0 to 3.3.1 [\#740](https://github.com/apache/camel-k-runtime/pull/740) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump groovy-version from 3.0.8 to 3.0.9 [\#739](https://github.com/apache/camel-k-runtime/pull/739) ([dependabot[bot]](https://github.com/apps/dependabot))
- Link to spec [\#734](https://github.com/apache/camel-k-runtime/pull/734) ([squakez](https://github.com/squakez))

## [camel-k-runtime-project-1.9.1](https://github.com/apache/camel-k-runtime/tree/camel-k-runtime-project-1.9.1) (2021-10-21)

[Full Changelog](https://github.com/apache/camel-k-runtime/compare/camel-k-runtime-project-1.9.0...camel-k-runtime-project-1.9.1)

**Closed issues:**

- Optional parameters are still not working [\#706](https://github.com/apache/camel-k-runtime/issues/706)
- Functions to escape Kamelet parameters [\#632](https://github.com/apache/camel-k-runtime/issues/632)

## [camel-k-runtime-project-1.9.0](https://github.com/apache/camel-k-runtime/tree/camel-k-runtime-project-1.9.0) (2021-09-03)

[Full Changelog](https://github.com/apache/camel-k-runtime/compare/camel-k-runtime-project-1.8.0...camel-k-runtime-project-1.9.0)

**Merged pull requests:**

- build\(deps\): bump jandex-maven-plugin from 1.1.0 to 1.2.0 [\#738](https://github.com/apache/camel-k-runtime/pull/738) ([dependabot[bot]](https://github.com/apps/dependabot))
- tools: allow to exclude components/dataformat/languages/dsld/capabilities from the generated camel-k-catalog [\#737](https://github.com/apache/camel-k-runtime/pull/737) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: remove integration tests for kamelet-reify as they duplicate the tests on camel with no added value [\#736](https://github.com/apache/camel-k-runtime/pull/736) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(deps\): update to camel-quarkus 2.2.0 [\#735](https://github.com/apache/camel-k-runtime/pull/735) ([lburgazzoli](https://github.com/lburgazzoli))
- Added quarkus-logging-json as a runtime dependency [\#731](https://github.com/apache/camel-k-runtime/pull/731) ([orpiske](https://github.com/orpiske))
- build\(deps\): bump apache from 23 to 24 [\#729](https://github.com/apache/camel-k-runtime/pull/729) ([lburgazzoli](https://github.com/lburgazzoli))
- deps: update camel-quarkus to v2.1.0 [\#728](https://github.com/apache/camel-k-runtime/pull/728) ([lburgazzoli](https://github.com/lburgazzoli))
- build\(deps\): bump maven-enforcer-plugin from 3.0.0-M3 to 3.0.0 [\#727](https://github.com/apache/camel-k-runtime/pull/727) ([dependabot[bot]](https://github.com/apps/dependabot))

## [camel-k-runtime-project-1.8.0](https://github.com/apache/camel-k-runtime/tree/camel-k-runtime-project-1.8.0) (2021-07-02)

[Full Changelog](https://github.com/apache/camel-k-runtime/compare/camel-k-runtime-project-1.7.0...camel-k-runtime-project-1.8.0)

**Closed issues:**

- Flaky test: KnativeEnvFromRegistryTest [\#704](https://github.com/apache/camel-k-runtime/issues/704)
- Re-enable YamlSourceLoaderTest [\#687](https://github.com/apache/camel-k-runtime/issues/687)
- Remove camel-k-loader-yaml when upgradeing to camel 3.10 [\#679](https://github.com/apache/camel-k-runtime/issues/679)
- Remove camel-k-loader-groovy when upgradeing to camel 3.10 [\#678](https://github.com/apache/camel-k-runtime/issues/678)
- Missing Java type information causes camel-main build to fail [\#677](https://github.com/apache/camel-k-runtime/issues/677)
- Update runtime to Camel 3.10 and Camel Quarkus 2.x [\#669](https://github.com/apache/camel-k-runtime/issues/669)
- Remove camel-kamelet-reify when upgrading to Camel 3.10 [\#667](https://github.com/apache/camel-k-runtime/issues/667)
- Support for simple, linear integration definitions [\#659](https://github.com/apache/camel-k-runtime/issues/659)
- SourceType should not be null [\#658](https://github.com/apache/camel-k-runtime/issues/658)
- Remove RouteBuilder workaround when moving to Camel 3.10 onward [\#657](https://github.com/apache/camel-k-runtime/issues/657)
- Move WebhookRoutePolicyFactory to camel main [\#645](https://github.com/apache/camel-k-runtime/issues/645)
- Optional parameters in Kamelet route templates [\#631](https://github.com/apache/camel-k-runtime/issues/631)
- Duplicated loadUserProperties\(\) method call [\#625](https://github.com/apache/camel-k-runtime/issues/625)
- Assess integration container resources layout changes impacts [\#614](https://github.com/apache/camel-k-runtime/issues/614)
- Remove changelog gh action [\#582](https://github.com/apache/camel-k-runtime/issues/582)
- yaml dsl: add support for component dsl [\#507](https://github.com/apache/camel-k-runtime/issues/507)
- Add support for property mapping in Kamelets [\#495](https://github.com/apache/camel-k-runtime/issues/495)
- yaml dsl: add json schema for endpoint-dsl [\#485](https://github.com/apache/camel-k-runtime/issues/485)
- Include description for elements in Yaml schema [\#386](https://github.com/apache/camel-k-runtime/issues/386)

**Merged pull requests:**

- Upgrade to camel-quarkus 2.0.0 and camel 3.11.0 [\#723](https://github.com/apache/camel-k-runtime/pull/723) ([nicolaferraro](https://github.com/nicolaferraro))
- Remove duplicated WebhookRoutePolicyFactory \(gh issue \#645\) [\#722](https://github.com/apache/camel-k-runtime/pull/722) ([orpiske](https://github.com/orpiske))
- Reintroduces Qute component [\#721](https://github.com/apache/camel-k-runtime/pull/721) ([orpiske](https://github.com/orpiske))
- Merge Camel-3.10 and Camel Quarkus 2.x changes [\#720](https://github.com/apache/camel-k-runtime/pull/720) ([orpiske](https://github.com/orpiske))
- Remove preview flag from YAML docs [\#710](https://github.com/apache/camel-k-runtime/pull/710) ([heiko-braun](https://github.com/heiko-braun))
- build\(deps\): bump jandex-maven-plugin from 1.0.8 to 1.1.0 [\#699](https://github.com/apache/camel-k-runtime/pull/699) ([dependabot[bot]](https://github.com/apps/dependabot))
- fix\(core\): default SourceType as source [\#685](https://github.com/apache/camel-k-runtime/pull/685) ([squakez](https://github.com/squakez))
- build\(deps\): bump maven-javadoc-plugin from 3.2.0 to 3.3.0 [\#680](https://github.com/apache/camel-k-runtime/pull/680) ([dependabot[bot]](https://github.com/apps/dependabot))
- GH action fixes [\#674](https://github.com/apache/camel-k-runtime/pull/674) ([orpiske](https://github.com/orpiske))
- Enable GH actions on camel-main branch [\#671](https://github.com/apache/camel-k-runtime/pull/671) ([orpiske](https://github.com/orpiske))
- build\(deps\): bump spock-core from 2.0-M5-groovy-3.0 to 2.0-groovy-3.0 [\#668](https://github.com/apache/camel-k-runtime/pull/668) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump maven-gpg-plugin from 1.6 to 3.0.1 [\#666](https://github.com/apache/camel-k-runtime/pull/666) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump maven-plugin-annotations from 3.6.0 to 3.6.1 [\#665](https://github.com/apache/camel-k-runtime/pull/665) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump maven-plugin-plugin from 3.6.0 to 3.6.1 [\#664](https://github.com/apache/camel-k-runtime/pull/664) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump license-maven-plugin from 4.0 to 4.1 [\#663](https://github.com/apache/camel-k-runtime/pull/663) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add quarkus:dev option for running the examples [\#661](https://github.com/apache/camel-k-runtime/pull/661) ([tplevko](https://github.com/tplevko))

## [camel-k-runtime-project-1.7.0](https://github.com/apache/camel-k-runtime/tree/camel-k-runtime-project-1.7.0) (2021-04-16)

[Full Changelog](https://github.com/apache/camel-k-runtime/compare/camel-k-runtime-project-1.6.0...camel-k-runtime-project-1.7.0)

**Closed issues:**

- Missing camel-k-kamelet-reify version while building kamelet binding [\#655](https://github.com/apache/camel-k-runtime/issues/655)
- Cron loader fails to start [\#651](https://github.com/apache/camel-k-runtime/issues/651)
- Examples broken after the quarkus 1.7.0 update [\#641](https://github.com/apache/camel-k-runtime/issues/641)
- PR actions failing [\#626](https://github.com/apache/camel-k-runtime/issues/626)
- java-loader: use camel-joor when upgrading to camel 3.8 [\#615](https://github.com/apache/camel-k-runtime/issues/615)
- Make changelog action work again [\#612](https://github.com/apache/camel-k-runtime/issues/612)
- Malformed exception when using binary config map file into an integration [\#593](https://github.com/apache/camel-k-runtime/issues/593)
- Catalog contains duplicate entry for same schema \(cron\) [\#592](https://github.com/apache/camel-k-runtime/issues/592)
- Fix missing wrap component error in camelk catalog [\#589](https://github.com/apache/camel-k-runtime/issues/589)
- Cannot use kamelets in yaml integrations [\#581](https://github.com/apache/camel-k-runtime/issues/581)
- Catalog json keys should be sorted [\#576](https://github.com/apache/camel-k-runtime/issues/576)
- kamelet: move camel-kamelet component to the camel repo [\#517](https://github.com/apache/camel-k-runtime/issues/517)
- Thread blocked calling knative REST [\#513](https://github.com/apache/camel-k-runtime/issues/513)
- Support fast-jar packaging for quarkus [\#360](https://github.com/apache/camel-k-runtime/issues/360)
- HTTP multi-headers are randomized in camel-knative-http [\#69](https://github.com/apache/camel-k-runtime/issues/69)

**Merged pull requests:**

- fix\(core\): solve NPE when missing source type [\#660](https://github.com/apache/camel-k-runtime/pull/660) ([squakez](https://github.com/squakez))
- Missing camel-k-kamelet-reify version while building kamelet binding [\#656](https://github.com/apache/camel-k-runtime/pull/656) ([claudio4j](https://github.com/claudio4j))
- Yaml DSL: add workarounds for backward compatibility issues [\#654](https://github.com/apache/camel-k-runtime/pull/654) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(deps\): remove unused version properties [\#653](https://github.com/apache/camel-k-runtime/pull/653) ([lburgazzoli](https://github.com/lburgazzoli))
- Cron loader fails to start [\#652](https://github.com/apache/camel-k-runtime/pull/652) ([lburgazzoli](https://github.com/lburgazzoli))
- feat\(core\): default error handler [\#648](https://github.com/apache/camel-k-runtime/pull/648) ([squakez](https://github.com/squakez))
- build\(deps\): bump license-maven-plugin from 3.0 to 4.0 [\#647](https://github.com/apache/camel-k-runtime/pull/647) ([dependabot[bot]](https://github.com/apps/dependabot))
- Upgrade to camel-quarkus 1.8.0, camel 3.9.0 [\#646](https://github.com/apache/camel-k-runtime/pull/646) ([lburgazzoli](https://github.com/lburgazzoli))
- build\(deps-dev\): bump spock-core from 2.0-M4-groovy-3.0 to 2.0-M5-groovy-3.0 [\#644](https://github.com/apache/camel-k-runtime/pull/644) ([dependabot[bot]](https://github.com/apps/dependabot))
- fix\(examples\) - update path to runner.jar [\#643](https://github.com/apache/camel-k-runtime/pull/643) ([tplevko](https://github.com/tplevko))
- build\(deps\): bump maven-enforcer-plugin from 3.0.0-M2 to 3.0.0-M3 [\#640](https://github.com/apache/camel-k-runtime/pull/640) ([dependabot[bot]](https://github.com/apps/dependabot))
- Maven-Enforcer-plugin: Set the minimal maven version to 3.6.3 [\#639](https://github.com/apache/camel-k-runtime/pull/639) ([oscerd](https://github.com/oscerd))
- Upgrade Maven Enforce to 3.0.0-M2 [\#638](https://github.com/apache/camel-k-runtime/pull/638) ([oscerd](https://github.com/oscerd))
- Support fast-jar packaging for quarkus [\#637](https://github.com/apache/camel-k-runtime/pull/637) ([jamesnetherton](https://github.com/jamesnetherton))
- Bump to Kotlin 1.4.30 [\#636](https://github.com/apache/camel-k-runtime/pull/636) ([oscerd](https://github.com/oscerd))
- build\(deps\): bump maven-common-artifact-filters from 3.1.1 to 3.2.0 [\#635](https://github.com/apache/camel-k-runtime/pull/635) ([dependabot[bot]](https://github.com/apps/dependabot))
- Upgrade to camel-quarkus 1.7.0 \(camel 3.8.x, quarkus 1.12.x\) [\#633](https://github.com/apache/camel-k-runtime/pull/633) ([lburgazzoli](https://github.com/lburgazzoli))
- doc: run local camel k runtime [\#630](https://github.com/apache/camel-k-runtime/pull/630) ([squakez](https://github.com/squakez))
- build\(deps\): bump testcontainers from 1.15.1 to 1.15.2 [\#629](https://github.com/apache/camel-k-runtime/pull/629) ([dependabot[bot]](https://github.com/apps/dependabot))
- fix\(test\): bump testcontainers to 1.5.1 [\#627](https://github.com/apache/camel-k-runtime/pull/627) ([squakez](https://github.com/squakez))
- fix\(core\): skip malformed UTF-8 resources [\#624](https://github.com/apache/camel-k-runtime/pull/624) ([squakez](https://github.com/squakez))
- Kafka Source S3: Fixed README Markdown [\#623](https://github.com/apache/camel-k-runtime/pull/623) ([oscerd](https://github.com/oscerd))
- Cron Example: Fixed README Markdown [\#622](https://github.com/apache/camel-k-runtime/pull/622) ([oscerd](https://github.com/oscerd))
- Java Example: Fixed README Markdown [\#621](https://github.com/apache/camel-k-runtime/pull/621) ([oscerd](https://github.com/oscerd))
- Kafka source to AWS S3 Java Example [\#620](https://github.com/apache/camel-k-runtime/pull/620) ([oscerd](https://github.com/oscerd))
- Added README for cron example [\#619](https://github.com/apache/camel-k-runtime/pull/619) ([oscerd](https://github.com/oscerd))
- Add README to examples, java example [\#618](https://github.com/apache/camel-k-runtime/pull/618) ([oscerd](https://github.com/oscerd))
- Changelog action [\#613](https://github.com/apache/camel-k-runtime/pull/613) ([oscerd](https://github.com/oscerd))
- Revert "Test PR" [\#611](https://github.com/apache/camel-k-runtime/pull/611) ([oscerd](https://github.com/oscerd))
- Test PR [\#609](https://github.com/apache/camel-k-runtime/pull/609) ([oscerd](https://github.com/oscerd))
- build\(deps\): bump maven-checkstyle-plugin from 3.1.1 to 3.1.2 [\#608](https://github.com/apache/camel-k-runtime/pull/608) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump maven-common-artifact-filters from 3.1.0 to 3.1.1 [\#607](https://github.com/apache/camel-k-runtime/pull/607) ([dependabot[bot]](https://github.com/apps/dependabot))
- Update backport.yml [\#605](https://github.com/apache/camel-k-runtime/pull/605) ([oscerd](https://github.com/oscerd))
- Backport action [\#602](https://github.com/apache/camel-k-runtime/pull/602) ([oscerd](https://github.com/oscerd))
- Revert "Test PR" [\#600](https://github.com/apache/camel-k-runtime/pull/600) ([oscerd](https://github.com/oscerd))
- Fixed backport action [\#599](https://github.com/apache/camel-k-runtime/pull/599) ([oscerd](https://github.com/oscerd))
- Test PR [\#598](https://github.com/apache/camel-k-runtime/pull/598) ([oscerd](https://github.com/oscerd))
- Backport action  [\#597](https://github.com/apache/camel-k-runtime/pull/597) ([oscerd](https://github.com/oscerd))
- Github actions: Do not persist credentials for Checkout action [\#596](https://github.com/apache/camel-k-runtime/pull/596) ([oscerd](https://github.com/oscerd))
- Revert "Support fast-jar packaging for quarkus" [\#595](https://github.com/apache/camel-k-runtime/pull/595) ([jamesnetherton](https://github.com/jamesnetherton))
- Catalog contains duplicate entry for same schema [\#594](https://github.com/apache/camel-k-runtime/pull/594) ([lburgazzoli](https://github.com/lburgazzoli))
- loader\(java\): support for jshell scripts [\#591](https://github.com/apache/camel-k-runtime/pull/591) ([lburgazzoli](https://github.com/lburgazzoli))
- Fixes \#589, fixed kamelet-reify component scheme in CamelK catalog [\#590](https://github.com/apache/camel-k-runtime/pull/590) ([dhirajsb](https://github.com/dhirajsb))
- Support fast-jar packaging for quarkus [\#588](https://github.com/apache/camel-k-runtime/pull/588) ([jamesnetherton](https://github.com/jamesnetherton))
- update camel-quarkus to v1.6.0 [\#587](https://github.com/apache/camel-k-runtime/pull/587) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(actions\): switch to potiuk/cancel-workflow-runs [\#586](https://github.com/apache/camel-k-runtime/pull/586) ([lburgazzoli](https://github.com/lburgazzoli))
- Move CloudEvents related code to camel-cloudevents [\#585](https://github.com/apache/camel-k-runtime/pull/585) ([lburgazzoli](https://github.com/lburgazzoli))
- Catalog json keys should be sorted [\#584](https://github.com/apache/camel-k-runtime/pull/584) ([lburgazzoli](https://github.com/lburgazzoli))
- Cannot use kamelets in yaml integrations [\#583](https://github.com/apache/camel-k-runtime/pull/583) ([lburgazzoli](https://github.com/lburgazzoli))
- build\(deps\): bump gmavenplus-plugin from 1.12.0 to 1.12.1 [\#580](https://github.com/apache/camel-k-runtime/pull/580) ([dependabot[bot]](https://github.com/apps/dependabot))

## [camel-k-runtime-project-1.6.0](https://github.com/apache/camel-k-runtime/tree/camel-k-runtime-project-1.6.0) (2020-12-22)

[Full Changelog](https://github.com/apache/camel-k-runtime/compare/camel-k-runtime-parent-1.5.0...camel-k-runtime-project-1.6.0)

**Implemented enhancements:**

- knative: support configuring the knative environment using properties [\#506](https://github.com/apache/camel-k-runtime/issues/506)
- Fixes \#544: Kamelet component - optimize as we did for direct component [\#553](https://github.com/apache/camel-k-runtime/pull/553) ([davsclaus](https://github.com/davsclaus))

**Closed issues:**

- camel-kamelet: improve global properties handling [\#560](https://github.com/apache/camel-k-runtime/issues/560)
- Rename wrap component to kamelet-reify [\#556](https://github.com/apache/camel-k-runtime/issues/556)
- Error with leader election examples [\#548](https://github.com/apache/camel-k-runtime/issues/548)
- Kamelet component - optimize as we did for direct component [\#544](https://github.com/apache/camel-k-runtime/issues/544)
- Allow to programmatically enable a route [\#540](https://github.com/apache/camel-k-runtime/issues/540)
- Use default event type with broker [\#536](https://github.com/apache/camel-k-runtime/issues/536)
- Can't set Knative broker name [\#535](https://github.com/apache/camel-k-runtime/issues/535)
- Groovy - such property: DELEGATE\_FIRST when mapping beans [\#529](https://github.com/apache/camel-k-runtime/issues/529)
- knative: split producer and consumer transport to avoid requiring platorm-http also for the producer   [\#521](https://github.com/apache/camel-k-runtime/issues/521)
- Simplify examples  [\#422](https://github.com/apache/camel-k-runtime/issues/422)
- Switch to Quarkus as runtime  [\#359](https://github.com/apache/camel-k-runtime/issues/359)

**Merged pull requests:**

- chore: align kotlin libs to Quarkus release [\#577](https://github.com/apache/camel-k-runtime/pull/577) ([nicolaferraro](https://github.com/nicolaferraro))
- chore: enable new rebalacing features in customizer [\#575](https://github.com/apache/camel-k-runtime/pull/575) ([nicolaferraro](https://github.com/nicolaferraro))
- Update to camel 3.7.0 and camel-quarkus 1.5.0 [\#573](https://github.com/apache/camel-k-runtime/pull/573) ([lburgazzoli](https://github.com/lburgazzoli))
- build\(deps\): bump gmavenplus-plugin from 1.11.1 to 1.12.0 [\#572](https://github.com/apache/camel-k-runtime/pull/572) ([dependabot[bot]](https://github.com/apps/dependabot))
- Cleanup [\#571](https://github.com/apache/camel-k-runtime/pull/571) ([lburgazzoli](https://github.com/lburgazzoli))
- build\(deps\): bump kotlin-version from 1.4.20 to 1.4.21 [\#570](https://github.com/apache/camel-k-runtime/pull/570) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump groovy-version from 3.0.6 to 3.0.7 [\#569](https://github.com/apache/camel-k-runtime/pull/569) ([dependabot[bot]](https://github.com/apps/dependabot))
- Fix \#536: enable knative:event endpoints without path [\#568](https://github.com/apache/camel-k-runtime/pull/568) ([nicolaferraro](https://github.com/nicolaferraro))
- build\(deps\): bump gmavenplus-plugin from 1.11.0 to 1.11.1 [\#567](https://github.com/apache/camel-k-runtime/pull/567) ([dependabot[bot]](https://github.com/apps/dependabot))
- Fix https://github.com/apache/camel-k/issues/1813 [\#565](https://github.com/apache/camel-k-runtime/pull/565) ([nicolaferraro](https://github.com/nicolaferraro))
- build\(deps\): bump value from 2.8.8 to 2.8.9-ea-1 [\#562](https://github.com/apache/camel-k-runtime/pull/562) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump maven-pmd-plugin from 3.13.0 to 3.14.0 [\#561](https://github.com/apache/camel-k-runtime/pull/561) ([dependabot[bot]](https://github.com/apps/dependabot))
- Update to camel-quarkus 1.4.0 and quarkus 1.10.0.Final [\#559](https://github.com/apache/camel-k-runtime/pull/559) ([lburgazzoli](https://github.com/lburgazzoli))
- build\(deps\): bump kotlin-version from 1.4.10 to 1.4.20 [\#558](https://github.com/apache/camel-k-runtime/pull/558) ([dependabot[bot]](https://github.com/apps/dependabot))
- Fixes \#556, Renamed wrap component to kamelet-reify [\#557](https://github.com/apache/camel-k-runtime/pull/557) ([dhirajsb](https://github.com/dhirajsb))
- knative: fix wrong dependencies [\#555](https://github.com/apache/camel-k-runtime/pull/555) ([lburgazzoli](https://github.com/lburgazzoli))
- knative: support configuring the knative environment using properties [\#554](https://github.com/apache/camel-k-runtime/pull/554) ([lburgazzoli](https://github.com/lburgazzoli))
- Cleanup extensions [\#552](https://github.com/apache/camel-k-runtime/pull/552) ([lburgazzoli](https://github.com/lburgazzoli))
- knative: split producer and consumer [\#551](https://github.com/apache/camel-k-runtime/pull/551) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(ci\): temporarily disable flacky jobs [\#550](https://github.com/apache/camel-k-runtime/pull/550) ([nicolaferraro](https://github.com/nicolaferraro))
- Error with leader election examples [\#549](https://github.com/apache/camel-k-runtime/pull/549) ([lburgazzoli](https://github.com/lburgazzoli))
- Cleanup examples [\#547](https://github.com/apache/camel-k-runtime/pull/547) ([lburgazzoli](https://github.com/lburgazzoli))
- Leveragte MP Config to load application and user properties [\#546](https://github.com/apache/camel-k-runtime/pull/546) ([lburgazzoli](https://github.com/lburgazzoli))
- Switch to Quarkus as runtime \#359 [\#543](https://github.com/apache/camel-k-runtime/pull/543) ([lburgazzoli](https://github.com/lburgazzoli))
- build\(deps-dev\): bump spock-core from 2.0-M3-groovy-3.0 to 2.0-M4-groovy-3.0 [\#542](https://github.com/apache/camel-k-runtime/pull/542) ([dependabot[bot]](https://github.com/apps/dependabot))
- kamelet: ensure URL encoded values is properly handled [\#541](https://github.com/apache/camel-k-runtime/pull/541) ([lburgazzoli](https://github.com/lburgazzoli))
- Can't set Knative broker name [\#539](https://github.com/apache/camel-k-runtime/pull/539) ([lburgazzoli](https://github.com/lburgazzoli))
- build\(actions\): cancel stale workflow runs [\#537](https://github.com/apache/camel-k-runtime/pull/537) ([lburgazzoli](https://github.com/lburgazzoli))
- kamelet: use raw url [\#534](https://github.com/apache/camel-k-runtime/pull/534) ([lburgazzoli](https://github.com/lburgazzoli))
- kamelet: ensure properties are correctly propagated to the route template engine [\#533](https://github.com/apache/camel-k-runtime/pull/533) ([lburgazzoli](https://github.com/lburgazzoli))
- Groovy - such property: DELEGATE\_FIRST when mapping beans [\#532](https://github.com/apache/camel-k-runtime/pull/532) ([lburgazzoli](https://github.com/lburgazzoli))
- yaml: auto wrap secret values wit RAW [\#531](https://github.com/apache/camel-k-runtime/pull/531) ([lburgazzoli](https://github.com/lburgazzoli))
- Automatic changelog: Remove deprecated github action commands [\#530](https://github.com/apache/camel-k-runtime/pull/530) ([oscerd](https://github.com/oscerd))
- update to camel-quarkus 1.3.0 [\#528](https://github.com/apache/camel-k-runtime/pull/528) ([lburgazzoli](https://github.com/lburgazzoli))
- Jenkinsfile build: changed the JDK name following INFRA new approach [\#527](https://github.com/apache/camel-k-runtime/pull/527) ([oscerd](https://github.com/oscerd))
- Add workflow dispatch to changelog gh action [\#525](https://github.com/apache/camel-k-runtime/pull/525) ([oscerd](https://github.com/oscerd))
- build\(deps\): bump gmavenplus-plugin from 1.10.1 to 1.11.0 [\#524](https://github.com/apache/camel-k-runtime/pull/524) ([dependabot[bot]](https://github.com/apps/dependabot))
- fix: Update loggers after configuration [\#523](https://github.com/apache/camel-k-runtime/pull/523) ([christophd](https://github.com/christophd))

## [camel-k-runtime-parent-1.5.0](https://github.com/apache/camel-k-runtime/tree/camel-k-runtime-parent-1.5.0) (2020-10-08)

[Full Changelog](https://github.com/apache/camel-k-runtime/compare/camel-k-runtime-parent-1.4.1...camel-k-runtime-parent-1.5.0)

**Implemented enhancements:**

- Remove suport for "configuration" classes [\#480](https://github.com/apache/camel-k-runtime/issues/480)
- Support endpoint DSL in YAML/JSON [\#366](https://github.com/apache/camel-k-runtime/issues/366)

**Closed issues:**

- Log runtime version when starting [\#512](https://github.com/apache/camel-k-runtime/issues/512)
- Sink Kamelet not called [\#500](https://github.com/apache/camel-k-runtime/issues/500)
- Failed to start Kamelet [\#493](https://github.com/apache/camel-k-runtime/issues/493)
- Fix kamelet entry in catalog [\#492](https://github.com/apache/camel-k-runtime/issues/492)
- Add a kamelet catalog entry [\#491](https://github.com/apache/camel-k-runtime/issues/491)
- kamelet-sink component [\#490](https://github.com/apache/camel-k-runtime/issues/490)
- yaml dsl: document how to create beans using YAML [\#487](https://github.com/apache/camel-k-runtime/issues/487)
- yaml dsl: add documentation for endpoint-dsl support [\#484](https://github.com/apache/camel-k-runtime/issues/484)
- Create an extension fot camel-k-runtime-master [\#470](https://github.com/apache/camel-k-runtime/issues/470)
- Use camel-dependencies instead of our own [\#459](https://github.com/apache/camel-k-runtime/issues/459)
- knative: support for programmatically add entries to the knative environment [\#454](https://github.com/apache/camel-k-runtime/issues/454)
- knative: refactor knative environment definition [\#453](https://github.com/apache/camel-k-runtime/issues/453)
- Invalid example on yaml language docu [\#423](https://github.com/apache/camel-k-runtime/issues/423)
- \[yaml\] support for configuring beans with the yaml dsl [\#376](https://github.com/apache/camel-k-runtime/issues/376)
- kamelets: create a camel-kamelet component [\#375](https://github.com/apache/camel-k-runtime/issues/375)
- Document Knative component [\#247](https://github.com/apache/camel-k-runtime/issues/247)
- \[quarkus\] add tests for jvm only loaders [\#215](https://github.com/apache/camel-k-runtime/issues/215)
- add support for component customizer [\#58](https://github.com/apache/camel-k-runtime/issues/58)

**Merged pull requests:**

- build\(deps\): bump junit-pioneer from 0.9.2 to 1.0.0 [\#522](https://github.com/apache/camel-k-runtime/pull/522) ([dependabot[bot]](https://github.com/apps/dependabot))
- knative: cleanup knative environment definition leftovers [\#520](https://github.com/apache/camel-k-runtime/pull/520) ([lburgazzoli](https://github.com/lburgazzoli))
- knative\(http\): fix request handler exception handling [\#519](https://github.com/apache/camel-k-runtime/pull/519) ([lburgazzoli](https://github.com/lburgazzoli))
- Log runtime version when starting [\#518](https://github.com/apache/camel-k-runtime/pull/518) ([lburgazzoli](https://github.com/lburgazzoli))
- knative\(http\): use async processor to process http requests [\#516](https://github.com/apache/camel-k-runtime/pull/516) ([lburgazzoli](https://github.com/lburgazzoli))
- build\(deps\): bump junit-pioneer from 0.9.1 to 0.9.2 [\#515](https://github.com/apache/camel-k-runtime/pull/515) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump groovy-version from 3.0.5 to 3.0.6 [\#514](https://github.com/apache/camel-k-runtime/pull/514) ([dependabot[bot]](https://github.com/apps/dependabot))
- kamelet source/sink component [\#511](https://github.com/apache/camel-k-runtime/pull/511) ([lburgazzoli](https://github.com/lburgazzoli))
- build\(deps\): bump junit-pioneer from 0.9.0 to 0.9.1 [\#510](https://github.com/apache/camel-k-runtime/pull/510) ([dependabot[bot]](https://github.com/apps/dependabot))
- Fixes changelog to run only on master [\#509](https://github.com/apache/camel-k-runtime/pull/509) ([oscerd](https://github.com/oscerd))
- yaml dsl: add documentation for endpoint-dsl support [\#508](https://github.com/apache/camel-k-runtime/pull/508) ([lburgazzoli](https://github.com/lburgazzoli))
- build: deploy to ASF snapshots from GitHub Actions [\#505](https://github.com/apache/camel-k-runtime/pull/505) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(build\): add virtual deps to quarkus itests to ensure test have correct dependency tree on deployment artifacts [\#504](https://github.com/apache/camel-k-runtime/pull/504) ([lburgazzoli](https://github.com/lburgazzoli))
- Create a wrap component to wrap single tenant component [\#503](https://github.com/apache/camel-k-runtime/pull/503) ([lburgazzoli](https://github.com/lburgazzoli))
- Sink Kamelet not called [\#502](https://github.com/apache/camel-k-runtime/pull/502) ([lburgazzoli](https://github.com/lburgazzoli))
- knative: refactor knative environment definition [\#501](https://github.com/apache/camel-k-runtime/pull/501) ([lburgazzoli](https://github.com/lburgazzoli))
- quarkus: consolidate kamelet integration tests [\#499](https://github.com/apache/camel-k-runtime/pull/499) ([lburgazzoli](https://github.com/lburgazzoli))
- quarkus: consolidate knative its [\#498](https://github.com/apache/camel-k-runtime/pull/498) ([lburgazzoli](https://github.com/lburgazzoli))
- quarkus: add integration tests for knative [\#497](https://github.com/apache/camel-k-runtime/pull/497) ([lburgazzoli](https://github.com/lburgazzoli))
- Failed to start Kamelet [\#496](https://github.com/apache/camel-k-runtime/pull/496) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix kamelet entry in catalog [\#494](https://github.com/apache/camel-k-runtime/pull/494) ([lburgazzoli](https://github.com/lburgazzoli))
- yaml dsl: document how to create beans using YAML [\#489](https://github.com/apache/camel-k-runtime/pull/489) ([lburgazzoli](https://github.com/lburgazzoli))
- build\(deps\): bump gmavenplus-plugin from 1.10.0 to 1.10.1 [\#488](https://github.com/apache/camel-k-runtime/pull/488) ([dependabot[bot]](https://github.com/apps/dependabot))
- Support endpoint DSL in YAML/JSON [\#486](https://github.com/apache/camel-k-runtime/pull/486) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(build\): use dependency management for dependencies and plugins [\#483](https://github.com/apache/camel-k-runtime/pull/483) ([lburgazzoli](https://github.com/lburgazzoli))
- Document Knative component [\#482](https://github.com/apache/camel-k-runtime/pull/482) ([lburgazzoli](https://github.com/lburgazzoli))
- Remove suport for configuration classes [\#481](https://github.com/apache/camel-k-runtime/pull/481) ([lburgazzoli](https://github.com/lburgazzoli))
- quarkus: disable routes discovery as routes are programmatically added [\#479](https://github.com/apache/camel-k-runtime/pull/479) ([lburgazzoli](https://github.com/lburgazzoli))
- loaders: simplify source loader interceptors [\#478](https://github.com/apache/camel-k-runtime/pull/478) ([lburgazzoli](https://github.com/lburgazzoli))
- Quarkus runtime improvements [\#477](https://github.com/apache/camel-k-runtime/pull/477) ([lburgazzoli](https://github.com/lburgazzoli))
- quarkus: improve runtime set-up [\#476](https://github.com/apache/camel-k-runtime/pull/476) ([lburgazzoli](https://github.com/lburgazzoli))
- Generate Configurer to bind properties SourceLoader.Interceptor without the need for reflection [\#475](https://github.com/apache/camel-k-runtime/pull/475) ([lburgazzoli](https://github.com/lburgazzoli))
- \[yaml\] support for configuring beans with the yaml dsl [\#474](https://github.com/apache/camel-k-runtime/pull/474) ([lburgazzoli](https://github.com/lburgazzoli))
- Generate Configurer to bind properties to Customizers without the need for reflection [\#473](https://github.com/apache/camel-k-runtime/pull/473) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(build\): enable native tests for js loader [\#472](https://github.com/apache/camel-k-runtime/pull/472) ([lburgazzoli](https://github.com/lburgazzoli))
- Create an extension fot camel-k-runtime-master [\#471](https://github.com/apache/camel-k-runtime/pull/471) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix PMD and checkstyle violations [\#469](https://github.com/apache/camel-k-runtime/pull/469) ([lburgazzoli](https://github.com/lburgazzoli))
- Switch from Gitter to Zulip [\#468](https://github.com/apache/camel-k-runtime/pull/468) ([lburgazzoli](https://github.com/lburgazzoli))
- build\(deps\): bump kotlin-version from 1.4.0 to 1.4.10 [\#467](https://github.com/apache/camel-k-runtime/pull/467) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump jaeger-client from 1.3.2 to 1.4.0 [\#466](https://github.com/apache/camel-k-runtime/pull/466) ([dependabot[bot]](https://github.com/apps/dependabot))
- Automatic changelog: Let's run during the night just one time [\#465](https://github.com/apache/camel-k-runtime/pull/465) ([oscerd](https://github.com/oscerd))
- Changelog updater: run every hour [\#464](https://github.com/apache/camel-k-runtime/pull/464) ([oscerd](https://github.com/oscerd))
- Use camel-dependencies instead of our own [\#463](https://github.com/apache/camel-k-runtime/pull/463) ([lburgazzoli](https://github.com/lburgazzoli))
- loaders: add itest for kotlin on quarkus [\#462](https://github.com/apache/camel-k-runtime/pull/462) ([lburgazzoli](https://github.com/lburgazzoli))
- Cleanup dependencies [\#461](https://github.com/apache/camel-k-runtime/pull/461) ([lburgazzoli](https://github.com/lburgazzoli))
- Added an automatic changelog gh action [\#460](https://github.com/apache/camel-k-runtime/pull/460) ([oscerd](https://github.com/oscerd))
- Upgrade Assertj to version 3.17.1 [\#457](https://github.com/apache/camel-k-runtime/pull/457) ([oscerd](https://github.com/oscerd))
- Kamelets [\#456](https://github.com/apache/camel-k-runtime/pull/456) ([lburgazzoli](https://github.com/lburgazzoli))
- build\(deps\): bump assertj-core from 3.16.1 to 3.17.0 [\#455](https://github.com/apache/camel-k-runtime/pull/455) ([dependabot[bot]](https://github.com/apps/dependabot))
- Invalid example on yaml language docu [\#452](https://github.com/apache/camel-k-runtime/pull/452) ([lburgazzoli](https://github.com/lburgazzoli))
- build\(ci\): Ignore some paths on the PR validate workflow [\#451](https://github.com/apache/camel-k-runtime/pull/451) ([jamesnetherton](https://github.com/jamesnetherton))
- chore: Minor docs & code sample fixes [\#450](https://github.com/apache/camel-k-runtime/pull/450) ([jamesnetherton](https://github.com/jamesnetherton))
- build\(deps\): bump maven-site-plugin from 3.9.0 to 3.9.1 [\#449](https://github.com/apache/camel-k-runtime/pull/449) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump javapoet from 1.11.1 to 1.13.0 [\#448](https://github.com/apache/camel-k-runtime/pull/448) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump apache from 21 to 23 [\#447](https://github.com/apache/camel-k-runtime/pull/447) ([dependabot[bot]](https://github.com/apps/dependabot))
- Loaders [\#446](https://github.com/apache/camel-k-runtime/pull/446) ([lburgazzoli](https://github.com/lburgazzoli))
- kotlin: cleanup loader and tests [\#445](https://github.com/apache/camel-k-runtime/pull/445) ([lburgazzoli](https://github.com/lburgazzoli))
- xml: cleanup loader and tests [\#444](https://github.com/apache/camel-k-runtime/pull/444) ([lburgazzoli](https://github.com/lburgazzoli))
- Update groovy.adoc [\#443](https://github.com/apache/camel-k-runtime/pull/443) ([PoojaChandak](https://github.com/PoojaChandak))
- js: cleanup loader and tests [\#442](https://github.com/apache/camel-k-runtime/pull/442) ([lburgazzoli](https://github.com/lburgazzoli))
- java: cleanup loader and tests [\#441](https://github.com/apache/camel-k-runtime/pull/441) ([lburgazzoli](https://github.com/lburgazzoli))
- groovy: cleanup loader and tests [\#440](https://github.com/apache/camel-k-runtime/pull/440) ([lburgazzoli](https://github.com/lburgazzoli))
- build\(deps\): bump jaeger-client from 1.2.0 to 1.3.2 [\#439](https://github.com/apache/camel-k-runtime/pull/439) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump exec-maven-plugin from 1.6.0 to 3.0.0 [\#438](https://github.com/apache/camel-k-runtime/pull/438) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump maven-remote-resources-plugin from 1.5 to 1.7.0 [\#437](https://github.com/apache/camel-k-runtime/pull/437) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(ci\): build on push and skip build for some paths [\#436](https://github.com/apache/camel-k-runtime/pull/436) ([lburgazzoli](https://github.com/lburgazzoli))
- build\(deps\): add junit-pioneer to ease test that require env vars or properties [\#435](https://github.com/apache/camel-k-runtime/pull/435) ([lburgazzoli](https://github.com/lburgazzoli))
- build\(deps\): bump jaxb-api from 2.3.0 to 2.3.1 [\#434](https://github.com/apache/camel-k-runtime/pull/434) ([dependabot[bot]](https://github.com/apps/dependabot))
- build\(deps\): bump gmavenplus-plugin from 1.9.0 to 1.10.0 [\#433](https://github.com/apache/camel-k-runtime/pull/433) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump maven-assembly-plugin from 3.2.0 to 3.3.0 [\#430](https://github.com/apache/camel-k-runtime/pull/430) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add dependabot [\#428](https://github.com/apache/camel-k-runtime/pull/428) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(build\): tune and enable pmd on sourcecheck profile [\#427](https://github.com/apache/camel-k-runtime/pull/427) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(deps\): update kotlin to v1.4.0 [\#426](https://github.com/apache/camel-k-runtime/pull/426) ([lburgazzoli](https://github.com/lburgazzoli))
- PMD [\#424](https://github.com/apache/camel-k-runtime/pull/424) ([lburgazzoli](https://github.com/lburgazzoli))
- \[quarkus\] add tests for jvm only loaders [\#421](https://github.com/apache/camel-k-runtime/pull/421) ([lburgazzoli](https://github.com/lburgazzoli))
- Update maven plugin dependencies [\#420](https://github.com/apache/camel-k-runtime/pull/420) ([lburgazzoli](https://github.com/lburgazzoli))
- Fixed properties test to use correct way of main configurations [\#419](https://github.com/apache/camel-k-runtime/pull/419) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgrade to camel-quarkus v1.0.0 [\#418](https://github.com/apache/camel-k-runtime/pull/418) ([lburgazzoli](https://github.com/lburgazzoli))
- Disable merge commits on pull requests [\#417](https://github.com/apache/camel-k-runtime/pull/417) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#394: unable to run Groovy routes on Quarkus [\#415](https://github.com/apache/camel-k-runtime/pull/415) ([nicolaferraro](https://github.com/nicolaferraro))
- Upgrade Jackson to version 2.10.5 [\#413](https://github.com/apache/camel-k-runtime/pull/413) ([oscerd](https://github.com/oscerd))
- Update commons text to version 1.9 [\#412](https://github.com/apache/camel-k-runtime/pull/412) ([oscerd](https://github.com/oscerd))
- Fix \#365: change sinkbinding to be a customizer unrelated to the knat… [\#411](https://github.com/apache/camel-k-runtime/pull/411) ([nicolaferraro](https://github.com/nicolaferraro))
- chore\(test\): cleanup yaml unit tests [\#410](https://github.com/apache/camel-k-runtime/pull/410) ([lburgazzoli](https://github.com/lburgazzoli))
- Update groovy to v3.0.5 [\#409](https://github.com/apache/camel-k-runtime/pull/409) ([lburgazzoli](https://github.com/lburgazzoli))

## [camel-k-runtime-parent-1.4.1](https://github.com/apache/camel-k-runtime/tree/camel-k-runtime-parent-1.4.1) (2020-07-21)

[Full Changelog](https://github.com/apache/camel-k-runtime/compare/camel-k-runtime-parent-1.4.0...camel-k-runtime-parent-1.4.1)

**Closed issues:**

- camel-knative: don't replace message when the producers completes [\#399](https://github.com/apache/camel-k-runtime/issues/399)
- Unable to run kotlin routes with quarkus [\#394](https://github.com/apache/camel-k-runtime/issues/394)
- Property substitution doesn't happen in from URI [\#392](https://github.com/apache/camel-k-runtime/issues/392)
- No type converter warning if final type of body is java.util.Map [\#390](https://github.com/apache/camel-k-runtime/issues/390)
- publish the camel-k yaml dsl schema as artifact [\#389](https://github.com/apache/camel-k-runtime/issues/389)
- publish the camel-k catalog as artifact [\#388](https://github.com/apache/camel-k-runtime/issues/388)
- Include a test collecting all \*.camelk.yaml files in the repository and validating it against the yaml schema [\#387](https://github.com/apache/camel-k-runtime/issues/387)

**Merged pull requests:**

- chore\(release\): decrease version to 1.4.1-SNAPSHOT [\#408](https://github.com/apache/camel-k-runtime/pull/408) ([nicolaferraro](https://github.com/nicolaferraro))
- Upgrade Commons Lang to version 3.11 [\#407](https://github.com/apache/camel-k-runtime/pull/407) ([oscerd](https://github.com/oscerd))
- Upgrade Vertx to version 3.9.2 [\#406](https://github.com/apache/camel-k-runtime/pull/406) ([oscerd](https://github.com/oscerd))
- chore\(deps\): update vert.x to v3.9.1 [\#405](https://github.com/apache/camel-k-runtime/pull/405) ([lburgazzoli](https://github.com/lburgazzoli))
- \[kotlin\] compile scripts wit the same target level used to compile the loader [\#404](https://github.com/apache/camel-k-runtime/pull/404) ([lburgazzoli](https://github.com/lburgazzoli))
- Bump Jandex to 2.2.1.Final [\#403](https://github.com/apache/camel-k-runtime/pull/403) ([oscerd](https://github.com/oscerd))
- Include a test collecting all \*.camelk.yaml files in the repository and validating it against the yaml schema [\#402](https://github.com/apache/camel-k-runtime/pull/402) ([lburgazzoli](https://github.com/lburgazzoli))
- publish the camel-k catalog as artifact [\#401](https://github.com/apache/camel-k-runtime/pull/401) ([lburgazzoli](https://github.com/lburgazzoli))
- camel-knative: don't replace message when the producers completes [\#400](https://github.com/apache/camel-k-runtime/pull/400) ([lburgazzoli](https://github.com/lburgazzoli))
- publish the camel-k yaml dsl schema as artifact \#389 [\#398](https://github.com/apache/camel-k-runtime/pull/398) ([lburgazzoli](https://github.com/lburgazzoli))
- \[js\] use proxy for global bindings [\#397](https://github.com/apache/camel-k-runtime/pull/397) ([lburgazzoli](https://github.com/lburgazzoli))
- No type converter warning if final type of body is java.util.Map [\#396](https://github.com/apache/camel-k-runtime/pull/396) ([lburgazzoli](https://github.com/lburgazzoli))
- Unable to run kotlin routes with quarkus [\#395](https://github.com/apache/camel-k-runtime/pull/395) ([lburgazzoli](https://github.com/lburgazzoli))
- Property substitution doesn't happen in from URI [\#393](https://github.com/apache/camel-k-runtime/pull/393) ([lburgazzoli](https://github.com/lburgazzoli))

## [camel-k-runtime-parent-1.4.0](https://github.com/apache/camel-k-runtime/tree/camel-k-runtime-parent-1.4.0) (2020-07-13)

[Full Changelog](https://github.com/apache/camel-k-runtime/compare/camel-k-runtime-parent-1.3.0...camel-k-runtime-parent-1.4.0)

**Implemented enhancements:**

- camel-knative: add support for lookup service definition from the registry [\#371](https://github.com/apache/camel-k-runtime/issues/371)
- camel-knative: add support for overriding Cloud Event fields in knative environment [\#370](https://github.com/apache/camel-k-runtime/issues/370)
- camel-knative: add support for URL in knative environment [\#369](https://github.com/apache/camel-k-runtime/issues/369)
- Add runtime support for Knative sinkbinding [\#365](https://github.com/apache/camel-k-runtime/issues/365)
- Integration should fail when no secret is found [\#363](https://github.com/apache/camel-k-runtime/issues/363)

**Closed issues:**

- Event-loop blocked when using http component starting from knative [\#383](https://github.com/apache/camel-k-runtime/issues/383)
- Create a CompositeClassloader and set is as Camel's ApplicationClassloader [\#364](https://github.com/apache/camel-k-runtime/issues/364)
- Injecting a CDI bean managed by Quarkus into Camel K routes leads to a null reference [\#362](https://github.com/apache/camel-k-runtime/issues/362)
- Upgrade to Camel 3.4 [\#361](https://github.com/apache/camel-k-runtime/issues/361)
- Generate schema for YAML DSL [\#358](https://github.com/apache/camel-k-runtime/issues/358)
- Use the new camel-component-maven-plugin from Camel 3.4 [\#357](https://github.com/apache/camel-k-runtime/issues/357)
- Quarkus application becomes ready before routes are bound [\#262](https://github.com/apache/camel-k-runtime/issues/262)

**Merged pull requests:**

- chore\(release\): bump version to 1.4.0-SNAPSHOT [\#391](https://github.com/apache/camel-k-runtime/pull/391) ([nicolaferraro](https://github.com/nicolaferraro))
- \[yaml\] cleanup schema generator leftovers [\#385](https://github.com/apache/camel-k-runtime/pull/385) ([lburgazzoli](https://github.com/lburgazzoli))
- Use the new camel-component-maven-plugin from Camel 3.4 [\#384](https://github.com/apache/camel-k-runtime/pull/384) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgrade Rest Assured to version 4.3.1 [\#382](https://github.com/apache/camel-k-runtime/pull/382) ([oscerd](https://github.com/oscerd))
- chore\(ci\): replace joschi/setup-jdk with AdoptOpenJDK/install-jdk [\#381](https://github.com/apache/camel-k-runtime/pull/381) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgrade to Camel 3.4 [\#380](https://github.com/apache/camel-k-runtime/pull/380) ([lburgazzoli](https://github.com/lburgazzoli))
- Bump Build Helper Maven plugin to version 3.2.0 [\#379](https://github.com/apache/camel-k-runtime/pull/379) ([oscerd](https://github.com/oscerd))
- Generate schema for YAML DSL [\#378](https://github.com/apache/camel-k-runtime/pull/378) ([lburgazzoli](https://github.com/lburgazzoli))
- Bump maven failsafe plugin to version 3.0.0-M5 [\#374](https://github.com/apache/camel-k-runtime/pull/374) ([oscerd](https://github.com/oscerd))
- Bump Surefire to version 3.0.0-M5 [\#373](https://github.com/apache/camel-k-runtime/pull/373) ([oscerd](https://github.com/oscerd))
- Add runtime support for Knative sinkbinding [\#372](https://github.com/apache/camel-k-runtime/pull/372) ([lburgazzoli](https://github.com/lburgazzoli))
- Create a CompositeClassloader and set is as Camel's ApplicationClassloader [\#368](https://github.com/apache/camel-k-runtime/pull/368) ([lburgazzoli](https://github.com/lburgazzoli))
- Integration should fail when no secret is found [\#367](https://github.com/apache/camel-k-runtime/pull/367) ([lburgazzoli](https://github.com/lburgazzoli))

## [camel-k-runtime-parent-1.3.0](https://github.com/apache/camel-k-runtime/tree/camel-k-runtime-parent-1.3.0) (2020-06-05)

[Full Changelog](https://github.com/apache/camel-k-runtime/compare/camel-k-runtime-parent-1.2.1...camel-k-runtime-parent-1.3.0)

**Implemented enhancements:**

- Leverage platform http service in camel-knative [\#264](https://github.com/apache/camel-k-runtime/issues/264)

**Closed issues:**

- mark JavaScipt DSL as experimental [\#349](https://github.com/apache/camel-k-runtime/issues/349)
- Can't run the API example on Quarkus [\#348](https://github.com/apache/camel-k-runtime/issues/348)
- Camel-quartz fails on Quarkus because of missing \(optional\) camel-cron dependency [\#346](https://github.com/apache/camel-k-runtime/issues/346)
- 'context' object not available in JavaScript integrations  [\#340](https://github.com/apache/camel-k-runtime/issues/340)
- yaml-loader: add support for error handler [\#339](https://github.com/apache/camel-k-runtime/issues/339)
- Upgrade to Camel 3.3 [\#338](https://github.com/apache/camel-k-runtime/issues/338)
- Improve knative broker integration [\#326](https://github.com/apache/camel-k-runtime/issues/326)
- Add a way to easily call a bean method after camel has started [\#324](https://github.com/apache/camel-k-runtime/issues/324)
- Update camel-quarkus to v1.0.0-M7 [\#316](https://github.com/apache/camel-k-runtime/issues/316)
- Set camel.k.customizer as base property for customizer  [\#305](https://github.com/apache/camel-k-runtime/issues/305)
- Add more EIPS to YAML DSL [\#303](https://github.com/apache/camel-k-runtime/issues/303)
- Can't get response from platform HTTP [\#301](https://github.com/apache/camel-k-runtime/issues/301)
- Cannot build using JDK8 [\#298](https://github.com/apache/camel-k-runtime/issues/298)
- Remove workaround for for platform-http when upgradeing to camel 3.2.0 [\#291](https://github.com/apache/camel-k-runtime/issues/291)
- Add an opentracing capability [\#289](https://github.com/apache/camel-k-runtime/issues/289)
- Add a check to ensure Maven 3.6.3+ is used [\#277](https://github.com/apache/camel-k-runtime/issues/277)
- Default to Java 11 [\#274](https://github.com/apache/camel-k-runtime/issues/274)
- Cannot find RestApiConsumerFactory [\#267](https://github.com/apache/camel-k-runtime/issues/267)
- Adding a restConfiguration\(\) make all rest properties to be ignored [\#266](https://github.com/apache/camel-k-runtime/issues/266)
- create platform http service [\#265](https://github.com/apache/camel-k-runtime/issues/265)
- Cannot run openapi in quarkus mode [\#258](https://github.com/apache/camel-k-runtime/issues/258)
- Add circuit-breaker capability [\#257](https://github.com/apache/camel-k-runtime/issues/257)
- \[quarkus\] support stopping the application [\#224](https://github.com/apache/camel-k-runtime/issues/224)
- Complete support for EIP in YAML DSL [\#183](https://github.com/apache/camel-k-runtime/issues/183)
- Support CloudEvents v1.0.0 [\#179](https://github.com/apache/camel-k-runtime/issues/179)

**Merged pull requests:**

- chore: remove meaningless log statement [\#356](https://github.com/apache/camel-k-runtime/pull/356) ([lburgazzoli](https://github.com/lburgazzoli))
- tracing: support configuring the jeager service name [\#355](https://github.com/apache/camel-k-runtime/pull/355) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(pgp\): update key for Nicola Ferraro [\#354](https://github.com/apache/camel-k-runtime/pull/354) ([nicolaferraro](https://github.com/nicolaferraro))
- Add an opentracing capability [\#353](https://github.com/apache/camel-k-runtime/pull/353) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgrade Jackson to version 2.10.4 [\#352](https://github.com/apache/camel-k-runtime/pull/352) ([oscerd](https://github.com/oscerd))
- Bump AssertJ to version 3.16.1 [\#351](https://github.com/apache/camel-k-runtime/pull/351) ([oscerd](https://github.com/oscerd))
- Add circuit-breaker capability [\#350](https://github.com/apache/camel-k-runtime/pull/350) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgrade to Camel 3.3.0 and camel-quarkus 1.0.0.CR2 [\#347](https://github.com/apache/camel-k-runtime/pull/347) ([lburgazzoli](https://github.com/lburgazzoli))
- kotlin-loader: add error handler support to the dsl [\#345](https://github.com/apache/camel-k-runtime/pull/345) ([lburgazzoli](https://github.com/lburgazzoli))
- js-loader: add error handler support to the dsl [\#344](https://github.com/apache/camel-k-runtime/pull/344) ([lburgazzoli](https://github.com/lburgazzoli))
- groovy-loader: add error handler support to the dsl [\#343](https://github.com/apache/camel-k-runtime/pull/343) ([lburgazzoli](https://github.com/lburgazzoli))
- 'context' object not available in JavaScript integrations [\#342](https://github.com/apache/camel-k-runtime/pull/342) ([lburgazzoli](https://github.com/lburgazzoli))
- yaml-loader: add support for error handler [\#341](https://github.com/apache/camel-k-runtime/pull/341) ([lburgazzoli](https://github.com/lburgazzoli))
- yaml-loader: add support for OnException [\#337](https://github.com/apache/camel-k-runtime/pull/337) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgrade Groovy to version 3.0.4 [\#336](https://github.com/apache/camel-k-runtime/pull/336) ([oscerd](https://github.com/oscerd))
- Code cleanup [\#335](https://github.com/apache/camel-k-runtime/pull/335) ([lburgazzoli](https://github.com/lburgazzoli))
- Generate customizers metatdata with APT [\#334](https://github.com/apache/camel-k-runtime/pull/334) ([lburgazzoli](https://github.com/lburgazzoli))
- Regen [\#333](https://github.com/apache/camel-k-runtime/pull/333) ([lburgazzoli](https://github.com/lburgazzoli))
- Remove RoutesDumper as the same functionnality is implemented by camel-main [\#332](https://github.com/apache/camel-k-runtime/pull/332) ([lburgazzoli](https://github.com/lburgazzoli))
- examples: improve knative example [\#331](https://github.com/apache/camel-k-runtime/pull/331) ([lburgazzoli](https://github.com/lburgazzoli))
- Bump Log4j2 version to 2.13.3 [\#330](https://github.com/apache/camel-k-runtime/pull/330) ([oscerd](https://github.com/oscerd))
- Improve Cron [\#329](https://github.com/apache/camel-k-runtime/pull/329) ([lburgazzoli](https://github.com/lburgazzoli))
- Improve Knative [\#328](https://github.com/apache/camel-k-runtime/pull/328) ([lburgazzoli](https://github.com/lburgazzoli))
- Code cleanup [\#327](https://github.com/apache/camel-k-runtime/pull/327) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgrade Kotlin documentation [\#325](https://github.com/apache/camel-k-runtime/pull/325) ([oscerd](https://github.com/oscerd))
- Bump Immutables to version 2.8.8 [\#323](https://github.com/apache/camel-k-runtime/pull/323) ([oscerd](https://github.com/oscerd))
- yaml-dsl-autogen [\#322](https://github.com/apache/camel-k-runtime/pull/322) ([lburgazzoli](https://github.com/lburgazzoli))
- Classname does not match the Filename. [\#321](https://github.com/apache/camel-k-runtime/pull/321) ([ityreh](https://github.com/ityreh))
- platform-http: split initialization and start phase [\#320](https://github.com/apache/camel-k-runtime/pull/320) ([lburgazzoli](https://github.com/lburgazzoli))
- Minor code cleanup [\#319](https://github.com/apache/camel-k-runtime/pull/319) ([lburgazzoli](https://github.com/lburgazzoli))
- Update to camel-quarkus 1.0.0-M7 and camel 3.2.0 [\#318](https://github.com/apache/camel-k-runtime/pull/318) ([lburgazzoli](https://github.com/lburgazzoli))
- Bump Jandex maven plugin to version 1.0.8 [\#317](https://github.com/apache/camel-k-runtime/pull/317) ([oscerd](https://github.com/oscerd))
- Fixes CAMEL-14975 \(1 of 3\) Add language docs moved from camel-k and infrastructure [\#315](https://github.com/apache/camel-k-runtime/pull/315) ([djencks](https://github.com/djencks))
- Bump log4j to version 2.13.2 [\#314](https://github.com/apache/camel-k-runtime/pull/314) ([oscerd](https://github.com/oscerd))
- Update jOOR tov 0.9.13 [\#313](https://github.com/apache/camel-k-runtime/pull/313) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(build\): cache artefacts within github cache by run infos instead of git sha [\#312](https://github.com/apache/camel-k-runtime/pull/312) ([lburgazzoli](https://github.com/lburgazzoli))
- Maven plugin updates [\#311](https://github.com/apache/camel-k-runtime/pull/311) ([oscerd](https://github.com/oscerd))
- chore: replace individual junit juniper artifacts \(api, engine, params\) with junit-jupiter [\#310](https://github.com/apache/camel-k-runtime/pull/310) ([lburgazzoli](https://github.com/lburgazzoli))
- Add more EIPS to YAML DSL [\#309](https://github.com/apache/camel-k-runtime/pull/309) ([lburgazzoli](https://github.com/lburgazzoli))
- Update groovy and kotlin [\#308](https://github.com/apache/camel-k-runtime/pull/308) ([lburgazzoli](https://github.com/lburgazzoli))
- Set camel.k.customizer as base property for customizer [\#307](https://github.com/apache/camel-k-runtime/pull/307) ([lburgazzoli](https://github.com/lburgazzoli))
- Add support for cors in platfomr http vertx [\#304](https://github.com/apache/camel-k-runtime/pull/304) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#301: Auto-set content-length or chunked transfer encoding [\#302](https://github.com/apache/camel-k-runtime/pull/302) ([nicolaferraro](https://github.com/nicolaferraro))
- yaml dsl - Add idempotent consumer EIP and update docs [\#300](https://github.com/apache/camel-k-runtime/pull/300) ([davsclaus](https://github.com/davsclaus))
- yaml: add support for LoadBalancer and CircuitBreaker EIPs \#183 [\#299](https://github.com/apache/camel-k-runtime/pull/299) ([lburgazzoli](https://github.com/lburgazzoli))
- Update camel-quarkus to v1.0.0-M6 [\#297](https://github.com/apache/camel-k-runtime/pull/297) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgrade Junit Jupiter to version 5.6.2 [\#296](https://github.com/apache/camel-k-runtime/pull/296) ([oscerd](https://github.com/oscerd))
- Update gmavenplus-plugin to v1.9.0 [\#295](https://github.com/apache/camel-k-runtime/pull/295) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix typo [\#294](https://github.com/apache/camel-k-runtime/pull/294) ([lburgazzoli](https://github.com/lburgazzoli))
- camel-k-maven-plugin: include checksum information in generated dependencies list [\#293](https://github.com/apache/camel-k-runtime/pull/293) ([lburgazzoli](https://github.com/lburgazzoli))
- Set the correct tag in main POM [\#292](https://github.com/apache/camel-k-runtime/pull/292) ([oscerd](https://github.com/oscerd))
- Workaround for the platform http not be able to handle matchOnUriPrefix [\#290](https://github.com/apache/camel-k-runtime/pull/290) ([lburgazzoli](https://github.com/lburgazzoli))
- camel-knative: fix parsing of knative environment [\#288](https://github.com/apache/camel-k-runtime/pull/288) ([lburgazzoli](https://github.com/lburgazzoli))
- Add platform-http capability [\#287](https://github.com/apache/camel-k-runtime/pull/287) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgrade Commons Lang to version 3.10 [\#286](https://github.com/apache/camel-k-runtime/pull/286) ([oscerd](https://github.com/oscerd))
- platform-http: add support for ssl to PlatformHttpServer [\#285](https://github.com/apache/camel-k-runtime/pull/285) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix joor after switching to Java 11 [\#284](https://github.com/apache/camel-k-runtime/pull/284) ([lburgazzoli](https://github.com/lburgazzoli))
- knative-transport-http: warn if host or port are configured for sources [\#283](https://github.com/apache/camel-k-runtime/pull/283) ([lburgazzoli](https://github.com/lburgazzoli))
- Cleanup pr-validate GitHub Action [\#282](https://github.com/apache/camel-k-runtime/pull/282) ([lburgazzoli](https://github.com/lburgazzoli))
- Cleanup kotlin loader [\#281](https://github.com/apache/camel-k-runtime/pull/281) ([lburgazzoli](https://github.com/lburgazzoli))
- Default to Java 11 [\#280](https://github.com/apache/camel-k-runtime/pull/280) ([lburgazzoli](https://github.com/lburgazzoli))
- Add a check to ensure Maven 3.6.3+ is used [\#278](https://github.com/apache/camel-k-runtime/pull/278) ([lburgazzoli](https://github.com/lburgazzoli))
- Bump Jandex to version 2.1.3.Final [\#276](https://github.com/apache/camel-k-runtime/pull/276) ([oscerd](https://github.com/oscerd))
- Bump Junit Jupiter to version 5.6.1 [\#275](https://github.com/apache/camel-k-runtime/pull/275) ([oscerd](https://github.com/oscerd))
- create platform http service and other stuffs [\#270](https://github.com/apache/camel-k-runtime/pull/270) ([lburgazzoli](https://github.com/lburgazzoli))

## [camel-k-runtime-parent-1.2.1](https://github.com/apache/camel-k-runtime/tree/camel-k-runtime-parent-1.2.1) (2020-03-20)

[Full Changelog](https://github.com/apache/camel-k-runtime/compare/camel-k-runtime-parent-1.1.0...camel-k-runtime-parent-1.2.1)

**Closed issues:**

- Knative extension not listed among knative dependencies in quarkus catalog [\#260](https://github.com/apache/camel-k-runtime/issues/260)
- Add cron capability [\#255](https://github.com/apache/camel-k-runtime/issues/255)
- Allow to configure default properties values [\#250](https://github.com/apache/camel-k-runtime/issues/250)
- Add capabilities to catalog [\#248](https://github.com/apache/camel-k-runtime/issues/248)
- camel-k-loader-xml - Use camel-xml-io for loading XML [\#246](https://github.com/apache/camel-k-runtime/issues/246)
- Upgarde Camel to v3.1.0 [\#245](https://github.com/apache/camel-k-runtime/issues/245)
- Rewrite support for health to leverage Vert.x [\#238](https://github.com/apache/camel-k-runtime/issues/238)
- Webhook endpoint may not be fully initialized when the route policy is applied [\#236](https://github.com/apache/camel-k-runtime/issues/236)
- Replace camel-swagger-rest-dsl-generator with camel-openapi-rest-dsl-generator [\#232](https://github.com/apache/camel-k-runtime/issues/232)
- add support for routes loaders interceptors [\#227](https://github.com/apache/camel-k-runtime/issues/227)
- camel-k-health - lets use json response body [\#193](https://github.com/apache/camel-k-runtime/issues/193)

**Merged pull requests:**

- Bump Maven Build Helper to version 3.1.0 [\#273](https://github.com/apache/camel-k-runtime/pull/273) ([oscerd](https://github.com/oscerd))
- Bump Rest-assured to version 4.3.0 [\#272](https://github.com/apache/camel-k-runtime/pull/272) ([oscerd](https://github.com/oscerd))
- Update camel-quarkus to v1.0.0-M5 [\#271](https://github.com/apache/camel-k-runtime/pull/271) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgrade Jackson to version 2.10.3 [\#269](https://github.com/apache/camel-k-runtime/pull/269) ([oscerd](https://github.com/oscerd))
- Bump Snakeyaml to version 1.26 [\#268](https://github.com/apache/camel-k-runtime/pull/268) ([oscerd](https://github.com/oscerd))
- quarkus: reduce dependencies by depending on quarkus-vertx-core and quarkus-vert-http instead of quarkus-verts [\#263](https://github.com/apache/camel-k-runtime/pull/263) ([lburgazzoli](https://github.com/lburgazzoli))
- Knative extension not listed among knative dependencies in quarkus catalog [\#261](https://github.com/apache/camel-k-runtime/pull/261) ([lburgazzoli](https://github.com/lburgazzoli))
- Allow to configure quarkus through runtime's application properties [\#259](https://github.com/apache/camel-k-runtime/pull/259) ([lburgazzoli](https://github.com/lburgazzoli))
- Improve catalog [\#256](https://github.com/apache/camel-k-runtime/pull/256) ([lburgazzoli](https://github.com/lburgazzoli))
- Bump Groovy to version 3.0.2 [\#254](https://github.com/apache/camel-k-runtime/pull/254) ([oscerd](https://github.com/oscerd))
- Improve actions [\#252](https://github.com/apache/camel-k-runtime/pull/252) ([lburgazzoli](https://github.com/lburgazzoli))
- Update to camel 3.1, camel-quarkus 1.0.0-M4 [\#251](https://github.com/apache/camel-k-runtime/pull/251) ([lburgazzoli](https://github.com/lburgazzoli))
- Refactor health support [\#249](https://github.com/apache/camel-k-runtime/pull/249) ([lburgazzoli](https://github.com/lburgazzoli))

## [camel-k-runtime-parent-1.1.0](https://github.com/apache/camel-k-runtime/tree/camel-k-runtime-parent-1.1.0) (2020-02-24)

[Full Changelog](https://github.com/apache/camel-k-runtime/compare/camel-k-runtime-parent-1.0.10...camel-k-runtime-parent-1.1.0)

**Closed issues:**

- Add camel-bean to transitive dependencies by default [\#243](https://github.com/apache/camel-k-runtime/issues/243)
- Add a helper module for setting up master [\#241](https://github.com/apache/camel-k-runtime/issues/241)
- Allow to load generic secrets and reference entries from integrations [\#239](https://github.com/apache/camel-k-runtime/issues/239)
- remove support for multiple camel versions [\#229](https://github.com/apache/camel-k-runtime/issues/229)
- Ad a specific section in the camel-k-runtime catalog to list loaders and related dependencies [\#182](https://github.com/apache/camel-k-runtime/issues/182)

**Merged pull requests:**

- Add camel-bean to transitive dependencies by default [\#244](https://github.com/apache/camel-k-runtime/pull/244) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#241: add master helper component [\#242](https://github.com/apache/camel-k-runtime/pull/242) ([nicolaferraro](https://github.com/nicolaferraro))
- Allow to load generic secrets and reference entries from integrations [\#240](https://github.com/apache/camel-k-runtime/pull/240) ([lburgazzoli](https://github.com/lburgazzoli))
- Add a repository distribution [\#237](https://github.com/apache/camel-k-runtime/pull/237) ([cunningt](https://github.com/cunningt))
- Remove deprecated properties and processors in camel-knative [\#235](https://github.com/apache/camel-k-runtime/pull/235) ([lburgazzoli](https://github.com/lburgazzoli))
- Remove the need of jaxb in camel-k-runtime-core [\#234](https://github.com/apache/camel-k-runtime/pull/234) ([lburgazzoli](https://github.com/lburgazzoli))
- Update camel-quarkus to v1.0.0-M3 [\#233](https://github.com/apache/camel-k-runtime/pull/233) ([lburgazzoli](https://github.com/lburgazzoli))
- remove support for multiple camel versions [\#231](https://github.com/apache/camel-k-runtime/pull/231) ([lburgazzoli](https://github.com/lburgazzoli))
- Upgrade AssertJ to version 3.15.0 [\#230](https://github.com/apache/camel-k-runtime/pull/230) ([oscerd](https://github.com/oscerd))
- Upgrade Vertx to version 3.8.5 [\#228](https://github.com/apache/camel-k-runtime/pull/228) ([oscerd](https://github.com/oscerd))
- Update junit5 to v5.6.0 [\#225](https://github.com/apache/camel-k-runtime/pull/225) ([lburgazzoli](https://github.com/lburgazzoli))

## [camel-k-runtime-parent-1.0.10](https://github.com/apache/camel-k-runtime/tree/camel-k-runtime-parent-1.0.10) (2020-01-13)

[Full Changelog](https://github.com/apache/camel-k-runtime/compare/camel-k-runtime-parent-1.0.9...camel-k-runtime-parent-1.0.10)

**Closed issues:**

- Native support for CronJob: convert cron endpoints to fire once at startup [\#222](https://github.com/apache/camel-k-runtime/issues/222)

**Merged pull requests:**

- Fix \#222: initial implementation of native cron support [\#223](https://github.com/apache/camel-k-runtime/pull/223) ([nicolaferraro](https://github.com/nicolaferraro))
- Upgrade Jackson to version 2.10.2 [\#221](https://github.com/apache/camel-k-runtime/pull/221) ([oscerd](https://github.com/oscerd))
- Bump Maven source plugin to version 3.2.1 [\#220](https://github.com/apache/camel-k-runtime/pull/220) ([oscerd](https://github.com/oscerd))
- Update to camel-quarkus 1.0.0-M2 [\#219](https://github.com/apache/camel-k-runtime/pull/219) ([lburgazzoli](https://github.com/lburgazzoli))

## [camel-k-runtime-parent-1.0.9](https://github.com/apache/camel-k-runtime/tree/camel-k-runtime-parent-1.0.9) (2019-12-19)

[Full Changelog](https://github.com/apache/camel-k-runtime/compare/camel-k-runtime-parent-1.0.8...camel-k-runtime-parent-1.0.9)

**Closed issues:**

- \[quarkus\] create loaders for java, groovy and kotlin in JVM mode [\#212](https://github.com/apache/camel-k-runtime/issues/212)

**Merged pull requests:**

- Dependencies updates and test improvements [\#216](https://github.com/apache/camel-k-runtime/pull/216) ([lburgazzoli](https://github.com/lburgazzoli))
- \[quarkus\] create loaders for java, groovy and kotlin in JVM mode [\#214](https://github.com/apache/camel-k-runtime/pull/214) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(plugin\): switch from v1alpha1 to v1 [\#213](https://github.com/apache/camel-k-runtime/pull/213) ([nicolaferraro](https://github.com/nicolaferraro))
- Ignore package when working with Java classes [\#211](https://github.com/apache/camel-k-runtime/pull/211) ([lburgazzoli](https://github.com/lburgazzoli))
- groovy: workaround for https://issues.apache.org/jira/browse/CAMEL-14300 [\#210](https://github.com/apache/camel-k-runtime/pull/210) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(plugin\): generate lower case names for resources [\#209](https://github.com/apache/camel-k-runtime/pull/209) ([nicolaferraro](https://github.com/nicolaferraro))

## [camel-k-runtime-parent-1.0.8](https://github.com/apache/camel-k-runtime/tree/camel-k-runtime-parent-1.0.8) (2019-12-16)

[Full Changelog](https://github.com/apache/camel-k-runtime/compare/camel-k-runtime-parent-1.0.7...camel-k-runtime-parent-1.0.8)

**Closed issues:**

- Invalid Camel KNative json schema [\#203](https://github.com/apache/camel-k-runtime/issues/203)
- Upgrade to quarkus 1.0 CR1 [\#191](https://github.com/apache/camel-k-runtime/issues/191)
- Suport Java 11 [\#103](https://github.com/apache/camel-k-runtime/issues/103)

**Merged pull requests:**

- Fix apache/camel-k\#1119: do not return cloud events by default [\#208](https://github.com/apache/camel-k-runtime/pull/208) ([nicolaferraro](https://github.com/nicolaferraro))
- runtime-main: disable routes collector as routes are discovered through camel-k specific mechanic [\#207](https://github.com/apache/camel-k-runtime/pull/207) ([lburgazzoli](https://github.com/lburgazzoli))
- Update to Camel 3.0.0 and Camel-Quarkus 1.0.0-M1 [\#206](https://github.com/apache/camel-k-runtime/pull/206) ([lburgazzoli](https://github.com/lburgazzoli))
- Provide basic description for KNative component to have a valid catalog [\#205](https://github.com/apache/camel-k-runtime/pull/205) ([apupier](https://github.com/apupier))
- Add type information to catalog [\#204](https://github.com/apache/camel-k-runtime/pull/204) ([jamesnetherton](https://github.com/jamesnetherton))
- Update kotlin to v1.3.61 [\#202](https://github.com/apache/camel-k-runtime/pull/202) ([lburgazzoli](https://github.com/lburgazzoli))
- YAML: add annotation to auto geenrate support classes and quarkus reflective class discovery [\#201](https://github.com/apache/camel-k-runtime/pull/201) ([lburgazzoli](https://github.com/lburgazzoli))
- Support additional EIP for YAML DSL [\#200](https://github.com/apache/camel-k-runtime/pull/200) ([lburgazzoli](https://github.com/lburgazzoli))
- loader-java: add test for compiling routes requiring external classes [\#199](https://github.com/apache/camel-k-runtime/pull/199) ([lburgazzoli](https://github.com/lburgazzoli))
- Allow to use any class as configuration source [\#198](https://github.com/apache/camel-k-runtime/pull/198) ([lburgazzoli](https://github.com/lburgazzoli))
- Update deps and actions [\#197](https://github.com/apache/camel-k-runtime/pull/197) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(tools\): make sure quarkus catalog name start with "camel-catalog-" [\#196](https://github.com/apache/camel-k-runtime/pull/196) ([nicolaferraro](https://github.com/nicolaferraro))

## [camel-k-runtime-parent-1.0.7](https://github.com/apache/camel-k-runtime/tree/camel-k-runtime-parent-1.0.7) (2019-11-13)

[Full Changelog](https://github.com/apache/camel-k-runtime/compare/camel-k-runtime-parent-1.0.6...camel-k-runtime-parent-1.0.7)

**Closed issues:**

- Remove support for java class loader [\#195](https://github.com/apache/camel-k-runtime/issues/195)
- Upgrade to Camel RC3 [\#189](https://github.com/apache/camel-k-runtime/issues/189)
- CamelCloudEventXXX not converted to CE header [\#177](https://github.com/apache/camel-k-runtime/issues/177)
- Undertow does not shut down properly in webhook route policy [\#172](https://github.com/apache/camel-k-runtime/issues/172)
- switch to camel main for quarkus related bits [\#149](https://github.com/apache/camel-k-runtime/issues/149)
- add quarkus information in catalog generator [\#148](https://github.com/apache/camel-k-runtime/issues/148)

**Merged pull requests:**

- loaders: remove java class loader as it is misleading [\#194](https://github.com/apache/camel-k-runtime/pull/194) ([lburgazzoli](https://github.com/lburgazzoli))
- Remove docker-maven-plugin in pom.xml which is not in use [\#192](https://github.com/apache/camel-k-runtime/pull/192) ([davsclaus](https://github.com/davsclaus))
- Fixes \#189 to update to Camel 3.0 RC3 [\#190](https://github.com/apache/camel-k-runtime/pull/190) ([davsclaus](https://github.com/davsclaus))
- Update deps [\#188](https://github.com/apache/camel-k-runtime/pull/188) ([lburgazzoli](https://github.com/lburgazzoli))
- Enable GitHub Actions [\#187](https://github.com/apache/camel-k-runtime/pull/187) ([lburgazzoli](https://github.com/lburgazzoli))
- update to quarkus 0.3.1 [\#181](https://github.com/apache/camel-k-runtime/pull/181) ([lburgazzoli](https://github.com/lburgazzoli))
- CamelCloudEventXXX not converted to CE header [\#178](https://github.com/apache/camel-k-runtime/pull/178) ([lburgazzoli](https://github.com/lburgazzoli))
- Camel Quarkus 0.3.0 support [\#167](https://github.com/apache/camel-k-runtime/pull/167) ([astefanutti](https://github.com/astefanutti))

## [camel-k-runtime-parent-1.0.6](https://github.com/apache/camel-k-runtime/tree/camel-k-runtime-parent-1.0.6) (2019-10-25)

[Full Changelog](https://github.com/apache/camel-k-runtime/compare/camel-k-runtime-parent-1.0.5...camel-k-runtime-parent-1.0.6)

**Closed issues:**

- Provide support for statically defined cloudevent headers [\#175](https://github.com/apache/camel-k-runtime/issues/175)
- Wrong CloudEvent Headers used [\#173](https://github.com/apache/camel-k-runtime/issues/173)
- Add support for webhook endpoints [\#170](https://github.com/apache/camel-k-runtime/issues/170)

**Merged pull requests:**

- Provide support for statically defined cloudevent headers [\#176](https://github.com/apache/camel-k-runtime/pull/176) ([lburgazzoli](https://github.com/lburgazzoli))
- Wrong CloudEvent Headers used [\#174](https://github.com/apache/camel-k-runtime/pull/174) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix \#170: add support for webhook endpoints [\#171](https://github.com/apache/camel-k-runtime/pull/171) ([nicolaferraro](https://github.com/nicolaferraro))

## [camel-k-runtime-parent-1.0.5](https://github.com/apache/camel-k-runtime/tree/camel-k-runtime-parent-1.0.5) (2019-10-18)

[Full Changelog](https://github.com/apache/camel-k-runtime/compare/camel-k-runtime-parent-1.0.4...camel-k-runtime-parent-1.0.5)

**Closed issues:**

- mismatch the runtime version in camel-k-maven-plugin generate-catelog [\#164](https://github.com/apache/camel-k-runtime/issues/164)
- Can't bridge two Knative channels with new component [\#163](https://github.com/apache/camel-k-runtime/issues/163)
- Remove artifact version from catalog [\#156](https://github.com/apache/camel-k-runtime/issues/156)
- Remove legacy artifacts [\#155](https://github.com/apache/camel-k-runtime/issues/155)
- Switch to CloudEvents 0.3 [\#154](https://github.com/apache/camel-k-runtime/issues/154)
- Support Knative broker/trigger model [\#151](https://github.com/apache/camel-k-runtime/issues/151)
- Support explicit source/target in knative endpoint [\#150](https://github.com/apache/camel-k-runtime/issues/150)
- Quarkus examples fail on mvn:release [\#146](https://github.com/apache/camel-k-runtime/issues/146)
- Include camel-k-runtime version in camel-catalog [\#141](https://github.com/apache/camel-k-runtime/issues/141)
- Knative component switches from POST to GET depending on the presence of the exchange body [\#121](https://github.com/apache/camel-k-runtime/issues/121)
- Support cloud events spec v3 [\#105](https://github.com/apache/camel-k-runtime/issues/105)
- add support for quarkus [\#57](https://github.com/apache/camel-k-runtime/issues/57)

**Merged pull requests:**

- Improve DSL for groovy and kotlin [\#169](https://github.com/apache/camel-k-runtime/pull/169) ([lburgazzoli](https://github.com/lburgazzoli))
- HTTP multi-headers are randomized in camel-knative-http [\#168](https://github.com/apache/camel-k-runtime/pull/168) ([lburgazzoli](https://github.com/lburgazzoli))
- Can't bridge two Knative channels with new component [\#166](https://github.com/apache/camel-k-runtime/pull/166) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix issue 164 to update the runtime version [\#165](https://github.com/apache/camel-k-runtime/pull/165) ([zhfeng](https://github.com/zhfeng))
- kotlin: improve rest dsl [\#162](https://github.com/apache/camel-k-runtime/pull/162) ([lburgazzoli](https://github.com/lburgazzoli))
- knative: add some checks about supported http methods and mandatory body [\#161](https://github.com/apache/camel-k-runtime/pull/161) ([lburgazzoli](https://github.com/lburgazzoli))
- Support cloud events spec v3 [\#158](https://github.com/apache/camel-k-runtime/pull/158) ([lburgazzoli](https://github.com/lburgazzoli))
- Remove legacy artifacts and version from catalog [\#157](https://github.com/apache/camel-k-runtime/pull/157) ([lburgazzoli](https://github.com/lburgazzoli))
- Support Knative broker/trigger model [\#153](https://github.com/apache/camel-k-runtime/pull/153) ([lburgazzoli](https://github.com/lburgazzoli))
- Disbale deploy task for examples [\#147](https://github.com/apache/camel-k-runtime/pull/147) ([lburgazzoli](https://github.com/lburgazzoli))

## [camel-k-runtime-parent-1.0.4](https://github.com/apache/camel-k-runtime/tree/camel-k-runtime-parent-1.0.4) (2019-10-04)

[Full Changelog](https://github.com/apache/camel-k-runtime/compare/camel-k-runtime-parent-1.0.1...camel-k-runtime-parent-1.0.4)

**Closed issues:**

- Add the error log when setting component property failed [\#137](https://github.com/apache/camel-k-runtime/issues/137)
- Update to Camel RC1 [\#134](https://github.com/apache/camel-k-runtime/issues/134)
- knative-http component does not return response [\#130](https://github.com/apache/camel-k-runtime/issues/130)
- Base knative-http component to vertx-web as the next undertow major release \(3\) will be based on it [\#126](https://github.com/apache/camel-k-runtime/issues/126)

**Merged pull requests:**

- add \(initial\) support for quarkus [\#145](https://github.com/apache/camel-k-runtime/pull/145) ([lburgazzoli](https://github.com/lburgazzoli))
- Update deps [\#144](https://github.com/apache/camel-k-runtime/pull/144) ([lburgazzoli](https://github.com/lburgazzoli))
- groovy: improve rest dsl [\#143](https://github.com/apache/camel-k-runtime/pull/143) ([lburgazzoli](https://github.com/lburgazzoli))
- Include camel-k-runtime version in camel-catalog [\#142](https://github.com/apache/camel-k-runtime/pull/142) ([lburgazzoli](https://github.com/lburgazzoli))
- fix\(catalog\): Declare the webhook component as an HTTP component [\#140](https://github.com/apache/camel-k-runtime/pull/140) ([astefanutti](https://github.com/astefanutti))
- yaml-loader: support route definition [\#139](https://github.com/apache/camel-k-runtime/pull/139) ([lburgazzoli](https://github.com/lburgazzoli))
- \#137 Throw exception when setting component property failed  [\#138](https://github.com/apache/camel-k-runtime/pull/138) ([WillemJiang](https://github.com/WillemJiang))
- Cleanup module dependencies [\#136](https://github.com/apache/camel-k-runtime/pull/136) ([lburgazzoli](https://github.com/lburgazzoli))
- Update to Camel RC1 [\#135](https://github.com/apache/camel-k-runtime/pull/135) ([lburgazzoli](https://github.com/lburgazzoli))
- groovy: add extension methods for expression clause [\#133](https://github.com/apache/camel-k-runtime/pull/133) ([lburgazzoli](https://github.com/lburgazzoli))
- Update deps [\#132](https://github.com/apache/camel-k-runtime/pull/132) ([lburgazzoli](https://github.com/lburgazzoli))
- knative-http component does not return response [\#131](https://github.com/apache/camel-k-runtime/pull/131) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(deps\): update kotlin to v1.3.50 [\#129](https://github.com/apache/camel-k-runtime/pull/129) ([lburgazzoli](https://github.com/lburgazzoli))

## [camel-k-runtime-parent-1.0.1](https://github.com/apache/camel-k-runtime/tree/camel-k-runtime-parent-1.0.1) (2019-08-23)

[Full Changelog](https://github.com/apache/camel-k-runtime/compare/camel-k-runtime-parent-1.0.0...camel-k-runtime-parent-1.0.1)

**Closed issues:**

- Allow endpoint DSL in Camel k [\#122](https://github.com/apache/camel-k-runtime/issues/122)
- Knative component filters out all headers [\#118](https://github.com/apache/camel-k-runtime/issues/118)

**Merged pull requests:**

- Base knative-http component to vertx-web as the next undertow major release \(3\) will be based on it \#126 [\#128](https://github.com/apache/camel-k-runtime/pull/128) ([lburgazzoli](https://github.com/lburgazzoli))
- Re-organize repo and update deps [\#127](https://github.com/apache/camel-k-runtime/pull/127) ([lburgazzoli](https://github.com/lburgazzoli))
- knative: add custom loader for sources [\#125](https://github.com/apache/camel-k-runtime/pull/125) ([lburgazzoli](https://github.com/lburgazzoli))
- knative: true knative-http component [\#124](https://github.com/apache/camel-k-runtime/pull/124) ([lburgazzoli](https://github.com/lburgazzoli))
- Allow endpoint DSL in Camel k [\#123](https://github.com/apache/camel-k-runtime/pull/123) ([lburgazzoli](https://github.com/lburgazzoli))
- Knative component filters out all headers [\#120](https://github.com/apache/camel-k-runtime/pull/120) ([lburgazzoli](https://github.com/lburgazzoli))
- maven dependencies for java.xml.bind \(jaxb\) issue \#103 [\#119](https://github.com/apache/camel-k-runtime/pull/119) ([ipolyzos](https://github.com/ipolyzos))
- chore\(dsl\): add bean dsl for kotlin and groovy [\#117](https://github.com/apache/camel-k-runtime/pull/117) ([lburgazzoli](https://github.com/lburgazzoli))

## [camel-k-runtime-parent-1.0.0](https://github.com/apache/camel-k-runtime/tree/camel-k-runtime-parent-1.0.0) (2019-07-25)

[Full Changelog](https://github.com/apache/camel-k-runtime/compare/camel-k-runtime-parent-0.3.3...camel-k-runtime-parent-1.0.0)

**Closed issues:**

- Lambda processor doesn't work with JS routes [\#115](https://github.com/apache/camel-k-runtime/issues/115)
- js: components not exported by base script [\#112](https://github.com/apache/camel-k-runtime/issues/112)
- Unable to run examples with exec:java [\#104](https://github.com/apache/camel-k-runtime/issues/104)
- camel-k-runtime-jvm is misleading [\#101](https://github.com/apache/camel-k-runtime/issues/101)
- Modularize loaders [\#100](https://github.com/apache/camel-k-runtime/issues/100)
- Switch to GraalJS [\#99](https://github.com/apache/camel-k-runtime/issues/99)
- Update to camel 3.0.0-M4 [\#94](https://github.com/apache/camel-k-runtime/issues/94)
- Add checstyle [\#87](https://github.com/apache/camel-k-runtime/issues/87)
- Add license format tool and amend license to use the same style as camel 3.x [\#86](https://github.com/apache/camel-k-runtime/issues/86)
- Support full yaml dsl [\#82](https://github.com/apache/camel-k-runtime/issues/82)
- Support full yaml dsl [\#80](https://github.com/apache/camel-k-runtime/issues/80)
- Support camel 3.0.0 M3 [\#79](https://github.com/apache/camel-k-runtime/issues/79)
- Release 0.3.3 [\#72](https://github.com/apache/camel-k-runtime/issues/72)
- remove log4j from bom [\#59](https://github.com/apache/camel-k-runtime/issues/59)
- remove support for camel 2.x [\#56](https://github.com/apache/camel-k-runtime/issues/56)

**Merged pull requests:**

- Lambda processor doesn't work with JS routes [\#116](https://github.com/apache/camel-k-runtime/pull/116) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(js\): add test for rest dsl/definition [\#114](https://github.com/apache/camel-k-runtime/pull/114) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix JS symbol export [\#113](https://github.com/apache/camel-k-runtime/pull/113) ([lburgazzoli](https://github.com/lburgazzoli))
- loader\(kotlin\): add default imports [\#111](https://github.com/apache/camel-k-runtime/pull/111) ([lburgazzoli](https://github.com/lburgazzoli))
- loader\(groovy\): add default imports [\#110](https://github.com/apache/camel-k-runtime/pull/110) ([lburgazzoli](https://github.com/lburgazzoli))
- loader\(java\): support for bean registration [\#109](https://github.com/apache/camel-k-runtime/pull/109) ([lburgazzoli](https://github.com/lburgazzoli))
- Fix the camel-k-runtime-example running issue [\#108](https://github.com/apache/camel-k-runtime/pull/108) ([WillemJiang](https://github.com/WillemJiang))
- chore\(js\): wrap script with a  block to make it easy to extend the DSL [\#107](https://github.com/apache/camel-k-runtime/pull/107) ([lburgazzoli](https://github.com/lburgazzoli))
- Make runtime more modular \(required for quarkus\) [\#106](https://github.com/apache/camel-k-runtime/pull/106) ([lburgazzoli](https://github.com/lburgazzoli))
- Switch to GraalJS [\#102](https://github.com/apache/camel-k-runtime/pull/102) ([lburgazzoli](https://github.com/lburgazzoli))
- cleanup camel-k bom [\#98](https://github.com/apache/camel-k-runtime/pull/98) ([lburgazzoli](https://github.com/lburgazzoli))
- Provide Travis CI badge [\#97](https://github.com/apache/camel-k-runtime/pull/97) ([apupier](https://github.com/apupier))
- Remove unused SuppresWarnings [\#96](https://github.com/apache/camel-k-runtime/pull/96) ([apupier](https://github.com/apupier))
- Update to camel 3.0.0-M4 [\#95](https://github.com/apache/camel-k-runtime/pull/95) ([lburgazzoli](https://github.com/lburgazzoli))
- Dpes updates and build clenaup [\#93](https://github.com/apache/camel-k-runtime/pull/93) ([lburgazzoli](https://github.com/lburgazzoli))
- improve kotlin support [\#92](https://github.com/apache/camel-k-runtime/pull/92) ([lburgazzoli](https://github.com/lburgazzoli))
- improve groovy support [\#91](https://github.com/apache/camel-k-runtime/pull/91) ([lburgazzoli](https://github.com/lburgazzoli))
- Update dependencies [\#90](https://github.com/apache/camel-k-runtime/pull/90) ([lburgazzoli](https://github.com/lburgazzoli))
- Ass keys [\#89](https://github.com/apache/camel-k-runtime/pull/89) ([lburgazzoli](https://github.com/lburgazzoli))
- Enable checkstyle and license checks [\#88](https://github.com/apache/camel-k-runtime/pull/88) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(deps\): update kotlin to v1.3.40 [\#85](https://github.com/apache/camel-k-runtime/pull/85) ([lburgazzoli](https://github.com/lburgazzoli))
- Support full yaml dsl \#80 [\#84](https://github.com/apache/camel-k-runtime/pull/84) ([lburgazzoli](https://github.com/lburgazzoli))
- Support camel 3.0.0 M3 \#79 [\#81](https://github.com/apache/camel-k-runtime/pull/81) ([lburgazzoli](https://github.com/lburgazzoli))
- catalog: generate license header \(camel 3\) [\#77](https://github.com/apache/camel-k-runtime/pull/77) ([lburgazzoli](https://github.com/lburgazzoli))
- Camel 3 cleanup [\#75](https://github.com/apache/camel-k-runtime/pull/75) ([lburgazzoli](https://github.com/lburgazzoli))
- Switch to Camel 3 by default [\#73](https://github.com/apache/camel-k-runtime/pull/73) ([lburgazzoli](https://github.com/lburgazzoli))

## [camel-k-runtime-parent-0.3.3](https://github.com/apache/camel-k-runtime/tree/camel-k-runtime-parent-0.3.3) (2019-05-28)

[Full Changelog](https://github.com/apache/camel-k-runtime/compare/camel-k-runtime-parent-0.3.2...camel-k-runtime-parent-0.3.3)

**Closed issues:**

- update to Camel 2.24.0 [\#60](https://github.com/apache/camel-k-runtime/issues/60)
- remove spring boot support [\#55](https://github.com/apache/camel-k-runtime/issues/55)
- Release 0.3.2 [\#51](https://github.com/apache/camel-k-runtime/issues/51)
- Refactor customizer activation [\#46](https://github.com/apache/camel-k-runtime/issues/46)

**Merged pull requests:**

- Added a servletregistration customizer and improved examples. [\#71](https://github.com/apache/camel-k-runtime/pull/71) ([valdar](https://github.com/valdar))
- servlet: update catalog and bom [\#70](https://github.com/apache/camel-k-runtime/pull/70) ([lburgazzoli](https://github.com/lburgazzoli))
- add servlet support [\#68](https://github.com/apache/camel-k-runtime/pull/68) ([lburgazzoli](https://github.com/lburgazzoli))
- Refactor customizer activation [\#67](https://github.com/apache/camel-k-runtime/pull/67) ([lburgazzoli](https://github.com/lburgazzoli))
- rest: support configuring rest's configuration component/endpoint properties [\#66](https://github.com/apache/camel-k-runtime/pull/66) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(cleanup\): remove platform stream handler [\#64](https://github.com/apache/camel-k-runtime/pull/64) ([lburgazzoli](https://github.com/lburgazzoli))
- Update dependencies [\#63](https://github.com/apache/camel-k-runtime/pull/63) ([lburgazzoli](https://github.com/lburgazzoli))
- remove spring boot support [\#62](https://github.com/apache/camel-k-runtime/pull/62) ([lburgazzoli](https://github.com/lburgazzoli))
- update to Camel 2.24.0 [\#61](https://github.com/apache/camel-k-runtime/pull/61) ([lburgazzoli](https://github.com/lburgazzoli))
- knative: fix wrong content type [\#54](https://github.com/apache/camel-k-runtime/pull/54) ([lburgazzoli](https://github.com/lburgazzoli))

## [camel-k-runtime-parent-0.3.2](https://github.com/apache/camel-k-runtime/tree/camel-k-runtime-parent-0.3.2) (2019-04-26)

[Full Changelog](https://github.com/apache/camel-k-runtime/compare/camel-k-runtime-parent-0.3.1...camel-k-runtime-parent-0.3.2)

**Closed issues:**

- Provide a default "type" for cloudevents [\#48](https://github.com/apache/camel-k-runtime/issues/48)
- Support StreamCaching configuration trough a ContextCustomizer [\#44](https://github.com/apache/camel-k-runtime/issues/44)
- Runtime components should include catalog information [\#31](https://github.com/apache/camel-k-runtime/issues/31)
- Release 0.3.1 [\#28](https://github.com/apache/camel-k-runtime/issues/28)

**Merged pull requests:**

- Rollback to 0.3.2-SNAPSHOT and re-enable missing module [\#53](https://github.com/apache/camel-k-runtime/pull/53) ([nicolaferraro](https://github.com/nicolaferraro))
- Align the snapshot version for camel-k-adapter-camel-3 module [\#52](https://github.com/apache/camel-k-runtime/pull/52) ([oscerd](https://github.com/oscerd))
- Fix \#48: add a default type to cloudevents [\#50](https://github.com/apache/camel-k-runtime/pull/50) ([nicolaferraro](https://github.com/nicolaferraro))
- customizer: honour cutomizer list property/env [\#49](https://github.com/apache/camel-k-runtime/pull/49) ([lburgazzoli](https://github.com/lburgazzoli))
- chore: fix typo in package name and add license header [\#47](https://github.com/apache/camel-k-runtime/pull/47) ([lburgazzoli](https://github.com/lburgazzoli))
- fix \#44 : Support StreamCaching configuration trough a ContextCustomi… [\#45](https://github.com/apache/camel-k-runtime/pull/45) ([valdar](https://github.com/valdar))
- Suport for camel 3.0.0-M2 and 2.21.x [\#43](https://github.com/apache/camel-k-runtime/pull/43) ([lburgazzoli](https://github.com/lburgazzoli))
- logging: add log4j to camel-k bom [\#42](https://github.com/apache/camel-k-runtime/pull/42) ([lburgazzoli](https://github.com/lburgazzoli))
- Fixed comnpatibility with camel 2.21.x [\#40](https://github.com/apache/camel-k-runtime/pull/40) ([valdar](https://github.com/valdar))
- Need to exclude groovy-all here as well, possible for it to bleed in [\#38](https://github.com/apache/camel-k-runtime/pull/38) ([cunningt](https://github.com/cunningt))
- Change log4j-slf4j-impl dependency scope from runtime to test [\#37](https://github.com/apache/camel-k-runtime/pull/37) ([astefanutti](https://github.com/astefanutti))
- cleanup [\#36](https://github.com/apache/camel-k-runtime/pull/36) ([lburgazzoli](https://github.com/lburgazzoli))
- fix: add custom netty http binding to workaround CAMEL-13351 [\#35](https://github.com/apache/camel-k-runtime/pull/35) ([lburgazzoli](https://github.com/lburgazzoli))
- Moved camel-k-adapter-camel-3 module to camel3 profile since all the … [\#34](https://github.com/apache/camel-k-runtime/pull/34) ([valdar](https://github.com/valdar))
- fix platform stream handler [\#33](https://github.com/apache/camel-k-runtime/pull/33) ([lburgazzoli](https://github.com/lburgazzoli))
- Runtime components should include catalog information [\#32](https://github.com/apache/camel-k-runtime/pull/32) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(version\): Bump Snakeyaml to version 1.24 [\#30](https://github.com/apache/camel-k-runtime/pull/30) ([oscerd](https://github.com/oscerd))

## [camel-k-runtime-parent-0.3.1](https://github.com/apache/camel-k-runtime/tree/camel-k-runtime-parent-0.3.1) (2019-03-06)

[Full Changelog](https://github.com/apache/camel-k-runtime/compare/camel-k-runtime-parent-0.3.0...camel-k-runtime-parent-0.3.1)

**Closed issues:**

- Upgrade spring boot [\#29](https://github.com/apache/camel-k-runtime/issues/29)
- Add runtime health endpoint [\#21](https://github.com/apache/camel-k-runtime/issues/21)
- Default service definition not taken into account [\#19](https://github.com/apache/camel-k-runtime/issues/19)
- Create release artifact of camel-k-runtime [\#18](https://github.com/apache/camel-k-runtime/issues/18)
- Release 0.3.0 [\#17](https://github.com/apache/camel-k-runtime/issues/17)

**Merged pull requests:**

- Please add my pgp key [\#27](https://github.com/apache/camel-k-runtime/pull/27) ([nicolaferraro](https://github.com/nicolaferraro))
- Fixed version checking in Catalog to accomodate also x.y.z-something … [\#26](https://github.com/apache/camel-k-runtime/pull/26) ([valdar](https://github.com/valdar))
- camel-knative: set CloudEvents v0.2 as default spec version [\#25](https://github.com/apache/camel-k-runtime/pull/25) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(netty\): improve health service [\#24](https://github.com/apache/camel-k-runtime/pull/24) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(camel-3\): fix camel 3 compatibility layer [\#23](https://github.com/apache/camel-k-runtime/pull/23) ([lburgazzoli](https://github.com/lburgazzoli))
- Add runtime health endpoint [\#22](https://github.com/apache/camel-k-runtime/pull/22) ([lburgazzoli](https://github.com/lburgazzoli))
- Default service definition not taken into account [\#20](https://github.com/apache/camel-k-runtime/pull/20) ([lburgazzoli](https://github.com/lburgazzoli))

## [camel-k-runtime-parent-0.3.0](https://github.com/apache/camel-k-runtime/tree/camel-k-runtime-parent-0.3.0) (2019-02-27)

[Full Changelog](https://github.com/apache/camel-k-runtime/compare/e2bfda27f6eff94355c4bcae3b37f233bac3c48e...camel-k-runtime-parent-0.3.0)

**Implemented enhancements:**

- Support for camel 3.x [\#11](https://github.com/apache/camel-k-runtime/issues/11)

**Closed issues:**

- Camel-k-runtime-merge job is failing [\#14](https://github.com/apache/camel-k-runtime/issues/14)
- Create runtime bom [\#12](https://github.com/apache/camel-k-runtime/issues/12)

**Merged pull requests:**

- Support for camel 3.x [\#16](https://github.com/apache/camel-k-runtime/pull/16) ([lburgazzoli](https://github.com/lburgazzoli))
- fix\(deploy\): Camel-k-runtime-merge job is failing, fixes \#14 [\#15](https://github.com/apache/camel-k-runtime/pull/15) ([oscerd](https://github.com/oscerd))
- Create runtime bom [\#13](https://github.com/apache/camel-k-runtime/pull/13) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(refactor\): Added license for .travis.yml [\#10](https://github.com/apache/camel-k-runtime/pull/10) ([oscerd](https://github.com/oscerd))
- Travis.yml: lets run only tests [\#9](https://github.com/apache/camel-k-runtime/pull/9) ([oscerd](https://github.com/oscerd))
- Added an initial travis.yml [\#8](https://github.com/apache/camel-k-runtime/pull/8) ([oscerd](https://github.com/oscerd))
- Added KEYS File [\#7](https://github.com/apache/camel-k-runtime/pull/7) ([oscerd](https://github.com/oscerd))
- Added a JenkinsFile for Pull Requests [\#5](https://github.com/apache/camel-k-runtime/pull/5) ([oscerd](https://github.com/oscerd))
- Added a little README [\#4](https://github.com/apache/camel-k-runtime/pull/4) ([oscerd](https://github.com/oscerd))
- Jenkins rework [\#3](https://github.com/apache/camel-k-runtime/pull/3) ([oscerd](https://github.com/oscerd))
- Bump to 0.3.0-SNAPSHOT [\#2](https://github.com/apache/camel-k-runtime/pull/2) ([oscerd](https://github.com/oscerd))
- First import for runtime [\#1](https://github.com/apache/camel-k-runtime/pull/1) ([oscerd](https://github.com/oscerd))



\* *This Changelog was automatically generated by [github_changelog_generator](https://github.com/github-changelog-generator/github-changelog-generator)*
