/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Store and retrieve objects from Google Cloud Storage Service using the
 * google-cloud-storage library.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface GoogleCloudStorageEndpointBuilderFactory {

    /**
     * Builder for endpoint consumers for the Google Storage component.
     */
    public interface GoogleCloudStorageEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedGoogleCloudStorageEndpointConsumerBuilder advanced() {
            return (AdvancedGoogleCloudStorageEndpointConsumerBuilder) this;
        }
        /**
         * Setting the autocreation of the bucket bucketName.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoCreateBucket the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder autoCreateBucket(boolean autoCreateBucket) {
            doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }
        /**
         * Setting the autocreation of the bucket bucketName.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoCreateBucket the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder autoCreateBucket(String autoCreateBucket) {
            doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }
        /**
         * The Service account key that can be used as credentials for the
         * Storage client. It can be loaded by default from classpath, but you
         * can prefix with classpath:, file:, or http: to load the resource from
         * different systems.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param serviceAccountKey the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder serviceAccountKey(String serviceAccountKey) {
            doSetProperty("serviceAccountKey", serviceAccountKey);
            return this;
        }
        /**
         * The Cloud Storage class to use when creating the new buckets.
         * 
         * The option is a: <code>com.google.cloud.storage.StorageClass</code>
         * type.
         * 
         * Default: STANDARD
         * Group: common
         * 
         * @param storageClass the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder storageClass(com.google.cloud.storage.StorageClass storageClass) {
            doSetProperty("storageClass", storageClass);
            return this;
        }
        /**
         * The Cloud Storage class to use when creating the new buckets.
         * 
         * The option will be converted to a
         * <code>com.google.cloud.storage.StorageClass</code> type.
         * 
         * Default: STANDARD
         * Group: common
         * 
         * @param storageClass the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder storageClass(String storageClass) {
            doSetProperty("storageClass", storageClass);
            return this;
        }
        /**
         * The storage client.
         * 
         * The option is a: <code>com.google.cloud.storage.Storage</code> type.
         * 
         * Group: common
         * 
         * @param storageClient the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder storageClient(com.google.cloud.storage.Storage storageClient) {
            doSetProperty("storageClient", storageClient);
            return this;
        }
        /**
         * The storage client.
         * 
         * The option will be converted to a
         * <code>com.google.cloud.storage.Storage</code> type.
         * 
         * Group: common
         * 
         * @param storageClient the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder storageClient(String storageClient) {
            doSetProperty("storageClient", storageClient);
            return this;
        }
        /**
         * The Cloud Storage location to use when creating the new buckets.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: US-EAST1
         * Group: common
         * 
         * @param storageLocation the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder storageLocation(String storageLocation) {
            doSetProperty("storageLocation", storageLocation);
            return this;
        }
        /**
         * Delete objects from the bucket after they have been retrieved. The
         * delete is only performed if the Exchange is committed. If a rollback
         * occurs, the object is not deleted. If this option is false, then the
         * same objects will be retrieve over and over again on the polls.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param deleteAfterRead the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder deleteAfterRead(boolean deleteAfterRead) {
            doSetProperty("deleteAfterRead", deleteAfterRead);
            return this;
        }
        /**
         * Delete objects from the bucket after they have been retrieved. The
         * delete is only performed if the Exchange is committed. If a rollback
         * occurs, the object is not deleted. If this option is false, then the
         * same objects will be retrieve over and over again on the polls.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param deleteAfterRead the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder deleteAfterRead(String deleteAfterRead) {
            doSetProperty("deleteAfterRead", deleteAfterRead);
            return this;
        }
        /**
         * Define the destination bucket where an object must be moved when
         * moveAfterRead is set to true.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param destinationBucket the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder destinationBucket(String destinationBucket) {
            doSetProperty("destinationBucket", destinationBucket);
            return this;
        }
        /**
         * The folder or filename to use when downloading the blob. By default,
         * this specifies the folder name, and the name of the file is the blob
         * name. For example, setting this to mydownload will be the same as
         * setting mydownload/${file:name}. You can use dynamic expressions for
         * fine-grained control. For example, you can specify
         * ${date:now:yyyyMMdd}/${file:name} to store the blob in sub folders
         * based on today's day. Only ${file:name} and ${file:name.noext} is
         * supported as dynamic tokens for the blob name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param downloadFileName the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder downloadFileName(String downloadFileName) {
            doSetProperty("downloadFileName", downloadFileName);
            return this;
        }
        /**
         * A regular expression to include only blobs with name matching it.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param filter the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder filter(String filter) {
            doSetProperty("filter", filter);
            return this;
        }
        /**
         * If it is true, the Object exchange will be consumed and put into the
         * body. If false the Object stream will be put raw into the body and
         * the headers will be set with the object metadata.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param includeBody the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder includeBody(boolean includeBody) {
            doSetProperty("includeBody", includeBody);
            return this;
        }
        /**
         * If it is true, the Object exchange will be consumed and put into the
         * body. If false the Object stream will be put raw into the body and
         * the headers will be set with the object metadata.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param includeBody the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder includeBody(String includeBody) {
            doSetProperty("includeBody", includeBody);
            return this;
        }
        /**
         * If it is true, the folders/directories will be consumed. If it is
         * false, they will be ignored, and Exchanges will not be created for
         * those.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param includeFolders the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder includeFolders(boolean includeFolders) {
            doSetProperty("includeFolders", includeFolders);
            return this;
        }
        /**
         * If it is true, the folders/directories will be consumed. If it is
         * false, they will be ignored, and Exchanges will not be created for
         * those.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param includeFolders the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder includeFolders(String includeFolders) {
            doSetProperty("includeFolders", includeFolders);
            return this;
        }
        /**
         * Move objects from the origin bucket to a different bucket after they
         * have been retrieved. To accomplish the operation the
         * destinationBucket option must be set. The copy bucket operation is
         * only performed if the Exchange is committed. If a rollback occurs,
         * the object is not moved.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param moveAfterRead the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder moveAfterRead(boolean moveAfterRead) {
            doSetProperty("moveAfterRead", moveAfterRead);
            return this;
        }
        /**
         * Move objects from the origin bucket to a different bucket after they
         * have been retrieved. To accomplish the operation the
         * destinationBucket option must be set. The copy bucket operation is
         * only performed if the Exchange is committed. If a rollback occurs,
         * the object is not moved.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param moveAfterRead the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder moveAfterRead(String moveAfterRead) {
            doSetProperty("moveAfterRead", moveAfterRead);
            return this;
        }
        /**
         * The prefix which is used in the BlobListOptions to only consume
         * objects we are interested in.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         * 
         * @param prefix the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder prefix(String prefix) {
            doSetProperty("prefix", prefix);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder sendEmptyMessageWhenIdle(boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder sendEmptyMessageWhenIdle(String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder backoffErrorThreshold(int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder backoffErrorThreshold(String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder backoffIdleThreshold(int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder backoffIdleThreshold(String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder backoffMultiplier(int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder backoffMultiplier(String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder initialDelay(String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder repeatCount(long repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder repeatCount(String repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a: <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder runLoggingLevel(org.apache.camel.LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder runLoggingLevel(String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder scheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder scheduledExecutorService(String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option is a: <code>java.lang.Object</code> type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder scheduler(Object scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option will be converted to a <code>java.lang.Object</code> type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder schedulerProperties(String key, Object value) {
            doSetMultiValueProperty("schedulerProperties", "scheduler." + key, value);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param values the values
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder schedulerProperties(Map values) {
            doSetMultiValueProperties("schedulerProperties", "scheduler.", values);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder startScheduler(boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder startScheduler(String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a: <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder useFixedDelay(boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointConsumerBuilder useFixedDelay(String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Google Storage component.
     */
    public interface AdvancedGoogleCloudStorageEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default GoogleCloudStorageEndpointConsumerBuilder basic() {
            return (GoogleCloudStorageEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedGoogleCloudStorageEndpointConsumerBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedGoogleCloudStorageEndpointConsumerBuilder bridgeErrorHandler(String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedGoogleCloudStorageEndpointConsumerBuilder exceptionHandler(org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedGoogleCloudStorageEndpointConsumerBuilder exceptionHandler(String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedGoogleCloudStorageEndpointConsumerBuilder exchangePattern(org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedGoogleCloudStorageEndpointConsumerBuilder exchangePattern(String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedGoogleCloudStorageEndpointConsumerBuilder pollStrategy(org.apache.camel.spi.PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedGoogleCloudStorageEndpointConsumerBuilder pollStrategy(String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Google Storage component.
     */
    public interface GoogleCloudStorageEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedGoogleCloudStorageEndpointProducerBuilder advanced() {
            return (AdvancedGoogleCloudStorageEndpointProducerBuilder) this;
        }

        /**
         * Setting the autocreation of the bucket bucketName.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoCreateBucket the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointProducerBuilder autoCreateBucket(boolean autoCreateBucket) {
            doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }
        /**
         * Setting the autocreation of the bucket bucketName.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoCreateBucket the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointProducerBuilder autoCreateBucket(String autoCreateBucket) {
            doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }
        /**
         * The Service account key that can be used as credentials for the
         * Storage client. It can be loaded by default from classpath, but you
         * can prefix with classpath:, file:, or http: to load the resource from
         * different systems.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param serviceAccountKey the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointProducerBuilder serviceAccountKey(String serviceAccountKey) {
            doSetProperty("serviceAccountKey", serviceAccountKey);
            return this;
        }
        /**
         * The Cloud Storage class to use when creating the new buckets.
         * 
         * The option is a: <code>com.google.cloud.storage.StorageClass</code>
         * type.
         * 
         * Default: STANDARD
         * Group: common
         * 
         * @param storageClass the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointProducerBuilder storageClass(com.google.cloud.storage.StorageClass storageClass) {
            doSetProperty("storageClass", storageClass);
            return this;
        }
        /**
         * The Cloud Storage class to use when creating the new buckets.
         * 
         * The option will be converted to a
         * <code>com.google.cloud.storage.StorageClass</code> type.
         * 
         * Default: STANDARD
         * Group: common
         * 
         * @param storageClass the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointProducerBuilder storageClass(String storageClass) {
            doSetProperty("storageClass", storageClass);
            return this;
        }
        /**
         * The storage client.
         * 
         * The option is a: <code>com.google.cloud.storage.Storage</code> type.
         * 
         * Group: common
         * 
         * @param storageClient the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointProducerBuilder storageClient(com.google.cloud.storage.Storage storageClient) {
            doSetProperty("storageClient", storageClient);
            return this;
        }
        /**
         * The storage client.
         * 
         * The option will be converted to a
         * <code>com.google.cloud.storage.Storage</code> type.
         * 
         * Group: common
         * 
         * @param storageClient the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointProducerBuilder storageClient(String storageClient) {
            doSetProperty("storageClient", storageClient);
            return this;
        }
        /**
         * The Cloud Storage location to use when creating the new buckets.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: US-EAST1
         * Group: common
         * 
         * @param storageLocation the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointProducerBuilder storageLocation(String storageLocation) {
            doSetProperty("storageLocation", storageLocation);
            return this;
        }
        /**
         * The Object name inside the bucket.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param objectName the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointProducerBuilder objectName(String objectName) {
            doSetProperty("objectName", objectName);
            return this;
        }
        /**
         * Set the operation for the producer.
         * 
         * The option is a:
         * <code>org.apache.camel.component.google.storage.GoogleCloudStorageOperations</code> type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointProducerBuilder operation(org.apache.camel.component.google.storage.GoogleCloudStorageOperations operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Set the operation for the producer.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.google.storage.GoogleCloudStorageOperations</code> type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointProducerBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Google Storage component.
     */
    public interface AdvancedGoogleCloudStorageEndpointProducerBuilder extends EndpointProducerBuilder {
        default GoogleCloudStorageEndpointProducerBuilder basic() {
            return (GoogleCloudStorageEndpointProducerBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedGoogleCloudStorageEndpointProducerBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedGoogleCloudStorageEndpointProducerBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Google Storage component.
     */
    public interface GoogleCloudStorageEndpointBuilder
            extends
                GoogleCloudStorageEndpointConsumerBuilder,
                GoogleCloudStorageEndpointProducerBuilder {
        default AdvancedGoogleCloudStorageEndpointBuilder advanced() {
            return (AdvancedGoogleCloudStorageEndpointBuilder) this;
        }

        /**
         * Setting the autocreation of the bucket bucketName.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoCreateBucket the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointBuilder autoCreateBucket(boolean autoCreateBucket) {
            doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }
        /**
         * Setting the autocreation of the bucket bucketName.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoCreateBucket the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointBuilder autoCreateBucket(String autoCreateBucket) {
            doSetProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }
        /**
         * The Service account key that can be used as credentials for the
         * Storage client. It can be loaded by default from classpath, but you
         * can prefix with classpath:, file:, or http: to load the resource from
         * different systems.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param serviceAccountKey the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointBuilder serviceAccountKey(String serviceAccountKey) {
            doSetProperty("serviceAccountKey", serviceAccountKey);
            return this;
        }
        /**
         * The Cloud Storage class to use when creating the new buckets.
         * 
         * The option is a: <code>com.google.cloud.storage.StorageClass</code>
         * type.
         * 
         * Default: STANDARD
         * Group: common
         * 
         * @param storageClass the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointBuilder storageClass(com.google.cloud.storage.StorageClass storageClass) {
            doSetProperty("storageClass", storageClass);
            return this;
        }
        /**
         * The Cloud Storage class to use when creating the new buckets.
         * 
         * The option will be converted to a
         * <code>com.google.cloud.storage.StorageClass</code> type.
         * 
         * Default: STANDARD
         * Group: common
         * 
         * @param storageClass the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointBuilder storageClass(String storageClass) {
            doSetProperty("storageClass", storageClass);
            return this;
        }
        /**
         * The storage client.
         * 
         * The option is a: <code>com.google.cloud.storage.Storage</code> type.
         * 
         * Group: common
         * 
         * @param storageClient the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointBuilder storageClient(com.google.cloud.storage.Storage storageClient) {
            doSetProperty("storageClient", storageClient);
            return this;
        }
        /**
         * The storage client.
         * 
         * The option will be converted to a
         * <code>com.google.cloud.storage.Storage</code> type.
         * 
         * Group: common
         * 
         * @param storageClient the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointBuilder storageClient(String storageClient) {
            doSetProperty("storageClient", storageClient);
            return this;
        }
        /**
         * The Cloud Storage location to use when creating the new buckets.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: US-EAST1
         * Group: common
         * 
         * @param storageLocation the value to set
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointBuilder storageLocation(String storageLocation) {
            doSetProperty("storageLocation", storageLocation);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Google Storage component.
     */
    public interface AdvancedGoogleCloudStorageEndpointBuilder
            extends
                AdvancedGoogleCloudStorageEndpointConsumerBuilder,
                AdvancedGoogleCloudStorageEndpointProducerBuilder {
        default GoogleCloudStorageEndpointBuilder basic() {
            return (GoogleCloudStorageEndpointBuilder) this;
        }

    }

    public interface GoogleCloudStorageBuilders {
        /**
         * Google Storage (camel-google-storage)
         * Store and retrieve objects from Google Cloud Storage Service using
         * the google-cloud-storage library.
         * 
         * Category: cloud
         * Since: 3.9
         * Maven coordinates: org.apache.camel:camel-google-storage
         * 
         * @return the dsl builder for the headers' name.
         */
        default GoogleCloudStorageHeaderNameBuilder googleStorage() {
            return GoogleCloudStorageHeaderNameBuilder.INSTANCE;
        }
        /**
         * Google Storage (camel-google-storage)
         * Store and retrieve objects from Google Cloud Storage Service using
         * the google-cloud-storage library.
         * 
         * Category: cloud
         * Since: 3.9
         * Maven coordinates: org.apache.camel:camel-google-storage
         * 
         * Syntax: <code>google-storage:bucketName</code>
         * 
         * Path parameter: bucketName (required)
         * Bucket name or ARN
         * 
         * @param path bucketName
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointBuilder googleStorage(String path) {
            return GoogleCloudStorageEndpointBuilderFactory.endpointBuilder("google-storage", path);
        }
        /**
         * Google Storage (camel-google-storage)
         * Store and retrieve objects from Google Cloud Storage Service using
         * the google-cloud-storage library.
         * 
         * Category: cloud
         * Since: 3.9
         * Maven coordinates: org.apache.camel:camel-google-storage
         * 
         * Syntax: <code>google-storage:bucketName</code>
         * 
         * Path parameter: bucketName (required)
         * Bucket name or ARN
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path bucketName
         * @return the dsl builder
         */
        default GoogleCloudStorageEndpointBuilder googleStorage(String componentName, String path) {
            return GoogleCloudStorageEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the Google Storage component.
     */
    public static class GoogleCloudStorageHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final GoogleCloudStorageHeaderNameBuilder INSTANCE = new GoogleCloudStorageHeaderNameBuilder();

        /**
         * The operation to perform.
         * 
         * The option is a: {@code
         * org.apache.camel.component.google.storage.GoogleCloudStorageOperations} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code GoogleCloudStorageOperation}.
         */
        public String googleCloudStorageOperation() {
            return "CamelGoogleCloudStorageOperation";
        }
        /**
         * The bucket Name which this object will be stored or which will be
         * used for the current operation.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code GoogleCloudStorageBucketName}.
         */
        public String googleCloudStorageBucketName() {
            return "CamelGoogleCloudStorageBucketName";
        }
        /**
         * The object Name which will be used for the current operation.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code GoogleCloudStorageObjectName}.
         */
        public String googleCloudStorageObjectName() {
            return "CamelGoogleCloudStorageObjectName";
        }
        /**
         * The prefix to be used in List Objects operation.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code GoogleCloudStoragePrefixName}.
         */
        public String googleCloudStoragePrefixName() {
            return "CamelGoogleCloudStoragePrefixName";
        }
        /**
         * The object Destination Name which will be used for the current
         * operation.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * GoogleCloudStorageDestinationObjectName}.
         */
        public String googleCloudStorageDestinationObjectName() {
            return "CamelGoogleCloudStorageDestinationObjectName";
        }
        /**
         * The bucket Destination Name which will be used for the current
         * operation.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * GoogleCloudStorageDestinationBucketName}.
         */
        public String googleCloudStorageDestinationBucketName() {
            return "CamelGoogleCloudStorageDestinationBucketName";
        }
        /**
         * The time in millisecond the download link will be valid.
         * 
         * The option is a: {@code Long} type.
         * 
         * Default: 300000
         * Group: producer
         * 
         * @return the name of the header {@code
         * GoogleCloudStorageDownloadLinkExpirationTime}.
         */
        public String googleCloudStorageDownloadLinkExpirationTime() {
            return "CamelGoogleCloudStorageDownloadLinkExpirationTime";
        }
        /**
         * The content length of this object.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code
         * GoogleCloudStorageContentLength}.
         */
        public String googleCloudStorageContentLength() {
            return "CamelGoogleCloudStorageContentLength";
        }
        /**
         * The content type of this object.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code GoogleCloudStorageContentType}.
         */
        public String googleCloudStorageContentType() {
            return "CamelGoogleCloudStorageContentType";
        }
        /**
         * The Cache-Control metadata can specify two different aspects of how
         * data is served from Cloud Storage: whether the data can be cached and
         * whether the data can be transformed.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code
         * GoogleCloudStorageCacheControl}.
         */
        public String googleCloudStorageCacheControl() {
            return "CamelGoogleCloudStorageCacheControl";
        }
        /**
         * The content disposition of this object.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code
         * GoogleCloudStorageContentDisposition}.
         */
        public String googleCloudStorageContentDisposition() {
            return "CamelGoogleCloudStorageContentDisposition";
        }
        /**
         * The content encoding of this object.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code
         * GoogleCloudStorageContentEncoding}.
         */
        public String googleCloudStorageContentEncoding() {
            return "CamelGoogleCloudStorageContentEncoding";
        }
        /**
         * The md5 checksum of this object.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code GoogleCloudStorageContentMd5}.
         */
        public String googleCloudStorageContentMd5() {
            return "CamelGoogleCloudStorageContentMd5";
        }
        /**
         * The name of the blob.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code FileName}.
         */
        public String fileName() {
            return "CamelFileName";
        }
        /**
         * The component count of this object.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code
         * GoogleCloudStorageComponentCount}.
         */
        public String googleCloudStorageComponentCount() {
            return "CamelGoogleCloudStorageComponentCount";
        }
        /**
         * The Content-Language metadata indicates the language(s) that the
         * object is intended for.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code
         * GoogleCloudStorageContentLanguage}.
         */
        public String googleCloudStorageContentLanguage() {
            return "CamelGoogleCloudStorageContentLanguage";
        }
        /**
         * The Custom-Time metadata is a user-specified date and time
         * represented in the RFC 3339 format YYYY-MM-DD'T'HH:MM:SS.SS'Z' or
         * YYYY-MM-DD'T'HH:MM:SS'Z' when milliseconds are zero. This metadata is
         * typically set in order to use the DaysSinceCustomTime condition in
         * Object Lifecycle Management.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code GoogleCloudStorageCustomTime}.
         */
        public String googleCloudStorageCustomTime() {
            return "CamelGoogleCloudStorageCustomTime";
        }
        /**
         * The CRC32c of the object.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code GoogleCloudStorageCrc32cHex}.
         */
        public String googleCloudStorageCrc32cHex() {
            return "CamelGoogleCloudStorageCrc32cHex";
        }
        /**
         * The ETag for the Object.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code GoogleCloudStorageETag}.
         */
        public String googleCloudStorageETag() {
            return "CamelGoogleCloudStorageETag";
        }
        /**
         * Is the generation number of the object for which you are retrieving
         * information.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code GoogleCloudStorageGeneration}.
         */
        public String googleCloudStorageGeneration() {
            return "CamelGoogleCloudStorageGeneration";
        }
        /**
         * The blob id of the object.
         * 
         * The option is a: {@code com.google.cloud.storage.BlobId} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code GoogleCloudStorageBlobId}.
         */
        public String googleCloudStorageBlobId() {
            return "CamelGoogleCloudStorageBlobId";
        }
        /**
         * The KMS key name.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code GoogleCloudStorageKmsKeyName}.
         */
        public String googleCloudStorageKmsKeyName() {
            return "CamelGoogleCloudStorageKmsKeyName";
        }
        /**
         * The media link.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code GoogleCloudStorageMediaLink}.
         */
        public String googleCloudStorageMediaLink() {
            return "CamelGoogleCloudStorageMediaLink";
        }
        /**
         * The metageneration of the object.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code
         * GoogleCloudStorageMetageneration}.
         */
        public String googleCloudStorageMetageneration() {
            return "CamelGoogleCloudStorageMetageneration";
        }
        /**
         * The storage class of the object.
         * 
         * The option is a: {@code com.google.cloud.storage.StorageClass} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code
         * GoogleCloudStorageStorageClass}.
         */
        public String googleCloudStorageStorageClass() {
            return "CamelGoogleCloudStorageStorageClass";
        }
        /**
         * The creation time of the object.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code GoogleCloudStorageCreateTime}.
         */
        public String googleCloudStorageCreateTime() {
            return "CamelGoogleCloudStorageCreateTime";
        }
        /**
         * The last update of the object.
         * 
         * The option is a: {@code Date} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code GoogleCloudStorageLastUpdate}.
         */
        public String googleCloudStorageLastUpdate() {
            return "CamelGoogleCloudStorageLastUpdate";
        }
    }
    static GoogleCloudStorageEndpointBuilder endpointBuilder(String componentName, String path) {
        class GoogleCloudStorageEndpointBuilderImpl extends AbstractEndpointBuilder implements GoogleCloudStorageEndpointBuilder, AdvancedGoogleCloudStorageEndpointBuilder {
            public GoogleCloudStorageEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new GoogleCloudStorageEndpointBuilderImpl(path);
    }
}