/*
 * Camel EndpointConfiguration generated by camel-api-component-maven-plugin
 */
package org.apache.camel.component.google.drive;

import org.apache.camel.spi.ApiMethod;
import org.apache.camel.spi.ApiParam;
import org.apache.camel.spi.ApiParams;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

/**
 * Camel endpoint configuration for {@link com.google.api.services.drive.Drive.Files}.
 */
@ApiParams(apiName = "drive-files", 
           description = "The files collection of methods",
           apiMethods = {@ApiMethod(methodName = "accessproposals", description="An accessor for creating requests from the Accessproposals collection", signatures={"com.google.api.services.drive.Drive$Files$Accessproposals accessproposals()"}), @ApiMethod(methodName = "copy", description="Creates a copy of a file and applies any requested updates with patch semantics", signatures={"com.google.api.services.drive.Drive$Files$Copy copy(String fileId, com.google.api.services.drive.model.File content)"}), @ApiMethod(methodName = "create", description="Creates a new file", signatures={"com.google.api.services.drive.Drive$Files$Create create(com.google.api.services.drive.model.File content)", "com.google.api.services.drive.Drive$Files$Create create(com.google.api.services.drive.model.File content, com.google.api.client.http.AbstractInputStreamContent mediaContent)"}), @ApiMethod(methodName = "delete", description="Permanently deletes a file owned by the user without moving it to the trash", signatures={"com.google.api.services.drive.Drive$Files$Delete delete(String fileId)"}), @ApiMethod(methodName = "download", description="Downloads content of a file", signatures={"com.google.api.services.drive.Drive$Files$Download download(String fileId)"}), @ApiMethod(methodName = "emptyTrash", description="Permanently deletes all of the user's trashed files", signatures={"com.google.api.services.drive.Drive$Files$EmptyTrash emptyTrash()"}), @ApiMethod(methodName = "export", description="Exports a Google Workspace document to the requested MIME type and returns exported byte content", signatures={"com.google.api.services.drive.Drive$Files$Export export(String fileId, String mimeType)"}), @ApiMethod(methodName = "generateIds", description="Generates a set of file IDs which can be provided in create or copy requests", signatures={"com.google.api.services.drive.Drive$Files$GenerateIds generateIds()"}), @ApiMethod(methodName = "get", description="Gets a file's metadata or content by ID", signatures={"com.google.api.services.drive.Drive$Files$Get get(String fileId)"}), @ApiMethod(methodName = "list", description="Lists the user's files", signatures={"com.google.api.services.drive.Drive$Files$List list()"}), @ApiMethod(methodName = "listLabels", description="Lists the labels on a file", signatures={"com.google.api.services.drive.Drive$Files$ListLabels listLabels(String fileId)"}), @ApiMethod(methodName = "modifyLabels", description="Modifies the set of labels applied to a file", signatures={"com.google.api.services.drive.Drive$Files$ModifyLabels modifyLabels(String fileId, com.google.api.services.drive.model.ModifyLabelsRequest content)"}), @ApiMethod(methodName = "update", description="Updates a file's metadata and/or content", signatures={"com.google.api.services.drive.Drive$Files$Update update(String fileId, com.google.api.services.drive.model.File content)", "com.google.api.services.drive.Drive$Files$Update update(String fileId, com.google.api.services.drive.model.File content, com.google.api.client.http.AbstractInputStreamContent mediaContent)"}), @ApiMethod(methodName = "watch", description="Subscribes to changes to a file", signatures={"com.google.api.services.drive.Drive$Files$Watch watch(String fileId, com.google.api.services.drive.model.Channel content)"})}, aliases = {})
@UriParams
@Configurer(extended = true)
public final class DriveFilesEndpointConfiguration extends GoogleDriveConfiguration {
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "watch", description="The com.google.api.services.drive.model.Channel")})
    private com.google.api.services.drive.model.Channel channel;
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "create", description="The com.google.api.services.drive.model.File media metadata or null if none")})
    private com.google.api.services.drive.model.File content;
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "copy", description="The com.google.api.services.drive.model.File"), @ApiMethod(methodName = "update", description="The com.google.api.services.drive.model.File media metadata or null if none")})
    private com.google.api.services.drive.model.File file;
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "copy", description="The ID of the file"), @ApiMethod(methodName = "delete", description="The ID of the file"), @ApiMethod(methodName = "download", description="Required. The ID of the file to download."), @ApiMethod(methodName = "export", description="The ID of the file"), @ApiMethod(methodName = "get", description="The ID of the file"), @ApiMethod(methodName = "listLabels", description="The ID for the file"), @ApiMethod(methodName = "modifyLabels", description="The ID of the file to which the labels belong"), @ApiMethod(methodName = "update", description="The ID of the file"), @ApiMethod(methodName = "watch", description="The ID of the file")})
    private String fileId;
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "create", description="The media HTTP content"), @ApiMethod(methodName = "update", description="The media HTTP content")})
    private com.google.api.client.http.AbstractInputStreamContent mediaContent;
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "export", description="Required. The MIME type of the format requested for this export.")})
    private String mimeType;
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "modifyLabels", description="The com.google.api.services.drive.model.ModifyLabelsRequest")})
    private com.google.api.services.drive.model.ModifyLabelsRequest modifyLabelsRequest;

    public com.google.api.services.drive.model.Channel getChannel() {
        return channel;
    }

    public void setChannel(com.google.api.services.drive.model.Channel channel) {
        this.channel = channel;
    }

    public com.google.api.services.drive.model.File getContent() {
        return content;
    }

    public void setContent(com.google.api.services.drive.model.File content) {
        this.content = content;
    }

    public com.google.api.services.drive.model.File getFile() {
        return file;
    }

    public void setFile(com.google.api.services.drive.model.File file) {
        this.file = file;
    }

    public String getFileId() {
        return fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public com.google.api.client.http.AbstractInputStreamContent getMediaContent() {
        return mediaContent;
    }

    public void setMediaContent(com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        this.mediaContent = mediaContent;
    }

    public String getMimeType() {
        return mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public com.google.api.services.drive.model.ModifyLabelsRequest getModifyLabelsRequest() {
        return modifyLabelsRequest;
    }

    public void setModifyLabelsRequest(com.google.api.services.drive.model.ModifyLabelsRequest modifyLabelsRequest) {
        this.modifyLabelsRequest = modifyLabelsRequest;
    }
}
