/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.dsl.yaml.common.exception;

import java.util.Optional;

import org.snakeyaml.engine.v2.exceptions.MarkedYamlEngineException;
import org.snakeyaml.engine.v2.nodes.Node;

public class YamlDeserializationException extends MarkedYamlEngineException {

    public YamlDeserializationException(String message) {
        super(null, Optional.empty(), message, Optional.empty());
    }

    public YamlDeserializationException(Node node, String message) {
        super(null, Optional.empty(), message, node.getStartMark());
    }

    public YamlDeserializationException(String message, Throwable cause) {
        super(null, Optional.empty(), message, Optional.empty(), cause);
    }

    public YamlDeserializationException(Node node, String message, Throwable cause) {
        super(null, Optional.empty(), message, node.getStartMark(), cause);
    }

}
