/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Generated by camel build tools - do NOT edit this file!
 */
package org.apache.camel.xml.in;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.processing.Generated;
import org.w3c.dom.Element;

import java.lang.*;
import org.apache.camel.*;
import org.apache.camel.model.*;
import org.apache.camel.model.app.*;
import org.apache.camel.model.cloud.*;
import org.apache.camel.model.config.*;
import org.apache.camel.model.dataformat.*;
import org.apache.camel.model.errorhandler.*;
import org.apache.camel.model.language.*;
import org.apache.camel.model.loadbalancer.*;
import org.apache.camel.model.rest.*;
import org.apache.camel.model.transformer.*;
import org.apache.camel.model.validator.*;
import org.apache.camel.spi.*;
import org.apache.camel.xml.io.XmlPullParserException;

@Generated("org.apache.camel.maven.packaging.ModelXmlParserGeneratorMojo")
@SuppressWarnings("unused")
public class ModelParser extends BaseParser {

    public ModelParser(Resource input) throws IOException, XmlPullParserException {
        super(input);
    }
    public ModelParser(Resource input, String namespace) throws IOException, XmlPullParserException {
        super(input, namespace);
    }
    public ModelParser(InputStream input) throws IOException, XmlPullParserException {
        super(input);
    }
    public ModelParser(Reader reader) throws IOException, XmlPullParserException {
        super(reader);
    }
    public ModelParser(InputStream input, String namespace) throws IOException, XmlPullParserException {
        super(input, namespace);
    }
    public ModelParser(Reader reader, String namespace) throws IOException, XmlPullParserException {
        super(reader, namespace);
    }

    protected AggregateDefinition doParseAggregateDefinition() throws IOException, XmlPullParserException {
        return doParse(new AggregateDefinition(), (def, key, val) -> switch (key) {
                case "aggregateController": def.setAggregateController(val); yield true;
                case "aggregationRepository": def.setAggregationRepository(val); yield true;
                case "aggregationStrategy": def.setAggregationStrategy(val); yield true;
                case "aggregationStrategyMethodAllowNull": def.setAggregationStrategyMethodAllowNull(val); yield true;
                case "aggregationStrategyMethodName": def.setAggregationStrategyMethodName(val); yield true;
                case "closeCorrelationKeyOnCompletion": def.setCloseCorrelationKeyOnCompletion(val); yield true;
                case "completeAllOnStop": def.setCompleteAllOnStop(val); yield true;
                case "completionFromBatchConsumer": def.setCompletionFromBatchConsumer(val); yield true;
                case "completionInterval": def.setCompletionInterval(val); yield true;
                case "completionOnNewCorrelationGroup": def.setCompletionOnNewCorrelationGroup(val); yield true;
                case "completionSize": def.setCompletionSize(val); yield true;
                case "completionTimeout": def.setCompletionTimeout(val); yield true;
                case "completionTimeoutCheckerInterval": def.setCompletionTimeoutCheckerInterval(val); yield true;
                case "discardOnAggregationFailure": def.setDiscardOnAggregationFailure(val); yield true;
                case "discardOnCompletionTimeout": def.setDiscardOnCompletionTimeout(val); yield true;
                case "eagerCheckCompletion": def.setEagerCheckCompletion(val); yield true;
                case "executorService": def.setExecutorService(val); yield true;
                case "forceCompletionOnStop": def.setForceCompletionOnStop(val); yield true;
                case "ignoreInvalidCorrelationKeys": def.setIgnoreInvalidCorrelationKeys(val); yield true;
                case "optimisticLocking": def.setOptimisticLocking(val); yield true;
                case "parallelProcessing": def.setParallelProcessing(val); yield true;
                case "timeoutCheckerExecutorService": def.setTimeoutCheckerExecutorService(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, (def, key) -> switch (key) {
                case "completionPredicate": def.setCompletionPredicate(doParseExpressionSubElementDefinition()); yield true;
                case "completionSizeExpression": def.setCompletionSizeExpression(doParseExpressionSubElementDefinition()); yield true;
                case "completionTimeoutExpression": def.setCompletionTimeoutExpression(doParseExpressionSubElementDefinition()); yield true;
                case "correlationExpression": def.setCorrelationExpression(doParseExpressionSubElementDefinition()); yield true;
                case "optimisticLockRetryPolicy": def.setOptimisticLockRetryPolicyDefinition(doParseOptimisticLockRetryPolicyDefinition()); yield true;
                default: yield outputDefinitionElementHandler().accept(def, key);
            }, noValueHandler());
    }
    protected ExpressionSubElementDefinition doParseExpressionSubElementDefinition() throws IOException, XmlPullParserException {
        return doParse(new ExpressionSubElementDefinition(), noAttributeHandler(), (def, key) -> {
                ExpressionDefinition v = doParseExpressionDefinitionRef(key);
                if (v != null) {
                    def.setExpressionType(v);
                    return true;
                }
                return false;
            }, noValueHandler());
    }
    protected OptimisticLockRetryPolicyDefinition doParseOptimisticLockRetryPolicyDefinition() throws IOException, XmlPullParserException {
        return doParse(new OptimisticLockRetryPolicyDefinition(), (def, key, val) -> switch (key) {
                case "exponentialBackOff": def.setExponentialBackOff(val); yield true;
                case "maximumRetries": def.setMaximumRetries(val); yield true;
                case "maximumRetryDelay": def.setMaximumRetryDelay(val); yield true;
                case "randomBackOff": def.setRandomBackOff(val); yield true;
                case "retryDelay": def.setRetryDelay(val); yield true;
                default: yield false;
            }, noElementHandler(), noValueHandler());
    }
    protected <T extends OutputDefinition> ElementHandler<T> outputDefinitionElementHandler() {
        return (def, key) -> {
            ProcessorDefinition v = doParseProcessorDefinitionRef(key);
            if (v != null) {
                doAdd(v, def.getOutputs(), def::setOutputs);
                return true;
            }
            return optionalIdentifiedDefinitionElementHandler().accept(def, key);
        };
    }
    protected OutputDefinition doParseOutputDefinition() throws IOException, XmlPullParserException {
        return doParse(new OutputDefinition(), processorDefinitionAttributeHandler(), outputDefinitionElementHandler(), noValueHandler());
    }
    protected <T extends ProcessorDefinition> AttributeHandler<T> processorDefinitionAttributeHandler() {
        return (def, key, val) -> switch (key) {
            case "disabled": def.setDisabled(val); yield true;
            case "inheritErrorHandler": def.setInheritErrorHandler(Boolean.valueOf(val)); yield true;
            default: yield optionalIdentifiedDefinitionAttributeHandler().accept(def, key, val);
        };
    }
    protected <T extends OptionalIdentifiedDefinition> AttributeHandler<T> optionalIdentifiedDefinitionAttributeHandler() {
        return (def, key, val) -> switch (key) {
            case "customId": def.setCustomId(Boolean.valueOf(val)); yield true;
            case "description": def.setDescription(val); yield true;
            case "id": def.setId(val); yield true;
            default: yield false;
        };
    }
    protected <T extends OptionalIdentifiedDefinition> ElementHandler<T> optionalIdentifiedDefinitionElementHandler() {
        return (def, key) -> switch (key) {
            case "generatedId": def.setGeneratedId(doParseText()); yield true;
            default: yield false;
        };
    }
    protected BeanDefinition doParseBeanDefinition() throws IOException, XmlPullParserException {
        return doParse(new BeanDefinition(), (def, key, val) -> switch (key) {
                case "beanType": def.setBeanType(val); yield true;
                case "method": def.setMethod(val); yield true;
                case "ref": def.setRef(val); yield true;
                case "scope": def.setScope(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, optionalIdentifiedDefinitionElementHandler(), noValueHandler());
    }
    protected BeanFactoryDefinition doParseBeanFactoryDefinition() throws IOException, XmlPullParserException {
        return doParse(new BeanFactoryDefinition(), (def, key, val) -> switch (key) {
                case "builderClass": def.setBuilderClass(val); yield true;
                case "builderMethod": def.setBuilderMethod(val); yield true;
                case "destroyMethod": def.setDestroyMethod(val); yield true;
                case "factoryBean": def.setFactoryBean(val); yield true;
                case "factoryMethod": def.setFactoryMethod(val); yield true;
                case "initMethod": def.setInitMethod(val); yield true;
                case "name": def.setName(val); yield true;
                case "scriptLanguage": def.setScriptLanguage(val); yield true;
                case "type": def.setType(val); yield true;
                default: yield false;
            }, (def, key) -> switch (key) {
                case "constructors": def.setConstructors(new BeanConstructorsAdapter().unmarshal(doParseBeanConstructorsDefinition())); yield true;
                case "properties": def.setProperties(new BeanPropertiesAdapter().unmarshal(doParseBeanPropertiesDefinition())); yield true;
                case "script": def.setScript(doParseText()); yield true;
                default: yield false;
            }, noValueHandler());
    }
    protected BeanConstructorsDefinition doParseBeanConstructorsDefinition() throws IOException, XmlPullParserException {
        return doParse(new BeanConstructorsDefinition(), noAttributeHandler(), (def, key) -> switch (key) {
                case "constructor": doAdd(doParseBeanConstructorDefinition(), def.getConstructors(), def::setConstructors); yield true;
                default: yield false;
            }, noValueHandler());
    }
    protected BeanPropertiesDefinition doParseBeanPropertiesDefinition() throws IOException, XmlPullParserException {
        return doParse(new BeanPropertiesDefinition(), noAttributeHandler(), (def, key) -> switch (key) {
                case "property": doAdd(doParseBeanPropertyDefinition(), def.getProperties(), def::setProperties); yield true;
                default: yield false;
            }, noValueHandler());
    }
    protected CatchDefinition doParseCatchDefinition() throws IOException, XmlPullParserException {
        return doParse(new CatchDefinition(), processorDefinitionAttributeHandler(), (def, key) -> switch (key) {
                case "exception": doAdd(doParseText(), def.getExceptions(), def::setExceptions); yield true;
                case "onWhen": def.setOnWhen(doParseWhenDefinition()); yield true;
                default: yield outputDefinitionElementHandler().accept(def, key);
            }, noValueHandler());
    }
    protected WhenDefinition doParseWhenDefinition() throws IOException, XmlPullParserException {
        return doParse(new WhenDefinition(), processorDefinitionAttributeHandler(), outputExpressionNodeElementHandler(), noValueHandler());
    }
    protected ChoiceDefinition doParseChoiceDefinition() throws IOException, XmlPullParserException {
        return doParse(new ChoiceDefinition(), (def, key, val) -> switch (key) {
                case "precondition": def.setPrecondition(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, (def, key) -> switch (key) {
                case "otherwise": def.setOtherwise(doParseOtherwiseDefinition()); yield true;
                case "when": doAdd(doParseWhenDefinition(), def.getWhenClauses(), def::setWhenClauses); yield true;
                default: yield optionalIdentifiedDefinitionElementHandler().accept(def, key);
            }, noValueHandler());
    }
    protected OtherwiseDefinition doParseOtherwiseDefinition() throws IOException, XmlPullParserException {
        return doParse(new OtherwiseDefinition(), processorDefinitionAttributeHandler(), outputDefinitionElementHandler(), noValueHandler());
    }
    protected CircuitBreakerDefinition doParseCircuitBreakerDefinition() throws IOException, XmlPullParserException {
        return doParse(new CircuitBreakerDefinition(), (def, key, val) -> switch (key) {
                case "configuration": def.setConfiguration(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, (def, key) -> switch (key) {
                case "faultToleranceConfiguration": def.setFaultToleranceConfiguration(doParseFaultToleranceConfigurationDefinition()); yield true;
                case "onFallback": def.setOnFallback(doParseOnFallbackDefinition()); yield true;
                case "resilience4jConfiguration": def.setResilience4jConfiguration(doParseResilience4jConfigurationDefinition()); yield true;
                default: yield outputDefinitionElementHandler().accept(def, key);
            }, noValueHandler());
    }
    protected Resilience4jConfigurationDefinition doParseResilience4jConfigurationDefinition() throws IOException, XmlPullParserException {
        return doParse(new Resilience4jConfigurationDefinition(), resilience4jConfigurationCommonAttributeHandler(), resilience4jConfigurationCommonElementHandler(), noValueHandler());
    }
    protected FaultToleranceConfigurationDefinition doParseFaultToleranceConfigurationDefinition() throws IOException, XmlPullParserException {
        return doParse(new FaultToleranceConfigurationDefinition(), faultToleranceConfigurationCommonAttributeHandler(), noElementHandler(), noValueHandler());
    }
    protected OnFallbackDefinition doParseOnFallbackDefinition() throws IOException, XmlPullParserException {
        return doParse(new OnFallbackDefinition(), (def, key, val) -> switch (key) {
                case "fallbackViaNetwork": def.setFallbackViaNetwork(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, (def, key) -> {
                ProcessorDefinition v = doParseProcessorDefinitionRef(key);
                if (v != null) {
                    doAdd(v, def.getOutputs(), def::setOutputs);
                    return true;
                }
                return optionalIdentifiedDefinitionElementHandler().accept(def, key);
            }, noValueHandler());
    }
    protected ClaimCheckDefinition doParseClaimCheckDefinition() throws IOException, XmlPullParserException {
        return doParse(new ClaimCheckDefinition(), (def, key, val) -> switch (key) {
                case "aggregationStrategy": def.setAggregationStrategy(val); yield true;
                case "aggregationStrategyMethodName": def.setAggregationStrategyMethodName(val); yield true;
                case "filter": def.setFilter(val); yield true;
                case "key": def.setKey(val); yield true;
                case "operation": def.setOperation(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, optionalIdentifiedDefinitionElementHandler(), noValueHandler());
    }
    protected ContextScanDefinition doParseContextScanDefinition() throws IOException, XmlPullParserException {
        return doParse(new ContextScanDefinition(), (def, key, val) -> switch (key) {
                case "includeNonSingletons": def.setIncludeNonSingletons(val); yield true;
                default: yield false;
            }, (def, key) -> switch (key) {
                case "excludes": doAdd(doParseText(), def.getExcludes(), def::setExcludes); yield true;
                case "includes": doAdd(doParseText(), def.getIncludes(), def::setIncludes); yield true;
                default: yield false;
            }, noValueHandler());
    }
    protected ConvertBodyDefinition doParseConvertBodyDefinition() throws IOException, XmlPullParserException {
        return doParse(new ConvertBodyDefinition(), (def, key, val) -> switch (key) {
                case "charset": def.setCharset(val); yield true;
                case "mandatory": def.setMandatory(val); yield true;
                case "type": def.setType(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, optionalIdentifiedDefinitionElementHandler(), noValueHandler());
    }
    protected ConvertHeaderDefinition doParseConvertHeaderDefinition() throws IOException, XmlPullParserException {
        return doParse(new ConvertHeaderDefinition(), (def, key, val) -> switch (key) {
                case "charset": def.setCharset(val); yield true;
                case "mandatory": def.setMandatory(val); yield true;
                case "name": def.setName(val); yield true;
                case "toName": def.setToName(val); yield true;
                case "type": def.setType(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, optionalIdentifiedDefinitionElementHandler(), noValueHandler());
    }
    protected ConvertVariableDefinition doParseConvertVariableDefinition() throws IOException, XmlPullParserException {
        return doParse(new ConvertVariableDefinition(), (def, key, val) -> switch (key) {
                case "charset": def.setCharset(val); yield true;
                case "mandatory": def.setMandatory(val); yield true;
                case "name": def.setName(val); yield true;
                case "toName": def.setToName(val); yield true;
                case "type": def.setType(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, optionalIdentifiedDefinitionElementHandler(), noValueHandler());
    }
    protected DataFormatDefinition doParseDataFormatDefinition() throws IOException, XmlPullParserException {
        return doParse(new DataFormatDefinition(), identifiedTypeAttributeHandler(), noElementHandler(), noValueHandler());
    }
    protected <T extends IdentifiedType> AttributeHandler<T> identifiedTypeAttributeHandler() {
        return (def, key, val) -> switch (key) {
            case "id": def.setId(val); yield true;
            default: yield false;
        };
    }
    protected DelayDefinition doParseDelayDefinition() throws IOException, XmlPullParserException {
        return doParse(new DelayDefinition(), (def, key, val) -> switch (key) {
                case "asyncDelayed": def.setAsyncDelayed(val); yield true;
                case "callerRunsWhenRejected": def.setCallerRunsWhenRejected(val); yield true;
                case "executorService": def.setExecutorService(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, expressionNodeElementHandler(), noValueHandler());
    }
    protected <T extends ExpressionNode> ElementHandler<T> expressionNodeElementHandler() {
        return (def, key) -> {
            ExpressionDefinition v = doParseExpressionDefinitionRef(key);
            if (v != null) {
                def.setExpression(v);
                return true;
            }
            return optionalIdentifiedDefinitionElementHandler().accept(def, key);
        };
    }
    protected <T extends ExpressionDefinition> AttributeHandler<T> expressionDefinitionAttributeHandler() {
        return (def, key, val) -> switch (key) {
            case "id": def.setId(val); yield true;
            case "trim": def.setTrim(val); yield true;
            default: yield false;
        };
    }
    protected ExpressionDefinition doParseExpressionDefinition() throws IOException, XmlPullParserException {
        return doParse(new ExpressionDefinition(), expressionDefinitionAttributeHandler(), noElementHandler(), expressionDefinitionValueHandler());
    }
    protected DynamicRouterDefinition doParseDynamicRouterDefinition() throws IOException, XmlPullParserException {
        return doParse(new DynamicRouterDefinition(), (def, key, val) -> switch (key) {
                case "cacheSize": def.setCacheSize(val); yield true;
                case "ignoreInvalidEndpoints": def.setIgnoreInvalidEndpoints(val); yield true;
                case "uriDelimiter": def.setUriDelimiter(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, expressionNodeElementHandler(), noValueHandler());
    }
    protected EnrichDefinition doParseEnrichDefinition() throws IOException, XmlPullParserException {
        return doParse(new EnrichDefinition(), (def, key, val) -> switch (key) {
                case "aggregateOnException": def.setAggregateOnException(val); yield true;
                case "aggregationStrategy": def.setAggregationStrategy(val); yield true;
                case "aggregationStrategyMethodAllowNull": def.setAggregationStrategyMethodAllowNull(val); yield true;
                case "aggregationStrategyMethodName": def.setAggregationStrategyMethodName(val); yield true;
                case "allowOptimisedComponents": def.setAllowOptimisedComponents(val); yield true;
                case "autoStartComponents": def.setAutoStartComponents(val); yield true;
                case "cacheSize": def.setCacheSize(val); yield true;
                case "ignoreInvalidEndpoint": def.setIgnoreInvalidEndpoint(val); yield true;
                case "shareUnitOfWork": def.setShareUnitOfWork(val); yield true;
                case "variableReceive": def.setVariableReceive(val); yield true;
                case "variableSend": def.setVariableSend(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, expressionNodeElementHandler(), noValueHandler());
    }
    protected ErrorHandlerDefinition doParseErrorHandlerDefinition() throws IOException, XmlPullParserException {
        return doParse(new ErrorHandlerDefinition(), identifiedTypeAttributeHandler(), (def, key) -> switch (key) {
                case "deadLetterChannel": def.setErrorHandlerType(doParseDeadLetterChannelDefinition()); yield true;
                case "defaultErrorHandler": def.setErrorHandlerType(doParseDefaultErrorHandlerDefinition()); yield true;
                case "noErrorHandler": def.setErrorHandlerType(doParseNoErrorHandlerDefinition()); yield true;
                case "refErrorHandler": def.setErrorHandlerType(doParseRefErrorHandlerDefinition()); yield true;
                case "jtaTransactionErrorHandler": def.setErrorHandlerType(doParseJtaTransactionErrorHandlerDefinition()); yield true;
                case "springTransactionErrorHandler": def.setErrorHandlerType(doParseSpringTransactionErrorHandlerDefinition()); yield true;
                default: yield false;
            }, noValueHandler());
    }
    protected <T extends FaultToleranceConfigurationCommon> AttributeHandler<T> faultToleranceConfigurationCommonAttributeHandler() {
        return (def, key, val) -> switch (key) {
            case "bulkheadEnabled": def.setBulkheadEnabled(val); yield true;
            case "bulkheadExecutorService": def.setBulkheadExecutorService(val); yield true;
            case "bulkheadMaxConcurrentCalls": def.setBulkheadMaxConcurrentCalls(val); yield true;
            case "bulkheadWaitingTaskQueue": def.setBulkheadWaitingTaskQueue(val); yield true;
            case "circuitBreaker": def.setCircuitBreaker(val); yield true;
            case "delay": def.setDelay(val); yield true;
            case "failureRatio": def.setFailureRatio(val); yield true;
            case "requestVolumeThreshold": def.setRequestVolumeThreshold(val); yield true;
            case "successThreshold": def.setSuccessThreshold(val); yield true;
            case "timeoutDuration": def.setTimeoutDuration(val); yield true;
            case "timeoutEnabled": def.setTimeoutEnabled(val); yield true;
            case "timeoutPoolSize": def.setTimeoutPoolSize(val); yield true;
            case "timeoutScheduledExecutorService": def.setTimeoutScheduledExecutorService(val); yield true;
            default: yield identifiedTypeAttributeHandler().accept(def, key, val);
        };
    }
    protected FaultToleranceConfigurationCommon doParseFaultToleranceConfigurationCommon() throws IOException, XmlPullParserException {
        return doParse(new FaultToleranceConfigurationCommon(), faultToleranceConfigurationCommonAttributeHandler(), noElementHandler(), noValueHandler());
    }
    protected FilterDefinition doParseFilterDefinition() throws IOException, XmlPullParserException {
        return doParse(new FilterDefinition(), (def, key, val) -> switch (key) {
                case "statusPropertyName": def.setStatusPropertyName(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, outputExpressionNodeElementHandler(), noValueHandler());
    }
    protected <T extends OutputExpressionNode> ElementHandler<T> outputExpressionNodeElementHandler() {
        return (def, key) -> {
            ProcessorDefinition v = doParseProcessorDefinitionRef(key);
            if (v != null) {
                doAdd(v, def.getOutputs(), def::setOutputs);
                return true;
            }
            return expressionNodeElementHandler().accept(def, key);
        };
    }
    protected FinallyDefinition doParseFinallyDefinition() throws IOException, XmlPullParserException {
        return doParse(new FinallyDefinition(), processorDefinitionAttributeHandler(), outputDefinitionElementHandler(), noValueHandler());
    }
    protected FromDefinition doParseFromDefinition() throws IOException, XmlPullParserException {
        return doParse(new FromDefinition(), (def, key, val) -> switch (key) {
                case "uri": def.setUri(sanitizeUri(val)); yield true;
                case "variableReceive": def.setVariableReceive(val); yield true;
                default: yield optionalIdentifiedDefinitionAttributeHandler().accept(def, key, val);
            }, optionalIdentifiedDefinitionElementHandler(), noValueHandler());
    }
    protected GlobalOptionDefinition doParseGlobalOptionDefinition() throws IOException, XmlPullParserException {
        return doParse(new GlobalOptionDefinition(), (def, key, val) -> switch (key) {
                case "key": def.setKey(val); yield true;
                case "value": def.setValue(val); yield true;
                default: yield false;
            }, noElementHandler(), noValueHandler());
    }
    protected GlobalOptionsDefinition doParseGlobalOptionsDefinition() throws IOException, XmlPullParserException {
        return doParse(new GlobalOptionsDefinition(), noAttributeHandler(), (def, key) -> switch (key) {
                case "globalOption": doAdd(doParseGlobalOptionDefinition(), def.getGlobalOptions(), def::setGlobalOptions); yield true;
                default: yield false;
            }, noValueHandler());
    }
    protected IdempotentConsumerDefinition doParseIdempotentConsumerDefinition() throws IOException, XmlPullParserException {
        return doParse(new IdempotentConsumerDefinition(), (def, key, val) -> switch (key) {
                case "completionEager": def.setCompletionEager(val); yield true;
                case "eager": def.setEager(val); yield true;
                case "idempotentRepository": def.setIdempotentRepository(val); yield true;
                case "removeOnFailure": def.setRemoveOnFailure(val); yield true;
                case "skipDuplicate": def.setSkipDuplicate(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, outputExpressionNodeElementHandler(), noValueHandler());
    }
    protected InputTypeDefinition doParseInputTypeDefinition() throws IOException, XmlPullParserException {
        return doParse(new InputTypeDefinition(), (def, key, val) -> switch (key) {
                case "urn": def.setUrn(val); yield true;
                case "validate": def.setValidate(val); yield true;
                default: yield optionalIdentifiedDefinitionAttributeHandler().accept(def, key, val);
            }, optionalIdentifiedDefinitionElementHandler(), noValueHandler());
    }
    protected InterceptDefinition doParseInterceptDefinition() throws IOException, XmlPullParserException {
        return doParse(new InterceptDefinition(), processorDefinitionAttributeHandler(), outputDefinitionElementHandler(), noValueHandler());
    }
    protected InterceptFromDefinition doParseInterceptFromDefinition() throws IOException, XmlPullParserException {
        return doParse(new InterceptFromDefinition(), (def, key, val) -> switch (key) {
                case "uri": def.setUri(sanitizeUri(val)); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, outputDefinitionElementHandler(), noValueHandler());
    }
    protected InterceptSendToEndpointDefinition doParseInterceptSendToEndpointDefinition() throws IOException, XmlPullParserException {
        return doParse(new InterceptSendToEndpointDefinition(), (def, key, val) -> switch (key) {
                case "afterUri": def.setAfterUri(val); yield true;
                case "skipSendToOriginalEndpoint": def.setSkipSendToOriginalEndpoint(val); yield true;
                case "uri": def.setUri(sanitizeUri(val)); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, outputDefinitionElementHandler(), noValueHandler());
    }
    protected KameletDefinition doParseKameletDefinition() throws IOException, XmlPullParserException {
        return doParse(new KameletDefinition(), (def, key, val) -> switch (key) {
                case "name": def.setName(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, outputDefinitionElementHandler(), noValueHandler());
    }
    protected LoadBalanceDefinition doParseLoadBalanceDefinition() throws IOException, XmlPullParserException {
        return doParse(new LoadBalanceDefinition(), processorDefinitionAttributeHandler(), (def, key) -> switch (key) {
                case "customLoadBalancer": def.setLoadBalancerType(doParseCustomLoadBalancerDefinition()); yield true;
                case "failover": def.setLoadBalancerType(doParseFailoverLoadBalancerDefinition()); yield true;
                case "random": def.setLoadBalancerType(doParseRandomLoadBalancerDefinition()); yield true;
                case "roundRobin": def.setLoadBalancerType(doParseRoundRobinLoadBalancerDefinition()); yield true;
                case "sticky": def.setLoadBalancerType(doParseStickyLoadBalancerDefinition()); yield true;
                case "topic": def.setLoadBalancerType(doParseTopicLoadBalancerDefinition()); yield true;
                case "weighted": def.setLoadBalancerType(doParseWeightedLoadBalancerDefinition()); yield true;
                default: yield outputDefinitionElementHandler().accept(def, key);
            }, noValueHandler());
    }
    protected LogDefinition doParseLogDefinition() throws IOException, XmlPullParserException {
        return doParse(new LogDefinition(), (def, key, val) -> switch (key) {
                case "logName": def.setLogName(val); yield true;
                case "logger": def.setLogger(val); yield true;
                case "loggingLevel": def.setLoggingLevel(val); yield true;
                case "marker": def.setMarker(val); yield true;
                case "message": def.setMessage(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, optionalIdentifiedDefinitionElementHandler(), noValueHandler());
    }
    protected LoopDefinition doParseLoopDefinition() throws IOException, XmlPullParserException {
        return doParse(new LoopDefinition(), (def, key, val) -> switch (key) {
                case "breakOnShutdown": def.setBreakOnShutdown(val); yield true;
                case "copy": def.setCopy(val); yield true;
                case "doWhile": def.setDoWhile(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, outputExpressionNodeElementHandler(), noValueHandler());
    }
    protected MarshalDefinition doParseMarshalDefinition() throws IOException, XmlPullParserException {
        return doParse(new MarshalDefinition(), (def, key, val) -> switch (key) {
                case "variableReceive": def.setVariableReceive(val); yield true;
                case "variableSend": def.setVariableSend(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, (def, key) -> {
                DataFormatDefinition v = doParseDataFormatDefinitionRef(key);
                if (v != null) {
                    def.setDataFormatType(v);
                    return true;
                }
                return optionalIdentifiedDefinitionElementHandler().accept(def, key);
            }, noValueHandler());
    }
    protected MulticastDefinition doParseMulticastDefinition() throws IOException, XmlPullParserException {
        return doParse(new MulticastDefinition(), (def, key, val) -> switch (key) {
                case "aggregationStrategy": def.setAggregationStrategy(val); yield true;
                case "aggregationStrategyMethodAllowNull": def.setAggregationStrategyMethodAllowNull(val); yield true;
                case "aggregationStrategyMethodName": def.setAggregationStrategyMethodName(val); yield true;
                case "executorService": def.setExecutorService(val); yield true;
                case "onPrepare": def.setOnPrepare(val); yield true;
                case "parallelAggregate": def.setParallelAggregate(val); yield true;
                case "parallelProcessing": def.setParallelProcessing(val); yield true;
                case "shareUnitOfWork": def.setShareUnitOfWork(val); yield true;
                case "stopOnException": def.setStopOnException(val); yield true;
                case "streaming": def.setStreaming(val); yield true;
                case "synchronous": def.setSynchronous(val); yield true;
                case "timeout": def.setTimeout(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, outputDefinitionElementHandler(), noValueHandler());
    }
    protected OnCompletionDefinition doParseOnCompletionDefinition() throws IOException, XmlPullParserException {
        return doParse(new OnCompletionDefinition(), (def, key, val) -> switch (key) {
                case "executorService": def.setExecutorService(val); yield true;
                case "mode": def.setMode(val); yield true;
                case "onCompleteOnly": def.setOnCompleteOnly(val); yield true;
                case "onFailureOnly": def.setOnFailureOnly(val); yield true;
                case "parallelProcessing": def.setParallelProcessing(val); yield true;
                case "useOriginalMessage": def.setUseOriginalMessage(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, (def, key) -> switch (key) {
                case "onWhen": def.setOnWhen(doParseWhenDefinition()); yield true;
                default: yield outputDefinitionElementHandler().accept(def, key);
            }, noValueHandler());
    }
    protected OnExceptionDefinition doParseOnExceptionDefinition() throws IOException, XmlPullParserException {
        return doParse(new OnExceptionDefinition(), (def, key, val) -> switch (key) {
                case "onExceptionOccurredRef": def.setOnExceptionOccurredRef(val); yield true;
                case "onRedeliveryRef": def.setOnRedeliveryRef(val); yield true;
                case "redeliveryPolicyRef": def.setRedeliveryPolicyRef(val); yield true;
                case "useOriginalBody": def.setUseOriginalBody(val); yield true;
                case "useOriginalMessage": def.setUseOriginalMessage(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, (def, key) -> switch (key) {
                case "continued": def.setContinued(doParseExpressionSubElementDefinition()); yield true;
                case "exception": doAdd(doParseText(), def.getExceptions(), def::setExceptions); yield true;
                case "handled": def.setHandled(doParseExpressionSubElementDefinition()); yield true;
                case "onWhen": def.setOnWhen(doParseWhenDefinition()); yield true;
                case "redeliveryPolicy": def.setRedeliveryPolicyType(doParseRedeliveryPolicyDefinition()); yield true;
                case "retryWhile": def.setRetryWhile(doParseExpressionSubElementDefinition()); yield true;
                default: yield outputDefinitionElementHandler().accept(def, key);
            }, noValueHandler());
    }
    protected RedeliveryPolicyDefinition doParseRedeliveryPolicyDefinition() throws IOException, XmlPullParserException {
        return doParse(new RedeliveryPolicyDefinition(), (def, key, val) -> switch (key) {
                case "allowRedeliveryWhileStopping": def.setAllowRedeliveryWhileStopping(val); yield true;
                case "asyncDelayedRedelivery": def.setAsyncDelayedRedelivery(val); yield true;
                case "backOffMultiplier": def.setBackOffMultiplier(val); yield true;
                case "collisionAvoidanceFactor": def.setCollisionAvoidanceFactor(val); yield true;
                case "delayPattern": def.setDelayPattern(val); yield true;
                case "disableRedelivery": def.setDisableRedelivery(val); yield true;
                case "exchangeFormatterRef": def.setExchangeFormatterRef(val); yield true;
                case "logContinued": def.setLogContinued(val); yield true;
                case "logExhausted": def.setLogExhausted(val); yield true;
                case "logExhaustedMessageBody": def.setLogExhaustedMessageBody(val); yield true;
                case "logExhaustedMessageHistory": def.setLogExhaustedMessageHistory(val); yield true;
                case "logHandled": def.setLogHandled(val); yield true;
                case "logNewException": def.setLogNewException(val); yield true;
                case "logRetryAttempted": def.setLogRetryAttempted(val); yield true;
                case "logRetryStackTrace": def.setLogRetryStackTrace(val); yield true;
                case "logStackTrace": def.setLogStackTrace(val); yield true;
                case "maximumRedeliveries": def.setMaximumRedeliveries(val); yield true;
                case "maximumRedeliveryDelay": def.setMaximumRedeliveryDelay(val); yield true;
                case "redeliveryDelay": def.setRedeliveryDelay(val); yield true;
                case "retriesExhaustedLogLevel": def.setRetriesExhaustedLogLevel(val); yield true;
                case "retryAttemptedLogInterval": def.setRetryAttemptedLogInterval(val); yield true;
                case "retryAttemptedLogLevel": def.setRetryAttemptedLogLevel(val); yield true;
                case "useCollisionAvoidance": def.setUseCollisionAvoidance(val); yield true;
                case "useExponentialBackOff": def.setUseExponentialBackOff(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected OutputTypeDefinition doParseOutputTypeDefinition() throws IOException, XmlPullParserException {
        return doParse(new OutputTypeDefinition(), (def, key, val) -> switch (key) {
                case "urn": def.setUrn(val); yield true;
                case "validate": def.setValidate(val); yield true;
                default: yield optionalIdentifiedDefinitionAttributeHandler().accept(def, key, val);
            }, optionalIdentifiedDefinitionElementHandler(), noValueHandler());
    }
    protected PackageScanDefinition doParsePackageScanDefinition() throws IOException, XmlPullParserException {
        return doParse(new PackageScanDefinition(), noAttributeHandler(), (def, key) -> switch (key) {
                case "excludes": doAdd(doParseText(), def.getExcludes(), def::setExcludes); yield true;
                case "includes": doAdd(doParseText(), def.getIncludes(), def::setIncludes); yield true;
                case "package": doAdd(doParseText(), def.getPackages(), def::setPackages); yield true;
                default: yield false;
            }, noValueHandler());
    }
    protected PausableDefinition doParsePausableDefinition() throws IOException, XmlPullParserException {
        return doParse(new PausableDefinition(), (def, key, val) -> switch (key) {
                case "consumerListener": def.setConsumerListener(val); yield true;
                case "untilCheck": def.setUntilCheck(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, optionalIdentifiedDefinitionElementHandler(), noValueHandler());
    }
    protected PipelineDefinition doParsePipelineDefinition() throws IOException, XmlPullParserException {
        return doParse(new PipelineDefinition(), processorDefinitionAttributeHandler(), outputDefinitionElementHandler(), noValueHandler());
    }
    protected PolicyDefinition doParsePolicyDefinition() throws IOException, XmlPullParserException {
        return doParse(new PolicyDefinition(), (def, key, val) -> switch (key) {
                case "ref": def.setRef(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, outputDefinitionElementHandler(), noValueHandler());
    }
    protected PollEnrichDefinition doParsePollEnrichDefinition() throws IOException, XmlPullParserException {
        return doParse(new PollEnrichDefinition(), (def, key, val) -> switch (key) {
                case "aggregateOnException": def.setAggregateOnException(val); yield true;
                case "aggregationStrategy": def.setAggregationStrategy(val); yield true;
                case "aggregationStrategyMethodAllowNull": def.setAggregationStrategyMethodAllowNull(val); yield true;
                case "aggregationStrategyMethodName": def.setAggregationStrategyMethodName(val); yield true;
                case "autoStartComponents": def.setAutoStartComponents(val); yield true;
                case "cacheSize": def.setCacheSize(val); yield true;
                case "ignoreInvalidEndpoint": def.setIgnoreInvalidEndpoint(val); yield true;
                case "timeout": def.setTimeout(val); yield true;
                case "variableReceive": def.setVariableReceive(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, expressionNodeElementHandler(), noValueHandler());
    }
    protected ProcessDefinition doParseProcessDefinition() throws IOException, XmlPullParserException {
        return doParse(new ProcessDefinition(), (def, key, val) -> switch (key) {
                case "ref": def.setRef(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, optionalIdentifiedDefinitionElementHandler(), noValueHandler());
    }
    protected PropertyDefinition doParsePropertyDefinition() throws IOException, XmlPullParserException {
        return doParse(new PropertyDefinition(), (def, key, val) -> switch (key) {
                case "key": def.setKey(val); yield true;
                case "value": def.setValue(val); yield true;
                default: yield false;
            }, noElementHandler(), noValueHandler());
    }
    protected PropertyDefinitions doParsePropertyDefinitions() throws IOException, XmlPullParserException {
        return doParse(new PropertyDefinitions(), noAttributeHandler(), (def, key) -> switch (key) {
                case "property": doAdd(doParsePropertyDefinition(), def.getProperties(), def::setProperties); yield true;
                default: yield false;
            }, noValueHandler());
    }
    protected PropertyExpressionDefinition doParsePropertyExpressionDefinition() throws IOException, XmlPullParserException {
        return doParse(new PropertyExpressionDefinition(), (def, key, val) -> switch (key) {
                case "key": def.setKey(val); yield true;
                default: yield false;
            }, (def, key) -> {
                ExpressionDefinition v = doParseExpressionDefinitionRef(key);
                if (v != null) {
                    def.setExpression(v);
                    return true;
                }
                return false;
            }, noValueHandler());
    }
    protected RecipientListDefinition doParseRecipientListDefinition() throws IOException, XmlPullParserException {
        return doParse(new RecipientListDefinition(), (def, key, val) -> switch (key) {
                case "aggregationStrategy": def.setAggregationStrategy(val); yield true;
                case "aggregationStrategyMethodAllowNull": def.setAggregationStrategyMethodAllowNull(val); yield true;
                case "aggregationStrategyMethodName": def.setAggregationStrategyMethodName(val); yield true;
                case "cacheSize": def.setCacheSize(val); yield true;
                case "delimiter": def.setDelimiter(val); yield true;
                case "executorService": def.setExecutorService(val); yield true;
                case "ignoreInvalidEndpoints": def.setIgnoreInvalidEndpoints(val); yield true;
                case "onPrepare": def.setOnPrepare(val); yield true;
                case "parallelAggregate": def.setParallelAggregate(val); yield true;
                case "parallelProcessing": def.setParallelProcessing(val); yield true;
                case "shareUnitOfWork": def.setShareUnitOfWork(val); yield true;
                case "stopOnException": def.setStopOnException(val); yield true;
                case "streaming": def.setStreaming(val); yield true;
                case "synchronous": def.setSynchronous(val); yield true;
                case "timeout": def.setTimeout(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, expressionNodeElementHandler(), noValueHandler());
    }
    protected RemoveHeaderDefinition doParseRemoveHeaderDefinition() throws IOException, XmlPullParserException {
        return doParse(new RemoveHeaderDefinition(), (def, key, val) -> switch (key) {
                case "name": def.setName(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, optionalIdentifiedDefinitionElementHandler(), noValueHandler());
    }
    protected RemoveHeadersDefinition doParseRemoveHeadersDefinition() throws IOException, XmlPullParserException {
        return doParse(new RemoveHeadersDefinition(), (def, key, val) -> switch (key) {
                case "excludePattern": def.setExcludePattern(val); yield true;
                case "pattern": def.setPattern(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, optionalIdentifiedDefinitionElementHandler(), noValueHandler());
    }
    protected RemovePropertiesDefinition doParseRemovePropertiesDefinition() throws IOException, XmlPullParserException {
        return doParse(new RemovePropertiesDefinition(), (def, key, val) -> switch (key) {
                case "excludePattern": def.setExcludePattern(val); yield true;
                case "pattern": def.setPattern(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, optionalIdentifiedDefinitionElementHandler(), noValueHandler());
    }
    protected RemovePropertyDefinition doParseRemovePropertyDefinition() throws IOException, XmlPullParserException {
        return doParse(new RemovePropertyDefinition(), (def, key, val) -> switch (key) {
                case "name": def.setName(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, optionalIdentifiedDefinitionElementHandler(), noValueHandler());
    }
    protected RemoveVariableDefinition doParseRemoveVariableDefinition() throws IOException, XmlPullParserException {
        return doParse(new RemoveVariableDefinition(), (def, key, val) -> switch (key) {
                case "name": def.setName(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, optionalIdentifiedDefinitionElementHandler(), noValueHandler());
    }
    protected ResequenceDefinition doParseResequenceDefinition() throws IOException, XmlPullParserException {
        return doParse(new ResequenceDefinition(), processorDefinitionAttributeHandler(), (def, key) -> {
                switch (key) {
                    case "batchConfig": def.setResequencerConfig(doParseBatchResequencerConfig()); break;
                    case "streamConfig": def.setResequencerConfig(doParseStreamResequencerConfig()); break;
                    default:
                        ExpressionDefinition v = doParseExpressionDefinitionRef(key);
                        if (v != null) {
                            def.setExpression(v);
                            return true;
                        }
                        return outputDefinitionElementHandler().accept(def, key);
                }
                return true;
            }, noValueHandler());
    }
    protected <T extends Resilience4jConfigurationCommon> AttributeHandler<T> resilience4jConfigurationCommonAttributeHandler() {
        return (def, key, val) -> switch (key) {
            case "automaticTransitionFromOpenToHalfOpenEnabled": def.setAutomaticTransitionFromOpenToHalfOpenEnabled(val); yield true;
            case "bulkheadEnabled": def.setBulkheadEnabled(val); yield true;
            case "bulkheadMaxConcurrentCalls": def.setBulkheadMaxConcurrentCalls(val); yield true;
            case "bulkheadMaxWaitDuration": def.setBulkheadMaxWaitDuration(val); yield true;
            case "circuitBreaker": def.setCircuitBreaker(val); yield true;
            case "config": def.setConfig(val); yield true;
            case "failureRateThreshold": def.setFailureRateThreshold(val); yield true;
            case "minimumNumberOfCalls": def.setMinimumNumberOfCalls(val); yield true;
            case "permittedNumberOfCallsInHalfOpenState": def.setPermittedNumberOfCallsInHalfOpenState(val); yield true;
            case "slidingWindowSize": def.setSlidingWindowSize(val); yield true;
            case "slidingWindowType": def.setSlidingWindowType(val); yield true;
            case "slowCallDurationThreshold": def.setSlowCallDurationThreshold(val); yield true;
            case "slowCallRateThreshold": def.setSlowCallRateThreshold(val); yield true;
            case "throwExceptionWhenHalfOpenOrOpenState": def.setThrowExceptionWhenHalfOpenOrOpenState(val); yield true;
            case "timeoutCancelRunningFuture": def.setTimeoutCancelRunningFuture(val); yield true;
            case "timeoutDuration": def.setTimeoutDuration(val); yield true;
            case "timeoutEnabled": def.setTimeoutEnabled(val); yield true;
            case "timeoutExecutorService": def.setTimeoutExecutorService(val); yield true;
            case "waitDurationInOpenState": def.setWaitDurationInOpenState(val); yield true;
            case "writableStackTraceEnabled": def.setWritableStackTraceEnabled(val); yield true;
            default: yield identifiedTypeAttributeHandler().accept(def, key, val);
        };
    }
    protected <T extends Resilience4jConfigurationCommon> ElementHandler<T> resilience4jConfigurationCommonElementHandler() {
        return (def, key) -> switch (key) {
            case "ignoreException": doAdd(doParseText(), def.getIgnoreExceptions(), def::setIgnoreExceptions); yield true;
            case "recordException": doAdd(doParseText(), def.getRecordExceptions(), def::setRecordExceptions); yield true;
            default: yield false;
        };
    }
    protected Resilience4jConfigurationCommon doParseResilience4jConfigurationCommon() throws IOException, XmlPullParserException {
        return doParse(new Resilience4jConfigurationCommon(), resilience4jConfigurationCommonAttributeHandler(), resilience4jConfigurationCommonElementHandler(), noValueHandler());
    }
    protected RestContextRefDefinition doParseRestContextRefDefinition() throws IOException, XmlPullParserException {
        return doParse(new RestContextRefDefinition(), (def, key, val) -> switch (key) {
                case "ref": def.setRef(val); yield true;
                default: yield false;
            }, noElementHandler(), noValueHandler());
    }
    protected ResumableDefinition doParseResumableDefinition() throws IOException, XmlPullParserException {
        return doParse(new ResumableDefinition(), (def, key, val) -> switch (key) {
                case "intermittent": def.setIntermittent(val); yield true;
                case "loggingLevel": def.setLoggingLevel(val); yield true;
                case "resumeStrategy": def.setResumeStrategy(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, optionalIdentifiedDefinitionElementHandler(), noValueHandler());
    }
    protected RollbackDefinition doParseRollbackDefinition() throws IOException, XmlPullParserException {
        return doParse(new RollbackDefinition(), (def, key, val) -> switch (key) {
                case "markRollbackOnly": def.setMarkRollbackOnly(val); yield true;
                case "markRollbackOnlyLast": def.setMarkRollbackOnlyLast(val); yield true;
                case "message": def.setMessage(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, optionalIdentifiedDefinitionElementHandler(), noValueHandler());
    }
    protected RouteBuilderDefinition doParseRouteBuilderDefinition() throws IOException, XmlPullParserException {
        return doParse(new RouteBuilderDefinition(), (def, key, val) -> switch (key) {
                case "ref": def.setRef(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected RouteConfigurationContextRefDefinition doParseRouteConfigurationContextRefDefinition() throws IOException, XmlPullParserException {
        return doParse(new RouteConfigurationContextRefDefinition(), (def, key, val) -> switch (key) {
                case "ref": def.setRef(val); yield true;
                default: yield false;
            }, noElementHandler(), noValueHandler());
    }
    protected RouteConfigurationDefinition doParseRouteConfigurationDefinition() throws IOException, XmlPullParserException {
        return doParse(new RouteConfigurationDefinition(), (def, key, val) -> switch (key) {
                case "precondition": def.setPrecondition(val); yield true;
                default: yield optionalIdentifiedDefinitionAttributeHandler().accept(def, key, val);
            }, (def, key) -> switch (key) {
                case "errorHandler": def.setErrorHandler(doParseErrorHandlerDefinition()); yield true;
                case "interceptFrom": doAdd(doParseInterceptFromDefinition(), def.getInterceptFroms(), def::setInterceptFroms); yield true;
                case "interceptSendToEndpoint": doAdd(doParseInterceptSendToEndpointDefinition(), def.getInterceptSendTos(), def::setInterceptSendTos); yield true;
                case "intercept": doAdd(doParseInterceptDefinition(), def.getIntercepts(), def::setIntercepts); yield true;
                case "onCompletion": doAdd(doParseOnCompletionDefinition(), def.getOnCompletions(), def::setOnCompletions); yield true;
                case "onException": doAdd(doParseOnExceptionDefinition(), def.getOnExceptions(), def::setOnExceptions); yield true;
                default: yield optionalIdentifiedDefinitionElementHandler().accept(def, key);
            }, noValueHandler());
    }
    protected RouteConfigurationsDefinition doParseRouteConfigurationsDefinition() throws IOException, XmlPullParserException {
        return doParse(new RouteConfigurationsDefinition(), optionalIdentifiedDefinitionAttributeHandler(), (def, key) -> switch (key) {
                case "routeConfiguration": doAdd(doParseRouteConfigurationDefinition(), def.getRouteConfigurations(), def::setRouteConfigurations); yield true;
                default: yield optionalIdentifiedDefinitionElementHandler().accept(def, key);
            }, noValueHandler());
    }
    public Optional<RouteConfigurationsDefinition> parseRouteConfigurationsDefinition() throws IOException, XmlPullParserException {
        String tag = getNextTag("routeConfigurations", "routeConfiguration");
        if (tag != null) {
            switch (tag) {
                case "routeConfigurations" : return Optional.of(doParseRouteConfigurationsDefinition());
                case "routeConfiguration" : return parseSingleRouteConfigurationsDefinition();
            }
        }
        return Optional.empty();
    }
    private Optional<RouteConfigurationsDefinition> parseSingleRouteConfigurationsDefinition() throws IOException, XmlPullParserException {
        Optional<RouteConfigurationDefinition> single = Optional.of(doParseRouteConfigurationDefinition());
        if (single.isPresent()) {
            List<RouteConfigurationDefinition> list = new ArrayList<>();
            list.add(single.get());
            RouteConfigurationsDefinition def = new RouteConfigurationsDefinition();
            def.setRouteConfigurations(list);
            return Optional.of(def);
        }
        return Optional.empty();
    }
    protected RouteContextRefDefinition doParseRouteContextRefDefinition() throws IOException, XmlPullParserException {
        return doParse(new RouteContextRefDefinition(), (def, key, val) -> switch (key) {
                case "ref": def.setRef(val); yield true;
                default: yield false;
            }, noElementHandler(), noValueHandler());
    }
    protected RouteDefinition doParseRouteDefinition() throws IOException, XmlPullParserException {
        return doParse(new RouteDefinition(), (def, key, val) -> switch (key) {
                case "autoStartup": def.setAutoStartup(val); yield true;
                case "delayer": def.setDelayer(val); yield true;
                case "errorHandlerRef": def.setErrorHandlerRef(val); yield true;
                case "group": def.setGroup(val); yield true;
                case "logMask": def.setLogMask(val); yield true;
                case "messageHistory": def.setMessageHistory(val); yield true;
                case "nodePrefixId": def.setNodePrefixId(val); yield true;
                case "precondition": def.setPrecondition(val); yield true;
                case "routeConfigurationId": def.setRouteConfigurationId(val); yield true;
                case "routePolicyRef": def.setRoutePolicyRef(val); yield true;
                case "shutdownRoute": def.setShutdownRoute(val); yield true;
                case "shutdownRunningTask": def.setShutdownRunningTask(val); yield true;
                case "startupOrder": def.setStartupOrder(Integer.valueOf(val)); yield true;
                case "streamCache": def.setStreamCache(val); yield true;
                case "trace": def.setTrace(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, (def, key) -> switch (key) {
                case "errorHandler": def.setErrorHandler(doParseErrorHandlerDefinition()); yield true;
                case "from": def.setInput(doParseFromDefinition()); yield true;
                case "inputType": def.setInputType(doParseInputTypeDefinition()); yield true;
                case "kamelet": def.setKamelet(Boolean.valueOf(doParseText())); yield true;
                case "outputType": def.setOutputType(doParseOutputTypeDefinition()); yield true;
                case "rest": def.setRest(Boolean.valueOf(doParseText())); yield true;
                case "routeProperty": doAdd(doParsePropertyDefinition(), def.getRouteProperties(), def::setRouteProperties); yield true;
                case "template": def.setTemplate(Boolean.valueOf(doParseText())); yield true;
                default: yield outputDefinitionElementHandler().accept(def, key);
            }, noValueHandler());
    }
    protected RestDefinition doParseRestDefinition() throws IOException, XmlPullParserException {
        return doParse(new RestDefinition(), (def, key, val) -> switch (key) {
                case "apiDocs": def.setApiDocs(val); yield true;
                case "bindingMode": def.setBindingMode(val); yield true;
                case "clientRequestValidation": def.setClientRequestValidation(val); yield true;
                case "consumes": def.setConsumes(val); yield true;
                case "disabled": def.setDisabled(val); yield true;
                case "enableCORS": def.setEnableCORS(val); yield true;
                case "enableNoContentResponse": def.setEnableNoContentResponse(val); yield true;
                case "path": def.setPath(val); yield true;
                case "produces": def.setProduces(val); yield true;
                case "skipBindingOnErrorCode": def.setSkipBindingOnErrorCode(val); yield true;
                case "tag": def.setTag(val); yield true;
                default: yield optionalIdentifiedDefinitionAttributeHandler().accept(def, key, val);
            }, (def, key) -> switch (key) {
                case "openApi": def.setOpenApi(doParseOpenApiDefinition()); yield true;
                case "securityDefinitions": def.setSecurityDefinitions(doParseRestSecuritiesDefinition()); yield true;
                case "securityRequirements": doAdd(doParseSecurityDefinition(), def.getSecurityRequirements(), def::setSecurityRequirements); yield true;
                case "delete": doAdd(doParseDeleteDefinition(), def.getVerbs(), def::setVerbs); yield true;
                case "get": doAdd(doParseGetDefinition(), def.getVerbs(), def::setVerbs); yield true;
                case "head": doAdd(doParseHeadDefinition(), def.getVerbs(), def::setVerbs); yield true;
                case "patch": doAdd(doParsePatchDefinition(), def.getVerbs(), def::setVerbs); yield true;
                case "post": doAdd(doParsePostDefinition(), def.getVerbs(), def::setVerbs); yield true;
                case "put": doAdd(doParsePutDefinition(), def.getVerbs(), def::setVerbs); yield true;
                default: yield optionalIdentifiedDefinitionElementHandler().accept(def, key);
            }, noValueHandler());
    }
    protected RestBindingDefinition doParseRestBindingDefinition() throws IOException, XmlPullParserException {
        return doParse(new RestBindingDefinition(), (def, key, val) -> switch (key) {
                case "bindingMode": def.setBindingMode(val); yield true;
                case "clientRequestValidation": def.setClientRequestValidation(val); yield true;
                case "component": def.setComponent(val); yield true;
                case "consumes": def.setConsumes(val); yield true;
                case "enableCORS": def.setEnableCORS(val); yield true;
                case "enableNoContentResponse": def.setEnableNoContentResponse(val); yield true;
                case "outType": def.setOutType(val); yield true;
                case "produces": def.setProduces(val); yield true;
                case "skipBindingOnErrorCode": def.setSkipBindingOnErrorCode(val); yield true;
                case "type": def.setType(val); yield true;
                default: yield optionalIdentifiedDefinitionAttributeHandler().accept(def, key, val);
            }, optionalIdentifiedDefinitionElementHandler(), noValueHandler());
    }
    protected RouteTemplateContextRefDefinition doParseRouteTemplateContextRefDefinition() throws IOException, XmlPullParserException {
        return doParse(new RouteTemplateContextRefDefinition(), (def, key, val) -> switch (key) {
                case "ref": def.setRef(val); yield true;
                default: yield false;
            }, noElementHandler(), noValueHandler());
    }
    protected RouteTemplateDefinition doParseRouteTemplateDefinition() throws IOException, XmlPullParserException {
        return doParse(new RouteTemplateDefinition(), optionalIdentifiedDefinitionAttributeHandler(), (def, key) -> switch (key) {
                case "route": def.setRoute(doParseRouteDefinition()); yield true;
                case "templateBean": doAdd(doParseBeanFactoryDefinition(), def.getTemplateBeans(), def::setTemplateBeans); yield true;
                case "templateParameter": doAdd(doParseRouteTemplateParameterDefinition(), def.getTemplateParameters(), def::setTemplateParameters); yield true;
                default: yield optionalIdentifiedDefinitionElementHandler().accept(def, key);
            }, noValueHandler());
    }
    protected RouteTemplateParameterDefinition doParseRouteTemplateParameterDefinition() throws IOException, XmlPullParserException {
        return doParse(new RouteTemplateParameterDefinition(), (def, key, val) -> switch (key) {
                case "defaultValue": def.setDefaultValue(val); yield true;
                case "description": def.setDescription(val); yield true;
                case "name": def.setName(val); yield true;
                case "required": def.setRequired(Boolean.valueOf(val)); yield true;
                default: yield false;
            }, noElementHandler(), noValueHandler());
    }
    protected RouteTemplatesDefinition doParseRouteTemplatesDefinition() throws IOException, XmlPullParserException {
        return doParse(new RouteTemplatesDefinition(), optionalIdentifiedDefinitionAttributeHandler(), (def, key) -> switch (key) {
                case "routeTemplate": doAdd(doParseRouteTemplateDefinition(), def.getRouteTemplates(), def::setRouteTemplates); yield true;
                default: yield optionalIdentifiedDefinitionElementHandler().accept(def, key);
            }, noValueHandler());
    }
    public Optional<RouteTemplatesDefinition> parseRouteTemplatesDefinition() throws IOException, XmlPullParserException {
        String tag = getNextTag("routeTemplates", "routeTemplate");
        if (tag != null) {
            switch (tag) {
                case "routeTemplates" : return Optional.of(doParseRouteTemplatesDefinition());
                case "routeTemplate" : return parseSingleRouteTemplatesDefinition();
            }
        }
        return Optional.empty();
    }
    private Optional<RouteTemplatesDefinition> parseSingleRouteTemplatesDefinition() throws IOException, XmlPullParserException {
        Optional<RouteTemplateDefinition> single = Optional.of(doParseRouteTemplateDefinition());
        if (single.isPresent()) {
            List<RouteTemplateDefinition> list = new ArrayList<>();
            list.add(single.get());
            RouteTemplatesDefinition def = new RouteTemplatesDefinition();
            def.setRouteTemplates(list);
            return Optional.of(def);
        }
        return Optional.empty();
    }
    protected RoutesDefinition doParseRoutesDefinition() throws IOException, XmlPullParserException {
        return doParse(new RoutesDefinition(), optionalIdentifiedDefinitionAttributeHandler(), (def, key) -> switch (key) {
                case "route": doAdd(doParseRouteDefinition(), def.getRoutes(), def::setRoutes); yield true;
                default: yield optionalIdentifiedDefinitionElementHandler().accept(def, key);
            }, noValueHandler());
    }
    public Optional<RoutesDefinition> parseRoutesDefinition() throws IOException, XmlPullParserException {
        String tag = getNextTag("routes", "route");
        if (tag != null) {
            switch (tag) {
                case "routes" : return Optional.of(doParseRoutesDefinition());
                case "route" : return parseSingleRoutesDefinition();
            }
        }
        return Optional.empty();
    }
    private Optional<RoutesDefinition> parseSingleRoutesDefinition() throws IOException, XmlPullParserException {
        Optional<RouteDefinition> single = Optional.of(doParseRouteDefinition());
        if (single.isPresent()) {
            List<RouteDefinition> list = new ArrayList<>();
            list.add(single.get());
            RoutesDefinition def = new RoutesDefinition();
            def.setRoutes(list);
            return Optional.of(def);
        }
        return Optional.empty();
    }
    protected RoutingSlipDefinition doParseRoutingSlipDefinition() throws IOException, XmlPullParserException {
        return doParse(new RoutingSlipDefinition(), (def, key, val) -> switch (key) {
                case "cacheSize": def.setCacheSize(val); yield true;
                case "ignoreInvalidEndpoints": def.setIgnoreInvalidEndpoints(val); yield true;
                case "uriDelimiter": def.setUriDelimiter(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, expressionNodeElementHandler(), noValueHandler());
    }
    protected SagaDefinition doParseSagaDefinition() throws IOException, XmlPullParserException {
        return doParse(new SagaDefinition(), (def, key, val) -> switch (key) {
                case "completionMode": def.setCompletionMode(val); yield true;
                case "propagation": def.setPropagation(val); yield true;
                case "sagaService": def.setSagaService(val); yield true;
                case "timeout": def.setTimeout(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, (def, key) -> switch (key) {
                case "compensation": def.setCompensation(doParseSagaActionUriDefinition()); yield true;
                case "completion": def.setCompletion(doParseSagaActionUriDefinition()); yield true;
                case "option": doAdd(doParsePropertyExpressionDefinition(), def.getOptions(), def::setOptions); yield true;
                default: yield outputDefinitionElementHandler().accept(def, key);
            }, noValueHandler());
    }
    protected SagaActionUriDefinition doParseSagaActionUriDefinition() throws IOException, XmlPullParserException {
        return doParse(new SagaActionUriDefinition(), sendDefinitionAttributeHandler(), optionalIdentifiedDefinitionElementHandler(), noValueHandler());
    }
    protected SamplingDefinition doParseSamplingDefinition() throws IOException, XmlPullParserException {
        return doParse(new SamplingDefinition(), (def, key, val) -> switch (key) {
                case "messageFrequency": def.setMessageFrequency(val); yield true;
                case "samplePeriod": def.setSamplePeriod(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, optionalIdentifiedDefinitionElementHandler(), noValueHandler());
    }
    protected ScriptDefinition doParseScriptDefinition() throws IOException, XmlPullParserException {
        return doParse(new ScriptDefinition(), processorDefinitionAttributeHandler(), expressionNodeElementHandler(), noValueHandler());
    }
    protected SetBodyDefinition doParseSetBodyDefinition() throws IOException, XmlPullParserException {
        return doParse(new SetBodyDefinition(), processorDefinitionAttributeHandler(), expressionNodeElementHandler(), noValueHandler());
    }
    protected SetExchangePatternDefinition doParseSetExchangePatternDefinition() throws IOException, XmlPullParserException {
        return doParse(new SetExchangePatternDefinition(), (def, key, val) -> switch (key) {
                case "pattern": def.setPattern(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, optionalIdentifiedDefinitionElementHandler(), noValueHandler());
    }
    protected SetHeaderDefinition doParseSetHeaderDefinition() throws IOException, XmlPullParserException {
        return doParse(new SetHeaderDefinition(), (def, key, val) -> switch (key) {
                case "name": def.setName(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, expressionNodeElementHandler(), noValueHandler());
    }
    protected SetHeadersDefinition doParseSetHeadersDefinition() throws IOException, XmlPullParserException {
        return doParse(new SetHeadersDefinition(), processorDefinitionAttributeHandler(), (def, key) -> switch (key) {
                case "setHeader": doAdd(doParseSetHeaderDefinition(), def.getHeaders(), def::setHeaders); yield true;
                default: yield optionalIdentifiedDefinitionElementHandler().accept(def, key);
            }, noValueHandler());
    }
    protected SetPropertyDefinition doParseSetPropertyDefinition() throws IOException, XmlPullParserException {
        return doParse(new SetPropertyDefinition(), (def, key, val) -> switch (key) {
                case "name": def.setName(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, expressionNodeElementHandler(), noValueHandler());
    }
    protected SetVariableDefinition doParseSetVariableDefinition() throws IOException, XmlPullParserException {
        return doParse(new SetVariableDefinition(), (def, key, val) -> switch (key) {
                case "name": def.setName(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, expressionNodeElementHandler(), noValueHandler());
    }
    protected SetVariablesDefinition doParseSetVariablesDefinition() throws IOException, XmlPullParserException {
        return doParse(new SetVariablesDefinition(), processorDefinitionAttributeHandler(), (def, key) -> switch (key) {
                case "setVariable": doAdd(doParseSetVariableDefinition(), def.getVariables(), def::setVariables); yield true;
                default: yield optionalIdentifiedDefinitionElementHandler().accept(def, key);
            }, noValueHandler());
    }
    protected SortDefinition doParseSortDefinition() throws IOException, XmlPullParserException {
        return doParse(new SortDefinition(), (def, key, val) -> switch (key) {
                case "comparator": def.setComparator(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, expressionNodeElementHandler(), noValueHandler());
    }
    protected SplitDefinition doParseSplitDefinition() throws IOException, XmlPullParserException {
        return doParse(new SplitDefinition(), (def, key, val) -> switch (key) {
                case "aggregationStrategy": def.setAggregationStrategy(val); yield true;
                case "aggregationStrategyMethodAllowNull": def.setAggregationStrategyMethodAllowNull(val); yield true;
                case "aggregationStrategyMethodName": def.setAggregationStrategyMethodName(val); yield true;
                case "delimiter": def.setDelimiter(val); yield true;
                case "executorService": def.setExecutorService(val); yield true;
                case "onPrepare": def.setOnPrepare(val); yield true;
                case "parallelAggregate": def.setParallelAggregate(val); yield true;
                case "parallelProcessing": def.setParallelProcessing(val); yield true;
                case "shareUnitOfWork": def.setShareUnitOfWork(val); yield true;
                case "stopOnException": def.setStopOnException(val); yield true;
                case "streaming": def.setStreaming(val); yield true;
                case "synchronous": def.setSynchronous(val); yield true;
                case "timeout": def.setTimeout(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, outputExpressionNodeElementHandler(), noValueHandler());
    }
    protected StepDefinition doParseStepDefinition() throws IOException, XmlPullParserException {
        return doParse(new StepDefinition(), processorDefinitionAttributeHandler(), outputDefinitionElementHandler(), noValueHandler());
    }
    protected StopDefinition doParseStopDefinition() throws IOException, XmlPullParserException {
        return doParse(new StopDefinition(), processorDefinitionAttributeHandler(), optionalIdentifiedDefinitionElementHandler(), noValueHandler());
    }
    protected TemplatedRouteDefinition doParseTemplatedRouteDefinition() throws IOException, XmlPullParserException {
        return doParse(new TemplatedRouteDefinition(), (def, key, val) -> switch (key) {
                case "prefixId": def.setPrefixId(val); yield true;
                case "routeId": def.setRouteId(val); yield true;
                case "routeTemplateRef": def.setRouteTemplateRef(val); yield true;
                default: yield false;
            }, (def, key) -> switch (key) {
                case "bean": doAdd(doParseBeanFactoryDefinition(), def.getBeans(), def::setBeans); yield true;
                case "parameter": doAdd(doParseTemplatedRouteParameterDefinition(), def.getParameters(), def::setParameters); yield true;
                default: yield false;
            }, noValueHandler());
    }
    protected TemplatedRouteParameterDefinition doParseTemplatedRouteParameterDefinition() throws IOException, XmlPullParserException {
        return doParse(new TemplatedRouteParameterDefinition(), (def, key, val) -> switch (key) {
                case "name": def.setName(val); yield true;
                case "value": def.setValue(val); yield true;
                default: yield false;
            }, noElementHandler(), noValueHandler());
    }
    protected TemplatedRoutesDefinition doParseTemplatedRoutesDefinition() throws IOException, XmlPullParserException {
        return doParse(new TemplatedRoutesDefinition(), optionalIdentifiedDefinitionAttributeHandler(), (def, key) -> switch (key) {
                case "templatedRoute": doAdd(doParseTemplatedRouteDefinition(), def.getTemplatedRoutes(), def::setTemplatedRoutes); yield true;
                default: yield optionalIdentifiedDefinitionElementHandler().accept(def, key);
            }, noValueHandler());
    }
    public Optional<TemplatedRoutesDefinition> parseTemplatedRoutesDefinition() throws IOException, XmlPullParserException {
        String tag = getNextTag("templatedRoutes", "templatedRoute");
        if (tag != null) {
            switch (tag) {
                case "templatedRoutes" : return Optional.of(doParseTemplatedRoutesDefinition());
                case "templatedRoute" : return parseSingleTemplatedRoutesDefinition();
            }
        }
        return Optional.empty();
    }
    private Optional<TemplatedRoutesDefinition> parseSingleTemplatedRoutesDefinition() throws IOException, XmlPullParserException {
        Optional<TemplatedRouteDefinition> single = Optional.of(doParseTemplatedRouteDefinition());
        if (single.isPresent()) {
            List<TemplatedRouteDefinition> list = new ArrayList<>();
            list.add(single.get());
            TemplatedRoutesDefinition def = new TemplatedRoutesDefinition();
            def.setTemplatedRoutes(list);
            return Optional.of(def);
        }
        return Optional.empty();
    }
    protected ThreadPoolProfileDefinition doParseThreadPoolProfileDefinition() throws IOException, XmlPullParserException {
        return doParse(new ThreadPoolProfileDefinition(), (def, key, val) -> switch (key) {
                case "allowCoreThreadTimeOut": def.setAllowCoreThreadTimeOut(val); yield true;
                case "defaultProfile": def.setDefaultProfile(val); yield true;
                case "keepAliveTime": def.setKeepAliveTime(val); yield true;
                case "maxPoolSize": def.setMaxPoolSize(val); yield true;
                case "maxQueueSize": def.setMaxQueueSize(val); yield true;
                case "poolSize": def.setPoolSize(val); yield true;
                case "rejectedPolicy": def.setRejectedPolicy(val); yield true;
                case "timeUnit": def.setTimeUnit(val); yield true;
                default: yield optionalIdentifiedDefinitionAttributeHandler().accept(def, key, val);
            }, optionalIdentifiedDefinitionElementHandler(), noValueHandler());
    }
    protected ThreadsDefinition doParseThreadsDefinition() throws IOException, XmlPullParserException {
        return doParse(new ThreadsDefinition(), (def, key, val) -> switch (key) {
                case "allowCoreThreadTimeOut": def.setAllowCoreThreadTimeOut(val); yield true;
                case "callerRunsWhenRejected": def.setCallerRunsWhenRejected(val); yield true;
                case "executorService": def.setExecutorService(val); yield true;
                case "keepAliveTime": def.setKeepAliveTime(val); yield true;
                case "maxPoolSize": def.setMaxPoolSize(val); yield true;
                case "maxQueueSize": def.setMaxQueueSize(val); yield true;
                case "poolSize": def.setPoolSize(val); yield true;
                case "rejectedPolicy": def.setRejectedPolicy(val); yield true;
                case "threadName": def.setThreadName(val); yield true;
                case "timeUnit": def.setTimeUnit(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, optionalIdentifiedDefinitionElementHandler(), noValueHandler());
    }
    protected ThrottleDefinition doParseThrottleDefinition() throws IOException, XmlPullParserException {
        return doParse(new ThrottleDefinition(), (def, key, val) -> switch (key) {
                case "asyncDelayed": def.setAsyncDelayed(val); yield true;
                case "callerRunsWhenRejected": def.setCallerRunsWhenRejected(val); yield true;
                case "executorService": def.setExecutorService(val); yield true;
                case "mode": def.setMode(val); yield true;
                case "rejectExecution": def.setRejectExecution(val); yield true;
                case "timePeriodMillis": def.setTimePeriodMillis(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, (def, key) -> switch (key) {
                case "correlationExpression": def.setCorrelationExpression(doParseExpressionSubElementDefinition()); yield true;
                default: yield expressionNodeElementHandler().accept(def, key);
            }, noValueHandler());
    }
    protected ThrowExceptionDefinition doParseThrowExceptionDefinition() throws IOException, XmlPullParserException {
        return doParse(new ThrowExceptionDefinition(), (def, key, val) -> switch (key) {
                case "exceptionType": def.setExceptionType(val); yield true;
                case "message": def.setMessage(val); yield true;
                case "ref": def.setRef(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, optionalIdentifiedDefinitionElementHandler(), noValueHandler());
    }
    protected ToDefinition doParseToDefinition() throws IOException, XmlPullParserException {
        return doParse(new ToDefinition(), (def, key, val) -> switch (key) {
                case "pattern": def.setPattern(val); yield true;
                case "variableReceive": def.setVariableReceive(val); yield true;
                case "variableSend": def.setVariableSend(val); yield true;
                default: yield sendDefinitionAttributeHandler().accept(def, key, val);
            }, optionalIdentifiedDefinitionElementHandler(), noValueHandler());
    }
    protected <T extends SendDefinition> AttributeHandler<T> sendDefinitionAttributeHandler() {
        return (def, key, val) -> switch (key) {
            case "uri": def.setUri(sanitizeUri(val)); yield true;
            default: yield processorDefinitionAttributeHandler().accept(def, key, val);
        };
    }
    protected <T extends ToDynamicDefinition> AttributeHandler<T> toDynamicDefinitionAttributeHandler() {
        return (def, key, val) -> switch (key) {
            case "allowOptimisedComponents": def.setAllowOptimisedComponents(val); yield true;
            case "autoStartComponents": def.setAutoStartComponents(val); yield true;
            case "cacheSize": def.setCacheSize(val); yield true;
            case "ignoreInvalidEndpoint": def.setIgnoreInvalidEndpoint(val); yield true;
            case "pattern": def.setPattern(val); yield true;
            case "uri": def.setUri(sanitizeUri(val)); yield true;
            case "variableReceive": def.setVariableReceive(val); yield true;
            case "variableSend": def.setVariableSend(val); yield true;
            default: yield processorDefinitionAttributeHandler().accept(def, key, val);
        };
    }
    protected ToDynamicDefinition doParseToDynamicDefinition() throws IOException, XmlPullParserException {
        return doParse(new ToDynamicDefinition(), toDynamicDefinitionAttributeHandler(), optionalIdentifiedDefinitionElementHandler(), noValueHandler());
    }
    protected TransactedDefinition doParseTransactedDefinition() throws IOException, XmlPullParserException {
        return doParse(new TransactedDefinition(), (def, key, val) -> switch (key) {
                case "ref": def.setRef(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, outputDefinitionElementHandler(), noValueHandler());
    }
    protected TransformDefinition doParseTransformDefinition() throws IOException, XmlPullParserException {
        return doParse(new TransformDefinition(), (def, key, val) -> switch (key) {
                case "fromType": def.setFromType(val); yield true;
                case "toType": def.setToType(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, expressionNodeElementHandler(), noValueHandler());
    }
    protected TryDefinition doParseTryDefinition() throws IOException, XmlPullParserException {
        return doParse(new TryDefinition(), processorDefinitionAttributeHandler(), outputDefinitionElementHandler(), noValueHandler());
    }
    protected UnmarshalDefinition doParseUnmarshalDefinition() throws IOException, XmlPullParserException {
        return doParse(new UnmarshalDefinition(), (def, key, val) -> switch (key) {
                case "allowNullBody": def.setAllowNullBody(val); yield true;
                case "variableReceive": def.setVariableReceive(val); yield true;
                case "variableSend": def.setVariableSend(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, (def, key) -> {
                DataFormatDefinition v = doParseDataFormatDefinitionRef(key);
                if (v != null) {
                    def.setDataFormatType(v);
                    return true;
                }
                return optionalIdentifiedDefinitionElementHandler().accept(def, key);
            }, noValueHandler());
    }
    protected ValidateDefinition doParseValidateDefinition() throws IOException, XmlPullParserException {
        return doParse(new ValidateDefinition(), (def, key, val) -> switch (key) {
                case "predicateExceptionFactory": def.setPredicateExceptionFactory(val); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, expressionNodeElementHandler(), noValueHandler());
    }
    protected List<ValueDefinition> doParseValueDefinition() throws IOException, XmlPullParserException {
        return doParseValue(() -> new ValueDefinition(), (def, val) -> def.setValue(val));
    }
    protected WireTapDefinition doParseWireTapDefinition() throws IOException, XmlPullParserException {
        return doParse(new WireTapDefinition(), (def, key, val) -> switch (key) {
                case "copy": def.setCopy(val); yield true;
                case "dynamicUri": def.setDynamicUri(val); yield true;
                case "executorService": def.setExecutorService(val); yield true;
                case "onPrepare": def.setOnPrepare(val); yield true;
                default: yield toDynamicDefinitionAttributeHandler().accept(def, key, val);
            }, optionalIdentifiedDefinitionElementHandler(), noValueHandler());
    }
    protected ApplicationDefinition doParseApplicationDefinition() throws IOException, XmlPullParserException {
        return doParse(new ApplicationDefinition(), noAttributeHandler(), beansDefinitionElementHandler(), noValueHandler());
    }
    public Optional<ApplicationDefinition> parseApplicationDefinition() throws IOException, XmlPullParserException {
        String tag = getNextTag("beans", "blueprint", "camel");
        if (tag != null) {
            return Optional.of(doParseApplicationDefinition());
        }
        return Optional.empty();
    }
    protected <T extends BeansDefinition> ElementHandler<T> beansDefinitionElementHandler() {
        return (def, key) -> {
            if ("http://www.osgi.org/xmlns/blueprint/v1.0.0".equals(parser.getNamespace())) {
                Element el = doParseDOMElement("blueprint", "http://www.osgi.org/xmlns/blueprint/v1.0.0", def.getBlueprintBeans());
                if (el != null) {
                    doAddElement(el, def.getBlueprintBeans(), def::setBlueprintBeans);
                    return true;
                }
                return false;
            }
            if ("http://www.springframework.org/schema/beans".equals(parser.getNamespace())) {
                Element el = doParseDOMElement("beans", "http://www.springframework.org/schema/beans", def.getSpringBeans());
                if (el != null) {
                    doAddElement(el, def.getSpringBeans(), def::setSpringBeans);
                    return true;
                }
                return false;
            }
            switch (key) {
                case "bean": doAdd(doParseBeanFactoryDefinition(), def.getBeans(), def::setBeans); break;
                case "component-scan": doAdd(doParseComponentScanDefinition(), def.getComponentScanning(), def::setComponentScanning); break;
                case "restConfiguration": doAdd(doParseRestConfigurationDefinition(), def.getRestConfigurations(), def::setRestConfigurations); break;
                case "rest": doAdd(doParseRestDefinition(), def.getRests(), def::setRests); break;
                case "routeConfiguration": doAdd(doParseRouteConfigurationDefinition(), def.getRouteConfigurations(), def::setRouteConfigurations); break;
                case "routeTemplate": doAdd(doParseRouteTemplateDefinition(), def.getRouteTemplates(), def::setRouteTemplates); break;
                case "route": doAdd(doParseRouteDefinition(), def.getRoutes(), def::setRoutes); break;
                case "templatedRoute": doAdd(doParseTemplatedRouteDefinition(), def.getTemplatedRoutes(), def::setTemplatedRoutes); break;
                default: return false;
            }
            return true;
        };
    }
    protected BeansDefinition doParseBeansDefinition() throws IOException, XmlPullParserException {
        return doParse(new BeansDefinition(), noAttributeHandler(), beansDefinitionElementHandler(), noValueHandler(), true);
    }
    public Optional<BeansDefinition> parseBeansDefinition() throws IOException, XmlPullParserException {
        String tag = getNextTag("beans", "blueprint", "camel");
        if (tag != null) {
            return Optional.of(doParseBeansDefinition());
        }
        return Optional.empty();
    }
    protected ComponentScanDefinition doParseComponentScanDefinition() throws IOException, XmlPullParserException {
        return doParse(new ComponentScanDefinition(), (def, key, val) -> switch (key) {
                case "base-package": def.setBasePackage(val); yield true;
                default: yield false;
            }, noElementHandler(), noValueHandler());
    }
    protected RestConfigurationDefinition doParseRestConfigurationDefinition() throws IOException, XmlPullParserException {
        return doParse(new RestConfigurationDefinition(), (def, key, val) -> switch (key) {
                case "apiComponent": def.setApiComponent(val); yield true;
                case "apiContextPath": def.setApiContextPath(val); yield true;
                case "apiContextRouteId": def.setApiContextRouteId(val); yield true;
                case "apiHost": def.setApiHost(val); yield true;
                case "apiVendorExtension": def.setApiVendorExtension(val); yield true;
                case "bindingMode": def.setBindingMode(RestBindingMode.valueOf(val)); yield true;
                case "bindingPackageScan": def.setBindingPackageScan(val); yield true;
                case "clientRequestValidation": def.setClientRequestValidation(val); yield true;
                case "component": def.setComponent(val); yield true;
                case "contextPath": def.setContextPath(val); yield true;
                case "enableCORS": def.setEnableCORS(val); yield true;
                case "enableNoContentResponse": def.setEnableNoContentResponse(val); yield true;
                case "host": def.setHost(val); yield true;
                case "hostNameResolver": def.setHostNameResolver(RestHostNameResolver.valueOf(val)); yield true;
                case "inlineRoutes": def.setInlineRoutes(val); yield true;
                case "jsonDataFormat": def.setJsonDataFormat(val); yield true;
                case "port": def.setPort(val); yield true;
                case "producerApiDoc": def.setProducerApiDoc(val); yield true;
                case "producerComponent": def.setProducerComponent(val); yield true;
                case "scheme": def.setScheme(val); yield true;
                case "skipBindingOnErrorCode": def.setSkipBindingOnErrorCode(val); yield true;
                case "useXForwardHeaders": def.setUseXForwardHeaders(val); yield true;
                case "xmlDataFormat": def.setXmlDataFormat(val); yield true;
                default: yield false;
            }, (def, key) -> switch (key) {
                case "apiProperty": doAdd(doParseRestPropertyDefinition(), def.getApiProperties(), def::setApiProperties); yield true;
                case "componentProperty": doAdd(doParseRestPropertyDefinition(), def.getComponentProperties(), def::setComponentProperties); yield true;
                case "consumerProperty": doAdd(doParseRestPropertyDefinition(), def.getConsumerProperties(), def::setConsumerProperties); yield true;
                case "corsHeaders": doAdd(doParseRestPropertyDefinition(), def.getCorsHeaders(), def::setCorsHeaders); yield true;
                case "dataFormatProperty": doAdd(doParseRestPropertyDefinition(), def.getDataFormatProperties(), def::setDataFormatProperties); yield true;
                case "endpointProperty": doAdd(doParseRestPropertyDefinition(), def.getEndpointProperties(), def::setEndpointProperties); yield true;
                default: yield false;
            }, noValueHandler());
    }
    protected BeanConstructorDefinition doParseBeanConstructorDefinition() throws IOException, XmlPullParserException {
        return doParse(new BeanConstructorDefinition(), (def, key, val) -> switch (key) {
                case "index": def.setIndex(Integer.valueOf(val)); yield true;
                case "value": def.setValue(val); yield true;
                default: yield false;
            }, noElementHandler(), noValueHandler());
    }
    protected BeanPropertyDefinition doParseBeanPropertyDefinition() throws IOException, XmlPullParserException {
        return doParse(new BeanPropertyDefinition(), (def, key, val) -> switch (key) {
                case "key": def.setKey(val); yield true;
                case "value": def.setValue(val); yield true;
                default: yield false;
            }, (def, key) -> switch (key) {
                case "properties": def.setProperties(doParseBeanPropertiesDefinition()); yield true;
                default: yield false;
            }, noValueHandler());
    }
    protected BlacklistServiceCallServiceFilterConfiguration doParseBlacklistServiceCallServiceFilterConfiguration() throws IOException, XmlPullParserException {
        return doParse(new BlacklistServiceCallServiceFilterConfiguration(), identifiedTypeAttributeHandler(), (def, key) -> switch (key) {
                case "servers": doAdd(doParseText(), def.getServers(), def::setServers); yield true;
                default: yield serviceCallConfigurationElementHandler().accept(def, key);
            }, noValueHandler());
    }
    protected ServiceCallServiceFilterConfiguration doParseServiceCallServiceFilterConfiguration() throws IOException, XmlPullParserException {
        return doParse(new ServiceCallServiceFilterConfiguration(), identifiedTypeAttributeHandler(), serviceCallConfigurationElementHandler(), noValueHandler());
    }
    protected <T extends ServiceCallConfiguration> ElementHandler<T> serviceCallConfigurationElementHandler() {
        return (def, key) -> switch (key) {
            case "properties": doAdd(doParsePropertyDefinition(), def.getProperties(), def::setProperties); yield true;
            default: yield false;
        };
    }
    protected CachingServiceCallServiceDiscoveryConfiguration doParseCachingServiceCallServiceDiscoveryConfiguration() throws IOException, XmlPullParserException {
        return doParse(new CachingServiceCallServiceDiscoveryConfiguration(), (def, key, val) -> switch (key) {
                case "timeout": def.setTimeout(val); yield true;
                case "units": def.setUnits(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, (def, key) -> switch (key) {
                case "consulServiceDiscovery": def.setServiceDiscoveryConfiguration(doParseConsulServiceCallServiceDiscoveryConfiguration()); yield true;
                case "dnsServiceDiscovery": def.setServiceDiscoveryConfiguration(doParseDnsServiceCallServiceDiscoveryConfiguration()); yield true;
                case "kubernetesServiceDiscovery": def.setServiceDiscoveryConfiguration(doParseKubernetesServiceCallServiceDiscoveryConfiguration()); yield true;
                case "combinedServiceDiscovery": def.setServiceDiscoveryConfiguration(doParseCombinedServiceCallServiceDiscoveryConfiguration()); yield true;
                case "staticServiceDiscovery": def.setServiceDiscoveryConfiguration(doParseStaticServiceCallServiceDiscoveryConfiguration()); yield true;
                default: yield serviceCallConfigurationElementHandler().accept(def, key);
            }, noValueHandler());
    }
    protected ServiceCallServiceDiscoveryConfiguration doParseServiceCallServiceDiscoveryConfiguration() throws IOException, XmlPullParserException {
        return doParse(new ServiceCallServiceDiscoveryConfiguration(), identifiedTypeAttributeHandler(), serviceCallConfigurationElementHandler(), noValueHandler());
    }
    protected CombinedServiceCallServiceDiscoveryConfiguration doParseCombinedServiceCallServiceDiscoveryConfiguration() throws IOException, XmlPullParserException {
        return doParse(new CombinedServiceCallServiceDiscoveryConfiguration(), identifiedTypeAttributeHandler(), (def, key) -> switch (key) {
                case "consulServiceDiscovery": doAdd(doParseConsulServiceCallServiceDiscoveryConfiguration(), def.getServiceDiscoveryConfigurations(), def::setServiceDiscoveryConfigurations); yield true;
                case "dnsServiceDiscovery": doAdd(doParseDnsServiceCallServiceDiscoveryConfiguration(), def.getServiceDiscoveryConfigurations(), def::setServiceDiscoveryConfigurations); yield true;
                case "kubernetesServiceDiscovery": doAdd(doParseKubernetesServiceCallServiceDiscoveryConfiguration(), def.getServiceDiscoveryConfigurations(), def::setServiceDiscoveryConfigurations); yield true;
                case "staticServiceDiscovery": doAdd(doParseStaticServiceCallServiceDiscoveryConfiguration(), def.getServiceDiscoveryConfigurations(), def::setServiceDiscoveryConfigurations); yield true;
                case "cachingServiceDiscovery": doAdd(doParseCachingServiceCallServiceDiscoveryConfiguration(), def.getServiceDiscoveryConfigurations(), def::setServiceDiscoveryConfigurations); yield true;
                default: yield serviceCallConfigurationElementHandler().accept(def, key);
            }, noValueHandler());
    }
    protected CombinedServiceCallServiceFilterConfiguration doParseCombinedServiceCallServiceFilterConfiguration() throws IOException, XmlPullParserException {
        return doParse(new CombinedServiceCallServiceFilterConfiguration(), identifiedTypeAttributeHandler(), (def, key) -> switch (key) {
                case "blacklistServiceFilter": doAdd(doParseBlacklistServiceCallServiceFilterConfiguration(), def.getServiceFilterConfigurations(), def::setServiceFilterConfigurations); yield true;
                case "customServiceFilter": doAdd(doParseCustomServiceCallServiceFilterConfiguration(), def.getServiceFilterConfigurations(), def::setServiceFilterConfigurations); yield true;
                case "healthyServiceFilter": doAdd(doParseHealthyServiceCallServiceFilterConfiguration(), def.getServiceFilterConfigurations(), def::setServiceFilterConfigurations); yield true;
                case "passThroughServiceFilter": doAdd(doParsePassThroughServiceCallServiceFilterConfiguration(), def.getServiceFilterConfigurations(), def::setServiceFilterConfigurations); yield true;
                default: yield serviceCallConfigurationElementHandler().accept(def, key);
            }, noValueHandler());
    }
    protected ConsulServiceCallServiceDiscoveryConfiguration doParseConsulServiceCallServiceDiscoveryConfiguration() throws IOException, XmlPullParserException {
        return doParse(new ConsulServiceCallServiceDiscoveryConfiguration(), (def, key, val) -> switch (key) {
                case "aclToken": def.setAclToken(val); yield true;
                case "blockSeconds": def.setBlockSeconds(val); yield true;
                case "connectTimeoutMillis": def.setConnectTimeoutMillis(val); yield true;
                case "datacenter": def.setDatacenter(val); yield true;
                case "password": def.setPassword(val); yield true;
                case "readTimeoutMillis": def.setReadTimeoutMillis(val); yield true;
                case "url": def.setUrl(val); yield true;
                case "userName": def.setUserName(val); yield true;
                case "writeTimeoutMillis": def.setWriteTimeoutMillis(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, serviceCallConfigurationElementHandler(), noValueHandler());
    }
    protected CustomServiceCallServiceFilterConfiguration doParseCustomServiceCallServiceFilterConfiguration() throws IOException, XmlPullParserException {
        return doParse(new CustomServiceCallServiceFilterConfiguration(), (def, key, val) -> switch (key) {
                case "ref": def.setServiceFilterRef(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, serviceCallConfigurationElementHandler(), noValueHandler());
    }
    protected DefaultServiceCallServiceLoadBalancerConfiguration doParseDefaultServiceCallServiceLoadBalancerConfiguration() throws IOException, XmlPullParserException {
        return doParse(new DefaultServiceCallServiceLoadBalancerConfiguration(), identifiedTypeAttributeHandler(), serviceCallConfigurationElementHandler(), noValueHandler());
    }
    protected ServiceCallServiceLoadBalancerConfiguration doParseServiceCallServiceLoadBalancerConfiguration() throws IOException, XmlPullParserException {
        return doParse(new ServiceCallServiceLoadBalancerConfiguration(), identifiedTypeAttributeHandler(), serviceCallConfigurationElementHandler(), noValueHandler());
    }
    protected DnsServiceCallServiceDiscoveryConfiguration doParseDnsServiceCallServiceDiscoveryConfiguration() throws IOException, XmlPullParserException {
        return doParse(new DnsServiceCallServiceDiscoveryConfiguration(), (def, key, val) -> switch (key) {
                case "domain": def.setDomain(val); yield true;
                case "proto": def.setProto(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, serviceCallConfigurationElementHandler(), noValueHandler());
    }
    protected HealthyServiceCallServiceFilterConfiguration doParseHealthyServiceCallServiceFilterConfiguration() throws IOException, XmlPullParserException {
        return doParse(new HealthyServiceCallServiceFilterConfiguration(), identifiedTypeAttributeHandler(), serviceCallConfigurationElementHandler(), noValueHandler());
    }
    protected KubernetesServiceCallServiceDiscoveryConfiguration doParseKubernetesServiceCallServiceDiscoveryConfiguration() throws IOException, XmlPullParserException {
        return doParse(new KubernetesServiceCallServiceDiscoveryConfiguration(), (def, key, val) -> switch (key) {
                case "apiVersion": def.setApiVersion(val); yield true;
                case "caCertData": def.setCaCertData(val); yield true;
                case "caCertFile": def.setCaCertFile(val); yield true;
                case "clientCertData": def.setClientCertData(val); yield true;
                case "clientCertFile": def.setClientCertFile(val); yield true;
                case "clientKeyAlgo": def.setClientKeyAlgo(val); yield true;
                case "clientKeyData": def.setClientKeyData(val); yield true;
                case "clientKeyFile": def.setClientKeyFile(val); yield true;
                case "clientKeyPassphrase": def.setClientKeyPassphrase(val); yield true;
                case "dnsDomain": def.setDnsDomain(val); yield true;
                case "lookup": def.setLookup(val); yield true;
                case "masterUrl": def.setMasterUrl(val); yield true;
                case "namespace": def.setNamespace(val); yield true;
                case "oauthToken": def.setOauthToken(val); yield true;
                case "password": def.setPassword(val); yield true;
                case "portName": def.setPortName(val); yield true;
                case "portProtocol": def.setPortProtocol(val); yield true;
                case "trustCerts": def.setTrustCerts(val); yield true;
                case "username": def.setUsername(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, serviceCallConfigurationElementHandler(), noValueHandler());
    }
    protected PassThroughServiceCallServiceFilterConfiguration doParsePassThroughServiceCallServiceFilterConfiguration() throws IOException, XmlPullParserException {
        return doParse(new PassThroughServiceCallServiceFilterConfiguration(), identifiedTypeAttributeHandler(), serviceCallConfigurationElementHandler(), noValueHandler());
    }
    protected ServiceCallConfigurationDefinition doParseServiceCallConfigurationDefinition() throws IOException, XmlPullParserException {
        return doParse(new ServiceCallConfigurationDefinition(), (def, key, val) -> switch (key) {
                case "component": def.setComponent(val); yield true;
                case "expressionRef": def.setExpressionRef(val); yield true;
                case "loadBalancerRef": def.setLoadBalancerRef(val); yield true;
                case "pattern": def.setPattern(val); yield true;
                case "serviceChooserRef": def.setServiceChooserRef(val); yield true;
                case "serviceDiscoveryRef": def.setServiceDiscoveryRef(val); yield true;
                case "serviceFilterRef": def.setServiceFilterRef(val); yield true;
                case "uri": def.setUri(sanitizeUri(val)); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, (def, key) -> switch (key) {
                case "expression": def.setExpressionConfiguration(doParseServiceCallExpressionConfiguration()); yield true;
                case "defaultLoadBalancer": def.setLoadBalancerConfiguration(doParseDefaultServiceCallServiceLoadBalancerConfiguration()); yield true;
                case "cachingServiceDiscovery": def.setServiceDiscoveryConfiguration(doParseCachingServiceCallServiceDiscoveryConfiguration()); yield true;
                case "combinedServiceDiscovery": def.setServiceDiscoveryConfiguration(doParseCombinedServiceCallServiceDiscoveryConfiguration()); yield true;
                case "consulServiceDiscovery": def.setServiceDiscoveryConfiguration(doParseConsulServiceCallServiceDiscoveryConfiguration()); yield true;
                case "dnsServiceDiscovery": def.setServiceDiscoveryConfiguration(doParseDnsServiceCallServiceDiscoveryConfiguration()); yield true;
                case "kubernetesServiceDiscovery": def.setServiceDiscoveryConfiguration(doParseKubernetesServiceCallServiceDiscoveryConfiguration()); yield true;
                case "staticServiceDiscovery": def.setServiceDiscoveryConfiguration(doParseStaticServiceCallServiceDiscoveryConfiguration()); yield true;
                case "zookeeperServiceDiscovery": def.setServiceDiscoveryConfiguration(doParseZooKeeperServiceCallServiceDiscoveryConfiguration()); yield true;
                case "blacklistServiceFilter": def.setServiceFilterConfiguration(doParseBlacklistServiceCallServiceFilterConfiguration()); yield true;
                case "combinedServiceFilter": def.setServiceFilterConfiguration(doParseCombinedServiceCallServiceFilterConfiguration()); yield true;
                case "customServiceFilter": def.setServiceFilterConfiguration(doParseCustomServiceCallServiceFilterConfiguration()); yield true;
                case "healthyServiceFilter": def.setServiceFilterConfiguration(doParseHealthyServiceCallServiceFilterConfiguration()); yield true;
                case "passThroughServiceFilter": def.setServiceFilterConfiguration(doParsePassThroughServiceCallServiceFilterConfiguration()); yield true;
                default: yield false;
            }, noValueHandler());
    }
    protected ServiceCallExpressionConfiguration doParseServiceCallExpressionConfiguration() throws IOException, XmlPullParserException {
        return doParse(new ServiceCallExpressionConfiguration(), (def, key, val) -> switch (key) {
                case "hostHeader": def.setHostHeader(val); yield true;
                case "portHeader": def.setPortHeader(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, (def, key) -> {
                ExpressionDefinition v = doParseExpressionDefinitionRef(key);
                if (v != null) {
                    def.setExpressionType(v);
                    return true;
                }
                return serviceCallConfigurationElementHandler().accept(def, key);
            }, noValueHandler());
    }
    protected ServiceCallDefinition doParseServiceCallDefinition() throws IOException, XmlPullParserException {
        return doParse(new ServiceCallDefinition(), (def, key, val) -> switch (key) {
                case "component": def.setComponent(val); yield true;
                case "configurationRef": def.setConfigurationRef(val); yield true;
                case "expressionRef": def.setExpressionRef(val); yield true;
                case "loadBalancerRef": def.setLoadBalancerRef(val); yield true;
                case "name": def.setName(val); yield true;
                case "pattern": def.setPattern(val); yield true;
                case "serviceChooserRef": def.setServiceChooserRef(val); yield true;
                case "serviceDiscoveryRef": def.setServiceDiscoveryRef(val); yield true;
                case "serviceFilterRef": def.setServiceFilterRef(val); yield true;
                case "uri": def.setUri(sanitizeUri(val)); yield true;
                default: yield processorDefinitionAttributeHandler().accept(def, key, val);
            }, (def, key) -> switch (key) {
                case "expression": def.setExpressionConfiguration(doParseServiceCallExpressionConfiguration()); yield true;
                case "defaultLoadBalancer": def.setLoadBalancerConfiguration(doParseDefaultServiceCallServiceLoadBalancerConfiguration()); yield true;
                case "cachingServiceDiscovery": def.setServiceDiscoveryConfiguration(doParseCachingServiceCallServiceDiscoveryConfiguration()); yield true;
                case "combinedServiceDiscovery": def.setServiceDiscoveryConfiguration(doParseCombinedServiceCallServiceDiscoveryConfiguration()); yield true;
                case "consulServiceDiscovery": def.setServiceDiscoveryConfiguration(doParseConsulServiceCallServiceDiscoveryConfiguration()); yield true;
                case "dnsServiceDiscovery": def.setServiceDiscoveryConfiguration(doParseDnsServiceCallServiceDiscoveryConfiguration()); yield true;
                case "kubernetesServiceDiscovery": def.setServiceDiscoveryConfiguration(doParseKubernetesServiceCallServiceDiscoveryConfiguration()); yield true;
                case "staticServiceDiscovery": def.setServiceDiscoveryConfiguration(doParseStaticServiceCallServiceDiscoveryConfiguration()); yield true;
                case "zookeeperServiceDiscovery": def.setServiceDiscoveryConfiguration(doParseZooKeeperServiceCallServiceDiscoveryConfiguration()); yield true;
                case "blacklistServiceFilter": def.setServiceFilterConfiguration(doParseBlacklistServiceCallServiceFilterConfiguration()); yield true;
                case "combinedServiceFilter": def.setServiceFilterConfiguration(doParseCombinedServiceCallServiceFilterConfiguration()); yield true;
                case "customServiceFilter": def.setServiceFilterConfiguration(doParseCustomServiceCallServiceFilterConfiguration()); yield true;
                case "healthyServiceFilter": def.setServiceFilterConfiguration(doParseHealthyServiceCallServiceFilterConfiguration()); yield true;
                case "passThroughServiceFilter": def.setServiceFilterConfiguration(doParsePassThroughServiceCallServiceFilterConfiguration()); yield true;
                default: yield optionalIdentifiedDefinitionElementHandler().accept(def, key);
            }, noValueHandler());
    }
    protected ServiceCallServiceChooserConfiguration doParseServiceCallServiceChooserConfiguration() throws IOException, XmlPullParserException {
        return doParse(new ServiceCallServiceChooserConfiguration(), identifiedTypeAttributeHandler(), serviceCallConfigurationElementHandler(), noValueHandler());
    }
    protected StaticServiceCallServiceDiscoveryConfiguration doParseStaticServiceCallServiceDiscoveryConfiguration() throws IOException, XmlPullParserException {
        return doParse(new StaticServiceCallServiceDiscoveryConfiguration(), identifiedTypeAttributeHandler(), (def, key) -> switch (key) {
                case "servers": doAdd(doParseText(), def.getServers(), def::setServers); yield true;
                default: yield serviceCallConfigurationElementHandler().accept(def, key);
            }, noValueHandler());
    }
    protected ZooKeeperServiceCallServiceDiscoveryConfiguration doParseZooKeeperServiceCallServiceDiscoveryConfiguration() throws IOException, XmlPullParserException {
        return doParse(new ZooKeeperServiceCallServiceDiscoveryConfiguration(), (def, key, val) -> switch (key) {
                case "basePath": def.setBasePath(val); yield true;
                case "connectionTimeout": def.setConnectionTimeout(val); yield true;
                case "namespace": def.setNamespace(val); yield true;
                case "nodes": def.setNodes(val); yield true;
                case "reconnectBaseSleepTime": def.setReconnectBaseSleepTime(val); yield true;
                case "reconnectMaxRetries": def.setReconnectMaxRetries(val); yield true;
                case "reconnectMaxSleepTime": def.setReconnectMaxSleepTime(val); yield true;
                case "sessionTimeout": def.setSessionTimeout(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, serviceCallConfigurationElementHandler(), noValueHandler());
    }
    protected BatchResequencerConfig doParseBatchResequencerConfig() throws IOException, XmlPullParserException {
        return doParse(new BatchResequencerConfig(), (def, key, val) -> switch (key) {
                case "allowDuplicates": def.setAllowDuplicates(val); yield true;
                case "batchSize": def.setBatchSize(val); yield true;
                case "batchTimeout": def.setBatchTimeout(val); yield true;
                case "ignoreInvalidExchanges": def.setIgnoreInvalidExchanges(val); yield true;
                case "reverse": def.setReverse(val); yield true;
                default: yield false;
            }, noElementHandler(), noValueHandler());
    }
    protected StreamResequencerConfig doParseStreamResequencerConfig() throws IOException, XmlPullParserException {
        return doParse(new StreamResequencerConfig(), (def, key, val) -> switch (key) {
                case "capacity": def.setCapacity(val); yield true;
                case "comparator": def.setComparator(val); yield true;
                case "deliveryAttemptInterval": def.setDeliveryAttemptInterval(val); yield true;
                case "ignoreInvalidExchanges": def.setIgnoreInvalidExchanges(val); yield true;
                case "rejectOld": def.setRejectOld(val); yield true;
                case "timeout": def.setTimeout(val); yield true;
                default: yield false;
            }, noElementHandler(), noValueHandler());
    }
    protected ASN1DataFormat doParseASN1DataFormat() throws IOException, XmlPullParserException {
        return doParse(new ASN1DataFormat(), (def, key, val) -> switch (key) {
                case "unmarshalType": def.setUnmarshalTypeName(val); yield true;
                case "usingIterator": def.setUsingIterator(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected AvroDataFormat doParseAvroDataFormat() throws IOException, XmlPullParserException {
        return doParse(new AvroDataFormat(), (def, key, val) -> switch (key) {
                case "allowJmsType": def.setAllowJmsType(val); yield true;
                case "allowUnmarshallType": def.setAllowUnmarshallType(val); yield true;
                case "autoDiscoverObjectMapper": def.setAutoDiscoverObjectMapper(val); yield true;
                case "autoDiscoverSchemaResolver": def.setAutoDiscoverSchemaResolver(val); yield true;
                case "collectionType": def.setCollectionTypeName(val); yield true;
                case "contentTypeHeader": def.setContentTypeHeader(val); yield true;
                case "disableFeatures": def.setDisableFeatures(val); yield true;
                case "enableFeatures": def.setEnableFeatures(val); yield true;
                case "include": def.setInclude(val); yield true;
                case "instanceClassName": def.setInstanceClassName(val); yield true;
                case "jsonView": def.setJsonViewTypeName(val); yield true;
                case "library": def.setLibrary(AvroLibrary.valueOf(val)); yield true;
                case "moduleClassNames": def.setModuleClassNames(val); yield true;
                case "moduleRefs": def.setModuleRefs(val); yield true;
                case "objectMapper": def.setObjectMapper(val); yield true;
                case "schemaResolver": def.setSchemaResolver(val); yield true;
                case "timezone": def.setTimezone(val); yield true;
                case "unmarshalType": def.setUnmarshalTypeName(val); yield true;
                case "useDefaultObjectMapper": def.setUseDefaultObjectMapper(val); yield true;
                case "useList": def.setUseList(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected BarcodeDataFormat doParseBarcodeDataFormat() throws IOException, XmlPullParserException {
        return doParse(new BarcodeDataFormat(), (def, key, val) -> switch (key) {
                case "barcodeFormat": def.setBarcodeFormat(val); yield true;
                case "height": def.setHeight(val); yield true;
                case "imageType": def.setImageType(val); yield true;
                case "width": def.setWidth(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected Base64DataFormat doParseBase64DataFormat() throws IOException, XmlPullParserException {
        return doParse(new Base64DataFormat(), (def, key, val) -> switch (key) {
                case "lineLength": def.setLineLength(val); yield true;
                case "lineSeparator": def.setLineSeparator(val); yield true;
                case "urlSafe": def.setUrlSafe(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected BeanioDataFormat doParseBeanioDataFormat() throws IOException, XmlPullParserException {
        return doParse(new BeanioDataFormat(), (def, key, val) -> switch (key) {
                case "beanReaderErrorHandlerType": def.setBeanReaderErrorHandlerType(val); yield true;
                case "encoding": def.setEncoding(val); yield true;
                case "ignoreInvalidRecords": def.setIgnoreInvalidRecords(val); yield true;
                case "ignoreUnexpectedRecords": def.setIgnoreUnexpectedRecords(val); yield true;
                case "ignoreUnidentifiedRecords": def.setIgnoreUnidentifiedRecords(val); yield true;
                case "mapping": def.setMapping(val); yield true;
                case "streamName": def.setStreamName(val); yield true;
                case "unmarshalSingleObject": def.setUnmarshalSingleObject(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected BindyDataFormat doParseBindyDataFormat() throws IOException, XmlPullParserException {
        return doParse(new BindyDataFormat(), (def, key, val) -> switch (key) {
                case "allowEmptyStream": def.setAllowEmptyStream(val); yield true;
                case "classType": def.setClassTypeAsString(val); yield true;
                case "locale": def.setLocale(val); yield true;
                case "type": def.setType(val); yield true;
                case "unwrapSingleInstance": def.setUnwrapSingleInstance(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected CBORDataFormat doParseCBORDataFormat() throws IOException, XmlPullParserException {
        return doParse(new CBORDataFormat(), (def, key, val) -> switch (key) {
                case "allowJmsType": def.setAllowJmsType(val); yield true;
                case "allowUnmarshallType": def.setAllowUnmarshallType(val); yield true;
                case "collectionType": def.setCollectionTypeName(val); yield true;
                case "disableFeatures": def.setDisableFeatures(val); yield true;
                case "enableFeatures": def.setEnableFeatures(val); yield true;
                case "objectMapper": def.setObjectMapper(val); yield true;
                case "prettyPrint": def.setPrettyPrint(val); yield true;
                case "unmarshalType": def.setUnmarshalTypeName(val); yield true;
                case "useDefaultObjectMapper": def.setUseDefaultObjectMapper(val); yield true;
                case "useList": def.setUseList(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected CryptoDataFormat doParseCryptoDataFormat() throws IOException, XmlPullParserException {
        return doParse(new CryptoDataFormat(), (def, key, val) -> switch (key) {
                case "algorithm": def.setAlgorithm(val); yield true;
                case "algorithmParameterRef": def.setAlgorithmParameterRef(val); yield true;
                case "bufferSize": def.setBufferSize(val); yield true;
                case "cryptoProvider": def.setCryptoProvider(val); yield true;
                case "initVectorRef": def.setInitVectorRef(val); yield true;
                case "inline": def.setInline(val); yield true;
                case "keyRef": def.setKeyRef(val); yield true;
                case "macAlgorithm": def.setMacAlgorithm(val); yield true;
                case "shouldAppendHMAC": def.setShouldAppendHMAC(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected CsvDataFormat doParseCsvDataFormat() throws IOException, XmlPullParserException {
        return doParse(new CsvDataFormat(), (def, key, val) -> switch (key) {
                case "allowMissingColumnNames": def.setAllowMissingColumnNames(val); yield true;
                case "captureHeaderRecord": def.setCaptureHeaderRecord(val); yield true;
                case "commentMarker": def.setCommentMarker(val); yield true;
                case "commentMarkerDisabled": def.setCommentMarkerDisabled(val); yield true;
                case "delimiter": def.setDelimiter(val); yield true;
                case "escape": def.setEscape(val); yield true;
                case "escapeDisabled": def.setEscapeDisabled(val); yield true;
                case "formatName": def.setFormatName(val); yield true;
                case "formatRef": def.setFormatRef(val); yield true;
                case "headerDisabled": def.setHeaderDisabled(val); yield true;
                case "ignoreEmptyLines": def.setIgnoreEmptyLines(val); yield true;
                case "ignoreHeaderCase": def.setIgnoreHeaderCase(val); yield true;
                case "ignoreSurroundingSpaces": def.setIgnoreSurroundingSpaces(val); yield true;
                case "lazyLoad": def.setLazyLoad(val); yield true;
                case "marshallerFactoryRef": def.setMarshallerFactoryRef(val); yield true;
                case "nullString": def.setNullString(val); yield true;
                case "nullStringDisabled": def.setNullStringDisabled(val); yield true;
                case "quote": def.setQuote(val); yield true;
                case "quoteDisabled": def.setQuoteDisabled(val); yield true;
                case "quoteMode": def.setQuoteMode(val); yield true;
                case "recordConverterRef": def.setRecordConverterRef(val); yield true;
                case "recordSeparator": def.setRecordSeparator(val); yield true;
                case "recordSeparatorDisabled": def.setRecordSeparatorDisabled(val); yield true;
                case "skipHeaderRecord": def.setSkipHeaderRecord(val); yield true;
                case "trailingDelimiter": def.setTrailingDelimiter(val); yield true;
                case "trim": def.setTrim(val); yield true;
                case "useMaps": def.setUseMaps(val); yield true;
                case "useOrderedMaps": def.setUseOrderedMaps(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, (def, key) -> switch (key) {
                case "header": doAdd(doParseText(), def.getHeader(), def::setHeader); yield true;
                default: yield false;
            }, noValueHandler());
    }
    protected CustomDataFormat doParseCustomDataFormat() throws IOException, XmlPullParserException {
        return doParse(new CustomDataFormat(), (def, key, val) -> switch (key) {
                case "ref": def.setRef(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected DataFormatsDefinition doParseDataFormatsDefinition() throws IOException, XmlPullParserException {
        return doParse(new DataFormatsDefinition(), noAttributeHandler(), (def, key) -> {
                DataFormatDefinition v = doParseDataFormatDefinitionRef(key);
                if (v != null) {
                    doAdd(v, def.getDataFormats(), def::setDataFormats);
                    return true;
                }
                return false;
            }, noValueHandler());
    }
    protected FhirJsonDataFormat doParseFhirJsonDataFormat() throws IOException, XmlPullParserException {
        return doParse(new FhirJsonDataFormat(), fhirDataformatAttributeHandler(), noElementHandler(), noValueHandler());
    }
    protected <T extends FhirDataformat> AttributeHandler<T> fhirDataformatAttributeHandler() {
        return (def, key, val) -> switch (key) {
            case "contentTypeHeader": def.setContentTypeHeader(val); yield true;
            case "dontEncodeElements": def.setDontEncodeElements(val); yield true;
            case "dontStripVersionsFromReferencesAtPaths": def.setDontStripVersionsFromReferencesAtPaths(val); yield true;
            case "encodeElements": def.setEncodeElements(val); yield true;
            case "encodeElementsAppliesToChildResourcesOnly": def.setEncodeElementsAppliesToChildResourcesOnly(val); yield true;
            case "fhirContext": def.setFhirContext(val); yield true;
            case "fhirVersion": def.setFhirVersion(val); yield true;
            case "forceResourceId": def.setForceResourceId(val); yield true;
            case "omitResourceId": def.setOmitResourceId(val); yield true;
            case "overrideResourceIdWithBundleEntryFullUrl": def.setOverrideResourceIdWithBundleEntryFullUrl(val); yield true;
            case "parserErrorHandler": def.setParserErrorHandler(val); yield true;
            case "parserOptions": def.setParserOptions(val); yield true;
            case "preferTypes": def.setPreferTypes(val); yield true;
            case "prettyPrint": def.setPrettyPrint(val); yield true;
            case "serverBaseUrl": def.setServerBaseUrl(val); yield true;
            case "stripVersionsFromReferences": def.setStripVersionsFromReferences(val); yield true;
            case "summaryMode": def.setSummaryMode(val); yield true;
            case "suppressNarratives": def.setSuppressNarratives(val); yield true;
            default: yield identifiedTypeAttributeHandler().accept(def, key, val);
        };
    }
    protected FhirXmlDataFormat doParseFhirXmlDataFormat() throws IOException, XmlPullParserException {
        return doParse(new FhirXmlDataFormat(), fhirDataformatAttributeHandler(), noElementHandler(), noValueHandler());
    }
    protected FlatpackDataFormat doParseFlatpackDataFormat() throws IOException, XmlPullParserException {
        return doParse(new FlatpackDataFormat(), (def, key, val) -> switch (key) {
                case "allowShortLines": def.setAllowShortLines(val); yield true;
                case "definition": def.setDefinition(val); yield true;
                case "delimiter": def.setDelimiter(val); yield true;
                case "fixed": def.setFixed(val); yield true;
                case "ignoreExtraColumns": def.setIgnoreExtraColumns(val); yield true;
                case "ignoreFirstRecord": def.setIgnoreFirstRecord(val); yield true;
                case "parserFactoryRef": def.setParserFactoryRef(val); yield true;
                case "textQualifier": def.setTextQualifier(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected GrokDataFormat doParseGrokDataFormat() throws IOException, XmlPullParserException {
        return doParse(new GrokDataFormat(), (def, key, val) -> switch (key) {
                case "allowMultipleMatchesPerLine": def.setAllowMultipleMatchesPerLine(val); yield true;
                case "flattened": def.setFlattened(val); yield true;
                case "namedOnly": def.setNamedOnly(val); yield true;
                case "pattern": def.setPattern(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected GzipDeflaterDataFormat doParseGzipDeflaterDataFormat() throws IOException, XmlPullParserException {
        return doParse(new GzipDeflaterDataFormat(), identifiedTypeAttributeHandler(), noElementHandler(), noValueHandler());
    }
    protected HL7DataFormat doParseHL7DataFormat() throws IOException, XmlPullParserException {
        return doParse(new HL7DataFormat(), (def, key, val) -> switch (key) {
                case "validate": def.setValidate(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected IcalDataFormat doParseIcalDataFormat() throws IOException, XmlPullParserException {
        return doParse(new IcalDataFormat(), (def, key, val) -> switch (key) {
                case "validating": def.setValidating(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected JacksonXMLDataFormat doParseJacksonXMLDataFormat() throws IOException, XmlPullParserException {
        return doParse(new JacksonXMLDataFormat(), (def, key, val) -> switch (key) {
                case "allowJmsType": def.setAllowJmsType(val); yield true;
                case "allowUnmarshallType": def.setAllowUnmarshallType(val); yield true;
                case "collectionType": def.setCollectionTypeName(val); yield true;
                case "contentTypeHeader": def.setContentTypeHeader(val); yield true;
                case "disableFeatures": def.setDisableFeatures(val); yield true;
                case "enableFeatures": def.setEnableFeatures(val); yield true;
                case "enableJaxbAnnotationModule": def.setEnableJaxbAnnotationModule(val); yield true;
                case "include": def.setInclude(val); yield true;
                case "jsonView": def.setJsonViewTypeName(val); yield true;
                case "moduleClassNames": def.setModuleClassNames(val); yield true;
                case "moduleRefs": def.setModuleRefs(val); yield true;
                case "prettyPrint": def.setPrettyPrint(val); yield true;
                case "timezone": def.setTimezone(val); yield true;
                case "unmarshalType": def.setUnmarshalTypeName(val); yield true;
                case "useList": def.setUseList(val); yield true;
                case "xmlMapper": def.setXmlMapper(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected JaxbDataFormat doParseJaxbDataFormat() throws IOException, XmlPullParserException {
        return doParse(new JaxbDataFormat(), (def, key, val) -> switch (key) {
                case "accessExternalSchemaProtocols": def.setAccessExternalSchemaProtocols(val); yield true;
                case "contentTypeHeader": def.setContentTypeHeader(val); yield true;
                case "contextPath": def.setContextPath(val); yield true;
                case "contextPathIsClassName": def.setContextPathIsClassName(val); yield true;
                case "encoding": def.setEncoding(val); yield true;
                case "filterNonXmlChars": def.setFilterNonXmlChars(val); yield true;
                case "fragment": def.setFragment(val); yield true;
                case "ignoreJAXBElement": def.setIgnoreJAXBElement(val); yield true;
                case "jaxbProviderProperties": def.setJaxbProviderProperties(val); yield true;
                case "mustBeJAXBElement": def.setMustBeJAXBElement(val); yield true;
                case "namespacePrefixRef": def.setNamespacePrefixRef(val); yield true;
                case "noNamespaceSchemaLocation": def.setNoNamespaceSchemaLocation(val); yield true;
                case "objectFactory": def.setObjectFactory(val); yield true;
                case "partClass": def.setPartClass(val); yield true;
                case "partNamespace": def.setPartNamespace(val); yield true;
                case "prettyPrint": def.setPrettyPrint(val); yield true;
                case "schema": def.setSchema(val); yield true;
                case "schemaLocation": def.setSchemaLocation(val); yield true;
                case "schemaSeverityLevel": def.setSchemaSeverityLevel(val); yield true;
                case "xmlStreamWriterWrapper": def.setXmlStreamWriterWrapper(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected JsonApiDataFormat doParseJsonApiDataFormat() throws IOException, XmlPullParserException {
        return doParse(new JsonApiDataFormat(), (def, key, val) -> switch (key) {
                case "dataFormatTypes": def.setDataFormatTypes(val); yield true;
                case "mainFormatType": def.setMainFormatType(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected JsonDataFormat doParseJsonDataFormat() throws IOException, XmlPullParserException {
        return doParse(new JsonDataFormat(), (def, key, val) -> switch (key) {
                case "allowJmsType": def.setAllowJmsType(val); yield true;
                case "allowUnmarshallType": def.setAllowUnmarshallType(val); yield true;
                case "autoDiscoverObjectMapper": def.setAutoDiscoverObjectMapper(val); yield true;
                case "autoDiscoverSchemaResolver": def.setAutoDiscoverSchemaResolver(val); yield true;
                case "collectionType": def.setCollectionTypeName(val); yield true;
                case "contentTypeHeader": def.setContentTypeHeader(val); yield true;
                case "dateFormatPattern": def.setDateFormatPattern(val); yield true;
                case "disableFeatures": def.setDisableFeatures(val); yield true;
                case "enableFeatures": def.setEnableFeatures(val); yield true;
                case "include": def.setInclude(val); yield true;
                case "jsonView": def.setJsonViewTypeName(val); yield true;
                case "library": def.setLibrary(JsonLibrary.valueOf(val)); yield true;
                case "moduleClassNames": def.setModuleClassNames(val); yield true;
                case "moduleRefs": def.setModuleRefs(val); yield true;
                case "namingStrategy": def.setNamingStrategy(val); yield true;
                case "objectMapper": def.setObjectMapper(val); yield true;
                case "prettyPrint": def.setPrettyPrint(val); yield true;
                case "schemaResolver": def.setSchemaResolver(val); yield true;
                case "timezone": def.setTimezone(val); yield true;
                case "unmarshalType": def.setUnmarshalTypeName(val); yield true;
                case "useDefaultObjectMapper": def.setUseDefaultObjectMapper(val); yield true;
                case "useList": def.setUseList(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected LZFDataFormat doParseLZFDataFormat() throws IOException, XmlPullParserException {
        return doParse(new LZFDataFormat(), (def, key, val) -> switch (key) {
                case "usingParallelCompression": def.setUsingParallelCompression(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected MimeMultipartDataFormat doParseMimeMultipartDataFormat() throws IOException, XmlPullParserException {
        return doParse(new MimeMultipartDataFormat(), (def, key, val) -> switch (key) {
                case "binaryContent": def.setBinaryContent(val); yield true;
                case "headersInline": def.setHeadersInline(val); yield true;
                case "includeHeaders": def.setIncludeHeaders(val); yield true;
                case "multipartSubType": def.setMultipartSubType(val); yield true;
                case "multipartWithoutAttachment": def.setMultipartWithoutAttachment(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected PGPDataFormat doParsePGPDataFormat() throws IOException, XmlPullParserException {
        return doParse(new PGPDataFormat(), (def, key, val) -> switch (key) {
                case "algorithm": def.setAlgorithm(val); yield true;
                case "armored": def.setArmored(val); yield true;
                case "compressionAlgorithm": def.setCompressionAlgorithm(val); yield true;
                case "hashAlgorithm": def.setHashAlgorithm(val); yield true;
                case "integrity": def.setIntegrity(val); yield true;
                case "keyFileName": def.setKeyFileName(val); yield true;
                case "keyUserid": def.setKeyUserid(val); yield true;
                case "password": def.setPassword(val); yield true;
                case "provider": def.setProvider(val); yield true;
                case "signatureKeyFileName": def.setSignatureKeyFileName(val); yield true;
                case "signatureKeyRing": def.setSignatureKeyRing(val); yield true;
                case "signatureKeyUserid": def.setSignatureKeyUserid(val); yield true;
                case "signaturePassword": def.setSignaturePassword(val); yield true;
                case "signatureVerificationOption": def.setSignatureVerificationOption(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected ParquetAvroDataFormat doParseParquetAvroDataFormat() throws IOException, XmlPullParserException {
        return doParse(new ParquetAvroDataFormat(), (def, key, val) -> switch (key) {
                case "compressionCodecName": def.setCompressionCodecName(val); yield true;
                case "lazyLoad": def.setLazyLoad(val); yield true;
                case "unmarshalType": def.setUnmarshalTypeName(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected ProtobufDataFormat doParseProtobufDataFormat() throws IOException, XmlPullParserException {
        return doParse(new ProtobufDataFormat(), (def, key, val) -> switch (key) {
                case "allowJmsType": def.setAllowJmsType(val); yield true;
                case "allowUnmarshallType": def.setAllowUnmarshallType(val); yield true;
                case "autoDiscoverObjectMapper": def.setAutoDiscoverObjectMapper(val); yield true;
                case "autoDiscoverSchemaResolver": def.setAutoDiscoverSchemaResolver(val); yield true;
                case "collectionType": def.setCollectionTypeName(val); yield true;
                case "contentTypeFormat": def.setContentTypeFormat(val); yield true;
                case "contentTypeHeader": def.setContentTypeHeader(val); yield true;
                case "disableFeatures": def.setDisableFeatures(val); yield true;
                case "enableFeatures": def.setEnableFeatures(val); yield true;
                case "include": def.setInclude(val); yield true;
                case "instanceClass": def.setInstanceClass(val); yield true;
                case "jsonView": def.setJsonViewTypeName(val); yield true;
                case "library": def.setLibrary(ProtobufLibrary.valueOf(val)); yield true;
                case "moduleClassNames": def.setModuleClassNames(val); yield true;
                case "moduleRefs": def.setModuleRefs(val); yield true;
                case "objectMapper": def.setObjectMapper(val); yield true;
                case "schemaResolver": def.setSchemaResolver(val); yield true;
                case "timezone": def.setTimezone(val); yield true;
                case "unmarshalType": def.setUnmarshalTypeName(val); yield true;
                case "useDefaultObjectMapper": def.setUseDefaultObjectMapper(val); yield true;
                case "useList": def.setUseList(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected RssDataFormat doParseRssDataFormat() throws IOException, XmlPullParserException {
        return doParse(new RssDataFormat(), identifiedTypeAttributeHandler(), noElementHandler(), noValueHandler());
    }
    protected SoapDataFormat doParseSoapDataFormat() throws IOException, XmlPullParserException {
        return doParse(new SoapDataFormat(), (def, key, val) -> switch (key) {
                case "contextPath": def.setContextPath(val); yield true;
                case "elementNameStrategyRef": def.setElementNameStrategyRef(val); yield true;
                case "encoding": def.setEncoding(val); yield true;
                case "namespacePrefixRef": def.setNamespacePrefixRef(val); yield true;
                case "schema": def.setSchema(val); yield true;
                case "version": def.setVersion(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected SwiftMtDataFormat doParseSwiftMtDataFormat() throws IOException, XmlPullParserException {
        return doParse(new SwiftMtDataFormat(), (def, key, val) -> switch (key) {
                case "writeInJson": def.setWriteInJson(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected SwiftMxDataFormat doParseSwiftMxDataFormat() throws IOException, XmlPullParserException {
        return doParse(new SwiftMxDataFormat(), (def, key, val) -> switch (key) {
                case "readConfigRef": def.setReadConfigRef(val); yield true;
                case "readMessageId": def.setReadMessageId(val); yield true;
                case "writeConfigRef": def.setWriteConfigRef(val); yield true;
                case "writeInJson": def.setWriteInJson(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected SyslogDataFormat doParseSyslogDataFormat() throws IOException, XmlPullParserException {
        return doParse(new SyslogDataFormat(), identifiedTypeAttributeHandler(), noElementHandler(), noValueHandler());
    }
    protected TarFileDataFormat doParseTarFileDataFormat() throws IOException, XmlPullParserException {
        return doParse(new TarFileDataFormat(), (def, key, val) -> switch (key) {
                case "allowEmptyDirectory": def.setAllowEmptyDirectory(val); yield true;
                case "maxDecompressedSize": def.setMaxDecompressedSize(val); yield true;
                case "preservePathElements": def.setPreservePathElements(val); yield true;
                case "usingIterator": def.setUsingIterator(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected ThriftDataFormat doParseThriftDataFormat() throws IOException, XmlPullParserException {
        return doParse(new ThriftDataFormat(), (def, key, val) -> switch (key) {
                case "contentTypeFormat": def.setContentTypeFormat(val); yield true;
                case "contentTypeHeader": def.setContentTypeHeader(val); yield true;
                case "instanceClass": def.setInstanceClass(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected TidyMarkupDataFormat doParseTidyMarkupDataFormat() throws IOException, XmlPullParserException {
        return doParse(new TidyMarkupDataFormat(), (def, key, val) -> switch (key) {
                case "dataObjectType": def.setDataObjectTypeName(val); yield true;
                case "omitXmlDeclaration": def.setOmitXmlDeclaration(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected UniVocityCsvDataFormat doParseUniVocityCsvDataFormat() throws IOException, XmlPullParserException {
        return doParse(new UniVocityCsvDataFormat(), (def, key, val) -> switch (key) {
                case "delimiter": def.setDelimiter(val); yield true;
                case "quote": def.setQuote(val); yield true;
                case "quoteAllFields": def.setQuoteAllFields(val); yield true;
                case "quoteEscape": def.setQuoteEscape(val); yield true;
                default: yield uniVocityAbstractDataFormatAttributeHandler().accept(def, key, val);
            }, uniVocityAbstractDataFormatElementHandler(), noValueHandler());
    }
    protected <T extends UniVocityAbstractDataFormat> AttributeHandler<T> uniVocityAbstractDataFormatAttributeHandler() {
        return (def, key, val) -> switch (key) {
            case "asMap": def.setAsMap(val); yield true;
            case "comment": def.setComment(val); yield true;
            case "emptyValue": def.setEmptyValue(val); yield true;
            case "headerExtractionEnabled": def.setHeaderExtractionEnabled(val); yield true;
            case "headersDisabled": def.setHeadersDisabled(val); yield true;
            case "ignoreLeadingWhitespaces": def.setIgnoreLeadingWhitespaces(val); yield true;
            case "ignoreTrailingWhitespaces": def.setIgnoreTrailingWhitespaces(val); yield true;
            case "lazyLoad": def.setLazyLoad(val); yield true;
            case "lineSeparator": def.setLineSeparator(val); yield true;
            case "normalizedLineSeparator": def.setNormalizedLineSeparator(val); yield true;
            case "nullValue": def.setNullValue(val); yield true;
            case "numberOfRecordsToRead": def.setNumberOfRecordsToRead(val); yield true;
            case "skipEmptyLines": def.setSkipEmptyLines(val); yield true;
            default: yield identifiedTypeAttributeHandler().accept(def, key, val);
        };
    }
    protected <T extends UniVocityAbstractDataFormat> ElementHandler<T> uniVocityAbstractDataFormatElementHandler() {
        return (def, key) -> switch (key) {
            case "univocityHeader": doAdd(doParseUniVocityHeader(), def.getHeaders(), def::setHeaders); yield true;
            default: yield false;
        };
    }
    protected UniVocityHeader doParseUniVocityHeader() throws IOException, XmlPullParserException {
        return doParse(new UniVocityHeader(), (def, key, val) -> switch (key) {
                case "length": def.setLength(val); yield true;
                default: yield false;
            }, noElementHandler(), (def, val) -> def.setName(val));
    }
    protected UniVocityFixedDataFormat doParseUniVocityFixedDataFormat() throws IOException, XmlPullParserException {
        return doParse(new UniVocityFixedDataFormat(), (def, key, val) -> switch (key) {
                case "padding": def.setPadding(val); yield true;
                case "recordEndsOnNewline": def.setRecordEndsOnNewline(val); yield true;
                case "skipTrailingCharsUntilNewline": def.setSkipTrailingCharsUntilNewline(val); yield true;
                default: yield uniVocityAbstractDataFormatAttributeHandler().accept(def, key, val);
            }, uniVocityAbstractDataFormatElementHandler(), noValueHandler());
    }
    protected UniVocityTsvDataFormat doParseUniVocityTsvDataFormat() throws IOException, XmlPullParserException {
        return doParse(new UniVocityTsvDataFormat(), (def, key, val) -> switch (key) {
                case "escapeChar": def.setEscapeChar(val); yield true;
                default: yield uniVocityAbstractDataFormatAttributeHandler().accept(def, key, val);
            }, uniVocityAbstractDataFormatElementHandler(), noValueHandler());
    }
    protected XMLSecurityDataFormat doParseXMLSecurityDataFormat() throws IOException, XmlPullParserException {
        return doParse(new XMLSecurityDataFormat(), (def, key, val) -> switch (key) {
                case "addKeyValueForEncryptedKey": def.setAddKeyValueForEncryptedKey(val); yield true;
                case "digestAlgorithm": def.setDigestAlgorithm(val); yield true;
                case "keyCipherAlgorithm": def.setKeyCipherAlgorithm(val); yield true;
                case "keyOrTrustStoreParametersRef": def.setKeyOrTrustStoreParametersRef(val); yield true;
                case "keyPassword": def.setKeyPassword(val); yield true;
                case "mgfAlgorithm": def.setMgfAlgorithm(val); yield true;
                case "passPhrase": def.setPassPhrase(val); yield true;
                case "passPhraseByte": def.setPassPhraseByte(asByteArray(val)); yield true;
                case "recipientKeyAlias": def.setRecipientKeyAlias(val); yield true;
                case "secureTag": def.setSecureTag(val); yield true;
                case "secureTagContents": def.setSecureTagContents(val); yield true;
                case "xmlCipherAlgorithm": def.setXmlCipherAlgorithm(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected YAMLDataFormat doParseYAMLDataFormat() throws IOException, XmlPullParserException {
        return doParse(new YAMLDataFormat(), (def, key, val) -> switch (key) {
                case "allowAnyType": def.setAllowAnyType(val); yield true;
                case "allowRecursiveKeys": def.setAllowRecursiveKeys(val); yield true;
                case "constructor": def.setConstructor(val); yield true;
                case "dumperOptions": def.setDumperOptions(val); yield true;
                case "library": def.setLibrary(YAMLLibrary.valueOf(val)); yield true;
                case "maxAliasesForCollections": def.setMaxAliasesForCollections(val); yield true;
                case "prettyFlow": def.setPrettyFlow(val); yield true;
                case "representer": def.setRepresenter(val); yield true;
                case "resolver": def.setResolver(val); yield true;
                case "unmarshalType": def.setUnmarshalTypeName(val); yield true;
                case "useApplicationContextClassLoader": def.setUseApplicationContextClassLoader(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, (def, key) -> switch (key) {
                case "typeFilter": doAdd(doParseYAMLTypeFilterDefinition(), def.getTypeFilters(), def::setTypeFilters); yield true;
                default: yield false;
            }, noValueHandler());
    }
    protected YAMLTypeFilterDefinition doParseYAMLTypeFilterDefinition() throws IOException, XmlPullParserException {
        return doParse(new YAMLTypeFilterDefinition(), (def, key, val) -> switch (key) {
                case "type": def.setType(val); yield true;
                case "value": def.setValue(val); yield true;
                default: yield false;
            }, noElementHandler(), noValueHandler());
    }
    protected ZipDeflaterDataFormat doParseZipDeflaterDataFormat() throws IOException, XmlPullParserException {
        return doParse(new ZipDeflaterDataFormat(), (def, key, val) -> switch (key) {
                case "compressionLevel": def.setCompressionLevel(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected ZipFileDataFormat doParseZipFileDataFormat() throws IOException, XmlPullParserException {
        return doParse(new ZipFileDataFormat(), (def, key, val) -> switch (key) {
                case "allowEmptyDirectory": def.setAllowEmptyDirectory(val); yield true;
                case "maxDecompressedSize": def.setMaxDecompressedSize(val); yield true;
                case "preservePathElements": def.setPreservePathElements(val); yield true;
                case "usingIterator": def.setUsingIterator(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected DeadLetterChannelDefinition doParseDeadLetterChannelDefinition() throws IOException, XmlPullParserException {
        return doParse(new DeadLetterChannelDefinition(), (def, key, val) -> switch (key) {
                case "deadLetterHandleNewException": def.setDeadLetterHandleNewException(val); yield true;
                case "deadLetterUri": def.setDeadLetterUri(val); yield true;
                default: yield defaultErrorHandlerDefinitionAttributeHandler().accept(def, key, val);
            }, defaultErrorHandlerDefinitionElementHandler(), noValueHandler());
    }
    protected <T extends DefaultErrorHandlerDefinition> AttributeHandler<T> defaultErrorHandlerDefinitionAttributeHandler() {
        return (def, key, val) -> switch (key) {
            case "executorServiceRef": def.setExecutorServiceRef(val); yield true;
            case "level": def.setLevel(val); yield true;
            case "logName": def.setLogName(val); yield true;
            case "loggerRef": def.setLoggerRef(val); yield true;
            case "onExceptionOccurredRef": def.setOnExceptionOccurredRef(val); yield true;
            case "onPrepareFailureRef": def.setOnPrepareFailureRef(val); yield true;
            case "onRedeliveryRef": def.setOnRedeliveryRef(val); yield true;
            case "redeliveryPolicyRef": def.setRedeliveryPolicyRef(val); yield true;
            case "retryWhileRef": def.setRetryWhileRef(val); yield true;
            case "useOriginalBody": def.setUseOriginalBody(val); yield true;
            case "useOriginalMessage": def.setUseOriginalMessage(val); yield true;
            default: yield identifiedTypeAttributeHandler().accept(def, key, val);
        };
    }
    protected <T extends DefaultErrorHandlerDefinition> ElementHandler<T> defaultErrorHandlerDefinitionElementHandler() {
        return (def, key) -> switch (key) {
            case "redeliveryPolicy": def.setRedeliveryPolicy(doParseRedeliveryPolicyDefinition()); yield true;
            default: yield false;
        };
    }
    protected DefaultErrorHandlerDefinition doParseDefaultErrorHandlerDefinition() throws IOException, XmlPullParserException {
        return doParse(new DefaultErrorHandlerDefinition(), defaultErrorHandlerDefinitionAttributeHandler(), defaultErrorHandlerDefinitionElementHandler(), noValueHandler());
    }
    protected JtaTransactionErrorHandlerDefinition doParseJtaTransactionErrorHandlerDefinition() throws IOException, XmlPullParserException {
        return doParse(new JtaTransactionErrorHandlerDefinition(), transactionErrorHandlerDefinitionAttributeHandler(), defaultErrorHandlerDefinitionElementHandler(), noValueHandler());
    }
    protected <T extends TransactionErrorHandlerDefinition> AttributeHandler<T> transactionErrorHandlerDefinitionAttributeHandler() {
        return (def, key, val) -> switch (key) {
            case "rollbackLoggingLevel": def.setRollbackLoggingLevel(val); yield true;
            case "transactedPolicyRef": def.setTransactedPolicyRef(val); yield true;
            default: yield defaultErrorHandlerDefinitionAttributeHandler().accept(def, key, val);
        };
    }
    protected NoErrorHandlerDefinition doParseNoErrorHandlerDefinition() throws IOException, XmlPullParserException {
        return doParse(new NoErrorHandlerDefinition(), identifiedTypeAttributeHandler(), noElementHandler(), noValueHandler());
    }
    protected RefErrorHandlerDefinition doParseRefErrorHandlerDefinition() throws IOException, XmlPullParserException {
        return doParse(new RefErrorHandlerDefinition(), (def, key, val) -> switch (key) {
                case "ref": def.setRef(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected SpringTransactionErrorHandlerDefinition doParseSpringTransactionErrorHandlerDefinition() throws IOException, XmlPullParserException {
        return doParse(new SpringTransactionErrorHandlerDefinition(), transactionErrorHandlerDefinitionAttributeHandler(), defaultErrorHandlerDefinitionElementHandler(), noValueHandler());
    }
    protected CSimpleExpression doParseCSimpleExpression() throws IOException, XmlPullParserException {
        return doParse(new CSimpleExpression(), typedExpressionDefinitionAttributeHandler(), noElementHandler(), expressionDefinitionValueHandler());
    }
    protected <T extends TypedExpressionDefinition> AttributeHandler<T> typedExpressionDefinitionAttributeHandler() {
        return (def, key, val) -> switch (key) {
            case "resultType": def.setResultTypeName(val); yield true;
            default: yield expressionDefinitionAttributeHandler().accept(def, key, val);
        };
    }
    protected ConstantExpression doParseConstantExpression() throws IOException, XmlPullParserException {
        return doParse(new ConstantExpression(), typedExpressionDefinitionAttributeHandler(), noElementHandler(), expressionDefinitionValueHandler());
    }
    protected DatasonnetExpression doParseDatasonnetExpression() throws IOException, XmlPullParserException {
        return doParse(new DatasonnetExpression(), (def, key, val) -> switch (key) {
                case "bodyMediaType": def.setBodyMediaType(val); yield true;
                case "outputMediaType": def.setOutputMediaType(val); yield true;
                default: yield singleInputTypedExpressionDefinitionAttributeHandler().accept(def, key, val);
            }, noElementHandler(), expressionDefinitionValueHandler());
    }
    protected <T extends SingleInputTypedExpressionDefinition> AttributeHandler<T> singleInputTypedExpressionDefinitionAttributeHandler() {
        return (def, key, val) -> switch (key) {
            case "source": def.setSource(val); yield true;
            default: yield typedExpressionDefinitionAttributeHandler().accept(def, key, val);
        };
    }
    protected ExchangePropertyExpression doParseExchangePropertyExpression() throws IOException, XmlPullParserException {
        return doParse(new ExchangePropertyExpression(), expressionDefinitionAttributeHandler(), noElementHandler(), expressionDefinitionValueHandler());
    }
    protected GroovyExpression doParseGroovyExpression() throws IOException, XmlPullParserException {
        return doParse(new GroovyExpression(), typedExpressionDefinitionAttributeHandler(), noElementHandler(), expressionDefinitionValueHandler());
    }
    protected HeaderExpression doParseHeaderExpression() throws IOException, XmlPullParserException {
        return doParse(new HeaderExpression(), expressionDefinitionAttributeHandler(), noElementHandler(), expressionDefinitionValueHandler());
    }
    protected Hl7TerserExpression doParseHl7TerserExpression() throws IOException, XmlPullParserException {
        return doParse(new Hl7TerserExpression(), singleInputTypedExpressionDefinitionAttributeHandler(), noElementHandler(), expressionDefinitionValueHandler());
    }
    protected JavaExpression doParseJavaExpression() throws IOException, XmlPullParserException {
        return doParse(new JavaExpression(), (def, key, val) -> switch (key) {
                case "preCompile": def.setPreCompile(val); yield true;
                case "singleQuotes": def.setSingleQuotes(val); yield true;
                default: yield typedExpressionDefinitionAttributeHandler().accept(def, key, val);
            }, noElementHandler(), expressionDefinitionValueHandler());
    }
    protected JavaScriptExpression doParseJavaScriptExpression() throws IOException, XmlPullParserException {
        return doParse(new JavaScriptExpression(), typedExpressionDefinitionAttributeHandler(), noElementHandler(), expressionDefinitionValueHandler());
    }
    protected JoorExpression doParseJoorExpression() throws IOException, XmlPullParserException {
        return doParse(new JoorExpression(), (def, key, val) -> switch (key) {
                case "preCompile": def.setPreCompile(val); yield true;
                case "singleQuotes": def.setSingleQuotes(val); yield true;
                default: yield typedExpressionDefinitionAttributeHandler().accept(def, key, val);
            }, noElementHandler(), expressionDefinitionValueHandler());
    }
    protected JqExpression doParseJqExpression() throws IOException, XmlPullParserException {
        return doParse(new JqExpression(), singleInputTypedExpressionDefinitionAttributeHandler(), noElementHandler(), expressionDefinitionValueHandler());
    }
    protected JsonPathExpression doParseJsonPathExpression() throws IOException, XmlPullParserException {
        return doParse(new JsonPathExpression(), (def, key, val) -> switch (key) {
                case "allowEasyPredicate": def.setAllowEasyPredicate(val); yield true;
                case "allowSimple": def.setAllowSimple(val); yield true;
                case "option": def.setOption(val); yield true;
                case "suppressExceptions": def.setSuppressExceptions(val); yield true;
                case "unpackArray": def.setUnpackArray(val); yield true;
                case "writeAsString": def.setWriteAsString(val); yield true;
                default: yield singleInputTypedExpressionDefinitionAttributeHandler().accept(def, key, val);
            }, noElementHandler(), expressionDefinitionValueHandler());
    }
    protected LanguageExpression doParseLanguageExpression() throws IOException, XmlPullParserException {
        return doParse(new LanguageExpression(), (def, key, val) -> switch (key) {
                case "language": def.setLanguage(val); yield true;
                default: yield expressionDefinitionAttributeHandler().accept(def, key, val);
            }, noElementHandler(), expressionDefinitionValueHandler());
    }
    protected MethodCallExpression doParseMethodCallExpression() throws IOException, XmlPullParserException {
        return doParse(new MethodCallExpression(), (def, key, val) -> switch (key) {
                case "beanType": def.setBeanTypeName(val); yield true;
                case "method": def.setMethod(val); yield true;
                case "ref": def.setRef(val); yield true;
                case "scope": def.setScope(val); yield true;
                case "validate": def.setValidate(val); yield true;
                default: yield typedExpressionDefinitionAttributeHandler().accept(def, key, val);
            }, noElementHandler(), expressionDefinitionValueHandler());
    }
    protected MvelExpression doParseMvelExpression() throws IOException, XmlPullParserException {
        return doParse(new MvelExpression(), typedExpressionDefinitionAttributeHandler(), noElementHandler(), expressionDefinitionValueHandler());
    }
    protected OgnlExpression doParseOgnlExpression() throws IOException, XmlPullParserException {
        return doParse(new OgnlExpression(), typedExpressionDefinitionAttributeHandler(), noElementHandler(), expressionDefinitionValueHandler());
    }
    protected PythonExpression doParsePythonExpression() throws IOException, XmlPullParserException {
        return doParse(new PythonExpression(), typedExpressionDefinitionAttributeHandler(), noElementHandler(), expressionDefinitionValueHandler());
    }
    protected RefExpression doParseRefExpression() throws IOException, XmlPullParserException {
        return doParse(new RefExpression(), typedExpressionDefinitionAttributeHandler(), noElementHandler(), expressionDefinitionValueHandler());
    }
    protected SimpleExpression doParseSimpleExpression() throws IOException, XmlPullParserException {
        return doParse(new SimpleExpression(), typedExpressionDefinitionAttributeHandler(), noElementHandler(), expressionDefinitionValueHandler());
    }
    protected SpELExpression doParseSpELExpression() throws IOException, XmlPullParserException {
        return doParse(new SpELExpression(), typedExpressionDefinitionAttributeHandler(), noElementHandler(), expressionDefinitionValueHandler());
    }
    protected TokenizerExpression doParseTokenizerExpression() throws IOException, XmlPullParserException {
        return doParse(new TokenizerExpression(), (def, key, val) -> switch (key) {
                case "endToken": def.setEndToken(val); yield true;
                case "group": def.setGroup(val); yield true;
                case "groupDelimiter": def.setGroupDelimiter(val); yield true;
                case "includeTokens": def.setIncludeTokens(val); yield true;
                case "inheritNamespaceTagName": def.setInheritNamespaceTagName(val); yield true;
                case "regex": def.setRegex(val); yield true;
                case "skipFirst": def.setSkipFirst(val); yield true;
                case "token": def.setToken(val); yield true;
                case "xml": def.setXml(val); yield true;
                default: yield singleInputTypedExpressionDefinitionAttributeHandler().accept(def, key, val);
            }, noElementHandler(), expressionDefinitionValueHandler());
    }
    protected VariableExpression doParseVariableExpression() throws IOException, XmlPullParserException {
        return doParse(new VariableExpression(), expressionDefinitionAttributeHandler(), noElementHandler(), expressionDefinitionValueHandler());
    }
    protected WasmExpression doParseWasmExpression() throws IOException, XmlPullParserException {
        return doParse(new WasmExpression(), (def, key, val) -> switch (key) {
                case "module": def.setModule(val); yield true;
                default: yield typedExpressionDefinitionAttributeHandler().accept(def, key, val);
            }, noElementHandler(), expressionDefinitionValueHandler());
    }
    protected XMLTokenizerExpression doParseXMLTokenizerExpression() throws IOException, XmlPullParserException {
        return doParse(new XMLTokenizerExpression(), (def, key, val) -> switch (key) {
                case "group": def.setGroup(val); yield true;
                case "mode": def.setMode(val); yield true;
                default: yield singleInputTypedExpressionDefinitionAttributeHandler().accept(def, key, val);
            }, namespaceAwareExpressionElementHandler(), expressionDefinitionValueHandler());
    }
    protected <T extends NamespaceAwareExpression> ElementHandler<T> namespaceAwareExpressionElementHandler() {
        return (def, key) -> switch (key) {
            case "namespace": doAdd(doParsePropertyDefinition(), def.getNamespace(), def::setNamespace); yield true;
            default: yield false;
        };
    }
    protected XPathExpression doParseXPathExpression() throws IOException, XmlPullParserException {
        return doParse(new XPathExpression(), (def, key, val) -> switch (key) {
                case "documentType": def.setDocumentTypeName(val); yield true;
                case "factoryRef": def.setFactoryRef(val); yield true;
                case "logNamespaces": def.setLogNamespaces(val); yield true;
                case "objectModel": def.setObjectModel(val); yield true;
                case "preCompile": def.setPreCompile(val); yield true;
                case "resultQName": def.setResultQName(val); yield true;
                case "saxon": def.setSaxon(val); yield true;
                case "threadSafety": def.setThreadSafety(val); yield true;
                default: yield singleInputTypedExpressionDefinitionAttributeHandler().accept(def, key, val);
            }, namespaceAwareExpressionElementHandler(), expressionDefinitionValueHandler());
    }
    protected XQueryExpression doParseXQueryExpression() throws IOException, XmlPullParserException {
        return doParse(new XQueryExpression(), (def, key, val) -> switch (key) {
                case "configurationRef": def.setConfigurationRef(val); yield true;
                default: yield singleInputTypedExpressionDefinitionAttributeHandler().accept(def, key, val);
            }, namespaceAwareExpressionElementHandler(), expressionDefinitionValueHandler());
    }
    protected CustomLoadBalancerDefinition doParseCustomLoadBalancerDefinition() throws IOException, XmlPullParserException {
        return doParse(new CustomLoadBalancerDefinition(), (def, key, val) -> switch (key) {
                case "ref": def.setRef(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected FailoverLoadBalancerDefinition doParseFailoverLoadBalancerDefinition() throws IOException, XmlPullParserException {
        return doParse(new FailoverLoadBalancerDefinition(), (def, key, val) -> switch (key) {
                case "maximumFailoverAttempts": def.setMaximumFailoverAttempts(val); yield true;
                case "roundRobin": def.setRoundRobin(val); yield true;
                case "sticky": def.setSticky(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, (def, key) -> switch (key) {
                case "exception": doAdd(doParseText(), def.getExceptions(), def::setExceptions); yield true;
                default: yield false;
            }, noValueHandler());
    }
    protected RandomLoadBalancerDefinition doParseRandomLoadBalancerDefinition() throws IOException, XmlPullParserException {
        return doParse(new RandomLoadBalancerDefinition(), identifiedTypeAttributeHandler(), noElementHandler(), noValueHandler());
    }
    protected RoundRobinLoadBalancerDefinition doParseRoundRobinLoadBalancerDefinition() throws IOException, XmlPullParserException {
        return doParse(new RoundRobinLoadBalancerDefinition(), identifiedTypeAttributeHandler(), noElementHandler(), noValueHandler());
    }
    protected StickyLoadBalancerDefinition doParseStickyLoadBalancerDefinition() throws IOException, XmlPullParserException {
        return doParse(new StickyLoadBalancerDefinition(), identifiedTypeAttributeHandler(), (def, key) -> switch (key) {
                case "correlationExpression": def.setCorrelationExpression(doParseExpressionSubElementDefinition()); yield true;
                default: yield false;
            }, noValueHandler());
    }
    protected TopicLoadBalancerDefinition doParseTopicLoadBalancerDefinition() throws IOException, XmlPullParserException {
        return doParse(new TopicLoadBalancerDefinition(), identifiedTypeAttributeHandler(), noElementHandler(), noValueHandler());
    }
    protected WeightedLoadBalancerDefinition doParseWeightedLoadBalancerDefinition() throws IOException, XmlPullParserException {
        return doParse(new WeightedLoadBalancerDefinition(), (def, key, val) -> switch (key) {
                case "distributionRatio": def.setDistributionRatio(val); yield true;
                case "distributionRatioDelimiter": def.setDistributionRatioDelimiter(val); yield true;
                case "roundRobin": def.setRoundRobin(val); yield true;
                default: yield identifiedTypeAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected ApiKeyDefinition doParseApiKeyDefinition() throws IOException, XmlPullParserException {
        return doParse(new ApiKeyDefinition(), (def, key, val) -> switch (key) {
                case "inCookie": def.setInCookie(val); yield true;
                case "inHeader": def.setInHeader(val); yield true;
                case "inQuery": def.setInQuery(val); yield true;
                case "name": def.setName(val); yield true;
                default: yield restSecurityDefinitionAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected <T extends RestSecurityDefinition> AttributeHandler<T> restSecurityDefinitionAttributeHandler() {
        return (def, key, val) -> switch (key) {
            case "description": def.setDescription(val); yield true;
            case "key": def.setKey(val); yield true;
            default: yield false;
        };
    }
    protected BasicAuthDefinition doParseBasicAuthDefinition() throws IOException, XmlPullParserException {
        return doParse(new BasicAuthDefinition(), restSecurityDefinitionAttributeHandler(), noElementHandler(), noValueHandler());
    }
    protected BearerTokenDefinition doParseBearerTokenDefinition() throws IOException, XmlPullParserException {
        return doParse(new BearerTokenDefinition(), (def, key, val) -> switch (key) {
                case "format": def.setFormat(val); yield true;
                default: yield restSecurityDefinitionAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected DeleteDefinition doParseDeleteDefinition() throws IOException, XmlPullParserException {
        return doParse(new DeleteDefinition(), verbDefinitionAttributeHandler(), verbDefinitionElementHandler(), noValueHandler());
    }
    protected <T extends VerbDefinition> AttributeHandler<T> verbDefinitionAttributeHandler() {
        return (def, key, val) -> switch (key) {
            case "apiDocs": def.setApiDocs(val); yield true;
            case "bindingMode": def.setBindingMode(val); yield true;
            case "clientRequestValidation": def.setClientRequestValidation(val); yield true;
            case "consumes": def.setConsumes(val); yield true;
            case "deprecated": def.setDeprecated(val); yield true;
            case "disabled": def.setDisabled(val); yield true;
            case "enableCORS": def.setEnableCORS(val); yield true;
            case "enableNoContentResponse": def.setEnableNoContentResponse(val); yield true;
            case "outType": def.setOutType(val); yield true;
            case "path": def.setPath(val); yield true;
            case "produces": def.setProduces(val); yield true;
            case "routeId": def.setRouteId(val); yield true;
            case "skipBindingOnErrorCode": def.setSkipBindingOnErrorCode(val); yield true;
            case "type": def.setType(val); yield true;
            default: yield optionalIdentifiedDefinitionAttributeHandler().accept(def, key, val);
        };
    }
    protected <T extends VerbDefinition> ElementHandler<T> verbDefinitionElementHandler() {
        return (def, key) -> switch (key) {
            case "param": doAdd(doParseParamDefinition(), def.getParams(), def::setParams); yield true;
            case "responseMessage": doAdd(doParseResponseMessageDefinition(), def.getResponseMsgs(), def::setResponseMsgs); yield true;
            case "security": doAdd(doParseSecurityDefinition(), def.getSecurity(), def::setSecurity); yield true;
            case "to": def.setTo(doParseToDefinition()); yield true;
            default: yield optionalIdentifiedDefinitionElementHandler().accept(def, key);
        };
    }
    protected ParamDefinition doParseParamDefinition() throws IOException, XmlPullParserException {
        return doParse(new ParamDefinition(), (def, key, val) -> switch (key) {
                case "arrayType": def.setArrayType(val); yield true;
                case "collectionFormat": def.setCollectionFormat(CollectionFormat.valueOf(val)); yield true;
                case "dataFormat": def.setDataFormat(val); yield true;
                case "dataType": def.setDataType(val); yield true;
                case "defaultValue": def.setDefaultValue(val); yield true;
                case "description": def.setDescription(val); yield true;
                case "name": def.setName(val); yield true;
                case "required": def.setRequired(Boolean.valueOf(val)); yield true;
                case "type": def.setType(RestParamType.valueOf(val)); yield true;
                default: yield false;
            }, (def, key) -> switch (key) {
                case "allowableValues": doAddValues(doParseValueDefinition(), def.getAllowableValues(), def::setAllowableValues); yield true;
                case "examples": doAdd(doParseRestPropertyDefinition(), def.getExamples(), def::setExamples); yield true;
                default: yield false;
            }, noValueHandler());
    }
    protected ResponseMessageDefinition doParseResponseMessageDefinition() throws IOException, XmlPullParserException {
        return doParse(new ResponseMessageDefinition(), (def, key, val) -> switch (key) {
                case "code": def.setCode(val); yield true;
                case "message": def.setMessage(val); yield true;
                case "responseModel": def.setResponseModel(val); yield true;
                default: yield false;
            }, (def, key) -> switch (key) {
                case "examples": doAdd(doParseRestPropertyDefinition(), def.getExamples(), def::setExamples); yield true;
                case "header": doAdd(doParseResponseHeaderDefinition(), def.getHeaders(), def::setHeaders); yield true;
                default: yield false;
            }, noValueHandler());
    }
    protected SecurityDefinition doParseSecurityDefinition() throws IOException, XmlPullParserException {
        return doParse(new SecurityDefinition(), (def, key, val) -> switch (key) {
                case "key": def.setKey(val); yield true;
                case "scopes": def.setScopes(val); yield true;
                default: yield false;
            }, noElementHandler(), noValueHandler());
    }
    protected GetDefinition doParseGetDefinition() throws IOException, XmlPullParserException {
        return doParse(new GetDefinition(), verbDefinitionAttributeHandler(), verbDefinitionElementHandler(), noValueHandler());
    }
    protected HeadDefinition doParseHeadDefinition() throws IOException, XmlPullParserException {
        return doParse(new HeadDefinition(), verbDefinitionAttributeHandler(), verbDefinitionElementHandler(), noValueHandler());
    }
    protected MutualTLSDefinition doParseMutualTLSDefinition() throws IOException, XmlPullParserException {
        return doParse(new MutualTLSDefinition(), restSecurityDefinitionAttributeHandler(), noElementHandler(), noValueHandler());
    }
    protected OAuth2Definition doParseOAuth2Definition() throws IOException, XmlPullParserException {
        return doParse(new OAuth2Definition(), (def, key, val) -> switch (key) {
                case "authorizationUrl": def.setAuthorizationUrl(val); yield true;
                case "flow": def.setFlow(val); yield true;
                case "refreshUrl": def.setRefreshUrl(val); yield true;
                case "tokenUrl": def.setTokenUrl(val); yield true;
                default: yield restSecurityDefinitionAttributeHandler().accept(def, key, val);
            }, (def, key) -> switch (key) {
                case "scopes": doAdd(doParseRestPropertyDefinition(), def.getScopes(), def::setScopes); yield true;
                default: yield false;
            }, noValueHandler());
    }
    protected RestPropertyDefinition doParseRestPropertyDefinition() throws IOException, XmlPullParserException {
        return doParse(new RestPropertyDefinition(), (def, key, val) -> switch (key) {
                case "key": def.setKey(val); yield true;
                case "value": def.setValue(val); yield true;
                default: yield false;
            }, noElementHandler(), noValueHandler());
    }
    protected OpenApiDefinition doParseOpenApiDefinition() throws IOException, XmlPullParserException {
        return doParse(new OpenApiDefinition(), (def, key, val) -> switch (key) {
                case "disabled": def.setDisabled(val); yield true;
                case "missingOperation": def.setMissingOperation(val); yield true;
                case "mockIncludePattern": def.setMockIncludePattern(val); yield true;
                case "routeId": def.setRouteId(val); yield true;
                case "specification": def.setSpecification(val); yield true;
                default: yield optionalIdentifiedDefinitionAttributeHandler().accept(def, key, val);
            }, (def, key) -> switch (key) {
                case "apiContextPath": def.setApiContextPath(doParseText()); yield true;
                default: yield optionalIdentifiedDefinitionElementHandler().accept(def, key);
            }, noValueHandler());
    }
    protected OpenIdConnectDefinition doParseOpenIdConnectDefinition() throws IOException, XmlPullParserException {
        return doParse(new OpenIdConnectDefinition(), (def, key, val) -> switch (key) {
                case "url": def.setUrl(val); yield true;
                default: yield restSecurityDefinitionAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected PatchDefinition doParsePatchDefinition() throws IOException, XmlPullParserException {
        return doParse(new PatchDefinition(), verbDefinitionAttributeHandler(), verbDefinitionElementHandler(), noValueHandler());
    }
    protected PostDefinition doParsePostDefinition() throws IOException, XmlPullParserException {
        return doParse(new PostDefinition(), verbDefinitionAttributeHandler(), verbDefinitionElementHandler(), noValueHandler());
    }
    protected PutDefinition doParsePutDefinition() throws IOException, XmlPullParserException {
        return doParse(new PutDefinition(), verbDefinitionAttributeHandler(), verbDefinitionElementHandler(), noValueHandler());
    }
    protected ResponseHeaderDefinition doParseResponseHeaderDefinition() throws IOException, XmlPullParserException {
        return doParse(new ResponseHeaderDefinition(), (def, key, val) -> switch (key) {
                case "arrayType": def.setArrayType(val); yield true;
                case "collectionFormat": def.setCollectionFormat(CollectionFormat.valueOf(val)); yield true;
                case "dataFormat": def.setDataFormat(val); yield true;
                case "dataType": def.setDataType(val); yield true;
                case "description": def.setDescription(val); yield true;
                case "example": def.setExample(val); yield true;
                case "name": def.setName(val); yield true;
                default: yield false;
            }, (def, key) -> switch (key) {
                case "allowableValues": doAddValues(doParseValueDefinition(), def.getAllowableValues(), def::setAllowableValues); yield true;
                default: yield false;
            }, noValueHandler());
    }
    protected RestSecuritiesDefinition doParseRestSecuritiesDefinition() throws IOException, XmlPullParserException {
        return doParse(new RestSecuritiesDefinition(), noAttributeHandler(), (def, key) -> switch (key) {
                case "apiKey": doAdd(doParseApiKeyDefinition(), def.getSecurityDefinitions(), def::setSecurityDefinitions); yield true;
                case "basicAuth": doAdd(doParseBasicAuthDefinition(), def.getSecurityDefinitions(), def::setSecurityDefinitions); yield true;
                case "bearer": doAdd(doParseBearerTokenDefinition(), def.getSecurityDefinitions(), def::setSecurityDefinitions); yield true;
                case "oauth2": doAdd(doParseOAuth2Definition(), def.getSecurityDefinitions(), def::setSecurityDefinitions); yield true;
                case "openIdConnect": doAdd(doParseOpenIdConnectDefinition(), def.getSecurityDefinitions(), def::setSecurityDefinitions); yield true;
                case "mutualTLS": doAdd(doParseMutualTLSDefinition(), def.getSecurityDefinitions(), def::setSecurityDefinitions); yield true;
                default: yield false;
            }, noValueHandler());
    }
    protected RestsDefinition doParseRestsDefinition() throws IOException, XmlPullParserException {
        return doParse(new RestsDefinition(), optionalIdentifiedDefinitionAttributeHandler(), (def, key) -> switch (key) {
                case "rest": doAdd(doParseRestDefinition(), def.getRests(), def::setRests); yield true;
                default: yield optionalIdentifiedDefinitionElementHandler().accept(def, key);
            }, noValueHandler());
    }
    public Optional<RestsDefinition> parseRestsDefinition() throws IOException, XmlPullParserException {
        String tag = getNextTag("rests", "rest");
        if (tag != null) {
            switch (tag) {
                case "rests" : return Optional.of(doParseRestsDefinition());
                case "rest" : return parseSingleRestsDefinition();
            }
        }
        return Optional.empty();
    }
    private Optional<RestsDefinition> parseSingleRestsDefinition() throws IOException, XmlPullParserException {
        Optional<RestDefinition> single = Optional.of(doParseRestDefinition());
        if (single.isPresent()) {
            List<RestDefinition> list = new ArrayList<>();
            list.add(single.get());
            RestsDefinition def = new RestsDefinition();
            def.setRests(list);
            return Optional.of(def);
        }
        return Optional.empty();
    }
    protected CustomTransformerDefinition doParseCustomTransformerDefinition() throws IOException, XmlPullParserException {
        return doParse(new CustomTransformerDefinition(), (def, key, val) -> switch (key) {
                case "className": def.setClassName(val); yield true;
                case "ref": def.setRef(val); yield true;
                default: yield transformerDefinitionAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected <T extends TransformerDefinition> AttributeHandler<T> transformerDefinitionAttributeHandler() {
        return (def, key, val) -> switch (key) {
            case "fromType": def.setFromType(val); yield true;
            case "name": def.setName(val); yield true;
            case "scheme": def.setScheme(val); yield true;
            case "toType": def.setToType(val); yield true;
            default: yield false;
        };
    }
    protected DataFormatTransformerDefinition doParseDataFormatTransformerDefinition() throws IOException, XmlPullParserException {
        return doParse(new DataFormatTransformerDefinition(), transformerDefinitionAttributeHandler(), (def, key) -> {
                DataFormatDefinition v = doParseDataFormatDefinitionRef(key);
                if (v != null) {
                    def.setDataFormatType(v);
                    return true;
                }
                return false;
            }, noValueHandler());
    }
    protected EndpointTransformerDefinition doParseEndpointTransformerDefinition() throws IOException, XmlPullParserException {
        return doParse(new EndpointTransformerDefinition(), (def, key, val) -> switch (key) {
                case "ref": def.setRef(val); yield true;
                case "uri": def.setUri(sanitizeUri(val)); yield true;
                default: yield transformerDefinitionAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected LoadTransformerDefinition doParseLoadTransformerDefinition() throws IOException, XmlPullParserException {
        return doParse(new LoadTransformerDefinition(), (def, key, val) -> switch (key) {
                case "defaults": def.setDefaults(val); yield true;
                case "packageScan": def.setPackageScan(val); yield true;
                default: yield transformerDefinitionAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected TransformersDefinition doParseTransformersDefinition() throws IOException, XmlPullParserException {
        return doParse(new TransformersDefinition(), noAttributeHandler(), (def, key) -> switch (key) {
                case "dataFormatTransformer": doAdd(doParseDataFormatTransformerDefinition(), def.getTransformers(), def::setTransformers); yield true;
                case "endpointTransformer": doAdd(doParseEndpointTransformerDefinition(), def.getTransformers(), def::setTransformers); yield true;
                case "loadTransformer": doAdd(doParseLoadTransformerDefinition(), def.getTransformers(), def::setTransformers); yield true;
                case "customTransformer": doAdd(doParseCustomTransformerDefinition(), def.getTransformers(), def::setTransformers); yield true;
                default: yield false;
            }, noValueHandler());
    }
    protected CustomValidatorDefinition doParseCustomValidatorDefinition() throws IOException, XmlPullParserException {
        return doParse(new CustomValidatorDefinition(), (def, key, val) -> switch (key) {
                case "className": def.setClassName(val); yield true;
                case "ref": def.setRef(val); yield true;
                default: yield validatorDefinitionAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected <T extends ValidatorDefinition> AttributeHandler<T> validatorDefinitionAttributeHandler() {
        return (def, key, val) -> switch (key) {
            case "type": def.setType(val); yield true;
            default: yield false;
        };
    }
    protected EndpointValidatorDefinition doParseEndpointValidatorDefinition() throws IOException, XmlPullParserException {
        return doParse(new EndpointValidatorDefinition(), (def, key, val) -> switch (key) {
                case "ref": def.setRef(val); yield true;
                case "uri": def.setUri(sanitizeUri(val)); yield true;
                default: yield validatorDefinitionAttributeHandler().accept(def, key, val);
            }, noElementHandler(), noValueHandler());
    }
    protected PredicateValidatorDefinition doParsePredicateValidatorDefinition() throws IOException, XmlPullParserException {
        return doParse(new PredicateValidatorDefinition(), validatorDefinitionAttributeHandler(), (def, key) -> {
                ExpressionDefinition v = doParseExpressionDefinitionRef(key);
                if (v != null) {
                    def.setExpression(v);
                    return true;
                }
                return false;
            }, noValueHandler());
    }
    protected ValidatorsDefinition doParseValidatorsDefinition() throws IOException, XmlPullParserException {
        return doParse(new ValidatorsDefinition(), noAttributeHandler(), (def, key) -> switch (key) {
                case "endpointValidator": doAdd(doParseEndpointValidatorDefinition(), def.getValidators(), def::setValidators); yield true;
                case "predicateValidator": doAdd(doParsePredicateValidatorDefinition(), def.getValidators(), def::setValidators); yield true;
                case "customValidator": doAdd(doParseCustomValidatorDefinition(), def.getValidators(), def::setValidators); yield true;
                default: yield false;
            }, noValueHandler());
    }
    protected ProcessorDefinition doParseProcessorDefinitionRef(String key) throws IOException, XmlPullParserException {
        switch (key) {
            case "aggregate": return doParseAggregateDefinition();
            case "bean": return doParseBeanDefinition();
            case "doCatch": return doParseCatchDefinition();
            case "when": return doParseWhenDefinition();
            case "choice": return doParseChoiceDefinition();
            case "otherwise": return doParseOtherwiseDefinition();
            case "circuitBreaker": return doParseCircuitBreakerDefinition();
            case "onFallback": return doParseOnFallbackDefinition();
            case "claimCheck": return doParseClaimCheckDefinition();
            case "convertBodyTo": return doParseConvertBodyDefinition();
            case "convertHeaderTo": return doParseConvertHeaderDefinition();
            case "convertVariableTo": return doParseConvertVariableDefinition();
            case "delay": return doParseDelayDefinition();
            case "dynamicRouter": return doParseDynamicRouterDefinition();
            case "enrich": return doParseEnrichDefinition();
            case "filter": return doParseFilterDefinition();
            case "doFinally": return doParseFinallyDefinition();
            case "idempotentConsumer": return doParseIdempotentConsumerDefinition();
            case "intercept": return doParseInterceptDefinition();
            case "interceptFrom": return doParseInterceptFromDefinition();
            case "interceptSendToEndpoint": return doParseInterceptSendToEndpointDefinition();
            case "kamelet": return doParseKameletDefinition();
            case "loadBalance": return doParseLoadBalanceDefinition();
            case "log": return doParseLogDefinition();
            case "loop": return doParseLoopDefinition();
            case "marshal": return doParseMarshalDefinition();
            case "multicast": return doParseMulticastDefinition();
            case "onCompletion": return doParseOnCompletionDefinition();
            case "onException": return doParseOnExceptionDefinition();
            case "pausable": return doParsePausableDefinition();
            case "pipeline": return doParsePipelineDefinition();
            case "policy": return doParsePolicyDefinition();
            case "pollEnrich": return doParsePollEnrichDefinition();
            case "process": return doParseProcessDefinition();
            case "recipientList": return doParseRecipientListDefinition();
            case "removeHeader": return doParseRemoveHeaderDefinition();
            case "removeHeaders": return doParseRemoveHeadersDefinition();
            case "removeProperties": return doParseRemovePropertiesDefinition();
            case "removeProperty": return doParseRemovePropertyDefinition();
            case "removeVariable": return doParseRemoveVariableDefinition();
            case "resequence": return doParseResequenceDefinition();
            case "resumable": return doParseResumableDefinition();
            case "rollback": return doParseRollbackDefinition();
            case "route": return doParseRouteDefinition();
            case "routingSlip": return doParseRoutingSlipDefinition();
            case "saga": return doParseSagaDefinition();
            case "sample": return doParseSamplingDefinition();
            case "script": return doParseScriptDefinition();
            case "setBody": return doParseSetBodyDefinition();
            case "setExchangePattern": return doParseSetExchangePatternDefinition();
            case "setHeader": return doParseSetHeaderDefinition();
            case "setHeaders": return doParseSetHeadersDefinition();
            case "setProperty": return doParseSetPropertyDefinition();
            case "setVariable": return doParseSetVariableDefinition();
            case "setVariables": return doParseSetVariablesDefinition();
            case "sort": return doParseSortDefinition();
            case "split": return doParseSplitDefinition();
            case "step": return doParseStepDefinition();
            case "stop": return doParseStopDefinition();
            case "threads": return doParseThreadsDefinition();
            case "throttle": return doParseThrottleDefinition();
            case "throwException": return doParseThrowExceptionDefinition();
            case "to": return doParseToDefinition();
            case "toD": return doParseToDynamicDefinition();
            case "transacted": return doParseTransactedDefinition();
            case "transform": return doParseTransformDefinition();
            case "doTry": return doParseTryDefinition();
            case "unmarshal": return doParseUnmarshalDefinition();
            case "validate": return doParseValidateDefinition();
            case "wireTap": return doParseWireTapDefinition();
            case "serviceCall": return doParseServiceCallDefinition();
            default: return null;
        }
    }
    protected DataFormatDefinition doParseDataFormatDefinitionRef(String key) throws IOException, XmlPullParserException {
        switch (key) {
            case "asn1": return doParseASN1DataFormat();
            case "avro": return doParseAvroDataFormat();
            case "barcode": return doParseBarcodeDataFormat();
            case "base64": return doParseBase64DataFormat();
            case "beanio": return doParseBeanioDataFormat();
            case "bindy": return doParseBindyDataFormat();
            case "cbor": return doParseCBORDataFormat();
            case "crypto": return doParseCryptoDataFormat();
            case "csv": return doParseCsvDataFormat();
            case "custom": return doParseCustomDataFormat();
            case "fhirJson": return doParseFhirJsonDataFormat();
            case "fhirXml": return doParseFhirXmlDataFormat();
            case "flatpack": return doParseFlatpackDataFormat();
            case "grok": return doParseGrokDataFormat();
            case "gzipDeflater": return doParseGzipDeflaterDataFormat();
            case "hl7": return doParseHL7DataFormat();
            case "ical": return doParseIcalDataFormat();
            case "jacksonXml": return doParseJacksonXMLDataFormat();
            case "jaxb": return doParseJaxbDataFormat();
            case "jsonApi": return doParseJsonApiDataFormat();
            case "json": return doParseJsonDataFormat();
            case "lzf": return doParseLZFDataFormat();
            case "mimeMultipart": return doParseMimeMultipartDataFormat();
            case "pgp": return doParsePGPDataFormat();
            case "parquetAvro": return doParseParquetAvroDataFormat();
            case "protobuf": return doParseProtobufDataFormat();
            case "rss": return doParseRssDataFormat();
            case "soap": return doParseSoapDataFormat();
            case "swiftMt": return doParseSwiftMtDataFormat();
            case "swiftMx": return doParseSwiftMxDataFormat();
            case "syslog": return doParseSyslogDataFormat();
            case "tarFile": return doParseTarFileDataFormat();
            case "thrift": return doParseThriftDataFormat();
            case "tidyMarkup": return doParseTidyMarkupDataFormat();
            case "univocityCsv": return doParseUniVocityCsvDataFormat();
            case "univocityFixed": return doParseUniVocityFixedDataFormat();
            case "univocityTsv": return doParseUniVocityTsvDataFormat();
            case "xmlSecurity": return doParseXMLSecurityDataFormat();
            case "yaml": return doParseYAMLDataFormat();
            case "zipDeflater": return doParseZipDeflaterDataFormat();
            case "zipFile": return doParseZipFileDataFormat();
            default: return null;
        }
    }
    protected ExpressionDefinition doParseExpressionDefinitionRef(String key) throws IOException, XmlPullParserException {
        switch (key) {
            case "expressionDefinition": return doParseExpressionDefinition();
            case "csimple": return doParseCSimpleExpression();
            case "constant": return doParseConstantExpression();
            case "datasonnet": return doParseDatasonnetExpression();
            case "exchangeProperty": return doParseExchangePropertyExpression();
            case "groovy": return doParseGroovyExpression();
            case "header": return doParseHeaderExpression();
            case "hl7terser": return doParseHl7TerserExpression();
            case "java": return doParseJavaExpression();
            case "js": return doParseJavaScriptExpression();
            case "joor": return doParseJoorExpression();
            case "jq": return doParseJqExpression();
            case "jsonpath": return doParseJsonPathExpression();
            case "language": return doParseLanguageExpression();
            case "method": return doParseMethodCallExpression();
            case "mvel": return doParseMvelExpression();
            case "ognl": return doParseOgnlExpression();
            case "python": return doParsePythonExpression();
            case "ref": return doParseRefExpression();
            case "simple": return doParseSimpleExpression();
            case "spel": return doParseSpELExpression();
            case "tokenize": return doParseTokenizerExpression();
            case "variable": return doParseVariableExpression();
            case "wasm": return doParseWasmExpression();
            case "xtokenize": return doParseXMLTokenizerExpression();
            case "xpath": return doParseXPathExpression();
            case "xquery": return doParseXQueryExpression();
            default: return null;
        }
    }
}