/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Invoke Wasm functions.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface WasmEndpointBuilderFactory {


    /**
     * Builder for endpoint for the Wasm component.
     */
    public interface WasmEndpointBuilder extends EndpointProducerBuilder {
        default AdvancedWasmEndpointBuilder advanced() {
            return (AdvancedWasmEndpointBuilder) this;
        }
        /**
         * Set the module (the distributable, loadable, and executable unit of
         * code in WebAssembly) resource that provides the producer function.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: producer
         * 
         * @param module the value to set
         * @return the dsl builder
         */
        default WasmEndpointBuilder module(String module) {
            doSetProperty("module", module);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Wasm component.
     */
    public interface AdvancedWasmEndpointBuilder
            extends
                EndpointProducerBuilder {
        default WasmEndpointBuilder basic() {
            return (WasmEndpointBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedWasmEndpointBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedWasmEndpointBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    public interface WasmBuilders {
        /**
         * Wasm (camel-wasm)
         * Invoke Wasm functions.
         * 
         * Category: core,script
         * Since: 4.4
         * Maven coordinates: org.apache.camel:camel-wasm
         * 
         * Syntax: <code>wasm:functionName</code>
         * 
         * Path parameter: functionName (required)
         * The Function Name
         * 
         * @param path functionName
         * @return the dsl builder
         */
        default WasmEndpointBuilder wasm(String path) {
            return WasmEndpointBuilderFactory.endpointBuilder("wasm", path);
        }
        /**
         * Wasm (camel-wasm)
         * Invoke Wasm functions.
         * 
         * Category: core,script
         * Since: 4.4
         * Maven coordinates: org.apache.camel:camel-wasm
         * 
         * Syntax: <code>wasm:functionName</code>
         * 
         * Path parameter: functionName (required)
         * The Function Name
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path functionName
         * @return the dsl builder
         */
        default WasmEndpointBuilder wasm(String componentName, String path) {
            return WasmEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static WasmEndpointBuilder endpointBuilder(String componentName, String path) {
        class WasmEndpointBuilderImpl extends AbstractEndpointBuilder implements WasmEndpointBuilder, AdvancedWasmEndpointBuilder {
            public WasmEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new WasmEndpointBuilderImpl(path);
    }
}