/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Messaging with AMQP protocol using Apache QPid Client.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface AMQPEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the AMQP component.
     */
    public interface AMQPEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedAMQPEndpointConsumerBuilder advanced() {
            return (AdvancedAMQPEndpointConsumerBuilder) this;
        }
        /**
         * Sets the JMS client ID to use. Note that this value, if specified,
         * must be unique and can only be used by a single JMS connection
         * instance. It is typically only required for durable topic
         * subscriptions with JMS 1.1.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param clientId the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder clientId(String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
        /**
         * The connection factory to be use. A connection factory must be
         * configured either on the component or endpoint.
         * 
         * The option is a:
         * &lt;code&gt;jakarta.jms.ConnectionFactory&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param connectionFactory the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder connectionFactory(
                jakarta.jms.ConnectionFactory connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * The connection factory to be use. A connection factory must be
         * configured either on the component or endpoint.
         * 
         * The option will be converted to a
         * &lt;code&gt;jakarta.jms.ConnectionFactory&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param connectionFactory the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder connectionFactory(
                String connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * Specifies whether Camel ignores the JMSReplyTo header in messages. If
         * true, Camel does not send a reply back to the destination specified
         * in the JMSReplyTo header. You can use this option if you want Camel
         * to consume from a route and you do not want Camel to automatically
         * send back a reply message because another component in your code
         * handles the reply message. You can also use this option if you want
         * to use Camel as a proxy between different message brokers and you
         * want to route message from one system to another.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disableReplyTo the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder disableReplyTo(
                boolean disableReplyTo) {
            doSetProperty("disableReplyTo", disableReplyTo);
            return this;
        }
        /**
         * Specifies whether Camel ignores the JMSReplyTo header in messages. If
         * true, Camel does not send a reply back to the destination specified
         * in the JMSReplyTo header. You can use this option if you want Camel
         * to consume from a route and you do not want Camel to automatically
         * send back a reply message because another component in your code
         * handles the reply message. You can also use this option if you want
         * to use Camel as a proxy between different message brokers and you
         * want to route message from one system to another.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disableReplyTo the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder disableReplyTo(String disableReplyTo) {
            doSetProperty("disableReplyTo", disableReplyTo);
            return this;
        }
        /**
         * The durable subscriber name for specifying durable topic
         * subscriptions. The clientId option must be configured as well.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param durableSubscriptionName the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder durableSubscriptionName(
                String durableSubscriptionName) {
            doSetProperty("durableSubscriptionName", durableSubscriptionName);
            return this;
        }
        /**
         * Allows you to force the use of a specific jakarta.jms.Message
         * implementation for sending JMS messages. Possible values are: Bytes,
         * Map, Object, Stream, Text. By default, Camel would determine which
         * JMS message type to use from the In body type. This option allows you
         * to specify it.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.jms.JmsMessageType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param jmsMessageType the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder jmsMessageType(
                org.apache.camel.component.jms.JmsMessageType jmsMessageType) {
            doSetProperty("jmsMessageType", jmsMessageType);
            return this;
        }
        /**
         * Allows you to force the use of a specific jakarta.jms.Message
         * implementation for sending JMS messages. Possible values are: Bytes,
         * Map, Object, Stream, Text. By default, Camel would determine which
         * JMS message type to use from the In body type. This option allows you
         * to specify it.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.jms.JmsMessageType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param jmsMessageType the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder jmsMessageType(String jmsMessageType) {
            doSetProperty("jmsMessageType", jmsMessageType);
            return this;
        }
        /**
         * Provides an explicit ReplyTo destination (overrides any incoming
         * value of Message.getJMSReplyTo() in consumer).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param replyTo the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder replyTo(String replyTo) {
            doSetProperty("replyTo", replyTo);
            return this;
        }
        /**
         * Specifies whether to test the connection on startup. This ensures
         * that when Camel starts that all the JMS consumers have a valid
         * connection to the JMS broker. If a connection cannot be granted then
         * Camel throws an exception on startup. This ensures that Camel is not
         * started with failed connections. The JMS producers is tested as well.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param testConnectionOnStartup the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder testConnectionOnStartup(
                boolean testConnectionOnStartup) {
            doSetProperty("testConnectionOnStartup", testConnectionOnStartup);
            return this;
        }
        /**
         * Specifies whether to test the connection on startup. This ensures
         * that when Camel starts that all the JMS consumers have a valid
         * connection to the JMS broker. If a connection cannot be granted then
         * Camel throws an exception on startup. This ensures that Camel is not
         * started with failed connections. The JMS producers is tested as well.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param testConnectionOnStartup the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder testConnectionOnStartup(
                String testConnectionOnStartup) {
            doSetProperty("testConnectionOnStartup", testConnectionOnStartup);
            return this;
        }
        /**
         * The JMS acknowledgement name, which is one of: SESSION_TRANSACTED,
         * CLIENT_ACKNOWLEDGE, AUTO_ACKNOWLEDGE, DUPS_OK_ACKNOWLEDGE.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: AUTO_ACKNOWLEDGE
         * Group: consumer
         * 
         * @param acknowledgementModeName the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder acknowledgementModeName(
                String acknowledgementModeName) {
            doSetProperty("acknowledgementModeName", acknowledgementModeName);
            return this;
        }
        /**
         * Consumer priorities allow you to ensure that high priority consumers
         * receive messages while they are active. Normally, active consumers
         * connected to a queue receive messages from it in a round-robin
         * fashion. When consumer priorities are in use, messages are delivered
         * round-robin if multiple active consumers exist with the same high
         * priority. Messages will only going to lower priority consumers when
         * the high priority consumers do not have credit available to consume
         * the message, or those high priority consumers have declined to accept
         * the message (for instance because it does not meet the criteria of
         * any selectors associated with the consumer).
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param artemisConsumerPriority the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder artemisConsumerPriority(
                int artemisConsumerPriority) {
            doSetProperty("artemisConsumerPriority", artemisConsumerPriority);
            return this;
        }
        /**
         * Consumer priorities allow you to ensure that high priority consumers
         * receive messages while they are active. Normally, active consumers
         * connected to a queue receive messages from it in a round-robin
         * fashion. When consumer priorities are in use, messages are delivered
         * round-robin if multiple active consumers exist with the same high
         * priority. Messages will only going to lower priority consumers when
         * the high priority consumers do not have credit available to consume
         * the message, or those high priority consumers have declined to accept
         * the message (for instance because it does not meet the criteria of
         * any selectors associated with the consumer).
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param artemisConsumerPriority the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder artemisConsumerPriority(
                String artemisConsumerPriority) {
            doSetProperty("artemisConsumerPriority", artemisConsumerPriority);
            return this;
        }
        /**
         * Whether the JmsConsumer processes the Exchange asynchronously. If
         * enabled then the JmsConsumer may pickup the next message from the JMS
         * queue, while the previous message is being processed asynchronously
         * (by the Asynchronous Routing Engine). This means that messages may be
         * processed not 100% strictly in order. If disabled (as default) then
         * the Exchange is fully processed before the JmsConsumer will pickup
         * the next message from the JMS queue. Note if transacted has been
         * enabled, then asyncConsumer=true does not run asynchronously, as
         * transaction must be executed synchronously (Camel 3.0 may support
         * async transactions).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param asyncConsumer the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder asyncConsumer(boolean asyncConsumer) {
            doSetProperty("asyncConsumer", asyncConsumer);
            return this;
        }
        /**
         * Whether the JmsConsumer processes the Exchange asynchronously. If
         * enabled then the JmsConsumer may pickup the next message from the JMS
         * queue, while the previous message is being processed asynchronously
         * (by the Asynchronous Routing Engine). This means that messages may be
         * processed not 100% strictly in order. If disabled (as default) then
         * the Exchange is fully processed before the JmsConsumer will pickup
         * the next message from the JMS queue. Note if transacted has been
         * enabled, then asyncConsumer=true does not run asynchronously, as
         * transaction must be executed synchronously (Camel 3.0 may support
         * async transactions).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param asyncConsumer the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder asyncConsumer(String asyncConsumer) {
            doSetProperty("asyncConsumer", asyncConsumer);
            return this;
        }
        /**
         * Specifies whether the consumer container should auto-startup.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param autoStartup the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder autoStartup(boolean autoStartup) {
            doSetProperty("autoStartup", autoStartup);
            return this;
        }
        /**
         * Specifies whether the consumer container should auto-startup.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param autoStartup the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder autoStartup(String autoStartup) {
            doSetProperty("autoStartup", autoStartup);
            return this;
        }
        /**
         * Sets the cache level by ID for the underlying JMS resources. See
         * cacheLevelName option for more details.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param cacheLevel the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder cacheLevel(int cacheLevel) {
            doSetProperty("cacheLevel", cacheLevel);
            return this;
        }
        /**
         * Sets the cache level by ID for the underlying JMS resources. See
         * cacheLevelName option for more details.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param cacheLevel the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder cacheLevel(String cacheLevel) {
            doSetProperty("cacheLevel", cacheLevel);
            return this;
        }
        /**
         * Sets the cache level by name for the underlying JMS resources.
         * Possible values are: CACHE_AUTO, CACHE_CONNECTION, CACHE_CONSUMER,
         * CACHE_NONE, and CACHE_SESSION. The default setting is CACHE_AUTO. See
         * the Spring documentation and Transactions Cache Levels for more
         * information.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: CACHE_AUTO
         * Group: consumer
         * 
         * @param cacheLevelName the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder cacheLevelName(String cacheLevelName) {
            doSetProperty("cacheLevelName", cacheLevelName);
            return this;
        }
        /**
         * Specifies the default number of concurrent consumers when consuming
         * from JMS (not for request/reply over JMS). See also the
         * maxMessagesPerTask option to control dynamic scaling up/down of
         * threads. When doing request/reply over JMS then the option
         * replyToConcurrentConsumers is used to control number of concurrent
         * consumers on the reply message listener.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: consumer
         * 
         * @param concurrentConsumers the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder concurrentConsumers(
                int concurrentConsumers) {
            doSetProperty("concurrentConsumers", concurrentConsumers);
            return this;
        }
        /**
         * Specifies the default number of concurrent consumers when consuming
         * from JMS (not for request/reply over JMS). See also the
         * maxMessagesPerTask option to control dynamic scaling up/down of
         * threads. When doing request/reply over JMS then the option
         * replyToConcurrentConsumers is used to control number of concurrent
         * consumers on the reply message listener.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: consumer
         * 
         * @param concurrentConsumers the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder concurrentConsumers(
                String concurrentConsumers) {
            doSetProperty("concurrentConsumers", concurrentConsumers);
            return this;
        }
        /**
         * Specifies the maximum number of concurrent consumers when consuming
         * from JMS (not for request/reply over JMS). See also the
         * maxMessagesPerTask option to control dynamic scaling up/down of
         * threads. When doing request/reply over JMS then the option
         * replyToMaxConcurrentConsumers is used to control number of concurrent
         * consumers on the reply message listener.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param maxConcurrentConsumers the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder maxConcurrentConsumers(
                int maxConcurrentConsumers) {
            doSetProperty("maxConcurrentConsumers", maxConcurrentConsumers);
            return this;
        }
        /**
         * Specifies the maximum number of concurrent consumers when consuming
         * from JMS (not for request/reply over JMS). See also the
         * maxMessagesPerTask option to control dynamic scaling up/down of
         * threads. When doing request/reply over JMS then the option
         * replyToMaxConcurrentConsumers is used to control number of concurrent
         * consumers on the reply message listener.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param maxConcurrentConsumers the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder maxConcurrentConsumers(
                String maxConcurrentConsumers) {
            doSetProperty("maxConcurrentConsumers", maxConcurrentConsumers);
            return this;
        }
        /**
         * Specifies whether to use persistent delivery by default for replies.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param replyToDeliveryPersistent the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder replyToDeliveryPersistent(
                boolean replyToDeliveryPersistent) {
            doSetProperty("replyToDeliveryPersistent", replyToDeliveryPersistent);
            return this;
        }
        /**
         * Specifies whether to use persistent delivery by default for replies.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param replyToDeliveryPersistent the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder replyToDeliveryPersistent(
                String replyToDeliveryPersistent) {
            doSetProperty("replyToDeliveryPersistent", replyToDeliveryPersistent);
            return this;
        }
        /**
         * Sets the JMS selector to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param selector the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder selector(String selector) {
            doSetProperty("selector", selector);
            return this;
        }
        /**
         * Set whether to make the subscription durable. The durable
         * subscription name to be used can be specified through the
         * subscriptionName property. Default is false. Set this to true to
         * register a durable subscription, typically in combination with a
         * subscriptionName value (unless your message listener class name is
         * good enough as subscription name). Only makes sense when listening to
         * a topic (pub-sub domain), therefore this method switches the
         * pubSubDomain flag as well.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param subscriptionDurable the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder subscriptionDurable(
                boolean subscriptionDurable) {
            doSetProperty("subscriptionDurable", subscriptionDurable);
            return this;
        }
        /**
         * Set whether to make the subscription durable. The durable
         * subscription name to be used can be specified through the
         * subscriptionName property. Default is false. Set this to true to
         * register a durable subscription, typically in combination with a
         * subscriptionName value (unless your message listener class name is
         * good enough as subscription name). Only makes sense when listening to
         * a topic (pub-sub domain), therefore this method switches the
         * pubSubDomain flag as well.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param subscriptionDurable the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder subscriptionDurable(
                String subscriptionDurable) {
            doSetProperty("subscriptionDurable", subscriptionDurable);
            return this;
        }
        /**
         * Set the name of a subscription to create. To be applied in case of a
         * topic (pub-sub domain) with a shared or durable subscription. The
         * subscription name needs to be unique within this client's JMS client
         * id. Default is the class name of the specified message listener.
         * Note: Only 1 concurrent consumer (which is the default of this
         * message listener container) is allowed for each subscription, except
         * for a shared subscription (which requires JMS 2.0).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param subscriptionName the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder subscriptionName(
                String subscriptionName) {
            doSetProperty("subscriptionName", subscriptionName);
            return this;
        }
        /**
         * Set whether to make the subscription shared. The shared subscription
         * name to be used can be specified through the subscriptionName
         * property. Default is false. Set this to true to register a shared
         * subscription, typically in combination with a subscriptionName value
         * (unless your message listener class name is good enough as
         * subscription name). Note that shared subscriptions may also be
         * durable, so this flag can (and often will) be combined with
         * subscriptionDurable as well. Only makes sense when listening to a
         * topic (pub-sub domain), therefore this method switches the
         * pubSubDomain flag as well. Requires a JMS 2.0 compatible message
         * broker.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param subscriptionShared the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder subscriptionShared(
                boolean subscriptionShared) {
            doSetProperty("subscriptionShared", subscriptionShared);
            return this;
        }
        /**
         * Set whether to make the subscription shared. The shared subscription
         * name to be used can be specified through the subscriptionName
         * property. Default is false. Set this to true to register a shared
         * subscription, typically in combination with a subscriptionName value
         * (unless your message listener class name is good enough as
         * subscription name). Note that shared subscriptions may also be
         * durable, so this flag can (and often will) be combined with
         * subscriptionDurable as well. Only makes sense when listening to a
         * topic (pub-sub domain), therefore this method switches the
         * pubSubDomain flag as well. Requires a JMS 2.0 compatible message
         * broker.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param subscriptionShared the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder subscriptionShared(
                String subscriptionShared) {
            doSetProperty("subscriptionShared", subscriptionShared);
            return this;
        }
        /**
         * Allows to configure the default errorHandler logging level for
         * logging uncaught exceptions.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: WARN
         * Group: logging
         * 
         * @param errorHandlerLoggingLevel the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder errorHandlerLoggingLevel(
                org.apache.camel.LoggingLevel errorHandlerLoggingLevel) {
            doSetProperty("errorHandlerLoggingLevel", errorHandlerLoggingLevel);
            return this;
        }
        /**
         * Allows to configure the default errorHandler logging level for
         * logging uncaught exceptions.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: WARN
         * Group: logging
         * 
         * @param errorHandlerLoggingLevel the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder errorHandlerLoggingLevel(
                String errorHandlerLoggingLevel) {
            doSetProperty("errorHandlerLoggingLevel", errorHandlerLoggingLevel);
            return this;
        }
        /**
         * Allows to control whether stack-traces should be logged or not, by
         * the default errorHandler.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: logging
         * 
         * @param errorHandlerLogStackTrace the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder errorHandlerLogStackTrace(
                boolean errorHandlerLogStackTrace) {
            doSetProperty("errorHandlerLogStackTrace", errorHandlerLogStackTrace);
            return this;
        }
        /**
         * Allows to control whether stack-traces should be logged or not, by
         * the default errorHandler.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: logging
         * 
         * @param errorHandlerLogStackTrace the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder errorHandlerLogStackTrace(
                String errorHandlerLogStackTrace) {
            doSetProperty("errorHandlerLogStackTrace", errorHandlerLogStackTrace);
            return this;
        }
        /**
         * Password to use with the ConnectionFactory. You can also configure
         * username/password directly on the ConnectionFactory.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Username to use with the ConnectionFactory. You can also configure
         * username/password directly on the ConnectionFactory.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
        /**
         * Specifies whether to use transacted mode.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: transaction
         * 
         * @param transacted the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder transacted(boolean transacted) {
            doSetProperty("transacted", transacted);
            return this;
        }
        /**
         * Specifies whether to use transacted mode.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: transaction
         * 
         * @param transacted the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder transacted(String transacted) {
            doSetProperty("transacted", transacted);
            return this;
        }
        /**
         * Specifies whether InOut operations (request reply) default to using
         * transacted mode If this flag is set to true, then Spring JmsTemplate
         * will have sessionTransacted set to true, and the acknowledgeMode as
         * transacted on the JmsTemplate used for InOut operations. Note from
         * Spring JMS: that within a JTA transaction, the parameters passed to
         * createQueue, createTopic methods are not taken into account.
         * Depending on the Java EE transaction context, the container makes its
         * own decisions on these values. Analogously, these parameters are not
         * taken into account within a locally managed transaction either, since
         * Spring JMS operates on an existing JMS Session in this case. Setting
         * this flag to true will use a short local JMS transaction when running
         * outside of a managed transaction, and a synchronized local JMS
         * transaction in case of a managed transaction (other than an XA
         * transaction) being present. This has the effect of a local JMS
         * transaction being managed alongside the main transaction (which might
         * be a native JDBC transaction), with the JMS transaction committing
         * right after the main transaction.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: transaction
         * 
         * @param transactedInOut the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder transactedInOut(
                boolean transactedInOut) {
            doSetProperty("transactedInOut", transactedInOut);
            return this;
        }
        /**
         * Specifies whether InOut operations (request reply) default to using
         * transacted mode If this flag is set to true, then Spring JmsTemplate
         * will have sessionTransacted set to true, and the acknowledgeMode as
         * transacted on the JmsTemplate used for InOut operations. Note from
         * Spring JMS: that within a JTA transaction, the parameters passed to
         * createQueue, createTopic methods are not taken into account.
         * Depending on the Java EE transaction context, the container makes its
         * own decisions on these values. Analogously, these parameters are not
         * taken into account within a locally managed transaction either, since
         * Spring JMS operates on an existing JMS Session in this case. Setting
         * this flag to true will use a short local JMS transaction when running
         * outside of a managed transaction, and a synchronized local JMS
         * transaction in case of a managed transaction (other than an XA
         * transaction) being present. This has the effect of a local JMS
         * transaction being managed alongside the main transaction (which might
         * be a native JDBC transaction), with the JMS transaction committing
         * right after the main transaction.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: transaction
         * 
         * @param transactedInOut the value to set
         * @return the dsl builder
         */
        default AMQPEndpointConsumerBuilder transactedInOut(
                String transactedInOut) {
            doSetProperty("transactedInOut", transactedInOut);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the AMQP component.
     */
    public interface AdvancedAMQPEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AMQPEndpointConsumerBuilder basic() {
            return (AMQPEndpointConsumerBuilder) this;
        }
        /**
         * Specifies whether the consumer accept messages while it is stopping.
         * You may consider enabling this option, if you start and stop JMS
         * routes at runtime, while there are still messages enqueued on the
         * queue. If this option is false, and you stop the JMS route, then
         * messages may be rejected, and the JMS broker would have to attempt
         * redeliveries, which yet again may be rejected, and eventually the
         * message may be moved at a dead letter queue on the JMS broker. To
         * avoid this its recommended to enable this option.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param acceptMessagesWhileStopping the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder acceptMessagesWhileStopping(
                boolean acceptMessagesWhileStopping) {
            doSetProperty("acceptMessagesWhileStopping", acceptMessagesWhileStopping);
            return this;
        }
        /**
         * Specifies whether the consumer accept messages while it is stopping.
         * You may consider enabling this option, if you start and stop JMS
         * routes at runtime, while there are still messages enqueued on the
         * queue. If this option is false, and you stop the JMS route, then
         * messages may be rejected, and the JMS broker would have to attempt
         * redeliveries, which yet again may be rejected, and eventually the
         * message may be moved at a dead letter queue on the JMS broker. To
         * avoid this its recommended to enable this option.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param acceptMessagesWhileStopping the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder acceptMessagesWhileStopping(
                String acceptMessagesWhileStopping) {
            doSetProperty("acceptMessagesWhileStopping", acceptMessagesWhileStopping);
            return this;
        }
        /**
         * Whether the DefaultMessageListenerContainer used in the reply
         * managers for request-reply messaging allow the
         * DefaultMessageListenerContainer.runningAllowed flag to quick stop in
         * case JmsConfiguration#isAcceptMessagesWhileStopping is enabled, and
         * org.apache.camel.CamelContext is currently being stopped. This quick
         * stop ability is enabled by default in the regular JMS consumers but
         * to enable for reply managers you must enable this flag.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param allowReplyManagerQuickStop the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder allowReplyManagerQuickStop(
                boolean allowReplyManagerQuickStop) {
            doSetProperty("allowReplyManagerQuickStop", allowReplyManagerQuickStop);
            return this;
        }
        /**
         * Whether the DefaultMessageListenerContainer used in the reply
         * managers for request-reply messaging allow the
         * DefaultMessageListenerContainer.runningAllowed flag to quick stop in
         * case JmsConfiguration#isAcceptMessagesWhileStopping is enabled, and
         * org.apache.camel.CamelContext is currently being stopped. This quick
         * stop ability is enabled by default in the regular JMS consumers but
         * to enable for reply managers you must enable this flag.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param allowReplyManagerQuickStop the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder allowReplyManagerQuickStop(
                String allowReplyManagerQuickStop) {
            doSetProperty("allowReplyManagerQuickStop", allowReplyManagerQuickStop);
            return this;
        }
        /**
         * The consumer type to use, which can be one of: Simple, Default, or
         * Custom. The consumer type determines which Spring JMS listener to
         * use. Default will use
         * org.springframework.jms.listener.DefaultMessageListenerContainer,
         * Simple will use
         * org.springframework.jms.listener.SimpleMessageListenerContainer. When
         * Custom is specified, the MessageListenerContainerFactory defined by
         * the messageListenerContainerFactory option will determine what
         * org.springframework.jms.listener.AbstractMessageListenerContainer to
         * use.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.jms.ConsumerType&lt;/code&gt;
         * type.
         * 
         * Default: Default
         * Group: consumer (advanced)
         * 
         * @param consumerType the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder consumerType(
                org.apache.camel.component.jms.ConsumerType consumerType) {
            doSetProperty("consumerType", consumerType);
            return this;
        }
        /**
         * The consumer type to use, which can be one of: Simple, Default, or
         * Custom. The consumer type determines which Spring JMS listener to
         * use. Default will use
         * org.springframework.jms.listener.DefaultMessageListenerContainer,
         * Simple will use
         * org.springframework.jms.listener.SimpleMessageListenerContainer. When
         * Custom is specified, the MessageListenerContainerFactory defined by
         * the messageListenerContainerFactory option will determine what
         * org.springframework.jms.listener.AbstractMessageListenerContainer to
         * use.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.jms.ConsumerType&lt;/code&gt;
         * type.
         * 
         * Default: Default
         * Group: consumer (advanced)
         * 
         * @param consumerType the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder consumerType(
                String consumerType) {
            doSetProperty("consumerType", consumerType);
            return this;
        }
        /**
         * Specifies what default TaskExecutor type to use in the
         * DefaultMessageListenerContainer, for both consumer endpoints and the
         * ReplyTo consumer of producer endpoints. Possible values: SimpleAsync
         * (uses Spring's SimpleAsyncTaskExecutor) or ThreadPool (uses Spring's
         * ThreadPoolTaskExecutor with optimal values - cached
         * thread-pool-like). If not set, it defaults to the previous behaviour,
         * which uses a cached thread pool for consumer endpoints and
         * SimpleAsync for reply consumers. The use of ThreadPool is recommended
         * to reduce thread trash in elastic configurations with dynamically
         * increasing and decreasing concurrent consumers.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.jms.DefaultTaskExecutorType&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param defaultTaskExecutorType the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder defaultTaskExecutorType(
                org.apache.camel.component.jms.DefaultTaskExecutorType defaultTaskExecutorType) {
            doSetProperty("defaultTaskExecutorType", defaultTaskExecutorType);
            return this;
        }
        /**
         * Specifies what default TaskExecutor type to use in the
         * DefaultMessageListenerContainer, for both consumer endpoints and the
         * ReplyTo consumer of producer endpoints. Possible values: SimpleAsync
         * (uses Spring's SimpleAsyncTaskExecutor) or ThreadPool (uses Spring's
         * ThreadPoolTaskExecutor with optimal values - cached
         * thread-pool-like). If not set, it defaults to the previous behaviour,
         * which uses a cached thread pool for consumer endpoints and
         * SimpleAsync for reply consumers. The use of ThreadPool is recommended
         * to reduce thread trash in elastic configurations with dynamically
         * increasing and decreasing concurrent consumers.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.jms.DefaultTaskExecutorType&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param defaultTaskExecutorType the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder defaultTaskExecutorType(
                String defaultTaskExecutorType) {
            doSetProperty("defaultTaskExecutorType", defaultTaskExecutorType);
            return this;
        }
        /**
         * Enables eager loading of JMS properties and payload as soon as a
         * message is loaded which generally is inefficient as the JMS
         * properties may not be required but sometimes can catch early any
         * issues with the underlying JMS provider and the use of JMS
         * properties. See also the option eagerPoisonBody.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param eagerLoadingOfProperties the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder eagerLoadingOfProperties(
                boolean eagerLoadingOfProperties) {
            doSetProperty("eagerLoadingOfProperties", eagerLoadingOfProperties);
            return this;
        }
        /**
         * Enables eager loading of JMS properties and payload as soon as a
         * message is loaded which generally is inefficient as the JMS
         * properties may not be required but sometimes can catch early any
         * issues with the underlying JMS provider and the use of JMS
         * properties. See also the option eagerPoisonBody.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param eagerLoadingOfProperties the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder eagerLoadingOfProperties(
                String eagerLoadingOfProperties) {
            doSetProperty("eagerLoadingOfProperties", eagerLoadingOfProperties);
            return this;
        }
        /**
         * If eagerLoadingOfProperties is enabled and the JMS message payload
         * (JMS body or JMS properties) is poison (cannot be read/mapped), then
         * set this text as the message body instead so the message can be
         * processed (the cause of the poison are already stored as exception on
         * the Exchange). This can be turned off by setting
         * eagerPoisonBody=false. See also the option eagerLoadingOfProperties.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: Poison JMS message due to ${exception.message}
         * Group: consumer (advanced)
         * 
         * @param eagerPoisonBody the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder eagerPoisonBody(
                String eagerPoisonBody) {
            doSetProperty("eagerPoisonBody", eagerPoisonBody);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Specifies whether the listener session should be exposed when
         * consuming messages.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param exposeListenerSession the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder exposeListenerSession(
                boolean exposeListenerSession) {
            doSetProperty("exposeListenerSession", exposeListenerSession);
            return this;
        }
        /**
         * Specifies whether the listener session should be exposed when
         * consuming messages.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param exposeListenerSession the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder exposeListenerSession(
                String exposeListenerSession) {
            doSetProperty("exposeListenerSession", exposeListenerSession);
            return this;
        }
        /**
         * The consumer type of the reply consumer (when doing request/reply),
         * which can be one of: Simple, Default, or Custom. The consumer type
         * determines which Spring JMS listener to use. Default will use
         * org.springframework.jms.listener.DefaultMessageListenerContainer,
         * Simple will use
         * org.springframework.jms.listener.SimpleMessageListenerContainer. When
         * Custom is specified, the MessageListenerContainerFactory defined by
         * the messageListenerContainerFactory option will determine what
         * org.springframework.jms.listener.AbstractMessageListenerContainer to
         * use.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.jms.ConsumerType&lt;/code&gt;
         * type.
         * 
         * Default: Default
         * Group: consumer (advanced)
         * 
         * @param replyToConsumerType the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder replyToConsumerType(
                org.apache.camel.component.jms.ConsumerType replyToConsumerType) {
            doSetProperty("replyToConsumerType", replyToConsumerType);
            return this;
        }
        /**
         * The consumer type of the reply consumer (when doing request/reply),
         * which can be one of: Simple, Default, or Custom. The consumer type
         * determines which Spring JMS listener to use. Default will use
         * org.springframework.jms.listener.DefaultMessageListenerContainer,
         * Simple will use
         * org.springframework.jms.listener.SimpleMessageListenerContainer. When
         * Custom is specified, the MessageListenerContainerFactory defined by
         * the messageListenerContainerFactory option will determine what
         * org.springframework.jms.listener.AbstractMessageListenerContainer to
         * use.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.jms.ConsumerType&lt;/code&gt;
         * type.
         * 
         * Default: Default
         * Group: consumer (advanced)
         * 
         * @param replyToConsumerType the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder replyToConsumerType(
                String replyToConsumerType) {
            doSetProperty("replyToConsumerType", replyToConsumerType);
            return this;
        }
        /**
         * Whether a JMS consumer is allowed to send a reply message to the same
         * destination that the consumer is using to consume from. This prevents
         * an endless loop by consuming and sending back the same message to
         * itself.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param replyToSameDestinationAllowed the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder replyToSameDestinationAllowed(
                boolean replyToSameDestinationAllowed) {
            doSetProperty("replyToSameDestinationAllowed", replyToSameDestinationAllowed);
            return this;
        }
        /**
         * Whether a JMS consumer is allowed to send a reply message to the same
         * destination that the consumer is using to consume from. This prevents
         * an endless loop by consuming and sending back the same message to
         * itself.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param replyToSameDestinationAllowed the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder replyToSameDestinationAllowed(
                String replyToSameDestinationAllowed) {
            doSetProperty("replyToSameDestinationAllowed", replyToSameDestinationAllowed);
            return this;
        }
        /**
         * Allows you to specify a custom task executor for consuming messages.
         * 
         * The option is a:
         * &lt;code&gt;org.springframework.core.task.TaskExecutor&lt;/code&gt;
         * type.
         * 
         * Group: consumer (advanced)
         * 
         * @param taskExecutor the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder taskExecutor(
                org.springframework.core.task.TaskExecutor taskExecutor) {
            doSetProperty("taskExecutor", taskExecutor);
            return this;
        }
        /**
         * Allows you to specify a custom task executor for consuming messages.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.springframework.core.task.TaskExecutor&lt;/code&gt;
         * type.
         * 
         * Group: consumer (advanced)
         * 
         * @param taskExecutor the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder taskExecutor(
                String taskExecutor) {
            doSetProperty("taskExecutor", taskExecutor);
            return this;
        }
        /**
         * Controls whether or not to include serialized headers. Applies only
         * when transferExchange is true. This requires that the objects are
         * serializable. Camel will exclude any non-serializable objects and log
         * it at WARN level.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param allowSerializedHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder allowSerializedHeaders(
                boolean allowSerializedHeaders) {
            doSetProperty("allowSerializedHeaders", allowSerializedHeaders);
            return this;
        }
        /**
         * Controls whether or not to include serialized headers. Applies only
         * when transferExchange is true. This requires that the objects are
         * serializable. Camel will exclude any non-serializable objects and log
         * it at WARN level.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param allowSerializedHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder allowSerializedHeaders(
                String allowSerializedHeaders) {
            doSetProperty("allowSerializedHeaders", allowSerializedHeaders);
            return this;
        }
        /**
         * Whether optimizing for Apache Artemis streaming mode. This can reduce
         * memory overhead when using Artemis with JMS StreamMessage types. This
         * option must only be enabled if Apache Artemis is being used.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param artemisStreamingEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder artemisStreamingEnabled(
                boolean artemisStreamingEnabled) {
            doSetProperty("artemisStreamingEnabled", artemisStreamingEnabled);
            return this;
        }
        /**
         * Whether optimizing for Apache Artemis streaming mode. This can reduce
         * memory overhead when using Artemis with JMS StreamMessage types. This
         * option must only be enabled if Apache Artemis is being used.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param artemisStreamingEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder artemisStreamingEnabled(
                String artemisStreamingEnabled) {
            doSetProperty("artemisStreamingEnabled", artemisStreamingEnabled);
            return this;
        }
        /**
         * Whether to startup the JmsConsumer message listener asynchronously,
         * when starting a route. For example if a JmsConsumer cannot get a
         * connection to a remote JMS broker, then it may block while retrying
         * and/or fail-over. This will cause Camel to block while starting
         * routes. By setting this option to true, you will let routes startup,
         * while the JmsConsumer connects to the JMS broker using a dedicated
         * thread in asynchronous mode. If this option is used, then beware that
         * if the connection could not be established, then an exception is
         * logged at WARN level, and the consumer will not be able to receive
         * messages; You can then restart the route to retry.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStartListener the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder asyncStartListener(
                boolean asyncStartListener) {
            doSetProperty("asyncStartListener", asyncStartListener);
            return this;
        }
        /**
         * Whether to startup the JmsConsumer message listener asynchronously,
         * when starting a route. For example if a JmsConsumer cannot get a
         * connection to a remote JMS broker, then it may block while retrying
         * and/or fail-over. This will cause Camel to block while starting
         * routes. By setting this option to true, you will let routes startup,
         * while the JmsConsumer connects to the JMS broker using a dedicated
         * thread in asynchronous mode. If this option is used, then beware that
         * if the connection could not be established, then an exception is
         * logged at WARN level, and the consumer will not be able to receive
         * messages; You can then restart the route to retry.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStartListener the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder asyncStartListener(
                String asyncStartListener) {
            doSetProperty("asyncStartListener", asyncStartListener);
            return this;
        }
        /**
         * Whether to stop the JmsConsumer message listener asynchronously, when
         * stopping a route.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStopListener the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder asyncStopListener(
                boolean asyncStopListener) {
            doSetProperty("asyncStopListener", asyncStopListener);
            return this;
        }
        /**
         * Whether to stop the JmsConsumer message listener asynchronously, when
         * stopping a route.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStopListener the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder asyncStopListener(
                String asyncStopListener) {
            doSetProperty("asyncStopListener", asyncStopListener);
            return this;
        }
        /**
         * A pluggable
         * org.springframework.jms.support.destination.DestinationResolver that
         * allows you to use your own resolver (for example, to lookup the real
         * destination in a JNDI registry).
         * 
         * The option is a:
         * &lt;code&gt;org.springframework.jms.support.destination.DestinationResolver&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param destinationResolver the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder destinationResolver(
                org.springframework.jms.support.destination.DestinationResolver destinationResolver) {
            doSetProperty("destinationResolver", destinationResolver);
            return this;
        }
        /**
         * A pluggable
         * org.springframework.jms.support.destination.DestinationResolver that
         * allows you to use your own resolver (for example, to lookup the real
         * destination in a JNDI registry).
         * 
         * The option will be converted to a
         * &lt;code&gt;org.springframework.jms.support.destination.DestinationResolver&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param destinationResolver the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder destinationResolver(
                String destinationResolver) {
            doSetProperty("destinationResolver", destinationResolver);
            return this;
        }
        /**
         * Specifies a org.springframework.util.ErrorHandler to be invoked in
         * case of any uncaught exceptions thrown while processing a Message. By
         * default these exceptions will be logged at the WARN level, if no
         * errorHandler has been configured. You can configure logging level and
         * whether stack traces should be logged using errorHandlerLoggingLevel
         * and errorHandlerLogStackTrace options. This makes it much easier to
         * configure, than having to code a custom errorHandler.
         * 
         * The option is a:
         * &lt;code&gt;org.springframework.util.ErrorHandler&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param errorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder errorHandler(
                org.springframework.util.ErrorHandler errorHandler) {
            doSetProperty("errorHandler", errorHandler);
            return this;
        }
        /**
         * Specifies a org.springframework.util.ErrorHandler to be invoked in
         * case of any uncaught exceptions thrown while processing a Message. By
         * default these exceptions will be logged at the WARN level, if no
         * errorHandler has been configured. You can configure logging level and
         * whether stack traces should be logged using errorHandlerLoggingLevel
         * and errorHandlerLogStackTrace options. This makes it much easier to
         * configure, than having to code a custom errorHandler.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.springframework.util.ErrorHandler&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param errorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder errorHandler(
                String errorHandler) {
            doSetProperty("errorHandler", errorHandler);
            return this;
        }
        /**
         * Specifies the JMS Exception Listener that is to be notified of any
         * underlying JMS exceptions.
         * 
         * The option is a:
         * &lt;code&gt;jakarta.jms.ExceptionListener&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param exceptionListener the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder exceptionListener(
                jakarta.jms.ExceptionListener exceptionListener) {
            doSetProperty("exceptionListener", exceptionListener);
            return this;
        }
        /**
         * Specifies the JMS Exception Listener that is to be notified of any
         * underlying JMS exceptions.
         * 
         * The option will be converted to a
         * &lt;code&gt;jakarta.jms.ExceptionListener&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param exceptionListener the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder exceptionListener(
                String exceptionListener) {
            doSetProperty("exceptionListener", exceptionListener);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder headerFilterStrategy(
                org.apache.camel.spi.HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Specify the limit for the number of consumers that are allowed to be
         * idle at any given time.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: advanced
         * 
         * @param idleConsumerLimit the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder idleConsumerLimit(
                int idleConsumerLimit) {
            doSetProperty("idleConsumerLimit", idleConsumerLimit);
            return this;
        }
        /**
         * Specify the limit for the number of consumers that are allowed to be
         * idle at any given time.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: advanced
         * 
         * @param idleConsumerLimit the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder idleConsumerLimit(
                String idleConsumerLimit) {
            doSetProperty("idleConsumerLimit", idleConsumerLimit);
            return this;
        }
        /**
         * Specifies the limit for idle executions of a receive task, not having
         * received any message within its execution. If this limit is reached,
         * the task will shut down and leave receiving to other executing tasks
         * (in the case of dynamic scheduling; see the maxConcurrentConsumers
         * setting). There is additional doc available from Spring.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: advanced
         * 
         * @param idleTaskExecutionLimit the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder idleTaskExecutionLimit(
                int idleTaskExecutionLimit) {
            doSetProperty("idleTaskExecutionLimit", idleTaskExecutionLimit);
            return this;
        }
        /**
         * Specifies the limit for idle executions of a receive task, not having
         * received any message within its execution. If this limit is reached,
         * the task will shut down and leave receiving to other executing tasks
         * (in the case of dynamic scheduling; see the maxConcurrentConsumers
         * setting). There is additional doc available from Spring.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: advanced
         * 
         * @param idleTaskExecutionLimit the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder idleTaskExecutionLimit(
                String idleTaskExecutionLimit) {
            doSetProperty("idleTaskExecutionLimit", idleTaskExecutionLimit);
            return this;
        }
        /**
         * Whether to include all JMSX prefixed properties when mapping from JMS
         * to Camel Message. Setting this to true will include properties such
         * as JMSXAppID, and JMSXUserID etc. Note: If you are using a custom
         * headerFilterStrategy then this option does not apply.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param includeAllJMSXProperties the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder includeAllJMSXProperties(
                boolean includeAllJMSXProperties) {
            doSetProperty("includeAllJMSXProperties", includeAllJMSXProperties);
            return this;
        }
        /**
         * Whether to include all JMSX prefixed properties when mapping from JMS
         * to Camel Message. Setting this to true will include properties such
         * as JMSXAppID, and JMSXUserID etc. Note: If you are using a custom
         * headerFilterStrategy then this option does not apply.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param includeAllJMSXProperties the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder includeAllJMSXProperties(
                String includeAllJMSXProperties) {
            doSetProperty("includeAllJMSXProperties", includeAllJMSXProperties);
            return this;
        }
        /**
         * Pluggable strategy for encoding and decoding JMS keys so they can be
         * compliant with the JMS specification. Camel provides two
         * implementations out of the box: default and passthrough. The default
         * strategy will safely marshal dots and hyphens (. and -). The
         * passthrough strategy leaves the key as is. Can be used for JMS
         * brokers which do not care whether JMS header keys contain illegal
         * characters. You can provide your own implementation of the
         * org.apache.camel.component.jms.JmsKeyFormatStrategy and refer to it
         * using the # notation.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.jms.JmsKeyFormatStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param jmsKeyFormatStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder jmsKeyFormatStrategy(
                org.apache.camel.component.jms.JmsKeyFormatStrategy jmsKeyFormatStrategy) {
            doSetProperty("jmsKeyFormatStrategy", jmsKeyFormatStrategy);
            return this;
        }
        /**
         * Pluggable strategy for encoding and decoding JMS keys so they can be
         * compliant with the JMS specification. Camel provides two
         * implementations out of the box: default and passthrough. The default
         * strategy will safely marshal dots and hyphens (. and -). The
         * passthrough strategy leaves the key as is. Can be used for JMS
         * brokers which do not care whether JMS header keys contain illegal
         * characters. You can provide your own implementation of the
         * org.apache.camel.component.jms.JmsKeyFormatStrategy and refer to it
         * using the # notation.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.jms.JmsKeyFormatStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param jmsKeyFormatStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder jmsKeyFormatStrategy(
                String jmsKeyFormatStrategy) {
            doSetProperty("jmsKeyFormatStrategy", jmsKeyFormatStrategy);
            return this;
        }
        /**
         * Specifies whether Camel should auto map the received JMS message to a
         * suited payload type, such as jakarta.jms.TextMessage to a String etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param mapJmsMessage the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder mapJmsMessage(
                boolean mapJmsMessage) {
            doSetProperty("mapJmsMessage", mapJmsMessage);
            return this;
        }
        /**
         * Specifies whether Camel should auto map the received JMS message to a
         * suited payload type, such as jakarta.jms.TextMessage to a String etc.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param mapJmsMessage the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder mapJmsMessage(
                String mapJmsMessage) {
            doSetProperty("mapJmsMessage", mapJmsMessage);
            return this;
        }
        /**
         * The number of messages per task. -1 is unlimited. If you use a range
         * for concurrent consumers (eg min max), then this option can be used
         * to set a value to eg 100 to control how fast the consumers will
         * shrink when less work is required.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: advanced
         * 
         * @param maxMessagesPerTask the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder maxMessagesPerTask(
                int maxMessagesPerTask) {
            doSetProperty("maxMessagesPerTask", maxMessagesPerTask);
            return this;
        }
        /**
         * The number of messages per task. -1 is unlimited. If you use a range
         * for concurrent consumers (eg min max), then this option can be used
         * to set a value to eg 100 to control how fast the consumers will
         * shrink when less work is required.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: advanced
         * 
         * @param maxMessagesPerTask the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder maxMessagesPerTask(
                String maxMessagesPerTask) {
            doSetProperty("maxMessagesPerTask", maxMessagesPerTask);
            return this;
        }
        /**
         * To use a custom Spring
         * org.springframework.jms.support.converter.MessageConverter so you can
         * be in control how to map to/from a jakarta.jms.Message.
         * 
         * The option is a:
         * &lt;code&gt;org.springframework.jms.support.converter.MessageConverter&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageConverter the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder messageConverter(
                org.springframework.jms.support.converter.MessageConverter messageConverter) {
            doSetProperty("messageConverter", messageConverter);
            return this;
        }
        /**
         * To use a custom Spring
         * org.springframework.jms.support.converter.MessageConverter so you can
         * be in control how to map to/from a jakarta.jms.Message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.springframework.jms.support.converter.MessageConverter&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageConverter the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder messageConverter(
                String messageConverter) {
            doSetProperty("messageConverter", messageConverter);
            return this;
        }
        /**
         * To use the given MessageCreatedStrategy which are invoked when Camel
         * creates new instances of jakarta.jms.Message objects when Camel is
         * sending a JMS message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.jms.MessageCreatedStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageCreatedStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder messageCreatedStrategy(
                org.apache.camel.component.jms.MessageCreatedStrategy messageCreatedStrategy) {
            doSetProperty("messageCreatedStrategy", messageCreatedStrategy);
            return this;
        }
        /**
         * To use the given MessageCreatedStrategy which are invoked when Camel
         * creates new instances of jakarta.jms.Message objects when Camel is
         * sending a JMS message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.jms.MessageCreatedStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageCreatedStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder messageCreatedStrategy(
                String messageCreatedStrategy) {
            doSetProperty("messageCreatedStrategy", messageCreatedStrategy);
            return this;
        }
        /**
         * When sending, specifies whether message IDs should be added. This is
         * just an hint to the JMS broker. If the JMS provider accepts this
         * hint, these messages must have the message ID set to null; if the
         * provider ignores the hint, the message ID must be set to its normal
         * unique value.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param messageIdEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder messageIdEnabled(
                boolean messageIdEnabled) {
            doSetProperty("messageIdEnabled", messageIdEnabled);
            return this;
        }
        /**
         * When sending, specifies whether message IDs should be added. This is
         * just an hint to the JMS broker. If the JMS provider accepts this
         * hint, these messages must have the message ID set to null; if the
         * provider ignores the hint, the message ID must be set to its normal
         * unique value.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param messageIdEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder messageIdEnabled(
                String messageIdEnabled) {
            doSetProperty("messageIdEnabled", messageIdEnabled);
            return this;
        }
        /**
         * Registry ID of the MessageListenerContainerFactory used to determine
         * what
         * org.springframework.jms.listener.AbstractMessageListenerContainer to
         * use to consume messages. Setting this will automatically set
         * consumerType to Custom.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.jms.MessageListenerContainerFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageListenerContainerFactory the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder messageListenerContainerFactory(
                org.apache.camel.component.jms.MessageListenerContainerFactory messageListenerContainerFactory) {
            doSetProperty("messageListenerContainerFactory", messageListenerContainerFactory);
            return this;
        }
        /**
         * Registry ID of the MessageListenerContainerFactory used to determine
         * what
         * org.springframework.jms.listener.AbstractMessageListenerContainer to
         * use to consume messages. Setting this will automatically set
         * consumerType to Custom.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.jms.MessageListenerContainerFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageListenerContainerFactory the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder messageListenerContainerFactory(
                String messageListenerContainerFactory) {
            doSetProperty("messageListenerContainerFactory", messageListenerContainerFactory);
            return this;
        }
        /**
         * Specifies whether timestamps should be enabled by default on sending
         * messages. This is just an hint to the JMS broker. If the JMS provider
         * accepts this hint, these messages must have the timestamp set to
         * zero; if the provider ignores the hint the timestamp must be set to
         * its normal value.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param messageTimestampEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder messageTimestampEnabled(
                boolean messageTimestampEnabled) {
            doSetProperty("messageTimestampEnabled", messageTimestampEnabled);
            return this;
        }
        /**
         * Specifies whether timestamps should be enabled by default on sending
         * messages. This is just an hint to the JMS broker. If the JMS provider
         * accepts this hint, these messages must have the timestamp set to
         * zero; if the provider ignores the hint the timestamp must be set to
         * its normal value.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param messageTimestampEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder messageTimestampEnabled(
                String messageTimestampEnabled) {
            doSetProperty("messageTimestampEnabled", messageTimestampEnabled);
            return this;
        }
        /**
         * Specifies whether to inhibit the delivery of messages published by
         * its own connection.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param pubSubNoLocal the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder pubSubNoLocal(
                boolean pubSubNoLocal) {
            doSetProperty("pubSubNoLocal", pubSubNoLocal);
            return this;
        }
        /**
         * Specifies whether to inhibit the delivery of messages published by
         * its own connection.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param pubSubNoLocal the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder pubSubNoLocal(
                String pubSubNoLocal) {
            doSetProperty("pubSubNoLocal", pubSubNoLocal);
            return this;
        }
        /**
         * The timeout for receiving messages (in milliseconds).
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param receiveTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder receiveTimeout(
                long receiveTimeout) {
            doSetProperty("receiveTimeout", receiveTimeout);
            return this;
        }
        /**
         * The timeout for receiving messages (in milliseconds).
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param receiveTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder receiveTimeout(
                String receiveTimeout) {
            doSetProperty("receiveTimeout", receiveTimeout);
            return this;
        }
        /**
         * Specifies the interval between recovery attempts, i.e. when a
         * connection is being refreshed, in milliseconds. The default is 5000
         * ms, that is, 5 seconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: advanced
         * 
         * @param recoveryInterval the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder recoveryInterval(
                long recoveryInterval) {
            doSetProperty("recoveryInterval", recoveryInterval);
            return this;
        }
        /**
         * Specifies the interval between recovery attempts, i.e. when a
         * connection is being refreshed, in milliseconds. The default is 5000
         * ms, that is, 5 seconds.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: advanced
         * 
         * @param recoveryInterval the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder recoveryInterval(
                String recoveryInterval) {
            doSetProperty("recoveryInterval", recoveryInterval);
            return this;
        }
        /**
         * Configures how often Camel should check for timed out Exchanges when
         * doing request/reply over JMS. By default Camel checks once per
         * second. But if you must react faster when a timeout occurs, then you
         * can lower this interval, to check more frequently. The timeout is
         * determined by the option requestTimeout.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param requestTimeoutCheckerInterval the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder requestTimeoutCheckerInterval(
                long requestTimeoutCheckerInterval) {
            doSetProperty("requestTimeoutCheckerInterval", requestTimeoutCheckerInterval);
            return this;
        }
        /**
         * Configures how often Camel should check for timed out Exchanges when
         * doing request/reply over JMS. By default Camel checks once per
         * second. But if you must react faster when a timeout occurs, then you
         * can lower this interval, to check more frequently. The timeout is
         * determined by the option requestTimeout.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param requestTimeoutCheckerInterval the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder requestTimeoutCheckerInterval(
                String requestTimeoutCheckerInterval) {
            doSetProperty("requestTimeoutCheckerInterval", requestTimeoutCheckerInterval);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * If enabled and you are using Request Reply messaging (InOut) and an
         * Exchange failed on the consumer side, then the caused Exception will
         * be send back in response as a jakarta.jms.ObjectMessage. If the
         * client is Camel, the returned Exception is rethrown. This allows you
         * to use Camel JMS as a bridge in your routing - for example, using
         * persistent queues to enable robust routing. Notice that if you also
         * have transferExchange enabled, this option takes precedence. The
         * caught exception is required to be serializable. The original
         * Exception on the consumer side can be wrapped in an outer exception
         * such as org.apache.camel.RuntimeCamelException when returned to the
         * producer. Use this with caution as the data is using Java Object
         * serialization and requires the received to be able to deserialize the
         * data at Class level, which forces a strong coupling between the
         * producers and consumer!.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferException the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder transferException(
                boolean transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * If enabled and you are using Request Reply messaging (InOut) and an
         * Exchange failed on the consumer side, then the caused Exception will
         * be send back in response as a jakarta.jms.ObjectMessage. If the
         * client is Camel, the returned Exception is rethrown. This allows you
         * to use Camel JMS as a bridge in your routing - for example, using
         * persistent queues to enable robust routing. Notice that if you also
         * have transferExchange enabled, this option takes precedence. The
         * caught exception is required to be serializable. The original
         * Exception on the consumer side can be wrapped in an outer exception
         * such as org.apache.camel.RuntimeCamelException when returned to the
         * producer. Use this with caution as the data is using Java Object
         * serialization and requires the received to be able to deserialize the
         * data at Class level, which forces a strong coupling between the
         * producers and consumer!.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferException the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder transferException(
                String transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * You can transfer the exchange over the wire instead of just the body
         * and headers. The following fields are transferred: In body, Out body,
         * Fault body, In headers, Out headers, Fault headers, exchange
         * properties, exchange exception. This requires that the objects are
         * serializable. Camel will exclude any non-serializable objects and log
         * it at WARN level. You must enable this option on both the producer
         * and consumer side, so Camel knows the payloads is an Exchange and not
         * a regular payload. Use this with caution as the data is using Java
         * Object serialization and requires the receiver to be able to
         * deserialize the data at Class level, which forces a strong coupling
         * between the producers and consumers having to use compatible Camel
         * versions!.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferExchange the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder transferExchange(
                boolean transferExchange) {
            doSetProperty("transferExchange", transferExchange);
            return this;
        }
        /**
         * You can transfer the exchange over the wire instead of just the body
         * and headers. The following fields are transferred: In body, Out body,
         * Fault body, In headers, Out headers, Fault headers, exchange
         * properties, exchange exception. This requires that the objects are
         * serializable. Camel will exclude any non-serializable objects and log
         * it at WARN level. You must enable this option on both the producer
         * and consumer side, so Camel knows the payloads is an Exchange and not
         * a regular payload. Use this with caution as the data is using Java
         * Object serialization and requires the receiver to be able to
         * deserialize the data at Class level, which forces a strong coupling
         * between the producers and consumers having to use compatible Camel
         * versions!.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferExchange the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder transferExchange(
                String transferExchange) {
            doSetProperty("transferExchange", transferExchange);
            return this;
        }
        /**
         * Specifies whether JMSMessageID should always be used as
         * JMSCorrelationID for InOut messages.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param useMessageIDAsCorrelationID the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder useMessageIDAsCorrelationID(
                boolean useMessageIDAsCorrelationID) {
            doSetProperty("useMessageIDAsCorrelationID", useMessageIDAsCorrelationID);
            return this;
        }
        /**
         * Specifies whether JMSMessageID should always be used as
         * JMSCorrelationID for InOut messages.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param useMessageIDAsCorrelationID the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder useMessageIDAsCorrelationID(
                String useMessageIDAsCorrelationID) {
            doSetProperty("useMessageIDAsCorrelationID", useMessageIDAsCorrelationID);
            return this;
        }
        /**
         * Number of times to wait for provisional correlation id to be updated
         * to the actual correlation id when doing request/reply over JMS and
         * when the option useMessageIDAsCorrelationID is enabled.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 50
         * Group: advanced
         * 
         * @param waitForProvisionCorrelationToBeUpdatedCounter the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder waitForProvisionCorrelationToBeUpdatedCounter(
                int waitForProvisionCorrelationToBeUpdatedCounter) {
            doSetProperty("waitForProvisionCorrelationToBeUpdatedCounter", waitForProvisionCorrelationToBeUpdatedCounter);
            return this;
        }
        /**
         * Number of times to wait for provisional correlation id to be updated
         * to the actual correlation id when doing request/reply over JMS and
         * when the option useMessageIDAsCorrelationID is enabled.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 50
         * Group: advanced
         * 
         * @param waitForProvisionCorrelationToBeUpdatedCounter the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder waitForProvisionCorrelationToBeUpdatedCounter(
                String waitForProvisionCorrelationToBeUpdatedCounter) {
            doSetProperty("waitForProvisionCorrelationToBeUpdatedCounter", waitForProvisionCorrelationToBeUpdatedCounter);
            return this;
        }
        /**
         * Interval in millis to sleep each time while waiting for provisional
         * correlation id to be updated.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: advanced
         * 
         * @param waitForProvisionCorrelationToBeUpdatedThreadSleepingTime the
         * value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder waitForProvisionCorrelationToBeUpdatedThreadSleepingTime(
                long waitForProvisionCorrelationToBeUpdatedThreadSleepingTime) {
            doSetProperty("waitForProvisionCorrelationToBeUpdatedThreadSleepingTime", waitForProvisionCorrelationToBeUpdatedThreadSleepingTime);
            return this;
        }
        /**
         * Interval in millis to sleep each time while waiting for provisional
         * correlation id to be updated.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: advanced
         * 
         * @param waitForProvisionCorrelationToBeUpdatedThreadSleepingTime the
         * value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder waitForProvisionCorrelationToBeUpdatedThreadSleepingTime(
                String waitForProvisionCorrelationToBeUpdatedThreadSleepingTime) {
            doSetProperty("waitForProvisionCorrelationToBeUpdatedThreadSleepingTime", waitForProvisionCorrelationToBeUpdatedThreadSleepingTime);
            return this;
        }
        /**
         * If true, Camel will create a JmsTransactionManager, if there is no
         * transactionManager injected when option transacted=true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: transaction (advanced)
         * 
         * @param lazyCreateTransactionManager the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder lazyCreateTransactionManager(
                boolean lazyCreateTransactionManager) {
            doSetProperty("lazyCreateTransactionManager", lazyCreateTransactionManager);
            return this;
        }
        /**
         * If true, Camel will create a JmsTransactionManager, if there is no
         * transactionManager injected when option transacted=true.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: transaction (advanced)
         * 
         * @param lazyCreateTransactionManager the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder lazyCreateTransactionManager(
                String lazyCreateTransactionManager) {
            doSetProperty("lazyCreateTransactionManager", lazyCreateTransactionManager);
            return this;
        }
        /**
         * The Spring transaction manager to use.
         * 
         * The option is a:
         * &lt;code&gt;org.springframework.transaction.PlatformTransactionManager&lt;/code&gt; type.
         * 
         * Group: transaction (advanced)
         * 
         * @param transactionManager the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder transactionManager(
                org.springframework.transaction.PlatformTransactionManager transactionManager) {
            doSetProperty("transactionManager", transactionManager);
            return this;
        }
        /**
         * The Spring transaction manager to use.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.springframework.transaction.PlatformTransactionManager&lt;/code&gt; type.
         * 
         * Group: transaction (advanced)
         * 
         * @param transactionManager the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder transactionManager(
                String transactionManager) {
            doSetProperty("transactionManager", transactionManager);
            return this;
        }
        /**
         * The name of the transaction to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: transaction (advanced)
         * 
         * @param transactionName the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder transactionName(
                String transactionName) {
            doSetProperty("transactionName", transactionName);
            return this;
        }
        /**
         * The timeout value of the transaction (in seconds), if using
         * transacted mode.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: transaction (advanced)
         * 
         * @param transactionTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder transactionTimeout(
                int transactionTimeout) {
            doSetProperty("transactionTimeout", transactionTimeout);
            return this;
        }
        /**
         * The timeout value of the transaction (in seconds), if using
         * transacted mode.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: transaction (advanced)
         * 
         * @param transactionTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointConsumerBuilder transactionTimeout(
                String transactionTimeout) {
            doSetProperty("transactionTimeout", transactionTimeout);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the AMQP component.
     */
    public interface AMQPEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedAMQPEndpointProducerBuilder advanced() {
            return (AdvancedAMQPEndpointProducerBuilder) this;
        }
        /**
         * Sets the JMS client ID to use. Note that this value, if specified,
         * must be unique and can only be used by a single JMS connection
         * instance. It is typically only required for durable topic
         * subscriptions with JMS 1.1.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param clientId the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder clientId(String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
        /**
         * The connection factory to be use. A connection factory must be
         * configured either on the component or endpoint.
         * 
         * The option is a:
         * &lt;code&gt;jakarta.jms.ConnectionFactory&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param connectionFactory the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder connectionFactory(
                jakarta.jms.ConnectionFactory connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * The connection factory to be use. A connection factory must be
         * configured either on the component or endpoint.
         * 
         * The option will be converted to a
         * &lt;code&gt;jakarta.jms.ConnectionFactory&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param connectionFactory the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder connectionFactory(
                String connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * Specifies whether Camel ignores the JMSReplyTo header in messages. If
         * true, Camel does not send a reply back to the destination specified
         * in the JMSReplyTo header. You can use this option if you want Camel
         * to consume from a route and you do not want Camel to automatically
         * send back a reply message because another component in your code
         * handles the reply message. You can also use this option if you want
         * to use Camel as a proxy between different message brokers and you
         * want to route message from one system to another.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disableReplyTo the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder disableReplyTo(
                boolean disableReplyTo) {
            doSetProperty("disableReplyTo", disableReplyTo);
            return this;
        }
        /**
         * Specifies whether Camel ignores the JMSReplyTo header in messages. If
         * true, Camel does not send a reply back to the destination specified
         * in the JMSReplyTo header. You can use this option if you want Camel
         * to consume from a route and you do not want Camel to automatically
         * send back a reply message because another component in your code
         * handles the reply message. You can also use this option if you want
         * to use Camel as a proxy between different message brokers and you
         * want to route message from one system to another.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disableReplyTo the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder disableReplyTo(String disableReplyTo) {
            doSetProperty("disableReplyTo", disableReplyTo);
            return this;
        }
        /**
         * The durable subscriber name for specifying durable topic
         * subscriptions. The clientId option must be configured as well.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param durableSubscriptionName the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder durableSubscriptionName(
                String durableSubscriptionName) {
            doSetProperty("durableSubscriptionName", durableSubscriptionName);
            return this;
        }
        /**
         * Allows you to force the use of a specific jakarta.jms.Message
         * implementation for sending JMS messages. Possible values are: Bytes,
         * Map, Object, Stream, Text. By default, Camel would determine which
         * JMS message type to use from the In body type. This option allows you
         * to specify it.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.jms.JmsMessageType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param jmsMessageType the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder jmsMessageType(
                org.apache.camel.component.jms.JmsMessageType jmsMessageType) {
            doSetProperty("jmsMessageType", jmsMessageType);
            return this;
        }
        /**
         * Allows you to force the use of a specific jakarta.jms.Message
         * implementation for sending JMS messages. Possible values are: Bytes,
         * Map, Object, Stream, Text. By default, Camel would determine which
         * JMS message type to use from the In body type. This option allows you
         * to specify it.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.jms.JmsMessageType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param jmsMessageType the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder jmsMessageType(String jmsMessageType) {
            doSetProperty("jmsMessageType", jmsMessageType);
            return this;
        }
        /**
         * Provides an explicit ReplyTo destination (overrides any incoming
         * value of Message.getJMSReplyTo() in consumer).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param replyTo the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder replyTo(String replyTo) {
            doSetProperty("replyTo", replyTo);
            return this;
        }
        /**
         * Specifies whether to test the connection on startup. This ensures
         * that when Camel starts that all the JMS consumers have a valid
         * connection to the JMS broker. If a connection cannot be granted then
         * Camel throws an exception on startup. This ensures that Camel is not
         * started with failed connections. The JMS producers is tested as well.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param testConnectionOnStartup the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder testConnectionOnStartup(
                boolean testConnectionOnStartup) {
            doSetProperty("testConnectionOnStartup", testConnectionOnStartup);
            return this;
        }
        /**
         * Specifies whether to test the connection on startup. This ensures
         * that when Camel starts that all the JMS consumers have a valid
         * connection to the JMS broker. If a connection cannot be granted then
         * Camel throws an exception on startup. This ensures that Camel is not
         * started with failed connections. The JMS producers is tested as well.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param testConnectionOnStartup the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder testConnectionOnStartup(
                String testConnectionOnStartup) {
            doSetProperty("testConnectionOnStartup", testConnectionOnStartup);
            return this;
        }
        /**
         * Sets delivery delay to use for send calls for JMS. This option
         * requires JMS 2.0 compliant broker.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: producer
         * 
         * @param deliveryDelay the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder deliveryDelay(long deliveryDelay) {
            doSetProperty("deliveryDelay", deliveryDelay);
            return this;
        }
        /**
         * Sets delivery delay to use for send calls for JMS. This option
         * requires JMS 2.0 compliant broker.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: producer
         * 
         * @param deliveryDelay the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder deliveryDelay(String deliveryDelay) {
            doSetProperty("deliveryDelay", deliveryDelay);
            return this;
        }
        /**
         * Specifies the delivery mode to be used. Possible values are those
         * defined by jakarta.jms.DeliveryMode. NON_PERSISTENT = 1 and
         * PERSISTENT = 2.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param deliveryMode the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder deliveryMode(Integer deliveryMode) {
            doSetProperty("deliveryMode", deliveryMode);
            return this;
        }
        /**
         * Specifies the delivery mode to be used. Possible values are those
         * defined by jakarta.jms.DeliveryMode. NON_PERSISTENT = 1 and
         * PERSISTENT = 2.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param deliveryMode the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder deliveryMode(String deliveryMode) {
            doSetProperty("deliveryMode", deliveryMode);
            return this;
        }
        /**
         * Specifies whether persistent delivery is used by default.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param deliveryPersistent the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder deliveryPersistent(
                boolean deliveryPersistent) {
            doSetProperty("deliveryPersistent", deliveryPersistent);
            return this;
        }
        /**
         * Specifies whether persistent delivery is used by default.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param deliveryPersistent the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder deliveryPersistent(
                String deliveryPersistent) {
            doSetProperty("deliveryPersistent", deliveryPersistent);
            return this;
        }
        /**
         * Set if the deliveryMode, priority or timeToLive qualities of service
         * should be used when sending messages. This option is based on
         * Spring's JmsTemplate. The deliveryMode, priority and timeToLive
         * options are applied to the current endpoint. This contrasts with the
         * preserveMessageQos option, which operates at message granularity,
         * reading QoS properties exclusively from the Camel In message headers.
         * 
         * The option is a: &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param explicitQosEnabled the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder explicitQosEnabled(
                Boolean explicitQosEnabled) {
            doSetProperty("explicitQosEnabled", explicitQosEnabled);
            return this;
        }
        /**
         * Set if the deliveryMode, priority or timeToLive qualities of service
         * should be used when sending messages. This option is based on
         * Spring's JmsTemplate. The deliveryMode, priority and timeToLive
         * options are applied to the current endpoint. This contrasts with the
         * preserveMessageQos option, which operates at message granularity,
         * reading QoS properties exclusively from the Camel In message headers.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param explicitQosEnabled the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder explicitQosEnabled(
                String explicitQosEnabled) {
            doSetProperty("explicitQosEnabled", explicitQosEnabled);
            return this;
        }
        /**
         * Sets whether JMS date properties should be formatted according to the
         * ISO 8601 standard.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param formatDateHeadersToIso8601 the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder formatDateHeadersToIso8601(
                boolean formatDateHeadersToIso8601) {
            doSetProperty("formatDateHeadersToIso8601", formatDateHeadersToIso8601);
            return this;
        }
        /**
         * Sets whether JMS date properties should be formatted according to the
         * ISO 8601 standard.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param formatDateHeadersToIso8601 the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder formatDateHeadersToIso8601(
                String formatDateHeadersToIso8601) {
            doSetProperty("formatDateHeadersToIso8601", formatDateHeadersToIso8601);
            return this;
        }
        /**
         * Set to true, if you want to send message using the QoS settings
         * specified on the message, instead of the QoS settings on the JMS
         * endpoint. The following three headers are considered JMSPriority,
         * JMSDeliveryMode, and JMSExpiration. You can provide all or only some
         * of them. If not provided, Camel will fall back to use the values from
         * the endpoint instead. So, when using this option, the headers
         * override the values from the endpoint. The explicitQosEnabled option,
         * by contrast, will only use options set on the endpoint, and not
         * values from the message header.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param preserveMessageQos the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder preserveMessageQos(
                boolean preserveMessageQos) {
            doSetProperty("preserveMessageQos", preserveMessageQos);
            return this;
        }
        /**
         * Set to true, if you want to send message using the QoS settings
         * specified on the message, instead of the QoS settings on the JMS
         * endpoint. The following three headers are considered JMSPriority,
         * JMSDeliveryMode, and JMSExpiration. You can provide all or only some
         * of them. If not provided, Camel will fall back to use the values from
         * the endpoint instead. So, when using this option, the headers
         * override the values from the endpoint. The explicitQosEnabled option,
         * by contrast, will only use options set on the endpoint, and not
         * values from the message header.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param preserveMessageQos the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder preserveMessageQos(
                String preserveMessageQos) {
            doSetProperty("preserveMessageQos", preserveMessageQos);
            return this;
        }
        /**
         * Values greater than 1 specify the message priority when sending
         * (where 1 is the lowest priority and 9 is the highest). The
         * explicitQosEnabled option must also be enabled in order for this
         * option to have any effect.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 4
         * Group: producer
         * 
         * @param priority the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder priority(int priority) {
            doSetProperty("priority", priority);
            return this;
        }
        /**
         * Values greater than 1 specify the message priority when sending
         * (where 1 is the lowest priority and 9 is the highest). The
         * explicitQosEnabled option must also be enabled in order for this
         * option to have any effect.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 4
         * Group: producer
         * 
         * @param priority the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder priority(String priority) {
            doSetProperty("priority", priority);
            return this;
        }
        /**
         * Specifies the default number of concurrent consumers when doing
         * request/reply over JMS. See also the maxMessagesPerTask option to
         * control dynamic scaling up/down of threads.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: producer
         * 
         * @param replyToConcurrentConsumers the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder replyToConcurrentConsumers(
                int replyToConcurrentConsumers) {
            doSetProperty("replyToConcurrentConsumers", replyToConcurrentConsumers);
            return this;
        }
        /**
         * Specifies the default number of concurrent consumers when doing
         * request/reply over JMS. See also the maxMessagesPerTask option to
         * control dynamic scaling up/down of threads.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: producer
         * 
         * @param replyToConcurrentConsumers the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder replyToConcurrentConsumers(
                String replyToConcurrentConsumers) {
            doSetProperty("replyToConcurrentConsumers", replyToConcurrentConsumers);
            return this;
        }
        /**
         * Specifies the maximum number of concurrent consumers when using
         * request/reply over JMS. See also the maxMessagesPerTask option to
         * control dynamic scaling up/down of threads.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param replyToMaxConcurrentConsumers the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder replyToMaxConcurrentConsumers(
                int replyToMaxConcurrentConsumers) {
            doSetProperty("replyToMaxConcurrentConsumers", replyToMaxConcurrentConsumers);
            return this;
        }
        /**
         * Specifies the maximum number of concurrent consumers when using
         * request/reply over JMS. See also the maxMessagesPerTask option to
         * control dynamic scaling up/down of threads.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param replyToMaxConcurrentConsumers the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder replyToMaxConcurrentConsumers(
                String replyToMaxConcurrentConsumers) {
            doSetProperty("replyToMaxConcurrentConsumers", replyToMaxConcurrentConsumers);
            return this;
        }
        /**
         * Specifies the maximum number of concurrent consumers for continue
         * routing when timeout occurred when using request/reply over JMS.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: producer
         * 
         * @param replyToOnTimeoutMaxConcurrentConsumers the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder replyToOnTimeoutMaxConcurrentConsumers(
                int replyToOnTimeoutMaxConcurrentConsumers) {
            doSetProperty("replyToOnTimeoutMaxConcurrentConsumers", replyToOnTimeoutMaxConcurrentConsumers);
            return this;
        }
        /**
         * Specifies the maximum number of concurrent consumers for continue
         * routing when timeout occurred when using request/reply over JMS.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: producer
         * 
         * @param replyToOnTimeoutMaxConcurrentConsumers the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder replyToOnTimeoutMaxConcurrentConsumers(
                String replyToOnTimeoutMaxConcurrentConsumers) {
            doSetProperty("replyToOnTimeoutMaxConcurrentConsumers", replyToOnTimeoutMaxConcurrentConsumers);
            return this;
        }
        /**
         * Provides an explicit ReplyTo destination in the JMS message, which
         * overrides the setting of replyTo. It is useful if you want to forward
         * the message to a remote Queue and receive the reply message from the
         * ReplyTo destination.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param replyToOverride the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder replyToOverride(
                String replyToOverride) {
            doSetProperty("replyToOverride", replyToOverride);
            return this;
        }
        /**
         * Allows for explicitly specifying which kind of strategy to use for
         * replyTo queues when doing request/reply over JMS. Possible values
         * are: Temporary, Shared, or Exclusive. By default Camel will use
         * temporary queues. However if replyTo has been configured, then Shared
         * is used by default. This option allows you to use exclusive queues
         * instead of shared ones. See Camel JMS documentation for more details,
         * and especially the notes about the implications if running in a
         * clustered environment, and the fact that Shared reply queues has
         * lower performance than its alternatives Temporary and Exclusive.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.jms.ReplyToType&lt;/code&gt;
         * type.
         * 
         * Group: producer
         * 
         * @param replyToType the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder replyToType(
                org.apache.camel.component.jms.ReplyToType replyToType) {
            doSetProperty("replyToType", replyToType);
            return this;
        }
        /**
         * Allows for explicitly specifying which kind of strategy to use for
         * replyTo queues when doing request/reply over JMS. Possible values
         * are: Temporary, Shared, or Exclusive. By default Camel will use
         * temporary queues. However if replyTo has been configured, then Shared
         * is used by default. This option allows you to use exclusive queues
         * instead of shared ones. See Camel JMS documentation for more details,
         * and especially the notes about the implications if running in a
         * clustered environment, and the fact that Shared reply queues has
         * lower performance than its alternatives Temporary and Exclusive.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.jms.ReplyToType&lt;/code&gt;
         * type.
         * 
         * Group: producer
         * 
         * @param replyToType the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder replyToType(String replyToType) {
            doSetProperty("replyToType", replyToType);
            return this;
        }
        /**
         * The timeout for waiting for a reply when using the InOut Exchange
         * Pattern (in milliseconds). The default is 20 seconds. You can include
         * the header CamelJmsRequestTimeout to override this endpoint
         * configured timeout value, and thus have per message individual
         * timeout values. See also the requestTimeoutCheckerInterval option.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 20000
         * Group: producer
         * 
         * @param requestTimeout the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder requestTimeout(long requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * The timeout for waiting for a reply when using the InOut Exchange
         * Pattern (in milliseconds). The default is 20 seconds. You can include
         * the header CamelJmsRequestTimeout to override this endpoint
         * configured timeout value, and thus have per message individual
         * timeout values. See also the requestTimeoutCheckerInterval option.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 20000
         * Group: producer
         * 
         * @param requestTimeout the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder requestTimeout(String requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * When sending messages, specifies the time-to-live of the message (in
         * milliseconds).
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: producer
         * 
         * @param timeToLive the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder timeToLive(long timeToLive) {
            doSetProperty("timeToLive", timeToLive);
            return this;
        }
        /**
         * When sending messages, specifies the time-to-live of the message (in
         * milliseconds).
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: producer
         * 
         * @param timeToLive the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder timeToLive(String timeToLive) {
            doSetProperty("timeToLive", timeToLive);
            return this;
        }
        /**
         * Password to use with the ConnectionFactory. You can also configure
         * username/password directly on the ConnectionFactory.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Username to use with the ConnectionFactory. You can also configure
         * username/password directly on the ConnectionFactory.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
        /**
         * Specifies whether to use transacted mode.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: transaction
         * 
         * @param transacted the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder transacted(boolean transacted) {
            doSetProperty("transacted", transacted);
            return this;
        }
        /**
         * Specifies whether to use transacted mode.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: transaction
         * 
         * @param transacted the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder transacted(String transacted) {
            doSetProperty("transacted", transacted);
            return this;
        }
        /**
         * Specifies whether InOut operations (request reply) default to using
         * transacted mode If this flag is set to true, then Spring JmsTemplate
         * will have sessionTransacted set to true, and the acknowledgeMode as
         * transacted on the JmsTemplate used for InOut operations. Note from
         * Spring JMS: that within a JTA transaction, the parameters passed to
         * createQueue, createTopic methods are not taken into account.
         * Depending on the Java EE transaction context, the container makes its
         * own decisions on these values. Analogously, these parameters are not
         * taken into account within a locally managed transaction either, since
         * Spring JMS operates on an existing JMS Session in this case. Setting
         * this flag to true will use a short local JMS transaction when running
         * outside of a managed transaction, and a synchronized local JMS
         * transaction in case of a managed transaction (other than an XA
         * transaction) being present. This has the effect of a local JMS
         * transaction being managed alongside the main transaction (which might
         * be a native JDBC transaction), with the JMS transaction committing
         * right after the main transaction.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: transaction
         * 
         * @param transactedInOut the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder transactedInOut(
                boolean transactedInOut) {
            doSetProperty("transactedInOut", transactedInOut);
            return this;
        }
        /**
         * Specifies whether InOut operations (request reply) default to using
         * transacted mode If this flag is set to true, then Spring JmsTemplate
         * will have sessionTransacted set to true, and the acknowledgeMode as
         * transacted on the JmsTemplate used for InOut operations. Note from
         * Spring JMS: that within a JTA transaction, the parameters passed to
         * createQueue, createTopic methods are not taken into account.
         * Depending on the Java EE transaction context, the container makes its
         * own decisions on these values. Analogously, these parameters are not
         * taken into account within a locally managed transaction either, since
         * Spring JMS operates on an existing JMS Session in this case. Setting
         * this flag to true will use a short local JMS transaction when running
         * outside of a managed transaction, and a synchronized local JMS
         * transaction in case of a managed transaction (other than an XA
         * transaction) being present. This has the effect of a local JMS
         * transaction being managed alongside the main transaction (which might
         * be a native JDBC transaction), with the JMS transaction committing
         * right after the main transaction.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: transaction
         * 
         * @param transactedInOut the value to set
         * @return the dsl builder
         */
        default AMQPEndpointProducerBuilder transactedInOut(
                String transactedInOut) {
            doSetProperty("transactedInOut", transactedInOut);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the AMQP component.
     */
    public interface AdvancedAMQPEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AMQPEndpointProducerBuilder basic() {
            return (AMQPEndpointProducerBuilder) this;
        }
        /**
         * This option is used to allow additional headers which may have values
         * that are invalid according to JMS specification. For example, some
         * message systems, such as WMQ, do this with header names using prefix
         * JMS_IBM_MQMD_ containing values with byte array or other invalid
         * types. You can specify multiple header names separated by comma, and
         * use as suffix for wildcard matching.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer (advanced)
         * 
         * @param allowAdditionalHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder allowAdditionalHeaders(
                String allowAdditionalHeaders) {
            doSetProperty("allowAdditionalHeaders", allowAdditionalHeaders);
            return this;
        }
        /**
         * Whether to allow sending messages with no body. If this option is
         * false and the message body is null, then an JMSException is thrown.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param allowNullBody the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder allowNullBody(
                boolean allowNullBody) {
            doSetProperty("allowNullBody", allowNullBody);
            return this;
        }
        /**
         * Whether to allow sending messages with no body. If this option is
         * false and the message body is null, then an JMSException is thrown.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: producer (advanced)
         * 
         * @param allowNullBody the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder allowNullBody(
                String allowNullBody) {
            doSetProperty("allowNullBody", allowNullBody);
            return this;
        }
        /**
         * If true, Camel will always make a JMS message copy of the message
         * when it is passed to the producer for sending. Copying the message is
         * needed in some situations, such as when a
         * replyToDestinationSelectorName is set (incidentally, Camel will set
         * the alwaysCopyMessage option to true, if a
         * replyToDestinationSelectorName is set).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param alwaysCopyMessage the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder alwaysCopyMessage(
                boolean alwaysCopyMessage) {
            doSetProperty("alwaysCopyMessage", alwaysCopyMessage);
            return this;
        }
        /**
         * If true, Camel will always make a JMS message copy of the message
         * when it is passed to the producer for sending. Copying the message is
         * needed in some situations, such as when a
         * replyToDestinationSelectorName is set (incidentally, Camel will set
         * the alwaysCopyMessage option to true, if a
         * replyToDestinationSelectorName is set).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param alwaysCopyMessage the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder alwaysCopyMessage(
                String alwaysCopyMessage) {
            doSetProperty("alwaysCopyMessage", alwaysCopyMessage);
            return this;
        }
        /**
         * When using InOut exchange pattern use this JMS property instead of
         * JMSCorrelationID JMS property to correlate messages. If set messages
         * will be correlated solely on the value of this property
         * JMSCorrelationID property will be ignored and not set by Camel.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer (advanced)
         * 
         * @param correlationProperty the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder correlationProperty(
                String correlationProperty) {
            doSetProperty("correlationProperty", correlationProperty);
            return this;
        }
        /**
         * Use this option to force disabling time to live. For example when you
         * do request/reply over JMS, then Camel will by default use the
         * requestTimeout value as time to live on the message being sent. The
         * problem is that the sender and receiver systems have to have their
         * clocks synchronized, so they are in sync. This is not always so easy
         * to archive. So you can use disableTimeToLive=true to not set a time
         * to live value on the sent message. Then the message will not expire
         * on the receiver system. See below in section About time to live for
         * more details.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param disableTimeToLive the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder disableTimeToLive(
                boolean disableTimeToLive) {
            doSetProperty("disableTimeToLive", disableTimeToLive);
            return this;
        }
        /**
         * Use this option to force disabling time to live. For example when you
         * do request/reply over JMS, then Camel will by default use the
         * requestTimeout value as time to live on the message being sent. The
         * problem is that the sender and receiver systems have to have their
         * clocks synchronized, so they are in sync. This is not always so easy
         * to archive. So you can use disableTimeToLive=true to not set a time
         * to live value on the sent message. Then the message will not expire
         * on the receiver system. See below in section About time to live for
         * more details.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param disableTimeToLive the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder disableTimeToLive(
                String disableTimeToLive) {
            doSetProperty("disableTimeToLive", disableTimeToLive);
            return this;
        }
        /**
         * When using mapJmsMessage=false Camel will create a new JMS message to
         * send to a new JMS destination if you touch the headers (get or set)
         * during the route. Set this option to true to force Camel to send the
         * original JMS message that was received.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param forceSendOriginalMessage the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder forceSendOriginalMessage(
                boolean forceSendOriginalMessage) {
            doSetProperty("forceSendOriginalMessage", forceSendOriginalMessage);
            return this;
        }
        /**
         * When using mapJmsMessage=false Camel will create a new JMS message to
         * send to a new JMS destination if you touch the headers (get or set)
         * during the route. Set this option to true to force Camel to send the
         * original JMS message that was received.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param forceSendOriginalMessage the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder forceSendOriginalMessage(
                String forceSendOriginalMessage) {
            doSetProperty("forceSendOriginalMessage", forceSendOriginalMessage);
            return this;
        }
        /**
         * Only applicable when sending to JMS destination using InOnly (eg fire
         * and forget). Enabling this option will enrich the Camel Exchange with
         * the actual JMSMessageID that was used by the JMS client when the
         * message was sent to the JMS destination.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param includeSentJMSMessageID the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder includeSentJMSMessageID(
                boolean includeSentJMSMessageID) {
            doSetProperty("includeSentJMSMessageID", includeSentJMSMessageID);
            return this;
        }
        /**
         * Only applicable when sending to JMS destination using InOnly (eg fire
         * and forget). Enabling this option will enrich the Camel Exchange with
         * the actual JMSMessageID that was used by the JMS client when the
         * message was sent to the JMS destination.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param includeSentJMSMessageID the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder includeSentJMSMessageID(
                String includeSentJMSMessageID) {
            doSetProperty("includeSentJMSMessageID", includeSentJMSMessageID);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Sets the cache level by name for the reply consumer when doing
         * request/reply over JMS. This option only applies when using fixed
         * reply queues (not temporary). Camel will by default use:
         * CACHE_CONSUMER for exclusive or shared w/ replyToSelectorName. And
         * CACHE_SESSION for shared without replyToSelectorName. Some JMS
         * brokers such as IBM WebSphere may require to set the
         * replyToCacheLevelName=CACHE_NONE to work. Note: If using temporary
         * queues then CACHE_NONE is not allowed, and you must use a higher
         * value such as CACHE_CONSUMER or CACHE_SESSION.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer (advanced)
         * 
         * @param replyToCacheLevelName the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder replyToCacheLevelName(
                String replyToCacheLevelName) {
            doSetProperty("replyToCacheLevelName", replyToCacheLevelName);
            return this;
        }
        /**
         * Sets the JMS Selector using the fixed name to be used so you can
         * filter out your own replies from the others when using a shared queue
         * (that is, if you are not using a temporary reply queue).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer (advanced)
         * 
         * @param replyToDestinationSelectorName the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder replyToDestinationSelectorName(
                String replyToDestinationSelectorName) {
            doSetProperty("replyToDestinationSelectorName", replyToDestinationSelectorName);
            return this;
        }
        /**
         * Sets whether StreamMessage type is enabled or not. Message payloads
         * of streaming kind such as files, InputStream, etc will either by sent
         * as BytesMessage or StreamMessage. This option controls which kind
         * will be used. By default BytesMessage is used which enforces the
         * entire message payload to be read into memory. By enabling this
         * option the message payload is read into memory in chunks and each
         * chunk is then written to the StreamMessage until no more data.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param streamMessageTypeEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder streamMessageTypeEnabled(
                boolean streamMessageTypeEnabled) {
            doSetProperty("streamMessageTypeEnabled", streamMessageTypeEnabled);
            return this;
        }
        /**
         * Sets whether StreamMessage type is enabled or not. Message payloads
         * of streaming kind such as files, InputStream, etc will either by sent
         * as BytesMessage or StreamMessage. This option controls which kind
         * will be used. By default BytesMessage is used which enforces the
         * entire message payload to be read into memory. By enabling this
         * option the message payload is read into memory in chunks and each
         * chunk is then written to the StreamMessage until no more data.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param streamMessageTypeEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder streamMessageTypeEnabled(
                String streamMessageTypeEnabled) {
            doSetProperty("streamMessageTypeEnabled", streamMessageTypeEnabled);
            return this;
        }
        /**
         * Controls whether or not to include serialized headers. Applies only
         * when transferExchange is true. This requires that the objects are
         * serializable. Camel will exclude any non-serializable objects and log
         * it at WARN level.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param allowSerializedHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder allowSerializedHeaders(
                boolean allowSerializedHeaders) {
            doSetProperty("allowSerializedHeaders", allowSerializedHeaders);
            return this;
        }
        /**
         * Controls whether or not to include serialized headers. Applies only
         * when transferExchange is true. This requires that the objects are
         * serializable. Camel will exclude any non-serializable objects and log
         * it at WARN level.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param allowSerializedHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder allowSerializedHeaders(
                String allowSerializedHeaders) {
            doSetProperty("allowSerializedHeaders", allowSerializedHeaders);
            return this;
        }
        /**
         * Whether optimizing for Apache Artemis streaming mode. This can reduce
         * memory overhead when using Artemis with JMS StreamMessage types. This
         * option must only be enabled if Apache Artemis is being used.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param artemisStreamingEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder artemisStreamingEnabled(
                boolean artemisStreamingEnabled) {
            doSetProperty("artemisStreamingEnabled", artemisStreamingEnabled);
            return this;
        }
        /**
         * Whether optimizing for Apache Artemis streaming mode. This can reduce
         * memory overhead when using Artemis with JMS StreamMessage types. This
         * option must only be enabled if Apache Artemis is being used.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param artemisStreamingEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder artemisStreamingEnabled(
                String artemisStreamingEnabled) {
            doSetProperty("artemisStreamingEnabled", artemisStreamingEnabled);
            return this;
        }
        /**
         * Whether to startup the JmsConsumer message listener asynchronously,
         * when starting a route. For example if a JmsConsumer cannot get a
         * connection to a remote JMS broker, then it may block while retrying
         * and/or fail-over. This will cause Camel to block while starting
         * routes. By setting this option to true, you will let routes startup,
         * while the JmsConsumer connects to the JMS broker using a dedicated
         * thread in asynchronous mode. If this option is used, then beware that
         * if the connection could not be established, then an exception is
         * logged at WARN level, and the consumer will not be able to receive
         * messages; You can then restart the route to retry.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStartListener the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder asyncStartListener(
                boolean asyncStartListener) {
            doSetProperty("asyncStartListener", asyncStartListener);
            return this;
        }
        /**
         * Whether to startup the JmsConsumer message listener asynchronously,
         * when starting a route. For example if a JmsConsumer cannot get a
         * connection to a remote JMS broker, then it may block while retrying
         * and/or fail-over. This will cause Camel to block while starting
         * routes. By setting this option to true, you will let routes startup,
         * while the JmsConsumer connects to the JMS broker using a dedicated
         * thread in asynchronous mode. If this option is used, then beware that
         * if the connection could not be established, then an exception is
         * logged at WARN level, and the consumer will not be able to receive
         * messages; You can then restart the route to retry.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStartListener the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder asyncStartListener(
                String asyncStartListener) {
            doSetProperty("asyncStartListener", asyncStartListener);
            return this;
        }
        /**
         * Whether to stop the JmsConsumer message listener asynchronously, when
         * stopping a route.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStopListener the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder asyncStopListener(
                boolean asyncStopListener) {
            doSetProperty("asyncStopListener", asyncStopListener);
            return this;
        }
        /**
         * Whether to stop the JmsConsumer message listener asynchronously, when
         * stopping a route.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStopListener the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder asyncStopListener(
                String asyncStopListener) {
            doSetProperty("asyncStopListener", asyncStopListener);
            return this;
        }
        /**
         * A pluggable
         * org.springframework.jms.support.destination.DestinationResolver that
         * allows you to use your own resolver (for example, to lookup the real
         * destination in a JNDI registry).
         * 
         * The option is a:
         * &lt;code&gt;org.springframework.jms.support.destination.DestinationResolver&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param destinationResolver the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder destinationResolver(
                org.springframework.jms.support.destination.DestinationResolver destinationResolver) {
            doSetProperty("destinationResolver", destinationResolver);
            return this;
        }
        /**
         * A pluggable
         * org.springframework.jms.support.destination.DestinationResolver that
         * allows you to use your own resolver (for example, to lookup the real
         * destination in a JNDI registry).
         * 
         * The option will be converted to a
         * &lt;code&gt;org.springframework.jms.support.destination.DestinationResolver&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param destinationResolver the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder destinationResolver(
                String destinationResolver) {
            doSetProperty("destinationResolver", destinationResolver);
            return this;
        }
        /**
         * Specifies a org.springframework.util.ErrorHandler to be invoked in
         * case of any uncaught exceptions thrown while processing a Message. By
         * default these exceptions will be logged at the WARN level, if no
         * errorHandler has been configured. You can configure logging level and
         * whether stack traces should be logged using errorHandlerLoggingLevel
         * and errorHandlerLogStackTrace options. This makes it much easier to
         * configure, than having to code a custom errorHandler.
         * 
         * The option is a:
         * &lt;code&gt;org.springframework.util.ErrorHandler&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param errorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder errorHandler(
                org.springframework.util.ErrorHandler errorHandler) {
            doSetProperty("errorHandler", errorHandler);
            return this;
        }
        /**
         * Specifies a org.springframework.util.ErrorHandler to be invoked in
         * case of any uncaught exceptions thrown while processing a Message. By
         * default these exceptions will be logged at the WARN level, if no
         * errorHandler has been configured. You can configure logging level and
         * whether stack traces should be logged using errorHandlerLoggingLevel
         * and errorHandlerLogStackTrace options. This makes it much easier to
         * configure, than having to code a custom errorHandler.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.springframework.util.ErrorHandler&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param errorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder errorHandler(
                String errorHandler) {
            doSetProperty("errorHandler", errorHandler);
            return this;
        }
        /**
         * Specifies the JMS Exception Listener that is to be notified of any
         * underlying JMS exceptions.
         * 
         * The option is a:
         * &lt;code&gt;jakarta.jms.ExceptionListener&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param exceptionListener the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder exceptionListener(
                jakarta.jms.ExceptionListener exceptionListener) {
            doSetProperty("exceptionListener", exceptionListener);
            return this;
        }
        /**
         * Specifies the JMS Exception Listener that is to be notified of any
         * underlying JMS exceptions.
         * 
         * The option will be converted to a
         * &lt;code&gt;jakarta.jms.ExceptionListener&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param exceptionListener the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder exceptionListener(
                String exceptionListener) {
            doSetProperty("exceptionListener", exceptionListener);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder headerFilterStrategy(
                org.apache.camel.spi.HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Specify the limit for the number of consumers that are allowed to be
         * idle at any given time.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: advanced
         * 
         * @param idleConsumerLimit the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder idleConsumerLimit(
                int idleConsumerLimit) {
            doSetProperty("idleConsumerLimit", idleConsumerLimit);
            return this;
        }
        /**
         * Specify the limit for the number of consumers that are allowed to be
         * idle at any given time.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: advanced
         * 
         * @param idleConsumerLimit the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder idleConsumerLimit(
                String idleConsumerLimit) {
            doSetProperty("idleConsumerLimit", idleConsumerLimit);
            return this;
        }
        /**
         * Specifies the limit for idle executions of a receive task, not having
         * received any message within its execution. If this limit is reached,
         * the task will shut down and leave receiving to other executing tasks
         * (in the case of dynamic scheduling; see the maxConcurrentConsumers
         * setting). There is additional doc available from Spring.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: advanced
         * 
         * @param idleTaskExecutionLimit the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder idleTaskExecutionLimit(
                int idleTaskExecutionLimit) {
            doSetProperty("idleTaskExecutionLimit", idleTaskExecutionLimit);
            return this;
        }
        /**
         * Specifies the limit for idle executions of a receive task, not having
         * received any message within its execution. If this limit is reached,
         * the task will shut down and leave receiving to other executing tasks
         * (in the case of dynamic scheduling; see the maxConcurrentConsumers
         * setting). There is additional doc available from Spring.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: advanced
         * 
         * @param idleTaskExecutionLimit the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder idleTaskExecutionLimit(
                String idleTaskExecutionLimit) {
            doSetProperty("idleTaskExecutionLimit", idleTaskExecutionLimit);
            return this;
        }
        /**
         * Whether to include all JMSX prefixed properties when mapping from JMS
         * to Camel Message. Setting this to true will include properties such
         * as JMSXAppID, and JMSXUserID etc. Note: If you are using a custom
         * headerFilterStrategy then this option does not apply.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param includeAllJMSXProperties the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder includeAllJMSXProperties(
                boolean includeAllJMSXProperties) {
            doSetProperty("includeAllJMSXProperties", includeAllJMSXProperties);
            return this;
        }
        /**
         * Whether to include all JMSX prefixed properties when mapping from JMS
         * to Camel Message. Setting this to true will include properties such
         * as JMSXAppID, and JMSXUserID etc. Note: If you are using a custom
         * headerFilterStrategy then this option does not apply.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param includeAllJMSXProperties the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder includeAllJMSXProperties(
                String includeAllJMSXProperties) {
            doSetProperty("includeAllJMSXProperties", includeAllJMSXProperties);
            return this;
        }
        /**
         * Pluggable strategy for encoding and decoding JMS keys so they can be
         * compliant with the JMS specification. Camel provides two
         * implementations out of the box: default and passthrough. The default
         * strategy will safely marshal dots and hyphens (. and -). The
         * passthrough strategy leaves the key as is. Can be used for JMS
         * brokers which do not care whether JMS header keys contain illegal
         * characters. You can provide your own implementation of the
         * org.apache.camel.component.jms.JmsKeyFormatStrategy and refer to it
         * using the # notation.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.jms.JmsKeyFormatStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param jmsKeyFormatStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder jmsKeyFormatStrategy(
                org.apache.camel.component.jms.JmsKeyFormatStrategy jmsKeyFormatStrategy) {
            doSetProperty("jmsKeyFormatStrategy", jmsKeyFormatStrategy);
            return this;
        }
        /**
         * Pluggable strategy for encoding and decoding JMS keys so they can be
         * compliant with the JMS specification. Camel provides two
         * implementations out of the box: default and passthrough. The default
         * strategy will safely marshal dots and hyphens (. and -). The
         * passthrough strategy leaves the key as is. Can be used for JMS
         * brokers which do not care whether JMS header keys contain illegal
         * characters. You can provide your own implementation of the
         * org.apache.camel.component.jms.JmsKeyFormatStrategy and refer to it
         * using the # notation.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.jms.JmsKeyFormatStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param jmsKeyFormatStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder jmsKeyFormatStrategy(
                String jmsKeyFormatStrategy) {
            doSetProperty("jmsKeyFormatStrategy", jmsKeyFormatStrategy);
            return this;
        }
        /**
         * Specifies whether Camel should auto map the received JMS message to a
         * suited payload type, such as jakarta.jms.TextMessage to a String etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param mapJmsMessage the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder mapJmsMessage(
                boolean mapJmsMessage) {
            doSetProperty("mapJmsMessage", mapJmsMessage);
            return this;
        }
        /**
         * Specifies whether Camel should auto map the received JMS message to a
         * suited payload type, such as jakarta.jms.TextMessage to a String etc.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param mapJmsMessage the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder mapJmsMessage(
                String mapJmsMessage) {
            doSetProperty("mapJmsMessage", mapJmsMessage);
            return this;
        }
        /**
         * The number of messages per task. -1 is unlimited. If you use a range
         * for concurrent consumers (eg min max), then this option can be used
         * to set a value to eg 100 to control how fast the consumers will
         * shrink when less work is required.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: advanced
         * 
         * @param maxMessagesPerTask the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder maxMessagesPerTask(
                int maxMessagesPerTask) {
            doSetProperty("maxMessagesPerTask", maxMessagesPerTask);
            return this;
        }
        /**
         * The number of messages per task. -1 is unlimited. If you use a range
         * for concurrent consumers (eg min max), then this option can be used
         * to set a value to eg 100 to control how fast the consumers will
         * shrink when less work is required.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: advanced
         * 
         * @param maxMessagesPerTask the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder maxMessagesPerTask(
                String maxMessagesPerTask) {
            doSetProperty("maxMessagesPerTask", maxMessagesPerTask);
            return this;
        }
        /**
         * To use a custom Spring
         * org.springframework.jms.support.converter.MessageConverter so you can
         * be in control how to map to/from a jakarta.jms.Message.
         * 
         * The option is a:
         * &lt;code&gt;org.springframework.jms.support.converter.MessageConverter&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageConverter the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder messageConverter(
                org.springframework.jms.support.converter.MessageConverter messageConverter) {
            doSetProperty("messageConverter", messageConverter);
            return this;
        }
        /**
         * To use a custom Spring
         * org.springframework.jms.support.converter.MessageConverter so you can
         * be in control how to map to/from a jakarta.jms.Message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.springframework.jms.support.converter.MessageConverter&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageConverter the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder messageConverter(
                String messageConverter) {
            doSetProperty("messageConverter", messageConverter);
            return this;
        }
        /**
         * To use the given MessageCreatedStrategy which are invoked when Camel
         * creates new instances of jakarta.jms.Message objects when Camel is
         * sending a JMS message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.jms.MessageCreatedStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageCreatedStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder messageCreatedStrategy(
                org.apache.camel.component.jms.MessageCreatedStrategy messageCreatedStrategy) {
            doSetProperty("messageCreatedStrategy", messageCreatedStrategy);
            return this;
        }
        /**
         * To use the given MessageCreatedStrategy which are invoked when Camel
         * creates new instances of jakarta.jms.Message objects when Camel is
         * sending a JMS message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.jms.MessageCreatedStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageCreatedStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder messageCreatedStrategy(
                String messageCreatedStrategy) {
            doSetProperty("messageCreatedStrategy", messageCreatedStrategy);
            return this;
        }
        /**
         * When sending, specifies whether message IDs should be added. This is
         * just an hint to the JMS broker. If the JMS provider accepts this
         * hint, these messages must have the message ID set to null; if the
         * provider ignores the hint, the message ID must be set to its normal
         * unique value.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param messageIdEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder messageIdEnabled(
                boolean messageIdEnabled) {
            doSetProperty("messageIdEnabled", messageIdEnabled);
            return this;
        }
        /**
         * When sending, specifies whether message IDs should be added. This is
         * just an hint to the JMS broker. If the JMS provider accepts this
         * hint, these messages must have the message ID set to null; if the
         * provider ignores the hint, the message ID must be set to its normal
         * unique value.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param messageIdEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder messageIdEnabled(
                String messageIdEnabled) {
            doSetProperty("messageIdEnabled", messageIdEnabled);
            return this;
        }
        /**
         * Registry ID of the MessageListenerContainerFactory used to determine
         * what
         * org.springframework.jms.listener.AbstractMessageListenerContainer to
         * use to consume messages. Setting this will automatically set
         * consumerType to Custom.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.jms.MessageListenerContainerFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageListenerContainerFactory the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder messageListenerContainerFactory(
                org.apache.camel.component.jms.MessageListenerContainerFactory messageListenerContainerFactory) {
            doSetProperty("messageListenerContainerFactory", messageListenerContainerFactory);
            return this;
        }
        /**
         * Registry ID of the MessageListenerContainerFactory used to determine
         * what
         * org.springframework.jms.listener.AbstractMessageListenerContainer to
         * use to consume messages. Setting this will automatically set
         * consumerType to Custom.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.jms.MessageListenerContainerFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageListenerContainerFactory the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder messageListenerContainerFactory(
                String messageListenerContainerFactory) {
            doSetProperty("messageListenerContainerFactory", messageListenerContainerFactory);
            return this;
        }
        /**
         * Specifies whether timestamps should be enabled by default on sending
         * messages. This is just an hint to the JMS broker. If the JMS provider
         * accepts this hint, these messages must have the timestamp set to
         * zero; if the provider ignores the hint the timestamp must be set to
         * its normal value.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param messageTimestampEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder messageTimestampEnabled(
                boolean messageTimestampEnabled) {
            doSetProperty("messageTimestampEnabled", messageTimestampEnabled);
            return this;
        }
        /**
         * Specifies whether timestamps should be enabled by default on sending
         * messages. This is just an hint to the JMS broker. If the JMS provider
         * accepts this hint, these messages must have the timestamp set to
         * zero; if the provider ignores the hint the timestamp must be set to
         * its normal value.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param messageTimestampEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder messageTimestampEnabled(
                String messageTimestampEnabled) {
            doSetProperty("messageTimestampEnabled", messageTimestampEnabled);
            return this;
        }
        /**
         * Specifies whether to inhibit the delivery of messages published by
         * its own connection.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param pubSubNoLocal the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder pubSubNoLocal(
                boolean pubSubNoLocal) {
            doSetProperty("pubSubNoLocal", pubSubNoLocal);
            return this;
        }
        /**
         * Specifies whether to inhibit the delivery of messages published by
         * its own connection.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param pubSubNoLocal the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder pubSubNoLocal(
                String pubSubNoLocal) {
            doSetProperty("pubSubNoLocal", pubSubNoLocal);
            return this;
        }
        /**
         * The timeout for receiving messages (in milliseconds).
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param receiveTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder receiveTimeout(
                long receiveTimeout) {
            doSetProperty("receiveTimeout", receiveTimeout);
            return this;
        }
        /**
         * The timeout for receiving messages (in milliseconds).
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param receiveTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder receiveTimeout(
                String receiveTimeout) {
            doSetProperty("receiveTimeout", receiveTimeout);
            return this;
        }
        /**
         * Specifies the interval between recovery attempts, i.e. when a
         * connection is being refreshed, in milliseconds. The default is 5000
         * ms, that is, 5 seconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: advanced
         * 
         * @param recoveryInterval the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder recoveryInterval(
                long recoveryInterval) {
            doSetProperty("recoveryInterval", recoveryInterval);
            return this;
        }
        /**
         * Specifies the interval between recovery attempts, i.e. when a
         * connection is being refreshed, in milliseconds. The default is 5000
         * ms, that is, 5 seconds.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: advanced
         * 
         * @param recoveryInterval the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder recoveryInterval(
                String recoveryInterval) {
            doSetProperty("recoveryInterval", recoveryInterval);
            return this;
        }
        /**
         * Configures how often Camel should check for timed out Exchanges when
         * doing request/reply over JMS. By default Camel checks once per
         * second. But if you must react faster when a timeout occurs, then you
         * can lower this interval, to check more frequently. The timeout is
         * determined by the option requestTimeout.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param requestTimeoutCheckerInterval the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder requestTimeoutCheckerInterval(
                long requestTimeoutCheckerInterval) {
            doSetProperty("requestTimeoutCheckerInterval", requestTimeoutCheckerInterval);
            return this;
        }
        /**
         * Configures how often Camel should check for timed out Exchanges when
         * doing request/reply over JMS. By default Camel checks once per
         * second. But if you must react faster when a timeout occurs, then you
         * can lower this interval, to check more frequently. The timeout is
         * determined by the option requestTimeout.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param requestTimeoutCheckerInterval the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder requestTimeoutCheckerInterval(
                String requestTimeoutCheckerInterval) {
            doSetProperty("requestTimeoutCheckerInterval", requestTimeoutCheckerInterval);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * If enabled and you are using Request Reply messaging (InOut) and an
         * Exchange failed on the consumer side, then the caused Exception will
         * be send back in response as a jakarta.jms.ObjectMessage. If the
         * client is Camel, the returned Exception is rethrown. This allows you
         * to use Camel JMS as a bridge in your routing - for example, using
         * persistent queues to enable robust routing. Notice that if you also
         * have transferExchange enabled, this option takes precedence. The
         * caught exception is required to be serializable. The original
         * Exception on the consumer side can be wrapped in an outer exception
         * such as org.apache.camel.RuntimeCamelException when returned to the
         * producer. Use this with caution as the data is using Java Object
         * serialization and requires the received to be able to deserialize the
         * data at Class level, which forces a strong coupling between the
         * producers and consumer!.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferException the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder transferException(
                boolean transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * If enabled and you are using Request Reply messaging (InOut) and an
         * Exchange failed on the consumer side, then the caused Exception will
         * be send back in response as a jakarta.jms.ObjectMessage. If the
         * client is Camel, the returned Exception is rethrown. This allows you
         * to use Camel JMS as a bridge in your routing - for example, using
         * persistent queues to enable robust routing. Notice that if you also
         * have transferExchange enabled, this option takes precedence. The
         * caught exception is required to be serializable. The original
         * Exception on the consumer side can be wrapped in an outer exception
         * such as org.apache.camel.RuntimeCamelException when returned to the
         * producer. Use this with caution as the data is using Java Object
         * serialization and requires the received to be able to deserialize the
         * data at Class level, which forces a strong coupling between the
         * producers and consumer!.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferException the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder transferException(
                String transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * You can transfer the exchange over the wire instead of just the body
         * and headers. The following fields are transferred: In body, Out body,
         * Fault body, In headers, Out headers, Fault headers, exchange
         * properties, exchange exception. This requires that the objects are
         * serializable. Camel will exclude any non-serializable objects and log
         * it at WARN level. You must enable this option on both the producer
         * and consumer side, so Camel knows the payloads is an Exchange and not
         * a regular payload. Use this with caution as the data is using Java
         * Object serialization and requires the receiver to be able to
         * deserialize the data at Class level, which forces a strong coupling
         * between the producers and consumers having to use compatible Camel
         * versions!.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferExchange the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder transferExchange(
                boolean transferExchange) {
            doSetProperty("transferExchange", transferExchange);
            return this;
        }
        /**
         * You can transfer the exchange over the wire instead of just the body
         * and headers. The following fields are transferred: In body, Out body,
         * Fault body, In headers, Out headers, Fault headers, exchange
         * properties, exchange exception. This requires that the objects are
         * serializable. Camel will exclude any non-serializable objects and log
         * it at WARN level. You must enable this option on both the producer
         * and consumer side, so Camel knows the payloads is an Exchange and not
         * a regular payload. Use this with caution as the data is using Java
         * Object serialization and requires the receiver to be able to
         * deserialize the data at Class level, which forces a strong coupling
         * between the producers and consumers having to use compatible Camel
         * versions!.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferExchange the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder transferExchange(
                String transferExchange) {
            doSetProperty("transferExchange", transferExchange);
            return this;
        }
        /**
         * Specifies whether JMSMessageID should always be used as
         * JMSCorrelationID for InOut messages.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param useMessageIDAsCorrelationID the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder useMessageIDAsCorrelationID(
                boolean useMessageIDAsCorrelationID) {
            doSetProperty("useMessageIDAsCorrelationID", useMessageIDAsCorrelationID);
            return this;
        }
        /**
         * Specifies whether JMSMessageID should always be used as
         * JMSCorrelationID for InOut messages.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param useMessageIDAsCorrelationID the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder useMessageIDAsCorrelationID(
                String useMessageIDAsCorrelationID) {
            doSetProperty("useMessageIDAsCorrelationID", useMessageIDAsCorrelationID);
            return this;
        }
        /**
         * Number of times to wait for provisional correlation id to be updated
         * to the actual correlation id when doing request/reply over JMS and
         * when the option useMessageIDAsCorrelationID is enabled.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 50
         * Group: advanced
         * 
         * @param waitForProvisionCorrelationToBeUpdatedCounter the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder waitForProvisionCorrelationToBeUpdatedCounter(
                int waitForProvisionCorrelationToBeUpdatedCounter) {
            doSetProperty("waitForProvisionCorrelationToBeUpdatedCounter", waitForProvisionCorrelationToBeUpdatedCounter);
            return this;
        }
        /**
         * Number of times to wait for provisional correlation id to be updated
         * to the actual correlation id when doing request/reply over JMS and
         * when the option useMessageIDAsCorrelationID is enabled.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 50
         * Group: advanced
         * 
         * @param waitForProvisionCorrelationToBeUpdatedCounter the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder waitForProvisionCorrelationToBeUpdatedCounter(
                String waitForProvisionCorrelationToBeUpdatedCounter) {
            doSetProperty("waitForProvisionCorrelationToBeUpdatedCounter", waitForProvisionCorrelationToBeUpdatedCounter);
            return this;
        }
        /**
         * Interval in millis to sleep each time while waiting for provisional
         * correlation id to be updated.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: advanced
         * 
         * @param waitForProvisionCorrelationToBeUpdatedThreadSleepingTime the
         * value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder waitForProvisionCorrelationToBeUpdatedThreadSleepingTime(
                long waitForProvisionCorrelationToBeUpdatedThreadSleepingTime) {
            doSetProperty("waitForProvisionCorrelationToBeUpdatedThreadSleepingTime", waitForProvisionCorrelationToBeUpdatedThreadSleepingTime);
            return this;
        }
        /**
         * Interval in millis to sleep each time while waiting for provisional
         * correlation id to be updated.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: advanced
         * 
         * @param waitForProvisionCorrelationToBeUpdatedThreadSleepingTime the
         * value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder waitForProvisionCorrelationToBeUpdatedThreadSleepingTime(
                String waitForProvisionCorrelationToBeUpdatedThreadSleepingTime) {
            doSetProperty("waitForProvisionCorrelationToBeUpdatedThreadSleepingTime", waitForProvisionCorrelationToBeUpdatedThreadSleepingTime);
            return this;
        }
        /**
         * If true, Camel will create a JmsTransactionManager, if there is no
         * transactionManager injected when option transacted=true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: transaction (advanced)
         * 
         * @param lazyCreateTransactionManager the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder lazyCreateTransactionManager(
                boolean lazyCreateTransactionManager) {
            doSetProperty("lazyCreateTransactionManager", lazyCreateTransactionManager);
            return this;
        }
        /**
         * If true, Camel will create a JmsTransactionManager, if there is no
         * transactionManager injected when option transacted=true.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: transaction (advanced)
         * 
         * @param lazyCreateTransactionManager the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder lazyCreateTransactionManager(
                String lazyCreateTransactionManager) {
            doSetProperty("lazyCreateTransactionManager", lazyCreateTransactionManager);
            return this;
        }
        /**
         * The Spring transaction manager to use.
         * 
         * The option is a:
         * &lt;code&gt;org.springframework.transaction.PlatformTransactionManager&lt;/code&gt; type.
         * 
         * Group: transaction (advanced)
         * 
         * @param transactionManager the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder transactionManager(
                org.springframework.transaction.PlatformTransactionManager transactionManager) {
            doSetProperty("transactionManager", transactionManager);
            return this;
        }
        /**
         * The Spring transaction manager to use.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.springframework.transaction.PlatformTransactionManager&lt;/code&gt; type.
         * 
         * Group: transaction (advanced)
         * 
         * @param transactionManager the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder transactionManager(
                String transactionManager) {
            doSetProperty("transactionManager", transactionManager);
            return this;
        }
        /**
         * The name of the transaction to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: transaction (advanced)
         * 
         * @param transactionName the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder transactionName(
                String transactionName) {
            doSetProperty("transactionName", transactionName);
            return this;
        }
        /**
         * The timeout value of the transaction (in seconds), if using
         * transacted mode.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: transaction (advanced)
         * 
         * @param transactionTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder transactionTimeout(
                int transactionTimeout) {
            doSetProperty("transactionTimeout", transactionTimeout);
            return this;
        }
        /**
         * The timeout value of the transaction (in seconds), if using
         * transacted mode.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: transaction (advanced)
         * 
         * @param transactionTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointProducerBuilder transactionTimeout(
                String transactionTimeout) {
            doSetProperty("transactionTimeout", transactionTimeout);
            return this;
        }
    }

    /**
     * Builder for endpoint for the AMQP component.
     */
    public interface AMQPEndpointBuilder
            extends
                AMQPEndpointConsumerBuilder,
                AMQPEndpointProducerBuilder {
        default AdvancedAMQPEndpointBuilder advanced() {
            return (AdvancedAMQPEndpointBuilder) this;
        }
        /**
         * Sets the JMS client ID to use. Note that this value, if specified,
         * must be unique and can only be used by a single JMS connection
         * instance. It is typically only required for durable topic
         * subscriptions with JMS 1.1.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param clientId the value to set
         * @return the dsl builder
         */
        default AMQPEndpointBuilder clientId(String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
        /**
         * The connection factory to be use. A connection factory must be
         * configured either on the component or endpoint.
         * 
         * The option is a:
         * &lt;code&gt;jakarta.jms.ConnectionFactory&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param connectionFactory the value to set
         * @return the dsl builder
         */
        default AMQPEndpointBuilder connectionFactory(
                jakarta.jms.ConnectionFactory connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * The connection factory to be use. A connection factory must be
         * configured either on the component or endpoint.
         * 
         * The option will be converted to a
         * &lt;code&gt;jakarta.jms.ConnectionFactory&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param connectionFactory the value to set
         * @return the dsl builder
         */
        default AMQPEndpointBuilder connectionFactory(String connectionFactory) {
            doSetProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * Specifies whether Camel ignores the JMSReplyTo header in messages. If
         * true, Camel does not send a reply back to the destination specified
         * in the JMSReplyTo header. You can use this option if you want Camel
         * to consume from a route and you do not want Camel to automatically
         * send back a reply message because another component in your code
         * handles the reply message. You can also use this option if you want
         * to use Camel as a proxy between different message brokers and you
         * want to route message from one system to another.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disableReplyTo the value to set
         * @return the dsl builder
         */
        default AMQPEndpointBuilder disableReplyTo(boolean disableReplyTo) {
            doSetProperty("disableReplyTo", disableReplyTo);
            return this;
        }
        /**
         * Specifies whether Camel ignores the JMSReplyTo header in messages. If
         * true, Camel does not send a reply back to the destination specified
         * in the JMSReplyTo header. You can use this option if you want Camel
         * to consume from a route and you do not want Camel to automatically
         * send back a reply message because another component in your code
         * handles the reply message. You can also use this option if you want
         * to use Camel as a proxy between different message brokers and you
         * want to route message from one system to another.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param disableReplyTo the value to set
         * @return the dsl builder
         */
        default AMQPEndpointBuilder disableReplyTo(String disableReplyTo) {
            doSetProperty("disableReplyTo", disableReplyTo);
            return this;
        }
        /**
         * The durable subscriber name for specifying durable topic
         * subscriptions. The clientId option must be configured as well.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param durableSubscriptionName the value to set
         * @return the dsl builder
         */
        default AMQPEndpointBuilder durableSubscriptionName(
                String durableSubscriptionName) {
            doSetProperty("durableSubscriptionName", durableSubscriptionName);
            return this;
        }
        /**
         * Allows you to force the use of a specific jakarta.jms.Message
         * implementation for sending JMS messages. Possible values are: Bytes,
         * Map, Object, Stream, Text. By default, Camel would determine which
         * JMS message type to use from the In body type. This option allows you
         * to specify it.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.jms.JmsMessageType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param jmsMessageType the value to set
         * @return the dsl builder
         */
        default AMQPEndpointBuilder jmsMessageType(
                org.apache.camel.component.jms.JmsMessageType jmsMessageType) {
            doSetProperty("jmsMessageType", jmsMessageType);
            return this;
        }
        /**
         * Allows you to force the use of a specific jakarta.jms.Message
         * implementation for sending JMS messages. Possible values are: Bytes,
         * Map, Object, Stream, Text. By default, Camel would determine which
         * JMS message type to use from the In body type. This option allows you
         * to specify it.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.jms.JmsMessageType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param jmsMessageType the value to set
         * @return the dsl builder
         */
        default AMQPEndpointBuilder jmsMessageType(String jmsMessageType) {
            doSetProperty("jmsMessageType", jmsMessageType);
            return this;
        }
        /**
         * Provides an explicit ReplyTo destination (overrides any incoming
         * value of Message.getJMSReplyTo() in consumer).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param replyTo the value to set
         * @return the dsl builder
         */
        default AMQPEndpointBuilder replyTo(String replyTo) {
            doSetProperty("replyTo", replyTo);
            return this;
        }
        /**
         * Specifies whether to test the connection on startup. This ensures
         * that when Camel starts that all the JMS consumers have a valid
         * connection to the JMS broker. If a connection cannot be granted then
         * Camel throws an exception on startup. This ensures that Camel is not
         * started with failed connections. The JMS producers is tested as well.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param testConnectionOnStartup the value to set
         * @return the dsl builder
         */
        default AMQPEndpointBuilder testConnectionOnStartup(
                boolean testConnectionOnStartup) {
            doSetProperty("testConnectionOnStartup", testConnectionOnStartup);
            return this;
        }
        /**
         * Specifies whether to test the connection on startup. This ensures
         * that when Camel starts that all the JMS consumers have a valid
         * connection to the JMS broker. If a connection cannot be granted then
         * Camel throws an exception on startup. This ensures that Camel is not
         * started with failed connections. The JMS producers is tested as well.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param testConnectionOnStartup the value to set
         * @return the dsl builder
         */
        default AMQPEndpointBuilder testConnectionOnStartup(
                String testConnectionOnStartup) {
            doSetProperty("testConnectionOnStartup", testConnectionOnStartup);
            return this;
        }
        /**
         * Password to use with the ConnectionFactory. You can also configure
         * username/password directly on the ConnectionFactory.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default AMQPEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Username to use with the ConnectionFactory. You can also configure
         * username/password directly on the ConnectionFactory.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default AMQPEndpointBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
        /**
         * Specifies whether to use transacted mode.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: transaction
         * 
         * @param transacted the value to set
         * @return the dsl builder
         */
        default AMQPEndpointBuilder transacted(boolean transacted) {
            doSetProperty("transacted", transacted);
            return this;
        }
        /**
         * Specifies whether to use transacted mode.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: transaction
         * 
         * @param transacted the value to set
         * @return the dsl builder
         */
        default AMQPEndpointBuilder transacted(String transacted) {
            doSetProperty("transacted", transacted);
            return this;
        }
        /**
         * Specifies whether InOut operations (request reply) default to using
         * transacted mode If this flag is set to true, then Spring JmsTemplate
         * will have sessionTransacted set to true, and the acknowledgeMode as
         * transacted on the JmsTemplate used for InOut operations. Note from
         * Spring JMS: that within a JTA transaction, the parameters passed to
         * createQueue, createTopic methods are not taken into account.
         * Depending on the Java EE transaction context, the container makes its
         * own decisions on these values. Analogously, these parameters are not
         * taken into account within a locally managed transaction either, since
         * Spring JMS operates on an existing JMS Session in this case. Setting
         * this flag to true will use a short local JMS transaction when running
         * outside of a managed transaction, and a synchronized local JMS
         * transaction in case of a managed transaction (other than an XA
         * transaction) being present. This has the effect of a local JMS
         * transaction being managed alongside the main transaction (which might
         * be a native JDBC transaction), with the JMS transaction committing
         * right after the main transaction.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: transaction
         * 
         * @param transactedInOut the value to set
         * @return the dsl builder
         */
        default AMQPEndpointBuilder transactedInOut(boolean transactedInOut) {
            doSetProperty("transactedInOut", transactedInOut);
            return this;
        }
        /**
         * Specifies whether InOut operations (request reply) default to using
         * transacted mode If this flag is set to true, then Spring JmsTemplate
         * will have sessionTransacted set to true, and the acknowledgeMode as
         * transacted on the JmsTemplate used for InOut operations. Note from
         * Spring JMS: that within a JTA transaction, the parameters passed to
         * createQueue, createTopic methods are not taken into account.
         * Depending on the Java EE transaction context, the container makes its
         * own decisions on these values. Analogously, these parameters are not
         * taken into account within a locally managed transaction either, since
         * Spring JMS operates on an existing JMS Session in this case. Setting
         * this flag to true will use a short local JMS transaction when running
         * outside of a managed transaction, and a synchronized local JMS
         * transaction in case of a managed transaction (other than an XA
         * transaction) being present. This has the effect of a local JMS
         * transaction being managed alongside the main transaction (which might
         * be a native JDBC transaction), with the JMS transaction committing
         * right after the main transaction.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: transaction
         * 
         * @param transactedInOut the value to set
         * @return the dsl builder
         */
        default AMQPEndpointBuilder transactedInOut(String transactedInOut) {
            doSetProperty("transactedInOut", transactedInOut);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the AMQP component.
     */
    public interface AdvancedAMQPEndpointBuilder
            extends
                AdvancedAMQPEndpointConsumerBuilder,
                AdvancedAMQPEndpointProducerBuilder {
        default AMQPEndpointBuilder basic() {
            return (AMQPEndpointBuilder) this;
        }
        /**
         * Controls whether or not to include serialized headers. Applies only
         * when transferExchange is true. This requires that the objects are
         * serializable. Camel will exclude any non-serializable objects and log
         * it at WARN level.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param allowSerializedHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder allowSerializedHeaders(
                boolean allowSerializedHeaders) {
            doSetProperty("allowSerializedHeaders", allowSerializedHeaders);
            return this;
        }
        /**
         * Controls whether or not to include serialized headers. Applies only
         * when transferExchange is true. This requires that the objects are
         * serializable. Camel will exclude any non-serializable objects and log
         * it at WARN level.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param allowSerializedHeaders the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder allowSerializedHeaders(
                String allowSerializedHeaders) {
            doSetProperty("allowSerializedHeaders", allowSerializedHeaders);
            return this;
        }
        /**
         * Whether optimizing for Apache Artemis streaming mode. This can reduce
         * memory overhead when using Artemis with JMS StreamMessage types. This
         * option must only be enabled if Apache Artemis is being used.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param artemisStreamingEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder artemisStreamingEnabled(
                boolean artemisStreamingEnabled) {
            doSetProperty("artemisStreamingEnabled", artemisStreamingEnabled);
            return this;
        }
        /**
         * Whether optimizing for Apache Artemis streaming mode. This can reduce
         * memory overhead when using Artemis with JMS StreamMessage types. This
         * option must only be enabled if Apache Artemis is being used.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param artemisStreamingEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder artemisStreamingEnabled(
                String artemisStreamingEnabled) {
            doSetProperty("artemisStreamingEnabled", artemisStreamingEnabled);
            return this;
        }
        /**
         * Whether to startup the JmsConsumer message listener asynchronously,
         * when starting a route. For example if a JmsConsumer cannot get a
         * connection to a remote JMS broker, then it may block while retrying
         * and/or fail-over. This will cause Camel to block while starting
         * routes. By setting this option to true, you will let routes startup,
         * while the JmsConsumer connects to the JMS broker using a dedicated
         * thread in asynchronous mode. If this option is used, then beware that
         * if the connection could not be established, then an exception is
         * logged at WARN level, and the consumer will not be able to receive
         * messages; You can then restart the route to retry.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStartListener the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder asyncStartListener(
                boolean asyncStartListener) {
            doSetProperty("asyncStartListener", asyncStartListener);
            return this;
        }
        /**
         * Whether to startup the JmsConsumer message listener asynchronously,
         * when starting a route. For example if a JmsConsumer cannot get a
         * connection to a remote JMS broker, then it may block while retrying
         * and/or fail-over. This will cause Camel to block while starting
         * routes. By setting this option to true, you will let routes startup,
         * while the JmsConsumer connects to the JMS broker using a dedicated
         * thread in asynchronous mode. If this option is used, then beware that
         * if the connection could not be established, then an exception is
         * logged at WARN level, and the consumer will not be able to receive
         * messages; You can then restart the route to retry.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStartListener the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder asyncStartListener(
                String asyncStartListener) {
            doSetProperty("asyncStartListener", asyncStartListener);
            return this;
        }
        /**
         * Whether to stop the JmsConsumer message listener asynchronously, when
         * stopping a route.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStopListener the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder asyncStopListener(
                boolean asyncStopListener) {
            doSetProperty("asyncStopListener", asyncStopListener);
            return this;
        }
        /**
         * Whether to stop the JmsConsumer message listener asynchronously, when
         * stopping a route.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param asyncStopListener the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder asyncStopListener(
                String asyncStopListener) {
            doSetProperty("asyncStopListener", asyncStopListener);
            return this;
        }
        /**
         * A pluggable
         * org.springframework.jms.support.destination.DestinationResolver that
         * allows you to use your own resolver (for example, to lookup the real
         * destination in a JNDI registry).
         * 
         * The option is a:
         * &lt;code&gt;org.springframework.jms.support.destination.DestinationResolver&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param destinationResolver the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder destinationResolver(
                org.springframework.jms.support.destination.DestinationResolver destinationResolver) {
            doSetProperty("destinationResolver", destinationResolver);
            return this;
        }
        /**
         * A pluggable
         * org.springframework.jms.support.destination.DestinationResolver that
         * allows you to use your own resolver (for example, to lookup the real
         * destination in a JNDI registry).
         * 
         * The option will be converted to a
         * &lt;code&gt;org.springframework.jms.support.destination.DestinationResolver&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param destinationResolver the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder destinationResolver(
                String destinationResolver) {
            doSetProperty("destinationResolver", destinationResolver);
            return this;
        }
        /**
         * Specifies a org.springframework.util.ErrorHandler to be invoked in
         * case of any uncaught exceptions thrown while processing a Message. By
         * default these exceptions will be logged at the WARN level, if no
         * errorHandler has been configured. You can configure logging level and
         * whether stack traces should be logged using errorHandlerLoggingLevel
         * and errorHandlerLogStackTrace options. This makes it much easier to
         * configure, than having to code a custom errorHandler.
         * 
         * The option is a:
         * &lt;code&gt;org.springframework.util.ErrorHandler&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param errorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder errorHandler(
                org.springframework.util.ErrorHandler errorHandler) {
            doSetProperty("errorHandler", errorHandler);
            return this;
        }
        /**
         * Specifies a org.springframework.util.ErrorHandler to be invoked in
         * case of any uncaught exceptions thrown while processing a Message. By
         * default these exceptions will be logged at the WARN level, if no
         * errorHandler has been configured. You can configure logging level and
         * whether stack traces should be logged using errorHandlerLoggingLevel
         * and errorHandlerLogStackTrace options. This makes it much easier to
         * configure, than having to code a custom errorHandler.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.springframework.util.ErrorHandler&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param errorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder errorHandler(String errorHandler) {
            doSetProperty("errorHandler", errorHandler);
            return this;
        }
        /**
         * Specifies the JMS Exception Listener that is to be notified of any
         * underlying JMS exceptions.
         * 
         * The option is a:
         * &lt;code&gt;jakarta.jms.ExceptionListener&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param exceptionListener the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder exceptionListener(
                jakarta.jms.ExceptionListener exceptionListener) {
            doSetProperty("exceptionListener", exceptionListener);
            return this;
        }
        /**
         * Specifies the JMS Exception Listener that is to be notified of any
         * underlying JMS exceptions.
         * 
         * The option will be converted to a
         * &lt;code&gt;jakarta.jms.ExceptionListener&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param exceptionListener the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder exceptionListener(
                String exceptionListener) {
            doSetProperty("exceptionListener", exceptionListener);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder headerFilterStrategy(
                org.apache.camel.spi.HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Specify the limit for the number of consumers that are allowed to be
         * idle at any given time.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: advanced
         * 
         * @param idleConsumerLimit the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder idleConsumerLimit(
                int idleConsumerLimit) {
            doSetProperty("idleConsumerLimit", idleConsumerLimit);
            return this;
        }
        /**
         * Specify the limit for the number of consumers that are allowed to be
         * idle at any given time.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: advanced
         * 
         * @param idleConsumerLimit the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder idleConsumerLimit(
                String idleConsumerLimit) {
            doSetProperty("idleConsumerLimit", idleConsumerLimit);
            return this;
        }
        /**
         * Specifies the limit for idle executions of a receive task, not having
         * received any message within its execution. If this limit is reached,
         * the task will shut down and leave receiving to other executing tasks
         * (in the case of dynamic scheduling; see the maxConcurrentConsumers
         * setting). There is additional doc available from Spring.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: advanced
         * 
         * @param idleTaskExecutionLimit the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder idleTaskExecutionLimit(
                int idleTaskExecutionLimit) {
            doSetProperty("idleTaskExecutionLimit", idleTaskExecutionLimit);
            return this;
        }
        /**
         * Specifies the limit for idle executions of a receive task, not having
         * received any message within its execution. If this limit is reached,
         * the task will shut down and leave receiving to other executing tasks
         * (in the case of dynamic scheduling; see the maxConcurrentConsumers
         * setting). There is additional doc available from Spring.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: advanced
         * 
         * @param idleTaskExecutionLimit the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder idleTaskExecutionLimit(
                String idleTaskExecutionLimit) {
            doSetProperty("idleTaskExecutionLimit", idleTaskExecutionLimit);
            return this;
        }
        /**
         * Whether to include all JMSX prefixed properties when mapping from JMS
         * to Camel Message. Setting this to true will include properties such
         * as JMSXAppID, and JMSXUserID etc. Note: If you are using a custom
         * headerFilterStrategy then this option does not apply.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param includeAllJMSXProperties the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder includeAllJMSXProperties(
                boolean includeAllJMSXProperties) {
            doSetProperty("includeAllJMSXProperties", includeAllJMSXProperties);
            return this;
        }
        /**
         * Whether to include all JMSX prefixed properties when mapping from JMS
         * to Camel Message. Setting this to true will include properties such
         * as JMSXAppID, and JMSXUserID etc. Note: If you are using a custom
         * headerFilterStrategy then this option does not apply.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param includeAllJMSXProperties the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder includeAllJMSXProperties(
                String includeAllJMSXProperties) {
            doSetProperty("includeAllJMSXProperties", includeAllJMSXProperties);
            return this;
        }
        /**
         * Pluggable strategy for encoding and decoding JMS keys so they can be
         * compliant with the JMS specification. Camel provides two
         * implementations out of the box: default and passthrough. The default
         * strategy will safely marshal dots and hyphens (. and -). The
         * passthrough strategy leaves the key as is. Can be used for JMS
         * brokers which do not care whether JMS header keys contain illegal
         * characters. You can provide your own implementation of the
         * org.apache.camel.component.jms.JmsKeyFormatStrategy and refer to it
         * using the # notation.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.jms.JmsKeyFormatStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param jmsKeyFormatStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder jmsKeyFormatStrategy(
                org.apache.camel.component.jms.JmsKeyFormatStrategy jmsKeyFormatStrategy) {
            doSetProperty("jmsKeyFormatStrategy", jmsKeyFormatStrategy);
            return this;
        }
        /**
         * Pluggable strategy for encoding and decoding JMS keys so they can be
         * compliant with the JMS specification. Camel provides two
         * implementations out of the box: default and passthrough. The default
         * strategy will safely marshal dots and hyphens (. and -). The
         * passthrough strategy leaves the key as is. Can be used for JMS
         * brokers which do not care whether JMS header keys contain illegal
         * characters. You can provide your own implementation of the
         * org.apache.camel.component.jms.JmsKeyFormatStrategy and refer to it
         * using the # notation.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.jms.JmsKeyFormatStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param jmsKeyFormatStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder jmsKeyFormatStrategy(
                String jmsKeyFormatStrategy) {
            doSetProperty("jmsKeyFormatStrategy", jmsKeyFormatStrategy);
            return this;
        }
        /**
         * Specifies whether Camel should auto map the received JMS message to a
         * suited payload type, such as jakarta.jms.TextMessage to a String etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param mapJmsMessage the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder mapJmsMessage(boolean mapJmsMessage) {
            doSetProperty("mapJmsMessage", mapJmsMessage);
            return this;
        }
        /**
         * Specifies whether Camel should auto map the received JMS message to a
         * suited payload type, such as jakarta.jms.TextMessage to a String etc.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param mapJmsMessage the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder mapJmsMessage(String mapJmsMessage) {
            doSetProperty("mapJmsMessage", mapJmsMessage);
            return this;
        }
        /**
         * The number of messages per task. -1 is unlimited. If you use a range
         * for concurrent consumers (eg min max), then this option can be used
         * to set a value to eg 100 to control how fast the consumers will
         * shrink when less work is required.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: advanced
         * 
         * @param maxMessagesPerTask the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder maxMessagesPerTask(
                int maxMessagesPerTask) {
            doSetProperty("maxMessagesPerTask", maxMessagesPerTask);
            return this;
        }
        /**
         * The number of messages per task. -1 is unlimited. If you use a range
         * for concurrent consumers (eg min max), then this option can be used
         * to set a value to eg 100 to control how fast the consumers will
         * shrink when less work is required.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: advanced
         * 
         * @param maxMessagesPerTask the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder maxMessagesPerTask(
                String maxMessagesPerTask) {
            doSetProperty("maxMessagesPerTask", maxMessagesPerTask);
            return this;
        }
        /**
         * To use a custom Spring
         * org.springframework.jms.support.converter.MessageConverter so you can
         * be in control how to map to/from a jakarta.jms.Message.
         * 
         * The option is a:
         * &lt;code&gt;org.springframework.jms.support.converter.MessageConverter&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageConverter the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder messageConverter(
                org.springframework.jms.support.converter.MessageConverter messageConverter) {
            doSetProperty("messageConverter", messageConverter);
            return this;
        }
        /**
         * To use a custom Spring
         * org.springframework.jms.support.converter.MessageConverter so you can
         * be in control how to map to/from a jakarta.jms.Message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.springframework.jms.support.converter.MessageConverter&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageConverter the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder messageConverter(
                String messageConverter) {
            doSetProperty("messageConverter", messageConverter);
            return this;
        }
        /**
         * To use the given MessageCreatedStrategy which are invoked when Camel
         * creates new instances of jakarta.jms.Message objects when Camel is
         * sending a JMS message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.jms.MessageCreatedStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageCreatedStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder messageCreatedStrategy(
                org.apache.camel.component.jms.MessageCreatedStrategy messageCreatedStrategy) {
            doSetProperty("messageCreatedStrategy", messageCreatedStrategy);
            return this;
        }
        /**
         * To use the given MessageCreatedStrategy which are invoked when Camel
         * creates new instances of jakarta.jms.Message objects when Camel is
         * sending a JMS message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.jms.MessageCreatedStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageCreatedStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder messageCreatedStrategy(
                String messageCreatedStrategy) {
            doSetProperty("messageCreatedStrategy", messageCreatedStrategy);
            return this;
        }
        /**
         * When sending, specifies whether message IDs should be added. This is
         * just an hint to the JMS broker. If the JMS provider accepts this
         * hint, these messages must have the message ID set to null; if the
         * provider ignores the hint, the message ID must be set to its normal
         * unique value.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param messageIdEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder messageIdEnabled(
                boolean messageIdEnabled) {
            doSetProperty("messageIdEnabled", messageIdEnabled);
            return this;
        }
        /**
         * When sending, specifies whether message IDs should be added. This is
         * just an hint to the JMS broker. If the JMS provider accepts this
         * hint, these messages must have the message ID set to null; if the
         * provider ignores the hint, the message ID must be set to its normal
         * unique value.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param messageIdEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder messageIdEnabled(
                String messageIdEnabled) {
            doSetProperty("messageIdEnabled", messageIdEnabled);
            return this;
        }
        /**
         * Registry ID of the MessageListenerContainerFactory used to determine
         * what
         * org.springframework.jms.listener.AbstractMessageListenerContainer to
         * use to consume messages. Setting this will automatically set
         * consumerType to Custom.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.jms.MessageListenerContainerFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageListenerContainerFactory the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder messageListenerContainerFactory(
                org.apache.camel.component.jms.MessageListenerContainerFactory messageListenerContainerFactory) {
            doSetProperty("messageListenerContainerFactory", messageListenerContainerFactory);
            return this;
        }
        /**
         * Registry ID of the MessageListenerContainerFactory used to determine
         * what
         * org.springframework.jms.listener.AbstractMessageListenerContainer to
         * use to consume messages. Setting this will automatically set
         * consumerType to Custom.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.jms.MessageListenerContainerFactory&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param messageListenerContainerFactory the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder messageListenerContainerFactory(
                String messageListenerContainerFactory) {
            doSetProperty("messageListenerContainerFactory", messageListenerContainerFactory);
            return this;
        }
        /**
         * Specifies whether timestamps should be enabled by default on sending
         * messages. This is just an hint to the JMS broker. If the JMS provider
         * accepts this hint, these messages must have the timestamp set to
         * zero; if the provider ignores the hint the timestamp must be set to
         * its normal value.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param messageTimestampEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder messageTimestampEnabled(
                boolean messageTimestampEnabled) {
            doSetProperty("messageTimestampEnabled", messageTimestampEnabled);
            return this;
        }
        /**
         * Specifies whether timestamps should be enabled by default on sending
         * messages. This is just an hint to the JMS broker. If the JMS provider
         * accepts this hint, these messages must have the timestamp set to
         * zero; if the provider ignores the hint the timestamp must be set to
         * its normal value.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param messageTimestampEnabled the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder messageTimestampEnabled(
                String messageTimestampEnabled) {
            doSetProperty("messageTimestampEnabled", messageTimestampEnabled);
            return this;
        }
        /**
         * Specifies whether to inhibit the delivery of messages published by
         * its own connection.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param pubSubNoLocal the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder pubSubNoLocal(boolean pubSubNoLocal) {
            doSetProperty("pubSubNoLocal", pubSubNoLocal);
            return this;
        }
        /**
         * Specifies whether to inhibit the delivery of messages published by
         * its own connection.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param pubSubNoLocal the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder pubSubNoLocal(String pubSubNoLocal) {
            doSetProperty("pubSubNoLocal", pubSubNoLocal);
            return this;
        }
        /**
         * The timeout for receiving messages (in milliseconds).
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param receiveTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder receiveTimeout(long receiveTimeout) {
            doSetProperty("receiveTimeout", receiveTimeout);
            return this;
        }
        /**
         * The timeout for receiving messages (in milliseconds).
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param receiveTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder receiveTimeout(String receiveTimeout) {
            doSetProperty("receiveTimeout", receiveTimeout);
            return this;
        }
        /**
         * Specifies the interval between recovery attempts, i.e. when a
         * connection is being refreshed, in milliseconds. The default is 5000
         * ms, that is, 5 seconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: advanced
         * 
         * @param recoveryInterval the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder recoveryInterval(
                long recoveryInterval) {
            doSetProperty("recoveryInterval", recoveryInterval);
            return this;
        }
        /**
         * Specifies the interval between recovery attempts, i.e. when a
         * connection is being refreshed, in milliseconds. The default is 5000
         * ms, that is, 5 seconds.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: advanced
         * 
         * @param recoveryInterval the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder recoveryInterval(
                String recoveryInterval) {
            doSetProperty("recoveryInterval", recoveryInterval);
            return this;
        }
        /**
         * Configures how often Camel should check for timed out Exchanges when
         * doing request/reply over JMS. By default Camel checks once per
         * second. But if you must react faster when a timeout occurs, then you
         * can lower this interval, to check more frequently. The timeout is
         * determined by the option requestTimeout.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param requestTimeoutCheckerInterval the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder requestTimeoutCheckerInterval(
                long requestTimeoutCheckerInterval) {
            doSetProperty("requestTimeoutCheckerInterval", requestTimeoutCheckerInterval);
            return this;
        }
        /**
         * Configures how often Camel should check for timed out Exchanges when
         * doing request/reply over JMS. By default Camel checks once per
         * second. But if you must react faster when a timeout occurs, then you
         * can lower this interval, to check more frequently. The timeout is
         * determined by the option requestTimeout.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param requestTimeoutCheckerInterval the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder requestTimeoutCheckerInterval(
                String requestTimeoutCheckerInterval) {
            doSetProperty("requestTimeoutCheckerInterval", requestTimeoutCheckerInterval);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * If enabled and you are using Request Reply messaging (InOut) and an
         * Exchange failed on the consumer side, then the caused Exception will
         * be send back in response as a jakarta.jms.ObjectMessage. If the
         * client is Camel, the returned Exception is rethrown. This allows you
         * to use Camel JMS as a bridge in your routing - for example, using
         * persistent queues to enable robust routing. Notice that if you also
         * have transferExchange enabled, this option takes precedence. The
         * caught exception is required to be serializable. The original
         * Exception on the consumer side can be wrapped in an outer exception
         * such as org.apache.camel.RuntimeCamelException when returned to the
         * producer. Use this with caution as the data is using Java Object
         * serialization and requires the received to be able to deserialize the
         * data at Class level, which forces a strong coupling between the
         * producers and consumer!.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferException the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder transferException(
                boolean transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * If enabled and you are using Request Reply messaging (InOut) and an
         * Exchange failed on the consumer side, then the caused Exception will
         * be send back in response as a jakarta.jms.ObjectMessage. If the
         * client is Camel, the returned Exception is rethrown. This allows you
         * to use Camel JMS as a bridge in your routing - for example, using
         * persistent queues to enable robust routing. Notice that if you also
         * have transferExchange enabled, this option takes precedence. The
         * caught exception is required to be serializable. The original
         * Exception on the consumer side can be wrapped in an outer exception
         * such as org.apache.camel.RuntimeCamelException when returned to the
         * producer. Use this with caution as the data is using Java Object
         * serialization and requires the received to be able to deserialize the
         * data at Class level, which forces a strong coupling between the
         * producers and consumer!.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferException the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder transferException(
                String transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * You can transfer the exchange over the wire instead of just the body
         * and headers. The following fields are transferred: In body, Out body,
         * Fault body, In headers, Out headers, Fault headers, exchange
         * properties, exchange exception. This requires that the objects are
         * serializable. Camel will exclude any non-serializable objects and log
         * it at WARN level. You must enable this option on both the producer
         * and consumer side, so Camel knows the payloads is an Exchange and not
         * a regular payload. Use this with caution as the data is using Java
         * Object serialization and requires the receiver to be able to
         * deserialize the data at Class level, which forces a strong coupling
         * between the producers and consumers having to use compatible Camel
         * versions!.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferExchange the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder transferExchange(
                boolean transferExchange) {
            doSetProperty("transferExchange", transferExchange);
            return this;
        }
        /**
         * You can transfer the exchange over the wire instead of just the body
         * and headers. The following fields are transferred: In body, Out body,
         * Fault body, In headers, Out headers, Fault headers, exchange
         * properties, exchange exception. This requires that the objects are
         * serializable. Camel will exclude any non-serializable objects and log
         * it at WARN level. You must enable this option on both the producer
         * and consumer side, so Camel knows the payloads is an Exchange and not
         * a regular payload. Use this with caution as the data is using Java
         * Object serialization and requires the receiver to be able to
         * deserialize the data at Class level, which forces a strong coupling
         * between the producers and consumers having to use compatible Camel
         * versions!.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param transferExchange the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder transferExchange(
                String transferExchange) {
            doSetProperty("transferExchange", transferExchange);
            return this;
        }
        /**
         * Specifies whether JMSMessageID should always be used as
         * JMSCorrelationID for InOut messages.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param useMessageIDAsCorrelationID the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder useMessageIDAsCorrelationID(
                boolean useMessageIDAsCorrelationID) {
            doSetProperty("useMessageIDAsCorrelationID", useMessageIDAsCorrelationID);
            return this;
        }
        /**
         * Specifies whether JMSMessageID should always be used as
         * JMSCorrelationID for InOut messages.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param useMessageIDAsCorrelationID the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder useMessageIDAsCorrelationID(
                String useMessageIDAsCorrelationID) {
            doSetProperty("useMessageIDAsCorrelationID", useMessageIDAsCorrelationID);
            return this;
        }
        /**
         * Number of times to wait for provisional correlation id to be updated
         * to the actual correlation id when doing request/reply over JMS and
         * when the option useMessageIDAsCorrelationID is enabled.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 50
         * Group: advanced
         * 
         * @param waitForProvisionCorrelationToBeUpdatedCounter the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder waitForProvisionCorrelationToBeUpdatedCounter(
                int waitForProvisionCorrelationToBeUpdatedCounter) {
            doSetProperty("waitForProvisionCorrelationToBeUpdatedCounter", waitForProvisionCorrelationToBeUpdatedCounter);
            return this;
        }
        /**
         * Number of times to wait for provisional correlation id to be updated
         * to the actual correlation id when doing request/reply over JMS and
         * when the option useMessageIDAsCorrelationID is enabled.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 50
         * Group: advanced
         * 
         * @param waitForProvisionCorrelationToBeUpdatedCounter the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder waitForProvisionCorrelationToBeUpdatedCounter(
                String waitForProvisionCorrelationToBeUpdatedCounter) {
            doSetProperty("waitForProvisionCorrelationToBeUpdatedCounter", waitForProvisionCorrelationToBeUpdatedCounter);
            return this;
        }
        /**
         * Interval in millis to sleep each time while waiting for provisional
         * correlation id to be updated.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: advanced
         * 
         * @param waitForProvisionCorrelationToBeUpdatedThreadSleepingTime the
         * value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder waitForProvisionCorrelationToBeUpdatedThreadSleepingTime(
                long waitForProvisionCorrelationToBeUpdatedThreadSleepingTime) {
            doSetProperty("waitForProvisionCorrelationToBeUpdatedThreadSleepingTime", waitForProvisionCorrelationToBeUpdatedThreadSleepingTime);
            return this;
        }
        /**
         * Interval in millis to sleep each time while waiting for provisional
         * correlation id to be updated.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: advanced
         * 
         * @param waitForProvisionCorrelationToBeUpdatedThreadSleepingTime the
         * value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder waitForProvisionCorrelationToBeUpdatedThreadSleepingTime(
                String waitForProvisionCorrelationToBeUpdatedThreadSleepingTime) {
            doSetProperty("waitForProvisionCorrelationToBeUpdatedThreadSleepingTime", waitForProvisionCorrelationToBeUpdatedThreadSleepingTime);
            return this;
        }
        /**
         * If true, Camel will create a JmsTransactionManager, if there is no
         * transactionManager injected when option transacted=true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: transaction (advanced)
         * 
         * @param lazyCreateTransactionManager the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder lazyCreateTransactionManager(
                boolean lazyCreateTransactionManager) {
            doSetProperty("lazyCreateTransactionManager", lazyCreateTransactionManager);
            return this;
        }
        /**
         * If true, Camel will create a JmsTransactionManager, if there is no
         * transactionManager injected when option transacted=true.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: transaction (advanced)
         * 
         * @param lazyCreateTransactionManager the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder lazyCreateTransactionManager(
                String lazyCreateTransactionManager) {
            doSetProperty("lazyCreateTransactionManager", lazyCreateTransactionManager);
            return this;
        }
        /**
         * The Spring transaction manager to use.
         * 
         * The option is a:
         * &lt;code&gt;org.springframework.transaction.PlatformTransactionManager&lt;/code&gt; type.
         * 
         * Group: transaction (advanced)
         * 
         * @param transactionManager the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder transactionManager(
                org.springframework.transaction.PlatformTransactionManager transactionManager) {
            doSetProperty("transactionManager", transactionManager);
            return this;
        }
        /**
         * The Spring transaction manager to use.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.springframework.transaction.PlatformTransactionManager&lt;/code&gt; type.
         * 
         * Group: transaction (advanced)
         * 
         * @param transactionManager the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder transactionManager(
                String transactionManager) {
            doSetProperty("transactionManager", transactionManager);
            return this;
        }
        /**
         * The name of the transaction to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: transaction (advanced)
         * 
         * @param transactionName the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder transactionName(
                String transactionName) {
            doSetProperty("transactionName", transactionName);
            return this;
        }
        /**
         * The timeout value of the transaction (in seconds), if using
         * transacted mode.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: transaction (advanced)
         * 
         * @param transactionTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder transactionTimeout(
                int transactionTimeout) {
            doSetProperty("transactionTimeout", transactionTimeout);
            return this;
        }
        /**
         * The timeout value of the transaction (in seconds), if using
         * transacted mode.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: transaction (advanced)
         * 
         * @param transactionTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedAMQPEndpointBuilder transactionTimeout(
                String transactionTimeout) {
            doSetProperty("transactionTimeout", transactionTimeout);
            return this;
        }
    }

    public interface AMQPBuilders {
        /**
         * AMQP (camel-amqp)
         * Messaging with AMQP protocol using Apache QPid Client.
         * 
         * Category: messaging
         * Since: 1.2
         * Maven coordinates: org.apache.camel:camel-amqp
         * 
         * @return the dsl builder for the headers' name.
         */
        default AMQPHeaderNameBuilder amqp() {
            return AMQPHeaderNameBuilder.INSTANCE;
        }
        /**
         * AMQP (camel-amqp)
         * Messaging with AMQP protocol using Apache QPid Client.
         * 
         * Category: messaging
         * Since: 1.2
         * Maven coordinates: org.apache.camel:camel-amqp
         * 
         * Syntax: <code>amqp:destinationType:destinationName</code>
         * 
         * Path parameter: destinationType
         * The kind of destination to use
         * Default value: queue
         * There are 4 enums and the value can be one of: queue, topic,
         * temp-queue, temp-topic
         * 
         * Path parameter: destinationName (required)
         * Name of the queue or topic to use as destination
         * 
         * @param path destinationType:destinationName
         * @return the dsl builder
         */
        default AMQPEndpointBuilder amqp(String path) {
            return AMQPEndpointBuilderFactory.endpointBuilder("amqp", path);
        }
        /**
         * AMQP (camel-amqp)
         * Messaging with AMQP protocol using Apache QPid Client.
         * 
         * Category: messaging
         * Since: 1.2
         * Maven coordinates: org.apache.camel:camel-amqp
         * 
         * Syntax: <code>amqp:destinationType:destinationName</code>
         * 
         * Path parameter: destinationType
         * The kind of destination to use
         * Default value: queue
         * There are 4 enums and the value can be one of: queue, topic,
         * temp-queue, temp-topic
         * 
         * Path parameter: destinationName (required)
         * Name of the queue or topic to use as destination
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path destinationType:destinationName
         * @return the dsl builder
         */
        default AMQPEndpointBuilder amqp(String componentName, String path) {
            return AMQPEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the AMQP component.
     */
    public static class AMQPHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final AMQPHeaderNameBuilder INSTANCE = new AMQPHeaderNameBuilder();

        /**
         * The destination.
         * 
         * The option is a: {@code jakarta.jms.Destination} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code JmsDestination}.
         */
        public String jmsDestination() {
            return "CamelJmsDestination";
        }

        /**
         * The name of the queue or topic to use as destination.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code JmsDestinationName}.
         */
        public String jmsDestinationName() {
            return "CamelJmsDestinationName";
        }

        /**
         * The name of the queue or topic the message was sent to.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code JMSDestinationProduced}.
         */
        public String jMSDestinationProduced() {
            return "CamelJMSDestinationProduced";
        }

        /**
         * The JMS group ID.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code JMSXGroupID}.
         */
        public String jMSXGroupID() {
            return "JMSXGroupID";
        }

        /**
         * The JMS unique message ID.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code JMSMessageID}.
         */
        public String jMSMessageID() {
            return "JMSMessageID";
        }

        /**
         * The JMS correlation ID.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code JMSCorrelationID}.
         */
        public String jMSCorrelationID() {
            return "JMSCorrelationID";
        }

        /**
         * The JMS correlation ID as bytes.
         * 
         * The option is a: {@code byte[]} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code JMSCorrelationIDAsBytes}.
         */
        public String jMSCorrelationIDAsBytes() {
            return "JMSCorrelationIDAsBytes";
        }

        /**
         * The JMS delivery mode.
         * 
         * The option is a: {@code int} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code JMSDeliveryMode}.
         */
        public String jMSDeliveryMode() {
            return "JMSDeliveryMode";
        }

        /**
         * The JMS destination.
         * 
         * The option is a: {@code jakarta.jms.Destination} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code JMSDestination}.
         */
        public String jMSDestination() {
            return "JMSDestination";
        }

        /**
         * The JMS expiration.
         * 
         * The option is a: {@code long} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code JMSExpiration}.
         */
        public String jMSExpiration() {
            return "JMSExpiration";
        }

        /**
         * The JMS priority (with 0 as the lowest priority and 9 as the
         * highest).
         * 
         * The option is a: {@code int} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code JMSPriority}.
         */
        public String jMSPriority() {
            return "JMSPriority";
        }

        /**
         * Is the JMS message redelivered.
         * 
         * The option is a: {@code boolean} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code JMSRedelivered}.
         */
        public String jMSRedelivered() {
            return "JMSRedelivered";
        }

        /**
         * The JMS timestamp.
         * 
         * The option is a: {@code long} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code JMSTimestamp}.
         */
        public String jMSTimestamp() {
            return "JMSTimestamp";
        }

        /**
         * The JMS reply-to destination.
         * 
         * The option is a: {@code jakarta.jms.Destination} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code JMSReplyTo}.
         */
        public String jMSReplyTo() {
            return "JMSReplyTo";
        }

        /**
         * The JMS type.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code JMSType}.
         */
        public String jMSType() {
            return "JMSType";
        }

        /**
         * The XUser id.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code JMSXUserID}.
         */
        public String jMSXUserID() {
            return "JMSXUserID";
        }

        /**
         * The message type.
         * 
         * The option is a: {@code
         * org.apache.camel.component.jms.JmsMessageType} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code JmsMessageType}.
         */
        public String jmsMessageType() {
            return "CamelJmsMessageType";
        }

        /**
         * The timeout for waiting for a reply when using the InOut Exchange
         * Pattern (in milliseconds).
         * 
         * The option is a: {@code long} type.
         * 
         * Default: 20_000
         * Group: producer
         * 
         * @return the name of the header {@code JmsRequestTimeout}.
         */
        public String jmsRequestTimeout() {
            return "CamelJmsRequestTimeout";
        }
    }
    static AMQPEndpointBuilder endpointBuilder(String componentName, String path) {
        class AMQPEndpointBuilderImpl extends AbstractEndpointBuilder implements AMQPEndpointBuilder, AdvancedAMQPEndpointBuilder {
            public AMQPEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new AMQPEndpointBuilderImpl(path);
    }
}