/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.Map;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Harvest metadata using OAI-PMH protocol
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface OAIPMHEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the OAI-PMH component.
     */
    public interface OAIPMHEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedOAIPMHEndpointConsumerBuilder advanced() {
            return (AdvancedOAIPMHEndpointConsumerBuilder) this;
        }
        /**
         * Specifies a lower bound for datestamp-based selective harvesting. UTC
         * DateTime value.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param from the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder from(String from) {
            doSetProperty("from", from);
            return this;
        }
        /**
         * Identifier of the requested resources. Applicable only with certain
         * verbs.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param identifier the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder identifier(String identifier) {
            doSetProperty("identifier", identifier);
            return this;
        }
        /**
         * Specifies the metadataPrefix of the format that should be included in
         * the metadata part of the returned records.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: oai_dc
         * Group: common
         * 
         * @param metadataPrefix the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder metadataPrefix(
                String metadataPrefix) {
            doSetProperty("metadataPrefix", metadataPrefix);
            return this;
        }
        /**
         * Specifies membership as a criteria for set-based selective
         * harvesting.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param set the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder set(String set) {
            doSetProperty("set", set);
            return this;
        }
        /**
         * Specifies an upper bound for datestamp-based selective harvesting.
         * UTC DateTime value.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param until the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder until(String until) {
            doSetProperty("until", until);
            return this;
        }
        /**
         * Request name supported by OAI-PMh protocol.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: ListRecords
         * Group: common
         * 
         * @param verb the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder verb(String verb) {
            doSetProperty("verb", verb);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder initialDelay(String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder repeatCount(long repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder repeatCount(String repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder runLoggingLevel(
                org.apache.camel.LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder runLoggingLevel(
                String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option is a: &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder scheduler(Object scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder schedulerProperties(
                String key,
                Object value) {
            doSetMultiValueProperty("schedulerProperties", "scheduler." + key, value);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param values the values
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder schedulerProperties(Map values) {
            doSetMultiValueProperties("schedulerProperties", "scheduler.", values);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder startScheduler(
                boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder startScheduler(
                String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder useFixedDelay(
                boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder useFixedDelay(String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Ignore SSL certificate warnings.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param ignoreSSLWarnings the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder ignoreSSLWarnings(
                boolean ignoreSSLWarnings) {
            doSetProperty("ignoreSSLWarnings", ignoreSSLWarnings);
            return this;
        }
        /**
         * Ignore SSL certificate warnings.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param ignoreSSLWarnings the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder ignoreSSLWarnings(
                String ignoreSSLWarnings) {
            doSetProperty("ignoreSSLWarnings", ignoreSSLWarnings);
            return this;
        }
        /**
         * Causes the defined url to make an https request.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param ssl the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder ssl(boolean ssl) {
            doSetProperty("ssl", ssl);
            return this;
        }
        /**
         * Causes the defined url to make an https request.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param ssl the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointConsumerBuilder ssl(String ssl) {
            doSetProperty("ssl", ssl);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the OAI-PMH component.
     */
    public interface AdvancedOAIPMHEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default OAIPMHEndpointConsumerBuilder basic() {
            return (OAIPMHEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedOAIPMHEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedOAIPMHEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedOAIPMHEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedOAIPMHEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedOAIPMHEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedOAIPMHEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedOAIPMHEndpointConsumerBuilder pollStrategy(
                org.apache.camel.spi.PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedOAIPMHEndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the OAI-PMH component.
     */
    public interface OAIPMHEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedOAIPMHEndpointProducerBuilder advanced() {
            return (AdvancedOAIPMHEndpointProducerBuilder) this;
        }
        /**
         * Specifies a lower bound for datestamp-based selective harvesting. UTC
         * DateTime value.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param from the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointProducerBuilder from(String from) {
            doSetProperty("from", from);
            return this;
        }
        /**
         * Identifier of the requested resources. Applicable only with certain
         * verbs.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param identifier the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointProducerBuilder identifier(String identifier) {
            doSetProperty("identifier", identifier);
            return this;
        }
        /**
         * Specifies the metadataPrefix of the format that should be included in
         * the metadata part of the returned records.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: oai_dc
         * Group: common
         * 
         * @param metadataPrefix the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointProducerBuilder metadataPrefix(
                String metadataPrefix) {
            doSetProperty("metadataPrefix", metadataPrefix);
            return this;
        }
        /**
         * Specifies membership as a criteria for set-based selective
         * harvesting.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param set the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointProducerBuilder set(String set) {
            doSetProperty("set", set);
            return this;
        }
        /**
         * Specifies an upper bound for datestamp-based selective harvesting.
         * UTC DateTime value.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param until the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointProducerBuilder until(String until) {
            doSetProperty("until", until);
            return this;
        }
        /**
         * Request name supported by OAI-PMh protocol.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: ListRecords
         * Group: common
         * 
         * @param verb the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointProducerBuilder verb(String verb) {
            doSetProperty("verb", verb);
            return this;
        }
        /**
         * Returns the response of a single request. Otherwise it will make
         * requests until there is no more data to return.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param onlyFirst the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointProducerBuilder onlyFirst(boolean onlyFirst) {
            doSetProperty("onlyFirst", onlyFirst);
            return this;
        }
        /**
         * Returns the response of a single request. Otherwise it will make
         * requests until there is no more data to return.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param onlyFirst the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointProducerBuilder onlyFirst(String onlyFirst) {
            doSetProperty("onlyFirst", onlyFirst);
            return this;
        }
        /**
         * Ignore SSL certificate warnings.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param ignoreSSLWarnings the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointProducerBuilder ignoreSSLWarnings(
                boolean ignoreSSLWarnings) {
            doSetProperty("ignoreSSLWarnings", ignoreSSLWarnings);
            return this;
        }
        /**
         * Ignore SSL certificate warnings.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param ignoreSSLWarnings the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointProducerBuilder ignoreSSLWarnings(
                String ignoreSSLWarnings) {
            doSetProperty("ignoreSSLWarnings", ignoreSSLWarnings);
            return this;
        }
        /**
         * Causes the defined url to make an https request.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param ssl the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointProducerBuilder ssl(boolean ssl) {
            doSetProperty("ssl", ssl);
            return this;
        }
        /**
         * Causes the defined url to make an https request.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param ssl the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointProducerBuilder ssl(String ssl) {
            doSetProperty("ssl", ssl);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the OAI-PMH component.
     */
    public interface AdvancedOAIPMHEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default OAIPMHEndpointProducerBuilder basic() {
            return (OAIPMHEndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedOAIPMHEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedOAIPMHEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Builder for endpoint for the OAI-PMH component.
     */
    public interface OAIPMHEndpointBuilder
            extends
                OAIPMHEndpointConsumerBuilder,
                OAIPMHEndpointProducerBuilder {
        default AdvancedOAIPMHEndpointBuilder advanced() {
            return (AdvancedOAIPMHEndpointBuilder) this;
        }
        /**
         * Specifies a lower bound for datestamp-based selective harvesting. UTC
         * DateTime value.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param from the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointBuilder from(String from) {
            doSetProperty("from", from);
            return this;
        }
        /**
         * Identifier of the requested resources. Applicable only with certain
         * verbs.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param identifier the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointBuilder identifier(String identifier) {
            doSetProperty("identifier", identifier);
            return this;
        }
        /**
         * Specifies the metadataPrefix of the format that should be included in
         * the metadata part of the returned records.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: oai_dc
         * Group: common
         * 
         * @param metadataPrefix the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointBuilder metadataPrefix(String metadataPrefix) {
            doSetProperty("metadataPrefix", metadataPrefix);
            return this;
        }
        /**
         * Specifies membership as a criteria for set-based selective
         * harvesting.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param set the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointBuilder set(String set) {
            doSetProperty("set", set);
            return this;
        }
        /**
         * Specifies an upper bound for datestamp-based selective harvesting.
         * UTC DateTime value.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param until the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointBuilder until(String until) {
            doSetProperty("until", until);
            return this;
        }
        /**
         * Request name supported by OAI-PMh protocol.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: ListRecords
         * Group: common
         * 
         * @param verb the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointBuilder verb(String verb) {
            doSetProperty("verb", verb);
            return this;
        }
        /**
         * Ignore SSL certificate warnings.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param ignoreSSLWarnings the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointBuilder ignoreSSLWarnings(
                boolean ignoreSSLWarnings) {
            doSetProperty("ignoreSSLWarnings", ignoreSSLWarnings);
            return this;
        }
        /**
         * Ignore SSL certificate warnings.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param ignoreSSLWarnings the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointBuilder ignoreSSLWarnings(String ignoreSSLWarnings) {
            doSetProperty("ignoreSSLWarnings", ignoreSSLWarnings);
            return this;
        }
        /**
         * Causes the defined url to make an https request.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param ssl the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointBuilder ssl(boolean ssl) {
            doSetProperty("ssl", ssl);
            return this;
        }
        /**
         * Causes the defined url to make an https request.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param ssl the value to set
         * @return the dsl builder
         */
        default OAIPMHEndpointBuilder ssl(String ssl) {
            doSetProperty("ssl", ssl);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the OAI-PMH component.
     */
    public interface AdvancedOAIPMHEndpointBuilder
            extends
                AdvancedOAIPMHEndpointConsumerBuilder,
                AdvancedOAIPMHEndpointProducerBuilder {
        default OAIPMHEndpointBuilder basic() {
            return (OAIPMHEndpointBuilder) this;
        }
    }

    public interface OAIPMHBuilders {
        /**
         * OAI-PMH (camel-oaipmh)
         * Harvest metadata using OAI-PMH protocol
         * 
         * Category: search
         * Since: 3.5
         * Maven coordinates: org.apache.camel:camel-oaipmh
         * 
         * @return the dsl builder for the headers' name.
         */
        default OAIPMHHeaderNameBuilder oaipmh() {
            return OAIPMHHeaderNameBuilder.INSTANCE;
        }
        /**
         * OAI-PMH (camel-oaipmh)
         * Harvest metadata using OAI-PMH protocol
         * 
         * Category: search
         * Since: 3.5
         * Maven coordinates: org.apache.camel:camel-oaipmh
         * 
         * Syntax: <code>oaipmh:baseUrl</code>
         * 
         * Path parameter: baseUrl (required)
         * Base URL of the repository to which the request is made through the
         * OAI-PMH protocol
         * 
         * @param path baseUrl
         * @return the dsl builder
         */
        default OAIPMHEndpointBuilder oaipmh(String path) {
            return OAIPMHEndpointBuilderFactory.endpointBuilder("oaipmh", path);
        }
        /**
         * OAI-PMH (camel-oaipmh)
         * Harvest metadata using OAI-PMH protocol
         * 
         * Category: search
         * Since: 3.5
         * Maven coordinates: org.apache.camel:camel-oaipmh
         * 
         * Syntax: <code>oaipmh:baseUrl</code>
         * 
         * Path parameter: baseUrl (required)
         * Base URL of the repository to which the request is made through the
         * OAI-PMH protocol
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path baseUrl
         * @return the dsl builder
         */
        default OAIPMHEndpointBuilder oaipmh(String componentName, String path) {
            return OAIPMHEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the OAI-PMH component.
     */
    public static class OAIPMHHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final OAIPMHHeaderNameBuilder INSTANCE = new OAIPMHHeaderNameBuilder();

        /**
         * This header is obtained when onlyFirst option is enable. Return
         * resumption token of the request when data is still available.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code OaimphResumptionToken}.
         */
        public String oaimphResumptionToken() {
            return "CamelOaimphResumptionToken";
        }
    }
    static OAIPMHEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class OAIPMHEndpointBuilderImpl extends AbstractEndpointBuilder implements OAIPMHEndpointBuilder, AdvancedOAIPMHEndpointBuilder {
            public OAIPMHEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new OAIPMHEndpointBuilderImpl(path);
    }
}