/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.ssh.SshComponent;

/**
 * Execute commands on remote hosts using SSH.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface SshComponentBuilderFactory {

    /**
     * SSH (camel-ssh)
     * Execute commands on remote hosts using SSH.
     * 
     * Category: file
     * Since: 2.10
     * Maven coordinates: org.apache.camel:camel-ssh
     * 
     * @return the dsl builder
     */
    static SshComponentBuilder ssh() {
        return new SshComponentBuilderImpl();
    }

    /**
     * Builder for the SSH component.
     */
    interface SshComponentBuilder extends ComponentBuilder<SshComponent> {
        /**
         * Specifies whether a connection to an unknown host should fail or not.
         * This value is only checked when the property knownHosts is set.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param failOnUnknownHost the value to set
         * @return the dsl builder
         */
        default SshComponentBuilder failOnUnknownHost(boolean failOnUnknownHost) {
            doSetProperty("failOnUnknownHost", failOnUnknownHost);
            return this;
        }
        /**
         * Sets the resource path for a known_hosts file.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param knownHostsResource the value to set
         * @return the dsl builder
         */
        default SshComponentBuilder knownHostsResource(
                java.lang.String knownHostsResource) {
            doSetProperty("knownHostsResource", knownHostsResource);
            return this;
        }
        /**
         * Sets the timeout in milliseconds to wait in establishing the remote
         * SSH server connection. Defaults to 30000 milliseconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default SshComponentBuilder timeout(long timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default SshComponentBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Sets the command string to send to the remote SSH server during every
         * poll cycle. Only works with camel-ssh component being used as a
         * consumer, i.e. from(ssh://...) You may need to end your command with
         * a newline, and that must be URL encoded %0A.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param pollCommand the value to set
         * @return the dsl builder
         */
        default SshComponentBuilder pollCommand(java.lang.String pollCommand) {
            doSetProperty("pollCommand", pollCommand);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default SshComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default SshComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
        /**
         * Sets the channel type to pass to the Channel as part of command
         * execution. Defaults to exec.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: exec
         * Group: advanced
         * 
         * @param channelType the value to set
         * @return the dsl builder
         */
        default SshComponentBuilder channelType(java.lang.String channelType) {
            doSetProperty("channelType", channelType);
            return this;
        }
        /**
         * Component configuration.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.ssh.SshConfiguration&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default SshComponentBuilder configuration(
                org.apache.camel.component.ssh.SshConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
        /**
         * Sets the shellPrompt to be dropped when response is read after
         * command execution.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param shellPrompt the value to set
         * @return the dsl builder
         */
        default SshComponentBuilder shellPrompt(java.lang.String shellPrompt) {
            doSetProperty("shellPrompt", shellPrompt);
            return this;
        }
        /**
         * Sets the sleep period in milliseconds to wait reading response from
         * shell prompt. Defaults to 100 milliseconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: advanced
         * 
         * @param sleepForShellPrompt the value to set
         * @return the dsl builder
         */
        default SshComponentBuilder sleepForShellPrompt(long sleepForShellPrompt) {
            doSetProperty("sleepForShellPrompt", sleepForShellPrompt);
            return this;
        }
        /**
         * Used for enabling or disabling all consumer based health checks from
         * this component.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: health
         * 
         * @param healthCheckConsumerEnabled the value to set
         * @return the dsl builder
         */
        default SshComponentBuilder healthCheckConsumerEnabled(
                boolean healthCheckConsumerEnabled) {
            doSetProperty("healthCheckConsumerEnabled", healthCheckConsumerEnabled);
            return this;
        }
        /**
         * Used for enabling or disabling all producer based health checks from
         * this component. Notice: Camel has by default disabled all producer
         * based health-checks. You can turn on producer checks globally by
         * setting camel.health.producersEnabled=true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: health
         * 
         * @param healthCheckProducerEnabled the value to set
         * @return the dsl builder
         */
        default SshComponentBuilder healthCheckProducerEnabled(
                boolean healthCheckProducerEnabled) {
            doSetProperty("healthCheckProducerEnabled", healthCheckProducerEnabled);
            return this;
        }
        /**
         * Sets the resource path of the certificate to use for Authentication.
         * Will use ResourceHelperKeyPairProvider to resolve file based
         * certificate, and depends on keyType setting.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param certResource the value to set
         * @return the dsl builder
         */
        default SshComponentBuilder certResource(java.lang.String certResource) {
            doSetProperty("certResource", certResource);
            return this;
        }
        /**
         * Sets the password to use in loading certResource, if certResource is
         * an encrypted key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param certResourcePassword the value to set
         * @return the dsl builder
         */
        default SshComponentBuilder certResourcePassword(
                java.lang.String certResourcePassword) {
            doSetProperty("certResourcePassword", certResourcePassword);
            return this;
        }
        /**
         * Sets the KeyPairProvider reference to use when connecting using
         * Certificates to the remote SSH Server.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.sshd.common.keyprovider.KeyPairProvider&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyPairProvider the value to set
         * @return the dsl builder
         */
        default SshComponentBuilder keyPairProvider(
                org.apache.sshd.common.keyprovider.KeyPairProvider keyPairProvider) {
            doSetProperty("keyPairProvider", keyPairProvider);
            return this;
        }
        /**
         * Sets the key type to pass to the KeyPairProvider as part of
         * authentication. KeyPairProvider.loadKey(...) will be passed this
         * value. From Camel 3.0.0 / 2.25.0, by default Camel will select the
         * first available KeyPair that is loaded. Prior to this, a KeyType of
         * 'ssh-rsa' was enforced by default.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param keyType the value to set
         * @return the dsl builder
         */
        default SshComponentBuilder keyType(java.lang.String keyType) {
            doSetProperty("keyType", keyType);
            return this;
        }
        /**
         * Sets the password to use in connecting to remote SSH server. Requires
         * keyPairProvider to be set to null.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default SshComponentBuilder password(java.lang.String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Sets the username to use in logging into the remote SSH server.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default SshComponentBuilder username(java.lang.String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    class SshComponentBuilderImpl
            extends
                AbstractComponentBuilder<SshComponent>
            implements
                SshComponentBuilder {
        @Override
        protected SshComponent buildConcreteComponent() {
            return new SshComponent();
        }
        private org.apache.camel.component.ssh.SshConfiguration getOrCreateConfiguration(
                org.apache.camel.component.ssh.SshComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.ssh.SshConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "failOnUnknownHost": getOrCreateConfiguration((SshComponent) component).setFailOnUnknownHost((boolean) value); return true;
            case "knownHostsResource": getOrCreateConfiguration((SshComponent) component).setKnownHostsResource((java.lang.String) value); return true;
            case "timeout": getOrCreateConfiguration((SshComponent) component).setTimeout((long) value); return true;
            case "bridgeErrorHandler": ((SshComponent) component).setBridgeErrorHandler((boolean) value); return true;
            case "pollCommand": getOrCreateConfiguration((SshComponent) component).setPollCommand((java.lang.String) value); return true;
            case "lazyStartProducer": ((SshComponent) component).setLazyStartProducer((boolean) value); return true;
            case "autowiredEnabled": ((SshComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "channelType": getOrCreateConfiguration((SshComponent) component).setChannelType((java.lang.String) value); return true;
            case "configuration": ((SshComponent) component).setConfiguration((org.apache.camel.component.ssh.SshConfiguration) value); return true;
            case "shellPrompt": getOrCreateConfiguration((SshComponent) component).setShellPrompt((java.lang.String) value); return true;
            case "sleepForShellPrompt": getOrCreateConfiguration((SshComponent) component).setSleepForShellPrompt((long) value); return true;
            case "healthCheckConsumerEnabled": ((SshComponent) component).setHealthCheckConsumerEnabled((boolean) value); return true;
            case "healthCheckProducerEnabled": ((SshComponent) component).setHealthCheckProducerEnabled((boolean) value); return true;
            case "certResource": getOrCreateConfiguration((SshComponent) component).setCertResource((java.lang.String) value); return true;
            case "certResourcePassword": getOrCreateConfiguration((SshComponent) component).setCertResourcePassword((java.lang.String) value); return true;
            case "keyPairProvider": getOrCreateConfiguration((SshComponent) component).setKeyPairProvider((org.apache.sshd.common.keyprovider.KeyPairProvider) value); return true;
            case "keyType": getOrCreateConfiguration((SshComponent) component).setKeyType((java.lang.String) value); return true;
            case "password": getOrCreateConfiguration((SshComponent) component).setPassword((java.lang.String) value); return true;
            case "username": getOrCreateConfiguration((SshComponent) component).setUsername((java.lang.String) value); return true;
            default: return false;
            }
        }
    }
}