/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Access external web services as a client or expose your own web services.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface SpringWebserviceEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Spring WebService component.
     */
    public interface SpringWebserviceEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedSpringWebserviceEndpointConsumerBuilder advanced() {
            return (AdvancedSpringWebserviceEndpointConsumerBuilder) this;
        }
        /**
         * Option to provide a custom MessageFilter. For example when you want
         * to process your headers or attachments by your own.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.spring.ws.filter.MessageFilter&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param messageFilter the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointConsumerBuilder messageFilter(
                org.apache.camel.component.spring.ws.filter.MessageFilter messageFilter) {
            doSetProperty("messageFilter", messageFilter);
            return this;
        }
        /**
         * Option to provide a custom MessageFilter. For example when you want
         * to process your headers or attachments by your own.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.spring.ws.filter.MessageFilter&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param messageFilter the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointConsumerBuilder messageFilter(
                String messageFilter) {
            doSetProperty("messageFilter", messageFilter);
            return this;
        }
        /**
         * Option to provide a custom MessageIdStrategy to control generation of
         * WS-Addressing unique message ids.
         * 
         * The option is a:
         * &lt;code&gt;org.springframework.ws.soap.addressing.messageid.MessageIdStrategy&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param messageIdStrategy the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointConsumerBuilder messageIdStrategy(
                org.springframework.ws.soap.addressing.messageid.MessageIdStrategy messageIdStrategy) {
            doSetProperty("messageIdStrategy", messageIdStrategy);
            return this;
        }
        /**
         * Option to provide a custom MessageIdStrategy to control generation of
         * WS-Addressing unique message ids.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.springframework.ws.soap.addressing.messageid.MessageIdStrategy&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param messageIdStrategy the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointConsumerBuilder messageIdStrategy(
                String messageIdStrategy) {
            doSetProperty("messageIdStrategy", messageIdStrategy);
            return this;
        }
        /**
         * Spring org.springframework.ws.server.endpoint.MessageEndpoint for
         * dispatching messages received by Spring-WS to a Camel endpoint, to
         * integrate with existing (legacy) endpoint mappings like
         * PayloadRootQNameEndpointMapping, SoapActionEndpointMapping, etc.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.spring.ws.bean.CamelEndpointDispatcher&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param endpointDispatcher the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointConsumerBuilder endpointDispatcher(
                org.apache.camel.component.spring.ws.bean.CamelEndpointDispatcher endpointDispatcher) {
            doSetProperty("endpointDispatcher", endpointDispatcher);
            return this;
        }
        /**
         * Spring org.springframework.ws.server.endpoint.MessageEndpoint for
         * dispatching messages received by Spring-WS to a Camel endpoint, to
         * integrate with existing (legacy) endpoint mappings like
         * PayloadRootQNameEndpointMapping, SoapActionEndpointMapping, etc.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.spring.ws.bean.CamelEndpointDispatcher&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param endpointDispatcher the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointConsumerBuilder endpointDispatcher(
                String endpointDispatcher) {
            doSetProperty("endpointDispatcher", endpointDispatcher);
            return this;
        }
        /**
         * Reference to an instance of
         * org.apache.camel.component.spring.ws.bean.CamelEndpointMapping in the
         * Registry/ApplicationContext. Only one bean is required in the
         * registry to serve all Camel/Spring-WS endpoints. This bean is
         * auto-discovered by the MessageDispatcher and used to map requests to
         * Camel endpoints based on characteristics specified on the endpoint
         * (like root QName, SOAP action, etc).
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.spring.ws.bean.CamelSpringWSEndpointMapping&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param endpointMapping the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointConsumerBuilder endpointMapping(
                org.apache.camel.component.spring.ws.bean.CamelSpringWSEndpointMapping endpointMapping) {
            doSetProperty("endpointMapping", endpointMapping);
            return this;
        }
        /**
         * Reference to an instance of
         * org.apache.camel.component.spring.ws.bean.CamelEndpointMapping in the
         * Registry/ApplicationContext. Only one bean is required in the
         * registry to serve all Camel/Spring-WS endpoints. This bean is
         * auto-discovered by the MessageDispatcher and used to map requests to
         * Camel endpoints based on characteristics specified on the endpoint
         * (like root QName, SOAP action, etc).
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.spring.ws.bean.CamelSpringWSEndpointMapping&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param endpointMapping the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointConsumerBuilder endpointMapping(
                String endpointMapping) {
            doSetProperty("endpointMapping", endpointMapping);
            return this;
        }
        /**
         * The XPath expression to use when option type=xpathresult. Then this
         * option is required to be configured.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param expression the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointConsumerBuilder expression(
                String expression) {
            doSetProperty("expression", expression);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointConsumerBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointConsumerBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Spring WebService
     * component.
     */
    public interface AdvancedSpringWebserviceEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default SpringWebserviceEndpointConsumerBuilder basic() {
            return (SpringWebserviceEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSpringWebserviceEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSpringWebserviceEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSpringWebserviceEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSpringWebserviceEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedSpringWebserviceEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedSpringWebserviceEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Spring WebService component.
     */
    public interface SpringWebserviceEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedSpringWebserviceEndpointProducerBuilder advanced() {
            return (AdvancedSpringWebserviceEndpointProducerBuilder) this;
        }
        /**
         * Option to provide a custom MessageFilter. For example when you want
         * to process your headers or attachments by your own.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.spring.ws.filter.MessageFilter&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param messageFilter the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointProducerBuilder messageFilter(
                org.apache.camel.component.spring.ws.filter.MessageFilter messageFilter) {
            doSetProperty("messageFilter", messageFilter);
            return this;
        }
        /**
         * Option to provide a custom MessageFilter. For example when you want
         * to process your headers or attachments by your own.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.spring.ws.filter.MessageFilter&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param messageFilter the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointProducerBuilder messageFilter(
                String messageFilter) {
            doSetProperty("messageFilter", messageFilter);
            return this;
        }
        /**
         * Option to provide a custom MessageIdStrategy to control generation of
         * WS-Addressing unique message ids.
         * 
         * The option is a:
         * &lt;code&gt;org.springframework.ws.soap.addressing.messageid.MessageIdStrategy&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param messageIdStrategy the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointProducerBuilder messageIdStrategy(
                org.springframework.ws.soap.addressing.messageid.MessageIdStrategy messageIdStrategy) {
            doSetProperty("messageIdStrategy", messageIdStrategy);
            return this;
        }
        /**
         * Option to provide a custom MessageIdStrategy to control generation of
         * WS-Addressing unique message ids.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.springframework.ws.soap.addressing.messageid.MessageIdStrategy&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param messageIdStrategy the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointProducerBuilder messageIdStrategy(
                String messageIdStrategy) {
            doSetProperty("messageIdStrategy", messageIdStrategy);
            return this;
        }
        /**
         * Option to override soap response attachments in in/out exchange with
         * attachments from the actual service layer. If the invoked service
         * appends or rewrites the soap attachments this option when set to
         * true, allows the modified soap attachments to be overwritten in
         * in/out message attachments.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param allowResponseAttachmentOverride the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointProducerBuilder allowResponseAttachmentOverride(
                boolean allowResponseAttachmentOverride) {
            doSetProperty("allowResponseAttachmentOverride", allowResponseAttachmentOverride);
            return this;
        }
        /**
         * Option to override soap response attachments in in/out exchange with
         * attachments from the actual service layer. If the invoked service
         * appends or rewrites the soap attachments this option when set to
         * true, allows the modified soap attachments to be overwritten in
         * in/out message attachments.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param allowResponseAttachmentOverride the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointProducerBuilder allowResponseAttachmentOverride(
                String allowResponseAttachmentOverride) {
            doSetProperty("allowResponseAttachmentOverride", allowResponseAttachmentOverride);
            return this;
        }
        /**
         * Option to override soap response header in in/out exchange with
         * header info from the actual service layer. If the invoked service
         * appends or rewrites the soap header this option when set to true,
         * allows the modified soap header to be overwritten in in/out message
         * headers.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param allowResponseHeaderOverride the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointProducerBuilder allowResponseHeaderOverride(
                boolean allowResponseHeaderOverride) {
            doSetProperty("allowResponseHeaderOverride", allowResponseHeaderOverride);
            return this;
        }
        /**
         * Option to override soap response header in in/out exchange with
         * header info from the actual service layer. If the invoked service
         * appends or rewrites the soap header this option when set to true,
         * allows the modified soap header to be overwritten in in/out message
         * headers.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param allowResponseHeaderOverride the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointProducerBuilder allowResponseHeaderOverride(
                String allowResponseHeaderOverride) {
            doSetProperty("allowResponseHeaderOverride", allowResponseHeaderOverride);
            return this;
        }
        /**
         * Signifies the value for the faultAction response WS-Addressing Fault
         * Action header that is provided by the method. See
         * org.springframework.ws.soap.addressing.server.annotation.Action
         * annotation for more details.
         * 
         * The option is a: &lt;code&gt;java.net.URI&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param faultAction the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointProducerBuilder faultAction(
                java.net.URI faultAction) {
            doSetProperty("faultAction", faultAction);
            return this;
        }
        /**
         * Signifies the value for the faultAction response WS-Addressing Fault
         * Action header that is provided by the method. See
         * org.springframework.ws.soap.addressing.server.annotation.Action
         * annotation for more details.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.net.URI&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param faultAction the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointProducerBuilder faultAction(
                String faultAction) {
            doSetProperty("faultAction", faultAction);
            return this;
        }
        /**
         * Signifies the value for the faultAction response WS-Addressing
         * FaultTo header that is provided by the method. See
         * org.springframework.ws.soap.addressing.server.annotation.Action
         * annotation for more details.
         * 
         * The option is a: &lt;code&gt;java.net.URI&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param faultTo the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointProducerBuilder faultTo(
                java.net.URI faultTo) {
            doSetProperty("faultTo", faultTo);
            return this;
        }
        /**
         * Signifies the value for the faultAction response WS-Addressing
         * FaultTo header that is provided by the method. See
         * org.springframework.ws.soap.addressing.server.annotation.Action
         * annotation for more details.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.net.URI&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param faultTo the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointProducerBuilder faultTo(String faultTo) {
            doSetProperty("faultTo", faultTo);
            return this;
        }
        /**
         * Option to provide a custom WebServiceMessageFactory.
         * 
         * The option is a:
         * &lt;code&gt;org.springframework.ws.WebServiceMessageFactory&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param messageFactory the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointProducerBuilder messageFactory(
                org.springframework.ws.WebServiceMessageFactory messageFactory) {
            doSetProperty("messageFactory", messageFactory);
            return this;
        }
        /**
         * Option to provide a custom WebServiceMessageFactory.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.springframework.ws.WebServiceMessageFactory&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param messageFactory the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointProducerBuilder messageFactory(
                String messageFactory) {
            doSetProperty("messageFactory", messageFactory);
            return this;
        }
        /**
         * Option to provide a custom WebServiceMessageSender. For example to
         * perform authentication or use alternative transports.
         * 
         * The option is a:
         * &lt;code&gt;org.springframework.ws.transport.WebServiceMessageSender&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param messageSender the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointProducerBuilder messageSender(
                org.springframework.ws.transport.WebServiceMessageSender messageSender) {
            doSetProperty("messageSender", messageSender);
            return this;
        }
        /**
         * Option to provide a custom WebServiceMessageSender. For example to
         * perform authentication or use alternative transports.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.springframework.ws.transport.WebServiceMessageSender&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param messageSender the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointProducerBuilder messageSender(
                String messageSender) {
            doSetProperty("messageSender", messageSender);
            return this;
        }
        /**
         * Signifies the value for the response WS-Addressing Action header that
         * is provided by the method. See
         * org.springframework.ws.soap.addressing.server.annotation.Action
         * annotation for more details.
         * 
         * The option is a: &lt;code&gt;java.net.URI&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param outputAction the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointProducerBuilder outputAction(
                java.net.URI outputAction) {
            doSetProperty("outputAction", outputAction);
            return this;
        }
        /**
         * Signifies the value for the response WS-Addressing Action header that
         * is provided by the method. See
         * org.springframework.ws.soap.addressing.server.annotation.Action
         * annotation for more details.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.net.URI&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param outputAction the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointProducerBuilder outputAction(
                String outputAction) {
            doSetProperty("outputAction", outputAction);
            return this;
        }
        /**
         * Signifies the value for the replyTo response WS-Addressing ReplyTo
         * header that is provided by the method. See
         * org.springframework.ws.soap.addressing.server.annotation.Action
         * annotation for more details.
         * 
         * The option is a: &lt;code&gt;java.net.URI&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param replyTo the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointProducerBuilder replyTo(
                java.net.URI replyTo) {
            doSetProperty("replyTo", replyTo);
            return this;
        }
        /**
         * Signifies the value for the replyTo response WS-Addressing ReplyTo
         * header that is provided by the method. See
         * org.springframework.ws.soap.addressing.server.annotation.Action
         * annotation for more details.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.net.URI&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param replyTo the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointProducerBuilder replyTo(String replyTo) {
            doSetProperty("replyTo", replyTo);
            return this;
        }
        /**
         * SOAP action to include inside a SOAP request when accessing remote
         * web services.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param soapAction the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointProducerBuilder soapAction(
                String soapAction) {
            doSetProperty("soapAction", soapAction);
            return this;
        }
        /**
         * Sets the socket read timeout (in milliseconds) while invoking a
         * webservice using the producer, see URLConnection.setReadTimeout() and
         * CommonsHttpMessageSender.setReadTimeout(). This option works when
         * using the built-in message sender implementations:
         * CommonsHttpMessageSender and HttpUrlConnectionMessageSender. One of
         * these implementations will be used by default for HTTP based services
         * unless you customize the Spring WS configuration options supplied to
         * the component. If you are using a non-standard sender, it is assumed
         * that you will handle your own timeout configuration. The built-in
         * message sender HttpComponentsMessageSender is considered instead of
         * CommonsHttpMessageSender which has been deprecated, see
         * HttpComponentsMessageSender.setReadTimeout().
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointProducerBuilder timeout(int timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * Sets the socket read timeout (in milliseconds) while invoking a
         * webservice using the producer, see URLConnection.setReadTimeout() and
         * CommonsHttpMessageSender.setReadTimeout(). This option works when
         * using the built-in message sender implementations:
         * CommonsHttpMessageSender and HttpUrlConnectionMessageSender. One of
         * these implementations will be used by default for HTTP based services
         * unless you customize the Spring WS configuration options supplied to
         * the component. If you are using a non-standard sender, it is assumed
         * that you will handle your own timeout configuration. The built-in
         * message sender HttpComponentsMessageSender is considered instead of
         * CommonsHttpMessageSender which has been deprecated, see
         * HttpComponentsMessageSender.setReadTimeout().
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointProducerBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * Option to provide a custom WebServiceTemplate. This allows for full
         * control over client-side web services handling; like adding a custom
         * interceptor or specifying a fault resolver, message sender or message
         * factory.
         * 
         * The option is a:
         * &lt;code&gt;org.springframework.ws.client.core.WebServiceTemplate&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param webServiceTemplate the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointProducerBuilder webServiceTemplate(
                org.springframework.ws.client.core.WebServiceTemplate webServiceTemplate) {
            doSetProperty("webServiceTemplate", webServiceTemplate);
            return this;
        }
        /**
         * Option to provide a custom WebServiceTemplate. This allows for full
         * control over client-side web services handling; like adding a custom
         * interceptor or specifying a fault resolver, message sender or message
         * factory.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.springframework.ws.client.core.WebServiceTemplate&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param webServiceTemplate the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointProducerBuilder webServiceTemplate(
                String webServiceTemplate) {
            doSetProperty("webServiceTemplate", webServiceTemplate);
            return this;
        }
        /**
         * WS-Addressing 1.0 action header to include when accessing web
         * services. The To header is set to the address of the web service as
         * specified in the endpoint URI (default Spring-WS behavior).
         * 
         * The option is a: &lt;code&gt;java.net.URI&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param wsAddressingAction the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointProducerBuilder wsAddressingAction(
                java.net.URI wsAddressingAction) {
            doSetProperty("wsAddressingAction", wsAddressingAction);
            return this;
        }
        /**
         * WS-Addressing 1.0 action header to include when accessing web
         * services. The To header is set to the address of the web service as
         * specified in the endpoint URI (default Spring-WS behavior).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.net.URI&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param wsAddressingAction the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointProducerBuilder wsAddressingAction(
                String wsAddressingAction) {
            doSetProperty("wsAddressingAction", wsAddressingAction);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointProducerBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointProducerBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Spring WebService
     * component.
     */
    public interface AdvancedSpringWebserviceEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default SpringWebserviceEndpointProducerBuilder basic() {
            return (SpringWebserviceEndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedSpringWebserviceEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedSpringWebserviceEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Spring WebService component.
     */
    public interface SpringWebserviceEndpointBuilder
            extends
                SpringWebserviceEndpointConsumerBuilder,
                SpringWebserviceEndpointProducerBuilder {
        default AdvancedSpringWebserviceEndpointBuilder advanced() {
            return (AdvancedSpringWebserviceEndpointBuilder) this;
        }
        /**
         * Option to provide a custom MessageFilter. For example when you want
         * to process your headers or attachments by your own.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.spring.ws.filter.MessageFilter&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param messageFilter the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointBuilder messageFilter(
                org.apache.camel.component.spring.ws.filter.MessageFilter messageFilter) {
            doSetProperty("messageFilter", messageFilter);
            return this;
        }
        /**
         * Option to provide a custom MessageFilter. For example when you want
         * to process your headers or attachments by your own.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.spring.ws.filter.MessageFilter&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param messageFilter the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointBuilder messageFilter(
                String messageFilter) {
            doSetProperty("messageFilter", messageFilter);
            return this;
        }
        /**
         * Option to provide a custom MessageIdStrategy to control generation of
         * WS-Addressing unique message ids.
         * 
         * The option is a:
         * &lt;code&gt;org.springframework.ws.soap.addressing.messageid.MessageIdStrategy&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param messageIdStrategy the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointBuilder messageIdStrategy(
                org.springframework.ws.soap.addressing.messageid.MessageIdStrategy messageIdStrategy) {
            doSetProperty("messageIdStrategy", messageIdStrategy);
            return this;
        }
        /**
         * Option to provide a custom MessageIdStrategy to control generation of
         * WS-Addressing unique message ids.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.springframework.ws.soap.addressing.messageid.MessageIdStrategy&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param messageIdStrategy the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointBuilder messageIdStrategy(
                String messageIdStrategy) {
            doSetProperty("messageIdStrategy", messageIdStrategy);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default SpringWebserviceEndpointBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Spring WebService component.
     */
    public interface AdvancedSpringWebserviceEndpointBuilder
            extends
                AdvancedSpringWebserviceEndpointConsumerBuilder,
                AdvancedSpringWebserviceEndpointProducerBuilder {
        default SpringWebserviceEndpointBuilder basic() {
            return (SpringWebserviceEndpointBuilder) this;
        }
    }

    public interface SpringWebserviceBuilders {
        /**
         * Spring WebService (camel-spring-ws)
         * Access external web services as a client or expose your own web
         * services.
         * 
         * Category: webservice
         * Since: 2.6
         * Maven coordinates: org.apache.camel:camel-spring-ws
         * 
         * @return the dsl builder for the headers' name.
         */
        default SpringWebserviceHeaderNameBuilder springWs() {
            return SpringWebserviceHeaderNameBuilder.INSTANCE;
        }
        /**
         * Spring WebService (camel-spring-ws)
         * Access external web services as a client or expose your own web
         * services.
         * 
         * Category: webservice
         * Since: 2.6
         * Maven coordinates: org.apache.camel:camel-spring-ws
         * 
         * Syntax: <code>spring-ws:type:lookupKey:webServiceEndpointUri</code>
         * 
         * Path parameter: type
         * Endpoint mapping type if endpoint mapping is used. rootqname - Offers
         * the option to map web service requests based on the qualified name of
         * the root element contained in the message. soapaction - Used to map
         * web service requests based on the SOAP action specified in the header
         * of the message. uri - In order to map web service requests that
         * target a specific URI. xpathresult - Used to map web service requests
         * based on the evaluation of an XPath expression against the incoming
         * message. The result of the evaluation should match the XPath result
         * specified in the endpoint URI. beanname - Allows you to reference an
         * org.apache.camel.component.spring.ws.bean.CamelEndpointDispatcher
         * object in order to integrate with existing (legacy) endpoint mappings
         * like PayloadRootQNameEndpointMapping, SoapActionEndpointMapping, etc
         * There are 8 enums and the value can be one of: ROOT_QNAME, ACTION,
         * TO, SOAP_ACTION, XPATHRESULT, URI, URI_PATH, BEANNAME
         * 
         * Path parameter: lookupKey
         * Endpoint mapping key if endpoint mapping is used
         * 
         * Path parameter: webServiceEndpointUri
         * The default Web Service endpoint uri to use for the producer.
         * 
         * @param path type:lookupKey:webServiceEndpointUri
         * @return the dsl builder
         */
        default SpringWebserviceEndpointBuilder springWs(String path) {
            return SpringWebserviceEndpointBuilderFactory.endpointBuilder("spring-ws", path);
        }
        /**
         * Spring WebService (camel-spring-ws)
         * Access external web services as a client or expose your own web
         * services.
         * 
         * Category: webservice
         * Since: 2.6
         * Maven coordinates: org.apache.camel:camel-spring-ws
         * 
         * Syntax: <code>spring-ws:type:lookupKey:webServiceEndpointUri</code>
         * 
         * Path parameter: type
         * Endpoint mapping type if endpoint mapping is used. rootqname - Offers
         * the option to map web service requests based on the qualified name of
         * the root element contained in the message. soapaction - Used to map
         * web service requests based on the SOAP action specified in the header
         * of the message. uri - In order to map web service requests that
         * target a specific URI. xpathresult - Used to map web service requests
         * based on the evaluation of an XPath expression against the incoming
         * message. The result of the evaluation should match the XPath result
         * specified in the endpoint URI. beanname - Allows you to reference an
         * org.apache.camel.component.spring.ws.bean.CamelEndpointDispatcher
         * object in order to integrate with existing (legacy) endpoint mappings
         * like PayloadRootQNameEndpointMapping, SoapActionEndpointMapping, etc
         * There are 8 enums and the value can be one of: ROOT_QNAME, ACTION,
         * TO, SOAP_ACTION, XPATHRESULT, URI, URI_PATH, BEANNAME
         * 
         * Path parameter: lookupKey
         * Endpoint mapping key if endpoint mapping is used
         * 
         * Path parameter: webServiceEndpointUri
         * The default Web Service endpoint uri to use for the producer.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path type:lookupKey:webServiceEndpointUri
         * @return the dsl builder
         */
        default SpringWebserviceEndpointBuilder springWs(
                String componentName,
                String path) {
            return SpringWebserviceEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the Spring WebService component.
     */
    public static class SpringWebserviceHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final SpringWebserviceHeaderNameBuilder INSTANCE = new SpringWebserviceHeaderNameBuilder();

        /**
         * The endpoint URI.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringWebserviceEndpointUri}.
         */
        public String springWebserviceEndpointUri() {
            return "SpringWebserviceEndpointUri";
        }

        /**
         * SOAP action to include inside a SOAP request when accessing remote
         * web services.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringWebserviceSoapAction}.
         */
        public String springWebserviceSoapAction() {
            return "SpringWebserviceSoapAction";
        }

        /**
         * The soap header source.
         * 
         * The option is a: {@code javax.xml.transform.Source} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code SpringWebserviceSoapHeader}.
         */
        public String springWebserviceSoapHeader() {
            return "SpringWebserviceSoapHeader";
        }

        /**
         * WS-Addressing 1.0 action header to include when accessing web
         * services. The To header is set to the address of the web service as
         * specified in the endpoint URI (default Spring-WS behavior).
         * 
         * The option is a: {@code java.net.URI} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * SpringWebserviceAddressingAction}.
         */
        public String springWebserviceAddressingAction() {
            return "SpringWebserviceAddressingAction";
        }

        /**
         * Signifies the value for the faultAction response WS-Addressing
         * FaultTo header that is provided by the method. See
         * org.springframework.ws.soap.addressing.server.annotation.Action
         * annotation for more details.
         * 
         * The option is a: {@code java.net.URI} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * SpringWebserviceAddressingFaultTo}.
         */
        public String springWebserviceAddressingFaultTo() {
            return "SpringWebserviceAddressingFaultTo";
        }

        /**
         * Signifies the value for the replyTo response WS-Addressing ReplyTo
         * header that is provided by the method. See
         * org.springframework.ws.soap.addressing.server.annotation.Action
         * annotation for more details.
         * 
         * The option is a: {@code java.net.URI} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * SpringWebserviceAddressingReplyTo}.
         */
        public String springWebserviceAddressingReplyTo() {
            return "SpringWebserviceAddressingReplyTo";
        }

        /**
         * The breadcrumb id.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code breadcrumbId}.
         */
        public String breadcrumbId() {
            return "breadcrumbId";
        }
    }
    static SpringWebserviceEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class SpringWebserviceEndpointBuilderImpl extends AbstractEndpointBuilder implements SpringWebserviceEndpointBuilder, AdvancedSpringWebserviceEndpointBuilder {
            public SpringWebserviceEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new SpringWebserviceEndpointBuilderImpl(path);
    }
}