/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Perform caching operations against JSR107/JCache.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface JCacheEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the JCache component.
     */
    public interface JCacheEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedJCacheEndpointConsumerBuilder advanced() {
            return (AdvancedJCacheEndpointConsumerBuilder) this;
        }
        /**
         * A Configuration for the Cache.
         * 
         * The option is a:
         * &lt;code&gt;javax.cache.configuration.Configuration&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param cacheConfiguration the value to set
         * @return the dsl builder
         */
        default JCacheEndpointConsumerBuilder cacheConfiguration(
                javax.cache.configuration.Configuration cacheConfiguration) {
            doSetProperty("cacheConfiguration", cacheConfiguration);
            return this;
        }
        /**
         * A Configuration for the Cache.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.cache.configuration.Configuration&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param cacheConfiguration the value to set
         * @return the dsl builder
         */
        default JCacheEndpointConsumerBuilder cacheConfiguration(
                String cacheConfiguration) {
            doSetProperty("cacheConfiguration", cacheConfiguration);
            return this;
        }
        /**
         * The Properties for the javax.cache.spi.CachingProvider to create the
         * CacheManager.
         * 
         * The option is a: &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param cacheConfigurationProperties the value to set
         * @return the dsl builder
         */
        default JCacheEndpointConsumerBuilder cacheConfigurationProperties(
                Properties cacheConfigurationProperties) {
            doSetProperty("cacheConfigurationProperties", cacheConfigurationProperties);
            return this;
        }
        /**
         * The Properties for the javax.cache.spi.CachingProvider to create the
         * CacheManager.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param cacheConfigurationProperties the value to set
         * @return the dsl builder
         */
        default JCacheEndpointConsumerBuilder cacheConfigurationProperties(
                String cacheConfigurationProperties) {
            doSetProperty("cacheConfigurationProperties", cacheConfigurationProperties);
            return this;
        }
        /**
         * The fully qualified class name of the
         * javax.cache.spi.CachingProvider.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param cachingProvider the value to set
         * @return the dsl builder
         */
        default JCacheEndpointConsumerBuilder cachingProvider(
                String cachingProvider) {
            doSetProperty("cachingProvider", cachingProvider);
            return this;
        }
        /**
         * An implementation specific URI for the CacheManager.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param configurationUri the value to set
         * @return the dsl builder
         */
        default JCacheEndpointConsumerBuilder configurationUri(
                String configurationUri) {
            doSetProperty("configurationUri", configurationUri);
            return this;
        }
        /**
         * Whether management gathering is enabled.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param managementEnabled the value to set
         * @return the dsl builder
         */
        default JCacheEndpointConsumerBuilder managementEnabled(
                boolean managementEnabled) {
            doSetProperty("managementEnabled", managementEnabled);
            return this;
        }
        /**
         * Whether management gathering is enabled.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param managementEnabled the value to set
         * @return the dsl builder
         */
        default JCacheEndpointConsumerBuilder managementEnabled(
                String managementEnabled) {
            doSetProperty("managementEnabled", managementEnabled);
            return this;
        }
        /**
         * If read-through caching should be used.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param readThrough the value to set
         * @return the dsl builder
         */
        default JCacheEndpointConsumerBuilder readThrough(boolean readThrough) {
            doSetProperty("readThrough", readThrough);
            return this;
        }
        /**
         * If read-through caching should be used.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param readThrough the value to set
         * @return the dsl builder
         */
        default JCacheEndpointConsumerBuilder readThrough(String readThrough) {
            doSetProperty("readThrough", readThrough);
            return this;
        }
        /**
         * Whether statistics gathering is enabled.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param statisticsEnabled the value to set
         * @return the dsl builder
         */
        default JCacheEndpointConsumerBuilder statisticsEnabled(
                boolean statisticsEnabled) {
            doSetProperty("statisticsEnabled", statisticsEnabled);
            return this;
        }
        /**
         * Whether statistics gathering is enabled.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param statisticsEnabled the value to set
         * @return the dsl builder
         */
        default JCacheEndpointConsumerBuilder statisticsEnabled(
                String statisticsEnabled) {
            doSetProperty("statisticsEnabled", statisticsEnabled);
            return this;
        }
        /**
         * If cache should use store-by-value or store-by-reference semantics.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param storeByValue the value to set
         * @return the dsl builder
         */
        default JCacheEndpointConsumerBuilder storeByValue(boolean storeByValue) {
            doSetProperty("storeByValue", storeByValue);
            return this;
        }
        /**
         * If cache should use store-by-value or store-by-reference semantics.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param storeByValue the value to set
         * @return the dsl builder
         */
        default JCacheEndpointConsumerBuilder storeByValue(String storeByValue) {
            doSetProperty("storeByValue", storeByValue);
            return this;
        }
        /**
         * If write-through caching should be used.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param writeThrough the value to set
         * @return the dsl builder
         */
        default JCacheEndpointConsumerBuilder writeThrough(boolean writeThrough) {
            doSetProperty("writeThrough", writeThrough);
            return this;
        }
        /**
         * If write-through caching should be used.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param writeThrough the value to set
         * @return the dsl builder
         */
        default JCacheEndpointConsumerBuilder writeThrough(String writeThrough) {
            doSetProperty("writeThrough", writeThrough);
            return this;
        }
        /**
         * Events a consumer should filter (multiple events can be separated by
         * comma). If using filteredEvents option, then eventFilters one will be
         * ignored.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param filteredEvents the value to set
         * @return the dsl builder
         */
        default JCacheEndpointConsumerBuilder filteredEvents(
                String filteredEvents) {
            doSetProperty("filteredEvents", filteredEvents);
            return this;
        }
        /**
         * if the old value is required for events.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param oldValueRequired the value to set
         * @return the dsl builder
         */
        default JCacheEndpointConsumerBuilder oldValueRequired(
                boolean oldValueRequired) {
            doSetProperty("oldValueRequired", oldValueRequired);
            return this;
        }
        /**
         * if the old value is required for events.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param oldValueRequired the value to set
         * @return the dsl builder
         */
        default JCacheEndpointConsumerBuilder oldValueRequired(
                String oldValueRequired) {
            doSetProperty("oldValueRequired", oldValueRequired);
            return this;
        }
        /**
         * if the event listener should block the thread causing the event.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default JCacheEndpointConsumerBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * if the event listener should block the thread causing the event.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default JCacheEndpointConsumerBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the JCache component.
     */
    public interface AdvancedJCacheEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default JCacheEndpointConsumerBuilder basic() {
            return (JCacheEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * The CacheEntryEventFilter. If using eventFilters option, then
         * filteredEvents one will be ignored.
         * 
         * The option is a:
         * &lt;code&gt;java.util.List&amp;lt;javax.cache.event.CacheEntryEventFilter&amp;gt;&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param eventFilters the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointConsumerBuilder eventFilters(
                List<javax.cache.event.CacheEntryEventFilter> eventFilters) {
            doSetProperty("eventFilters", eventFilters);
            return this;
        }
        /**
         * The CacheEntryEventFilter. If using eventFilters option, then
         * filteredEvents one will be ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.List&amp;lt;javax.cache.event.CacheEntryEventFilter&amp;gt;&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param eventFilters the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointConsumerBuilder eventFilters(
                String eventFilters) {
            doSetProperty("eventFilters", eventFilters);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * The CacheLoader factory.
         * 
         * The option is a:
         * &lt;code&gt;javax.cache.configuration.Factory&amp;lt;javax.cache.integration.CacheLoader&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param cacheLoaderFactory the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointConsumerBuilder cacheLoaderFactory(
                javax.cache.configuration.Factory<javax.cache.integration.CacheLoader> cacheLoaderFactory) {
            doSetProperty("cacheLoaderFactory", cacheLoaderFactory);
            return this;
        }
        /**
         * The CacheLoader factory.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.cache.configuration.Factory&amp;lt;javax.cache.integration.CacheLoader&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param cacheLoaderFactory the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointConsumerBuilder cacheLoaderFactory(
                String cacheLoaderFactory) {
            doSetProperty("cacheLoaderFactory", cacheLoaderFactory);
            return this;
        }
        /**
         * The CacheWriter factory.
         * 
         * The option is a:
         * &lt;code&gt;javax.cache.configuration.Factory&amp;lt;javax.cache.integration.CacheWriter&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param cacheWriterFactory the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointConsumerBuilder cacheWriterFactory(
                javax.cache.configuration.Factory<javax.cache.integration.CacheWriter> cacheWriterFactory) {
            doSetProperty("cacheWriterFactory", cacheWriterFactory);
            return this;
        }
        /**
         * The CacheWriter factory.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.cache.configuration.Factory&amp;lt;javax.cache.integration.CacheWriter&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param cacheWriterFactory the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointConsumerBuilder cacheWriterFactory(
                String cacheWriterFactory) {
            doSetProperty("cacheWriterFactory", cacheWriterFactory);
            return this;
        }
        /**
         * Configure if a cache need to be created if it does exist or can't be
         * pre-configured.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param createCacheIfNotExists the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointConsumerBuilder createCacheIfNotExists(
                boolean createCacheIfNotExists) {
            doSetProperty("createCacheIfNotExists", createCacheIfNotExists);
            return this;
        }
        /**
         * Configure if a cache need to be created if it does exist or can't be
         * pre-configured.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param createCacheIfNotExists the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointConsumerBuilder createCacheIfNotExists(
                String createCacheIfNotExists) {
            doSetProperty("createCacheIfNotExists", createCacheIfNotExists);
            return this;
        }
        /**
         * The ExpiryPolicy factory.
         * 
         * The option is a:
         * &lt;code&gt;javax.cache.configuration.Factory&amp;lt;javax.cache.expiry.ExpiryPolicy&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param expiryPolicyFactory the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointConsumerBuilder expiryPolicyFactory(
                javax.cache.configuration.Factory<javax.cache.expiry.ExpiryPolicy> expiryPolicyFactory) {
            doSetProperty("expiryPolicyFactory", expiryPolicyFactory);
            return this;
        }
        /**
         * The ExpiryPolicy factory.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.cache.configuration.Factory&amp;lt;javax.cache.expiry.ExpiryPolicy&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param expiryPolicyFactory the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointConsumerBuilder expiryPolicyFactory(
                String expiryPolicyFactory) {
            doSetProperty("expiryPolicyFactory", expiryPolicyFactory);
            return this;
        }
        /**
         * Configure if a camel-cache should try to find implementations of
         * jcache api in runtimes like OSGi.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param lookupProviders the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointConsumerBuilder lookupProviders(
                boolean lookupProviders) {
            doSetProperty("lookupProviders", lookupProviders);
            return this;
        }
        /**
         * Configure if a camel-cache should try to find implementations of
         * jcache api in runtimes like OSGi.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param lookupProviders the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointConsumerBuilder lookupProviders(
                String lookupProviders) {
            doSetProperty("lookupProviders", lookupProviders);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the JCache component.
     */
    public interface JCacheEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedJCacheEndpointProducerBuilder advanced() {
            return (AdvancedJCacheEndpointProducerBuilder) this;
        }
        /**
         * A Configuration for the Cache.
         * 
         * The option is a:
         * &lt;code&gt;javax.cache.configuration.Configuration&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param cacheConfiguration the value to set
         * @return the dsl builder
         */
        default JCacheEndpointProducerBuilder cacheConfiguration(
                javax.cache.configuration.Configuration cacheConfiguration) {
            doSetProperty("cacheConfiguration", cacheConfiguration);
            return this;
        }
        /**
         * A Configuration for the Cache.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.cache.configuration.Configuration&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param cacheConfiguration the value to set
         * @return the dsl builder
         */
        default JCacheEndpointProducerBuilder cacheConfiguration(
                String cacheConfiguration) {
            doSetProperty("cacheConfiguration", cacheConfiguration);
            return this;
        }
        /**
         * The Properties for the javax.cache.spi.CachingProvider to create the
         * CacheManager.
         * 
         * The option is a: &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param cacheConfigurationProperties the value to set
         * @return the dsl builder
         */
        default JCacheEndpointProducerBuilder cacheConfigurationProperties(
                Properties cacheConfigurationProperties) {
            doSetProperty("cacheConfigurationProperties", cacheConfigurationProperties);
            return this;
        }
        /**
         * The Properties for the javax.cache.spi.CachingProvider to create the
         * CacheManager.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param cacheConfigurationProperties the value to set
         * @return the dsl builder
         */
        default JCacheEndpointProducerBuilder cacheConfigurationProperties(
                String cacheConfigurationProperties) {
            doSetProperty("cacheConfigurationProperties", cacheConfigurationProperties);
            return this;
        }
        /**
         * The fully qualified class name of the
         * javax.cache.spi.CachingProvider.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param cachingProvider the value to set
         * @return the dsl builder
         */
        default JCacheEndpointProducerBuilder cachingProvider(
                String cachingProvider) {
            doSetProperty("cachingProvider", cachingProvider);
            return this;
        }
        /**
         * An implementation specific URI for the CacheManager.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param configurationUri the value to set
         * @return the dsl builder
         */
        default JCacheEndpointProducerBuilder configurationUri(
                String configurationUri) {
            doSetProperty("configurationUri", configurationUri);
            return this;
        }
        /**
         * Whether management gathering is enabled.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param managementEnabled the value to set
         * @return the dsl builder
         */
        default JCacheEndpointProducerBuilder managementEnabled(
                boolean managementEnabled) {
            doSetProperty("managementEnabled", managementEnabled);
            return this;
        }
        /**
         * Whether management gathering is enabled.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param managementEnabled the value to set
         * @return the dsl builder
         */
        default JCacheEndpointProducerBuilder managementEnabled(
                String managementEnabled) {
            doSetProperty("managementEnabled", managementEnabled);
            return this;
        }
        /**
         * If read-through caching should be used.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param readThrough the value to set
         * @return the dsl builder
         */
        default JCacheEndpointProducerBuilder readThrough(boolean readThrough) {
            doSetProperty("readThrough", readThrough);
            return this;
        }
        /**
         * If read-through caching should be used.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param readThrough the value to set
         * @return the dsl builder
         */
        default JCacheEndpointProducerBuilder readThrough(String readThrough) {
            doSetProperty("readThrough", readThrough);
            return this;
        }
        /**
         * Whether statistics gathering is enabled.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param statisticsEnabled the value to set
         * @return the dsl builder
         */
        default JCacheEndpointProducerBuilder statisticsEnabled(
                boolean statisticsEnabled) {
            doSetProperty("statisticsEnabled", statisticsEnabled);
            return this;
        }
        /**
         * Whether statistics gathering is enabled.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param statisticsEnabled the value to set
         * @return the dsl builder
         */
        default JCacheEndpointProducerBuilder statisticsEnabled(
                String statisticsEnabled) {
            doSetProperty("statisticsEnabled", statisticsEnabled);
            return this;
        }
        /**
         * If cache should use store-by-value or store-by-reference semantics.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param storeByValue the value to set
         * @return the dsl builder
         */
        default JCacheEndpointProducerBuilder storeByValue(boolean storeByValue) {
            doSetProperty("storeByValue", storeByValue);
            return this;
        }
        /**
         * If cache should use store-by-value or store-by-reference semantics.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param storeByValue the value to set
         * @return the dsl builder
         */
        default JCacheEndpointProducerBuilder storeByValue(String storeByValue) {
            doSetProperty("storeByValue", storeByValue);
            return this;
        }
        /**
         * If write-through caching should be used.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param writeThrough the value to set
         * @return the dsl builder
         */
        default JCacheEndpointProducerBuilder writeThrough(boolean writeThrough) {
            doSetProperty("writeThrough", writeThrough);
            return this;
        }
        /**
         * If write-through caching should be used.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param writeThrough the value to set
         * @return the dsl builder
         */
        default JCacheEndpointProducerBuilder writeThrough(String writeThrough) {
            doSetProperty("writeThrough", writeThrough);
            return this;
        }
        /**
         * To configure using a cache operation by default. If an operation in
         * the message header, then the operation from the header takes
         * precedence.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param action the value to set
         * @return the dsl builder
         */
        default JCacheEndpointProducerBuilder action(String action) {
            doSetProperty("action", action);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the JCache component.
     */
    public interface AdvancedJCacheEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default JCacheEndpointProducerBuilder basic() {
            return (JCacheEndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The CacheLoader factory.
         * 
         * The option is a:
         * &lt;code&gt;javax.cache.configuration.Factory&amp;lt;javax.cache.integration.CacheLoader&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param cacheLoaderFactory the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointProducerBuilder cacheLoaderFactory(
                javax.cache.configuration.Factory<javax.cache.integration.CacheLoader> cacheLoaderFactory) {
            doSetProperty("cacheLoaderFactory", cacheLoaderFactory);
            return this;
        }
        /**
         * The CacheLoader factory.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.cache.configuration.Factory&amp;lt;javax.cache.integration.CacheLoader&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param cacheLoaderFactory the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointProducerBuilder cacheLoaderFactory(
                String cacheLoaderFactory) {
            doSetProperty("cacheLoaderFactory", cacheLoaderFactory);
            return this;
        }
        /**
         * The CacheWriter factory.
         * 
         * The option is a:
         * &lt;code&gt;javax.cache.configuration.Factory&amp;lt;javax.cache.integration.CacheWriter&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param cacheWriterFactory the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointProducerBuilder cacheWriterFactory(
                javax.cache.configuration.Factory<javax.cache.integration.CacheWriter> cacheWriterFactory) {
            doSetProperty("cacheWriterFactory", cacheWriterFactory);
            return this;
        }
        /**
         * The CacheWriter factory.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.cache.configuration.Factory&amp;lt;javax.cache.integration.CacheWriter&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param cacheWriterFactory the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointProducerBuilder cacheWriterFactory(
                String cacheWriterFactory) {
            doSetProperty("cacheWriterFactory", cacheWriterFactory);
            return this;
        }
        /**
         * Configure if a cache need to be created if it does exist or can't be
         * pre-configured.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param createCacheIfNotExists the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointProducerBuilder createCacheIfNotExists(
                boolean createCacheIfNotExists) {
            doSetProperty("createCacheIfNotExists", createCacheIfNotExists);
            return this;
        }
        /**
         * Configure if a cache need to be created if it does exist or can't be
         * pre-configured.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param createCacheIfNotExists the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointProducerBuilder createCacheIfNotExists(
                String createCacheIfNotExists) {
            doSetProperty("createCacheIfNotExists", createCacheIfNotExists);
            return this;
        }
        /**
         * The ExpiryPolicy factory.
         * 
         * The option is a:
         * &lt;code&gt;javax.cache.configuration.Factory&amp;lt;javax.cache.expiry.ExpiryPolicy&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param expiryPolicyFactory the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointProducerBuilder expiryPolicyFactory(
                javax.cache.configuration.Factory<javax.cache.expiry.ExpiryPolicy> expiryPolicyFactory) {
            doSetProperty("expiryPolicyFactory", expiryPolicyFactory);
            return this;
        }
        /**
         * The ExpiryPolicy factory.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.cache.configuration.Factory&amp;lt;javax.cache.expiry.ExpiryPolicy&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param expiryPolicyFactory the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointProducerBuilder expiryPolicyFactory(
                String expiryPolicyFactory) {
            doSetProperty("expiryPolicyFactory", expiryPolicyFactory);
            return this;
        }
        /**
         * Configure if a camel-cache should try to find implementations of
         * jcache api in runtimes like OSGi.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param lookupProviders the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointProducerBuilder lookupProviders(
                boolean lookupProviders) {
            doSetProperty("lookupProviders", lookupProviders);
            return this;
        }
        /**
         * Configure if a camel-cache should try to find implementations of
         * jcache api in runtimes like OSGi.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param lookupProviders the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointProducerBuilder lookupProviders(
                String lookupProviders) {
            doSetProperty("lookupProviders", lookupProviders);
            return this;
        }
    }

    /**
     * Builder for endpoint for the JCache component.
     */
    public interface JCacheEndpointBuilder
            extends
                JCacheEndpointConsumerBuilder,
                JCacheEndpointProducerBuilder {
        default AdvancedJCacheEndpointBuilder advanced() {
            return (AdvancedJCacheEndpointBuilder) this;
        }
        /**
         * A Configuration for the Cache.
         * 
         * The option is a:
         * &lt;code&gt;javax.cache.configuration.Configuration&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param cacheConfiguration the value to set
         * @return the dsl builder
         */
        default JCacheEndpointBuilder cacheConfiguration(
                javax.cache.configuration.Configuration cacheConfiguration) {
            doSetProperty("cacheConfiguration", cacheConfiguration);
            return this;
        }
        /**
         * A Configuration for the Cache.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.cache.configuration.Configuration&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param cacheConfiguration the value to set
         * @return the dsl builder
         */
        default JCacheEndpointBuilder cacheConfiguration(
                String cacheConfiguration) {
            doSetProperty("cacheConfiguration", cacheConfiguration);
            return this;
        }
        /**
         * The Properties for the javax.cache.spi.CachingProvider to create the
         * CacheManager.
         * 
         * The option is a: &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param cacheConfigurationProperties the value to set
         * @return the dsl builder
         */
        default JCacheEndpointBuilder cacheConfigurationProperties(
                Properties cacheConfigurationProperties) {
            doSetProperty("cacheConfigurationProperties", cacheConfigurationProperties);
            return this;
        }
        /**
         * The Properties for the javax.cache.spi.CachingProvider to create the
         * CacheManager.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param cacheConfigurationProperties the value to set
         * @return the dsl builder
         */
        default JCacheEndpointBuilder cacheConfigurationProperties(
                String cacheConfigurationProperties) {
            doSetProperty("cacheConfigurationProperties", cacheConfigurationProperties);
            return this;
        }
        /**
         * The fully qualified class name of the
         * javax.cache.spi.CachingProvider.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param cachingProvider the value to set
         * @return the dsl builder
         */
        default JCacheEndpointBuilder cachingProvider(String cachingProvider) {
            doSetProperty("cachingProvider", cachingProvider);
            return this;
        }
        /**
         * An implementation specific URI for the CacheManager.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param configurationUri the value to set
         * @return the dsl builder
         */
        default JCacheEndpointBuilder configurationUri(String configurationUri) {
            doSetProperty("configurationUri", configurationUri);
            return this;
        }
        /**
         * Whether management gathering is enabled.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param managementEnabled the value to set
         * @return the dsl builder
         */
        default JCacheEndpointBuilder managementEnabled(
                boolean managementEnabled) {
            doSetProperty("managementEnabled", managementEnabled);
            return this;
        }
        /**
         * Whether management gathering is enabled.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param managementEnabled the value to set
         * @return the dsl builder
         */
        default JCacheEndpointBuilder managementEnabled(String managementEnabled) {
            doSetProperty("managementEnabled", managementEnabled);
            return this;
        }
        /**
         * If read-through caching should be used.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param readThrough the value to set
         * @return the dsl builder
         */
        default JCacheEndpointBuilder readThrough(boolean readThrough) {
            doSetProperty("readThrough", readThrough);
            return this;
        }
        /**
         * If read-through caching should be used.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param readThrough the value to set
         * @return the dsl builder
         */
        default JCacheEndpointBuilder readThrough(String readThrough) {
            doSetProperty("readThrough", readThrough);
            return this;
        }
        /**
         * Whether statistics gathering is enabled.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param statisticsEnabled the value to set
         * @return the dsl builder
         */
        default JCacheEndpointBuilder statisticsEnabled(
                boolean statisticsEnabled) {
            doSetProperty("statisticsEnabled", statisticsEnabled);
            return this;
        }
        /**
         * Whether statistics gathering is enabled.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param statisticsEnabled the value to set
         * @return the dsl builder
         */
        default JCacheEndpointBuilder statisticsEnabled(String statisticsEnabled) {
            doSetProperty("statisticsEnabled", statisticsEnabled);
            return this;
        }
        /**
         * If cache should use store-by-value or store-by-reference semantics.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param storeByValue the value to set
         * @return the dsl builder
         */
        default JCacheEndpointBuilder storeByValue(boolean storeByValue) {
            doSetProperty("storeByValue", storeByValue);
            return this;
        }
        /**
         * If cache should use store-by-value or store-by-reference semantics.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param storeByValue the value to set
         * @return the dsl builder
         */
        default JCacheEndpointBuilder storeByValue(String storeByValue) {
            doSetProperty("storeByValue", storeByValue);
            return this;
        }
        /**
         * If write-through caching should be used.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param writeThrough the value to set
         * @return the dsl builder
         */
        default JCacheEndpointBuilder writeThrough(boolean writeThrough) {
            doSetProperty("writeThrough", writeThrough);
            return this;
        }
        /**
         * If write-through caching should be used.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param writeThrough the value to set
         * @return the dsl builder
         */
        default JCacheEndpointBuilder writeThrough(String writeThrough) {
            doSetProperty("writeThrough", writeThrough);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the JCache component.
     */
    public interface AdvancedJCacheEndpointBuilder
            extends
                AdvancedJCacheEndpointConsumerBuilder,
                AdvancedJCacheEndpointProducerBuilder {
        default JCacheEndpointBuilder basic() {
            return (JCacheEndpointBuilder) this;
        }
        /**
         * The CacheLoader factory.
         * 
         * The option is a:
         * &lt;code&gt;javax.cache.configuration.Factory&amp;lt;javax.cache.integration.CacheLoader&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param cacheLoaderFactory the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointBuilder cacheLoaderFactory(
                javax.cache.configuration.Factory<javax.cache.integration.CacheLoader> cacheLoaderFactory) {
            doSetProperty("cacheLoaderFactory", cacheLoaderFactory);
            return this;
        }
        /**
         * The CacheLoader factory.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.cache.configuration.Factory&amp;lt;javax.cache.integration.CacheLoader&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param cacheLoaderFactory the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointBuilder cacheLoaderFactory(
                String cacheLoaderFactory) {
            doSetProperty("cacheLoaderFactory", cacheLoaderFactory);
            return this;
        }
        /**
         * The CacheWriter factory.
         * 
         * The option is a:
         * &lt;code&gt;javax.cache.configuration.Factory&amp;lt;javax.cache.integration.CacheWriter&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param cacheWriterFactory the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointBuilder cacheWriterFactory(
                javax.cache.configuration.Factory<javax.cache.integration.CacheWriter> cacheWriterFactory) {
            doSetProperty("cacheWriterFactory", cacheWriterFactory);
            return this;
        }
        /**
         * The CacheWriter factory.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.cache.configuration.Factory&amp;lt;javax.cache.integration.CacheWriter&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param cacheWriterFactory the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointBuilder cacheWriterFactory(
                String cacheWriterFactory) {
            doSetProperty("cacheWriterFactory", cacheWriterFactory);
            return this;
        }
        /**
         * Configure if a cache need to be created if it does exist or can't be
         * pre-configured.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param createCacheIfNotExists the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointBuilder createCacheIfNotExists(
                boolean createCacheIfNotExists) {
            doSetProperty("createCacheIfNotExists", createCacheIfNotExists);
            return this;
        }
        /**
         * Configure if a cache need to be created if it does exist or can't be
         * pre-configured.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param createCacheIfNotExists the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointBuilder createCacheIfNotExists(
                String createCacheIfNotExists) {
            doSetProperty("createCacheIfNotExists", createCacheIfNotExists);
            return this;
        }
        /**
         * The ExpiryPolicy factory.
         * 
         * The option is a:
         * &lt;code&gt;javax.cache.configuration.Factory&amp;lt;javax.cache.expiry.ExpiryPolicy&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param expiryPolicyFactory the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointBuilder expiryPolicyFactory(
                javax.cache.configuration.Factory<javax.cache.expiry.ExpiryPolicy> expiryPolicyFactory) {
            doSetProperty("expiryPolicyFactory", expiryPolicyFactory);
            return this;
        }
        /**
         * The ExpiryPolicy factory.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.cache.configuration.Factory&amp;lt;javax.cache.expiry.ExpiryPolicy&amp;gt;&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param expiryPolicyFactory the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointBuilder expiryPolicyFactory(
                String expiryPolicyFactory) {
            doSetProperty("expiryPolicyFactory", expiryPolicyFactory);
            return this;
        }
        /**
         * Configure if a camel-cache should try to find implementations of
         * jcache api in runtimes like OSGi.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param lookupProviders the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointBuilder lookupProviders(
                boolean lookupProviders) {
            doSetProperty("lookupProviders", lookupProviders);
            return this;
        }
        /**
         * Configure if a camel-cache should try to find implementations of
         * jcache api in runtimes like OSGi.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param lookupProviders the value to set
         * @return the dsl builder
         */
        default AdvancedJCacheEndpointBuilder lookupProviders(
                String lookupProviders) {
            doSetProperty("lookupProviders", lookupProviders);
            return this;
        }
    }

    public interface JCacheBuilders {
        /**
         * JCache (camel-jcache)
         * Perform caching operations against JSR107/JCache.
         * 
         * Category: cache,clustering
         * Since: 2.17
         * Maven coordinates: org.apache.camel:camel-jcache
         * 
         * @return the dsl builder for the headers' name.
         */
        default JCacheHeaderNameBuilder jcache() {
            return JCacheHeaderNameBuilder.INSTANCE;
        }
        /**
         * JCache (camel-jcache)
         * Perform caching operations against JSR107/JCache.
         * 
         * Category: cache,clustering
         * Since: 2.17
         * Maven coordinates: org.apache.camel:camel-jcache
         * 
         * Syntax: <code>jcache:cacheName</code>
         * 
         * Path parameter: cacheName (required)
         * The name of the cache
         * 
         * @param path cacheName
         * @return the dsl builder
         */
        default JCacheEndpointBuilder jcache(String path) {
            return JCacheEndpointBuilderFactory.endpointBuilder("jcache", path);
        }
        /**
         * JCache (camel-jcache)
         * Perform caching operations against JSR107/JCache.
         * 
         * Category: cache,clustering
         * Since: 2.17
         * Maven coordinates: org.apache.camel:camel-jcache
         * 
         * Syntax: <code>jcache:cacheName</code>
         * 
         * Path parameter: cacheName (required)
         * The name of the cache
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path cacheName
         * @return the dsl builder
         */
        default JCacheEndpointBuilder jcache(String componentName, String path) {
            return JCacheEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the JCache component.
     */
    public static class JCacheHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final JCacheHeaderNameBuilder INSTANCE = new JCacheHeaderNameBuilder();

        /**
         * The cache operation to perform.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code JCacheAction}.
         */
        public String jCacheAction() {
            return "CamelJCacheAction";
        }

        /**
         * The result of the cache operation.
         * 
         * The option is a: {@code boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code JCacheResult}.
         */
        public String jCacheResult() {
            return "CamelJCacheResult";
        }

        /**
         * The type of event received.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code JCacheEventType}.
         */
        public String jCacheEventType() {
            return "CamelJCacheEventType";
        }

        /**
         * The key of the cache entry.
         * 
         * The option is a: {@code Object} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code JCacheKey}.
         */
        public String jCacheKey() {
            return "CamelJCacheKey";
        }

        /**
         * The collection of keys against which the action should be performed.
         * 
         * The option is a: {@code Set<Object>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code JCacheKeys}.
         */
        public String jCacheKeys() {
            return "CamelJCacheKeys";
        }

        /**
         * The old value of the cache entry.
         * 
         * The option is a: {@code Object} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code JCacheOldValue}.
         */
        public String jCacheOldValue() {
            return "CamelJCacheOldValue";
        }

        /**
         * The EntryProcessor to invoke.
         * 
         * The option is a: {@code EntryProcessor<Object, Object, Object>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code JCacheEntryProcessor}.
         */
        public String jCacheEntryProcessor() {
            return "CamelJCacheEntryProcessor";
        }

        /**
         * The additional arguments to pass to the EntryProcessor.
         * 
         * The option is a: {@code Collection<Object>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code JCacheEntryArgs}.
         */
        public String jCacheEntryArgs() {
            return "CamelJCacheEntryArgs";
        }
    }
    static JCacheEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class JCacheEndpointBuilderImpl extends AbstractEndpointBuilder implements JCacheEndpointBuilder, AdvancedJCacheEndpointBuilder {
            public JCacheEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new JCacheEndpointBuilderImpl(path);
    }
}