/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Perform operations on MongoDB documents and collections.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface MongoDbEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the MongoDB component.
     */
    public interface MongoDbEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedMongoDbEndpointConsumerBuilder advanced() {
            return (AdvancedMongoDbEndpointConsumerBuilder) this;
        }
        /**
         * Sets the name of the MongoDB collection to bind to this endpoint.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param collection the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder collection(String collection) {
            doSetProperty("collection", collection);
            return this;
        }
        /**
         * Sets the collection index (JSON FORMAT : { field1 : order1, field2 :
         * order2}).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param collectionIndex the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder collectionIndex(
                String collectionIndex) {
            doSetProperty("collectionIndex", collectionIndex);
            return this;
        }
        /**
         * Create collection during initialisation if it doesn't exist. Default
         * is true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param createCollection the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder createCollection(
                boolean createCollection) {
            doSetProperty("createCollection", createCollection);
            return this;
        }
        /**
         * Create collection during initialisation if it doesn't exist. Default
         * is true.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param createCollection the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder createCollection(
                String createCollection) {
            doSetProperty("createCollection", createCollection);
            return this;
        }
        /**
         * Sets the name of the MongoDB database to target.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param database the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder database(String database) {
            doSetProperty("database", database);
            return this;
        }
        /**
         * Host address of mongodb server in host:port format. It's possible
         * also use more than one address, as comma separated list of hosts:
         * host1:port1,host2:port2. If the hosts parameter is specified, the
         * provided connectionBean is ignored.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param hosts the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder hosts(String hosts) {
            doSetProperty("hosts", hosts);
            return this;
        }
        /**
         * Sets the connection bean used as a client for connecting to a
         * database.
         * 
         * The option is a:
         * &lt;code&gt;com.mongodb.client.MongoClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param mongoConnection the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder mongoConnection(
                com.mongodb.client.MongoClient mongoConnection) {
            doSetProperty("mongoConnection", mongoConnection);
            return this;
        }
        /**
         * Sets the connection bean used as a client for connecting to a
         * database.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.mongodb.client.MongoClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param mongoConnection the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder mongoConnection(
                String mongoConnection) {
            doSetProperty("mongoConnection", mongoConnection);
            return this;
        }
        /**
         * Sets the operation this endpoint will execute against MongoDB.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.mongodb.MongoDbOperation&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder operation(
                org.apache.camel.component.mongodb.MongoDbOperation operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Sets the operation this endpoint will execute against MongoDB.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.mongodb.MongoDbOperation&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Convert the output of the producer to the selected type :
         * DocumentList Document or MongoIterable. DocumentList or MongoIterable
         * applies to findAll and aggregate. Document applies to all other
         * operations.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.mongodb.MongoDbOutputType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param outputType the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder outputType(
                org.apache.camel.component.mongodb.MongoDbOutputType outputType) {
            doSetProperty("outputType", outputType);
            return this;
        }
        /**
         * Convert the output of the producer to the selected type :
         * DocumentList Document or MongoIterable. DocumentList or MongoIterable
         * applies to findAll and aggregate. Document applies to all other
         * operations.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.mongodb.MongoDbOutputType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param outputType the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder outputType(String outputType) {
            doSetProperty("outputType", outputType);
            return this;
        }
        /**
         * Consumer type.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param consumerType the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder consumerType(String consumerType) {
            doSetProperty("consumerType", consumerType);
            return this;
        }
        /**
         * Specifies whether changeStream consumer include a copy of the full
         * document when modified by update operations. Possible values are
         * default, updateLookup, required and whenAvailable.
         * 
         * The option is a:
         * &lt;code&gt;com.mongodb.client.model.changestream.FullDocument&lt;/code&gt; type.
         * 
         * Default: default
         * Group: changeStream
         * 
         * @param fullDocument the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder fullDocument(
                com.mongodb.client.model.changestream.FullDocument fullDocument) {
            doSetProperty("fullDocument", fullDocument);
            return this;
        }
        /**
         * Specifies whether changeStream consumer include a copy of the full
         * document when modified by update operations. Possible values are
         * default, updateLookup, required and whenAvailable.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.mongodb.client.model.changestream.FullDocument&lt;/code&gt; type.
         * 
         * Default: default
         * Group: changeStream
         * 
         * @param fullDocument the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder fullDocument(String fullDocument) {
            doSetProperty("fullDocument", fullDocument);
            return this;
        }
        /**
         * Filter condition for change streams consumer.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: changeStream
         * 
         * @param streamFilter the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder streamFilter(String streamFilter) {
            doSetProperty("streamFilter", streamFilter);
            return this;
        }
        /**
         * The database name associated with the user's credentials.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param authSource the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder authSource(String authSource) {
            doSetProperty("authSource", authSource);
            return this;
        }
        /**
         * User password for mongodb connection.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Username for mongodb connection.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
        /**
         * One tail tracking collection can host many trackers for several
         * tailable consumers. To keep them separate, each tracker should have
         * its own unique persistentId.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: tail
         * 
         * @param persistentId the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder persistentId(String persistentId) {
            doSetProperty("persistentId", persistentId);
            return this;
        }
        /**
         * Enable persistent tail tracking, which is a mechanism to keep track
         * of the last consumed message across system restarts. The next time
         * the system is up, the endpoint will recover the cursor from the point
         * where it last stopped slurping records.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: tail
         * 
         * @param persistentTailTracking the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder persistentTailTracking(
                boolean persistentTailTracking) {
            doSetProperty("persistentTailTracking", persistentTailTracking);
            return this;
        }
        /**
         * Enable persistent tail tracking, which is a mechanism to keep track
         * of the last consumed message across system restarts. The next time
         * the system is up, the endpoint will recover the cursor from the point
         * where it last stopped slurping records.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: tail
         * 
         * @param persistentTailTracking the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder persistentTailTracking(
                String persistentTailTracking) {
            doSetProperty("persistentTailTracking", persistentTailTracking);
            return this;
        }
        /**
         * Collection where tail tracking information will be persisted. If not
         * specified, MongoDbTailTrackingConfig#DEFAULT_COLLECTION will be used
         * by default.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: tail
         * 
         * @param tailTrackCollection the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder tailTrackCollection(
                String tailTrackCollection) {
            doSetProperty("tailTrackCollection", tailTrackCollection);
            return this;
        }
        /**
         * Indicates what database the tail tracking mechanism will persist to.
         * If not specified, the current database will be picked by default.
         * Dynamicity will not be taken into account even if enabled, i.e. the
         * tail tracking database will not vary past endpoint initialisation.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: tail
         * 
         * @param tailTrackDb the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder tailTrackDb(String tailTrackDb) {
            doSetProperty("tailTrackDb", tailTrackDb);
            return this;
        }
        /**
         * Field where the last tracked value will be placed. If not specified,
         * MongoDbTailTrackingConfig#DEFAULT_FIELD will be used by default.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: tail
         * 
         * @param tailTrackField the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder tailTrackField(
                String tailTrackField) {
            doSetProperty("tailTrackField", tailTrackField);
            return this;
        }
        /**
         * Correlation field in the incoming record which is of increasing
         * nature and will be used to position the tailing cursor every time it
         * is generated. The cursor will be (re)created with a query of type:
         * tailTrackIncreasingField greater than lastValue (possibly recovered
         * from persistent tail tracking). Can be of type Integer, Date, String,
         * etc. NOTE: No support for dot notation at the current time, so the
         * field should be at the top level of the document.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: tail
         * 
         * @param tailTrackIncreasingField the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointConsumerBuilder tailTrackIncreasingField(
                String tailTrackIncreasingField) {
            doSetProperty("tailTrackIncreasingField", tailTrackIncreasingField);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the MongoDB component.
     */
    public interface AdvancedMongoDbEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default MongoDbEndpointConsumerBuilder basic() {
            return (MongoDbEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the logical name of the application. The application name may be
         * used by the client to identify the application to the server, for use
         * in server logs, slow query logs, and profile collection. Default:
         * null.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param appName the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder appName(String appName) {
            doSetProperty("appName", appName);
            return this;
        }
        /**
         * Specifies one or more compression algorithms that the driver will
         * attempt to use to compress requests sent to the connected MongoDB
         * instance. Possible values include: zlib, snappy, and zstd. Default:
         * null.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param compressors the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder compressors(
                String compressors) {
            doSetProperty("compressors", compressors);
            return this;
        }
        /**
         * Specifies the maximum amount of time, in milliseconds, the Java
         * driver waits for a connection to open before timing out. A value of 0
         * instructs the driver to never time out while waiting for a connection
         * to open. Default: 10000 (10 seconds).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: advanced
         * 
         * @param connectTimeoutMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder connectTimeoutMS(
                Integer connectTimeoutMS) {
            doSetProperty("connectTimeoutMS", connectTimeoutMS);
            return this;
        }
        /**
         * Specifies the maximum amount of time, in milliseconds, the Java
         * driver waits for a connection to open before timing out. A value of 0
         * instructs the driver to never time out while waiting for a connection
         * to open. Default: 10000 (10 seconds).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: advanced
         * 
         * @param connectTimeoutMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder connectTimeoutMS(
                String connectTimeoutMS) {
            doSetProperty("connectTimeoutMS", connectTimeoutMS);
            return this;
        }
        /**
         * MongoDB tailable cursors will block until new data arrives. If no new
         * data is inserted, after some time the cursor will be automatically
         * freed and closed by the MongoDB server. The client is expected to
         * regenerate the cursor if needed. This value specifies the time to
         * wait before attempting to fetch a new cursor, and if the attempt
         * fails, how long before the next attempt is made. Default value is
         * 1000ms.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param cursorRegenerationDelay the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder cursorRegenerationDelay(
                long cursorRegenerationDelay) {
            doSetProperty("cursorRegenerationDelay", cursorRegenerationDelay);
            return this;
        }
        /**
         * MongoDB tailable cursors will block until new data arrives. If no new
         * data is inserted, after some time the cursor will be automatically
         * freed and closed by the MongoDB server. The client is expected to
         * regenerate the cursor if needed. This value specifies the time to
         * wait before attempting to fetch a new cursor, and if the attempt
         * fails, how long before the next attempt is made. Default value is
         * 1000ms.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param cursorRegenerationDelay the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder cursorRegenerationDelay(
                String cursorRegenerationDelay) {
            doSetProperty("cursorRegenerationDelay", cursorRegenerationDelay);
            return this;
        }
        /**
         * Specifies that the driver must connect to the host directly. Default:
         * false.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param directConnection the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder directConnection(
                boolean directConnection) {
            doSetProperty("directConnection", directConnection);
            return this;
        }
        /**
         * Specifies that the driver must connect to the host directly. Default:
         * false.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param directConnection the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder directConnection(
                String directConnection) {
            doSetProperty("directConnection", directConnection);
            return this;
        }
        /**
         * Sets whether this endpoint will attempt to dynamically resolve the
         * target database and collection from the incoming Exchange properties.
         * Can be used to override at runtime the database and collection
         * specified on the otherwise static endpoint URI. It is disabled by
         * default to boost performance. Enabling it will take a minimal
         * performance hit.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param dynamicity the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder dynamicity(
                boolean dynamicity) {
            doSetProperty("dynamicity", dynamicity);
            return this;
        }
        /**
         * Sets whether this endpoint will attempt to dynamically resolve the
         * target database and collection from the incoming Exchange properties.
         * Can be used to override at runtime the database and collection
         * specified on the otherwise static endpoint URI. It is disabled by
         * default to boost performance. Enabling it will take a minimal
         * performance hit.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param dynamicity the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder dynamicity(
                String dynamicity) {
            doSetProperty("dynamicity", dynamicity);
            return this;
        }
        /**
         * heartbeatFrequencyMS controls when the driver checks the state of the
         * MongoDB deployment. Specify the interval (in milliseconds) between
         * checks, counted from the end of the previous check until the
         * beginning of the next one. Default: Single-threaded drivers: 60
         * seconds. Multi-threaded drivers: 10 seconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param heartbeatFrequencyMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder heartbeatFrequencyMS(
                Integer heartbeatFrequencyMS) {
            doSetProperty("heartbeatFrequencyMS", heartbeatFrequencyMS);
            return this;
        }
        /**
         * heartbeatFrequencyMS controls when the driver checks the state of the
         * MongoDB deployment. Specify the interval (in milliseconds) between
         * checks, counted from the end of the previous check until the
         * beginning of the next one. Default: Single-threaded drivers: 60
         * seconds. Multi-threaded drivers: 10 seconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param heartbeatFrequencyMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder heartbeatFrequencyMS(
                String heartbeatFrequencyMS) {
            doSetProperty("heartbeatFrequencyMS", heartbeatFrequencyMS);
            return this;
        }
        /**
         * If true the driver will assume that it's connecting to MongoDB
         * through a load balancer.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param loadBalanced the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder loadBalanced(
                boolean loadBalanced) {
            doSetProperty("loadBalanced", loadBalanced);
            return this;
        }
        /**
         * If true the driver will assume that it's connecting to MongoDB
         * through a load balancer.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param loadBalanced the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder loadBalanced(
                String loadBalanced) {
            doSetProperty("loadBalanced", loadBalanced);
            return this;
        }
        /**
         * The size (in milliseconds) of the latency window for selecting among
         * multiple suitable MongoDB instances. Default: 15 milliseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 15
         * Group: advanced
         * 
         * @param localThresholdMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder localThresholdMS(
                Integer localThresholdMS) {
            doSetProperty("localThresholdMS", localThresholdMS);
            return this;
        }
        /**
         * The size (in milliseconds) of the latency window for selecting among
         * multiple suitable MongoDB instances. Default: 15 milliseconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 15
         * Group: advanced
         * 
         * @param localThresholdMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder localThresholdMS(
                String localThresholdMS) {
            doSetProperty("localThresholdMS", localThresholdMS);
            return this;
        }
        /**
         * Specifies the maximum number of connections a pool may be
         * establishing concurrently. Default: 2.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 2
         * Group: advanced
         * 
         * @param maxConnecting the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder maxConnecting(
                Integer maxConnecting) {
            doSetProperty("maxConnecting", maxConnecting);
            return this;
        }
        /**
         * Specifies the maximum number of connections a pool may be
         * establishing concurrently. Default: 2.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 2
         * Group: advanced
         * 
         * @param maxConnecting the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder maxConnecting(
                String maxConnecting) {
            doSetProperty("maxConnecting", maxConnecting);
            return this;
        }
        /**
         * Specifies the maximum amount of time, in milliseconds, the Java
         * driver will allow a pooled connection to idle before closing the
         * connection. A value of 0 indicates that there is no upper bound on
         * how long the driver can allow a pooled collection to be idle.
         * Default: 0.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: advanced
         * 
         * @param maxIdleTimeMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder maxIdleTimeMS(
                Integer maxIdleTimeMS) {
            doSetProperty("maxIdleTimeMS", maxIdleTimeMS);
            return this;
        }
        /**
         * Specifies the maximum amount of time, in milliseconds, the Java
         * driver will allow a pooled connection to idle before closing the
         * connection. A value of 0 indicates that there is no upper bound on
         * how long the driver can allow a pooled collection to be idle.
         * Default: 0.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: advanced
         * 
         * @param maxIdleTimeMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder maxIdleTimeMS(
                String maxIdleTimeMS) {
            doSetProperty("maxIdleTimeMS", maxIdleTimeMS);
            return this;
        }
        /**
         * Specifies the maximum amount of time, in milliseconds, the Java
         * driver will continue to use a pooled connection before closing the
         * connection. A value of 0 indicates that there is no upper bound on
         * how long the driver can keep a pooled connection open. Default: 0.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: advanced
         * 
         * @param maxLifeTimeMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder maxLifeTimeMS(
                Integer maxLifeTimeMS) {
            doSetProperty("maxLifeTimeMS", maxLifeTimeMS);
            return this;
        }
        /**
         * Specifies the maximum amount of time, in milliseconds, the Java
         * driver will continue to use a pooled connection before closing the
         * connection. A value of 0 indicates that there is no upper bound on
         * how long the driver can keep a pooled connection open. Default: 0.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: advanced
         * 
         * @param maxLifeTimeMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder maxLifeTimeMS(
                String maxLifeTimeMS) {
            doSetProperty("maxLifeTimeMS", maxLifeTimeMS);
            return this;
        }
        /**
         * The maximum number of connections in the connection pool. The default
         * value is 100.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: advanced
         * 
         * @param maxPoolSize the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder maxPoolSize(
                Integer maxPoolSize) {
            doSetProperty("maxPoolSize", maxPoolSize);
            return this;
        }
        /**
         * The maximum number of connections in the connection pool. The default
         * value is 100.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: advanced
         * 
         * @param maxPoolSize the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder maxPoolSize(
                String maxPoolSize) {
            doSetProperty("maxPoolSize", maxPoolSize);
            return this;
        }
        /**
         * Specifies, in seconds, how stale a secondary can be before the driver
         * stops communicating with that secondary. The minimum value is either
         * 90 seconds or the heartbeat frequency plus 10 seconds, whichever is
         * greater. For more information, see the server documentation for the
         * maxStalenessSeconds option. Not providing a parameter or explicitly
         * specifying -1 indicates that there should be no staleness check for
         * secondaries. Default: -1.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: advanced
         * 
         * @param maxStalenessSeconds the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder maxStalenessSeconds(
                Integer maxStalenessSeconds) {
            doSetProperty("maxStalenessSeconds", maxStalenessSeconds);
            return this;
        }
        /**
         * Specifies, in seconds, how stale a secondary can be before the driver
         * stops communicating with that secondary. The minimum value is either
         * 90 seconds or the heartbeat frequency plus 10 seconds, whichever is
         * greater. For more information, see the server documentation for the
         * maxStalenessSeconds option. Not providing a parameter or explicitly
         * specifying -1 indicates that there should be no staleness check for
         * secondaries. Default: -1.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: advanced
         * 
         * @param maxStalenessSeconds the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder maxStalenessSeconds(
                String maxStalenessSeconds) {
            doSetProperty("maxStalenessSeconds", maxStalenessSeconds);
            return this;
        }
        /**
         * Specifies the minimum number of connections that must exist at any
         * moment in a single connection pool. Default: 0.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: advanced
         * 
         * @param minPoolSize the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder minPoolSize(
                Integer minPoolSize) {
            doSetProperty("minPoolSize", minPoolSize);
            return this;
        }
        /**
         * Specifies the minimum number of connections that must exist at any
         * moment in a single connection pool. Default: 0.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: advanced
         * 
         * @param minPoolSize the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder minPoolSize(
                String minPoolSize) {
            doSetProperty("minPoolSize", minPoolSize);
            return this;
        }
        /**
         * Configure how MongoDB clients route read operations to the members of
         * a replica set. Possible values are PRIMARY, PRIMARY_PREFERRED,
         * SECONDARY, SECONDARY_PREFERRED or NEAREST.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: PRIMARY
         * Group: advanced
         * 
         * @param readPreference the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder readPreference(
                String readPreference) {
            doSetProperty("readPreference", readPreference);
            return this;
        }
        /**
         * A representation of a tag set as a comma-separated list of
         * colon-separated key-value pairs, e.g. dc:ny,rack:1. Spaces are
         * stripped from beginning and end of all keys and values. To specify a
         * list of tag sets, using multiple readPreferenceTags, e.g.
         * readPreferenceTags=dc:ny,rack:1;readPreferenceTags=dc:ny;readPreferenceTags= Note the empty value for the last one, which means match any secondary as a last resort. Order matters when using multiple readPreferenceTags.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param readPreferenceTags the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder readPreferenceTags(
                String readPreferenceTags) {
            doSetProperty("readPreferenceTags", readPreferenceTags);
            return this;
        }
        /**
         * Specifies that the connection string provided includes multiple
         * hosts. When specified, the driver attempts to find all members of
         * that set.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param replicaSet the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder replicaSet(
                String replicaSet) {
            doSetProperty("replicaSet", replicaSet);
            return this;
        }
        /**
         * Specifies that the driver must retry supported read operations if
         * they fail due to a network error. Default: true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param retryReads the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder retryReads(
                boolean retryReads) {
            doSetProperty("retryReads", retryReads);
            return this;
        }
        /**
         * Specifies that the driver must retry supported read operations if
         * they fail due to a network error. Default: true.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param retryReads the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder retryReads(
                String retryReads) {
            doSetProperty("retryReads", retryReads);
            return this;
        }
        /**
         * Specifies that the driver must retry supported write operations if
         * they fail due to a network error. Default: true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param retryWrites the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder retryWrites(
                boolean retryWrites) {
            doSetProperty("retryWrites", retryWrites);
            return this;
        }
        /**
         * Specifies that the driver must retry supported write operations if
         * they fail due to a network error. Default: true.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param retryWrites the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder retryWrites(
                String retryWrites) {
            doSetProperty("retryWrites", retryWrites);
            return this;
        }
        /**
         * Specifies how long (in milliseconds) to block for server selection
         * before throwing an exception. Default: 30,000 milliseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: advanced
         * 
         * @param serverSelectionTimeoutMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder serverSelectionTimeoutMS(
                Integer serverSelectionTimeoutMS) {
            doSetProperty("serverSelectionTimeoutMS", serverSelectionTimeoutMS);
            return this;
        }
        /**
         * Specifies how long (in milliseconds) to block for server selection
         * before throwing an exception. Default: 30,000 milliseconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: advanced
         * 
         * @param serverSelectionTimeoutMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder serverSelectionTimeoutMS(
                String serverSelectionTimeoutMS) {
            doSetProperty("serverSelectionTimeoutMS", serverSelectionTimeoutMS);
            return this;
        }
        /**
         * Specifies the maximum amount of time, in milliseconds, the Java
         * driver will wait to send or receive a request before timing out. A
         * value of 0 instructs the driver to never time out while waiting to
         * send or receive a request. Default: 0.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: advanced
         * 
         * @param socketTimeoutMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder socketTimeoutMS(
                Integer socketTimeoutMS) {
            doSetProperty("socketTimeoutMS", socketTimeoutMS);
            return this;
        }
        /**
         * Specifies the maximum amount of time, in milliseconds, the Java
         * driver will wait to send or receive a request before timing out. A
         * value of 0 instructs the driver to never time out while waiting to
         * send or receive a request. Default: 0.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: advanced
         * 
         * @param socketTimeoutMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder socketTimeoutMS(
                String socketTimeoutMS) {
            doSetProperty("socketTimeoutMS", socketTimeoutMS);
            return this;
        }
        /**
         * The maximum number of hosts from the SRV record to connect to.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param srvMaxHosts the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder srvMaxHosts(
                Integer srvMaxHosts) {
            doSetProperty("srvMaxHosts", srvMaxHosts);
            return this;
        }
        /**
         * The maximum number of hosts from the SRV record to connect to.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param srvMaxHosts the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder srvMaxHosts(
                String srvMaxHosts) {
            doSetProperty("srvMaxHosts", srvMaxHosts);
            return this;
        }
        /**
         * Specifies the service name of the SRV resource recordsthe driver
         * retrieves to construct your seed list. You must use the DNS Seed List
         * Connection Format in your connection URI to use this option. Default:
         * mongodb.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: mongodb
         * Group: advanced
         * 
         * @param srvServiceName the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder srvServiceName(
                String srvServiceName) {
            doSetProperty("srvServiceName", srvServiceName);
            return this;
        }
        /**
         * Specifies that all communication with MongoDB instances should use
         * TLS. Supersedes the ssl option. Default: false.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param tls the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder tls(boolean tls) {
            doSetProperty("tls", tls);
            return this;
        }
        /**
         * Specifies that all communication with MongoDB instances should use
         * TLS. Supersedes the ssl option. Default: false.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param tls the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder tls(String tls) {
            doSetProperty("tls", tls);
            return this;
        }
        /**
         * Specifies that the driver should allow invalid hostnames in the
         * certificate for TLS connections. Supersedes
         * sslInvalidHostNameAllowed. Has the same effect as tlsInsecure by
         * setting tlsAllowInvalidHostnames to true. Default: false.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param tlsAllowInvalidHostnames the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder tlsAllowInvalidHostnames(
                boolean tlsAllowInvalidHostnames) {
            doSetProperty("tlsAllowInvalidHostnames", tlsAllowInvalidHostnames);
            return this;
        }
        /**
         * Specifies that the driver should allow invalid hostnames in the
         * certificate for TLS connections. Supersedes
         * sslInvalidHostNameAllowed. Has the same effect as tlsInsecure by
         * setting tlsAllowInvalidHostnames to true. Default: false.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param tlsAllowInvalidHostnames the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder tlsAllowInvalidHostnames(
                String tlsAllowInvalidHostnames) {
            doSetProperty("tlsAllowInvalidHostnames", tlsAllowInvalidHostnames);
            return this;
        }
        /**
         * Specifies the maximum amount of time, in milliseconds that a thread
         * may wait for a connection to become available. Default: 120000 (120
         * seconds).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 120000
         * Group: advanced
         * 
         * @param waitQueueTimeoutMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder waitQueueTimeoutMS(
                Integer waitQueueTimeoutMS) {
            doSetProperty("waitQueueTimeoutMS", waitQueueTimeoutMS);
            return this;
        }
        /**
         * Specifies the maximum amount of time, in milliseconds that a thread
         * may wait for a connection to become available. Default: 120000 (120
         * seconds).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 120000
         * Group: advanced
         * 
         * @param waitQueueTimeoutMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder waitQueueTimeoutMS(
                String waitQueueTimeoutMS) {
            doSetProperty("waitQueueTimeoutMS", waitQueueTimeoutMS);
            return this;
        }
        /**
         * Configure the connection bean with the level of acknowledgment
         * requested from MongoDB for write operations to a standalone mongod,
         * replicaset or cluster. Possible values are ACKNOWLEDGED, W1, W2, W3,
         * UNACKNOWLEDGED, JOURNALED or MAJORITY.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: ACKNOWLEDGED
         * Group: advanced
         * 
         * @param writeConcern the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder writeConcern(
                String writeConcern) {
            doSetProperty("writeConcern", writeConcern);
            return this;
        }
        /**
         * In write operations, it determines whether instead of returning
         * WriteResult as the body of the OUT message, we transfer the IN
         * message to the OUT and attach the WriteResult as a header.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param writeResultAsHeader the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder writeResultAsHeader(
                boolean writeResultAsHeader) {
            doSetProperty("writeResultAsHeader", writeResultAsHeader);
            return this;
        }
        /**
         * In write operations, it determines whether instead of returning
         * WriteResult as the body of the OUT message, we transfer the IN
         * message to the OUT and attach the WriteResult as a header.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param writeResultAsHeader the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder writeResultAsHeader(
                String writeResultAsHeader) {
            doSetProperty("writeResultAsHeader", writeResultAsHeader);
            return this;
        }
        /**
         * Specifies the degree of compression that Zlib should use to decrease
         * the size of requests to the connected MongoDB instance. The level can
         * range from -1 to 9, with lower values compressing faster (but
         * resulting in larger requests) and larger values compressing slower
         * (but resulting in smaller requests). Default: null.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param zlibCompressionLevel the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder zlibCompressionLevel(
                Integer zlibCompressionLevel) {
            doSetProperty("zlibCompressionLevel", zlibCompressionLevel);
            return this;
        }
        /**
         * Specifies the degree of compression that Zlib should use to decrease
         * the size of requests to the connected MongoDB instance. The level can
         * range from -1 to 9, with lower values compressing faster (but
         * resulting in larger requests) and larger values compressing slower
         * (but resulting in smaller requests). Default: null.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param zlibCompressionLevel the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointConsumerBuilder zlibCompressionLevel(
                String zlibCompressionLevel) {
            doSetProperty("zlibCompressionLevel", zlibCompressionLevel);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the MongoDB component.
     */
    public interface MongoDbEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedMongoDbEndpointProducerBuilder advanced() {
            return (AdvancedMongoDbEndpointProducerBuilder) this;
        }
        /**
         * Sets the name of the MongoDB collection to bind to this endpoint.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param collection the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder collection(String collection) {
            doSetProperty("collection", collection);
            return this;
        }
        /**
         * Sets the collection index (JSON FORMAT : { field1 : order1, field2 :
         * order2}).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param collectionIndex the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder collectionIndex(
                String collectionIndex) {
            doSetProperty("collectionIndex", collectionIndex);
            return this;
        }
        /**
         * Create collection during initialisation if it doesn't exist. Default
         * is true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param createCollection the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder createCollection(
                boolean createCollection) {
            doSetProperty("createCollection", createCollection);
            return this;
        }
        /**
         * Create collection during initialisation if it doesn't exist. Default
         * is true.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param createCollection the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder createCollection(
                String createCollection) {
            doSetProperty("createCollection", createCollection);
            return this;
        }
        /**
         * Sets the name of the MongoDB database to target.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param database the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder database(String database) {
            doSetProperty("database", database);
            return this;
        }
        /**
         * Host address of mongodb server in host:port format. It's possible
         * also use more than one address, as comma separated list of hosts:
         * host1:port1,host2:port2. If the hosts parameter is specified, the
         * provided connectionBean is ignored.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param hosts the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder hosts(String hosts) {
            doSetProperty("hosts", hosts);
            return this;
        }
        /**
         * Sets the connection bean used as a client for connecting to a
         * database.
         * 
         * The option is a:
         * &lt;code&gt;com.mongodb.client.MongoClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param mongoConnection the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder mongoConnection(
                com.mongodb.client.MongoClient mongoConnection) {
            doSetProperty("mongoConnection", mongoConnection);
            return this;
        }
        /**
         * Sets the connection bean used as a client for connecting to a
         * database.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.mongodb.client.MongoClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param mongoConnection the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder mongoConnection(
                String mongoConnection) {
            doSetProperty("mongoConnection", mongoConnection);
            return this;
        }
        /**
         * Sets the operation this endpoint will execute against MongoDB.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.mongodb.MongoDbOperation&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder operation(
                org.apache.camel.component.mongodb.MongoDbOperation operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Sets the operation this endpoint will execute against MongoDB.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.mongodb.MongoDbOperation&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Convert the output of the producer to the selected type :
         * DocumentList Document or MongoIterable. DocumentList or MongoIterable
         * applies to findAll and aggregate. Document applies to all other
         * operations.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.mongodb.MongoDbOutputType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param outputType the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder outputType(
                org.apache.camel.component.mongodb.MongoDbOutputType outputType) {
            doSetProperty("outputType", outputType);
            return this;
        }
        /**
         * Convert the output of the producer to the selected type :
         * DocumentList Document or MongoIterable. DocumentList or MongoIterable
         * applies to findAll and aggregate. Document applies to all other
         * operations.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.mongodb.MongoDbOutputType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param outputType the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder outputType(String outputType) {
            doSetProperty("outputType", outputType);
            return this;
        }
        /**
         * The database name associated with the user's credentials.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param authSource the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder authSource(String authSource) {
            doSetProperty("authSource", authSource);
            return this;
        }
        /**
         * User password for mongodb connection.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Username for mongodb connection.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointProducerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the MongoDB component.
     */
    public interface AdvancedMongoDbEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default MongoDbEndpointProducerBuilder basic() {
            return (MongoDbEndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Sets the logical name of the application. The application name may be
         * used by the client to identify the application to the server, for use
         * in server logs, slow query logs, and profile collection. Default:
         * null.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param appName the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder appName(String appName) {
            doSetProperty("appName", appName);
            return this;
        }
        /**
         * Specifies one or more compression algorithms that the driver will
         * attempt to use to compress requests sent to the connected MongoDB
         * instance. Possible values include: zlib, snappy, and zstd. Default:
         * null.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param compressors the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder compressors(
                String compressors) {
            doSetProperty("compressors", compressors);
            return this;
        }
        /**
         * Specifies the maximum amount of time, in milliseconds, the Java
         * driver waits for a connection to open before timing out. A value of 0
         * instructs the driver to never time out while waiting for a connection
         * to open. Default: 10000 (10 seconds).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: advanced
         * 
         * @param connectTimeoutMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder connectTimeoutMS(
                Integer connectTimeoutMS) {
            doSetProperty("connectTimeoutMS", connectTimeoutMS);
            return this;
        }
        /**
         * Specifies the maximum amount of time, in milliseconds, the Java
         * driver waits for a connection to open before timing out. A value of 0
         * instructs the driver to never time out while waiting for a connection
         * to open. Default: 10000 (10 seconds).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: advanced
         * 
         * @param connectTimeoutMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder connectTimeoutMS(
                String connectTimeoutMS) {
            doSetProperty("connectTimeoutMS", connectTimeoutMS);
            return this;
        }
        /**
         * MongoDB tailable cursors will block until new data arrives. If no new
         * data is inserted, after some time the cursor will be automatically
         * freed and closed by the MongoDB server. The client is expected to
         * regenerate the cursor if needed. This value specifies the time to
         * wait before attempting to fetch a new cursor, and if the attempt
         * fails, how long before the next attempt is made. Default value is
         * 1000ms.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param cursorRegenerationDelay the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder cursorRegenerationDelay(
                long cursorRegenerationDelay) {
            doSetProperty("cursorRegenerationDelay", cursorRegenerationDelay);
            return this;
        }
        /**
         * MongoDB tailable cursors will block until new data arrives. If no new
         * data is inserted, after some time the cursor will be automatically
         * freed and closed by the MongoDB server. The client is expected to
         * regenerate the cursor if needed. This value specifies the time to
         * wait before attempting to fetch a new cursor, and if the attempt
         * fails, how long before the next attempt is made. Default value is
         * 1000ms.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param cursorRegenerationDelay the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder cursorRegenerationDelay(
                String cursorRegenerationDelay) {
            doSetProperty("cursorRegenerationDelay", cursorRegenerationDelay);
            return this;
        }
        /**
         * Specifies that the driver must connect to the host directly. Default:
         * false.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param directConnection the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder directConnection(
                boolean directConnection) {
            doSetProperty("directConnection", directConnection);
            return this;
        }
        /**
         * Specifies that the driver must connect to the host directly. Default:
         * false.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param directConnection the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder directConnection(
                String directConnection) {
            doSetProperty("directConnection", directConnection);
            return this;
        }
        /**
         * Sets whether this endpoint will attempt to dynamically resolve the
         * target database and collection from the incoming Exchange properties.
         * Can be used to override at runtime the database and collection
         * specified on the otherwise static endpoint URI. It is disabled by
         * default to boost performance. Enabling it will take a minimal
         * performance hit.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param dynamicity the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder dynamicity(
                boolean dynamicity) {
            doSetProperty("dynamicity", dynamicity);
            return this;
        }
        /**
         * Sets whether this endpoint will attempt to dynamically resolve the
         * target database and collection from the incoming Exchange properties.
         * Can be used to override at runtime the database and collection
         * specified on the otherwise static endpoint URI. It is disabled by
         * default to boost performance. Enabling it will take a minimal
         * performance hit.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param dynamicity the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder dynamicity(
                String dynamicity) {
            doSetProperty("dynamicity", dynamicity);
            return this;
        }
        /**
         * heartbeatFrequencyMS controls when the driver checks the state of the
         * MongoDB deployment. Specify the interval (in milliseconds) between
         * checks, counted from the end of the previous check until the
         * beginning of the next one. Default: Single-threaded drivers: 60
         * seconds. Multi-threaded drivers: 10 seconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param heartbeatFrequencyMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder heartbeatFrequencyMS(
                Integer heartbeatFrequencyMS) {
            doSetProperty("heartbeatFrequencyMS", heartbeatFrequencyMS);
            return this;
        }
        /**
         * heartbeatFrequencyMS controls when the driver checks the state of the
         * MongoDB deployment. Specify the interval (in milliseconds) between
         * checks, counted from the end of the previous check until the
         * beginning of the next one. Default: Single-threaded drivers: 60
         * seconds. Multi-threaded drivers: 10 seconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param heartbeatFrequencyMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder heartbeatFrequencyMS(
                String heartbeatFrequencyMS) {
            doSetProperty("heartbeatFrequencyMS", heartbeatFrequencyMS);
            return this;
        }
        /**
         * If true the driver will assume that it's connecting to MongoDB
         * through a load balancer.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param loadBalanced the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder loadBalanced(
                boolean loadBalanced) {
            doSetProperty("loadBalanced", loadBalanced);
            return this;
        }
        /**
         * If true the driver will assume that it's connecting to MongoDB
         * through a load balancer.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param loadBalanced the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder loadBalanced(
                String loadBalanced) {
            doSetProperty("loadBalanced", loadBalanced);
            return this;
        }
        /**
         * The size (in milliseconds) of the latency window for selecting among
         * multiple suitable MongoDB instances. Default: 15 milliseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 15
         * Group: advanced
         * 
         * @param localThresholdMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder localThresholdMS(
                Integer localThresholdMS) {
            doSetProperty("localThresholdMS", localThresholdMS);
            return this;
        }
        /**
         * The size (in milliseconds) of the latency window for selecting among
         * multiple suitable MongoDB instances. Default: 15 milliseconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 15
         * Group: advanced
         * 
         * @param localThresholdMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder localThresholdMS(
                String localThresholdMS) {
            doSetProperty("localThresholdMS", localThresholdMS);
            return this;
        }
        /**
         * Specifies the maximum number of connections a pool may be
         * establishing concurrently. Default: 2.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 2
         * Group: advanced
         * 
         * @param maxConnecting the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder maxConnecting(
                Integer maxConnecting) {
            doSetProperty("maxConnecting", maxConnecting);
            return this;
        }
        /**
         * Specifies the maximum number of connections a pool may be
         * establishing concurrently. Default: 2.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 2
         * Group: advanced
         * 
         * @param maxConnecting the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder maxConnecting(
                String maxConnecting) {
            doSetProperty("maxConnecting", maxConnecting);
            return this;
        }
        /**
         * Specifies the maximum amount of time, in milliseconds, the Java
         * driver will allow a pooled connection to idle before closing the
         * connection. A value of 0 indicates that there is no upper bound on
         * how long the driver can allow a pooled collection to be idle.
         * Default: 0.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: advanced
         * 
         * @param maxIdleTimeMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder maxIdleTimeMS(
                Integer maxIdleTimeMS) {
            doSetProperty("maxIdleTimeMS", maxIdleTimeMS);
            return this;
        }
        /**
         * Specifies the maximum amount of time, in milliseconds, the Java
         * driver will allow a pooled connection to idle before closing the
         * connection. A value of 0 indicates that there is no upper bound on
         * how long the driver can allow a pooled collection to be idle.
         * Default: 0.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: advanced
         * 
         * @param maxIdleTimeMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder maxIdleTimeMS(
                String maxIdleTimeMS) {
            doSetProperty("maxIdleTimeMS", maxIdleTimeMS);
            return this;
        }
        /**
         * Specifies the maximum amount of time, in milliseconds, the Java
         * driver will continue to use a pooled connection before closing the
         * connection. A value of 0 indicates that there is no upper bound on
         * how long the driver can keep a pooled connection open. Default: 0.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: advanced
         * 
         * @param maxLifeTimeMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder maxLifeTimeMS(
                Integer maxLifeTimeMS) {
            doSetProperty("maxLifeTimeMS", maxLifeTimeMS);
            return this;
        }
        /**
         * Specifies the maximum amount of time, in milliseconds, the Java
         * driver will continue to use a pooled connection before closing the
         * connection. A value of 0 indicates that there is no upper bound on
         * how long the driver can keep a pooled connection open. Default: 0.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: advanced
         * 
         * @param maxLifeTimeMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder maxLifeTimeMS(
                String maxLifeTimeMS) {
            doSetProperty("maxLifeTimeMS", maxLifeTimeMS);
            return this;
        }
        /**
         * The maximum number of connections in the connection pool. The default
         * value is 100.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: advanced
         * 
         * @param maxPoolSize the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder maxPoolSize(
                Integer maxPoolSize) {
            doSetProperty("maxPoolSize", maxPoolSize);
            return this;
        }
        /**
         * The maximum number of connections in the connection pool. The default
         * value is 100.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: advanced
         * 
         * @param maxPoolSize the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder maxPoolSize(
                String maxPoolSize) {
            doSetProperty("maxPoolSize", maxPoolSize);
            return this;
        }
        /**
         * Specifies, in seconds, how stale a secondary can be before the driver
         * stops communicating with that secondary. The minimum value is either
         * 90 seconds or the heartbeat frequency plus 10 seconds, whichever is
         * greater. For more information, see the server documentation for the
         * maxStalenessSeconds option. Not providing a parameter or explicitly
         * specifying -1 indicates that there should be no staleness check for
         * secondaries. Default: -1.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: advanced
         * 
         * @param maxStalenessSeconds the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder maxStalenessSeconds(
                Integer maxStalenessSeconds) {
            doSetProperty("maxStalenessSeconds", maxStalenessSeconds);
            return this;
        }
        /**
         * Specifies, in seconds, how stale a secondary can be before the driver
         * stops communicating with that secondary. The minimum value is either
         * 90 seconds or the heartbeat frequency plus 10 seconds, whichever is
         * greater. For more information, see the server documentation for the
         * maxStalenessSeconds option. Not providing a parameter or explicitly
         * specifying -1 indicates that there should be no staleness check for
         * secondaries. Default: -1.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: advanced
         * 
         * @param maxStalenessSeconds the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder maxStalenessSeconds(
                String maxStalenessSeconds) {
            doSetProperty("maxStalenessSeconds", maxStalenessSeconds);
            return this;
        }
        /**
         * Specifies the minimum number of connections that must exist at any
         * moment in a single connection pool. Default: 0.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: advanced
         * 
         * @param minPoolSize the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder minPoolSize(
                Integer minPoolSize) {
            doSetProperty("minPoolSize", minPoolSize);
            return this;
        }
        /**
         * Specifies the minimum number of connections that must exist at any
         * moment in a single connection pool. Default: 0.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: advanced
         * 
         * @param minPoolSize the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder minPoolSize(
                String minPoolSize) {
            doSetProperty("minPoolSize", minPoolSize);
            return this;
        }
        /**
         * Configure how MongoDB clients route read operations to the members of
         * a replica set. Possible values are PRIMARY, PRIMARY_PREFERRED,
         * SECONDARY, SECONDARY_PREFERRED or NEAREST.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: PRIMARY
         * Group: advanced
         * 
         * @param readPreference the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder readPreference(
                String readPreference) {
            doSetProperty("readPreference", readPreference);
            return this;
        }
        /**
         * A representation of a tag set as a comma-separated list of
         * colon-separated key-value pairs, e.g. dc:ny,rack:1. Spaces are
         * stripped from beginning and end of all keys and values. To specify a
         * list of tag sets, using multiple readPreferenceTags, e.g.
         * readPreferenceTags=dc:ny,rack:1;readPreferenceTags=dc:ny;readPreferenceTags= Note the empty value for the last one, which means match any secondary as a last resort. Order matters when using multiple readPreferenceTags.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param readPreferenceTags the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder readPreferenceTags(
                String readPreferenceTags) {
            doSetProperty("readPreferenceTags", readPreferenceTags);
            return this;
        }
        /**
         * Specifies that the connection string provided includes multiple
         * hosts. When specified, the driver attempts to find all members of
         * that set.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param replicaSet the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder replicaSet(
                String replicaSet) {
            doSetProperty("replicaSet", replicaSet);
            return this;
        }
        /**
         * Specifies that the driver must retry supported read operations if
         * they fail due to a network error. Default: true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param retryReads the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder retryReads(
                boolean retryReads) {
            doSetProperty("retryReads", retryReads);
            return this;
        }
        /**
         * Specifies that the driver must retry supported read operations if
         * they fail due to a network error. Default: true.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param retryReads the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder retryReads(
                String retryReads) {
            doSetProperty("retryReads", retryReads);
            return this;
        }
        /**
         * Specifies that the driver must retry supported write operations if
         * they fail due to a network error. Default: true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param retryWrites the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder retryWrites(
                boolean retryWrites) {
            doSetProperty("retryWrites", retryWrites);
            return this;
        }
        /**
         * Specifies that the driver must retry supported write operations if
         * they fail due to a network error. Default: true.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param retryWrites the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder retryWrites(
                String retryWrites) {
            doSetProperty("retryWrites", retryWrites);
            return this;
        }
        /**
         * Specifies how long (in milliseconds) to block for server selection
         * before throwing an exception. Default: 30,000 milliseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: advanced
         * 
         * @param serverSelectionTimeoutMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder serverSelectionTimeoutMS(
                Integer serverSelectionTimeoutMS) {
            doSetProperty("serverSelectionTimeoutMS", serverSelectionTimeoutMS);
            return this;
        }
        /**
         * Specifies how long (in milliseconds) to block for server selection
         * before throwing an exception. Default: 30,000 milliseconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: advanced
         * 
         * @param serverSelectionTimeoutMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder serverSelectionTimeoutMS(
                String serverSelectionTimeoutMS) {
            doSetProperty("serverSelectionTimeoutMS", serverSelectionTimeoutMS);
            return this;
        }
        /**
         * Specifies the maximum amount of time, in milliseconds, the Java
         * driver will wait to send or receive a request before timing out. A
         * value of 0 instructs the driver to never time out while waiting to
         * send or receive a request. Default: 0.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: advanced
         * 
         * @param socketTimeoutMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder socketTimeoutMS(
                Integer socketTimeoutMS) {
            doSetProperty("socketTimeoutMS", socketTimeoutMS);
            return this;
        }
        /**
         * Specifies the maximum amount of time, in milliseconds, the Java
         * driver will wait to send or receive a request before timing out. A
         * value of 0 instructs the driver to never time out while waiting to
         * send or receive a request. Default: 0.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: advanced
         * 
         * @param socketTimeoutMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder socketTimeoutMS(
                String socketTimeoutMS) {
            doSetProperty("socketTimeoutMS", socketTimeoutMS);
            return this;
        }
        /**
         * The maximum number of hosts from the SRV record to connect to.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param srvMaxHosts the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder srvMaxHosts(
                Integer srvMaxHosts) {
            doSetProperty("srvMaxHosts", srvMaxHosts);
            return this;
        }
        /**
         * The maximum number of hosts from the SRV record to connect to.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param srvMaxHosts the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder srvMaxHosts(
                String srvMaxHosts) {
            doSetProperty("srvMaxHosts", srvMaxHosts);
            return this;
        }
        /**
         * Specifies the service name of the SRV resource recordsthe driver
         * retrieves to construct your seed list. You must use the DNS Seed List
         * Connection Format in your connection URI to use this option. Default:
         * mongodb.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: mongodb
         * Group: advanced
         * 
         * @param srvServiceName the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder srvServiceName(
                String srvServiceName) {
            doSetProperty("srvServiceName", srvServiceName);
            return this;
        }
        /**
         * Specifies that all communication with MongoDB instances should use
         * TLS. Supersedes the ssl option. Default: false.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param tls the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder tls(boolean tls) {
            doSetProperty("tls", tls);
            return this;
        }
        /**
         * Specifies that all communication with MongoDB instances should use
         * TLS. Supersedes the ssl option. Default: false.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param tls the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder tls(String tls) {
            doSetProperty("tls", tls);
            return this;
        }
        /**
         * Specifies that the driver should allow invalid hostnames in the
         * certificate for TLS connections. Supersedes
         * sslInvalidHostNameAllowed. Has the same effect as tlsInsecure by
         * setting tlsAllowInvalidHostnames to true. Default: false.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param tlsAllowInvalidHostnames the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder tlsAllowInvalidHostnames(
                boolean tlsAllowInvalidHostnames) {
            doSetProperty("tlsAllowInvalidHostnames", tlsAllowInvalidHostnames);
            return this;
        }
        /**
         * Specifies that the driver should allow invalid hostnames in the
         * certificate for TLS connections. Supersedes
         * sslInvalidHostNameAllowed. Has the same effect as tlsInsecure by
         * setting tlsAllowInvalidHostnames to true. Default: false.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param tlsAllowInvalidHostnames the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder tlsAllowInvalidHostnames(
                String tlsAllowInvalidHostnames) {
            doSetProperty("tlsAllowInvalidHostnames", tlsAllowInvalidHostnames);
            return this;
        }
        /**
         * Specifies the maximum amount of time, in milliseconds that a thread
         * may wait for a connection to become available. Default: 120000 (120
         * seconds).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 120000
         * Group: advanced
         * 
         * @param waitQueueTimeoutMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder waitQueueTimeoutMS(
                Integer waitQueueTimeoutMS) {
            doSetProperty("waitQueueTimeoutMS", waitQueueTimeoutMS);
            return this;
        }
        /**
         * Specifies the maximum amount of time, in milliseconds that a thread
         * may wait for a connection to become available. Default: 120000 (120
         * seconds).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 120000
         * Group: advanced
         * 
         * @param waitQueueTimeoutMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder waitQueueTimeoutMS(
                String waitQueueTimeoutMS) {
            doSetProperty("waitQueueTimeoutMS", waitQueueTimeoutMS);
            return this;
        }
        /**
         * Configure the connection bean with the level of acknowledgment
         * requested from MongoDB for write operations to a standalone mongod,
         * replicaset or cluster. Possible values are ACKNOWLEDGED, W1, W2, W3,
         * UNACKNOWLEDGED, JOURNALED or MAJORITY.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: ACKNOWLEDGED
         * Group: advanced
         * 
         * @param writeConcern the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder writeConcern(
                String writeConcern) {
            doSetProperty("writeConcern", writeConcern);
            return this;
        }
        /**
         * In write operations, it determines whether instead of returning
         * WriteResult as the body of the OUT message, we transfer the IN
         * message to the OUT and attach the WriteResult as a header.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param writeResultAsHeader the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder writeResultAsHeader(
                boolean writeResultAsHeader) {
            doSetProperty("writeResultAsHeader", writeResultAsHeader);
            return this;
        }
        /**
         * In write operations, it determines whether instead of returning
         * WriteResult as the body of the OUT message, we transfer the IN
         * message to the OUT and attach the WriteResult as a header.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param writeResultAsHeader the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder writeResultAsHeader(
                String writeResultAsHeader) {
            doSetProperty("writeResultAsHeader", writeResultAsHeader);
            return this;
        }
        /**
         * Specifies the degree of compression that Zlib should use to decrease
         * the size of requests to the connected MongoDB instance. The level can
         * range from -1 to 9, with lower values compressing faster (but
         * resulting in larger requests) and larger values compressing slower
         * (but resulting in smaller requests). Default: null.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param zlibCompressionLevel the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder zlibCompressionLevel(
                Integer zlibCompressionLevel) {
            doSetProperty("zlibCompressionLevel", zlibCompressionLevel);
            return this;
        }
        /**
         * Specifies the degree of compression that Zlib should use to decrease
         * the size of requests to the connected MongoDB instance. The level can
         * range from -1 to 9, with lower values compressing faster (but
         * resulting in larger requests) and larger values compressing slower
         * (but resulting in smaller requests). Default: null.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param zlibCompressionLevel the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointProducerBuilder zlibCompressionLevel(
                String zlibCompressionLevel) {
            doSetProperty("zlibCompressionLevel", zlibCompressionLevel);
            return this;
        }
    }

    /**
     * Builder for endpoint for the MongoDB component.
     */
    public interface MongoDbEndpointBuilder
            extends
                MongoDbEndpointConsumerBuilder,
                MongoDbEndpointProducerBuilder {
        default AdvancedMongoDbEndpointBuilder advanced() {
            return (AdvancedMongoDbEndpointBuilder) this;
        }
        /**
         * Sets the name of the MongoDB collection to bind to this endpoint.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param collection the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder collection(String collection) {
            doSetProperty("collection", collection);
            return this;
        }
        /**
         * Sets the collection index (JSON FORMAT : { field1 : order1, field2 :
         * order2}).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param collectionIndex the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder collectionIndex(String collectionIndex) {
            doSetProperty("collectionIndex", collectionIndex);
            return this;
        }
        /**
         * Create collection during initialisation if it doesn't exist. Default
         * is true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param createCollection the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder createCollection(boolean createCollection) {
            doSetProperty("createCollection", createCollection);
            return this;
        }
        /**
         * Create collection during initialisation if it doesn't exist. Default
         * is true.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param createCollection the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder createCollection(String createCollection) {
            doSetProperty("createCollection", createCollection);
            return this;
        }
        /**
         * Sets the name of the MongoDB database to target.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param database the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder database(String database) {
            doSetProperty("database", database);
            return this;
        }
        /**
         * Host address of mongodb server in host:port format. It's possible
         * also use more than one address, as comma separated list of hosts:
         * host1:port1,host2:port2. If the hosts parameter is specified, the
         * provided connectionBean is ignored.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param hosts the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder hosts(String hosts) {
            doSetProperty("hosts", hosts);
            return this;
        }
        /**
         * Sets the connection bean used as a client for connecting to a
         * database.
         * 
         * The option is a:
         * &lt;code&gt;com.mongodb.client.MongoClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param mongoConnection the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder mongoConnection(
                com.mongodb.client.MongoClient mongoConnection) {
            doSetProperty("mongoConnection", mongoConnection);
            return this;
        }
        /**
         * Sets the connection bean used as a client for connecting to a
         * database.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.mongodb.client.MongoClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param mongoConnection the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder mongoConnection(String mongoConnection) {
            doSetProperty("mongoConnection", mongoConnection);
            return this;
        }
        /**
         * Sets the operation this endpoint will execute against MongoDB.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.mongodb.MongoDbOperation&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder operation(
                org.apache.camel.component.mongodb.MongoDbOperation operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Sets the operation this endpoint will execute against MongoDB.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.mongodb.MongoDbOperation&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Convert the output of the producer to the selected type :
         * DocumentList Document or MongoIterable. DocumentList or MongoIterable
         * applies to findAll and aggregate. Document applies to all other
         * operations.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.mongodb.MongoDbOutputType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param outputType the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder outputType(
                org.apache.camel.component.mongodb.MongoDbOutputType outputType) {
            doSetProperty("outputType", outputType);
            return this;
        }
        /**
         * Convert the output of the producer to the selected type :
         * DocumentList Document or MongoIterable. DocumentList or MongoIterable
         * applies to findAll and aggregate. Document applies to all other
         * operations.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.mongodb.MongoDbOutputType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param outputType the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder outputType(String outputType) {
            doSetProperty("outputType", outputType);
            return this;
        }
        /**
         * The database name associated with the user's credentials.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param authSource the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder authSource(String authSource) {
            doSetProperty("authSource", authSource);
            return this;
        }
        /**
         * User password for mongodb connection.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Username for mongodb connection.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the MongoDB component.
     */
    public interface AdvancedMongoDbEndpointBuilder
            extends
                AdvancedMongoDbEndpointConsumerBuilder,
                AdvancedMongoDbEndpointProducerBuilder {
        default MongoDbEndpointBuilder basic() {
            return (MongoDbEndpointBuilder) this;
        }
        /**
         * Sets the logical name of the application. The application name may be
         * used by the client to identify the application to the server, for use
         * in server logs, slow query logs, and profile collection. Default:
         * null.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param appName the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder appName(String appName) {
            doSetProperty("appName", appName);
            return this;
        }
        /**
         * Specifies one or more compression algorithms that the driver will
         * attempt to use to compress requests sent to the connected MongoDB
         * instance. Possible values include: zlib, snappy, and zstd. Default:
         * null.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param compressors the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder compressors(String compressors) {
            doSetProperty("compressors", compressors);
            return this;
        }
        /**
         * Specifies the maximum amount of time, in milliseconds, the Java
         * driver waits for a connection to open before timing out. A value of 0
         * instructs the driver to never time out while waiting for a connection
         * to open. Default: 10000 (10 seconds).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: advanced
         * 
         * @param connectTimeoutMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder connectTimeoutMS(
                Integer connectTimeoutMS) {
            doSetProperty("connectTimeoutMS", connectTimeoutMS);
            return this;
        }
        /**
         * Specifies the maximum amount of time, in milliseconds, the Java
         * driver waits for a connection to open before timing out. A value of 0
         * instructs the driver to never time out while waiting for a connection
         * to open. Default: 10000 (10 seconds).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 10000
         * Group: advanced
         * 
         * @param connectTimeoutMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder connectTimeoutMS(
                String connectTimeoutMS) {
            doSetProperty("connectTimeoutMS", connectTimeoutMS);
            return this;
        }
        /**
         * MongoDB tailable cursors will block until new data arrives. If no new
         * data is inserted, after some time the cursor will be automatically
         * freed and closed by the MongoDB server. The client is expected to
         * regenerate the cursor if needed. This value specifies the time to
         * wait before attempting to fetch a new cursor, and if the attempt
         * fails, how long before the next attempt is made. Default value is
         * 1000ms.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param cursorRegenerationDelay the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder cursorRegenerationDelay(
                long cursorRegenerationDelay) {
            doSetProperty("cursorRegenerationDelay", cursorRegenerationDelay);
            return this;
        }
        /**
         * MongoDB tailable cursors will block until new data arrives. If no new
         * data is inserted, after some time the cursor will be automatically
         * freed and closed by the MongoDB server. The client is expected to
         * regenerate the cursor if needed. This value specifies the time to
         * wait before attempting to fetch a new cursor, and if the attempt
         * fails, how long before the next attempt is made. Default value is
         * 1000ms.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: advanced
         * 
         * @param cursorRegenerationDelay the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder cursorRegenerationDelay(
                String cursorRegenerationDelay) {
            doSetProperty("cursorRegenerationDelay", cursorRegenerationDelay);
            return this;
        }
        /**
         * Specifies that the driver must connect to the host directly. Default:
         * false.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param directConnection the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder directConnection(
                boolean directConnection) {
            doSetProperty("directConnection", directConnection);
            return this;
        }
        /**
         * Specifies that the driver must connect to the host directly. Default:
         * false.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param directConnection the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder directConnection(
                String directConnection) {
            doSetProperty("directConnection", directConnection);
            return this;
        }
        /**
         * Sets whether this endpoint will attempt to dynamically resolve the
         * target database and collection from the incoming Exchange properties.
         * Can be used to override at runtime the database and collection
         * specified on the otherwise static endpoint URI. It is disabled by
         * default to boost performance. Enabling it will take a minimal
         * performance hit.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param dynamicity the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder dynamicity(boolean dynamicity) {
            doSetProperty("dynamicity", dynamicity);
            return this;
        }
        /**
         * Sets whether this endpoint will attempt to dynamically resolve the
         * target database and collection from the incoming Exchange properties.
         * Can be used to override at runtime the database and collection
         * specified on the otherwise static endpoint URI. It is disabled by
         * default to boost performance. Enabling it will take a minimal
         * performance hit.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param dynamicity the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder dynamicity(String dynamicity) {
            doSetProperty("dynamicity", dynamicity);
            return this;
        }
        /**
         * heartbeatFrequencyMS controls when the driver checks the state of the
         * MongoDB deployment. Specify the interval (in milliseconds) between
         * checks, counted from the end of the previous check until the
         * beginning of the next one. Default: Single-threaded drivers: 60
         * seconds. Multi-threaded drivers: 10 seconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param heartbeatFrequencyMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder heartbeatFrequencyMS(
                Integer heartbeatFrequencyMS) {
            doSetProperty("heartbeatFrequencyMS", heartbeatFrequencyMS);
            return this;
        }
        /**
         * heartbeatFrequencyMS controls when the driver checks the state of the
         * MongoDB deployment. Specify the interval (in milliseconds) between
         * checks, counted from the end of the previous check until the
         * beginning of the next one. Default: Single-threaded drivers: 60
         * seconds. Multi-threaded drivers: 10 seconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param heartbeatFrequencyMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder heartbeatFrequencyMS(
                String heartbeatFrequencyMS) {
            doSetProperty("heartbeatFrequencyMS", heartbeatFrequencyMS);
            return this;
        }
        /**
         * If true the driver will assume that it's connecting to MongoDB
         * through a load balancer.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param loadBalanced the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder loadBalanced(boolean loadBalanced) {
            doSetProperty("loadBalanced", loadBalanced);
            return this;
        }
        /**
         * If true the driver will assume that it's connecting to MongoDB
         * through a load balancer.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param loadBalanced the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder loadBalanced(String loadBalanced) {
            doSetProperty("loadBalanced", loadBalanced);
            return this;
        }
        /**
         * The size (in milliseconds) of the latency window for selecting among
         * multiple suitable MongoDB instances. Default: 15 milliseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 15
         * Group: advanced
         * 
         * @param localThresholdMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder localThresholdMS(
                Integer localThresholdMS) {
            doSetProperty("localThresholdMS", localThresholdMS);
            return this;
        }
        /**
         * The size (in milliseconds) of the latency window for selecting among
         * multiple suitable MongoDB instances. Default: 15 milliseconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 15
         * Group: advanced
         * 
         * @param localThresholdMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder localThresholdMS(
                String localThresholdMS) {
            doSetProperty("localThresholdMS", localThresholdMS);
            return this;
        }
        /**
         * Specifies the maximum number of connections a pool may be
         * establishing concurrently. Default: 2.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 2
         * Group: advanced
         * 
         * @param maxConnecting the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder maxConnecting(
                Integer maxConnecting) {
            doSetProperty("maxConnecting", maxConnecting);
            return this;
        }
        /**
         * Specifies the maximum number of connections a pool may be
         * establishing concurrently. Default: 2.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 2
         * Group: advanced
         * 
         * @param maxConnecting the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder maxConnecting(
                String maxConnecting) {
            doSetProperty("maxConnecting", maxConnecting);
            return this;
        }
        /**
         * Specifies the maximum amount of time, in milliseconds, the Java
         * driver will allow a pooled connection to idle before closing the
         * connection. A value of 0 indicates that there is no upper bound on
         * how long the driver can allow a pooled collection to be idle.
         * Default: 0.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: advanced
         * 
         * @param maxIdleTimeMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder maxIdleTimeMS(
                Integer maxIdleTimeMS) {
            doSetProperty("maxIdleTimeMS", maxIdleTimeMS);
            return this;
        }
        /**
         * Specifies the maximum amount of time, in milliseconds, the Java
         * driver will allow a pooled connection to idle before closing the
         * connection. A value of 0 indicates that there is no upper bound on
         * how long the driver can allow a pooled collection to be idle.
         * Default: 0.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: advanced
         * 
         * @param maxIdleTimeMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder maxIdleTimeMS(
                String maxIdleTimeMS) {
            doSetProperty("maxIdleTimeMS", maxIdleTimeMS);
            return this;
        }
        /**
         * Specifies the maximum amount of time, in milliseconds, the Java
         * driver will continue to use a pooled connection before closing the
         * connection. A value of 0 indicates that there is no upper bound on
         * how long the driver can keep a pooled connection open. Default: 0.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: advanced
         * 
         * @param maxLifeTimeMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder maxLifeTimeMS(
                Integer maxLifeTimeMS) {
            doSetProperty("maxLifeTimeMS", maxLifeTimeMS);
            return this;
        }
        /**
         * Specifies the maximum amount of time, in milliseconds, the Java
         * driver will continue to use a pooled connection before closing the
         * connection. A value of 0 indicates that there is no upper bound on
         * how long the driver can keep a pooled connection open. Default: 0.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: advanced
         * 
         * @param maxLifeTimeMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder maxLifeTimeMS(
                String maxLifeTimeMS) {
            doSetProperty("maxLifeTimeMS", maxLifeTimeMS);
            return this;
        }
        /**
         * The maximum number of connections in the connection pool. The default
         * value is 100.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: advanced
         * 
         * @param maxPoolSize the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder maxPoolSize(Integer maxPoolSize) {
            doSetProperty("maxPoolSize", maxPoolSize);
            return this;
        }
        /**
         * The maximum number of connections in the connection pool. The default
         * value is 100.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: advanced
         * 
         * @param maxPoolSize the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder maxPoolSize(String maxPoolSize) {
            doSetProperty("maxPoolSize", maxPoolSize);
            return this;
        }
        /**
         * Specifies, in seconds, how stale a secondary can be before the driver
         * stops communicating with that secondary. The minimum value is either
         * 90 seconds or the heartbeat frequency plus 10 seconds, whichever is
         * greater. For more information, see the server documentation for the
         * maxStalenessSeconds option. Not providing a parameter or explicitly
         * specifying -1 indicates that there should be no staleness check for
         * secondaries. Default: -1.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: advanced
         * 
         * @param maxStalenessSeconds the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder maxStalenessSeconds(
                Integer maxStalenessSeconds) {
            doSetProperty("maxStalenessSeconds", maxStalenessSeconds);
            return this;
        }
        /**
         * Specifies, in seconds, how stale a secondary can be before the driver
         * stops communicating with that secondary. The minimum value is either
         * 90 seconds or the heartbeat frequency plus 10 seconds, whichever is
         * greater. For more information, see the server documentation for the
         * maxStalenessSeconds option. Not providing a parameter or explicitly
         * specifying -1 indicates that there should be no staleness check for
         * secondaries. Default: -1.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: advanced
         * 
         * @param maxStalenessSeconds the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder maxStalenessSeconds(
                String maxStalenessSeconds) {
            doSetProperty("maxStalenessSeconds", maxStalenessSeconds);
            return this;
        }
        /**
         * Specifies the minimum number of connections that must exist at any
         * moment in a single connection pool. Default: 0.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: advanced
         * 
         * @param minPoolSize the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder minPoolSize(Integer minPoolSize) {
            doSetProperty("minPoolSize", minPoolSize);
            return this;
        }
        /**
         * Specifies the minimum number of connections that must exist at any
         * moment in a single connection pool. Default: 0.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: advanced
         * 
         * @param minPoolSize the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder minPoolSize(String minPoolSize) {
            doSetProperty("minPoolSize", minPoolSize);
            return this;
        }
        /**
         * Configure how MongoDB clients route read operations to the members of
         * a replica set. Possible values are PRIMARY, PRIMARY_PREFERRED,
         * SECONDARY, SECONDARY_PREFERRED or NEAREST.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: PRIMARY
         * Group: advanced
         * 
         * @param readPreference the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder readPreference(
                String readPreference) {
            doSetProperty("readPreference", readPreference);
            return this;
        }
        /**
         * A representation of a tag set as a comma-separated list of
         * colon-separated key-value pairs, e.g. dc:ny,rack:1. Spaces are
         * stripped from beginning and end of all keys and values. To specify a
         * list of tag sets, using multiple readPreferenceTags, e.g.
         * readPreferenceTags=dc:ny,rack:1;readPreferenceTags=dc:ny;readPreferenceTags= Note the empty value for the last one, which means match any secondary as a last resort. Order matters when using multiple readPreferenceTags.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param readPreferenceTags the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder readPreferenceTags(
                String readPreferenceTags) {
            doSetProperty("readPreferenceTags", readPreferenceTags);
            return this;
        }
        /**
         * Specifies that the connection string provided includes multiple
         * hosts. When specified, the driver attempts to find all members of
         * that set.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param replicaSet the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder replicaSet(String replicaSet) {
            doSetProperty("replicaSet", replicaSet);
            return this;
        }
        /**
         * Specifies that the driver must retry supported read operations if
         * they fail due to a network error. Default: true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param retryReads the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder retryReads(boolean retryReads) {
            doSetProperty("retryReads", retryReads);
            return this;
        }
        /**
         * Specifies that the driver must retry supported read operations if
         * they fail due to a network error. Default: true.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param retryReads the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder retryReads(String retryReads) {
            doSetProperty("retryReads", retryReads);
            return this;
        }
        /**
         * Specifies that the driver must retry supported write operations if
         * they fail due to a network error. Default: true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param retryWrites the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder retryWrites(boolean retryWrites) {
            doSetProperty("retryWrites", retryWrites);
            return this;
        }
        /**
         * Specifies that the driver must retry supported write operations if
         * they fail due to a network error. Default: true.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param retryWrites the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder retryWrites(String retryWrites) {
            doSetProperty("retryWrites", retryWrites);
            return this;
        }
        /**
         * Specifies how long (in milliseconds) to block for server selection
         * before throwing an exception. Default: 30,000 milliseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: advanced
         * 
         * @param serverSelectionTimeoutMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder serverSelectionTimeoutMS(
                Integer serverSelectionTimeoutMS) {
            doSetProperty("serverSelectionTimeoutMS", serverSelectionTimeoutMS);
            return this;
        }
        /**
         * Specifies how long (in milliseconds) to block for server selection
         * before throwing an exception. Default: 30,000 milliseconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: advanced
         * 
         * @param serverSelectionTimeoutMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder serverSelectionTimeoutMS(
                String serverSelectionTimeoutMS) {
            doSetProperty("serverSelectionTimeoutMS", serverSelectionTimeoutMS);
            return this;
        }
        /**
         * Specifies the maximum amount of time, in milliseconds, the Java
         * driver will wait to send or receive a request before timing out. A
         * value of 0 instructs the driver to never time out while waiting to
         * send or receive a request. Default: 0.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: advanced
         * 
         * @param socketTimeoutMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder socketTimeoutMS(
                Integer socketTimeoutMS) {
            doSetProperty("socketTimeoutMS", socketTimeoutMS);
            return this;
        }
        /**
         * Specifies the maximum amount of time, in milliseconds, the Java
         * driver will wait to send or receive a request before timing out. A
         * value of 0 instructs the driver to never time out while waiting to
         * send or receive a request. Default: 0.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: advanced
         * 
         * @param socketTimeoutMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder socketTimeoutMS(
                String socketTimeoutMS) {
            doSetProperty("socketTimeoutMS", socketTimeoutMS);
            return this;
        }
        /**
         * The maximum number of hosts from the SRV record to connect to.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param srvMaxHosts the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder srvMaxHosts(Integer srvMaxHosts) {
            doSetProperty("srvMaxHosts", srvMaxHosts);
            return this;
        }
        /**
         * The maximum number of hosts from the SRV record to connect to.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param srvMaxHosts the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder srvMaxHosts(String srvMaxHosts) {
            doSetProperty("srvMaxHosts", srvMaxHosts);
            return this;
        }
        /**
         * Specifies the service name of the SRV resource recordsthe driver
         * retrieves to construct your seed list. You must use the DNS Seed List
         * Connection Format in your connection URI to use this option. Default:
         * mongodb.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: mongodb
         * Group: advanced
         * 
         * @param srvServiceName the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder srvServiceName(
                String srvServiceName) {
            doSetProperty("srvServiceName", srvServiceName);
            return this;
        }
        /**
         * Specifies that all communication with MongoDB instances should use
         * TLS. Supersedes the ssl option. Default: false.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param tls the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder tls(boolean tls) {
            doSetProperty("tls", tls);
            return this;
        }
        /**
         * Specifies that all communication with MongoDB instances should use
         * TLS. Supersedes the ssl option. Default: false.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param tls the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder tls(String tls) {
            doSetProperty("tls", tls);
            return this;
        }
        /**
         * Specifies that the driver should allow invalid hostnames in the
         * certificate for TLS connections. Supersedes
         * sslInvalidHostNameAllowed. Has the same effect as tlsInsecure by
         * setting tlsAllowInvalidHostnames to true. Default: false.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param tlsAllowInvalidHostnames the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder tlsAllowInvalidHostnames(
                boolean tlsAllowInvalidHostnames) {
            doSetProperty("tlsAllowInvalidHostnames", tlsAllowInvalidHostnames);
            return this;
        }
        /**
         * Specifies that the driver should allow invalid hostnames in the
         * certificate for TLS connections. Supersedes
         * sslInvalidHostNameAllowed. Has the same effect as tlsInsecure by
         * setting tlsAllowInvalidHostnames to true. Default: false.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param tlsAllowInvalidHostnames the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder tlsAllowInvalidHostnames(
                String tlsAllowInvalidHostnames) {
            doSetProperty("tlsAllowInvalidHostnames", tlsAllowInvalidHostnames);
            return this;
        }
        /**
         * Specifies the maximum amount of time, in milliseconds that a thread
         * may wait for a connection to become available. Default: 120000 (120
         * seconds).
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 120000
         * Group: advanced
         * 
         * @param waitQueueTimeoutMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder waitQueueTimeoutMS(
                Integer waitQueueTimeoutMS) {
            doSetProperty("waitQueueTimeoutMS", waitQueueTimeoutMS);
            return this;
        }
        /**
         * Specifies the maximum amount of time, in milliseconds that a thread
         * may wait for a connection to become available. Default: 120000 (120
         * seconds).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 120000
         * Group: advanced
         * 
         * @param waitQueueTimeoutMS the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder waitQueueTimeoutMS(
                String waitQueueTimeoutMS) {
            doSetProperty("waitQueueTimeoutMS", waitQueueTimeoutMS);
            return this;
        }
        /**
         * Configure the connection bean with the level of acknowledgment
         * requested from MongoDB for write operations to a standalone mongod,
         * replicaset or cluster. Possible values are ACKNOWLEDGED, W1, W2, W3,
         * UNACKNOWLEDGED, JOURNALED or MAJORITY.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: ACKNOWLEDGED
         * Group: advanced
         * 
         * @param writeConcern the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder writeConcern(String writeConcern) {
            doSetProperty("writeConcern", writeConcern);
            return this;
        }
        /**
         * In write operations, it determines whether instead of returning
         * WriteResult as the body of the OUT message, we transfer the IN
         * message to the OUT and attach the WriteResult as a header.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param writeResultAsHeader the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder writeResultAsHeader(
                boolean writeResultAsHeader) {
            doSetProperty("writeResultAsHeader", writeResultAsHeader);
            return this;
        }
        /**
         * In write operations, it determines whether instead of returning
         * WriteResult as the body of the OUT message, we transfer the IN
         * message to the OUT and attach the WriteResult as a header.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param writeResultAsHeader the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder writeResultAsHeader(
                String writeResultAsHeader) {
            doSetProperty("writeResultAsHeader", writeResultAsHeader);
            return this;
        }
        /**
         * Specifies the degree of compression that Zlib should use to decrease
         * the size of requests to the connected MongoDB instance. The level can
         * range from -1 to 9, with lower values compressing faster (but
         * resulting in larger requests) and larger values compressing slower
         * (but resulting in smaller requests). Default: null.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param zlibCompressionLevel the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder zlibCompressionLevel(
                Integer zlibCompressionLevel) {
            doSetProperty("zlibCompressionLevel", zlibCompressionLevel);
            return this;
        }
        /**
         * Specifies the degree of compression that Zlib should use to decrease
         * the size of requests to the connected MongoDB instance. The level can
         * range from -1 to 9, with lower values compressing faster (but
         * resulting in larger requests) and larger values compressing slower
         * (but resulting in smaller requests). Default: null.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param zlibCompressionLevel the value to set
         * @return the dsl builder
         */
        default AdvancedMongoDbEndpointBuilder zlibCompressionLevel(
                String zlibCompressionLevel) {
            doSetProperty("zlibCompressionLevel", zlibCompressionLevel);
            return this;
        }
    }

    public interface MongoDbBuilders {
        /**
         * MongoDB (camel-mongodb)
         * Perform operations on MongoDB documents and collections.
         * 
         * Category: database
         * Since: 2.19
         * Maven coordinates: org.apache.camel:camel-mongodb
         * 
         * @return the dsl builder for the headers' name.
         */
        default MongoDbHeaderNameBuilder mongodb() {
            return MongoDbHeaderNameBuilder.INSTANCE;
        }
        /**
         * MongoDB (camel-mongodb)
         * Perform operations on MongoDB documents and collections.
         * 
         * Category: database
         * Since: 2.19
         * Maven coordinates: org.apache.camel:camel-mongodb
         * 
         * Syntax: <code>mongodb:connectionBean</code>
         * 
         * Path parameter: connectionBean (required)
         * Sets the connection bean reference used to lookup a client for
         * connecting to a database if no hosts parameter is present.
         * 
         * @param path connectionBean
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder mongodb(String path) {
            return MongoDbEndpointBuilderFactory.endpointBuilder("mongodb", path);
        }
        /**
         * MongoDB (camel-mongodb)
         * Perform operations on MongoDB documents and collections.
         * 
         * Category: database
         * Since: 2.19
         * Maven coordinates: org.apache.camel:camel-mongodb
         * 
         * Syntax: <code>mongodb:connectionBean</code>
         * 
         * Path parameter: connectionBean (required)
         * Sets the connection bean reference used to lookup a client for
         * connecting to a database if no hosts parameter is present.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path connectionBean
         * @return the dsl builder
         */
        default MongoDbEndpointBuilder mongodb(String componentName, String path) {
            return MongoDbEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the MongoDB component.
     */
    public static class MongoDbHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final MongoDbHeaderNameBuilder INSTANCE = new MongoDbHeaderNameBuilder();

        /**
         * The operation this endpoint will execute against MongoDB.
         * 
         * The option is a: {@code
         * org.apache.camel.component.mongodb.MongoDbOperation or String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code MongoDbOperation}.
         */
        public String mongoDbOperation() {
            return "MongoDbOperation";
        }

        /**
         * Number of objects matching the query. This does not take limit/skip
         * into consideration.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer findAll
         * 
         * @return the name of the header {@code MongoDbResultTotalSize}.
         */
        public String mongoDbResultTotalSize() {
            return "MongoDbResultTotalSize";
        }

        /**
         * Number of objects matching the query. This does not take limit/skip
         * into consideration.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer findAll
         * 
         * @return the name of the header {@code MongoDbResultPageSize}.
         */
        public String mongoDbResultPageSize() {
            return "MongoDbResultPageSize";
        }

        /**
         * The query to execute against MongoDB.
         * 
         * The option is a: {@code org.bson.conversions.Bson} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code MongoDbCriteria}.
         */
        public String mongoDbCriteria() {
            return "MongoDbCriteria";
        }

        /**
         * The project document.
         * 
         * The option is a: {@code org.bson.conversions.Bson} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code MongoDbFieldsProjection}.
         */
        public String mongoDbFieldsProjection() {
            return "MongoDbFieldsProjection";
        }

        /**
         * The number of documents per batch.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer findAll aggregate
         * 
         * @return the name of the header {@code MongoDbBatchSize}.
         */
        public String mongoDbBatchSize() {
            return "MongoDbBatchSize";
        }

        /**
         * Discards a given number of elements at the beginning of the cursor.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer findAll
         * 
         * @return the name of the header {@code MongoDbNumToSkip}.
         */
        public String mongoDbNumToSkip() {
            return "MongoDbNumToSkip";
        }

        /**
         * If the update should be applied to all objects matching. See
         * http://www.mongodb.org/display/DOCS/AtomicOperationsAtomic
         * Operations.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer update
         * 
         * @return the name of the header {@code MongoDbMultiUpdate}.
         */
        public String mongoDbMultiUpdate() {
            return "MongoDbMultiUpdate";
        }

        /**
         * If the database should create the element if it does not exist.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer update
         * 
         * @return the name of the header {@code MongoDbUpsert}.
         */
        public String mongoDbUpsert() {
            return "MongoDbUpsert";
        }

        /**
         * The number of modified or deleted records.
         * 
         * The option is a: {@code long} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code MongoDbRecordsAffected}.
         */
        public String mongoDbRecordsAffected() {
            return "MongoDbRecordsAffected";
        }

        /**
         * The number of documents matched by the query.
         * 
         * The option is a: {@code long} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code MongoDbRecordsMatched}.
         */
        public String mongoDbRecordsMatched() {
            return "MongoDbRecordsMatched";
        }

        /**
         * The sort criteria.
         * 
         * The option is a: {@code Bson or Document} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code MongoDbSortBy}.
         */
        public String mongoDbSortBy() {
            return "MongoDbSortBy";
        }

        /**
         * The name of the MongoDB database to target.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code MongoDbDatabase}.
         */
        public String mongoDbDatabase() {
            return "MongoDbDatabase";
        }

        /**
         * The name of the MongoDB collection to bind to this endpoint.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code MongoDbCollection}.
         */
        public String mongoDbCollection() {
            return "MongoDbCollection";
        }

        /**
         * The list of dynamic indexes to create on the fly.
         * 
         * The option is a: {@code List<Bson>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code MongoDbCollectionIndex}.
         */
        public String mongoDbCollectionIndex() {
            return "MongoDbCollectionIndex";
        }

        /**
         * Limits the number of elements returned.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer findAll
         * 
         * @return the name of the header {@code MongoDbLimit}.
         */
        public String mongoDbLimit() {
            return "MongoDbLimit";
        }

        /**
         * Is from tailable.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code MongoDbTailable}.
         */
        public String mongoDbTailable() {
            return "MongoDbTailable";
        }

        /**
         * The result of the write operation.
         * 
         * The option is a: {@code Object} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code MongoWriteResult}.
         */
        public String mongoWriteResult() {
            return "MongoWriteResult";
        }

        /**
         * The OID(s) of the inserted record(s).
         * 
         * The option is a: {@code Object or List<Object>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code MongoOid}.
         */
        public String mongoOid() {
            return "MongoOid";
        }

        /**
         * The specified field name fow which we want to get the distinct
         * values.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code MongoDbDistinctQueryField}.
         */
        public String mongoDbDistinctQueryField() {
            return "MongoDbDistinctQueryField";
        }

        /**
         * Sets allowDiskUse MongoDB flag. This is supported since MongoDB
         * Server 4.3.1. Using this header with older MongoDB Server version can
         * cause query to fail.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Group: producer findAll aggregate
         * 
         * @return the name of the header {@code MongoDbAllowDiskUse}.
         */
        public String mongoDbAllowDiskUse() {
            return "MongoDbAllowDiskUse";
        }

        /**
         * Perform an ordered or unordered operation execution.
         * 
         * The option is a: {@code Boolean} type.
         * 
         * Default: TRUE
         * Group: producer bulkWrite
         * 
         * @return the name of the header {@code MongoDbBulkOrdered}.
         */
        public String mongoDbBulkOrdered() {
            return "MongoDbBulkOrdered";
        }

        /**
         * A document that contains the _id of the document created or modified
         * by the insert, replace, delete, update operations (i.e. CRUD
         * operations). For sharded collections, also displays the full shard
         * key for the document. The _id field is not repeated if it is already
         * a part of the shard key.
         * 
         * The option is a: {@code org.bson.types.ObjectId} type.
         * 
         * Group: consumer changeStreams
         * 
         * @return the name of the header {@code _id}.
         */
        public String id() {
            return "_id";
        }

        /**
         * The type of operation that occurred. Can be any of the following
         * values: insert, delete, replace, update, drop, rename, dropDatabase,
         * invalidate.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer changeStreams
         * 
         * @return the name of the header {@code MongoDbStreamOperationType}.
         */
        public String mongoDbStreamOperationType() {
            return "MongoDbStreamOperationType";
        }
    }
    static MongoDbEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class MongoDbEndpointBuilderImpl extends AbstractEndpointBuilder implements MongoDbEndpointBuilder, AdvancedMongoDbEndpointBuilder {
            public MongoDbEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new MongoDbEndpointBuilderImpl(path);
    }
}