/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.dhis2;

import java.util.Map;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.test.junit5.CamelTestSupport;
import org.junit.jupiter.api.TestInstance;

/**
 * Abstract base class for Dhis2 Integration tests generated by Camel API component maven plugin.
 */
@TestInstance(TestInstance.Lifecycle.PER_CLASS)
abstract class AbstractDhis2TestSupport extends CamelTestSupport {

    @Override
    protected CamelContext createCamelContext()
            throws Exception {

        String baseApiUrl = "http://" + Environment.getDhis2Container().getHost() + ":" + Environment.getDhis2Container()
                .getFirstMappedPort() + "/api";
        String username = "admin";
        String password = "district";

        final CamelContext context = super.createCamelContext();
        Dhis2Configuration configuration = new Dhis2Configuration();
        configuration.setBaseApiUrl(baseApiUrl);
        configuration.setUsername(username);
        configuration.setPassword(password);

        // add Dhis2Component to Camel context
        final Dhis2Component component = new Dhis2Component(context);
        component.setConfiguration(configuration);
        context.addComponent("dhis2", component);

        return context;
    }

    @SuppressWarnings("unchecked")
    protected <T> T requestBodyAndHeaders(String endpointUri, Object body, Map<String, Object> headers)
            throws CamelExecutionException {
        return (T) template().requestBodyAndHeaders(endpointUri, body, headers);
    }

    @SuppressWarnings("unchecked")
    protected <T> T requestBody(String endpoint, Object body)
            throws CamelExecutionException {
        return (T) template().requestBody(endpoint, body);
    }
}
