/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.aws2.ddb.localstack;

import org.apache.camel.CamelContext;
import org.apache.camel.component.aws2.ddb.Ddb2Component;
import org.apache.camel.test.infra.aws.common.services.AWSService;
import org.apache.camel.test.infra.aws2.clients.AWSSDKClientUtils;
import org.apache.camel.test.infra.aws2.services.AWSServiceFactory;
import org.apache.camel.test.junit5.CamelTestSupport;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.RegisterExtension;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@TestInstance(TestInstance.Lifecycle.PER_CLASS)
public class Aws2DDBBase extends CamelTestSupport {

    @RegisterExtension
    public static AWSService service = AWSServiceFactory.createDynamodbService();

    protected DynamoDbClient ddbClient;

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        Ddb2Component ddb2Component = context.getComponent("aws2-ddb", Ddb2Component.class);
        if (ddbClient == null) {
            ddbClient = AWSSDKClientUtils.newDynamoDBClient();
        }
        ddb2Component.getConfiguration().setAmazonDDBClient(ddbClient);
        return context;
    }
}
