/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.Map;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Send and receive emails using imap, pop3 and smtp protocols.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface MailEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the IMAP component.
     */
    public interface MailEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedMailEndpointConsumerBuilder advanced() {
            return (AdvancedMailEndpointConsumerBuilder) this;
        }
        /**
         * Whether the consumer should close the folder after polling. Setting
         * this option to false and having disconnect=false as well, then the
         * consumer keep the folder open between polls.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param closeFolder the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder closeFolder(boolean closeFolder) {
            doSetProperty("closeFolder", closeFolder);
            return this;
        }
        /**
         * Whether the consumer should close the folder after polling. Setting
         * this option to false and having disconnect=false as well, then the
         * consumer keep the folder open between polls.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param closeFolder the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder closeFolder(String closeFolder) {
            doSetProperty("closeFolder", closeFolder);
            return this;
        }
        /**
         * After processing a mail message, it can be copied to a mail folder
         * with the given name. You can override this configuration value, with
         * a header with the key copyTo, allowing you to copy messages to folder
         * names configured at runtime.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param copyTo the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder copyTo(String copyTo) {
            doSetProperty("copyTo", copyTo);
            return this;
        }
        /**
         * If set to true, the MimeUtility.decodeText method will be used to
         * decode the filename. This is similar to setting JVM system property
         * mail.mime.encodefilename.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param decodeFilename the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder decodeFilename(
                boolean decodeFilename) {
            doSetProperty("decodeFilename", decodeFilename);
            return this;
        }
        /**
         * If set to true, the MimeUtility.decodeText method will be used to
         * decode the filename. This is similar to setting JVM system property
         * mail.mime.encodefilename.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param decodeFilename the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder decodeFilename(String decodeFilename) {
            doSetProperty("decodeFilename", decodeFilename);
            return this;
        }
        /**
         * Deletes the messages after they have been processed. This is done by
         * setting the DELETED flag on the mail message. If false, the SEEN flag
         * is set instead. As of Camel 2.10 you can override this configuration
         * option by setting a header with the key delete to determine if the
         * mail should be deleted or not.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param delete the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder delete(boolean delete) {
            doSetProperty("delete", delete);
            return this;
        }
        /**
         * Deletes the messages after they have been processed. This is done by
         * setting the DELETED flag on the mail message. If false, the SEEN flag
         * is set instead. As of Camel 2.10 you can override this configuration
         * option by setting a header with the key delete to determine if the
         * mail should be deleted or not.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param delete the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder delete(String delete) {
            doSetProperty("delete", delete);
            return this;
        }
        /**
         * Whether the consumer should disconnect after polling. If enabled this
         * forces Camel to connect on each poll.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param disconnect the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder disconnect(boolean disconnect) {
            doSetProperty("disconnect", disconnect);
            return this;
        }
        /**
         * Whether the consumer should disconnect after polling. If enabled this
         * forces Camel to connect on each poll.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param disconnect the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder disconnect(String disconnect) {
            doSetProperty("disconnect", disconnect);
            return this;
        }
        /**
         * If the mail consumer cannot retrieve a given mail message, then this
         * option allows to handle the caused exception by the consumer's error
         * handler. By enable the bridge error handler on the consumer, then the
         * Camel routing error handler can handle the exception instead. The
         * default behavior would be the consumer throws an exception and no
         * mails from the batch would be able to be routed by Camel.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param handleFailedMessage the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder handleFailedMessage(
                boolean handleFailedMessage) {
            doSetProperty("handleFailedMessage", handleFailedMessage);
            return this;
        }
        /**
         * If the mail consumer cannot retrieve a given mail message, then this
         * option allows to handle the caused exception by the consumer's error
         * handler. By enable the bridge error handler on the consumer, then the
         * Camel routing error handler can handle the exception instead. The
         * default behavior would be the consumer throws an exception and no
         * mails from the batch would be able to be routed by Camel.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param handleFailedMessage the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder handleFailedMessage(
                String handleFailedMessage) {
            doSetProperty("handleFailedMessage", handleFailedMessage);
            return this;
        }
        /**
         * Specifies the maximum number of messages to gather per poll. By
         * default, no maximum is set. Can be used to set a limit of e.g. 1000
         * to avoid downloading thousands of files when the server starts up.
         * Set a value of 0 or negative to disable this option.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param maxMessagesPerPoll the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder maxMessagesPerPoll(
                int maxMessagesPerPoll) {
            doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }
        /**
         * Specifies the maximum number of messages to gather per poll. By
         * default, no maximum is set. Can be used to set a limit of e.g. 1000
         * to avoid downloading thousands of files when the server starts up.
         * Set a value of 0 or negative to disable this option.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param maxMessagesPerPoll the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder maxMessagesPerPoll(
                String maxMessagesPerPoll) {
            doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }
        /**
         * This option enables transparent MIME decoding and unfolding for mail
         * headers.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param mimeDecodeHeaders the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder mimeDecodeHeaders(
                boolean mimeDecodeHeaders) {
            doSetProperty("mimeDecodeHeaders", mimeDecodeHeaders);
            return this;
        }
        /**
         * This option enables transparent MIME decoding and unfolding for mail
         * headers.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param mimeDecodeHeaders the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder mimeDecodeHeaders(
                String mimeDecodeHeaders) {
            doSetProperty("mimeDecodeHeaders", mimeDecodeHeaders);
            return this;
        }
        /**
         * After processing a mail message, it can be moved to a mail folder
         * with the given name. You can override this configuration value, with
         * a header with the key moveTo, allowing you to move messages to folder
         * names configured at runtime.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param moveTo the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder moveTo(String moveTo) {
            doSetProperty("moveTo", moveTo);
            return this;
        }
        /**
         * Will mark the jakarta.mail.Message as peeked before processing the
         * mail message. This applies to IMAPMessage messages types only. By
         * using peek the mail will not be eager marked as SEEN on the mail
         * server, which allows us to rollback the mail message if there is an
         * error processing in Camel.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param peek the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder peek(boolean peek) {
            doSetProperty("peek", peek);
            return this;
        }
        /**
         * Will mark the jakarta.mail.Message as peeked before processing the
         * mail message. This applies to IMAPMessage messages types only. By
         * using peek the mail will not be eager marked as SEEN on the mail
         * server, which allows us to rollback the mail message if there is an
         * error processing in Camel.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param peek the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder peek(String peek) {
            doSetProperty("peek", peek);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the mail consumer cannot retrieve a given mail message, then this
         * option allows to skip the message and move on to retrieve the next
         * mail message. The default behavior would be the consumer throws an
         * exception and no mails from the batch would be able to be routed by
         * Camel.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param skipFailedMessage the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder skipFailedMessage(
                boolean skipFailedMessage) {
            doSetProperty("skipFailedMessage", skipFailedMessage);
            return this;
        }
        /**
         * If the mail consumer cannot retrieve a given mail message, then this
         * option allows to skip the message and move on to retrieve the next
         * mail message. The default behavior would be the consumer throws an
         * exception and no mails from the batch would be able to be routed by
         * Camel.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param skipFailedMessage the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder skipFailedMessage(
                String skipFailedMessage) {
            doSetProperty("skipFailedMessage", skipFailedMessage);
            return this;
        }
        /**
         * Whether to limit by unseen mails only.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param unseen the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder unseen(boolean unseen) {
            doSetProperty("unseen", unseen);
            return this;
        }
        /**
         * Whether to limit by unseen mails only.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param unseen the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder unseen(String unseen) {
            doSetProperty("unseen", unseen);
            return this;
        }
        /**
         * A pluggable repository org.apache.camel.spi.IdempotentRepository
         * which allows to cluster consuming from the same mailbox, and let the
         * repository coordinate whether a mail message is valid for the
         * consumer to process. By default no repository is in use.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.IdempotentRepository&lt;/code&gt;
         * type.
         * 
         * Group: filter
         * 
         * @param idempotentRepository the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder idempotentRepository(
                org.apache.camel.spi.IdempotentRepository idempotentRepository) {
            doSetProperty("idempotentRepository", idempotentRepository);
            return this;
        }
        /**
         * A pluggable repository org.apache.camel.spi.IdempotentRepository
         * which allows to cluster consuming from the same mailbox, and let the
         * repository coordinate whether a mail message is valid for the
         * consumer to process. By default no repository is in use.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.IdempotentRepository&lt;/code&gt;
         * type.
         * 
         * Group: filter
         * 
         * @param idempotentRepository the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder idempotentRepository(
                String idempotentRepository) {
            doSetProperty("idempotentRepository", idempotentRepository);
            return this;
        }
        /**
         * When using idempotent repository, then when the mail message has been
         * successfully processed and is committed, should the message id be
         * removed from the idempotent repository (default) or be kept in the
         * repository. By default its assumed the message id is unique and has
         * no value to be kept in the repository, because the mail message will
         * be marked as seen/moved or deleted to prevent it from being consumed
         * again. And therefore having the message id stored in the idempotent
         * repository has little value. However this option allows to store the
         * message id, for whatever reason you may have.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param idempotentRepositoryRemoveOnCommit the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder idempotentRepositoryRemoveOnCommit(
                boolean idempotentRepositoryRemoveOnCommit) {
            doSetProperty("idempotentRepositoryRemoveOnCommit", idempotentRepositoryRemoveOnCommit);
            return this;
        }
        /**
         * When using idempotent repository, then when the mail message has been
         * successfully processed and is committed, should the message id be
         * removed from the idempotent repository (default) or be kept in the
         * repository. By default its assumed the message id is unique and has
         * no value to be kept in the repository, because the mail message will
         * be marked as seen/moved or deleted to prevent it from being consumed
         * again. And therefore having the message id stored in the idempotent
         * repository has little value. However this option allows to store the
         * message id, for whatever reason you may have.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: filter
         * 
         * @param idempotentRepositoryRemoveOnCommit the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder idempotentRepositoryRemoveOnCommit(
                String idempotentRepositoryRemoveOnCommit) {
            doSetProperty("idempotentRepositoryRemoveOnCommit", idempotentRepositoryRemoveOnCommit);
            return this;
        }
        /**
         * Refers to a jakarta.mail.search.SearchTerm which allows to filter
         * mails based on search criteria such as subject, body, from, sent
         * after a certain date etc.
         * 
         * The option is a:
         * &lt;code&gt;jakarta.mail.search.SearchTerm&lt;/code&gt; type.
         * The option is multivalued, and you can use the searchTerm(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: filter
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder searchTerm(String key, Object value) {
            doSetMultiValueProperty("searchTerm", "searchTerm." + key, value);
            return this;
        }
        /**
         * Refers to a jakarta.mail.search.SearchTerm which allows to filter
         * mails based on search criteria such as subject, body, from, sent
         * after a certain date etc.
         * 
         * The option is a:
         * &lt;code&gt;jakarta.mail.search.SearchTerm&lt;/code&gt; type.
         * The option is multivalued, and you can use the searchTerm(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: filter
         * 
         * @param values the values
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder searchTerm(Map values) {
            doSetMultiValueProperties("searchTerm", "searchTerm.", values);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 60000
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 60000
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder initialDelay(String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder repeatCount(long repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder repeatCount(String repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder runLoggingLevel(
                org.apache.camel.LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder runLoggingLevel(
                String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option is a: &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder scheduler(Object scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder schedulerProperties(
                String key,
                Object value) {
            doSetMultiValueProperty("schedulerProperties", "scheduler." + key, value);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param values the values
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder schedulerProperties(Map values) {
            doSetMultiValueProperties("schedulerProperties", "scheduler.", values);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder startScheduler(
                boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder startScheduler(String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder useFixedDelay(boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder useFixedDelay(String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * The password for login. See also setAuthenticator(MailAuthenticator).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * The username for login. See also setAuthenticator(MailAuthenticator).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
        /**
         * Sorting order for messages. Only natively supported for IMAP.
         * Emulated to some degree when using POP3 or when IMAP server does not
         * have the SORT capability.
         * 
         * The option is a:
         * &lt;code&gt;com.sun.mail.imap.SortTerm[]&lt;/code&gt; type.
         * 
         * Group: sort
         * 
         * @param sortTerm the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder sortTerm(
                com.sun.mail.imap.SortTerm[] sortTerm) {
            doSetProperty("sortTerm", sortTerm);
            return this;
        }
        /**
         * Sorting order for messages. Only natively supported for IMAP.
         * Emulated to some degree when using POP3 or when IMAP server does not
         * have the SORT capability.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.sun.mail.imap.SortTerm[]&lt;/code&gt; type.
         * 
         * Group: sort
         * 
         * @param sortTerm the value to set
         * @return the dsl builder
         */
        default MailEndpointConsumerBuilder sortTerm(String sortTerm) {
            doSetProperty("sortTerm", sortTerm);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the IMAP component.
     */
    public interface AdvancedMailEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default MailEndpointConsumerBuilder basic() {
            return (MailEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Whether to fail processing the mail if the mail message contains
         * attachments with duplicate file names. If set to false, then the
         * duplicate attachment is skipped and a WARN is logged. If set to true
         * then an exception is thrown failing to process the mail message.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param failOnDuplicateFileAttachment the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder failOnDuplicateFileAttachment(
                boolean failOnDuplicateFileAttachment) {
            doSetProperty("failOnDuplicateFileAttachment", failOnDuplicateFileAttachment);
            return this;
        }
        /**
         * Whether to fail processing the mail if the mail message contains
         * attachments with duplicate file names. If set to false, then the
         * duplicate attachment is skipped and a WARN is logged. If set to true
         * then an exception is thrown failing to process the mail message.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param failOnDuplicateFileAttachment the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder failOnDuplicateFileAttachment(
                String failOnDuplicateFileAttachment) {
            doSetProperty("failOnDuplicateFileAttachment", failOnDuplicateFileAttachment);
            return this;
        }
        /**
         * Sets the maximum number of messages to consume during a poll. This
         * can be used to avoid overloading a mail server, if a mailbox folder
         * contains a lot of messages. Default value of -1 means no fetch size
         * and all messages will be consumed. Setting the value to 0 is a
         * special corner case, where Camel will not consume any messages at
         * all.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: consumer (advanced)
         * 
         * @param fetchSize the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder fetchSize(int fetchSize) {
            doSetProperty("fetchSize", fetchSize);
            return this;
        }
        /**
         * Sets the maximum number of messages to consume during a poll. This
         * can be used to avoid overloading a mail server, if a mailbox folder
         * contains a lot of messages. Default value of -1 means no fetch size
         * and all messages will be consumed. Setting the value to 0 is a
         * special corner case, where Camel will not consume any messages at
         * all.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: consumer (advanced)
         * 
         * @param fetchSize the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder fetchSize(String fetchSize) {
            doSetProperty("fetchSize", fetchSize);
            return this;
        }
        /**
         * The folder to poll.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: INBOX
         * Group: consumer (advanced)
         * 
         * @param folderName the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder folderName(String folderName) {
            doSetProperty("folderName", folderName);
            return this;
        }
        /**
         * Set this to 'uuid' to set a UUID for the filename of the attachment
         * if no filename was set.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param generateMissingAttachmentNames the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder generateMissingAttachmentNames(
                String generateMissingAttachmentNames) {
            doSetProperty("generateMissingAttachmentNames", generateMissingAttachmentNames);
            return this;
        }
        /**
         * Set the strategy to handle duplicate filenames of attachments never:
         * attachments that have a filename which is already present in the
         * attachments will be ignored unless failOnDuplicateFileAttachment is
         * set to true. uuidPrefix: this will prefix the duplicate attachment
         * filenames each with a uuid and underscore
         * (uuid_filename.fileextension). uuidSuffix: this will suffix the
         * duplicate attachment filenames each with a underscore and uuid
         * (filename_uuid.fileextension).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param handleDuplicateAttachmentNames the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder handleDuplicateAttachmentNames(
                String handleDuplicateAttachmentNames) {
            doSetProperty("handleDuplicateAttachmentNames", handleDuplicateAttachmentNames);
            return this;
        }
        /**
         * A pluggable MailUidGenerator that allows to use custom logic to
         * generate UUID of the mail message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.mail.MailUidGenerator&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param mailUidGenerator the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder mailUidGenerator(
                org.apache.camel.component.mail.MailUidGenerator mailUidGenerator) {
            doSetProperty("mailUidGenerator", mailUidGenerator);
            return this;
        }
        /**
         * A pluggable MailUidGenerator that allows to use custom logic to
         * generate UUID of the mail message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.mail.MailUidGenerator&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param mailUidGenerator the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder mailUidGenerator(
                String mailUidGenerator) {
            doSetProperty("mailUidGenerator", mailUidGenerator);
            return this;
        }
        /**
         * Specifies whether Camel should map the received mail message to Camel
         * body/headers/attachments. If set to true, the body of the mail
         * message is mapped to the body of the Camel IN message, the mail
         * headers are mapped to IN headers, and the attachments to Camel IN
         * attachment message. If this option is set to false then the IN
         * message contains a raw jakarta.mail.Message. You can retrieve this
         * raw message by calling
         * exchange.getIn().getBody(jakarta.mail.Message.class).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer (advanced)
         * 
         * @param mapMailMessage the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder mapMailMessage(
                boolean mapMailMessage) {
            doSetProperty("mapMailMessage", mapMailMessage);
            return this;
        }
        /**
         * Specifies whether Camel should map the received mail message to Camel
         * body/headers/attachments. If set to true, the body of the mail
         * message is mapped to the body of the Camel IN message, the mail
         * headers are mapped to IN headers, and the attachments to Camel IN
         * attachment message. If this option is set to false then the IN
         * message contains a raw jakarta.mail.Message. You can retrieve this
         * raw message by calling
         * exchange.getIn().getBody(jakarta.mail.Message.class).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer (advanced)
         * 
         * @param mapMailMessage the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder mapMailMessage(
                String mapMailMessage) {
            doSetProperty("mapMailMessage", mapMailMessage);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder pollStrategy(
                org.apache.camel.spi.PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * Refers to an MailBoxPostProcessAction for doing post processing tasks
         * on the mailbox once the normal processing ended.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.mail.MailBoxPostProcessAction&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param postProcessAction the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder postProcessAction(
                org.apache.camel.component.mail.MailBoxPostProcessAction postProcessAction) {
            doSetProperty("postProcessAction", postProcessAction);
            return this;
        }
        /**
         * Refers to an MailBoxPostProcessAction for doing post processing tasks
         * on the mailbox once the normal processing ended.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.mail.MailBoxPostProcessAction&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param postProcessAction the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder postProcessAction(
                String postProcessAction) {
            doSetProperty("postProcessAction", postProcessAction);
            return this;
        }
        /**
         * Sets additional java mail properties, that will append/override any
         * default properties that is set based on all the other options. This
         * is useful if you need to add some special options but want to keep
         * the others as is.
         * 
         * The option is a: &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * additionalJavaMailProperties(String, Object) method to add a value
         * (call the method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder additionalJavaMailProperties(
                String key,
                Object value) {
            doSetMultiValueProperty("additionalJavaMailProperties", "mail." + key, value);
            return this;
        }
        /**
         * Sets additional java mail properties, that will append/override any
         * default properties that is set based on all the other options. This
         * is useful if you need to add some special options but want to keep
         * the others as is.
         * 
         * The option is a: &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * additionalJavaMailProperties(String, Object) method to add a value
         * (call the method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder additionalJavaMailProperties(
                Map values) {
            doSetMultiValueProperties("additionalJavaMailProperties", "mail.", values);
            return this;
        }
        /**
         * Specifies the key to an IN message header that contains an
         * alternative email body. For example, if you send emails in text/html
         * format and want to provide an alternative mail body for non-HTML
         * email clients, set the alternative mail body with this key as a
         * header.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: CamelMailAlternativeBody
         * Group: advanced
         * 
         * @param alternativeBodyHeader the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder alternativeBodyHeader(
                String alternativeBodyHeader) {
            doSetProperty("alternativeBodyHeader", alternativeBodyHeader);
            return this;
        }
        /**
         * To use a custom AttachmentsContentTransferEncodingResolver to resolve
         * what content-type-encoding to use for attachments.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.mail.AttachmentsContentTransferEncodingResolver&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param attachmentsContentTransferEncodingResolver the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder attachmentsContentTransferEncodingResolver(
                org.apache.camel.component.mail.AttachmentsContentTransferEncodingResolver attachmentsContentTransferEncodingResolver) {
            doSetProperty("attachmentsContentTransferEncodingResolver", attachmentsContentTransferEncodingResolver);
            return this;
        }
        /**
         * To use a custom AttachmentsContentTransferEncodingResolver to resolve
         * what content-type-encoding to use for attachments.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.mail.AttachmentsContentTransferEncodingResolver&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param attachmentsContentTransferEncodingResolver the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder attachmentsContentTransferEncodingResolver(
                String attachmentsContentTransferEncodingResolver) {
            doSetProperty("attachmentsContentTransferEncodingResolver", attachmentsContentTransferEncodingResolver);
            return this;
        }
        /**
         * The authenticator for login. If set then the password and username
         * are ignored. Can be used for tokens which can expire and therefore
         * must be read dynamically.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.mail.MailAuthenticator&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param authenticator the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder authenticator(
                org.apache.camel.component.mail.MailAuthenticator authenticator) {
            doSetProperty("authenticator", authenticator);
            return this;
        }
        /**
         * The authenticator for login. If set then the password and username
         * are ignored. Can be used for tokens which can expire and therefore
         * must be read dynamically.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.mail.MailAuthenticator&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param authenticator the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder authenticator(
                String authenticator) {
            doSetProperty("authenticator", authenticator);
            return this;
        }
        /**
         * Sets the binding used to convert from a Camel message to and from a
         * Mail message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.mail.MailBinding&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param binding the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder binding(
                org.apache.camel.component.mail.MailBinding binding) {
            doSetProperty("binding", binding);
            return this;
        }
        /**
         * Sets the binding used to convert from a Camel message to and from a
         * Mail message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.mail.MailBinding&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param binding the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder binding(String binding) {
            doSetProperty("binding", binding);
            return this;
        }
        /**
         * The connection timeout in milliseconds.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: advanced
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder connectionTimeout(
                int connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * The connection timeout in milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: advanced
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder connectionTimeout(
                String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * The mail message content type. Use text/html for HTML mails.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: text/plain
         * Group: advanced
         * 
         * @param contentType the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder contentType(
                String contentType) {
            doSetProperty("contentType", contentType);
            return this;
        }
        /**
         * Resolver to determine Content-Type for file attachments.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.mail.ContentTypeResolver&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param contentTypeResolver the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder contentTypeResolver(
                org.apache.camel.component.mail.ContentTypeResolver contentTypeResolver) {
            doSetProperty("contentTypeResolver", contentTypeResolver);
            return this;
        }
        /**
         * Resolver to determine Content-Type for file attachments.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.mail.ContentTypeResolver&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param contentTypeResolver the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder contentTypeResolver(
                String contentTypeResolver) {
            doSetProperty("contentTypeResolver", contentTypeResolver);
            return this;
        }
        /**
         * Enable debug mode on the underlying mail framework. The SUN Mail
         * framework logs the debug messages to System.out by default.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param debugMode the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder debugMode(boolean debugMode) {
            doSetProperty("debugMode", debugMode);
            return this;
        }
        /**
         * Enable debug mode on the underlying mail framework. The SUN Mail
         * framework logs the debug messages to System.out by default.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param debugMode the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder debugMode(String debugMode) {
            doSetProperty("debugMode", debugMode);
            return this;
        }
        /**
         * To use a custom org.apache.camel.spi.HeaderFilterStrategy to filter
         * headers.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder headerFilterStrategy(
                org.apache.camel.spi.HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom org.apache.camel.spi.HeaderFilterStrategy to filter
         * headers.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Option to let Camel ignore unsupported charset in the local JVM when
         * sending mails. If the charset is unsupported then charset=XXX (where
         * XXX represents the unsupported charset) is removed from the
         * content-type and it relies on the platform default instead.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param ignoreUnsupportedCharset the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder ignoreUnsupportedCharset(
                boolean ignoreUnsupportedCharset) {
            doSetProperty("ignoreUnsupportedCharset", ignoreUnsupportedCharset);
            return this;
        }
        /**
         * Option to let Camel ignore unsupported charset in the local JVM when
         * sending mails. If the charset is unsupported then charset=XXX (where
         * XXX represents the unsupported charset) is removed from the
         * content-type and it relies on the platform default instead.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param ignoreUnsupportedCharset the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder ignoreUnsupportedCharset(
                String ignoreUnsupportedCharset) {
            doSetProperty("ignoreUnsupportedCharset", ignoreUnsupportedCharset);
            return this;
        }
        /**
         * Option to let Camel ignore unsupported charset in the local JVM when
         * sending mails. If the charset is unsupported then charset=XXX (where
         * XXX represents the unsupported charset) is removed from the
         * content-type and it relies on the platform default instead.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param ignoreUriScheme the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder ignoreUriScheme(
                boolean ignoreUriScheme) {
            doSetProperty("ignoreUriScheme", ignoreUriScheme);
            return this;
        }
        /**
         * Option to let Camel ignore unsupported charset in the local JVM when
         * sending mails. If the charset is unsupported then charset=XXX (where
         * XXX represents the unsupported charset) is removed from the
         * content-type and it relies on the platform default instead.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param ignoreUriScheme the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder ignoreUriScheme(
                String ignoreUriScheme) {
            doSetProperty("ignoreUriScheme", ignoreUriScheme);
            return this;
        }
        /**
         * Sets the java mail options. Will clear any default properties and
         * only use the properties provided for this method.
         * 
         * The option is a: &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param javaMailProperties the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder javaMailProperties(
                Properties javaMailProperties) {
            doSetProperty("javaMailProperties", javaMailProperties);
            return this;
        }
        /**
         * Sets the java mail options. Will clear any default properties and
         * only use the properties provided for this method.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param javaMailProperties the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder javaMailProperties(
                String javaMailProperties) {
            doSetProperty("javaMailProperties", javaMailProperties);
            return this;
        }
        /**
         * Specifies the mail session that camel should use for all mail
         * interactions. Useful in scenarios where mail sessions are created and
         * managed by some other resource, such as a JavaEE container. When
         * using a custom mail session, then the hostname and port from the mail
         * session will be used (if configured on the session).
         * 
         * The option is a: &lt;code&gt;jakarta.mail.Session&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param session the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder session(
                jakarta.mail.Session session) {
            doSetProperty("session", session);
            return this;
        }
        /**
         * Specifies the mail session that camel should use for all mail
         * interactions. Useful in scenarios where mail sessions are created and
         * managed by some other resource, such as a JavaEE container. When
         * using a custom mail session, then the hostname and port from the mail
         * session will be used (if configured on the session).
         * 
         * The option will be converted to a
         * &lt;code&gt;jakarta.mail.Session&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param session the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder session(String session) {
            doSetProperty("session", session);
            return this;
        }
        /**
         * Whether to use disposition inline or attachment.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param useInlineAttachments the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder useInlineAttachments(
                boolean useInlineAttachments) {
            doSetProperty("useInlineAttachments", useInlineAttachments);
            return this;
        }
        /**
         * Whether to use disposition inline or attachment.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param useInlineAttachments the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointConsumerBuilder useInlineAttachments(
                String useInlineAttachments) {
            doSetProperty("useInlineAttachments", useInlineAttachments);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the IMAP component.
     */
    public interface MailEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedMailEndpointProducerBuilder advanced() {
            return (AdvancedMailEndpointProducerBuilder) this;
        }
        /**
         * Sets the BCC email address. Separate multiple email addresses with
         * comma.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param bcc the value to set
         * @return the dsl builder
         */
        default MailEndpointProducerBuilder bcc(String bcc) {
            doSetProperty("bcc", bcc);
            return this;
        }
        /**
         * Sets the CC email address. Separate multiple email addresses with
         * comma.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param cc the value to set
         * @return the dsl builder
         */
        default MailEndpointProducerBuilder cc(String cc) {
            doSetProperty("cc", cc);
            return this;
        }
        /**
         * The from email address.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: camel@localhost
         * Group: producer
         * 
         * @param from the value to set
         * @return the dsl builder
         */
        default MailEndpointProducerBuilder from(String from) {
            doSetProperty("from", from);
            return this;
        }
        /**
         * The Reply-To recipients (the receivers of the response mail).
         * Separate multiple email addresses with a comma.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param replyTo the value to set
         * @return the dsl builder
         */
        default MailEndpointProducerBuilder replyTo(String replyTo) {
            doSetProperty("replyTo", replyTo);
            return this;
        }
        /**
         * The Subject of the message being sent. Note: Setting the subject in
         * the header takes precedence over this option.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param subject the value to set
         * @return the dsl builder
         */
        default MailEndpointProducerBuilder subject(String subject) {
            doSetProperty("subject", subject);
            return this;
        }
        /**
         * Sets the To email address. Separate multiple email addresses with
         * comma.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param to the value to set
         * @return the dsl builder
         */
        default MailEndpointProducerBuilder to(String to) {
            doSetProperty("to", to);
            return this;
        }
        /**
         * The password for login. See also setAuthenticator(MailAuthenticator).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default MailEndpointProducerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default MailEndpointProducerBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default MailEndpointProducerBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * The username for login. See also setAuthenticator(MailAuthenticator).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default MailEndpointProducerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the IMAP component.
     */
    public interface AdvancedMailEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default MailEndpointProducerBuilder basic() {
            return (MailEndpointProducerBuilder) this;
        }
        /**
         * To use a custom org.apache.camel.component.mail.JavaMailSender for
         * sending emails.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.mail.JavaMailSender&lt;/code&gt; type.
         * 
         * Group: producer (advanced)
         * 
         * @param javaMailSender the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointProducerBuilder javaMailSender(
                org.apache.camel.component.mail.JavaMailSender javaMailSender) {
            doSetProperty("javaMailSender", javaMailSender);
            return this;
        }
        /**
         * To use a custom org.apache.camel.component.mail.JavaMailSender for
         * sending emails.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.mail.JavaMailSender&lt;/code&gt; type.
         * 
         * Group: producer (advanced)
         * 
         * @param javaMailSender the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointProducerBuilder javaMailSender(
                String javaMailSender) {
            doSetProperty("javaMailSender", javaMailSender);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Sets additional java mail properties, that will append/override any
         * default properties that is set based on all the other options. This
         * is useful if you need to add some special options but want to keep
         * the others as is.
         * 
         * The option is a: &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * additionalJavaMailProperties(String, Object) method to add a value
         * (call the method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedMailEndpointProducerBuilder additionalJavaMailProperties(
                String key,
                Object value) {
            doSetMultiValueProperty("additionalJavaMailProperties", "mail." + key, value);
            return this;
        }
        /**
         * Sets additional java mail properties, that will append/override any
         * default properties that is set based on all the other options. This
         * is useful if you need to add some special options but want to keep
         * the others as is.
         * 
         * The option is a: &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * additionalJavaMailProperties(String, Object) method to add a value
         * (call the method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedMailEndpointProducerBuilder additionalJavaMailProperties(
                Map values) {
            doSetMultiValueProperties("additionalJavaMailProperties", "mail.", values);
            return this;
        }
        /**
         * Specifies the key to an IN message header that contains an
         * alternative email body. For example, if you send emails in text/html
         * format and want to provide an alternative mail body for non-HTML
         * email clients, set the alternative mail body with this key as a
         * header.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: CamelMailAlternativeBody
         * Group: advanced
         * 
         * @param alternativeBodyHeader the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointProducerBuilder alternativeBodyHeader(
                String alternativeBodyHeader) {
            doSetProperty("alternativeBodyHeader", alternativeBodyHeader);
            return this;
        }
        /**
         * To use a custom AttachmentsContentTransferEncodingResolver to resolve
         * what content-type-encoding to use for attachments.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.mail.AttachmentsContentTransferEncodingResolver&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param attachmentsContentTransferEncodingResolver the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointProducerBuilder attachmentsContentTransferEncodingResolver(
                org.apache.camel.component.mail.AttachmentsContentTransferEncodingResolver attachmentsContentTransferEncodingResolver) {
            doSetProperty("attachmentsContentTransferEncodingResolver", attachmentsContentTransferEncodingResolver);
            return this;
        }
        /**
         * To use a custom AttachmentsContentTransferEncodingResolver to resolve
         * what content-type-encoding to use for attachments.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.mail.AttachmentsContentTransferEncodingResolver&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param attachmentsContentTransferEncodingResolver the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointProducerBuilder attachmentsContentTransferEncodingResolver(
                String attachmentsContentTransferEncodingResolver) {
            doSetProperty("attachmentsContentTransferEncodingResolver", attachmentsContentTransferEncodingResolver);
            return this;
        }
        /**
         * The authenticator for login. If set then the password and username
         * are ignored. Can be used for tokens which can expire and therefore
         * must be read dynamically.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.mail.MailAuthenticator&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param authenticator the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointProducerBuilder authenticator(
                org.apache.camel.component.mail.MailAuthenticator authenticator) {
            doSetProperty("authenticator", authenticator);
            return this;
        }
        /**
         * The authenticator for login. If set then the password and username
         * are ignored. Can be used for tokens which can expire and therefore
         * must be read dynamically.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.mail.MailAuthenticator&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param authenticator the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointProducerBuilder authenticator(
                String authenticator) {
            doSetProperty("authenticator", authenticator);
            return this;
        }
        /**
         * Sets the binding used to convert from a Camel message to and from a
         * Mail message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.mail.MailBinding&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param binding the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointProducerBuilder binding(
                org.apache.camel.component.mail.MailBinding binding) {
            doSetProperty("binding", binding);
            return this;
        }
        /**
         * Sets the binding used to convert from a Camel message to and from a
         * Mail message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.mail.MailBinding&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param binding the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointProducerBuilder binding(String binding) {
            doSetProperty("binding", binding);
            return this;
        }
        /**
         * The connection timeout in milliseconds.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: advanced
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointProducerBuilder connectionTimeout(
                int connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * The connection timeout in milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: advanced
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointProducerBuilder connectionTimeout(
                String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * The mail message content type. Use text/html for HTML mails.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: text/plain
         * Group: advanced
         * 
         * @param contentType the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointProducerBuilder contentType(
                String contentType) {
            doSetProperty("contentType", contentType);
            return this;
        }
        /**
         * Resolver to determine Content-Type for file attachments.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.mail.ContentTypeResolver&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param contentTypeResolver the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointProducerBuilder contentTypeResolver(
                org.apache.camel.component.mail.ContentTypeResolver contentTypeResolver) {
            doSetProperty("contentTypeResolver", contentTypeResolver);
            return this;
        }
        /**
         * Resolver to determine Content-Type for file attachments.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.mail.ContentTypeResolver&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param contentTypeResolver the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointProducerBuilder contentTypeResolver(
                String contentTypeResolver) {
            doSetProperty("contentTypeResolver", contentTypeResolver);
            return this;
        }
        /**
         * Enable debug mode on the underlying mail framework. The SUN Mail
         * framework logs the debug messages to System.out by default.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param debugMode the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointProducerBuilder debugMode(boolean debugMode) {
            doSetProperty("debugMode", debugMode);
            return this;
        }
        /**
         * Enable debug mode on the underlying mail framework. The SUN Mail
         * framework logs the debug messages to System.out by default.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param debugMode the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointProducerBuilder debugMode(String debugMode) {
            doSetProperty("debugMode", debugMode);
            return this;
        }
        /**
         * To use a custom org.apache.camel.spi.HeaderFilterStrategy to filter
         * headers.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointProducerBuilder headerFilterStrategy(
                org.apache.camel.spi.HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom org.apache.camel.spi.HeaderFilterStrategy to filter
         * headers.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointProducerBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Option to let Camel ignore unsupported charset in the local JVM when
         * sending mails. If the charset is unsupported then charset=XXX (where
         * XXX represents the unsupported charset) is removed from the
         * content-type and it relies on the platform default instead.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param ignoreUnsupportedCharset the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointProducerBuilder ignoreUnsupportedCharset(
                boolean ignoreUnsupportedCharset) {
            doSetProperty("ignoreUnsupportedCharset", ignoreUnsupportedCharset);
            return this;
        }
        /**
         * Option to let Camel ignore unsupported charset in the local JVM when
         * sending mails. If the charset is unsupported then charset=XXX (where
         * XXX represents the unsupported charset) is removed from the
         * content-type and it relies on the platform default instead.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param ignoreUnsupportedCharset the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointProducerBuilder ignoreUnsupportedCharset(
                String ignoreUnsupportedCharset) {
            doSetProperty("ignoreUnsupportedCharset", ignoreUnsupportedCharset);
            return this;
        }
        /**
         * Option to let Camel ignore unsupported charset in the local JVM when
         * sending mails. If the charset is unsupported then charset=XXX (where
         * XXX represents the unsupported charset) is removed from the
         * content-type and it relies on the platform default instead.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param ignoreUriScheme the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointProducerBuilder ignoreUriScheme(
                boolean ignoreUriScheme) {
            doSetProperty("ignoreUriScheme", ignoreUriScheme);
            return this;
        }
        /**
         * Option to let Camel ignore unsupported charset in the local JVM when
         * sending mails. If the charset is unsupported then charset=XXX (where
         * XXX represents the unsupported charset) is removed from the
         * content-type and it relies on the platform default instead.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param ignoreUriScheme the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointProducerBuilder ignoreUriScheme(
                String ignoreUriScheme) {
            doSetProperty("ignoreUriScheme", ignoreUriScheme);
            return this;
        }
        /**
         * Sets the java mail options. Will clear any default properties and
         * only use the properties provided for this method.
         * 
         * The option is a: &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param javaMailProperties the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointProducerBuilder javaMailProperties(
                Properties javaMailProperties) {
            doSetProperty("javaMailProperties", javaMailProperties);
            return this;
        }
        /**
         * Sets the java mail options. Will clear any default properties and
         * only use the properties provided for this method.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param javaMailProperties the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointProducerBuilder javaMailProperties(
                String javaMailProperties) {
            doSetProperty("javaMailProperties", javaMailProperties);
            return this;
        }
        /**
         * Specifies the mail session that camel should use for all mail
         * interactions. Useful in scenarios where mail sessions are created and
         * managed by some other resource, such as a JavaEE container. When
         * using a custom mail session, then the hostname and port from the mail
         * session will be used (if configured on the session).
         * 
         * The option is a: &lt;code&gt;jakarta.mail.Session&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param session the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointProducerBuilder session(
                jakarta.mail.Session session) {
            doSetProperty("session", session);
            return this;
        }
        /**
         * Specifies the mail session that camel should use for all mail
         * interactions. Useful in scenarios where mail sessions are created and
         * managed by some other resource, such as a JavaEE container. When
         * using a custom mail session, then the hostname and port from the mail
         * session will be used (if configured on the session).
         * 
         * The option will be converted to a
         * &lt;code&gt;jakarta.mail.Session&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param session the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointProducerBuilder session(String session) {
            doSetProperty("session", session);
            return this;
        }
        /**
         * Whether to use disposition inline or attachment.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param useInlineAttachments the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointProducerBuilder useInlineAttachments(
                boolean useInlineAttachments) {
            doSetProperty("useInlineAttachments", useInlineAttachments);
            return this;
        }
        /**
         * Whether to use disposition inline or attachment.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param useInlineAttachments the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointProducerBuilder useInlineAttachments(
                String useInlineAttachments) {
            doSetProperty("useInlineAttachments", useInlineAttachments);
            return this;
        }
    }

    /**
     * Builder for endpoint for the IMAP component.
     */
    public interface MailEndpointBuilder
            extends
                MailEndpointConsumerBuilder,
                MailEndpointProducerBuilder {
        default AdvancedMailEndpointBuilder advanced() {
            return (AdvancedMailEndpointBuilder) this;
        }
        /**
         * The password for login. See also setAuthenticator(MailAuthenticator).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param password the value to set
         * @return the dsl builder
         */
        default MailEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default MailEndpointBuilder sslContextParameters(
                org.apache.camel.support.jsse.SSLContextParameters sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default MailEndpointBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * The username for login. See also setAuthenticator(MailAuthenticator).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param username the value to set
         * @return the dsl builder
         */
        default MailEndpointBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the IMAP component.
     */
    public interface AdvancedMailEndpointBuilder
            extends
                AdvancedMailEndpointConsumerBuilder,
                AdvancedMailEndpointProducerBuilder {
        default MailEndpointBuilder basic() {
            return (MailEndpointBuilder) this;
        }
        /**
         * Sets additional java mail properties, that will append/override any
         * default properties that is set based on all the other options. This
         * is useful if you need to add some special options but want to keep
         * the others as is.
         * 
         * The option is a: &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * additionalJavaMailProperties(String, Object) method to add a value
         * (call the method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedMailEndpointBuilder additionalJavaMailProperties(
                String key,
                Object value) {
            doSetMultiValueProperty("additionalJavaMailProperties", "mail." + key, value);
            return this;
        }
        /**
         * Sets additional java mail properties, that will append/override any
         * default properties that is set based on all the other options. This
         * is useful if you need to add some special options but want to keep
         * the others as is.
         * 
         * The option is a: &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * additionalJavaMailProperties(String, Object) method to add a value
         * (call the method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedMailEndpointBuilder additionalJavaMailProperties(
                Map values) {
            doSetMultiValueProperties("additionalJavaMailProperties", "mail.", values);
            return this;
        }
        /**
         * Specifies the key to an IN message header that contains an
         * alternative email body. For example, if you send emails in text/html
         * format and want to provide an alternative mail body for non-HTML
         * email clients, set the alternative mail body with this key as a
         * header.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: CamelMailAlternativeBody
         * Group: advanced
         * 
         * @param alternativeBodyHeader the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointBuilder alternativeBodyHeader(
                String alternativeBodyHeader) {
            doSetProperty("alternativeBodyHeader", alternativeBodyHeader);
            return this;
        }
        /**
         * To use a custom AttachmentsContentTransferEncodingResolver to resolve
         * what content-type-encoding to use for attachments.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.mail.AttachmentsContentTransferEncodingResolver&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param attachmentsContentTransferEncodingResolver the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointBuilder attachmentsContentTransferEncodingResolver(
                org.apache.camel.component.mail.AttachmentsContentTransferEncodingResolver attachmentsContentTransferEncodingResolver) {
            doSetProperty("attachmentsContentTransferEncodingResolver", attachmentsContentTransferEncodingResolver);
            return this;
        }
        /**
         * To use a custom AttachmentsContentTransferEncodingResolver to resolve
         * what content-type-encoding to use for attachments.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.mail.AttachmentsContentTransferEncodingResolver&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param attachmentsContentTransferEncodingResolver the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointBuilder attachmentsContentTransferEncodingResolver(
                String attachmentsContentTransferEncodingResolver) {
            doSetProperty("attachmentsContentTransferEncodingResolver", attachmentsContentTransferEncodingResolver);
            return this;
        }
        /**
         * The authenticator for login. If set then the password and username
         * are ignored. Can be used for tokens which can expire and therefore
         * must be read dynamically.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.mail.MailAuthenticator&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param authenticator the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointBuilder authenticator(
                org.apache.camel.component.mail.MailAuthenticator authenticator) {
            doSetProperty("authenticator", authenticator);
            return this;
        }
        /**
         * The authenticator for login. If set then the password and username
         * are ignored. Can be used for tokens which can expire and therefore
         * must be read dynamically.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.mail.MailAuthenticator&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param authenticator the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointBuilder authenticator(String authenticator) {
            doSetProperty("authenticator", authenticator);
            return this;
        }
        /**
         * Sets the binding used to convert from a Camel message to and from a
         * Mail message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.mail.MailBinding&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param binding the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointBuilder binding(
                org.apache.camel.component.mail.MailBinding binding) {
            doSetProperty("binding", binding);
            return this;
        }
        /**
         * Sets the binding used to convert from a Camel message to and from a
         * Mail message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.mail.MailBinding&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param binding the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointBuilder binding(String binding) {
            doSetProperty("binding", binding);
            return this;
        }
        /**
         * The connection timeout in milliseconds.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: advanced
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointBuilder connectionTimeout(
                int connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * The connection timeout in milliseconds.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: advanced
         * 
         * @param connectionTimeout the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointBuilder connectionTimeout(
                String connectionTimeout) {
            doSetProperty("connectionTimeout", connectionTimeout);
            return this;
        }
        /**
         * The mail message content type. Use text/html for HTML mails.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: text/plain
         * Group: advanced
         * 
         * @param contentType the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointBuilder contentType(String contentType) {
            doSetProperty("contentType", contentType);
            return this;
        }
        /**
         * Resolver to determine Content-Type for file attachments.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.mail.ContentTypeResolver&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param contentTypeResolver the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointBuilder contentTypeResolver(
                org.apache.camel.component.mail.ContentTypeResolver contentTypeResolver) {
            doSetProperty("contentTypeResolver", contentTypeResolver);
            return this;
        }
        /**
         * Resolver to determine Content-Type for file attachments.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.mail.ContentTypeResolver&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param contentTypeResolver the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointBuilder contentTypeResolver(
                String contentTypeResolver) {
            doSetProperty("contentTypeResolver", contentTypeResolver);
            return this;
        }
        /**
         * Enable debug mode on the underlying mail framework. The SUN Mail
         * framework logs the debug messages to System.out by default.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param debugMode the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointBuilder debugMode(boolean debugMode) {
            doSetProperty("debugMode", debugMode);
            return this;
        }
        /**
         * Enable debug mode on the underlying mail framework. The SUN Mail
         * framework logs the debug messages to System.out by default.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param debugMode the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointBuilder debugMode(String debugMode) {
            doSetProperty("debugMode", debugMode);
            return this;
        }
        /**
         * To use a custom org.apache.camel.spi.HeaderFilterStrategy to filter
         * headers.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointBuilder headerFilterStrategy(
                org.apache.camel.spi.HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom org.apache.camel.spi.HeaderFilterStrategy to filter
         * headers.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Option to let Camel ignore unsupported charset in the local JVM when
         * sending mails. If the charset is unsupported then charset=XXX (where
         * XXX represents the unsupported charset) is removed from the
         * content-type and it relies on the platform default instead.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param ignoreUnsupportedCharset the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointBuilder ignoreUnsupportedCharset(
                boolean ignoreUnsupportedCharset) {
            doSetProperty("ignoreUnsupportedCharset", ignoreUnsupportedCharset);
            return this;
        }
        /**
         * Option to let Camel ignore unsupported charset in the local JVM when
         * sending mails. If the charset is unsupported then charset=XXX (where
         * XXX represents the unsupported charset) is removed from the
         * content-type and it relies on the platform default instead.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param ignoreUnsupportedCharset the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointBuilder ignoreUnsupportedCharset(
                String ignoreUnsupportedCharset) {
            doSetProperty("ignoreUnsupportedCharset", ignoreUnsupportedCharset);
            return this;
        }
        /**
         * Option to let Camel ignore unsupported charset in the local JVM when
         * sending mails. If the charset is unsupported then charset=XXX (where
         * XXX represents the unsupported charset) is removed from the
         * content-type and it relies on the platform default instead.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param ignoreUriScheme the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointBuilder ignoreUriScheme(
                boolean ignoreUriScheme) {
            doSetProperty("ignoreUriScheme", ignoreUriScheme);
            return this;
        }
        /**
         * Option to let Camel ignore unsupported charset in the local JVM when
         * sending mails. If the charset is unsupported then charset=XXX (where
         * XXX represents the unsupported charset) is removed from the
         * content-type and it relies on the platform default instead.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param ignoreUriScheme the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointBuilder ignoreUriScheme(
                String ignoreUriScheme) {
            doSetProperty("ignoreUriScheme", ignoreUriScheme);
            return this;
        }
        /**
         * Sets the java mail options. Will clear any default properties and
         * only use the properties provided for this method.
         * 
         * The option is a: &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param javaMailProperties the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointBuilder javaMailProperties(
                Properties javaMailProperties) {
            doSetProperty("javaMailProperties", javaMailProperties);
            return this;
        }
        /**
         * Sets the java mail options. Will clear any default properties and
         * only use the properties provided for this method.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Properties&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param javaMailProperties the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointBuilder javaMailProperties(
                String javaMailProperties) {
            doSetProperty("javaMailProperties", javaMailProperties);
            return this;
        }
        /**
         * Specifies the mail session that camel should use for all mail
         * interactions. Useful in scenarios where mail sessions are created and
         * managed by some other resource, such as a JavaEE container. When
         * using a custom mail session, then the hostname and port from the mail
         * session will be used (if configured on the session).
         * 
         * The option is a: &lt;code&gt;jakarta.mail.Session&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param session the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointBuilder session(jakarta.mail.Session session) {
            doSetProperty("session", session);
            return this;
        }
        /**
         * Specifies the mail session that camel should use for all mail
         * interactions. Useful in scenarios where mail sessions are created and
         * managed by some other resource, such as a JavaEE container. When
         * using a custom mail session, then the hostname and port from the mail
         * session will be used (if configured on the session).
         * 
         * The option will be converted to a
         * &lt;code&gt;jakarta.mail.Session&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param session the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointBuilder session(String session) {
            doSetProperty("session", session);
            return this;
        }
        /**
         * Whether to use disposition inline or attachment.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param useInlineAttachments the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointBuilder useInlineAttachments(
                boolean useInlineAttachments) {
            doSetProperty("useInlineAttachments", useInlineAttachments);
            return this;
        }
        /**
         * Whether to use disposition inline or attachment.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param useInlineAttachments the value to set
         * @return the dsl builder
         */
        default AdvancedMailEndpointBuilder useInlineAttachments(
                String useInlineAttachments) {
            doSetProperty("useInlineAttachments", useInlineAttachments);
            return this;
        }
    }

    public interface MailBuilders {
        /**
         * IMAP (camel-mail)
         * Send and receive emails using imap, pop3 and smtp protocols.
         * 
         * Category: mail
         * Since: 1.0
         * Maven coordinates: org.apache.camel:camel-mail
         * 
         * @return the dsl builder for the headers' name.
         */
        default MailHeaderNameBuilder imap() {
            return MailHeaderNameBuilder.INSTANCE;
        }
        /**
         * IMAP (camel-mail)
         * Send and receive emails using imap, pop3 and smtp protocols.
         * 
         * Category: mail
         * Since: 1.0
         * Maven coordinates: org.apache.camel:camel-mail
         * 
         * Syntax: <code>imap:host:port</code>
         * 
         * Path parameter: host (required)
         * The mail server host name
         * 
         * Path parameter: port
         * The port number of the mail server
         * 
         * @param path host:port
         * @return the dsl builder
         */
        default MailEndpointBuilder imap(String path) {
            return MailEndpointBuilderFactory.endpointBuilder("imap", path);
        }
        /**
         * IMAP (camel-mail)
         * Send and receive emails using imap, pop3 and smtp protocols.
         * 
         * Category: mail
         * Since: 1.0
         * Maven coordinates: org.apache.camel:camel-mail
         * 
         * Syntax: <code>imap:host:port</code>
         * 
         * Path parameter: host (required)
         * The mail server host name
         * 
         * Path parameter: port
         * The port number of the mail server
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path host:port
         * @return the dsl builder
         */
        default MailEndpointBuilder imap(String componentName, String path) {
            return MailEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
        /**
         * IMAPS (Secure) (camel-mail)
         * Send and receive emails using imap, pop3 and smtp protocols.
         * 
         * Category: mail
         * Since: 1.0
         * Maven coordinates: org.apache.camel:camel-mail
         * 
         * Syntax: <code>imaps:host:port</code>
         * 
         * Path parameter: host (required)
         * The mail server host name
         * 
         * Path parameter: port
         * The port number of the mail server
         * 
         * @param path host:port
         * @return the dsl builder
         */
        default MailEndpointBuilder imaps(String path) {
            return MailEndpointBuilderFactory.endpointBuilder("imaps", path);
        }
        /**
         * POP3 (camel-mail)
         * Send and receive emails using imap, pop3 and smtp protocols.
         * 
         * Category: mail
         * Since: 1.0
         * Maven coordinates: org.apache.camel:camel-mail
         * 
         * Syntax: <code>pop3:host:port</code>
         * 
         * Path parameter: host (required)
         * The mail server host name
         * 
         * Path parameter: port
         * The port number of the mail server
         * 
         * @param path host:port
         * @return the dsl builder
         */
        default MailEndpointBuilder pop3(String path) {
            return MailEndpointBuilderFactory.endpointBuilder("pop3", path);
        }
        /**
         * POP3S (camel-mail)
         * Send and receive emails using imap, pop3 and smtp protocols.
         * 
         * Category: mail
         * Since: 1.0
         * Maven coordinates: org.apache.camel:camel-mail
         * 
         * Syntax: <code>pop3s:host:port</code>
         * 
         * Path parameter: host (required)
         * The mail server host name
         * 
         * Path parameter: port
         * The port number of the mail server
         * 
         * @param path host:port
         * @return the dsl builder
         */
        default MailEndpointBuilder pop3s(String path) {
            return MailEndpointBuilderFactory.endpointBuilder("pop3s", path);
        }
        /**
         * SMTP (camel-mail)
         * Send and receive emails using imap, pop3 and smtp protocols.
         * 
         * Category: mail
         * Since: 1.0
         * Maven coordinates: org.apache.camel:camel-mail
         * 
         * Syntax: <code>smtp:host:port</code>
         * 
         * Path parameter: host (required)
         * The mail server host name
         * 
         * Path parameter: port
         * The port number of the mail server
         * 
         * @param path host:port
         * @return the dsl builder
         */
        default MailEndpointBuilder smtp(String path) {
            return MailEndpointBuilderFactory.endpointBuilder("smtp", path);
        }
        /**
         * SMTPS (camel-mail)
         * Send and receive emails using imap, pop3 and smtp protocols.
         * 
         * Category: mail
         * Since: 1.0
         * Maven coordinates: org.apache.camel:camel-mail
         * 
         * Syntax: <code>smtps:host:port</code>
         * 
         * Path parameter: host (required)
         * The mail server host name
         * 
         * Path parameter: port
         * The port number of the mail server
         * 
         * @param path host:port
         * @return the dsl builder
         */
        default MailEndpointBuilder smtps(String path) {
            return MailEndpointBuilderFactory.endpointBuilder("smtps", path);
        }
    }

    /**
     * The builder of headers' name for the IMAP component.
     */
    public static class MailHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final MailHeaderNameBuilder INSTANCE = new MailHeaderNameBuilder();

        /**
         * Subject.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code Subject}.
         */
        public String subject() {
            return "Subject";
        }

        /**
         * From.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code From}.
         */
        public String from() {
            return "From";
        }

        /**
         * To.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code To}.
         */
        public String to() {
            return "To";
        }

        /**
         * Cc.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code Cc}.
         */
        public String cc() {
            return "Cc";
        }

        /**
         * Bcc.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code Bcc}.
         */
        public String bcc() {
            return "Bcc";
        }

        /**
         * Reply to.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code Reply-To}.
         */
        public String replyTo() {
            return "Reply-To";
        }

        /**
         * The content type.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code contentType}.
         */
        public String contentType() {
            return "contentType";
        }

        /**
         * After processing a mail message, it can be copied to a mail folder
         * with the given name.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code copyTo}.
         */
        public String copyTo() {
            return "copyTo";
        }

        /**
         * After processing a mail message, it can be moved to a mail folder
         * with the given name.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code moveTo}.
         */
        public String moveTo() {
            return "moveTo";
        }

        /**
         * Deletes the messages after they have been processed.
         * 
         * The option is a: {@code boolean} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code delete}.
         */
        public String delete() {
            return "delete";
        }

        /**
         * The message ID.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code MailMessageId}.
         */
        public String mailMessageId() {
            return "MailMessageId";
        }
    }
    static MailEndpointBuilder endpointBuilder(String componentName, String path) {
        class MailEndpointBuilderImpl extends AbstractEndpointBuilder implements MailEndpointBuilder, AdvancedMailEndpointBuilder {
            public MailEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new MailEndpointBuilderImpl(path);
    }
}