
/*
 * Camel ApiMethod Enumeration generated by camel-api-component-maven-plugin
 */
package org.apache.camel.component.box.internal;

import java.lang.reflect.Method;
import java.util.List;

import org.apache.camel.component.box.api.BoxFoldersManager;

import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodArg;
import org.apache.camel.support.component.ApiMethodImpl;

import static org.apache.camel.support.component.ApiMethodArg.arg;

/**
 * Camel {@link ApiMethod} Enumeration for org.apache.camel.component.box.api.BoxFoldersManager
 */
public enum BoxFoldersManagerApiMethod implements ApiMethod {

    COPY_FOLDER(
        com.box.sdk.BoxFolder.class,
        "copyFolder",
        arg("folderId", String.class),
        arg("destinationFolderId", String.class),
        arg("newName", String.class)),

    CREATE_FOLDER(
        com.box.sdk.BoxFolder.class,
        "createFolder",
        arg("parentFolderId", String.class),
        arg("folderName", String.class)),

    CREATE_FOLDER_1(
        com.box.sdk.BoxFolder.class,
        "createFolder",
        arg("parentFolderId", String.class),
        arg("path", new String[0].getClass())),

    CREATE_FOLDER_SHARED_LINK(
        com.box.sdk.BoxSharedLink.class,
        "createFolderSharedLink",
        arg("folderId", String.class),
        arg("access", com.box.sdk.BoxSharedLink.Access.class),
        arg("unshareDate", java.util.Date.class),
        arg("permissions", com.box.sdk.BoxSharedLink.Permissions.class)),

    DELETE_FOLDER(
        void.class,
        "deleteFolder",
        arg("folderId", String.class)),

    GET_FOLDER(
        com.box.sdk.BoxFolder.class,
        "getFolder",
        arg("path", new String[0].getClass())),

    GET_FOLDER_INFO(
        com.box.sdk.BoxFolder.Info.class,
        "getFolderInfo",
        arg("folderId", String.class),
        arg("fields", new String[0].getClass())),

    GET_FOLDER_ITEMS(
        java.util.Collection.class,
        "getFolderItems",
        arg("folderId", String.class),
        arg("offset", Long.class),
        arg("limit", Long.class),
        arg("fields", new String[0].getClass())),

    GET_ROOT_FOLDER(
        com.box.sdk.BoxFolder.class,
        "getRootFolder"),

    MOVE_FOLDER(
        com.box.sdk.BoxFolder.class,
        "moveFolder",
        arg("folderId", String.class),
        arg("destinationFolderId", String.class),
        arg("newName", String.class)),

    RENAME_FOLDER(
        com.box.sdk.BoxFolder.class,
        "renameFolder",
        arg("folderId", String.class),
        arg("newFolderName", String.class)),

    UPDATE_FOLDER_INFO(
        com.box.sdk.BoxFolder.class,
        "updateFolderInfo",
        arg("folderId", String.class),
        arg("info", com.box.sdk.BoxFolder.Info.class));

    private final ApiMethod apiMethod;

    private BoxFoldersManagerApiMethod(Class<?> resultType, String name, ApiMethodArg... args) {
        this.apiMethod = new ApiMethodImpl(BoxFoldersManager.class, resultType, name, args);
    }

    @Override
    public String getName() { return apiMethod.getName(); }

    @Override
    public Class<?> getResultType() { return apiMethod.getResultType(); }

    @Override
    public List<String> getArgNames() { return apiMethod.getArgNames(); }

    @Override
    public List<Class<?>> getArgTypes() { return apiMethod.getArgTypes(); }

    @Override
    public Method getMethod() { return apiMethod.getMethod(); }
}
