/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.jms.issues;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Producer;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.jms.AbstractJMSTest;
import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertEquals;

public class RequestReplyWithProducerIssueTest extends AbstractJMSTest {

    @Test
    public void testInOut() throws Exception {
        Endpoint endpoint = context.getEndpoint("activemq:queue:RequestReplyWithProducerIssueTest");
        Producer producer = endpoint.createProducer();
        producer.start();

        Exchange exchange = endpoint.createExchange(ExchangePattern.InOut);
        exchange.getIn().setBody("Hello World");
        producer.process(exchange);
        producer.stop();

        assertEquals("Bye World", exchange.getMessage().getBody());
    }

    @Override
    protected String getComponentName() {
        return "activemq";
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder() {
            @Override
            public void configure() {
                from("activemq:queue:RequestReplyWithProducerIssueTest")
                        .process(exchange -> exchange.getMessage().setBody("Bye World"));
            }
        };
    }
}
