
/*
 * Camel EndpointConfiguration generated by camel-api-component-maven-plugin
 */
package org.apache.camel.component.google.mail;

import org.apache.camel.spi.ApiMethod;
import org.apache.camel.spi.ApiParam;
import org.apache.camel.spi.ApiParams;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

/**
 * Camel endpoint configuration for {@link com.google.api.services.gmail.Gmail.Users}.
 */
@ApiParams(apiName = "users", 
           description = "The users collection of methods",
           apiMethods = {@ApiMethod(methodName = "getProfile", description="Gets the current user's Gmail profile", signatures={"com.google.api.services.gmail.Gmail$Users$GetProfile getProfile(String userId)"}), @ApiMethod(methodName = "stop", description="Stop receiving push notifications for the given user mailbox", signatures={"com.google.api.services.gmail.Gmail$Users$Stop stop(String userId)"}), @ApiMethod(methodName = "watch", description="Set up or update a push notification watch on the given user mailbox", signatures={"com.google.api.services.gmail.Gmail$Users$Watch watch(String userId, com.google.api.services.gmail.model.WatchRequest content)"})}, aliases = {})
@UriParams
@Configurer(extended = true)
public final class GmailUsersEndpointConfiguration extends GoogleMailConfiguration {
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "watch", description="The com.google.api.services.gmail.model.WatchRequest")})
    private com.google.api.services.gmail.model.WatchRequest content;
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "getProfile", description="The user's email address. The special value me can be used to indicate the authenticated user. default: me"), @ApiMethod(methodName = "stop", description="The user's email address. The special value me can be used to indicate the authenticated user. default: me"), @ApiMethod(methodName = "watch", description="The user's email address. The special value me can be used to indicate the authenticated user. default: me")})
    private String userId;

    public com.google.api.services.gmail.model.WatchRequest getContent() {
        return content;
    }

    public void setContent(com.google.api.services.gmail.model.WatchRequest content) {
        this.content = content;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }
}
