/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws.kinesis.KinesisComponent;

/**
 * Consume and produce records from AWS Kinesis Streams.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface AwsKinesisComponentBuilderFactory {

    /**
     * AWS Kinesis (camel-aws-kinesis)
     * Consume and produce records from AWS Kinesis Streams.
     * 
     * Category: cloud,messaging
     * Since: 2.17
     * Maven coordinates: org.apache.camel:camel-aws-kinesis
     * 
     * @return the dsl builder
     */
    @Deprecated
    static AwsKinesisComponentBuilder awsKinesis() {
        return new AwsKinesisComponentBuilderImpl();
    }

    /**
     * Builder for the AWS Kinesis component.
     */
    interface AwsKinesisComponentBuilder
            extends
                ComponentBuilder<KinesisComponent> {
        /**
         * Amazon Kinesis client to use for all requests for this endpoint.
         * 
         * The option is a:
         * &lt;code&gt;com.amazonaws.services.kinesis.AmazonKinesis&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param amazonKinesisClient the value to set
         * @return the dsl builder
         */
        default AwsKinesisComponentBuilder amazonKinesisClient(
                com.amazonaws.services.kinesis.AmazonKinesis amazonKinesisClient) {
            doSetProperty("amazonKinesisClient", amazonKinesisClient);
            return this;
        }
        /**
         * Setting the autoDiscoverClient mechanism, if true, the component will
         * look for a client instance in the registry automatically otherwise it
         * will skip that checking.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param autoDiscoverClient the value to set
         * @return the dsl builder
         */
        default AwsKinesisComponentBuilder autoDiscoverClient(
                boolean autoDiscoverClient) {
            doSetProperty("autoDiscoverClient", autoDiscoverClient);
            return this;
        }
        /**
         * The component configuration.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.aws.kinesis.KinesisConfiguration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default AwsKinesisComponentBuilder configuration(
                org.apache.camel.component.aws.kinesis.KinesisConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
        /**
         * To define a proxy host when instantiating the Kinesis client.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default AwsKinesisComponentBuilder proxyHost(java.lang.String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * To define a proxy port when instantiating the Kinesis client.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default AwsKinesisComponentBuilder proxyPort(java.lang.Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the Kinesis client.
         * 
         * The option is a: &lt;code&gt;com.amazonaws.Protocol&lt;/code&gt;
         * type.
         * 
         * Default: HTTPS
         * Group: common
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default AwsKinesisComponentBuilder proxyProtocol(
                com.amazonaws.Protocol proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * The region in which Kinesis client needs to work. When using this
         * parameter, the configuration will expect the capitalized name of the
         * region (for example AP_EAST_1)You'll need to use the name
         * Regions.EU_WEST_1.name().
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param region the value to set
         * @return the dsl builder
         */
        default AwsKinesisComponentBuilder region(java.lang.String region) {
            doSetProperty("region", region);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AwsKinesisComponentBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Defines where in the Kinesis stream to start getting records.
         * 
         * The option is a:
         * &lt;code&gt;com.amazonaws.services.kinesis.model.ShardIteratorType&lt;/code&gt; type.
         * 
         * Default: TRIM_HORIZON
         * Group: consumer
         * 
         * @param iteratorType the value to set
         * @return the dsl builder
         */
        default AwsKinesisComponentBuilder iteratorType(
                com.amazonaws.services.kinesis.model.ShardIteratorType iteratorType) {
            doSetProperty("iteratorType", iteratorType);
            return this;
        }
        /**
         * Maximum number of records that will be fetched in each poll.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: consumer
         * 
         * @param maxResultsPerRequest the value to set
         * @return the dsl builder
         */
        default AwsKinesisComponentBuilder maxResultsPerRequest(
                int maxResultsPerRequest) {
            doSetProperty("maxResultsPerRequest", maxResultsPerRequest);
            return this;
        }
        /**
         * The sequence number to start polling from. Required if iteratorType
         * is set to AFTER_SEQUENCE_NUMBER or AT_SEQUENCE_NUMBER.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param sequenceNumber the value to set
         * @return the dsl builder
         */
        default AwsKinesisComponentBuilder sequenceNumber(
                java.lang.String sequenceNumber) {
            doSetProperty("sequenceNumber", sequenceNumber);
            return this;
        }
        /**
         * Define what will be the behavior in case of shard closed. Possible
         * value are ignore, silent and fail. In case of ignore a message will
         * be logged and the consumer will restart from the beginning,in case of
         * silent there will be no logging and the consumer will start from the
         * beginning,in case of fail a ReachedClosedStateException will be
         * raised.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.aws.kinesis.KinesisShardClosedStrategyEnum&lt;/code&gt; type.
         * 
         * Default: ignore
         * Group: consumer
         * 
         * @param shardClosed the value to set
         * @return the dsl builder
         */
        default AwsKinesisComponentBuilder shardClosed(
                org.apache.camel.component.aws.kinesis.KinesisShardClosedStrategyEnum shardClosed) {
            doSetProperty("shardClosed", shardClosed);
            return this;
        }
        /**
         * Defines which shardId in the Kinesis stream to get records from.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param shardId the value to set
         * @return the dsl builder
         */
        default AwsKinesisComponentBuilder shardId(java.lang.String shardId) {
            doSetProperty("shardId", shardId);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AwsKinesisComponentBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default AwsKinesisComponentBuilder autowiredEnabled(
                boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default AwsKinesisComponentBuilder accessKey(java.lang.String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param secretKey the value to set
         * @return the dsl builder
         */
        default AwsKinesisComponentBuilder secretKey(java.lang.String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
    }

    class AwsKinesisComponentBuilderImpl
            extends
                AbstractComponentBuilder<KinesisComponent>
            implements
                AwsKinesisComponentBuilder {
        @Override
        protected KinesisComponent buildConcreteComponent() {
            return new KinesisComponent();
        }
        private org.apache.camel.component.aws.kinesis.KinesisConfiguration getOrCreateConfiguration(
                org.apache.camel.component.aws.kinesis.KinesisComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.aws.kinesis.KinesisConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "amazonKinesisClient": getOrCreateConfiguration((KinesisComponent) component).setAmazonKinesisClient((com.amazonaws.services.kinesis.AmazonKinesis) value); return true;
            case "autoDiscoverClient": getOrCreateConfiguration((KinesisComponent) component).setAutoDiscoverClient((boolean) value); return true;
            case "configuration": ((KinesisComponent) component).setConfiguration((org.apache.camel.component.aws.kinesis.KinesisConfiguration) value); return true;
            case "proxyHost": getOrCreateConfiguration((KinesisComponent) component).setProxyHost((java.lang.String) value); return true;
            case "proxyPort": getOrCreateConfiguration((KinesisComponent) component).setProxyPort((java.lang.Integer) value); return true;
            case "proxyProtocol": getOrCreateConfiguration((KinesisComponent) component).setProxyProtocol((com.amazonaws.Protocol) value); return true;
            case "region": getOrCreateConfiguration((KinesisComponent) component).setRegion((java.lang.String) value); return true;
            case "bridgeErrorHandler": ((KinesisComponent) component).setBridgeErrorHandler((boolean) value); return true;
            case "iteratorType": getOrCreateConfiguration((KinesisComponent) component).setIteratorType((com.amazonaws.services.kinesis.model.ShardIteratorType) value); return true;
            case "maxResultsPerRequest": getOrCreateConfiguration((KinesisComponent) component).setMaxResultsPerRequest((int) value); return true;
            case "sequenceNumber": getOrCreateConfiguration((KinesisComponent) component).setSequenceNumber((java.lang.String) value); return true;
            case "shardClosed": getOrCreateConfiguration((KinesisComponent) component).setShardClosed((org.apache.camel.component.aws.kinesis.KinesisShardClosedStrategyEnum) value); return true;
            case "shardId": getOrCreateConfiguration((KinesisComponent) component).setShardId((java.lang.String) value); return true;
            case "lazyStartProducer": ((KinesisComponent) component).setLazyStartProducer((boolean) value); return true;
            case "autowiredEnabled": ((KinesisComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "accessKey": getOrCreateConfiguration((KinesisComponent) component).setAccessKey((java.lang.String) value); return true;
            case "secretKey": getOrCreateConfiguration((KinesisComponent) component).setSecretKey((java.lang.String) value); return true;
            default: return false;
            }
        }
    }
}