/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * Manage workflows in the AWS Simple Workflow service.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface SWFEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the AWS Simple Workflow (SWF)
     * component.
     */
    public interface SWFEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedSWFEndpointConsumerBuilder advanced() {
            return (AdvancedSWFEndpointConsumerBuilder) this;
        }
        /**
         * To use the given AmazonSimpleWorkflowClient as client.
         * 
         * The option is a:
         * &lt;code&gt;com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflowClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param amazonSWClient the value to set
         * @return the dsl builder
         */
        default SWFEndpointConsumerBuilder amazonSWClient(Object amazonSWClient) {
            doSetProperty("amazonSWClient", amazonSWClient);
            return this;
        }
        /**
         * To use the given AmazonSimpleWorkflowClient as client.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflowClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param amazonSWClient the value to set
         * @return the dsl builder
         */
        default SWFEndpointConsumerBuilder amazonSWClient(String amazonSWClient) {
            doSetProperty("amazonSWClient", amazonSWClient);
            return this;
        }
        /**
         * An instance of
         * com.amazonaws.services.simpleworkflow.flow.DataConverter to use for
         * serializing/deserializing the data.
         * 
         * The option is a:
         * &lt;code&gt;com.amazonaws.services.simpleworkflow.flow.DataConverter&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataConverter the value to set
         * @return the dsl builder
         */
        default SWFEndpointConsumerBuilder dataConverter(Object dataConverter) {
            doSetProperty("dataConverter", dataConverter);
            return this;
        }
        /**
         * An instance of
         * com.amazonaws.services.simpleworkflow.flow.DataConverter to use for
         * serializing/deserializing the data.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.amazonaws.services.simpleworkflow.flow.DataConverter&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataConverter the value to set
         * @return the dsl builder
         */
        default SWFEndpointConsumerBuilder dataConverter(String dataConverter) {
            doSetProperty("dataConverter", dataConverter);
            return this;
        }
        /**
         * The workflow domain to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param domainName the value to set
         * @return the dsl builder
         */
        default SWFEndpointConsumerBuilder domainName(String domainName) {
            doSetProperty("domainName", domainName);
            return this;
        }
        /**
         * The workflow or activity event name to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param eventName the value to set
         * @return the dsl builder
         */
        default SWFEndpointConsumerBuilder eventName(String eventName) {
            doSetProperty("eventName", eventName);
            return this;
        }
        /**
         * Amazon AWS Region. When using this parameter, the configuration will
         * expect the capitalized name of the region (for example AP_EAST_1)
         * You'll need to use the name Regions.EU_WEST_1.name().
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param region the value to set
         * @return the dsl builder
         */
        default SWFEndpointConsumerBuilder region(String region) {
            doSetProperty("region", region);
            return this;
        }
        /**
         * The workflow or activity event version to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param version the value to set
         * @return the dsl builder
         */
        default SWFEndpointConsumerBuilder version(String version) {
            doSetProperty("version", version);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default SWFEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default SWFEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * The list name to consume activities from.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: activity
         * 
         * @param activityList the value to set
         * @return the dsl builder
         */
        default SWFEndpointConsumerBuilder activityList(String activityList) {
            doSetProperty("activityList", activityList);
            return this;
        }
        /**
         * Maximum number of threads in work pool for activity.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: activity
         * 
         * @param activityThreadPoolSize the value to set
         * @return the dsl builder
         */
        default SWFEndpointConsumerBuilder activityThreadPoolSize(
                int activityThreadPoolSize) {
            doSetProperty("activityThreadPoolSize", activityThreadPoolSize);
            return this;
        }
        /**
         * Maximum number of threads in work pool for activity.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 100
         * Group: activity
         * 
         * @param activityThreadPoolSize the value to set
         * @return the dsl builder
         */
        default SWFEndpointConsumerBuilder activityThreadPoolSize(
                String activityThreadPoolSize) {
            doSetProperty("activityThreadPoolSize", activityThreadPoolSize);
            return this;
        }
        /**
         * Activity execution options.
         * 
         * The option is a:
         * &lt;code&gt;com.amazonaws.services.simpleworkflow.flow.worker.ActivityTypeExecutionOptions&lt;/code&gt; type.
         * 
         * Group: activity
         * 
         * @param activityTypeExecutionOptions the value to set
         * @return the dsl builder
         */
        default SWFEndpointConsumerBuilder activityTypeExecutionOptions(
                Object activityTypeExecutionOptions) {
            doSetProperty("activityTypeExecutionOptions", activityTypeExecutionOptions);
            return this;
        }
        /**
         * Activity execution options.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.amazonaws.services.simpleworkflow.flow.worker.ActivityTypeExecutionOptions&lt;/code&gt; type.
         * 
         * Group: activity
         * 
         * @param activityTypeExecutionOptions the value to set
         * @return the dsl builder
         */
        default SWFEndpointConsumerBuilder activityTypeExecutionOptions(
                String activityTypeExecutionOptions) {
            doSetProperty("activityTypeExecutionOptions", activityTypeExecutionOptions);
            return this;
        }
        /**
         * Activity registration options.
         * 
         * The option is a:
         * &lt;code&gt;com.amazonaws.services.simpleworkflow.flow.worker.ActivityTypeRegistrationOptions&lt;/code&gt; type.
         * 
         * Group: activity
         * 
         * @param activityTypeRegistrationOptions the value to set
         * @return the dsl builder
         */
        default SWFEndpointConsumerBuilder activityTypeRegistrationOptions(
                Object activityTypeRegistrationOptions) {
            doSetProperty("activityTypeRegistrationOptions", activityTypeRegistrationOptions);
            return this;
        }
        /**
         * Activity registration options.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.amazonaws.services.simpleworkflow.flow.worker.ActivityTypeRegistrationOptions&lt;/code&gt; type.
         * 
         * Group: activity
         * 
         * @param activityTypeRegistrationOptions the value to set
         * @return the dsl builder
         */
        default SWFEndpointConsumerBuilder activityTypeRegistrationOptions(
                String activityTypeRegistrationOptions) {
            doSetProperty("activityTypeRegistrationOptions", activityTypeRegistrationOptions);
            return this;
        }
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default SWFEndpointConsumerBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param secretKey the value to set
         * @return the dsl builder
         */
        default SWFEndpointConsumerBuilder secretKey(String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
        /**
         * The list name to consume workflows from.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: workflow
         * 
         * @param workflowList the value to set
         * @return the dsl builder
         */
        default SWFEndpointConsumerBuilder workflowList(String workflowList) {
            doSetProperty("workflowList", workflowList);
            return this;
        }
        /**
         * Workflow registration options.
         * 
         * The option is a:
         * &lt;code&gt;com.amazonaws.services.simpleworkflow.flow.WorkflowTypeRegistrationOptions&lt;/code&gt; type.
         * 
         * Group: workflow
         * 
         * @param workflowTypeRegistrationOptions the value to set
         * @return the dsl builder
         */
        default SWFEndpointConsumerBuilder workflowTypeRegistrationOptions(
                Object workflowTypeRegistrationOptions) {
            doSetProperty("workflowTypeRegistrationOptions", workflowTypeRegistrationOptions);
            return this;
        }
        /**
         * Workflow registration options.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.amazonaws.services.simpleworkflow.flow.WorkflowTypeRegistrationOptions&lt;/code&gt; type.
         * 
         * Group: workflow
         * 
         * @param workflowTypeRegistrationOptions the value to set
         * @return the dsl builder
         */
        default SWFEndpointConsumerBuilder workflowTypeRegistrationOptions(
                String workflowTypeRegistrationOptions) {
            doSetProperty("workflowTypeRegistrationOptions", workflowTypeRegistrationOptions);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the AWS Simple Workflow (SWF)
     * component.
     */
    public interface AdvancedSWFEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default SWFEndpointConsumerBuilder basic() {
            return (SWFEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSWFEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedSWFEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedSWFEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedSWFEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * To configure the ClientConfiguration using the key/values from the
         * Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * clientConfigurationParameters(String, Object) method to add a value
         * (call the method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedSWFEndpointConsumerBuilder clientConfigurationParameters(
                String key,
                Object value) {
            doSetMultiValueProperty("clientConfigurationParameters", "clientConfiguration." + key, value);
            return this;
        }
        /**
         * To configure the ClientConfiguration using the key/values from the
         * Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * clientConfigurationParameters(String, Object) method to add a value
         * (call the method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedSWFEndpointConsumerBuilder clientConfigurationParameters(
                Map values) {
            doSetMultiValueProperties("clientConfigurationParameters", "clientConfiguration.", values);
            return this;
        }
        /**
         * To configure the StartWorkflowOptions using the key/values from the
         * Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * startWorkflowOptionsParameters(String, Object) method to add a value
         * (call the method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedSWFEndpointConsumerBuilder startWorkflowOptionsParameters(
                String key,
                Object value) {
            doSetMultiValueProperty("startWorkflowOptionsParameters", "startWorkflowOptions." + key, value);
            return this;
        }
        /**
         * To configure the StartWorkflowOptions using the key/values from the
         * Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * startWorkflowOptionsParameters(String, Object) method to add a value
         * (call the method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedSWFEndpointConsumerBuilder startWorkflowOptionsParameters(
                Map values) {
            doSetMultiValueProperties("startWorkflowOptionsParameters", "startWorkflowOptions.", values);
            return this;
        }
        /**
         * To configure the AmazonSimpleWorkflowClient using the key/values from
         * the Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * sWClientParameters(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedSWFEndpointConsumerBuilder sWClientParameters(
                String key,
                Object value) {
            doSetMultiValueProperty("sWClientParameters", "sWClient." + key, value);
            return this;
        }
        /**
         * To configure the AmazonSimpleWorkflowClient using the key/values from
         * the Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * sWClientParameters(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedSWFEndpointConsumerBuilder sWClientParameters(Map values) {
            doSetMultiValueProperties("sWClientParameters", "sWClient.", values);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedSWFEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedSWFEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the AWS Simple Workflow (SWF)
     * component.
     */
    public interface SWFEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedSWFEndpointProducerBuilder advanced() {
            return (AdvancedSWFEndpointProducerBuilder) this;
        }
        /**
         * To use the given AmazonSimpleWorkflowClient as client.
         * 
         * The option is a:
         * &lt;code&gt;com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflowClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param amazonSWClient the value to set
         * @return the dsl builder
         */
        default SWFEndpointProducerBuilder amazonSWClient(Object amazonSWClient) {
            doSetProperty("amazonSWClient", amazonSWClient);
            return this;
        }
        /**
         * To use the given AmazonSimpleWorkflowClient as client.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflowClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param amazonSWClient the value to set
         * @return the dsl builder
         */
        default SWFEndpointProducerBuilder amazonSWClient(String amazonSWClient) {
            doSetProperty("amazonSWClient", amazonSWClient);
            return this;
        }
        /**
         * An instance of
         * com.amazonaws.services.simpleworkflow.flow.DataConverter to use for
         * serializing/deserializing the data.
         * 
         * The option is a:
         * &lt;code&gt;com.amazonaws.services.simpleworkflow.flow.DataConverter&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataConverter the value to set
         * @return the dsl builder
         */
        default SWFEndpointProducerBuilder dataConverter(Object dataConverter) {
            doSetProperty("dataConverter", dataConverter);
            return this;
        }
        /**
         * An instance of
         * com.amazonaws.services.simpleworkflow.flow.DataConverter to use for
         * serializing/deserializing the data.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.amazonaws.services.simpleworkflow.flow.DataConverter&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataConverter the value to set
         * @return the dsl builder
         */
        default SWFEndpointProducerBuilder dataConverter(String dataConverter) {
            doSetProperty("dataConverter", dataConverter);
            return this;
        }
        /**
         * The workflow domain to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param domainName the value to set
         * @return the dsl builder
         */
        default SWFEndpointProducerBuilder domainName(String domainName) {
            doSetProperty("domainName", domainName);
            return this;
        }
        /**
         * The workflow or activity event name to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param eventName the value to set
         * @return the dsl builder
         */
        default SWFEndpointProducerBuilder eventName(String eventName) {
            doSetProperty("eventName", eventName);
            return this;
        }
        /**
         * Amazon AWS Region. When using this parameter, the configuration will
         * expect the capitalized name of the region (for example AP_EAST_1)
         * You'll need to use the name Regions.EU_WEST_1.name().
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param region the value to set
         * @return the dsl builder
         */
        default SWFEndpointProducerBuilder region(String region) {
            doSetProperty("region", region);
            return this;
        }
        /**
         * The workflow or activity event version to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param version the value to set
         * @return the dsl builder
         */
        default SWFEndpointProducerBuilder version(String version) {
            doSetProperty("version", version);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default SWFEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default SWFEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Activity scheduling options.
         * 
         * The option is a:
         * &lt;code&gt;com.amazonaws.services.simpleworkflow.flow.ActivitySchedulingOptions&lt;/code&gt; type.
         * 
         * Group: activity
         * 
         * @param activitySchedulingOptions the value to set
         * @return the dsl builder
         */
        default SWFEndpointProducerBuilder activitySchedulingOptions(
                Object activitySchedulingOptions) {
            doSetProperty("activitySchedulingOptions", activitySchedulingOptions);
            return this;
        }
        /**
         * Activity scheduling options.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.amazonaws.services.simpleworkflow.flow.ActivitySchedulingOptions&lt;/code&gt; type.
         * 
         * Group: activity
         * 
         * @param activitySchedulingOptions the value to set
         * @return the dsl builder
         */
        default SWFEndpointProducerBuilder activitySchedulingOptions(
                String activitySchedulingOptions) {
            doSetProperty("activitySchedulingOptions", activitySchedulingOptions);
            return this;
        }
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default SWFEndpointProducerBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param secretKey the value to set
         * @return the dsl builder
         */
        default SWFEndpointProducerBuilder secretKey(String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
        /**
         * The policy to use on child workflows when terminating a workflow.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: workflow
         * 
         * @param childPolicy the value to set
         * @return the dsl builder
         */
        default SWFEndpointProducerBuilder childPolicy(String childPolicy) {
            doSetProperty("childPolicy", childPolicy);
            return this;
        }
        /**
         * Set the execution start to close timeout.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: 3600
         * Group: workflow
         * 
         * @param executionStartToCloseTimeout the value to set
         * @return the dsl builder
         */
        default SWFEndpointProducerBuilder executionStartToCloseTimeout(
                String executionStartToCloseTimeout) {
            doSetProperty("executionStartToCloseTimeout", executionStartToCloseTimeout);
            return this;
        }
        /**
         * Workflow operation.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: START
         * Group: workflow
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default SWFEndpointProducerBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The name of the signal to send to the workflow.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: workflow
         * 
         * @param signalName the value to set
         * @return the dsl builder
         */
        default SWFEndpointProducerBuilder signalName(String signalName) {
            doSetProperty("signalName", signalName);
            return this;
        }
        /**
         * The type of the result when a workflow state is queried.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: workflow
         * 
         * @param stateResultType the value to set
         * @return the dsl builder
         */
        default SWFEndpointProducerBuilder stateResultType(
                String stateResultType) {
            doSetProperty("stateResultType", stateResultType);
            return this;
        }
        /**
         * Set the task start to close timeout.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: 600
         * Group: workflow
         * 
         * @param taskStartToCloseTimeout the value to set
         * @return the dsl builder
         */
        default SWFEndpointProducerBuilder taskStartToCloseTimeout(
                String taskStartToCloseTimeout) {
            doSetProperty("taskStartToCloseTimeout", taskStartToCloseTimeout);
            return this;
        }
        /**
         * Details for terminating a workflow.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: workflow
         * 
         * @param terminationDetails the value to set
         * @return the dsl builder
         */
        default SWFEndpointProducerBuilder terminationDetails(
                String terminationDetails) {
            doSetProperty("terminationDetails", terminationDetails);
            return this;
        }
        /**
         * The reason for terminating a workflow.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: workflow
         * 
         * @param terminationReason the value to set
         * @return the dsl builder
         */
        default SWFEndpointProducerBuilder terminationReason(
                String terminationReason) {
            doSetProperty("terminationReason", terminationReason);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the AWS Simple Workflow (SWF)
     * component.
     */
    public interface AdvancedSWFEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default SWFEndpointProducerBuilder basic() {
            return (SWFEndpointProducerBuilder) this;
        }
        /**
         * To configure the ClientConfiguration using the key/values from the
         * Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * clientConfigurationParameters(String, Object) method to add a value
         * (call the method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedSWFEndpointProducerBuilder clientConfigurationParameters(
                String key,
                Object value) {
            doSetMultiValueProperty("clientConfigurationParameters", "clientConfiguration." + key, value);
            return this;
        }
        /**
         * To configure the ClientConfiguration using the key/values from the
         * Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * clientConfigurationParameters(String, Object) method to add a value
         * (call the method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedSWFEndpointProducerBuilder clientConfigurationParameters(
                Map values) {
            doSetMultiValueProperties("clientConfigurationParameters", "clientConfiguration.", values);
            return this;
        }
        /**
         * To configure the StartWorkflowOptions using the key/values from the
         * Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * startWorkflowOptionsParameters(String, Object) method to add a value
         * (call the method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedSWFEndpointProducerBuilder startWorkflowOptionsParameters(
                String key,
                Object value) {
            doSetMultiValueProperty("startWorkflowOptionsParameters", "startWorkflowOptions." + key, value);
            return this;
        }
        /**
         * To configure the StartWorkflowOptions using the key/values from the
         * Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * startWorkflowOptionsParameters(String, Object) method to add a value
         * (call the method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedSWFEndpointProducerBuilder startWorkflowOptionsParameters(
                Map values) {
            doSetMultiValueProperties("startWorkflowOptionsParameters", "startWorkflowOptions.", values);
            return this;
        }
        /**
         * To configure the AmazonSimpleWorkflowClient using the key/values from
         * the Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * sWClientParameters(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedSWFEndpointProducerBuilder sWClientParameters(
                String key,
                Object value) {
            doSetMultiValueProperty("sWClientParameters", "sWClient." + key, value);
            return this;
        }
        /**
         * To configure the AmazonSimpleWorkflowClient using the key/values from
         * the Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * sWClientParameters(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedSWFEndpointProducerBuilder sWClientParameters(Map values) {
            doSetMultiValueProperties("sWClientParameters", "sWClient.", values);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedSWFEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedSWFEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the AWS Simple Workflow (SWF) component.
     */
    public interface SWFEndpointBuilder
            extends
                SWFEndpointConsumerBuilder,
                SWFEndpointProducerBuilder {
        default AdvancedSWFEndpointBuilder advanced() {
            return (AdvancedSWFEndpointBuilder) this;
        }
        /**
         * To use the given AmazonSimpleWorkflowClient as client.
         * 
         * The option is a:
         * &lt;code&gt;com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflowClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param amazonSWClient the value to set
         * @return the dsl builder
         */
        default SWFEndpointBuilder amazonSWClient(Object amazonSWClient) {
            doSetProperty("amazonSWClient", amazonSWClient);
            return this;
        }
        /**
         * To use the given AmazonSimpleWorkflowClient as client.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflowClient&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param amazonSWClient the value to set
         * @return the dsl builder
         */
        default SWFEndpointBuilder amazonSWClient(String amazonSWClient) {
            doSetProperty("amazonSWClient", amazonSWClient);
            return this;
        }
        /**
         * An instance of
         * com.amazonaws.services.simpleworkflow.flow.DataConverter to use for
         * serializing/deserializing the data.
         * 
         * The option is a:
         * &lt;code&gt;com.amazonaws.services.simpleworkflow.flow.DataConverter&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataConverter the value to set
         * @return the dsl builder
         */
        default SWFEndpointBuilder dataConverter(Object dataConverter) {
            doSetProperty("dataConverter", dataConverter);
            return this;
        }
        /**
         * An instance of
         * com.amazonaws.services.simpleworkflow.flow.DataConverter to use for
         * serializing/deserializing the data.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.amazonaws.services.simpleworkflow.flow.DataConverter&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataConverter the value to set
         * @return the dsl builder
         */
        default SWFEndpointBuilder dataConverter(String dataConverter) {
            doSetProperty("dataConverter", dataConverter);
            return this;
        }
        /**
         * The workflow domain to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param domainName the value to set
         * @return the dsl builder
         */
        default SWFEndpointBuilder domainName(String domainName) {
            doSetProperty("domainName", domainName);
            return this;
        }
        /**
         * The workflow or activity event name to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param eventName the value to set
         * @return the dsl builder
         */
        default SWFEndpointBuilder eventName(String eventName) {
            doSetProperty("eventName", eventName);
            return this;
        }
        /**
         * Amazon AWS Region. When using this parameter, the configuration will
         * expect the capitalized name of the region (for example AP_EAST_1)
         * You'll need to use the name Regions.EU_WEST_1.name().
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param region the value to set
         * @return the dsl builder
         */
        default SWFEndpointBuilder region(String region) {
            doSetProperty("region", region);
            return this;
        }
        /**
         * The workflow or activity event version to use.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param version the value to set
         * @return the dsl builder
         */
        default SWFEndpointBuilder version(String version) {
            doSetProperty("version", version);
            return this;
        }
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default SWFEndpointBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param secretKey the value to set
         * @return the dsl builder
         */
        default SWFEndpointBuilder secretKey(String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the AWS Simple Workflow (SWF)
     * component.
     */
    public interface AdvancedSWFEndpointBuilder
            extends
                AdvancedSWFEndpointConsumerBuilder,
                AdvancedSWFEndpointProducerBuilder {
        default SWFEndpointBuilder basic() {
            return (SWFEndpointBuilder) this;
        }
        /**
         * To configure the ClientConfiguration using the key/values from the
         * Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * clientConfigurationParameters(String, Object) method to add a value
         * (call the method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedSWFEndpointBuilder clientConfigurationParameters(
                String key,
                Object value) {
            doSetMultiValueProperty("clientConfigurationParameters", "clientConfiguration." + key, value);
            return this;
        }
        /**
         * To configure the ClientConfiguration using the key/values from the
         * Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * clientConfigurationParameters(String, Object) method to add a value
         * (call the method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedSWFEndpointBuilder clientConfigurationParameters(
                Map values) {
            doSetMultiValueProperties("clientConfigurationParameters", "clientConfiguration.", values);
            return this;
        }
        /**
         * To configure the StartWorkflowOptions using the key/values from the
         * Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * startWorkflowOptionsParameters(String, Object) method to add a value
         * (call the method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedSWFEndpointBuilder startWorkflowOptionsParameters(
                String key,
                Object value) {
            doSetMultiValueProperty("startWorkflowOptionsParameters", "startWorkflowOptions." + key, value);
            return this;
        }
        /**
         * To configure the StartWorkflowOptions using the key/values from the
         * Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * startWorkflowOptionsParameters(String, Object) method to add a value
         * (call the method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedSWFEndpointBuilder startWorkflowOptionsParameters(
                Map values) {
            doSetMultiValueProperties("startWorkflowOptionsParameters", "startWorkflowOptions.", values);
            return this;
        }
        /**
         * To configure the AmazonSimpleWorkflowClient using the key/values from
         * the Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * sWClientParameters(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedSWFEndpointBuilder sWClientParameters(
                String key,
                Object value) {
            doSetMultiValueProperty("sWClientParameters", "sWClient." + key, value);
            return this;
        }
        /**
         * To configure the AmazonSimpleWorkflowClient using the key/values from
         * the Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * sWClientParameters(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedSWFEndpointBuilder sWClientParameters(Map values) {
            doSetMultiValueProperties("sWClientParameters", "sWClient.", values);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedSWFEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedSWFEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    public interface SWFBuilders {
        /**
         * AWS Simple Workflow (SWF) (camel-aws-swf)
         * Manage workflows in the AWS Simple Workflow service.
         * 
         * Category: cloud,workflow
         * Since: 2.13
         * Maven coordinates: org.apache.camel:camel-aws-swf
         * 
         * Syntax: <code>aws-swf:type</code>
         * 
         * Path parameter: type (required)
         * Activity or workflow
         * There are 2 enums and the value can be one of: activity, workflow
         * 
         * @param path type
         * @return the dsl builder
         */
        default SWFEndpointBuilder awsSwf(String path) {
            return SWFEndpointBuilderFactory.endpointBuilder("aws-swf", path);
        }
        /**
         * AWS Simple Workflow (SWF) (camel-aws-swf)
         * Manage workflows in the AWS Simple Workflow service.
         * 
         * Category: cloud,workflow
         * Since: 2.13
         * Maven coordinates: org.apache.camel:camel-aws-swf
         * 
         * Syntax: <code>aws-swf:type</code>
         * 
         * Path parameter: type (required)
         * Activity or workflow
         * There are 2 enums and the value can be one of: activity, workflow
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path type
         * @return the dsl builder
         */
        default SWFEndpointBuilder awsSwf(String componentName, String path) {
            return SWFEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static SWFEndpointBuilder endpointBuilder(String componentName, String path) {
        class SWFEndpointBuilderImpl extends AbstractEndpointBuilder implements SWFEndpointBuilder, AdvancedSWFEndpointBuilder {
            public SWFEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new SWFEndpointBuilderImpl(path);
    }
}