/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Set;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * Connect to OPC UA servers using the binary protocol for acquiring telemetry
 * data.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface MiloClientEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the OPC UA Client component.
     */
    public interface MiloClientEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedMiloClientEndpointConsumerBuilder advanced() {
            return (AdvancedMiloClientEndpointConsumerBuilder) this;
        }
        /**
         * A virtual client id to force the creation of a new connection
         * instance.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param clientId the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointConsumerBuilder clientId(String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
        /**
         * Default await setting for writes.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param defaultAwaitWrites the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointConsumerBuilder defaultAwaitWrites(
                boolean defaultAwaitWrites) {
            doSetProperty("defaultAwaitWrites", defaultAwaitWrites);
            return this;
        }
        /**
         * Default await setting for writes.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param defaultAwaitWrites the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointConsumerBuilder defaultAwaitWrites(
                String defaultAwaitWrites) {
            doSetProperty("defaultAwaitWrites", defaultAwaitWrites);
            return this;
        }
        /**
         * A suffix for endpoint URI when discovering.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param discoveryEndpointSuffix the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointConsumerBuilder discoveryEndpointSuffix(
                String discoveryEndpointSuffix) {
            doSetProperty("discoveryEndpointSuffix", discoveryEndpointSuffix);
            return this;
        }
        /**
         * An alternative discovery URI.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param discoveryEndpointUri the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointConsumerBuilder discoveryEndpointUri(
                String discoveryEndpointUri) {
            doSetProperty("discoveryEndpointUri", discoveryEndpointUri);
            return this;
        }
        /**
         * The method definition (see Method ID).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param method the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointConsumerBuilder method(String method) {
            doSetProperty("method", method);
            return this;
        }
        /**
         * The node definition (see Node ID).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param node the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointConsumerBuilder node(String node) {
            doSetProperty("node", node);
            return this;
        }
        /**
         * The sampling interval in milliseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Double&lt;/code&gt; type.
         * 
         * Default: 0.0
         * Group: common
         * 
         * @param samplingInterval the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointConsumerBuilder samplingInterval(
                Double samplingInterval) {
            doSetProperty("samplingInterval", samplingInterval);
            return this;
        }
        /**
         * The sampling interval in milliseconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Double&lt;/code&gt; type.
         * 
         * Default: 0.0
         * Group: common
         * 
         * @param samplingInterval the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointConsumerBuilder samplingInterval(
                String samplingInterval) {
            doSetProperty("samplingInterval", samplingInterval);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * A set of allowed security policy URIs. Default is to accept all and
         * use the highest.
         * 
         * The option is a:
         * &lt;code&gt;java.util.Set&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param allowedSecurityPolicies the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointConsumerBuilder allowedSecurityPolicies(
                Set<String> allowedSecurityPolicies) {
            doSetProperty("allowedSecurityPolicies", allowedSecurityPolicies);
            return this;
        }
        /**
         * A set of allowed security policy URIs. Default is to accept all and
         * use the highest.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Set&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param allowedSecurityPolicies the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointConsumerBuilder allowedSecurityPolicies(
                String allowedSecurityPolicies) {
            doSetProperty("allowedSecurityPolicies", allowedSecurityPolicies);
            return this;
        }
        /**
         * The application name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: Apache Camel adapter for Eclipse Milo
         * Group: client
         * 
         * @param applicationName the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointConsumerBuilder applicationName(
                String applicationName) {
            doSetProperty("applicationName", applicationName);
            return this;
        }
        /**
         * The application URI.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: http://camel.apache.org/EclipseMilo/Client
         * Group: client
         * 
         * @param applicationUri the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointConsumerBuilder applicationUri(
                String applicationUri) {
            doSetProperty("applicationUri", applicationUri);
            return this;
        }
        /**
         * Channel lifetime in milliseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param channelLifetime the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointConsumerBuilder channelLifetime(
                Long channelLifetime) {
            doSetProperty("channelLifetime", channelLifetime);
            return this;
        }
        /**
         * Channel lifetime in milliseconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param channelLifetime the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointConsumerBuilder channelLifetime(
                String channelLifetime) {
            doSetProperty("channelLifetime", channelLifetime);
            return this;
        }
        /**
         * The name of the key in the keystore file.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param keyAlias the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointConsumerBuilder keyAlias(String keyAlias) {
            doSetProperty("keyAlias", keyAlias);
            return this;
        }
        /**
         * The key password.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param keyPassword the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointConsumerBuilder keyPassword(String keyPassword) {
            doSetProperty("keyPassword", keyPassword);
            return this;
        }
        /**
         * The keystore password.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param keyStorePassword the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointConsumerBuilder keyStorePassword(
                String keyStorePassword) {
            doSetProperty("keyStorePassword", keyStorePassword);
            return this;
        }
        /**
         * The key store type.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param keyStoreType the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointConsumerBuilder keyStoreType(
                String keyStoreType) {
            doSetProperty("keyStoreType", keyStoreType);
            return this;
        }
        /**
         * The URL where the key should be loaded from.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param keyStoreUrl the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointConsumerBuilder keyStoreUrl(String keyStoreUrl) {
            doSetProperty("keyStoreUrl", keyStoreUrl);
            return this;
        }
        /**
         * The maximum number of pending publish requests.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param maxPendingPublishRequests the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointConsumerBuilder maxPendingPublishRequests(
                Long maxPendingPublishRequests) {
            doSetProperty("maxPendingPublishRequests", maxPendingPublishRequests);
            return this;
        }
        /**
         * The maximum number of pending publish requests.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param maxPendingPublishRequests the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointConsumerBuilder maxPendingPublishRequests(
                String maxPendingPublishRequests) {
            doSetProperty("maxPendingPublishRequests", maxPendingPublishRequests);
            return this;
        }
        /**
         * The maximum number of bytes a response message may have.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param maxResponseMessageSize the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointConsumerBuilder maxResponseMessageSize(
                Long maxResponseMessageSize) {
            doSetProperty("maxResponseMessageSize", maxResponseMessageSize);
            return this;
        }
        /**
         * The maximum number of bytes a response message may have.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param maxResponseMessageSize the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointConsumerBuilder maxResponseMessageSize(
                String maxResponseMessageSize) {
            doSetProperty("maxResponseMessageSize", maxResponseMessageSize);
            return this;
        }
        /**
         * Override the server reported endpoint host with the host from the
         * endpoint URI.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: client
         * 
         * @param overrideHost the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointConsumerBuilder overrideHost(
                boolean overrideHost) {
            doSetProperty("overrideHost", overrideHost);
            return this;
        }
        /**
         * Override the server reported endpoint host with the host from the
         * endpoint URI.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: client
         * 
         * @param overrideHost the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointConsumerBuilder overrideHost(
                String overrideHost) {
            doSetProperty("overrideHost", overrideHost);
            return this;
        }
        /**
         * The product URI.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: http://camel.apache.org/EclipseMilo
         * Group: client
         * 
         * @param productUri the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointConsumerBuilder productUri(String productUri) {
            doSetProperty("productUri", productUri);
            return this;
        }
        /**
         * The requested publishing interval in milliseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Double&lt;/code&gt; type.
         * 
         * Default: 1_000.0
         * Group: client
         * 
         * @param requestedPublishingInterval the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointConsumerBuilder requestedPublishingInterval(
                Double requestedPublishingInterval) {
            doSetProperty("requestedPublishingInterval", requestedPublishingInterval);
            return this;
        }
        /**
         * The requested publishing interval in milliseconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Double&lt;/code&gt; type.
         * 
         * Default: 1_000.0
         * Group: client
         * 
         * @param requestedPublishingInterval the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointConsumerBuilder requestedPublishingInterval(
                String requestedPublishingInterval) {
            doSetProperty("requestedPublishingInterval", requestedPublishingInterval);
            return this;
        }
        /**
         * Request timeout in milliseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param requestTimeout the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointConsumerBuilder requestTimeout(
                Long requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Request timeout in milliseconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param requestTimeout the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointConsumerBuilder requestTimeout(
                String requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Session name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param sessionName the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointConsumerBuilder sessionName(String sessionName) {
            doSetProperty("sessionName", sessionName);
            return this;
        }
        /**
         * Session timeout in milliseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param sessionTimeout the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointConsumerBuilder sessionTimeout(
                Long sessionTimeout) {
            doSetProperty("sessionTimeout", sessionTimeout);
            return this;
        }
        /**
         * Session timeout in milliseconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param sessionTimeout the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointConsumerBuilder sessionTimeout(
                String sessionTimeout) {
            doSetProperty("sessionTimeout", sessionTimeout);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the OPC UA Client component.
     */
    public interface AdvancedMiloClientEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default MiloClientEndpointConsumerBuilder basic() {
            return (MiloClientEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedMiloClientEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedMiloClientEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedMiloClientEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedMiloClientEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedMiloClientEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedMiloClientEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the OPC UA Client component.
     */
    public interface MiloClientEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedMiloClientEndpointProducerBuilder advanced() {
            return (AdvancedMiloClientEndpointProducerBuilder) this;
        }
        /**
         * A virtual client id to force the creation of a new connection
         * instance.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param clientId the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointProducerBuilder clientId(String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
        /**
         * Default await setting for writes.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param defaultAwaitWrites the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointProducerBuilder defaultAwaitWrites(
                boolean defaultAwaitWrites) {
            doSetProperty("defaultAwaitWrites", defaultAwaitWrites);
            return this;
        }
        /**
         * Default await setting for writes.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param defaultAwaitWrites the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointProducerBuilder defaultAwaitWrites(
                String defaultAwaitWrites) {
            doSetProperty("defaultAwaitWrites", defaultAwaitWrites);
            return this;
        }
        /**
         * A suffix for endpoint URI when discovering.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param discoveryEndpointSuffix the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointProducerBuilder discoveryEndpointSuffix(
                String discoveryEndpointSuffix) {
            doSetProperty("discoveryEndpointSuffix", discoveryEndpointSuffix);
            return this;
        }
        /**
         * An alternative discovery URI.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param discoveryEndpointUri the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointProducerBuilder discoveryEndpointUri(
                String discoveryEndpointUri) {
            doSetProperty("discoveryEndpointUri", discoveryEndpointUri);
            return this;
        }
        /**
         * The method definition (see Method ID).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param method the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointProducerBuilder method(String method) {
            doSetProperty("method", method);
            return this;
        }
        /**
         * The node definition (see Node ID).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param node the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointProducerBuilder node(String node) {
            doSetProperty("node", node);
            return this;
        }
        /**
         * The sampling interval in milliseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Double&lt;/code&gt; type.
         * 
         * Default: 0.0
         * Group: common
         * 
         * @param samplingInterval the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointProducerBuilder samplingInterval(
                Double samplingInterval) {
            doSetProperty("samplingInterval", samplingInterval);
            return this;
        }
        /**
         * The sampling interval in milliseconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Double&lt;/code&gt; type.
         * 
         * Default: 0.0
         * Group: common
         * 
         * @param samplingInterval the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointProducerBuilder samplingInterval(
                String samplingInterval) {
            doSetProperty("samplingInterval", samplingInterval);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * A set of allowed security policy URIs. Default is to accept all and
         * use the highest.
         * 
         * The option is a:
         * &lt;code&gt;java.util.Set&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param allowedSecurityPolicies the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointProducerBuilder allowedSecurityPolicies(
                Set<String> allowedSecurityPolicies) {
            doSetProperty("allowedSecurityPolicies", allowedSecurityPolicies);
            return this;
        }
        /**
         * A set of allowed security policy URIs. Default is to accept all and
         * use the highest.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Set&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param allowedSecurityPolicies the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointProducerBuilder allowedSecurityPolicies(
                String allowedSecurityPolicies) {
            doSetProperty("allowedSecurityPolicies", allowedSecurityPolicies);
            return this;
        }
        /**
         * The application name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: Apache Camel adapter for Eclipse Milo
         * Group: client
         * 
         * @param applicationName the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointProducerBuilder applicationName(
                String applicationName) {
            doSetProperty("applicationName", applicationName);
            return this;
        }
        /**
         * The application URI.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: http://camel.apache.org/EclipseMilo/Client
         * Group: client
         * 
         * @param applicationUri the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointProducerBuilder applicationUri(
                String applicationUri) {
            doSetProperty("applicationUri", applicationUri);
            return this;
        }
        /**
         * Channel lifetime in milliseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param channelLifetime the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointProducerBuilder channelLifetime(
                Long channelLifetime) {
            doSetProperty("channelLifetime", channelLifetime);
            return this;
        }
        /**
         * Channel lifetime in milliseconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param channelLifetime the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointProducerBuilder channelLifetime(
                String channelLifetime) {
            doSetProperty("channelLifetime", channelLifetime);
            return this;
        }
        /**
         * The name of the key in the keystore file.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param keyAlias the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointProducerBuilder keyAlias(String keyAlias) {
            doSetProperty("keyAlias", keyAlias);
            return this;
        }
        /**
         * The key password.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param keyPassword the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointProducerBuilder keyPassword(String keyPassword) {
            doSetProperty("keyPassword", keyPassword);
            return this;
        }
        /**
         * The keystore password.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param keyStorePassword the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointProducerBuilder keyStorePassword(
                String keyStorePassword) {
            doSetProperty("keyStorePassword", keyStorePassword);
            return this;
        }
        /**
         * The key store type.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param keyStoreType the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointProducerBuilder keyStoreType(
                String keyStoreType) {
            doSetProperty("keyStoreType", keyStoreType);
            return this;
        }
        /**
         * The URL where the key should be loaded from.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param keyStoreUrl the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointProducerBuilder keyStoreUrl(String keyStoreUrl) {
            doSetProperty("keyStoreUrl", keyStoreUrl);
            return this;
        }
        /**
         * The maximum number of pending publish requests.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param maxPendingPublishRequests the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointProducerBuilder maxPendingPublishRequests(
                Long maxPendingPublishRequests) {
            doSetProperty("maxPendingPublishRequests", maxPendingPublishRequests);
            return this;
        }
        /**
         * The maximum number of pending publish requests.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param maxPendingPublishRequests the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointProducerBuilder maxPendingPublishRequests(
                String maxPendingPublishRequests) {
            doSetProperty("maxPendingPublishRequests", maxPendingPublishRequests);
            return this;
        }
        /**
         * The maximum number of bytes a response message may have.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param maxResponseMessageSize the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointProducerBuilder maxResponseMessageSize(
                Long maxResponseMessageSize) {
            doSetProperty("maxResponseMessageSize", maxResponseMessageSize);
            return this;
        }
        /**
         * The maximum number of bytes a response message may have.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param maxResponseMessageSize the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointProducerBuilder maxResponseMessageSize(
                String maxResponseMessageSize) {
            doSetProperty("maxResponseMessageSize", maxResponseMessageSize);
            return this;
        }
        /**
         * Override the server reported endpoint host with the host from the
         * endpoint URI.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: client
         * 
         * @param overrideHost the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointProducerBuilder overrideHost(
                boolean overrideHost) {
            doSetProperty("overrideHost", overrideHost);
            return this;
        }
        /**
         * Override the server reported endpoint host with the host from the
         * endpoint URI.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: client
         * 
         * @param overrideHost the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointProducerBuilder overrideHost(
                String overrideHost) {
            doSetProperty("overrideHost", overrideHost);
            return this;
        }
        /**
         * The product URI.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: http://camel.apache.org/EclipseMilo
         * Group: client
         * 
         * @param productUri the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointProducerBuilder productUri(String productUri) {
            doSetProperty("productUri", productUri);
            return this;
        }
        /**
         * The requested publishing interval in milliseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Double&lt;/code&gt; type.
         * 
         * Default: 1_000.0
         * Group: client
         * 
         * @param requestedPublishingInterval the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointProducerBuilder requestedPublishingInterval(
                Double requestedPublishingInterval) {
            doSetProperty("requestedPublishingInterval", requestedPublishingInterval);
            return this;
        }
        /**
         * The requested publishing interval in milliseconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Double&lt;/code&gt; type.
         * 
         * Default: 1_000.0
         * Group: client
         * 
         * @param requestedPublishingInterval the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointProducerBuilder requestedPublishingInterval(
                String requestedPublishingInterval) {
            doSetProperty("requestedPublishingInterval", requestedPublishingInterval);
            return this;
        }
        /**
         * Request timeout in milliseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param requestTimeout the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointProducerBuilder requestTimeout(
                Long requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Request timeout in milliseconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param requestTimeout the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointProducerBuilder requestTimeout(
                String requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Session name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param sessionName the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointProducerBuilder sessionName(String sessionName) {
            doSetProperty("sessionName", sessionName);
            return this;
        }
        /**
         * Session timeout in milliseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param sessionTimeout the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointProducerBuilder sessionTimeout(
                Long sessionTimeout) {
            doSetProperty("sessionTimeout", sessionTimeout);
            return this;
        }
        /**
         * Session timeout in milliseconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param sessionTimeout the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointProducerBuilder sessionTimeout(
                String sessionTimeout) {
            doSetProperty("sessionTimeout", sessionTimeout);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the OPC UA Client component.
     */
    public interface AdvancedMiloClientEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default MiloClientEndpointProducerBuilder basic() {
            return (MiloClientEndpointProducerBuilder) this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedMiloClientEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedMiloClientEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the OPC UA Client component.
     */
    public interface MiloClientEndpointBuilder
            extends
                MiloClientEndpointConsumerBuilder,
                MiloClientEndpointProducerBuilder {
        default AdvancedMiloClientEndpointBuilder advanced() {
            return (AdvancedMiloClientEndpointBuilder) this;
        }
        /**
         * A virtual client id to force the creation of a new connection
         * instance.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param clientId the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointBuilder clientId(String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
        /**
         * Default await setting for writes.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param defaultAwaitWrites the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointBuilder defaultAwaitWrites(
                boolean defaultAwaitWrites) {
            doSetProperty("defaultAwaitWrites", defaultAwaitWrites);
            return this;
        }
        /**
         * Default await setting for writes.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param defaultAwaitWrites the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointBuilder defaultAwaitWrites(
                String defaultAwaitWrites) {
            doSetProperty("defaultAwaitWrites", defaultAwaitWrites);
            return this;
        }
        /**
         * A suffix for endpoint URI when discovering.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param discoveryEndpointSuffix the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointBuilder discoveryEndpointSuffix(
                String discoveryEndpointSuffix) {
            doSetProperty("discoveryEndpointSuffix", discoveryEndpointSuffix);
            return this;
        }
        /**
         * An alternative discovery URI.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param discoveryEndpointUri the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointBuilder discoveryEndpointUri(
                String discoveryEndpointUri) {
            doSetProperty("discoveryEndpointUri", discoveryEndpointUri);
            return this;
        }
        /**
         * The method definition (see Method ID).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param method the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointBuilder method(String method) {
            doSetProperty("method", method);
            return this;
        }
        /**
         * The node definition (see Node ID).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param node the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointBuilder node(String node) {
            doSetProperty("node", node);
            return this;
        }
        /**
         * The sampling interval in milliseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Double&lt;/code&gt; type.
         * 
         * Default: 0.0
         * Group: common
         * 
         * @param samplingInterval the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointBuilder samplingInterval(
                Double samplingInterval) {
            doSetProperty("samplingInterval", samplingInterval);
            return this;
        }
        /**
         * The sampling interval in milliseconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Double&lt;/code&gt; type.
         * 
         * Default: 0.0
         * Group: common
         * 
         * @param samplingInterval the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointBuilder samplingInterval(
                String samplingInterval) {
            doSetProperty("samplingInterval", samplingInterval);
            return this;
        }
        /**
         * A set of allowed security policy URIs. Default is to accept all and
         * use the highest.
         * 
         * The option is a:
         * &lt;code&gt;java.util.Set&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param allowedSecurityPolicies the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointBuilder allowedSecurityPolicies(
                Set<String> allowedSecurityPolicies) {
            doSetProperty("allowedSecurityPolicies", allowedSecurityPolicies);
            return this;
        }
        /**
         * A set of allowed security policy URIs. Default is to accept all and
         * use the highest.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.Set&amp;lt;java.lang.String&amp;gt;&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param allowedSecurityPolicies the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointBuilder allowedSecurityPolicies(
                String allowedSecurityPolicies) {
            doSetProperty("allowedSecurityPolicies", allowedSecurityPolicies);
            return this;
        }
        /**
         * The application name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: Apache Camel adapter for Eclipse Milo
         * Group: client
         * 
         * @param applicationName the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointBuilder applicationName(String applicationName) {
            doSetProperty("applicationName", applicationName);
            return this;
        }
        /**
         * The application URI.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: http://camel.apache.org/EclipseMilo/Client
         * Group: client
         * 
         * @param applicationUri the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointBuilder applicationUri(String applicationUri) {
            doSetProperty("applicationUri", applicationUri);
            return this;
        }
        /**
         * Channel lifetime in milliseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param channelLifetime the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointBuilder channelLifetime(Long channelLifetime) {
            doSetProperty("channelLifetime", channelLifetime);
            return this;
        }
        /**
         * Channel lifetime in milliseconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param channelLifetime the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointBuilder channelLifetime(String channelLifetime) {
            doSetProperty("channelLifetime", channelLifetime);
            return this;
        }
        /**
         * The name of the key in the keystore file.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param keyAlias the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointBuilder keyAlias(String keyAlias) {
            doSetProperty("keyAlias", keyAlias);
            return this;
        }
        /**
         * The key password.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param keyPassword the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointBuilder keyPassword(String keyPassword) {
            doSetProperty("keyPassword", keyPassword);
            return this;
        }
        /**
         * The keystore password.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param keyStorePassword the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointBuilder keyStorePassword(
                String keyStorePassword) {
            doSetProperty("keyStorePassword", keyStorePassword);
            return this;
        }
        /**
         * The key store type.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param keyStoreType the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointBuilder keyStoreType(String keyStoreType) {
            doSetProperty("keyStoreType", keyStoreType);
            return this;
        }
        /**
         * The URL where the key should be loaded from.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param keyStoreUrl the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointBuilder keyStoreUrl(String keyStoreUrl) {
            doSetProperty("keyStoreUrl", keyStoreUrl);
            return this;
        }
        /**
         * The maximum number of pending publish requests.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param maxPendingPublishRequests the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointBuilder maxPendingPublishRequests(
                Long maxPendingPublishRequests) {
            doSetProperty("maxPendingPublishRequests", maxPendingPublishRequests);
            return this;
        }
        /**
         * The maximum number of pending publish requests.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param maxPendingPublishRequests the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointBuilder maxPendingPublishRequests(
                String maxPendingPublishRequests) {
            doSetProperty("maxPendingPublishRequests", maxPendingPublishRequests);
            return this;
        }
        /**
         * The maximum number of bytes a response message may have.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param maxResponseMessageSize the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointBuilder maxResponseMessageSize(
                Long maxResponseMessageSize) {
            doSetProperty("maxResponseMessageSize", maxResponseMessageSize);
            return this;
        }
        /**
         * The maximum number of bytes a response message may have.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param maxResponseMessageSize the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointBuilder maxResponseMessageSize(
                String maxResponseMessageSize) {
            doSetProperty("maxResponseMessageSize", maxResponseMessageSize);
            return this;
        }
        /**
         * Override the server reported endpoint host with the host from the
         * endpoint URI.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: client
         * 
         * @param overrideHost the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointBuilder overrideHost(boolean overrideHost) {
            doSetProperty("overrideHost", overrideHost);
            return this;
        }
        /**
         * Override the server reported endpoint host with the host from the
         * endpoint URI.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: client
         * 
         * @param overrideHost the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointBuilder overrideHost(String overrideHost) {
            doSetProperty("overrideHost", overrideHost);
            return this;
        }
        /**
         * The product URI.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: http://camel.apache.org/EclipseMilo
         * Group: client
         * 
         * @param productUri the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointBuilder productUri(String productUri) {
            doSetProperty("productUri", productUri);
            return this;
        }
        /**
         * The requested publishing interval in milliseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Double&lt;/code&gt; type.
         * 
         * Default: 1_000.0
         * Group: client
         * 
         * @param requestedPublishingInterval the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointBuilder requestedPublishingInterval(
                Double requestedPublishingInterval) {
            doSetProperty("requestedPublishingInterval", requestedPublishingInterval);
            return this;
        }
        /**
         * The requested publishing interval in milliseconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Double&lt;/code&gt; type.
         * 
         * Default: 1_000.0
         * Group: client
         * 
         * @param requestedPublishingInterval the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointBuilder requestedPublishingInterval(
                String requestedPublishingInterval) {
            doSetProperty("requestedPublishingInterval", requestedPublishingInterval);
            return this;
        }
        /**
         * Request timeout in milliseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param requestTimeout the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointBuilder requestTimeout(Long requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Request timeout in milliseconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param requestTimeout the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointBuilder requestTimeout(String requestTimeout) {
            doSetProperty("requestTimeout", requestTimeout);
            return this;
        }
        /**
         * Session name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param sessionName the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointBuilder sessionName(String sessionName) {
            doSetProperty("sessionName", sessionName);
            return this;
        }
        /**
         * Session timeout in milliseconds.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param sessionTimeout the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointBuilder sessionTimeout(Long sessionTimeout) {
            doSetProperty("sessionTimeout", sessionTimeout);
            return this;
        }
        /**
         * Session timeout in milliseconds.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: client
         * 
         * @param sessionTimeout the value to set
         * @return the dsl builder
         */
        default MiloClientEndpointBuilder sessionTimeout(String sessionTimeout) {
            doSetProperty("sessionTimeout", sessionTimeout);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the OPC UA Client component.
     */
    public interface AdvancedMiloClientEndpointBuilder
            extends
                AdvancedMiloClientEndpointConsumerBuilder,
                AdvancedMiloClientEndpointProducerBuilder {
        default MiloClientEndpointBuilder basic() {
            return (MiloClientEndpointBuilder) this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedMiloClientEndpointBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedMiloClientEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    public interface MiloClientBuilders {
        /**
         * OPC UA Client (camel-milo)
         * Connect to OPC UA servers using the binary protocol for acquiring
         * telemetry data.
         * 
         * Category: iot
         * Since: 2.19
         * Maven coordinates: org.apache.camel:camel-milo
         * 
         * Syntax: <code>milo-client:endpointUri</code>
         * 
         * Path parameter: endpointUri (required)
         * The OPC UA server endpoint
         * 
         * @param path endpointUri
         * @return the dsl builder
         */
        default MiloClientEndpointBuilder miloClient(String path) {
            return MiloClientEndpointBuilderFactory.endpointBuilder("milo-client", path);
        }
        /**
         * OPC UA Client (camel-milo)
         * Connect to OPC UA servers using the binary protocol for acquiring
         * telemetry data.
         * 
         * Category: iot
         * Since: 2.19
         * Maven coordinates: org.apache.camel:camel-milo
         * 
         * Syntax: <code>milo-client:endpointUri</code>
         * 
         * Path parameter: endpointUri (required)
         * The OPC UA server endpoint
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path endpointUri
         * @return the dsl builder
         */
        default MiloClientEndpointBuilder miloClient(
                String componentName,
                String path) {
            return MiloClientEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static MiloClientEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class MiloClientEndpointBuilderImpl extends AbstractEndpointBuilder implements MiloClientEndpointBuilder, AdvancedMiloClientEndpointBuilder {
            public MiloClientEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new MiloClientEndpointBuilderImpl(path);
    }
}