/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.HeaderFilterStrategy;

/**
 * Exchange data with external Websocket servers using Async Http Client.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface WsEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Async HTTP Client (AHC) Websocket
     * component.
     */
    public interface WsEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedWsEndpointConsumerBuilder advanced() {
            return (AdvancedWsEndpointConsumerBuilder) this;
        }
        /**
         * If the option is true, then the Exchange.HTTP_URI header is ignored,
         * and use the endpoint's URI for request. You may also set the
         * throwExceptionOnFailure to be false to let the AhcProducer send all
         * the fault response back.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param bridgeEndpoint the value to set
         * @return the dsl builder
         */
        default WsEndpointConsumerBuilder bridgeEndpoint(boolean bridgeEndpoint) {
            doSetProperty("bridgeEndpoint", bridgeEndpoint);
            return this;
        }
        /**
         * If the option is true, then the Exchange.HTTP_URI header is ignored,
         * and use the endpoint's URI for request. You may also set the
         * throwExceptionOnFailure to be false to let the AhcProducer send all
         * the fault response back.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param bridgeEndpoint the value to set
         * @return the dsl builder
         */
        default WsEndpointConsumerBuilder bridgeEndpoint(String bridgeEndpoint) {
            doSetProperty("bridgeEndpoint", bridgeEndpoint);
            return this;
        }
        /**
         * The initial in-memory buffer size used when transferring data between
         * Camel and AHC Client.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 4096
         * Group: common
         * 
         * @param bufferSize the value to set
         * @return the dsl builder
         */
        default WsEndpointConsumerBuilder bufferSize(int bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * The initial in-memory buffer size used when transferring data between
         * Camel and AHC Client.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 4096
         * Group: common
         * 
         * @param bufferSize the value to set
         * @return the dsl builder
         */
        default WsEndpointConsumerBuilder bufferSize(String bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default WsEndpointConsumerBuilder headerFilterStrategy(
                HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default WsEndpointConsumerBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Option to disable throwing the AhcOperationFailedException in case of
         * failed responses from the remote server. This allows you to get all
         * responses regardless of the HTTP status code.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param throwExceptionOnFailure the value to set
         * @return the dsl builder
         */
        default WsEndpointConsumerBuilder throwExceptionOnFailure(
                boolean throwExceptionOnFailure) {
            doSetProperty("throwExceptionOnFailure", throwExceptionOnFailure);
            return this;
        }
        /**
         * Option to disable throwing the AhcOperationFailedException in case of
         * failed responses from the remote server. This allows you to get all
         * responses regardless of the HTTP status code.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param throwExceptionOnFailure the value to set
         * @return the dsl builder
         */
        default WsEndpointConsumerBuilder throwExceptionOnFailure(
                String throwExceptionOnFailure) {
            doSetProperty("throwExceptionOnFailure", throwExceptionOnFailure);
            return this;
        }
        /**
         * If enabled and an Exchange failed processing on the consumer side,
         * and if the caused Exception was send back serialized in the response
         * as a application/x-java-serialized-object content type (for example
         * using Jetty or Servlet Camel components). On the producer side the
         * exception will be deserialized and thrown as is, instead of the
         * AhcOperationFailedException. The caused exception is required to be
         * serialized. This is by default turned off. If you enable this then be
         * aware that Java will deserialize the incoming data from the request
         * to Java and that can be a potential security risk.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param transferException the value to set
         * @return the dsl builder
         */
        default WsEndpointConsumerBuilder transferException(
                boolean transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * If enabled and an Exchange failed processing on the consumer side,
         * and if the caused Exception was send back serialized in the response
         * as a application/x-java-serialized-object content type (for example
         * using Jetty or Servlet Camel components). On the producer side the
         * exception will be deserialized and thrown as is, instead of the
         * AhcOperationFailedException. The caused exception is required to be
         * serialized. This is by default turned off. If you enable this then be
         * aware that Java will deserialize the incoming data from the request
         * to Java and that can be a potential security risk.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param transferException the value to set
         * @return the dsl builder
         */
        default WsEndpointConsumerBuilder transferException(
                String transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default WsEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default WsEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Whether to send an message if the web-socket listener received an
         * error.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendMessageOnError the value to set
         * @return the dsl builder
         */
        default WsEndpointConsumerBuilder sendMessageOnError(
                boolean sendMessageOnError) {
            doSetProperty("sendMessageOnError", sendMessageOnError);
            return this;
        }
        /**
         * Whether to send an message if the web-socket listener received an
         * error.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendMessageOnError the value to set
         * @return the dsl builder
         */
        default WsEndpointConsumerBuilder sendMessageOnError(
                String sendMessageOnError) {
            doSetProperty("sendMessageOnError", sendMessageOnError);
            return this;
        }
        /**
         * Reference to a org.apache.camel.support.jsse.SSLContextParameters in
         * the Registry. This reference overrides any configured
         * SSLContextParameters at the component level. See Using the JSSE
         * Configuration Utility. Note that configuring this option will
         * override any SSL/TLS configuration options provided through the
         * clientConfig option at the endpoint or component level.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default WsEndpointConsumerBuilder sslContextParameters(
                Object sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Reference to a org.apache.camel.support.jsse.SSLContextParameters in
         * the Registry. This reference overrides any configured
         * SSLContextParameters at the component level. See Using the JSSE
         * Configuration Utility. Note that configuring this option will
         * override any SSL/TLS configuration options provided through the
         * clientConfig option at the endpoint or component level.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default WsEndpointConsumerBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Async HTTP Client (AHC)
     * Websocket component.
     */
    public interface AdvancedWsEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default WsEndpointConsumerBuilder basic() {
            return (WsEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedWsEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedWsEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedWsEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedWsEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * To use a custom AhcBinding which allows to control how to bind
         * between AHC and Camel.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.ahc.AhcBinding&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param binding the value to set
         * @return the dsl builder
         */
        default AdvancedWsEndpointConsumerBuilder binding(Object binding) {
            doSetProperty("binding", binding);
            return this;
        }
        /**
         * To use a custom AhcBinding which allows to control how to bind
         * between AHC and Camel.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.ahc.AhcBinding&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param binding the value to set
         * @return the dsl builder
         */
        default AdvancedWsEndpointConsumerBuilder binding(String binding) {
            doSetProperty("binding", binding);
            return this;
        }
        /**
         * To configure the AsyncHttpClient to use a custom
         * com.ning.http.client.AsyncHttpClientConfig instance.
         * 
         * The option is a:
         * &lt;code&gt;org.asynchttpclient.AsyncHttpClientConfig&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param clientConfig the value to set
         * @return the dsl builder
         */
        default AdvancedWsEndpointConsumerBuilder clientConfig(
                Object clientConfig) {
            doSetProperty("clientConfig", clientConfig);
            return this;
        }
        /**
         * To configure the AsyncHttpClient to use a custom
         * com.ning.http.client.AsyncHttpClientConfig instance.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.asynchttpclient.AsyncHttpClientConfig&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param clientConfig the value to set
         * @return the dsl builder
         */
        default AdvancedWsEndpointConsumerBuilder clientConfig(
                String clientConfig) {
            doSetProperty("clientConfig", clientConfig);
            return this;
        }
        /**
         * To configure the AsyncHttpClientConfig using the key/values from the
         * Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * clientConfigOptions(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedWsEndpointConsumerBuilder clientConfigOptions(
                String key,
                Object value) {
            doSetMultiValueProperty("clientConfigOptions", "clientConfig." + key, value);
            return this;
        }
        /**
         * To configure the AsyncHttpClientConfig using the key/values from the
         * Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * clientConfigOptions(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedWsEndpointConsumerBuilder clientConfigOptions(Map values) {
            doSetMultiValueProperties("clientConfigOptions", "clientConfig.", values);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedWsEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedWsEndpointConsumerBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * To configure the AsyncHttpClientConfig Realm using the key/values
         * from the Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * clientConfigRealmOptions(String, Object) method to add a value (call
         * the method multiple times to set more values).
         * 
         * Group: security
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedWsEndpointConsumerBuilder clientConfigRealmOptions(
                String key,
                Object value) {
            doSetMultiValueProperty("clientConfigRealmOptions", "clientConfig.realm." + key, value);
            return this;
        }
        /**
         * To configure the AsyncHttpClientConfig Realm using the key/values
         * from the Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * clientConfigRealmOptions(String, Object) method to add a value (call
         * the method multiple times to set more values).
         * 
         * Group: security
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedWsEndpointConsumerBuilder clientConfigRealmOptions(
                Map values) {
            doSetMultiValueProperties("clientConfigRealmOptions", "clientConfig.realm.", values);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Async HTTP Client (AHC) Websocket
     * component.
     */
    public interface WsEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedWsEndpointProducerBuilder advanced() {
            return (AdvancedWsEndpointProducerBuilder) this;
        }
        /**
         * If the option is true, then the Exchange.HTTP_URI header is ignored,
         * and use the endpoint's URI for request. You may also set the
         * throwExceptionOnFailure to be false to let the AhcProducer send all
         * the fault response back.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param bridgeEndpoint the value to set
         * @return the dsl builder
         */
        default WsEndpointProducerBuilder bridgeEndpoint(boolean bridgeEndpoint) {
            doSetProperty("bridgeEndpoint", bridgeEndpoint);
            return this;
        }
        /**
         * If the option is true, then the Exchange.HTTP_URI header is ignored,
         * and use the endpoint's URI for request. You may also set the
         * throwExceptionOnFailure to be false to let the AhcProducer send all
         * the fault response back.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param bridgeEndpoint the value to set
         * @return the dsl builder
         */
        default WsEndpointProducerBuilder bridgeEndpoint(String bridgeEndpoint) {
            doSetProperty("bridgeEndpoint", bridgeEndpoint);
            return this;
        }
        /**
         * The initial in-memory buffer size used when transferring data between
         * Camel and AHC Client.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 4096
         * Group: common
         * 
         * @param bufferSize the value to set
         * @return the dsl builder
         */
        default WsEndpointProducerBuilder bufferSize(int bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * The initial in-memory buffer size used when transferring data between
         * Camel and AHC Client.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 4096
         * Group: common
         * 
         * @param bufferSize the value to set
         * @return the dsl builder
         */
        default WsEndpointProducerBuilder bufferSize(String bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default WsEndpointProducerBuilder headerFilterStrategy(
                HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default WsEndpointProducerBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Option to disable throwing the AhcOperationFailedException in case of
         * failed responses from the remote server. This allows you to get all
         * responses regardless of the HTTP status code.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param throwExceptionOnFailure the value to set
         * @return the dsl builder
         */
        default WsEndpointProducerBuilder throwExceptionOnFailure(
                boolean throwExceptionOnFailure) {
            doSetProperty("throwExceptionOnFailure", throwExceptionOnFailure);
            return this;
        }
        /**
         * Option to disable throwing the AhcOperationFailedException in case of
         * failed responses from the remote server. This allows you to get all
         * responses regardless of the HTTP status code.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param throwExceptionOnFailure the value to set
         * @return the dsl builder
         */
        default WsEndpointProducerBuilder throwExceptionOnFailure(
                String throwExceptionOnFailure) {
            doSetProperty("throwExceptionOnFailure", throwExceptionOnFailure);
            return this;
        }
        /**
         * If enabled and an Exchange failed processing on the consumer side,
         * and if the caused Exception was send back serialized in the response
         * as a application/x-java-serialized-object content type (for example
         * using Jetty or Servlet Camel components). On the producer side the
         * exception will be deserialized and thrown as is, instead of the
         * AhcOperationFailedException. The caused exception is required to be
         * serialized. This is by default turned off. If you enable this then be
         * aware that Java will deserialize the incoming data from the request
         * to Java and that can be a potential security risk.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param transferException the value to set
         * @return the dsl builder
         */
        default WsEndpointProducerBuilder transferException(
                boolean transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * If enabled and an Exchange failed processing on the consumer side,
         * and if the caused Exception was send back serialized in the response
         * as a application/x-java-serialized-object content type (for example
         * using Jetty or Servlet Camel components). On the producer side the
         * exception will be deserialized and thrown as is, instead of the
         * AhcOperationFailedException. The caused exception is required to be
         * serialized. This is by default turned off. If you enable this then be
         * aware that Java will deserialize the incoming data from the request
         * to Java and that can be a potential security risk.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param transferException the value to set
         * @return the dsl builder
         */
        default WsEndpointProducerBuilder transferException(
                String transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * Define if the Connection Close header has to be added to HTTP
         * Request. This parameter is false by default.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param connectionClose the value to set
         * @return the dsl builder
         */
        default WsEndpointProducerBuilder connectionClose(
                boolean connectionClose) {
            doSetProperty("connectionClose", connectionClose);
            return this;
        }
        /**
         * Define if the Connection Close header has to be added to HTTP
         * Request. This parameter is false by default.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param connectionClose the value to set
         * @return the dsl builder
         */
        default WsEndpointProducerBuilder connectionClose(String connectionClose) {
            doSetProperty("connectionClose", connectionClose);
            return this;
        }
        /**
         * Configure a cookie handler to maintain a HTTP session.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.http.base.cookie.CookieHandler&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param cookieHandler the value to set
         * @return the dsl builder
         */
        default WsEndpointProducerBuilder cookieHandler(Object cookieHandler) {
            doSetProperty("cookieHandler", cookieHandler);
            return this;
        }
        /**
         * Configure a cookie handler to maintain a HTTP session.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.http.base.cookie.CookieHandler&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param cookieHandler the value to set
         * @return the dsl builder
         */
        default WsEndpointProducerBuilder cookieHandler(String cookieHandler) {
            doSetProperty("cookieHandler", cookieHandler);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default WsEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default WsEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * To enable streaming to send data as multiple text fragments.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param useStreaming the value to set
         * @return the dsl builder
         */
        default WsEndpointProducerBuilder useStreaming(boolean useStreaming) {
            doSetProperty("useStreaming", useStreaming);
            return this;
        }
        /**
         * To enable streaming to send data as multiple text fragments.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param useStreaming the value to set
         * @return the dsl builder
         */
        default WsEndpointProducerBuilder useStreaming(String useStreaming) {
            doSetProperty("useStreaming", useStreaming);
            return this;
        }
        /**
         * Reference to a org.apache.camel.support.jsse.SSLContextParameters in
         * the Registry. This reference overrides any configured
         * SSLContextParameters at the component level. See Using the JSSE
         * Configuration Utility. Note that configuring this option will
         * override any SSL/TLS configuration options provided through the
         * clientConfig option at the endpoint or component level.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default WsEndpointProducerBuilder sslContextParameters(
                Object sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Reference to a org.apache.camel.support.jsse.SSLContextParameters in
         * the Registry. This reference overrides any configured
         * SSLContextParameters at the component level. See Using the JSSE
         * Configuration Utility. Note that configuring this option will
         * override any SSL/TLS configuration options provided through the
         * clientConfig option at the endpoint or component level.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default WsEndpointProducerBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Async HTTP Client (AHC)
     * Websocket component.
     */
    public interface AdvancedWsEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default WsEndpointProducerBuilder basic() {
            return (WsEndpointProducerBuilder) this;
        }
        /**
         * To use a custom AhcBinding which allows to control how to bind
         * between AHC and Camel.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.ahc.AhcBinding&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param binding the value to set
         * @return the dsl builder
         */
        default AdvancedWsEndpointProducerBuilder binding(Object binding) {
            doSetProperty("binding", binding);
            return this;
        }
        /**
         * To use a custom AhcBinding which allows to control how to bind
         * between AHC and Camel.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.ahc.AhcBinding&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param binding the value to set
         * @return the dsl builder
         */
        default AdvancedWsEndpointProducerBuilder binding(String binding) {
            doSetProperty("binding", binding);
            return this;
        }
        /**
         * To configure the AsyncHttpClient to use a custom
         * com.ning.http.client.AsyncHttpClientConfig instance.
         * 
         * The option is a:
         * &lt;code&gt;org.asynchttpclient.AsyncHttpClientConfig&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param clientConfig the value to set
         * @return the dsl builder
         */
        default AdvancedWsEndpointProducerBuilder clientConfig(
                Object clientConfig) {
            doSetProperty("clientConfig", clientConfig);
            return this;
        }
        /**
         * To configure the AsyncHttpClient to use a custom
         * com.ning.http.client.AsyncHttpClientConfig instance.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.asynchttpclient.AsyncHttpClientConfig&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param clientConfig the value to set
         * @return the dsl builder
         */
        default AdvancedWsEndpointProducerBuilder clientConfig(
                String clientConfig) {
            doSetProperty("clientConfig", clientConfig);
            return this;
        }
        /**
         * To configure the AsyncHttpClientConfig using the key/values from the
         * Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * clientConfigOptions(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedWsEndpointProducerBuilder clientConfigOptions(
                String key,
                Object value) {
            doSetMultiValueProperty("clientConfigOptions", "clientConfig." + key, value);
            return this;
        }
        /**
         * To configure the AsyncHttpClientConfig using the key/values from the
         * Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * clientConfigOptions(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedWsEndpointProducerBuilder clientConfigOptions(Map values) {
            doSetMultiValueProperties("clientConfigOptions", "clientConfig.", values);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedWsEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedWsEndpointProducerBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * To configure the AsyncHttpClientConfig Realm using the key/values
         * from the Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * clientConfigRealmOptions(String, Object) method to add a value (call
         * the method multiple times to set more values).
         * 
         * Group: security
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedWsEndpointProducerBuilder clientConfigRealmOptions(
                String key,
                Object value) {
            doSetMultiValueProperty("clientConfigRealmOptions", "clientConfig.realm." + key, value);
            return this;
        }
        /**
         * To configure the AsyncHttpClientConfig Realm using the key/values
         * from the Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * clientConfigRealmOptions(String, Object) method to add a value (call
         * the method multiple times to set more values).
         * 
         * Group: security
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedWsEndpointProducerBuilder clientConfigRealmOptions(
                Map values) {
            doSetMultiValueProperties("clientConfigRealmOptions", "clientConfig.realm.", values);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Async HTTP Client (AHC) Websocket component.
     */
    public interface WsEndpointBuilder
            extends
                WsEndpointConsumerBuilder,
                WsEndpointProducerBuilder {
        default AdvancedWsEndpointBuilder advanced() {
            return (AdvancedWsEndpointBuilder) this;
        }
        /**
         * If the option is true, then the Exchange.HTTP_URI header is ignored,
         * and use the endpoint's URI for request. You may also set the
         * throwExceptionOnFailure to be false to let the AhcProducer send all
         * the fault response back.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param bridgeEndpoint the value to set
         * @return the dsl builder
         */
        default WsEndpointBuilder bridgeEndpoint(boolean bridgeEndpoint) {
            doSetProperty("bridgeEndpoint", bridgeEndpoint);
            return this;
        }
        /**
         * If the option is true, then the Exchange.HTTP_URI header is ignored,
         * and use the endpoint's URI for request. You may also set the
         * throwExceptionOnFailure to be false to let the AhcProducer send all
         * the fault response back.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param bridgeEndpoint the value to set
         * @return the dsl builder
         */
        default WsEndpointBuilder bridgeEndpoint(String bridgeEndpoint) {
            doSetProperty("bridgeEndpoint", bridgeEndpoint);
            return this;
        }
        /**
         * The initial in-memory buffer size used when transferring data between
         * Camel and AHC Client.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 4096
         * Group: common
         * 
         * @param bufferSize the value to set
         * @return the dsl builder
         */
        default WsEndpointBuilder bufferSize(int bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * The initial in-memory buffer size used when transferring data between
         * Camel and AHC Client.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 4096
         * Group: common
         * 
         * @param bufferSize the value to set
         * @return the dsl builder
         */
        default WsEndpointBuilder bufferSize(String bufferSize) {
            doSetProperty("bufferSize", bufferSize);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default WsEndpointBuilder headerFilterStrategy(
                HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default WsEndpointBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Option to disable throwing the AhcOperationFailedException in case of
         * failed responses from the remote server. This allows you to get all
         * responses regardless of the HTTP status code.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param throwExceptionOnFailure the value to set
         * @return the dsl builder
         */
        default WsEndpointBuilder throwExceptionOnFailure(
                boolean throwExceptionOnFailure) {
            doSetProperty("throwExceptionOnFailure", throwExceptionOnFailure);
            return this;
        }
        /**
         * Option to disable throwing the AhcOperationFailedException in case of
         * failed responses from the remote server. This allows you to get all
         * responses regardless of the HTTP status code.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param throwExceptionOnFailure the value to set
         * @return the dsl builder
         */
        default WsEndpointBuilder throwExceptionOnFailure(
                String throwExceptionOnFailure) {
            doSetProperty("throwExceptionOnFailure", throwExceptionOnFailure);
            return this;
        }
        /**
         * If enabled and an Exchange failed processing on the consumer side,
         * and if the caused Exception was send back serialized in the response
         * as a application/x-java-serialized-object content type (for example
         * using Jetty or Servlet Camel components). On the producer side the
         * exception will be deserialized and thrown as is, instead of the
         * AhcOperationFailedException. The caused exception is required to be
         * serialized. This is by default turned off. If you enable this then be
         * aware that Java will deserialize the incoming data from the request
         * to Java and that can be a potential security risk.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param transferException the value to set
         * @return the dsl builder
         */
        default WsEndpointBuilder transferException(boolean transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * If enabled and an Exchange failed processing on the consumer side,
         * and if the caused Exception was send back serialized in the response
         * as a application/x-java-serialized-object content type (for example
         * using Jetty or Servlet Camel components). On the producer side the
         * exception will be deserialized and thrown as is, instead of the
         * AhcOperationFailedException. The caused exception is required to be
         * serialized. This is by default turned off. If you enable this then be
         * aware that Java will deserialize the incoming data from the request
         * to Java and that can be a potential security risk.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param transferException the value to set
         * @return the dsl builder
         */
        default WsEndpointBuilder transferException(String transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * Reference to a org.apache.camel.support.jsse.SSLContextParameters in
         * the Registry. This reference overrides any configured
         * SSLContextParameters at the component level. See Using the JSSE
         * Configuration Utility. Note that configuring this option will
         * override any SSL/TLS configuration options provided through the
         * clientConfig option at the endpoint or component level.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default WsEndpointBuilder sslContextParameters(
                Object sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Reference to a org.apache.camel.support.jsse.SSLContextParameters in
         * the Registry. This reference overrides any configured
         * SSLContextParameters at the component level. See Using the JSSE
         * Configuration Utility. Note that configuring this option will
         * override any SSL/TLS configuration options provided through the
         * clientConfig option at the endpoint or component level.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.support.jsse.SSLContextParameters&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sslContextParameters the value to set
         * @return the dsl builder
         */
        default WsEndpointBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Async HTTP Client (AHC) Websocket
     * component.
     */
    public interface AdvancedWsEndpointBuilder
            extends
                AdvancedWsEndpointConsumerBuilder,
                AdvancedWsEndpointProducerBuilder {
        default WsEndpointBuilder basic() {
            return (WsEndpointBuilder) this;
        }
        /**
         * To use a custom AhcBinding which allows to control how to bind
         * between AHC and Camel.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.ahc.AhcBinding&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param binding the value to set
         * @return the dsl builder
         */
        default AdvancedWsEndpointBuilder binding(Object binding) {
            doSetProperty("binding", binding);
            return this;
        }
        /**
         * To use a custom AhcBinding which allows to control how to bind
         * between AHC and Camel.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.ahc.AhcBinding&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param binding the value to set
         * @return the dsl builder
         */
        default AdvancedWsEndpointBuilder binding(String binding) {
            doSetProperty("binding", binding);
            return this;
        }
        /**
         * To configure the AsyncHttpClient to use a custom
         * com.ning.http.client.AsyncHttpClientConfig instance.
         * 
         * The option is a:
         * &lt;code&gt;org.asynchttpclient.AsyncHttpClientConfig&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param clientConfig the value to set
         * @return the dsl builder
         */
        default AdvancedWsEndpointBuilder clientConfig(Object clientConfig) {
            doSetProperty("clientConfig", clientConfig);
            return this;
        }
        /**
         * To configure the AsyncHttpClient to use a custom
         * com.ning.http.client.AsyncHttpClientConfig instance.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.asynchttpclient.AsyncHttpClientConfig&lt;/code&gt;
         * type.
         * 
         * Group: advanced
         * 
         * @param clientConfig the value to set
         * @return the dsl builder
         */
        default AdvancedWsEndpointBuilder clientConfig(String clientConfig) {
            doSetProperty("clientConfig", clientConfig);
            return this;
        }
        /**
         * To configure the AsyncHttpClientConfig using the key/values from the
         * Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * clientConfigOptions(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedWsEndpointBuilder clientConfigOptions(
                String key,
                Object value) {
            doSetMultiValueProperty("clientConfigOptions", "clientConfig." + key, value);
            return this;
        }
        /**
         * To configure the AsyncHttpClientConfig using the key/values from the
         * Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * clientConfigOptions(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedWsEndpointBuilder clientConfigOptions(Map values) {
            doSetMultiValueProperties("clientConfigOptions", "clientConfig.", values);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedWsEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedWsEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * To configure the AsyncHttpClientConfig Realm using the key/values
         * from the Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * clientConfigRealmOptions(String, Object) method to add a value (call
         * the method multiple times to set more values).
         * 
         * Group: security
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedWsEndpointBuilder clientConfigRealmOptions(
                String key,
                Object value) {
            doSetMultiValueProperty("clientConfigRealmOptions", "clientConfig.realm." + key, value);
            return this;
        }
        /**
         * To configure the AsyncHttpClientConfig Realm using the key/values
         * from the Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * clientConfigRealmOptions(String, Object) method to add a value (call
         * the method multiple times to set more values).
         * 
         * Group: security
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedWsEndpointBuilder clientConfigRealmOptions(Map values) {
            doSetMultiValueProperties("clientConfigRealmOptions", "clientConfig.realm.", values);
            return this;
        }
    }

    public interface WsBuilders {
        /**
         * Async HTTP Client (AHC) Websocket (camel-ahc-ws)
         * Exchange data with external Websocket servers using Async Http
         * Client.
         * 
         * Category: websocket
         * Since: 2.14
         * Maven coordinates: org.apache.camel:camel-ahc-ws
         * 
         * Syntax: <code>ahc-ws:httpUri</code>
         * 
         * Path parameter: httpUri (required)
         * The URI to use such as http://hostname:port/path
         * 
         * @param path httpUri
         * @return the dsl builder
         */
        default WsEndpointBuilder ahcWs(String path) {
            return WsEndpointBuilderFactory.endpointBuilder("ahc-ws", path);
        }
        /**
         * Async HTTP Client (AHC) Websocket (camel-ahc-ws)
         * Exchange data with external Websocket servers using Async Http
         * Client.
         * 
         * Category: websocket
         * Since: 2.14
         * Maven coordinates: org.apache.camel:camel-ahc-ws
         * 
         * Syntax: <code>ahc-ws:httpUri</code>
         * 
         * Path parameter: httpUri (required)
         * The URI to use such as http://hostname:port/path
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path httpUri
         * @return the dsl builder
         */
        default WsEndpointBuilder ahcWs(String componentName, String path) {
            return WsEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
        /**
         * Async HTTP Client (AHC) Secure Websocket (Secure) (camel-ahc-ws)
         * Exchange data with external Websocket servers using Async Http
         * Client.
         * 
         * Category: websocket
         * Since: 2.14
         * Maven coordinates: org.apache.camel:camel-ahc-ws
         * 
         * Syntax: <code>ahc-wss:httpUri</code>
         * 
         * Path parameter: httpUri (required)
         * The URI to use such as http://hostname:port/path
         * 
         * @param path httpUri
         * @return the dsl builder
         */
        default WsEndpointBuilder ahcWss(String path) {
            return WsEndpointBuilderFactory.endpointBuilder("ahc-wss", path);
        }
    }
    static WsEndpointBuilder endpointBuilder(String componentName, String path) {
        class WsEndpointBuilderImpl extends AbstractEndpointBuilder implements WsEndpointBuilder, AdvancedWsEndpointBuilder {
            public WsEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new WsEndpointBuilderImpl(path);
    }
}