/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Store and Retrieve data from/to AWS SDB service.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface SdbEndpointBuilderFactory {


    /**
     * Builder for endpoint for the AWS SimpleDB component.
     */
    public interface SdbEndpointBuilder extends EndpointProducerBuilder {
        default AdvancedSdbEndpointBuilder advanced() {
            return (AdvancedSdbEndpointBuilder) this;
        }
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default SdbEndpointBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * To use the AmazonSimpleDB as the client.
         * 
         * The option is a:
         * &lt;code&gt;com.amazonaws.services.simpledb.AmazonSimpleDB&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param amazonSDBClient the value to set
         * @return the dsl builder
         */
        default SdbEndpointBuilder amazonSDBClient(Object amazonSDBClient) {
            doSetProperty("amazonSDBClient", amazonSDBClient);
            return this;
        }
        /**
         * To use the AmazonSimpleDB as the client.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.amazonaws.services.simpledb.AmazonSimpleDB&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param amazonSDBClient the value to set
         * @return the dsl builder
         */
        default SdbEndpointBuilder amazonSDBClient(String amazonSDBClient) {
            doSetProperty("amazonSDBClient", amazonSDBClient);
            return this;
        }
        /**
         * Determines whether or not strong consistency should be enforced when
         * data is read.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param consistentRead the value to set
         * @return the dsl builder
         */
        default SdbEndpointBuilder consistentRead(boolean consistentRead) {
            doSetProperty("consistentRead", consistentRead);
            return this;
        }
        /**
         * Determines whether or not strong consistency should be enforced when
         * data is read.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param consistentRead the value to set
         * @return the dsl builder
         */
        default SdbEndpointBuilder consistentRead(String consistentRead) {
            doSetProperty("consistentRead", consistentRead);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default SdbEndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default SdbEndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The maximum number of domain names you want returned. The range is 1
         * to 100.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param maxNumberOfDomains the value to set
         * @return the dsl builder
         */
        default SdbEndpointBuilder maxNumberOfDomains(Integer maxNumberOfDomains) {
            doSetProperty("maxNumberOfDomains", maxNumberOfDomains);
            return this;
        }
        /**
         * The maximum number of domain names you want returned. The range is 1
         * to 100.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param maxNumberOfDomains the value to set
         * @return the dsl builder
         */
        default SdbEndpointBuilder maxNumberOfDomains(String maxNumberOfDomains) {
            doSetProperty("maxNumberOfDomains", maxNumberOfDomains);
            return this;
        }
        /**
         * Operation to perform.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.aws.sdb.SdbOperations&lt;/code&gt; type.
         * 
         * Default: PutAttributes
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default SdbEndpointBuilder operation(SdbOperations operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Operation to perform.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.aws.sdb.SdbOperations&lt;/code&gt; type.
         * 
         * Default: PutAttributes
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default SdbEndpointBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * To define a proxy host when instantiating the SDB client.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default SdbEndpointBuilder proxyHost(String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * To define a proxy port when instantiating the SDB client.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default SdbEndpointBuilder proxyPort(Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy port when instantiating the SDB client.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default SdbEndpointBuilder proxyPort(String proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the SDB client.
         * 
         * The option is a: &lt;code&gt;com.amazonaws.Protocol&lt;/code&gt;
         * type.
         * 
         * Default: HTTPS
         * Group: producer
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default SdbEndpointBuilder proxyProtocol(Protocol proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * To define a proxy protocol when instantiating the SDB client.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.amazonaws.Protocol&lt;/code&gt; type.
         * 
         * Default: HTTPS
         * Group: producer
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default SdbEndpointBuilder proxyProtocol(String proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
        /**
         * The region in which SDB client needs to work. When using this
         * parameter, the configuration will expect the capitalized name of the
         * region (for example AP_EAST_1) You'll need to use the name
         * Regions.EU_WEST_1.name().
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param region the value to set
         * @return the dsl builder
         */
        default SdbEndpointBuilder region(String region) {
            doSetProperty("region", region);
            return this;
        }
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param secretKey the value to set
         * @return the dsl builder
         */
        default SdbEndpointBuilder secretKey(String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the AWS SimpleDB component.
     */
    public interface AdvancedSdbEndpointBuilder
            extends
                EndpointProducerBuilder {
        default SdbEndpointBuilder basic() {
            return (SdbEndpointBuilder) this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedSdbEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedSdbEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.aws.sdb.SdbOperations</code> enum.
     */
    enum SdbOperations {
        BatchDeleteAttributes,
        BatchPutAttributes,
        DeleteAttributes,
        DeleteDomain,
        DomainMetadata,
        GetAttributes,
        ListDomains,
        PutAttributes,
        Select;
    }

    /**
     * Proxy enum for <code>com.amazonaws.Protocol</code> enum.
     */
    enum Protocol {
        HTTP,
        HTTPS;
    }

    public interface SdbBuilders {
        /**
         * AWS SimpleDB (camel-aws-sdb)
         * Store and Retrieve data from/to AWS SDB service.
         * 
         * Category: cloud,database,nosql
         * Since: 2.9
         * Maven coordinates: org.apache.camel:camel-aws-sdb
         * 
         * Syntax: <code>aws-sdb:domainName</code>
         * 
         * Path parameter: domainName (required)
         * The name of the domain currently worked with.
         * 
         * @param path domainName
         * @return the dsl builder
         */
        default SdbEndpointBuilder awsSdb(String path) {
            return SdbEndpointBuilderFactory.endpointBuilder("aws-sdb", path);
        }
        /**
         * AWS SimpleDB (camel-aws-sdb)
         * Store and Retrieve data from/to AWS SDB service.
         * 
         * Category: cloud,database,nosql
         * Since: 2.9
         * Maven coordinates: org.apache.camel:camel-aws-sdb
         * 
         * Syntax: <code>aws-sdb:domainName</code>
         * 
         * Path parameter: domainName (required)
         * The name of the domain currently worked with.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path domainName
         * @return the dsl builder
         */
        default SdbEndpointBuilder awsSdb(String componentName, String path) {
            return SdbEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static SdbEndpointBuilder endpointBuilder(String componentName, String path) {
        class SdbEndpointBuilderImpl extends AbstractEndpointBuilder implements SdbEndpointBuilder, AdvancedSdbEndpointBuilder {
            public SdbEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new SdbEndpointBuilderImpl(path);
    }
}