/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.security.PrivateKey;
import java.security.cert.Certificate;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * Transfer data securely and reliably using the AS2 protocol (RFC4130).
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface AS2EndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the AS2 component.
     */
    public interface AS2EndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedAS2EndpointConsumerBuilder advanced() {
            return (AdvancedAS2EndpointConsumerBuilder) this;
        }
        /**
         * The value of the AS2From header of AS2 message.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param as2From the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder as2From(String as2From) {
            doSetProperty("as2From", as2From);
            return this;
        }
        /**
         * The structure of AS2 Message. One of: PLAIN - No encryption, no
         * signature, SIGNED - No encryption, signature, ENCRYPTED - Encryption,
         * no signature, ENCRYPTED_SIGNED - Encryption, signature.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.as2.api.AS2MessageStructure&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param as2MessageStructure the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder as2MessageStructure(
                AS2MessageStructure as2MessageStructure) {
            doSetProperty("as2MessageStructure", as2MessageStructure);
            return this;
        }
        /**
         * The structure of AS2 Message. One of: PLAIN - No encryption, no
         * signature, SIGNED - No encryption, signature, ENCRYPTED - Encryption,
         * no signature, ENCRYPTED_SIGNED - Encryption, signature.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.as2.api.AS2MessageStructure&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param as2MessageStructure the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder as2MessageStructure(
                String as2MessageStructure) {
            doSetProperty("as2MessageStructure", as2MessageStructure);
            return this;
        }
        /**
         * The value of the AS2To header of AS2 message.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param as2To the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder as2To(String as2To) {
            doSetProperty("as2To", as2To);
            return this;
        }
        /**
         * The version of the AS2 protocol.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: 1.1
         * Group: common
         * 
         * @param as2Version the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder as2Version(String as2Version) {
            doSetProperty("as2Version", as2Version);
            return this;
        }
        /**
         * The Client Fully Qualified Domain Name (FQDN). Used in message ids
         * sent by endpoint.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: camel.apache.org
         * Group: common
         * 
         * @param clientFqdn the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder clientFqdn(String clientFqdn) {
            doSetProperty("clientFqdn", clientFqdn);
            return this;
        }
        /**
         * The algorithm used to compress EDI message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.as2.api.AS2CompressionAlgorithm&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param compressionAlgorithm the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder compressionAlgorithm(
                AS2CompressionAlgorithm compressionAlgorithm) {
            doSetProperty("compressionAlgorithm", compressionAlgorithm);
            return this;
        }
        /**
         * The algorithm used to compress EDI message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.as2.api.AS2CompressionAlgorithm&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param compressionAlgorithm the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder compressionAlgorithm(
                String compressionAlgorithm) {
            doSetProperty("compressionAlgorithm", compressionAlgorithm);
            return this;
        }
        /**
         * The key used to encrypt the EDI message.
         * 
         * The option is a: &lt;code&gt;java.security.PrivateKey&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param decryptingPrivateKey the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder decryptingPrivateKey(
                PrivateKey decryptingPrivateKey) {
            doSetProperty("decryptingPrivateKey", decryptingPrivateKey);
            return this;
        }
        /**
         * The key used to encrypt the EDI message.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.security.PrivateKey&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param decryptingPrivateKey the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder decryptingPrivateKey(
                String decryptingPrivateKey) {
            doSetProperty("decryptingPrivateKey", decryptingPrivateKey);
            return this;
        }
        /**
         * The value of the Disposition-Notification-To header. Assigning a
         * value to this parameter requests a message disposition notification
         * (MDN) for the AS2 message.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dispositionNotificationTo the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder dispositionNotificationTo(
                String dispositionNotificationTo) {
            doSetProperty("dispositionNotificationTo", dispositionNotificationTo);
            return this;
        }
        /**
         * The transfer encoding of EDI message.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param ediMessageTransferEncoding the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder ediMessageTransferEncoding(
                String ediMessageTransferEncoding) {
            doSetProperty("ediMessageTransferEncoding", ediMessageTransferEncoding);
            return this;
        }
        /**
         * The content type of EDI message. One of application/edifact,
         * application/edi-x12, application/edi-consent.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.http.entity.ContentType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param ediMessageType the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder ediMessageType(Object ediMessageType) {
            doSetProperty("ediMessageType", ediMessageType);
            return this;
        }
        /**
         * The content type of EDI message. One of application/edifact,
         * application/edi-x12, application/edi-consent.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.http.entity.ContentType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param ediMessageType the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder ediMessageType(String ediMessageType) {
            doSetProperty("ediMessageType", ediMessageType);
            return this;
        }
        /**
         * The algorithm used to encrypt EDI message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.as2.api.AS2EncryptionAlgorithm&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param encryptingAlgorithm the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder encryptingAlgorithm(
                AS2EncryptionAlgorithm encryptingAlgorithm) {
            doSetProperty("encryptingAlgorithm", encryptingAlgorithm);
            return this;
        }
        /**
         * The algorithm used to encrypt EDI message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.as2.api.AS2EncryptionAlgorithm&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param encryptingAlgorithm the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder encryptingAlgorithm(
                String encryptingAlgorithm) {
            doSetProperty("encryptingAlgorithm", encryptingAlgorithm);
            return this;
        }
        /**
         * The chain of certificates used to encrypt EDI message.
         * 
         * The option is a:
         * &lt;code&gt;java.security.cert.Certificate[]&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param encryptingCertificateChain the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder encryptingCertificateChain(
                Certificate[] encryptingCertificateChain) {
            doSetProperty("encryptingCertificateChain", encryptingCertificateChain);
            return this;
        }
        /**
         * The chain of certificates used to encrypt EDI message.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.security.cert.Certificate[]&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param encryptingCertificateChain the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder encryptingCertificateChain(
                String encryptingCertificateChain) {
            doSetProperty("encryptingCertificateChain", encryptingCertificateChain);
            return this;
        }
        /**
         * The value of the From header of AS2 message.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param from the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder from(String from) {
            doSetProperty("from", from);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param inBody the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder inBody(String inBody) {
            doSetProperty("inBody", inBody);
            return this;
        }
        /**
         * The template used to format MDN message.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param mdnMessageTemplate the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder mdnMessageTemplate(
                String mdnMessageTemplate) {
            doSetProperty("mdnMessageTemplate", mdnMessageTemplate);
            return this;
        }
        /**
         * The request URI of EDI message.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: /
         * Group: common
         * 
         * @param requestUri the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder requestUri(String requestUri) {
            doSetProperty("requestUri", requestUri);
            return this;
        }
        /**
         * The value included in the Server message header identifying the AS2
         * Server.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: Camel AS2 Server Endpoint
         * Group: common
         * 
         * @param server the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder server(String server) {
            doSetProperty("server", server);
            return this;
        }
        /**
         * The Server Fully Qualified Domain Name (FQDN). Used in message ids
         * sent by endpoint.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: camel.apache.org
         * Group: common
         * 
         * @param serverFqdn the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder serverFqdn(String serverFqdn) {
            doSetProperty("serverFqdn", serverFqdn);
            return this;
        }
        /**
         * The port number of server.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param serverPortNumber the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder serverPortNumber(
                Integer serverPortNumber) {
            doSetProperty("serverPortNumber", serverPortNumber);
            return this;
        }
        /**
         * The port number of server.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param serverPortNumber the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder serverPortNumber(
                String serverPortNumber) {
            doSetProperty("serverPortNumber", serverPortNumber);
            return this;
        }
        /**
         * The list of algorithms, in order of preference, requested to generate
         * a message integrity check (MIC) returned in message dispostion
         * notification (MDN).
         * 
         * The option is a: &lt;code&gt;java.lang.String[]&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param signedReceiptMicAlgorithms the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder signedReceiptMicAlgorithms(
                String[] signedReceiptMicAlgorithms) {
            doSetProperty("signedReceiptMicAlgorithms", signedReceiptMicAlgorithms);
            return this;
        }
        /**
         * The list of algorithms, in order of preference, requested to generate
         * a message integrity check (MIC) returned in message dispostion
         * notification (MDN).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.String[]&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param signedReceiptMicAlgorithms the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder signedReceiptMicAlgorithms(
                String signedReceiptMicAlgorithms) {
            doSetProperty("signedReceiptMicAlgorithms", signedReceiptMicAlgorithms);
            return this;
        }
        /**
         * The algorithm used to sign EDI message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.as2.api.AS2SignatureAlgorithm&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param signingAlgorithm the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder signingAlgorithm(
                AS2SignatureAlgorithm signingAlgorithm) {
            doSetProperty("signingAlgorithm", signingAlgorithm);
            return this;
        }
        /**
         * The algorithm used to sign EDI message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.as2.api.AS2SignatureAlgorithm&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param signingAlgorithm the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder signingAlgorithm(
                String signingAlgorithm) {
            doSetProperty("signingAlgorithm", signingAlgorithm);
            return this;
        }
        /**
         * The chain of certificates used to sign EDI message.
         * 
         * The option is a:
         * &lt;code&gt;java.security.cert.Certificate[]&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param signingCertificateChain the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder signingCertificateChain(
                Certificate[] signingCertificateChain) {
            doSetProperty("signingCertificateChain", signingCertificateChain);
            return this;
        }
        /**
         * The chain of certificates used to sign EDI message.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.security.cert.Certificate[]&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param signingCertificateChain the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder signingCertificateChain(
                String signingCertificateChain) {
            doSetProperty("signingCertificateChain", signingCertificateChain);
            return this;
        }
        /**
         * The key used to sign the EDI message.
         * 
         * The option is a: &lt;code&gt;java.security.PrivateKey&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param signingPrivateKey the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder signingPrivateKey(
                PrivateKey signingPrivateKey) {
            doSetProperty("signingPrivateKey", signingPrivateKey);
            return this;
        }
        /**
         * The key used to sign the EDI message.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.security.PrivateKey&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param signingPrivateKey the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder signingPrivateKey(
                String signingPrivateKey) {
            doSetProperty("signingPrivateKey", signingPrivateKey);
            return this;
        }
        /**
         * The value of Subject header of AS2 message.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param subject the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder subject(String subject) {
            doSetProperty("subject", subject);
            return this;
        }
        /**
         * The host name (IP or DNS name) of target host.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param targetHostname the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder targetHostname(String targetHostname) {
            doSetProperty("targetHostname", targetHostname);
            return this;
        }
        /**
         * The port number of target host. -1 indicates the scheme default port.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param targetPortNumber the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder targetPortNumber(
                Integer targetPortNumber) {
            doSetProperty("targetPortNumber", targetPortNumber);
            return this;
        }
        /**
         * The port number of target host. -1 indicates the scheme default port.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param targetPortNumber the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder targetPortNumber(
                String targetPortNumber) {
            doSetProperty("targetPortNumber", targetPortNumber);
            return this;
        }
        /**
         * The value included in the User-Agent message header identifying the
         * AS2 user agent.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: Camel AS2 Client Endpoint
         * Group: common
         * 
         * @param userAgent the value to set
         * @return the dsl builder
         */
        default AS2EndpointConsumerBuilder userAgent(String userAgent) {
            doSetProperty("userAgent", userAgent);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the AS2 component.
     */
    public interface AdvancedAS2EndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AS2EndpointConsumerBuilder basic() {
            return (AS2EndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedAS2EndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedAS2EndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedAS2EndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedAS2EndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedAS2EndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedAS2EndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the AS2 component.
     */
    public interface AS2EndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedAS2EndpointProducerBuilder advanced() {
            return (AdvancedAS2EndpointProducerBuilder) this;
        }
        /**
         * The value of the AS2From header of AS2 message.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param as2From the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder as2From(String as2From) {
            doSetProperty("as2From", as2From);
            return this;
        }
        /**
         * The structure of AS2 Message. One of: PLAIN - No encryption, no
         * signature, SIGNED - No encryption, signature, ENCRYPTED - Encryption,
         * no signature, ENCRYPTED_SIGNED - Encryption, signature.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.as2.api.AS2MessageStructure&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param as2MessageStructure the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder as2MessageStructure(
                AS2MessageStructure as2MessageStructure) {
            doSetProperty("as2MessageStructure", as2MessageStructure);
            return this;
        }
        /**
         * The structure of AS2 Message. One of: PLAIN - No encryption, no
         * signature, SIGNED - No encryption, signature, ENCRYPTED - Encryption,
         * no signature, ENCRYPTED_SIGNED - Encryption, signature.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.as2.api.AS2MessageStructure&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param as2MessageStructure the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder as2MessageStructure(
                String as2MessageStructure) {
            doSetProperty("as2MessageStructure", as2MessageStructure);
            return this;
        }
        /**
         * The value of the AS2To header of AS2 message.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param as2To the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder as2To(String as2To) {
            doSetProperty("as2To", as2To);
            return this;
        }
        /**
         * The version of the AS2 protocol.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: 1.1
         * Group: common
         * 
         * @param as2Version the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder as2Version(String as2Version) {
            doSetProperty("as2Version", as2Version);
            return this;
        }
        /**
         * The Client Fully Qualified Domain Name (FQDN). Used in message ids
         * sent by endpoint.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: camel.apache.org
         * Group: common
         * 
         * @param clientFqdn the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder clientFqdn(String clientFqdn) {
            doSetProperty("clientFqdn", clientFqdn);
            return this;
        }
        /**
         * The algorithm used to compress EDI message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.as2.api.AS2CompressionAlgorithm&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param compressionAlgorithm the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder compressionAlgorithm(
                AS2CompressionAlgorithm compressionAlgorithm) {
            doSetProperty("compressionAlgorithm", compressionAlgorithm);
            return this;
        }
        /**
         * The algorithm used to compress EDI message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.as2.api.AS2CompressionAlgorithm&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param compressionAlgorithm the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder compressionAlgorithm(
                String compressionAlgorithm) {
            doSetProperty("compressionAlgorithm", compressionAlgorithm);
            return this;
        }
        /**
         * The key used to encrypt the EDI message.
         * 
         * The option is a: &lt;code&gt;java.security.PrivateKey&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param decryptingPrivateKey the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder decryptingPrivateKey(
                PrivateKey decryptingPrivateKey) {
            doSetProperty("decryptingPrivateKey", decryptingPrivateKey);
            return this;
        }
        /**
         * The key used to encrypt the EDI message.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.security.PrivateKey&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param decryptingPrivateKey the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder decryptingPrivateKey(
                String decryptingPrivateKey) {
            doSetProperty("decryptingPrivateKey", decryptingPrivateKey);
            return this;
        }
        /**
         * The value of the Disposition-Notification-To header. Assigning a
         * value to this parameter requests a message disposition notification
         * (MDN) for the AS2 message.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dispositionNotificationTo the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder dispositionNotificationTo(
                String dispositionNotificationTo) {
            doSetProperty("dispositionNotificationTo", dispositionNotificationTo);
            return this;
        }
        /**
         * The transfer encoding of EDI message.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param ediMessageTransferEncoding the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder ediMessageTransferEncoding(
                String ediMessageTransferEncoding) {
            doSetProperty("ediMessageTransferEncoding", ediMessageTransferEncoding);
            return this;
        }
        /**
         * The content type of EDI message. One of application/edifact,
         * application/edi-x12, application/edi-consent.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.http.entity.ContentType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param ediMessageType the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder ediMessageType(Object ediMessageType) {
            doSetProperty("ediMessageType", ediMessageType);
            return this;
        }
        /**
         * The content type of EDI message. One of application/edifact,
         * application/edi-x12, application/edi-consent.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.http.entity.ContentType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param ediMessageType the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder ediMessageType(String ediMessageType) {
            doSetProperty("ediMessageType", ediMessageType);
            return this;
        }
        /**
         * The algorithm used to encrypt EDI message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.as2.api.AS2EncryptionAlgorithm&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param encryptingAlgorithm the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder encryptingAlgorithm(
                AS2EncryptionAlgorithm encryptingAlgorithm) {
            doSetProperty("encryptingAlgorithm", encryptingAlgorithm);
            return this;
        }
        /**
         * The algorithm used to encrypt EDI message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.as2.api.AS2EncryptionAlgorithm&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param encryptingAlgorithm the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder encryptingAlgorithm(
                String encryptingAlgorithm) {
            doSetProperty("encryptingAlgorithm", encryptingAlgorithm);
            return this;
        }
        /**
         * The chain of certificates used to encrypt EDI message.
         * 
         * The option is a:
         * &lt;code&gt;java.security.cert.Certificate[]&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param encryptingCertificateChain the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder encryptingCertificateChain(
                Certificate[] encryptingCertificateChain) {
            doSetProperty("encryptingCertificateChain", encryptingCertificateChain);
            return this;
        }
        /**
         * The chain of certificates used to encrypt EDI message.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.security.cert.Certificate[]&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param encryptingCertificateChain the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder encryptingCertificateChain(
                String encryptingCertificateChain) {
            doSetProperty("encryptingCertificateChain", encryptingCertificateChain);
            return this;
        }
        /**
         * The value of the From header of AS2 message.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param from the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder from(String from) {
            doSetProperty("from", from);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param inBody the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder inBody(String inBody) {
            doSetProperty("inBody", inBody);
            return this;
        }
        /**
         * The template used to format MDN message.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param mdnMessageTemplate the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder mdnMessageTemplate(
                String mdnMessageTemplate) {
            doSetProperty("mdnMessageTemplate", mdnMessageTemplate);
            return this;
        }
        /**
         * The request URI of EDI message.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: /
         * Group: common
         * 
         * @param requestUri the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder requestUri(String requestUri) {
            doSetProperty("requestUri", requestUri);
            return this;
        }
        /**
         * The value included in the Server message header identifying the AS2
         * Server.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: Camel AS2 Server Endpoint
         * Group: common
         * 
         * @param server the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder server(String server) {
            doSetProperty("server", server);
            return this;
        }
        /**
         * The Server Fully Qualified Domain Name (FQDN). Used in message ids
         * sent by endpoint.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: camel.apache.org
         * Group: common
         * 
         * @param serverFqdn the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder serverFqdn(String serverFqdn) {
            doSetProperty("serverFqdn", serverFqdn);
            return this;
        }
        /**
         * The port number of server.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param serverPortNumber the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder serverPortNumber(
                Integer serverPortNumber) {
            doSetProperty("serverPortNumber", serverPortNumber);
            return this;
        }
        /**
         * The port number of server.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param serverPortNumber the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder serverPortNumber(
                String serverPortNumber) {
            doSetProperty("serverPortNumber", serverPortNumber);
            return this;
        }
        /**
         * The list of algorithms, in order of preference, requested to generate
         * a message integrity check (MIC) returned in message dispostion
         * notification (MDN).
         * 
         * The option is a: &lt;code&gt;java.lang.String[]&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param signedReceiptMicAlgorithms the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder signedReceiptMicAlgorithms(
                String[] signedReceiptMicAlgorithms) {
            doSetProperty("signedReceiptMicAlgorithms", signedReceiptMicAlgorithms);
            return this;
        }
        /**
         * The list of algorithms, in order of preference, requested to generate
         * a message integrity check (MIC) returned in message dispostion
         * notification (MDN).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.String[]&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param signedReceiptMicAlgorithms the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder signedReceiptMicAlgorithms(
                String signedReceiptMicAlgorithms) {
            doSetProperty("signedReceiptMicAlgorithms", signedReceiptMicAlgorithms);
            return this;
        }
        /**
         * The algorithm used to sign EDI message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.as2.api.AS2SignatureAlgorithm&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param signingAlgorithm the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder signingAlgorithm(
                AS2SignatureAlgorithm signingAlgorithm) {
            doSetProperty("signingAlgorithm", signingAlgorithm);
            return this;
        }
        /**
         * The algorithm used to sign EDI message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.as2.api.AS2SignatureAlgorithm&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param signingAlgorithm the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder signingAlgorithm(
                String signingAlgorithm) {
            doSetProperty("signingAlgorithm", signingAlgorithm);
            return this;
        }
        /**
         * The chain of certificates used to sign EDI message.
         * 
         * The option is a:
         * &lt;code&gt;java.security.cert.Certificate[]&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param signingCertificateChain the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder signingCertificateChain(
                Certificate[] signingCertificateChain) {
            doSetProperty("signingCertificateChain", signingCertificateChain);
            return this;
        }
        /**
         * The chain of certificates used to sign EDI message.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.security.cert.Certificate[]&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param signingCertificateChain the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder signingCertificateChain(
                String signingCertificateChain) {
            doSetProperty("signingCertificateChain", signingCertificateChain);
            return this;
        }
        /**
         * The key used to sign the EDI message.
         * 
         * The option is a: &lt;code&gt;java.security.PrivateKey&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param signingPrivateKey the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder signingPrivateKey(
                PrivateKey signingPrivateKey) {
            doSetProperty("signingPrivateKey", signingPrivateKey);
            return this;
        }
        /**
         * The key used to sign the EDI message.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.security.PrivateKey&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param signingPrivateKey the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder signingPrivateKey(
                String signingPrivateKey) {
            doSetProperty("signingPrivateKey", signingPrivateKey);
            return this;
        }
        /**
         * The value of Subject header of AS2 message.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param subject the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder subject(String subject) {
            doSetProperty("subject", subject);
            return this;
        }
        /**
         * The host name (IP or DNS name) of target host.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param targetHostname the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder targetHostname(String targetHostname) {
            doSetProperty("targetHostname", targetHostname);
            return this;
        }
        /**
         * The port number of target host. -1 indicates the scheme default port.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param targetPortNumber the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder targetPortNumber(
                Integer targetPortNumber) {
            doSetProperty("targetPortNumber", targetPortNumber);
            return this;
        }
        /**
         * The port number of target host. -1 indicates the scheme default port.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param targetPortNumber the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder targetPortNumber(
                String targetPortNumber) {
            doSetProperty("targetPortNumber", targetPortNumber);
            return this;
        }
        /**
         * The value included in the User-Agent message header identifying the
         * AS2 user agent.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: Camel AS2 Client Endpoint
         * Group: common
         * 
         * @param userAgent the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder userAgent(String userAgent) {
            doSetProperty("userAgent", userAgent);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AS2EndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the AS2 component.
     */
    public interface AdvancedAS2EndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AS2EndpointProducerBuilder basic() {
            return (AS2EndpointProducerBuilder) this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedAS2EndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedAS2EndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the AS2 component.
     */
    public interface AS2EndpointBuilder
            extends
                AS2EndpointConsumerBuilder,
                AS2EndpointProducerBuilder {
        default AdvancedAS2EndpointBuilder advanced() {
            return (AdvancedAS2EndpointBuilder) this;
        }
        /**
         * The value of the AS2From header of AS2 message.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param as2From the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder as2From(String as2From) {
            doSetProperty("as2From", as2From);
            return this;
        }
        /**
         * The structure of AS2 Message. One of: PLAIN - No encryption, no
         * signature, SIGNED - No encryption, signature, ENCRYPTED - Encryption,
         * no signature, ENCRYPTED_SIGNED - Encryption, signature.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.as2.api.AS2MessageStructure&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param as2MessageStructure the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder as2MessageStructure(
                AS2MessageStructure as2MessageStructure) {
            doSetProperty("as2MessageStructure", as2MessageStructure);
            return this;
        }
        /**
         * The structure of AS2 Message. One of: PLAIN - No encryption, no
         * signature, SIGNED - No encryption, signature, ENCRYPTED - Encryption,
         * no signature, ENCRYPTED_SIGNED - Encryption, signature.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.as2.api.AS2MessageStructure&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param as2MessageStructure the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder as2MessageStructure(
                String as2MessageStructure) {
            doSetProperty("as2MessageStructure", as2MessageStructure);
            return this;
        }
        /**
         * The value of the AS2To header of AS2 message.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param as2To the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder as2To(String as2To) {
            doSetProperty("as2To", as2To);
            return this;
        }
        /**
         * The version of the AS2 protocol.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: 1.1
         * Group: common
         * 
         * @param as2Version the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder as2Version(String as2Version) {
            doSetProperty("as2Version", as2Version);
            return this;
        }
        /**
         * The Client Fully Qualified Domain Name (FQDN). Used in message ids
         * sent by endpoint.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: camel.apache.org
         * Group: common
         * 
         * @param clientFqdn the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder clientFqdn(String clientFqdn) {
            doSetProperty("clientFqdn", clientFqdn);
            return this;
        }
        /**
         * The algorithm used to compress EDI message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.as2.api.AS2CompressionAlgorithm&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param compressionAlgorithm the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder compressionAlgorithm(
                AS2CompressionAlgorithm compressionAlgorithm) {
            doSetProperty("compressionAlgorithm", compressionAlgorithm);
            return this;
        }
        /**
         * The algorithm used to compress EDI message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.as2.api.AS2CompressionAlgorithm&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param compressionAlgorithm the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder compressionAlgorithm(
                String compressionAlgorithm) {
            doSetProperty("compressionAlgorithm", compressionAlgorithm);
            return this;
        }
        /**
         * The key used to encrypt the EDI message.
         * 
         * The option is a: &lt;code&gt;java.security.PrivateKey&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param decryptingPrivateKey the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder decryptingPrivateKey(
                PrivateKey decryptingPrivateKey) {
            doSetProperty("decryptingPrivateKey", decryptingPrivateKey);
            return this;
        }
        /**
         * The key used to encrypt the EDI message.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.security.PrivateKey&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param decryptingPrivateKey the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder decryptingPrivateKey(
                String decryptingPrivateKey) {
            doSetProperty("decryptingPrivateKey", decryptingPrivateKey);
            return this;
        }
        /**
         * The value of the Disposition-Notification-To header. Assigning a
         * value to this parameter requests a message disposition notification
         * (MDN) for the AS2 message.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dispositionNotificationTo the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder dispositionNotificationTo(
                String dispositionNotificationTo) {
            doSetProperty("dispositionNotificationTo", dispositionNotificationTo);
            return this;
        }
        /**
         * The transfer encoding of EDI message.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param ediMessageTransferEncoding the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder ediMessageTransferEncoding(
                String ediMessageTransferEncoding) {
            doSetProperty("ediMessageTransferEncoding", ediMessageTransferEncoding);
            return this;
        }
        /**
         * The content type of EDI message. One of application/edifact,
         * application/edi-x12, application/edi-consent.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.http.entity.ContentType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param ediMessageType the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder ediMessageType(Object ediMessageType) {
            doSetProperty("ediMessageType", ediMessageType);
            return this;
        }
        /**
         * The content type of EDI message. One of application/edifact,
         * application/edi-x12, application/edi-consent.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.http.entity.ContentType&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param ediMessageType the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder ediMessageType(String ediMessageType) {
            doSetProperty("ediMessageType", ediMessageType);
            return this;
        }
        /**
         * The algorithm used to encrypt EDI message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.as2.api.AS2EncryptionAlgorithm&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param encryptingAlgorithm the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder encryptingAlgorithm(
                AS2EncryptionAlgorithm encryptingAlgorithm) {
            doSetProperty("encryptingAlgorithm", encryptingAlgorithm);
            return this;
        }
        /**
         * The algorithm used to encrypt EDI message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.as2.api.AS2EncryptionAlgorithm&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param encryptingAlgorithm the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder encryptingAlgorithm(
                String encryptingAlgorithm) {
            doSetProperty("encryptingAlgorithm", encryptingAlgorithm);
            return this;
        }
        /**
         * The chain of certificates used to encrypt EDI message.
         * 
         * The option is a:
         * &lt;code&gt;java.security.cert.Certificate[]&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param encryptingCertificateChain the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder encryptingCertificateChain(
                Certificate[] encryptingCertificateChain) {
            doSetProperty("encryptingCertificateChain", encryptingCertificateChain);
            return this;
        }
        /**
         * The chain of certificates used to encrypt EDI message.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.security.cert.Certificate[]&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param encryptingCertificateChain the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder encryptingCertificateChain(
                String encryptingCertificateChain) {
            doSetProperty("encryptingCertificateChain", encryptingCertificateChain);
            return this;
        }
        /**
         * The value of the From header of AS2 message.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param from the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder from(String from) {
            doSetProperty("from", from);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param inBody the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder inBody(String inBody) {
            doSetProperty("inBody", inBody);
            return this;
        }
        /**
         * The template used to format MDN message.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param mdnMessageTemplate the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder mdnMessageTemplate(String mdnMessageTemplate) {
            doSetProperty("mdnMessageTemplate", mdnMessageTemplate);
            return this;
        }
        /**
         * The request URI of EDI message.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: /
         * Group: common
         * 
         * @param requestUri the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder requestUri(String requestUri) {
            doSetProperty("requestUri", requestUri);
            return this;
        }
        /**
         * The value included in the Server message header identifying the AS2
         * Server.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: Camel AS2 Server Endpoint
         * Group: common
         * 
         * @param server the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder server(String server) {
            doSetProperty("server", server);
            return this;
        }
        /**
         * The Server Fully Qualified Domain Name (FQDN). Used in message ids
         * sent by endpoint.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: camel.apache.org
         * Group: common
         * 
         * @param serverFqdn the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder serverFqdn(String serverFqdn) {
            doSetProperty("serverFqdn", serverFqdn);
            return this;
        }
        /**
         * The port number of server.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param serverPortNumber the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder serverPortNumber(Integer serverPortNumber) {
            doSetProperty("serverPortNumber", serverPortNumber);
            return this;
        }
        /**
         * The port number of server.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param serverPortNumber the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder serverPortNumber(String serverPortNumber) {
            doSetProperty("serverPortNumber", serverPortNumber);
            return this;
        }
        /**
         * The list of algorithms, in order of preference, requested to generate
         * a message integrity check (MIC) returned in message dispostion
         * notification (MDN).
         * 
         * The option is a: &lt;code&gt;java.lang.String[]&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param signedReceiptMicAlgorithms the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder signedReceiptMicAlgorithms(
                String[] signedReceiptMicAlgorithms) {
            doSetProperty("signedReceiptMicAlgorithms", signedReceiptMicAlgorithms);
            return this;
        }
        /**
         * The list of algorithms, in order of preference, requested to generate
         * a message integrity check (MIC) returned in message dispostion
         * notification (MDN).
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.String[]&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param signedReceiptMicAlgorithms the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder signedReceiptMicAlgorithms(
                String signedReceiptMicAlgorithms) {
            doSetProperty("signedReceiptMicAlgorithms", signedReceiptMicAlgorithms);
            return this;
        }
        /**
         * The algorithm used to sign EDI message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.as2.api.AS2SignatureAlgorithm&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param signingAlgorithm the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder signingAlgorithm(
                AS2SignatureAlgorithm signingAlgorithm) {
            doSetProperty("signingAlgorithm", signingAlgorithm);
            return this;
        }
        /**
         * The algorithm used to sign EDI message.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.as2.api.AS2SignatureAlgorithm&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param signingAlgorithm the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder signingAlgorithm(String signingAlgorithm) {
            doSetProperty("signingAlgorithm", signingAlgorithm);
            return this;
        }
        /**
         * The chain of certificates used to sign EDI message.
         * 
         * The option is a:
         * &lt;code&gt;java.security.cert.Certificate[]&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param signingCertificateChain the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder signingCertificateChain(
                Certificate[] signingCertificateChain) {
            doSetProperty("signingCertificateChain", signingCertificateChain);
            return this;
        }
        /**
         * The chain of certificates used to sign EDI message.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.security.cert.Certificate[]&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param signingCertificateChain the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder signingCertificateChain(
                String signingCertificateChain) {
            doSetProperty("signingCertificateChain", signingCertificateChain);
            return this;
        }
        /**
         * The key used to sign the EDI message.
         * 
         * The option is a: &lt;code&gt;java.security.PrivateKey&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param signingPrivateKey the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder signingPrivateKey(
                PrivateKey signingPrivateKey) {
            doSetProperty("signingPrivateKey", signingPrivateKey);
            return this;
        }
        /**
         * The key used to sign the EDI message.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.security.PrivateKey&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param signingPrivateKey the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder signingPrivateKey(String signingPrivateKey) {
            doSetProperty("signingPrivateKey", signingPrivateKey);
            return this;
        }
        /**
         * The value of Subject header of AS2 message.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param subject the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder subject(String subject) {
            doSetProperty("subject", subject);
            return this;
        }
        /**
         * The host name (IP or DNS name) of target host.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param targetHostname the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder targetHostname(String targetHostname) {
            doSetProperty("targetHostname", targetHostname);
            return this;
        }
        /**
         * The port number of target host. -1 indicates the scheme default port.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param targetPortNumber the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder targetPortNumber(Integer targetPortNumber) {
            doSetProperty("targetPortNumber", targetPortNumber);
            return this;
        }
        /**
         * The port number of target host. -1 indicates the scheme default port.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param targetPortNumber the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder targetPortNumber(String targetPortNumber) {
            doSetProperty("targetPortNumber", targetPortNumber);
            return this;
        }
        /**
         * The value included in the User-Agent message header identifying the
         * AS2 user agent.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: Camel AS2 Client Endpoint
         * Group: common
         * 
         * @param userAgent the value to set
         * @return the dsl builder
         */
        default AS2EndpointBuilder userAgent(String userAgent) {
            doSetProperty("userAgent", userAgent);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the AS2 component.
     */
    public interface AdvancedAS2EndpointBuilder
            extends
                AdvancedAS2EndpointConsumerBuilder,
                AdvancedAS2EndpointProducerBuilder {
        default AS2EndpointBuilder basic() {
            return (AS2EndpointBuilder) this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedAS2EndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param synchronous the value to set
         * @return the dsl builder
         */
        default AdvancedAS2EndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.as2.api.AS2MessageStructure</code> enum.
     */
    enum AS2MessageStructure {
        PLAIN,
        SIGNED,
        ENCRYPTED,
        SIGNED_ENCRYPTED,
        PLAIN_COMPRESSED,
        SIGNED_COMPRESSED,
        ENCRYPTED_COMPRESSED,
        ENCRYPTED_COMPRESSED_SIGNED;
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.as2.api.AS2CompressionAlgorithm</code>
     * enum.
     */
    enum AS2CompressionAlgorithm {
        ZLIB;
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.as2.api.AS2EncryptionAlgorithm</code>
     * enum.
     */
    enum AS2EncryptionAlgorithm {
        AES128_CBC,
        AES192_CBC,
        AES256_CBC,
        AES128_CCM,
        AES192_CCM,
        AES256_CCM,
        AES128_GCM,
        AES192_GCM,
        AES256_GCM,
        CAMELLIA128_CBC,
        CAMELLIA192_CBC,
        CAMELLIA256_CBC,
        CAST5_CBC,
        DES_CBC,
        DES_EDE3_CBC,
        GOST28147_GCFB,
        IDEA_CBC,
        RC2_CBC,
        RC4,
        SEED_CBC;
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.as2.api.AS2SignatureAlgorithm</code>
     * enum.
     */
    enum AS2SignatureAlgorithm {
        SHA3_224WITHRSA,
        SHA3_256WITHRSA,
        SHA3_384withRSA,
        SHA3_512WITHRSA,
        MD5WITHRSA,
        SHA1WITHRSA,
        MD2WITHRSA,
        SHA224WITHRSA,
        SHA256WITHRSA,
        SHA384WITHRSA,
        SHA512WITHRSA,
        RIPEMD128WITHRSA,
        RIPEMD160WITHRSA,
        RIPEMD256WITHRSA,
        SHA224WITHDSA,
        SHA256WITHDSA,
        SHA384WITHDSA,
        SHA512WITHDSA,
        SHA3_224WITHDSA,
        SHA3_256WITHDSA,
        SHA3_384WITHDSA,
        SHA3_512WITHDSA,
        SHA1WITHDSA,
        SHA3_224WITHECDSA,
        SHA3_256WITHECDSA,
        SHA3_384WITHECDSA,
        SHA3_512WITHECDSA,
        SHA1WITHECDSA,
        SHA224WITHECDSA,
        SHA256WITHECDSA,
        SHA384WITHECDSA,
        SHA512WITHECDSA,
        SHA1WITHPLAIN_ECDSA,
        SHA224WITHPLAIN_ECDSA,
        SHA256WITHPLAIN_ECDSA,
        SHA384WITHPLAIN_ECDSA,
        SHA512WITHPLAIN_ECDSA,
        RIPEMD160WITHPLAIN_ECDSA,
        SHA1WITHRSAANDMGF1,
        SHA224WITHRSAANDMGF1,
        SHA256WITHRSAANDMGF1,
        SHA384WITHRSAANDMGF1,
        SHA512WITHRSAANDMGF1,
        SHA3_224WITHRSAANDMGF1,
        SHA3_256WITHRSAANDMGF1,
        SHA3_384WITHRSAANDMGF1,
        SHA3_512WITHRSAANDMGF1;
    }

    public interface AS2Builders {
        /**
         * AS2 (camel-as2)
         * Transfer data securely and reliably using the AS2 protocol (RFC4130).
         * 
         * Category: file
         * Since: 2.22
         * Maven coordinates: org.apache.camel:camel-as2
         * 
         * Syntax: <code>as2:apiName/methodName</code>
         * 
         * Path parameter: apiName (required)
         * What kind of operation to perform
         * There are 2 enums and the value can be one of: CLIENT, SERVER
         * 
         * Path parameter: methodName (required)
         * What sub operation to use for the selected operation
         * 
         * @param path apiName/methodName
         * @return the dsl builder
         */
        default AS2EndpointBuilder as2(String path) {
            return AS2EndpointBuilderFactory.endpointBuilder("as2", path);
        }
        /**
         * AS2 (camel-as2)
         * Transfer data securely and reliably using the AS2 protocol (RFC4130).
         * 
         * Category: file
         * Since: 2.22
         * Maven coordinates: org.apache.camel:camel-as2
         * 
         * Syntax: <code>as2:apiName/methodName</code>
         * 
         * Path parameter: apiName (required)
         * What kind of operation to perform
         * There are 2 enums and the value can be one of: CLIENT, SERVER
         * 
         * Path parameter: methodName (required)
         * What sub operation to use for the selected operation
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path apiName/methodName
         * @return the dsl builder
         */
        default AS2EndpointBuilder as2(String componentName, String path) {
            return AS2EndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static AS2EndpointBuilder endpointBuilder(String componentName, String path) {
        class AS2EndpointBuilderImpl extends AbstractEndpointBuilder implements AS2EndpointBuilder, AdvancedAS2EndpointBuilder {
            public AS2EndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new AS2EndpointBuilderImpl(path);
    }
}