/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jsonb;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.service.ServiceSupport;

@Dataformat(value="json-jsonb")
@Metadata(includeProperties="unmarshalTypeName,objectMapper,prettyPrint,binaryStrategy,encoding,propertyOrder,propertyamingStrategy,skipNull")
public class JsonbDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName,
CamelContextAware {
    private CamelContext camelContext;
    private Jsonb objectMapper;
    private String unmarshalTypeName;
    private Type unmarshalType;
    private boolean prettyPrint;
    private String encoding = "UTF-8";
    private String binaryStrategy = "BASE_64";
    private String propertyOrder = "ANY";
    private String propertyamingStrategy = "IDENTITY";
    private boolean skipNull = true;

    public JsonbDataFormat() {
        this((Type)((Object)Object.class));
    }

    public JsonbDataFormat(Type unmarshalType) {
        this(null, unmarshalType);
    }

    public JsonbDataFormat(Jsonb mapper, Type unmarshalType) {
        this.objectMapper = mapper;
        this.unmarshalType = unmarshalType;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public String getDataFormatName() {
        return "json-jsonb";
    }

    public Jsonb getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(Jsonb objectMapper) {
        this.objectMapper = objectMapper;
    }

    public Type getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Type unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    public String getUnmarshalTypeName() {
        return this.unmarshalTypeName;
    }

    public void setUnmarshalTypeName(String unmarshalTypeName) {
        this.unmarshalTypeName = unmarshalTypeName;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isSkipNull() {
        return this.skipNull;
    }

    public void setSkipNull(boolean skipNull) {
        this.skipNull = skipNull;
    }

    public String getBinaryStrategy() {
        return this.binaryStrategy;
    }

    public void setBinaryStrategy(String binaryStrategy) {
        this.binaryStrategy = binaryStrategy;
    }

    public String getPropertyOrder() {
        return this.propertyOrder;
    }

    public void setPropertyOrder(String propertyOrder) {
        this.propertyOrder = propertyOrder;
    }

    public String getPropertyamingStrategy() {
        return this.propertyamingStrategy;
    }

    public void setPropertyamingStrategy(String propertyamingStrategy) {
        this.propertyamingStrategy = propertyamingStrategy;
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) {
        this.objectMapper.toJson(graph, stream);
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        Type expectedType = this.unmarshalType;
        String type = (String)exchange.getIn().getHeader("CamelJsonbUnmarshallType", String.class);
        if (type != null) {
            expectedType = exchange.getContext().getClassResolver().resolveMandatoryClass(type);
        }
        return this.objectMapper.fromJson(stream, expectedType);
    }

    protected void doInit() {
        if (this.unmarshalTypeName != null && (this.unmarshalType == null || this.unmarshalType == Object.class)) {
            this.unmarshalType = this.camelContext.getClassResolver().resolveClass(this.unmarshalTypeName);
        }
    }

    protected void doStart() {
        if (this.objectMapper == null) {
            this.objectMapper = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withFormatting(Boolean.valueOf(this.prettyPrint)).withNullValues(Boolean.valueOf(!this.skipNull)).withBinaryDataStrategy(this.binaryStrategy).withPropertyOrderStrategy(this.propertyOrder).withPropertyNamingStrategy(this.propertyamingStrategy).withEncoding(this.encoding));
        }
    }

    protected void doStop() {
    }
}

